/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include <sbkpython.h>
#include <shiboken.h>
#include <algorithm>
#include <signature.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
#include "pyside2_qtprintsupport_python.h"



// Extra includes

// Current module's type array.
PyTypeObject **SbkPySide2_QtPrintSupportTypes = nullptr;
// Current module's PyObject pointer.
PyObject *SbkPySide2_QtPrintSupportModuleObject = nullptr;
// Current module's converter array.
SbkConverter **SbkPySide2_QtPrintSupportTypeConverters = nullptr;
void cleanTypesAttributes(void) {
    if (PY_VERSION_HEX >= 0x03000000 && PY_VERSION_HEX < 0x03060000)
        return; // PYSIDE-953: testbinding crashes in Python 3.5 when hasattr touches types!
    for (int i = 0, imax = SBK_QtPrintSupport_IDX_COUNT; i < imax; i++) {
        PyObject *pyType = reinterpret_cast<PyObject *>(SbkPySide2_QtPrintSupportTypes[i]);
        Shiboken::AutoDecRef attrName(Py_BuildValue("s", "staticMetaObject"));
        if (pyType && PyObject_HasAttr(pyType, attrName))
            PyObject_SetAttr(pyType, attrName, Py_None);
    }
}
// Global functions ------------------------------------------------------------

static PyMethodDef QtPrintSupport_methods[] = {
    {0} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------
void init_QPrinterInfo(PyObject *module);
void init_QPrintEngine(PyObject *module);
void init_QPrinter(PyObject *module);
void init_QPrintPreviewWidget(PyObject *module);
void init_QPrintPreviewDialog(PyObject *module);
void init_QPageSetupDialog(PyObject *module);
void init_QAbstractPrintDialog(PyObject *module);
void init_QPrintDialog(PyObject *module);

// Required modules' type and converter arrays.
PyTypeObject **SbkPySide2_QtWidgetsTypes;
SbkConverter **SbkPySide2_QtWidgetsTypeConverters;
PyTypeObject **SbkPySide2_QtGuiTypes;
SbkConverter **SbkPySide2_QtGuiTypeConverters;
PyTypeObject **SbkPySide2_QtCoreTypes;
SbkConverter **SbkPySide2_QtCoreTypeConverters;

// Module initialization ------------------------------------------------------------
// Container Type converters.

// C++ to Python conversion for type 'const QList<QWidget* > &'.
static PyObject *_constQList_QWidgetPTR_REF_CppToPython__constQList_QWidgetPTR_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QWidget* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QWidget* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QWidget* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QWidgetPTR_REF_PythonToCpp__constQList_QWidgetPTR_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QWidget* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QWidget* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QWidgetPTR_REF_PythonToCpp__constQList_QWidgetPTR_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX], pyIn))
        return _constQList_QWidgetPTR_REF_PythonToCpp__constQList_QWidgetPTR_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QAction* >'.
static PyObject *_QList_QActionPTR__CppToPython__QList_QActionPTR_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QAction* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QAction* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QAction* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QActionPTR__PythonToCpp__QList_QActionPTR_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QAction* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QAction* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QActionPTR__PythonToCpp__QList_QActionPTR__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtWidgetsTypes[SBK_QACTION_IDX], pyIn))
        return _QList_QActionPTR__PythonToCpp__QList_QActionPTR_;
    return {};
}

// C++ to Python conversion for type 'QList<int >'.
static PyObject *_QList_int__CppToPython__QList_int_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<int > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<int >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        int cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_int__PythonToCpp__QList_int_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<int > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        int cppItem;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_int__PythonToCpp__QList_int__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyIn))
        return _QList_int__PythonToCpp__QList_int_;
    return {};
}

// C++ to Python conversion for type 'QList<QPrinterInfo >'.
static PyObject *_QList_QPrinterInfo__CppToPython__QList_QPrinterInfo_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QPrinterInfo > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QPrinterInfo >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QPrinterInfo cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTERINFO_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QPrinterInfo__PythonToCpp__QList_QPrinterInfo_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QPrinterInfo > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QPrinterInfo cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTERINFO_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QPrinterInfo__PythonToCpp__QList_QPrinterInfo__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTERINFO_IDX]), pyIn))
        return _QList_QPrinterInfo__PythonToCpp__QList_QPrinterInfo_;
    return {};
}

// C++ to Python conversion for type 'QList<QPrinter::ColorMode >'.
static PyObject *_QList_QPrinter_ColorMode__CppToPython__QList_QPrinter_ColorMode_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QPrinter::ColorMode > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QPrinter::ColorMode >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QPrinter::ColorMode cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_COLORMODE_IDX])->converter, &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QPrinter_ColorMode__PythonToCpp__QList_QPrinter_ColorMode_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QPrinter::ColorMode > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QPrinter::ColorMode cppItem{QPrinter::GrayScale};
        Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_COLORMODE_IDX])->converter, pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QPrinter_ColorMode__PythonToCpp__QList_QPrinter_ColorMode__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_COLORMODE_IDX])->converter, pyIn))
        return _QList_QPrinter_ColorMode__PythonToCpp__QList_QPrinter_ColorMode_;
    return {};
}

// C++ to Python conversion for type 'QList<QPrinter::DuplexMode >'.
static PyObject *_QList_QPrinter_DuplexMode__CppToPython__QList_QPrinter_DuplexMode_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QPrinter::DuplexMode > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QPrinter::DuplexMode >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QPrinter::DuplexMode cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_DUPLEXMODE_IDX])->converter, &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QPrinter_DuplexMode__PythonToCpp__QList_QPrinter_DuplexMode_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QPrinter::DuplexMode > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QPrinter::DuplexMode cppItem{QPrinter::DuplexNone};
        Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_DUPLEXMODE_IDX])->converter, pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QPrinter_DuplexMode__PythonToCpp__QList_QPrinter_DuplexMode__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_DUPLEXMODE_IDX])->converter, pyIn))
        return _QList_QPrinter_DuplexMode__PythonToCpp__QList_QPrinter_DuplexMode_;
    return {};
}

// C++ to Python conversion for type 'QList<QPageSize >'.
static PyObject *_QList_QPageSize__CppToPython__QList_QPageSize_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QPageSize > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QPageSize >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QPageSize cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QPageSize__PythonToCpp__QList_QPageSize_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QPageSize > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QPageSize cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QPageSize__PythonToCpp__QList_QPageSize__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX]), pyIn))
        return _QList_QPageSize__PythonToCpp__QList_QPageSize_;
    return {};
}

// C++ to Python conversion for type 'QList<QPagedPaintDevice::PageSize >'.
static PyObject *_QList_QPagedPaintDevice_PageSize__CppToPython__QList_QPagedPaintDevice_PageSize_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QPagedPaintDevice::PageSize > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QPagedPaintDevice::PageSize >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QPagedPaintDevice::PageSize cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX])->converter, &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QPagedPaintDevice_PageSize__PythonToCpp__QList_QPagedPaintDevice_PageSize_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QPagedPaintDevice::PageSize > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QPagedPaintDevice::PageSize cppItem{QPagedPaintDevice::A4};
        Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX])->converter, pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QPagedPaintDevice_PageSize__PythonToCpp__QList_QPagedPaintDevice_PageSize__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX])->converter, pyIn))
        return _QList_QPagedPaintDevice_PageSize__PythonToCpp__QList_QPagedPaintDevice_PageSize_;
    return {};
}

// C++ to Python conversion for type 'QPair<QString,QSizeF >'.
static PyObject *_QPair_QString_QSizeF__CppToPython__QPair_QString_QSizeF_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QPair<QString,QSizeF > *>(const_cast<void *>(cppIn));
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (return-qpair)]
    PyObject *pyOut = PyTuple_New(2);
    PyTuple_SET_ITEM(pyOut, 0, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppInRef.first));
    PyTuple_SET_ITEM(pyOut, 1, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), &cppInRef.second));
    return pyOut;
    // END of custom code block [file: ../glue/qtcore.cpp (return-qpair)]
    // ========================================================================

}
static void _QPair_QString_QSizeF__PythonToCpp__QPair_QString_QSizeF_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QPair<QString,QSizeF > *>(cppOut);
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-qpair-pysequence)]
    Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], PySequence_Fast_GET_ITEM(pyIn, 0), &(cppOutRef.first));
    Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), PySequence_Fast_GET_ITEM(pyIn, 1), &(cppOutRef.second));
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-qpair-pysequence)]
    // ========================================================================

}
static PythonToCppFunc is__QPair_QString_QSizeF__PythonToCpp__QPair_QString_QSizeF__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertiblePairTypes(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], false, *PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX])->converter, false, pyIn))
        return _QPair_QString_QSizeF__PythonToCpp__QPair_QString_QSizeF_;
    return {};
}

// C++ to Python conversion for type 'QList<QPair< QString,QSizeF > >'.
static PyObject *_QList_QPair_QString_QSizeF___CppToPython__QList_QPair_QString_QSizeF__(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QPair< QString,QSizeF > > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QPair< QString,QSizeF > >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QPair<QString,QSizeF > cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QPAIR_QSTRING_QSIZEF_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QPair_QString_QSizeF___PythonToCpp__QList_QPair_QString_QSizeF__(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QPair< QString,QSizeF > > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QPair<QString,QSizeF > cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QPAIR_QSTRING_QSIZEF_IDX], pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QPair_QString_QSizeF___PythonToCpp__QList_QPair_QString_QSizeF___Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QPAIR_QSTRING_QSIZEF_IDX], pyIn))
        return _QList_QPair_QString_QSizeF___PythonToCpp__QList_QPair_QString_QSizeF__;
    return {};
}

// C++ to Python conversion for type 'QList<QVariant >'.
static PyObject *_QList_QVariant__CppToPython__QList_QVariant_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QVariant >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QVariant cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QVariant__PythonToCpp__QList_QVariant_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QVariant > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QVariant cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QVariant__PythonToCpp__QList_QVariant__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyIn))
        return _QList_QVariant__PythonToCpp__QList_QVariant_;
    return {};
}

// C++ to Python conversion for type 'QList<QString >'.
static PyObject *_QList_QString__CppToPython__QList_QString_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QString > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QString >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QString cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QString__PythonToCpp__QList_QString_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QString > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QString cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QString__PythonToCpp__QList_QString__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyIn))
        return _QList_QString__PythonToCpp__QList_QString_;
    return {};
}

// C++ to Python conversion for type 'QMap<QString,QVariant >'.
static PyObject *_QMap_QString_QVariant__CppToPython__QMap_QString_QVariant_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QMap<QString,QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppmap_to_pymap_conversion - START
    PyObject *pyOut = PyDict_New();
    for (::QMap<QString,QVariant >::const_iterator it = cppInRef.begin(), end = cppInRef.end(); it != end; ++it) {
        ::QString key = it.key();
        ::QVariant value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - cppmap_to_pymap_conversion - END

}
static void _QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QMap<QString,QVariant > *>(cppOut);
    // TEMPLATE - pydict_to_cppmap_conversion - START
    PyObject *key;
    PyObject *value;
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QString cppKey;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], key, &(cppKey));
        ::QVariant cppValue;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - pydict_to_cppmap_conversion - END

}
static PythonToCppFunc is__QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleDictTypes(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], false, SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], false, pyIn))
        return _QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant_;
    return {};
}


#ifdef IS_PY3K
static struct PyModuleDef moduledef = {
    /* m_base     */ PyModuleDef_HEAD_INIT,
    /* m_name     */ "QtPrintSupport",
    /* m_doc      */ nullptr,
    /* m_size     */ -1,
    /* m_methods  */ QtPrintSupport_methods,
    /* m_reload   */ nullptr,
    /* m_traverse */ nullptr,
    /* m_clear    */ nullptr,
    /* m_free     */ nullptr
};

#endif

// The signatures string for the global functions.
// Multiple signatures have their index "n:" in front.
static const char *QtPrintSupport_SignatureStrings[] = {
    nullptr}; // Sentinel

SBK_MODULE_INIT_FUNCTION_BEGIN(QtPrintSupport)
    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.QtWidgets"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_QtWidgetsTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_QtWidgetsTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.QtGui"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_QtGuiTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_QtGuiTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.QtCore"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_QtCoreTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_QtCoreTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    // Create an array of wrapper types for the current module.
    static PyTypeObject *cppApi[SBK_QtPrintSupport_IDX_COUNT];
    SbkPySide2_QtPrintSupportTypes = cppApi;

    // Create an array of primitive type converters for the current module.
    static SbkConverter *sbkConverters[SBK_QtPrintSupport_CONVERTERS_IDX_COUNT];
    SbkPySide2_QtPrintSupportTypeConverters = sbkConverters;

#ifdef IS_PY3K
    PyObject *module = Shiboken::Module::create("QtPrintSupport", &moduledef);
#else
    PyObject *module = Shiboken::Module::create("QtPrintSupport", QtPrintSupport_methods);
#endif

    // Make module available from global scope
    SbkPySide2_QtPrintSupportModuleObject = module;

    // Initialize classes in the type system
    init_QPrinterInfo(module);
    init_QPrintEngine(module);
    init_QPrinter(module);
    init_QPrintPreviewWidget(module);
    init_QPrintPreviewDialog(module);
    init_QPageSetupDialog(module);
    init_QAbstractPrintDialog(module);
    init_QPrintDialog(module);

    // Register converter for type 'const QList<QWidget*>&'.
    SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_QWIDGETPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QWidgetPTR_REF_CppToPython__constQList_QWidgetPTR_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_QWIDGETPTR_IDX], "const QList<QWidget*>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_QWIDGETPTR_IDX], "QList<QWidget*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_QWIDGETPTR_IDX],
        _constQList_QWidgetPTR_REF_PythonToCpp__constQList_QWidgetPTR_REF,
        is__constQList_QWidgetPTR_REF_PythonToCpp__constQList_QWidgetPTR_REF_Convertible);

    // Register converter for type 'QList<QAction*>'.
    SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_QACTIONPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QActionPTR__CppToPython__QList_QActionPTR_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_QACTIONPTR_IDX], "QList<QAction*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_QACTIONPTR_IDX],
        _QList_QActionPTR__PythonToCpp__QList_QActionPTR_,
        is__QList_QActionPTR__PythonToCpp__QList_QActionPTR__Convertible);

    // Register converter for type 'QList<int>'.
    SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_INT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_int__CppToPython__QList_int_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_INT_IDX], "QList<int>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_INT_IDX],
        _QList_int__PythonToCpp__QList_int_,
        is__QList_int__PythonToCpp__QList_int__Convertible);

    // Register converter for type 'QList<QPrinterInfo>'.
    SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_QPRINTERINFO_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QPrinterInfo__CppToPython__QList_QPrinterInfo_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_QPRINTERINFO_IDX], "QList<QPrinterInfo>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_QPRINTERINFO_IDX],
        _QList_QPrinterInfo__PythonToCpp__QList_QPrinterInfo_,
        is__QList_QPrinterInfo__PythonToCpp__QList_QPrinterInfo__Convertible);

    // Register converter for type 'QList<QPrinter::ColorMode>'.
    SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_QPRINTER_COLORMODE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QPrinter_ColorMode__CppToPython__QList_QPrinter_ColorMode_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_QPRINTER_COLORMODE_IDX], "QList<QPrinter::ColorMode>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_QPRINTER_COLORMODE_IDX],
        _QList_QPrinter_ColorMode__PythonToCpp__QList_QPrinter_ColorMode_,
        is__QList_QPrinter_ColorMode__PythonToCpp__QList_QPrinter_ColorMode__Convertible);

    // Register converter for type 'QList<QPrinter::DuplexMode>'.
    SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_QPRINTER_DUPLEXMODE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QPrinter_DuplexMode__CppToPython__QList_QPrinter_DuplexMode_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_QPRINTER_DUPLEXMODE_IDX], "QList<QPrinter::DuplexMode>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_QPRINTER_DUPLEXMODE_IDX],
        _QList_QPrinter_DuplexMode__PythonToCpp__QList_QPrinter_DuplexMode_,
        is__QList_QPrinter_DuplexMode__PythonToCpp__QList_QPrinter_DuplexMode__Convertible);

    // Register converter for type 'QList<QPageSize>'.
    SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_QPAGESIZE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QPageSize__CppToPython__QList_QPageSize_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_QPAGESIZE_IDX], "QList<QPageSize>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_QPAGESIZE_IDX],
        _QList_QPageSize__PythonToCpp__QList_QPageSize_,
        is__QList_QPageSize__PythonToCpp__QList_QPageSize__Convertible);

    // Register converter for type 'QList<QPagedPaintDevice::PageSize>'.
    SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_QPAGEDPAINTDEVICE_PAGESIZE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QPagedPaintDevice_PageSize__CppToPython__QList_QPagedPaintDevice_PageSize_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_QPAGEDPAINTDEVICE_PAGESIZE_IDX], "QList<QPagedPaintDevice::PageSize>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        _QList_QPagedPaintDevice_PageSize__PythonToCpp__QList_QPagedPaintDevice_PageSize_,
        is__QList_QPagedPaintDevice_PageSize__PythonToCpp__QList_QPagedPaintDevice_PageSize__Convertible);

    // Register converter for type 'QPair<QString,QSizeF>'.
    SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QPAIR_QSTRING_QSIZEF_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QPair_QString_QSizeF__CppToPython__QPair_QString_QSizeF_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QPAIR_QSTRING_QSIZEF_IDX], "QPair<QString,QSizeF>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QPAIR_QSTRING_QSIZEF_IDX],
        _QPair_QString_QSizeF__PythonToCpp__QPair_QString_QSizeF_,
        is__QPair_QString_QSizeF__PythonToCpp__QPair_QString_QSizeF__Convertible);

    // Register converter for type 'QList<QPair<QString,QSizeF>>'.
    SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_QPAIR_QSTRING_QSIZEF_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QPair_QString_QSizeF___CppToPython__QList_QPair_QString_QSizeF__);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_QPAIR_QSTRING_QSIZEF_IDX], "QList<QPair<QString,QSizeF>>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_QPAIR_QSTRING_QSIZEF_IDX],
        _QList_QPair_QString_QSizeF___PythonToCpp__QList_QPair_QString_QSizeF__,
        is__QList_QPair_QString_QSizeF___PythonToCpp__QList_QPair_QString_QSizeF___Convertible);

    // Register converter for type 'QList<QVariant>'.
    SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QVariant__CppToPython__QList_QVariant_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_QVARIANT_IDX], "QList<QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_QVARIANT_IDX],
        _QList_QVariant__PythonToCpp__QList_QVariant_,
        is__QList_QVariant__PythonToCpp__QList_QVariant__Convertible);

    // Register converter for type 'QList<QString>'.
    SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_QSTRING_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QString__CppToPython__QList_QString_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_QSTRING_IDX], "QList<QString>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_QSTRING_IDX],
        _QList_QString__PythonToCpp__QList_QString_,
        is__QList_QString__PythonToCpp__QList_QString__Convertible);

    // Register converter for type 'QMap<QString,QVariant>'.
    SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QMAP_QSTRING_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QMap_QString_QVariant__CppToPython__QMap_QString_QVariant_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QMAP_QSTRING_QVARIANT_IDX], "QMap<QString,QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QMAP_QSTRING_QVARIANT_IDX],
        _QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant_,
        is__QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant__Convertible);

    // Register primitive types converters.

    Shiboken::Module::registerTypes(module, SbkPySide2_QtPrintSupportTypes);
    Shiboken::Module::registerTypeConverters(module, SbkPySide2_QtPrintSupportTypeConverters);

    if (PyErr_Occurred()) {
        PyErr_Print();
        Py_FatalError("can't initialize module QtPrintSupport");
    }
    PySide::registerCleanupFunction(cleanTypesAttributes);

    FinishSignatureInitialization(module, QtPrintSupport_SignatureStrings);

SBK_MODULE_INIT_FUNCTION_END
