/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtprintsupport_python.h"

// main header
#include "qprinter_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QPrinterWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QPrinterWrapper::QPrinterWrapper(::QPrinter::PrinterMode mode) : QPrinter(mode)
{
    resetPyMethodCache();
    // ... middle
}

QPrinterWrapper::QPrinterWrapper(const ::QPrinterInfo & printer, ::QPrinter::PrinterMode mode) : QPrinter(printer, mode)
{
    resetPyMethodCache();
    // ... middle
}

int QPrinterWrapper::devType() const
{
    if (m_PyMethodCache[0])
        return this->::QPrinter::devType();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "devType";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QPrinter::devType();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPrinter.devType", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QPrinterWrapper::initPainter(::QPainter * painter) const
{
    if (m_PyMethodCache[1]) {
        return this->::QPaintDevice::initPainter(painter);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "initPainter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QPaintDevice::initPainter(painter);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), painter)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

int QPrinterWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    if (m_PyMethodCache[2])
        return this->::QPrinter::metric(arg__1);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "metric";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QPrinter::metric(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_PAINTDEVICEMETRIC_IDX])->converter, &arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPrinter.metric", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QPrinterWrapper::newPage()
{
    if (m_PyMethodCache[3])
        return this->::QPrinter::newPage();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "newPage";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QPrinter::newPage();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPrinter.newPage", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QPaintEngine * QPrinterWrapper::paintEngine() const
{
    if (m_PyMethodCache[4])
        return this->::QPrinter::paintEngine();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "paintEngine";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QPrinter::paintEngine();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPrinter.paintEngine", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QPaintEngine >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QPaintEngine *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QPaintDevice * QPrinterWrapper::redirected(::QPoint * offset) const
{
    if (m_PyMethodCache[5])
        return this->::QPaintDevice::redirected(offset);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "redirected";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QPaintDevice::redirected(offset);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), offset)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPrinter.redirected", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QPaintDevice >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QPaintDevice *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QPrinterWrapper::setMargins(const ::QPagedPaintDevice::Margins & m)
{
    if (m_PyMethodCache[6]) {
        return this->::QPrinter::setMargins(m);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setMargins";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QPrinter::setMargins(m);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_MARGINS_IDX]), &m)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QPrinterWrapper::setPageSize(::QPagedPaintDevice::PageSize arg__1)
{
    if (m_PyMethodCache[7]) {
        return this->::QPrinter::setPageSize(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setPageSize";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QPrinter::setPageSize(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX])->converter, &arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QPrinterWrapper::setPageSizeMM(const ::QSizeF & size)
{
    if (m_PyMethodCache[8]) {
        return this->::QPrinter::setPageSizeMM(size);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setPageSizeMM";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QPrinter::setPageSizeMM(size);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), &size)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QPainter * QPrinterWrapper::sharedPainter() const
{
    if (m_PyMethodCache[9])
        return this->::QPaintDevice::sharedPainter();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "sharedPainter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QPaintDevice::sharedPainter();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPrinter.sharedPainter", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QPainter >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QPainter *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

QPrinterWrapper::~QPrinterWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QPrinter_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QPrinter >()))
        return -1;

    ::QPrinterWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPrinter_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:QPrinter", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QPrinter::QPrinter(QPrinter::PrinterMode)
    // 1: QPrinter::QPrinter(QPrinterInfo,QPrinter::PrinterMode)
    if (numArgs == 0) {
        overloadId = 0; // QPrinter(QPrinter::PrinterMode)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTERINFO_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // QPrinter(QPrinterInfo,QPrinter::PrinterMode)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PRINTERMODE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 1; // QPrinter(QPrinterInfo,QPrinter::PrinterMode)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PRINTERMODE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // QPrinter(QPrinter::PrinterMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPrinter_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QPrinter(QPrinter::PrinterMode mode)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[0]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QPrinter_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PRINTERMODE_IDX])->converter, (pyArgs[0]))))
                            goto Sbk_QPrinter_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPrinter_Init_TypeError;
                }
            }
            ::QPrinter::PrinterMode cppArg0 = QPrinter::PrinterMode::ScreenResolution;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QPrinter(QPrinter::PrinterMode)
                cptr = new ::QPrinterWrapper(cppArg0);
            }
            break;
        }
        case 1: // QPrinter(const QPrinterInfo & printer, QPrinter::PrinterMode mode)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[1]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QPrinter_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PRINTERMODE_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QPrinter_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPrinter_Init_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QPrinterInfo cppArg0_local;
            ::QPrinterInfo *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTERINFO_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QPrinter::PrinterMode cppArg1 = QPrinter::PrinterMode::ScreenResolution;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QPrinter(QPrinterInfo,QPrinter::PrinterMode)
                cptr = new ::QPrinterWrapper(*cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QPrinter >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QPrinter_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QPrinter_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QPrinterFunc_abort(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.abort";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // abort()
            bool cppResult = cppSelf->abort();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterFunc_actualNumCopies(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.actualNumCopies";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // actualNumCopies()const
            int cppResult = const_cast<const ::QPrinter *>(cppSelf)->actualNumCopies();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterFunc_collateCopies(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.collateCopies";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // collateCopies()const
            bool cppResult = const_cast<const ::QPrinter *>(cppSelf)->collateCopies();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterFunc_colorMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.colorMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // colorMode()const
            QPrinter::ColorMode cppResult = const_cast<const ::QPrinter *>(cppSelf)->colorMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_COLORMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterFunc_copyCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.copyCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // copyCount()const
            int cppResult = const_cast<const ::QPrinter *>(cppSelf)->copyCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterFunc_creator(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.creator";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // creator()const
            QString cppResult = const_cast<const ::QPrinter *>(cppSelf)->creator();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterFunc_devType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.devType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // devType()const
            int cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QPrinter *>(cppSelf)->::QPrinter::devType()
                : const_cast<const ::QPrinter *>(cppSelf)->devType();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterFunc_docName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.docName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // docName()const
            QString cppResult = const_cast<const ::QPrinter *>(cppSelf)->docName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterFunc_doubleSidedPrinting(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.doubleSidedPrinting";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // doubleSidedPrinting()const
            bool cppResult = const_cast<const ::QPrinter *>(cppSelf)->doubleSidedPrinting();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterFunc_duplex(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.duplex";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // duplex()const
            QPrinter::DuplexMode cppResult = const_cast<const ::QPrinter *>(cppSelf)->duplex();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_DUPLEXMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterFunc_fontEmbeddingEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.fontEmbeddingEnabled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fontEmbeddingEnabled()const
            bool cppResult = const_cast<const ::QPrinter *>(cppSelf)->fontEmbeddingEnabled();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterFunc_fromPage(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.fromPage";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fromPage()const
            int cppResult = const_cast<const ::QPrinter *>(cppSelf)->fromPage();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterFunc_fullPage(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.fullPage";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fullPage()const
            bool cppResult = const_cast<const ::QPrinter *>(cppSelf)->fullPage();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterFunc_getPageMargins(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.getPageMargins";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPrinter::getPageMargins(qreal*,qreal*,qreal*,qreal*,QPrinter::Unit)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_UNIT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // getPageMargins(qreal*,qreal*,qreal*,qreal*,QPrinter::Unit)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPrinterFunc_getPageMargins_TypeError;

    // Call function/method
    {
        ::QPrinter::Unit cppArg0{QPrinter::Millimeter};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // getPageMargins(qreal*,qreal*,qreal*,qreal*,QPrinter::Unit)const
            // Begin code injection
            // TEMPLATE - fix_number*,number*,number*,number*,args - START
            qreal a, b, c, d;
            cppSelf->::QPrinter::getPageMargins(&a, &b, &c, &d, cppArg0);
            // TEMPLATE - tuple_abcd_same_type - START
            pyResult = PyTuple_New(4);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &a));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &b));
            PyTuple_SET_ITEM(pyResult, 2, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &c));
            PyTuple_SET_ITEM(pyResult, 3, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &d));
            // TEMPLATE - tuple_abcd_same_type - END
            // TEMPLATE - fix_number*,number*,number*,number*,args - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPrinterFunc_getPageMargins_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPrinterFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QPrinter *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterFunc_metric(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.metric";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPaintDevice::metric(QPaintDevice::PaintDeviceMetric)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_PAINTDEVICEMETRIC_IDX])->converter, (pyArg)))) {
        overloadId = 0; // metric(QPaintDevice::PaintDeviceMetric)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPrinterFunc_metric_TypeError;

    // Call function/method
    {
        ::QPaintDevice::PaintDeviceMetric cppArg0 = static_cast< ::QPaintDevice::PaintDeviceMetric>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // metric(QPaintDevice::PaintDeviceMetric)const
            int cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QPrinter *>(cppSelf)->::QPrinter::metric(cppArg0)
                : const_cast<const ::QPrinter *>(cppSelf)->metric(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPrinterFunc_metric_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPrinterFunc_newPage(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.newPage";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // newPage()
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QPrinter::newPage()
                : cppSelf->newPage();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterFunc_numCopies(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.numCopies";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // numCopies()const
            int cppResult = const_cast<const ::QPrinter *>(cppSelf)->numCopies();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterFunc_orientation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.orientation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // orientation()const
            QPrinter::Orientation cppResult = const_cast<const ::QPrinter *>(cppSelf)->orientation();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_ORIENTATION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterFunc_outputFileName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.outputFileName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // outputFileName()const
            QString cppResult = const_cast<const ::QPrinter *>(cppSelf)->outputFileName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterFunc_outputFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.outputFormat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // outputFormat()const
            QPrinter::OutputFormat cppResult = const_cast<const ::QPrinter *>(cppSelf)->outputFormat();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_OUTPUTFORMAT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterFunc_pageOrder(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.pageOrder";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pageOrder()const
            QPrinter::PageOrder cppResult = const_cast<const ::QPrinter *>(cppSelf)->pageOrder();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PAGEORDER_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterFunc_pageRect(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.pageRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "pageRect", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QPrinter::pageRect()const
    // 1: QPrinter::pageRect(QPrinter::Unit)const
    if (numArgs == 0) {
        overloadId = 0; // pageRect()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_UNIT_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // pageRect(QPrinter::Unit)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPrinterFunc_pageRect_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // pageRect() const
        {

            if (!PyErr_Occurred()) {
                // pageRect()const
                QRect cppResult = const_cast<const ::QPrinter *>(cppSelf)->pageRect();
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QPrinter.pageRect() const is deprecated", 1);
            break;
        }
        case 1: // pageRect(QPrinter::Unit arg__1) const
        {
            ::QPrinter::Unit cppArg0{QPrinter::Millimeter};
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // pageRect(QPrinter::Unit)const
                QRectF cppResult = const_cast<const ::QPrinter *>(cppSelf)->pageRect(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPrinterFunc_pageRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPrinterFunc_pageSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.pageSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pageSize()const
            QPagedPaintDevice::PageSize cppResult = const_cast<const ::QPrinter *>(cppSelf)->pageSize();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterFunc_paintEngine(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.paintEngine";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // paintEngine()const
            QPaintEngine * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QPrinter *>(cppSelf)->::QPrinter::paintEngine()
                : const_cast<const ::QPrinter *>(cppSelf)->paintEngine();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterFunc_paperName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.paperName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // paperName()const
            QString cppResult = const_cast<const ::QPrinter *>(cppSelf)->paperName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterFunc_paperRect(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.paperRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "paperRect", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QPrinter::paperRect()const
    // 1: QPrinter::paperRect(QPrinter::Unit)const
    if (numArgs == 0) {
        overloadId = 0; // paperRect()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_UNIT_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // paperRect(QPrinter::Unit)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPrinterFunc_paperRect_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // paperRect() const
        {

            if (!PyErr_Occurred()) {
                // paperRect()const
                QRect cppResult = const_cast<const ::QPrinter *>(cppSelf)->paperRect();
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QPrinter.paperRect() const is deprecated", 1);
            break;
        }
        case 1: // paperRect(QPrinter::Unit arg__1) const
        {
            ::QPrinter::Unit cppArg0{QPrinter::Millimeter};
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // paperRect(QPrinter::Unit)const
                QRectF cppResult = const_cast<const ::QPrinter *>(cppSelf)->paperRect(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPrinterFunc_paperRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPrinterFunc_paperSize(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.paperSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "paperSize", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QPrinter::paperSize()const
    // 1: QPrinter::paperSize(QPrinter::Unit)const
    if (numArgs == 0) {
        overloadId = 0; // paperSize()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_UNIT_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // paperSize(QPrinter::Unit)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPrinterFunc_paperSize_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // paperSize() const
        {

            if (!PyErr_Occurred()) {
                // paperSize()const
                QPagedPaintDevice::PageSize cppResult = const_cast<const ::QPrinter *>(cppSelf)->paperSize();
                pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX])->converter, &cppResult);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QPrinter.paperSize() const is deprecated", 1);
            break;
        }
        case 1: // paperSize(QPrinter::Unit unit) const
        {
            ::QPrinter::Unit cppArg0{QPrinter::Millimeter};
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // paperSize(QPrinter::Unit)const
                QSizeF cppResult = const_cast<const ::QPrinter *>(cppSelf)->paperSize(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), &cppResult);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QPrinter.paperSize(QPrinter::Unit unit) const is deprecated", 1);
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPrinterFunc_paperSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPrinterFunc_paperSource(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.paperSource";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // paperSource()const
            QPrinter::PaperSource cppResult = const_cast<const ::QPrinter *>(cppSelf)->paperSource();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PAPERSOURCE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterFunc_pdfVersion(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.pdfVersion";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pdfVersion()const
            QPagedPaintDevice::PdfVersion cppResult = const_cast<const ::QPrinter *>(cppSelf)->pdfVersion();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PDFVERSION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterFunc_printEngine(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.printEngine";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // printEngine()const
            QPrintEngine * cppResult = const_cast<const ::QPrinter *>(cppSelf)->printEngine();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterFunc_printProgram(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.printProgram";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // printProgram()const
            QString cppResult = const_cast<const ::QPrinter *>(cppSelf)->printProgram();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterFunc_printRange(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.printRange";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // printRange()const
            QPrinter::PrintRange cppResult = const_cast<const ::QPrinter *>(cppSelf)->printRange();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PRINTRANGE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterFunc_printerName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.printerName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // printerName()const
            QString cppResult = const_cast<const ::QPrinter *>(cppSelf)->printerName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterFunc_printerState(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.printerState";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // printerState()const
            QPrinter::PrinterState cppResult = const_cast<const ::QPrinter *>(cppSelf)->printerState();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PRINTERSTATE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterFunc_resolution(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.resolution";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // resolution()const
            int cppResult = const_cast<const ::QPrinter *>(cppSelf)->resolution();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterFunc_setCollateCopies(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.setCollateCopies";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPrinter::setCollateCopies(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setCollateCopies(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPrinterFunc_setCollateCopies_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCollateCopies(bool)
            cppSelf->setCollateCopies(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPrinterFunc_setCollateCopies_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPrinterFunc_setColorMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.setColorMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPrinter::setColorMode(QPrinter::ColorMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_COLORMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setColorMode(QPrinter::ColorMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPrinterFunc_setColorMode_TypeError;

    // Call function/method
    {
        ::QPrinter::ColorMode cppArg0{QPrinter::GrayScale};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setColorMode(QPrinter::ColorMode)
            cppSelf->setColorMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPrinterFunc_setColorMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPrinterFunc_setCopyCount(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.setCopyCount";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPrinter::setCopyCount(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setCopyCount(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPrinterFunc_setCopyCount_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCopyCount(int)
            cppSelf->setCopyCount(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPrinterFunc_setCopyCount_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPrinterFunc_setCreator(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.setCreator";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPrinter::setCreator(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setCreator(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPrinterFunc_setCreator_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCreator(QString)
            cppSelf->setCreator(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPrinterFunc_setCreator_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPrinterFunc_setDocName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.setDocName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPrinter::setDocName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setDocName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPrinterFunc_setDocName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDocName(QString)
            cppSelf->setDocName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPrinterFunc_setDocName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPrinterFunc_setDoubleSidedPrinting(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.setDoubleSidedPrinting";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPrinter::setDoubleSidedPrinting(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setDoubleSidedPrinting(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPrinterFunc_setDoubleSidedPrinting_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDoubleSidedPrinting(bool)
            cppSelf->setDoubleSidedPrinting(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPrinterFunc_setDoubleSidedPrinting_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPrinterFunc_setDuplex(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.setDuplex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPrinter::setDuplex(QPrinter::DuplexMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_DUPLEXMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setDuplex(QPrinter::DuplexMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPrinterFunc_setDuplex_TypeError;

    // Call function/method
    {
        ::QPrinter::DuplexMode cppArg0{QPrinter::DuplexNone};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDuplex(QPrinter::DuplexMode)
            cppSelf->setDuplex(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPrinterFunc_setDuplex_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPrinterFunc_setEngines(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.setEngines";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setEngines", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QPrinter::setEngines(QPrintEngine*,QPaintEngine*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX]), (pyArgs[1])))) {
        overloadId = 0; // setEngines(QPrintEngine*,QPaintEngine*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPrinterFunc_setEngines_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QPrintEngine *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QPaintEngine *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setEngines(QPrintEngine*,QPaintEngine*)
            cppSelf->setEngines(cppArg0, cppArg1);
            Shiboken::Object::setParent(self, pyArgs[0]);
            Shiboken::Object::setParent(self, pyArgs[1]);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPrinterFunc_setEngines_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPrinterFunc_setFontEmbeddingEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.setFontEmbeddingEnabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPrinter::setFontEmbeddingEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setFontEmbeddingEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPrinterFunc_setFontEmbeddingEnabled_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFontEmbeddingEnabled(bool)
            cppSelf->setFontEmbeddingEnabled(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPrinterFunc_setFontEmbeddingEnabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPrinterFunc_setFromTo(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.setFromTo";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setFromTo", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QPrinter::setFromTo(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // setFromTo(int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPrinterFunc_setFromTo_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setFromTo(int,int)
            cppSelf->setFromTo(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPrinterFunc_setFromTo_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPrinterFunc_setFullPage(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.setFullPage";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPrinter::setFullPage(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setFullPage(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPrinterFunc_setFullPage_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFullPage(bool)
            cppSelf->setFullPage(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPrinterFunc_setFullPage_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPrinterFunc_setMargins(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.setMargins";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPagedPaintDevice::setMargins(QPagedPaintDevice::Margins)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_MARGINS_IDX]), (pyArg)))) {
        overloadId = 0; // setMargins(QPagedPaintDevice::Margins)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPrinterFunc_setMargins_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPagedPaintDevice::Margins cppArg0_local;
        ::QPagedPaintDevice::Margins *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_MARGINS_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setMargins(QPagedPaintDevice::Margins)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QPrinter::setMargins(*cppArg0)
                : cppSelf->setMargins(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPrinterFunc_setMargins_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPrinterFunc_setNumCopies(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.setNumCopies";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPrinter::setNumCopies(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setNumCopies(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPrinterFunc_setNumCopies_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setNumCopies(int)
            cppSelf->setNumCopies(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPrinterFunc_setNumCopies_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPrinterFunc_setOrientation(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.setOrientation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPrinter::setOrientation(QPrinter::Orientation)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_ORIENTATION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setOrientation(QPrinter::Orientation)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPrinterFunc_setOrientation_TypeError;

    // Call function/method
    {
        ::QPrinter::Orientation cppArg0{QPrinter::Portrait};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setOrientation(QPrinter::Orientation)
            cppSelf->setOrientation(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPrinterFunc_setOrientation_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPrinterFunc_setOutputFileName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.setOutputFileName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPrinter::setOutputFileName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setOutputFileName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPrinterFunc_setOutputFileName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setOutputFileName(QString)
            cppSelf->setOutputFileName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPrinterFunc_setOutputFileName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPrinterFunc_setOutputFormat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.setOutputFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPrinter::setOutputFormat(QPrinter::OutputFormat)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_OUTPUTFORMAT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setOutputFormat(QPrinter::OutputFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPrinterFunc_setOutputFormat_TypeError;

    // Call function/method
    {
        ::QPrinter::OutputFormat cppArg0{QPrinter::NativeFormat};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setOutputFormat(QPrinter::OutputFormat)
            cppSelf->setOutputFormat(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPrinterFunc_setOutputFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPrinterFunc_setPageMargins(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.setPageMargins";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3 || numArgs == 4)
        goto Sbk_QPrinterFunc_setPageMargins_TypeError;

    if (!PyArg_UnpackTuple(args, "setPageMargins", 1, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QPrinter::setPageMargins(qreal,qreal,qreal,qreal,QPrinter::Unit)
    // 1: QPagedPaintDevice::setPageMargins(QMarginsF)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), (pyArgs[0])))) {
        overloadId = 1; // setPageMargins(QMarginsF)
    } else if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_UNIT_IDX])->converter, (pyArgs[4])))) {
        overloadId = 0; // setPageMargins(qreal,qreal,qreal,qreal,QPrinter::Unit)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPrinterFunc_setPageMargins_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setPageMargins(qreal left, qreal top, qreal right, qreal bottom, QPrinter::Unit unit)
        {
            qreal cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            qreal cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            qreal cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            ::QPrinter::Unit cppArg4{QPrinter::Millimeter};
            pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // setPageMargins(qreal,qreal,qreal,qreal,QPrinter::Unit)
                cppSelf->setPageMargins(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
                pyResult = Py_None;
                Py_INCREF(Py_None);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QPrinter.setPageMargins(qreal left, qreal top, qreal right, qreal bottom, QPrinter::Unit unit) is deprecated", 1);
            break;
        }
        case 1: // setPageMargins(const QMarginsF & margins)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QMarginsF cppArg0_local;
            ::QMarginsF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // setPageMargins(QMarginsF)
                bool cppResult = reinterpret_cast<QPagedPaintDevice *>(cppSelf)->setPageMargins(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPrinterFunc_setPageMargins_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPrinterFunc_setPageOrder(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.setPageOrder";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPrinter::setPageOrder(QPrinter::PageOrder)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PAGEORDER_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setPageOrder(QPrinter::PageOrder)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPrinterFunc_setPageOrder_TypeError;

    // Call function/method
    {
        ::QPrinter::PageOrder cppArg0{QPrinter::FirstPageFirst};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPageOrder(QPrinter::PageOrder)
            cppSelf->setPageOrder(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPrinterFunc_setPageOrder_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPrinterFunc_setPageSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.setPageSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPagedPaintDevice::setPageSize(QPagedPaintDevice::PageSize)
    // 1: QPagedPaintDevice::setPageSize(QPageSize)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX]), (pyArg)))) {
        overloadId = 1; // setPageSize(QPageSize)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setPageSize(QPagedPaintDevice::PageSize)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPrinterFunc_setPageSize_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setPageSize(QPagedPaintDevice::PageSize arg__1)
        {
            ::QPagedPaintDevice::PageSize cppArg0{QPagedPaintDevice::A4};
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // setPageSize(QPagedPaintDevice::PageSize)
                Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                    ? cppSelf->::QPrinter::setPageSize(cppArg0)
                    : cppSelf->setPageSize(cppArg0);
                pyResult = Py_None;
                Py_INCREF(Py_None);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QPrinter.setPageSize(QPagedPaintDevice::PageSize arg__1) is deprecated", 1);
            break;
        }
        case 1: // setPageSize(QPageSize arg__1)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QPageSize cppArg0;
            pythonToCpp(pyArg, &cppArg0);
            SBK_UNUSED(cppArg0)

            if (!PyErr_Occurred()) {
                // setPageSize(QPageSize)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtprintsupport.cpp (setpagesize)]
                bool out = cppSelf->setPageSize(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &out);
                // END of custom code block [file: ../glue/qtprintsupport.cpp (setpagesize)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPrinterFunc_setPageSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPrinterFunc_setPageSizeMM(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.setPageSizeMM";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPagedPaintDevice::setPageSizeMM(QSizeF)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), (pyArg)))) {
        overloadId = 0; // setPageSizeMM(QSizeF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPrinterFunc_setPageSizeMM_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSizeF cppArg0_local;
        ::QSizeF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setPageSizeMM(QSizeF)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QPrinter::setPageSizeMM(*cppArg0)
                : cppSelf->setPageSizeMM(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPrinterFunc_setPageSizeMM_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPrinterFunc_setPaperName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.setPaperName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPrinter::setPaperName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setPaperName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPrinterFunc_setPaperName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPaperName(QString)
            cppSelf->setPaperName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPrinterFunc_setPaperName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPrinterFunc_setPaperSize(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.setPaperSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setPaperSize", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QPrinter::setPaperSize(QPagedPaintDevice::PageSize)
    // 1: QPrinter::setPaperSize(QSizeF,QPrinter::Unit)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_UNIT_IDX])->converter, (pyArgs[1])))) {
        overloadId = 1; // setPaperSize(QSizeF,QPrinter::Unit)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // setPaperSize(QPagedPaintDevice::PageSize)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPrinterFunc_setPaperSize_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setPaperSize(QPagedPaintDevice::PageSize arg__1)
        {
            ::QPagedPaintDevice::PageSize cppArg0{QPagedPaintDevice::A4};
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // setPaperSize(QPagedPaintDevice::PageSize)
                cppSelf->setPaperSize(cppArg0);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QPrinter.setPaperSize(QPagedPaintDevice::PageSize arg__1) is deprecated", 1);
            break;
        }
        case 1: // setPaperSize(const QSizeF & paperSize, QPrinter::Unit unit)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QSizeF cppArg0_local;
            ::QSizeF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QPrinter::Unit cppArg1{QPrinter::Millimeter};
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setPaperSize(QSizeF,QPrinter::Unit)
                cppSelf->setPaperSize(*cppArg0, cppArg1);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QPrinter.setPaperSize(const QSizeF & paperSize, QPrinter::Unit unit) is deprecated", 1);
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPrinterFunc_setPaperSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPrinterFunc_setPaperSource(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.setPaperSource";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPrinter::setPaperSource(QPrinter::PaperSource)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PAPERSOURCE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setPaperSource(QPrinter::PaperSource)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPrinterFunc_setPaperSource_TypeError;

    // Call function/method
    {
        ::QPrinter::PaperSource cppArg0{QPrinter::Upper};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPaperSource(QPrinter::PaperSource)
            cppSelf->setPaperSource(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPrinterFunc_setPaperSource_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPrinterFunc_setPdfVersion(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.setPdfVersion";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPrinter::setPdfVersion(QPagedPaintDevice::PdfVersion)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PDFVERSION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setPdfVersion(QPagedPaintDevice::PdfVersion)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPrinterFunc_setPdfVersion_TypeError;

    // Call function/method
    {
        ::QPagedPaintDevice::PdfVersion cppArg0{QPagedPaintDevice::PdfVersion_1_4};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPdfVersion(QPagedPaintDevice::PdfVersion)
            cppSelf->setPdfVersion(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPrinterFunc_setPdfVersion_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPrinterFunc_setPrintProgram(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.setPrintProgram";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPrinter::setPrintProgram(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setPrintProgram(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPrinterFunc_setPrintProgram_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPrintProgram(QString)
            cppSelf->setPrintProgram(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPrinterFunc_setPrintProgram_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPrinterFunc_setPrintRange(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.setPrintRange";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPrinter::setPrintRange(QPrinter::PrintRange)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PRINTRANGE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setPrintRange(QPrinter::PrintRange)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPrinterFunc_setPrintRange_TypeError;

    // Call function/method
    {
        ::QPrinter::PrintRange cppArg0{QPrinter::AllPages};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPrintRange(QPrinter::PrintRange)
            cppSelf->setPrintRange(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPrinterFunc_setPrintRange_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPrinterFunc_setPrinterName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.setPrinterName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPrinter::setPrinterName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setPrinterName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPrinterFunc_setPrinterName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPrinterName(QString)
            cppSelf->setPrinterName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPrinterFunc_setPrinterName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPrinterFunc_setResolution(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.setResolution";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPrinter::setResolution(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setResolution(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPrinterFunc_setResolution_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setResolution(int)
            cppSelf->setResolution(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPrinterFunc_setResolution_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPrinterFunc_setWinPageSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.setWinPageSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPrinter::setWinPageSize(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setWinPageSize(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPrinterFunc_setWinPageSize_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setWinPageSize(int)
            cppSelf->setWinPageSize(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPrinterFunc_setWinPageSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPrinterFunc_supportedResolutions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.supportedResolutions";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedResolutions()const
            QList<int > cppResult = const_cast<const ::QPrinter *>(cppSelf)->supportedResolutions();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtPrintSupportTypeConverters[SBK_QTPRINTSUPPORT_QLIST_INT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterFunc_supportsMultipleCopies(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.supportsMultipleCopies";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportsMultipleCopies()const
            bool cppResult = const_cast<const ::QPrinter *>(cppSelf)->supportsMultipleCopies();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterFunc_toPage(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.toPage";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toPage()const
            int cppResult = const_cast<const ::QPrinter *>(cppSelf)->toPage();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrinterFunc_winPageSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrinter.winPageSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // winPageSize()const
            int cppResult = const_cast<const ::QPrinter *>(cppSelf)->winPageSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QPrinter_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QPrinter_methods[] = {
    {"abort", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_abort), METH_NOARGS},
    {"actualNumCopies", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_actualNumCopies), METH_NOARGS},
    {"collateCopies", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_collateCopies), METH_NOARGS},
    {"colorMode", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_colorMode), METH_NOARGS},
    {"copyCount", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_copyCount), METH_NOARGS},
    {"creator", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_creator), METH_NOARGS},
    {"devType", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_devType), METH_NOARGS},
    {"docName", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_docName), METH_NOARGS},
    {"doubleSidedPrinting", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_doubleSidedPrinting), METH_NOARGS},
    {"duplex", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_duplex), METH_NOARGS},
    {"fontEmbeddingEnabled", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_fontEmbeddingEnabled), METH_NOARGS},
    {"fromPage", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_fromPage), METH_NOARGS},
    {"fullPage", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_fullPage), METH_NOARGS},
    {"getPageMargins", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_getPageMargins), METH_O},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_isValid), METH_NOARGS},
    {"metric", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_metric), METH_O},
    {"newPage", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_newPage), METH_NOARGS},
    {"numCopies", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_numCopies), METH_NOARGS},
    {"orientation", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_orientation), METH_NOARGS},
    {"outputFileName", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_outputFileName), METH_NOARGS},
    {"outputFormat", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_outputFormat), METH_NOARGS},
    {"pageOrder", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_pageOrder), METH_NOARGS},
    {"pageRect", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_pageRect), METH_VARARGS},
    {"pageSize", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_pageSize), METH_NOARGS},
    {"paintEngine", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_paintEngine), METH_NOARGS},
    {"paperName", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_paperName), METH_NOARGS},
    {"paperRect", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_paperRect), METH_VARARGS},
    {"paperSize", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_paperSize), METH_VARARGS},
    {"paperSource", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_paperSource), METH_NOARGS},
    {"pdfVersion", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_pdfVersion), METH_NOARGS},
    {"printEngine", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_printEngine), METH_NOARGS},
    {"printProgram", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_printProgram), METH_NOARGS},
    {"printRange", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_printRange), METH_NOARGS},
    {"printerName", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_printerName), METH_NOARGS},
    {"printerState", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_printerState), METH_NOARGS},
    {"resolution", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_resolution), METH_NOARGS},
    {"setCollateCopies", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_setCollateCopies), METH_O},
    {"setColorMode", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_setColorMode), METH_O},
    {"setCopyCount", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_setCopyCount), METH_O},
    {"setCreator", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_setCreator), METH_O},
    {"setDocName", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_setDocName), METH_O},
    {"setDoubleSidedPrinting", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_setDoubleSidedPrinting), METH_O},
    {"setDuplex", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_setDuplex), METH_O},
    {"setEngines", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_setEngines), METH_VARARGS},
    {"setFontEmbeddingEnabled", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_setFontEmbeddingEnabled), METH_O},
    {"setFromTo", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_setFromTo), METH_VARARGS},
    {"setFullPage", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_setFullPage), METH_O},
    {"setMargins", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_setMargins), METH_O},
    {"setNumCopies", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_setNumCopies), METH_O},
    {"setOrientation", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_setOrientation), METH_O},
    {"setOutputFileName", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_setOutputFileName), METH_O},
    {"setOutputFormat", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_setOutputFormat), METH_O},
    {"setPageMargins", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_setPageMargins), METH_VARARGS},
    {"setPageOrder", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_setPageOrder), METH_O},
    {"setPageSize", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_setPageSize), METH_O},
    {"setPageSizeMM", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_setPageSizeMM), METH_O},
    {"setPaperName", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_setPaperName), METH_O},
    {"setPaperSize", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_setPaperSize), METH_VARARGS},
    {"setPaperSource", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_setPaperSource), METH_O},
    {"setPdfVersion", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_setPdfVersion), METH_O},
    {"setPrintProgram", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_setPrintProgram), METH_O},
    {"setPrintRange", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_setPrintRange), METH_O},
    {"setPrinterName", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_setPrinterName), METH_O},
    {"setResolution", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_setResolution), METH_O},
    {"setWinPageSize", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_setWinPageSize), METH_O},
    {"supportedResolutions", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_supportedResolutions), METH_NOARGS},
    {"supportsMultipleCopies", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_supportsMultipleCopies), METH_NOARGS},
    {"toPage", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_toPage), METH_NOARGS},
    {"winPageSize", reinterpret_cast<PyCFunction>(Sbk_QPrinterFunc_winPageSize), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QPrinter_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QPrinter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QPrinterWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QPrinter_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QPrinter_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QPrinter_Type = nullptr;
static SbkObjectType *Sbk_QPrinter_TypeF(void)
{
    return _Sbk_QPrinter_Type;
}

static PyType_Slot Sbk_QPrinter_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QPrinter_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QPrinter_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QPrinter_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QPrinter_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QPrinter_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QPrinter_spec = {
    "2:PySide2.QtPrintSupport.QPrinter",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QPrinter_slots
};

} //extern "C"

static void *Sbk_QPrinter_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QPaintDevice >()))
        return dynamic_cast< ::QPrinter *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QPrinter_PrinterMode_PythonToCpp_QPrinter_PrinterMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPrinter::PrinterMode *>(cppOut) =
        static_cast<::QPrinter::PrinterMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QPrinter_PrinterMode_PythonToCpp_QPrinter_PrinterMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PRINTERMODE_IDX]))
        return QPrinter_PrinterMode_PythonToCpp_QPrinter_PrinterMode;
    return {};
}
static PyObject *QPrinter_PrinterMode_CppToPython_QPrinter_PrinterMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QPrinter::PrinterMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PRINTERMODE_IDX], castCppIn);

}

static void QPrinter_Orientation_PythonToCpp_QPrinter_Orientation(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPrinter::Orientation *>(cppOut) =
        static_cast<::QPrinter::Orientation>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QPrinter_Orientation_PythonToCpp_QPrinter_Orientation_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_ORIENTATION_IDX]))
        return QPrinter_Orientation_PythonToCpp_QPrinter_Orientation;
    return {};
}
static PyObject *QPrinter_Orientation_CppToPython_QPrinter_Orientation(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QPrinter::Orientation *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_ORIENTATION_IDX], castCppIn);

}

static void QPrinter_PageOrder_PythonToCpp_QPrinter_PageOrder(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPrinter::PageOrder *>(cppOut) =
        static_cast<::QPrinter::PageOrder>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QPrinter_PageOrder_PythonToCpp_QPrinter_PageOrder_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PAGEORDER_IDX]))
        return QPrinter_PageOrder_PythonToCpp_QPrinter_PageOrder;
    return {};
}
static PyObject *QPrinter_PageOrder_CppToPython_QPrinter_PageOrder(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QPrinter::PageOrder *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PAGEORDER_IDX], castCppIn);

}

static void QPrinter_ColorMode_PythonToCpp_QPrinter_ColorMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPrinter::ColorMode *>(cppOut) =
        static_cast<::QPrinter::ColorMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QPrinter_ColorMode_PythonToCpp_QPrinter_ColorMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_COLORMODE_IDX]))
        return QPrinter_ColorMode_PythonToCpp_QPrinter_ColorMode;
    return {};
}
static PyObject *QPrinter_ColorMode_CppToPython_QPrinter_ColorMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QPrinter::ColorMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_COLORMODE_IDX], castCppIn);

}

static void QPrinter_PaperSource_PythonToCpp_QPrinter_PaperSource(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPrinter::PaperSource *>(cppOut) =
        static_cast<::QPrinter::PaperSource>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QPrinter_PaperSource_PythonToCpp_QPrinter_PaperSource_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PAPERSOURCE_IDX]))
        return QPrinter_PaperSource_PythonToCpp_QPrinter_PaperSource;
    return {};
}
static PyObject *QPrinter_PaperSource_CppToPython_QPrinter_PaperSource(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QPrinter::PaperSource *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PAPERSOURCE_IDX], castCppIn);

}

static void QPrinter_PrinterState_PythonToCpp_QPrinter_PrinterState(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPrinter::PrinterState *>(cppOut) =
        static_cast<::QPrinter::PrinterState>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QPrinter_PrinterState_PythonToCpp_QPrinter_PrinterState_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PRINTERSTATE_IDX]))
        return QPrinter_PrinterState_PythonToCpp_QPrinter_PrinterState;
    return {};
}
static PyObject *QPrinter_PrinterState_CppToPython_QPrinter_PrinterState(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QPrinter::PrinterState *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PRINTERSTATE_IDX], castCppIn);

}

static void QPrinter_OutputFormat_PythonToCpp_QPrinter_OutputFormat(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPrinter::OutputFormat *>(cppOut) =
        static_cast<::QPrinter::OutputFormat>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QPrinter_OutputFormat_PythonToCpp_QPrinter_OutputFormat_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_OUTPUTFORMAT_IDX]))
        return QPrinter_OutputFormat_PythonToCpp_QPrinter_OutputFormat;
    return {};
}
static PyObject *QPrinter_OutputFormat_CppToPython_QPrinter_OutputFormat(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QPrinter::OutputFormat *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_OUTPUTFORMAT_IDX], castCppIn);

}

static void QPrinter_PrintRange_PythonToCpp_QPrinter_PrintRange(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPrinter::PrintRange *>(cppOut) =
        static_cast<::QPrinter::PrintRange>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QPrinter_PrintRange_PythonToCpp_QPrinter_PrintRange_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PRINTRANGE_IDX]))
        return QPrinter_PrintRange_PythonToCpp_QPrinter_PrintRange;
    return {};
}
static PyObject *QPrinter_PrintRange_CppToPython_QPrinter_PrintRange(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QPrinter::PrintRange *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PRINTRANGE_IDX], castCppIn);

}

static void QPrinter_Unit_PythonToCpp_QPrinter_Unit(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPrinter::Unit *>(cppOut) =
        static_cast<::QPrinter::Unit>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QPrinter_Unit_PythonToCpp_QPrinter_Unit_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_UNIT_IDX]))
        return QPrinter_Unit_PythonToCpp_QPrinter_Unit;
    return {};
}
static PyObject *QPrinter_Unit_CppToPython_QPrinter_Unit(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QPrinter::Unit *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_UNIT_IDX], castCppIn);

}

static void QPrinter_DuplexMode_PythonToCpp_QPrinter_DuplexMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPrinter::DuplexMode *>(cppOut) =
        static_cast<::QPrinter::DuplexMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QPrinter_DuplexMode_PythonToCpp_QPrinter_DuplexMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_DUPLEXMODE_IDX]))
        return QPrinter_DuplexMode_PythonToCpp_QPrinter_DuplexMode;
    return {};
}
static PyObject *QPrinter_DuplexMode_CppToPython_QPrinter_DuplexMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QPrinter::DuplexMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_DUPLEXMODE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QPrinter_PythonToCpp_QPrinter_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QPrinter_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QPrinter_PythonToCpp_QPrinter_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QPrinter_TypeF())))
        return QPrinter_PythonToCpp_QPrinter_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QPrinter_PTR_CppToPython_QPrinter(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QPrinter *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QPrinter_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QPrinter_SignatureStrings[] = {
    "1:PySide2.QtPrintSupport.QPrinter(self,mode:PySide2.QtPrintSupport.QPrinter.PrinterMode=ScreenResolution)",
    "0:PySide2.QtPrintSupport.QPrinter(self,printer:PySide2.QtPrintSupport.QPrinterInfo,mode:PySide2.QtPrintSupport.QPrinter.PrinterMode=ScreenResolution)",
    "PySide2.QtPrintSupport.QPrinter.abort(self)->bool",
    "PySide2.QtPrintSupport.QPrinter.actualNumCopies(self)->int",
    "PySide2.QtPrintSupport.QPrinter.collateCopies(self)->bool",
    "PySide2.QtPrintSupport.QPrinter.colorMode(self)->PySide2.QtPrintSupport.QPrinter.ColorMode",
    "PySide2.QtPrintSupport.QPrinter.copyCount(self)->int",
    "PySide2.QtPrintSupport.QPrinter.creator(self)->QString",
    "PySide2.QtPrintSupport.QPrinter.devType(self)->int",
    "PySide2.QtPrintSupport.QPrinter.docName(self)->QString",
    "PySide2.QtPrintSupport.QPrinter.doubleSidedPrinting(self)->bool",
    "PySide2.QtPrintSupport.QPrinter.duplex(self)->PySide2.QtPrintSupport.QPrinter.DuplexMode",
    "PySide2.QtPrintSupport.QPrinter.fontEmbeddingEnabled(self)->bool",
    "PySide2.QtPrintSupport.QPrinter.fromPage(self)->int",
    "PySide2.QtPrintSupport.QPrinter.fullPage(self)->bool",
    "PySide2.QtPrintSupport.QPrinter.getPageMargins(self,left:qreal*,top:qreal*,right:qreal*,bottom:qreal*,unit:PySide2.QtPrintSupport.QPrinter.Unit)",
    "PySide2.QtPrintSupport.QPrinter.isValid(self)->bool",
    "PySide2.QtPrintSupport.QPrinter.metric(self,arg__1:PySide2.QtGui.QPaintDevice.PaintDeviceMetric)->int",
    "PySide2.QtPrintSupport.QPrinter.newPage(self)->bool",
    "PySide2.QtPrintSupport.QPrinter.numCopies(self)->int",
    "PySide2.QtPrintSupport.QPrinter.orientation(self)->PySide2.QtPrintSupport.QPrinter.Orientation",
    "PySide2.QtPrintSupport.QPrinter.outputFileName(self)->QString",
    "PySide2.QtPrintSupport.QPrinter.outputFormat(self)->PySide2.QtPrintSupport.QPrinter.OutputFormat",
    "PySide2.QtPrintSupport.QPrinter.pageOrder(self)->PySide2.QtPrintSupport.QPrinter.PageOrder",
    "1:PySide2.QtPrintSupport.QPrinter.pageRect(self)->PySide2.QtCore.QRect",
    "0:PySide2.QtPrintSupport.QPrinter.pageRect(self,arg__1:PySide2.QtPrintSupport.QPrinter.Unit)->PySide2.QtCore.QRectF",
    "PySide2.QtPrintSupport.QPrinter.pageSize(self)->PySide2.QtGui.QPagedPaintDevice.PageSize",
    "PySide2.QtPrintSupport.QPrinter.paintEngine(self)->PySide2.QtGui.QPaintEngine",
    "PySide2.QtPrintSupport.QPrinter.paperName(self)->QString",
    "1:PySide2.QtPrintSupport.QPrinter.paperRect(self)->PySide2.QtCore.QRect",
    "0:PySide2.QtPrintSupport.QPrinter.paperRect(self,arg__1:PySide2.QtPrintSupport.QPrinter.Unit)->PySide2.QtCore.QRectF",
    "1:PySide2.QtPrintSupport.QPrinter.paperSize(self)->PySide2.QtGui.QPagedPaintDevice.PageSize",
    "0:PySide2.QtPrintSupport.QPrinter.paperSize(self,unit:PySide2.QtPrintSupport.QPrinter.Unit)->PySide2.QtCore.QSizeF",
    "PySide2.QtPrintSupport.QPrinter.paperSource(self)->PySide2.QtPrintSupport.QPrinter.PaperSource",
    "PySide2.QtPrintSupport.QPrinter.pdfVersion(self)->PySide2.QtGui.QPagedPaintDevice.PdfVersion",
    "PySide2.QtPrintSupport.QPrinter.printEngine(self)->PySide2.QtPrintSupport.QPrintEngine",
    "PySide2.QtPrintSupport.QPrinter.printProgram(self)->QString",
    "PySide2.QtPrintSupport.QPrinter.printRange(self)->PySide2.QtPrintSupport.QPrinter.PrintRange",
    "PySide2.QtPrintSupport.QPrinter.printerName(self)->QString",
    "PySide2.QtPrintSupport.QPrinter.printerState(self)->PySide2.QtPrintSupport.QPrinter.PrinterState",
    "PySide2.QtPrintSupport.QPrinter.resolution(self)->int",
    "PySide2.QtPrintSupport.QPrinter.setCollateCopies(self,collate:bool)",
    "PySide2.QtPrintSupport.QPrinter.setColorMode(self,arg__1:PySide2.QtPrintSupport.QPrinter.ColorMode)",
    "PySide2.QtPrintSupport.QPrinter.setCopyCount(self,arg__1:int)",
    "PySide2.QtPrintSupport.QPrinter.setCreator(self,arg__1:QString)",
    "PySide2.QtPrintSupport.QPrinter.setDocName(self,arg__1:QString)",
    "PySide2.QtPrintSupport.QPrinter.setDoubleSidedPrinting(self,enable:bool)",
    "PySide2.QtPrintSupport.QPrinter.setDuplex(self,duplex:PySide2.QtPrintSupport.QPrinter.DuplexMode)",
    "PySide2.QtPrintSupport.QPrinter.setEngines(self,printEngine:PySide2.QtPrintSupport.QPrintEngine,paintEngine:PySide2.QtGui.QPaintEngine)",
    "PySide2.QtPrintSupport.QPrinter.setFontEmbeddingEnabled(self,enable:bool)",
    "PySide2.QtPrintSupport.QPrinter.setFromTo(self,fromPage:int,toPage:int)",
    "PySide2.QtPrintSupport.QPrinter.setFullPage(self,arg__1:bool)",
    "PySide2.QtPrintSupport.QPrinter.setMargins(self,m:PySide2.QtGui.QPagedPaintDevice.Margins)",
    "PySide2.QtPrintSupport.QPrinter.setNumCopies(self,arg__1:int)",
    "PySide2.QtPrintSupport.QPrinter.setOrientation(self,arg__1:PySide2.QtPrintSupport.QPrinter.Orientation)",
    "PySide2.QtPrintSupport.QPrinter.setOutputFileName(self,arg__1:QString)",
    "PySide2.QtPrintSupport.QPrinter.setOutputFormat(self,format:PySide2.QtPrintSupport.QPrinter.OutputFormat)",
    "1:PySide2.QtPrintSupport.QPrinter.setPageMargins(self,left:qreal,top:qreal,right:qreal,bottom:qreal,unit:PySide2.QtPrintSupport.QPrinter.Unit)",
    "0:PySide2.QtPrintSupport.QPrinter.setPageMargins(self,margins:PySide2.QtCore.QMarginsF)->bool",
    "PySide2.QtPrintSupport.QPrinter.setPageOrder(self,arg__1:PySide2.QtPrintSupport.QPrinter.PageOrder)",
    "1:PySide2.QtPrintSupport.QPrinter.setPageSize(self,arg__1:PySide2.QtGui.QPagedPaintDevice.PageSize)",
    "0:PySide2.QtPrintSupport.QPrinter.setPageSize(self,arg__1:PySide2.QtGui.QPageSize)->bool",
    "PySide2.QtPrintSupport.QPrinter.setPageSizeMM(self,size:PySide2.QtCore.QSizeF)",
    "PySide2.QtPrintSupport.QPrinter.setPaperName(self,paperName:QString)",
    "1:PySide2.QtPrintSupport.QPrinter.setPaperSize(self,arg__1:PySide2.QtGui.QPagedPaintDevice.PageSize)",
    "0:PySide2.QtPrintSupport.QPrinter.setPaperSize(self,paperSize:PySide2.QtCore.QSizeF,unit:PySide2.QtPrintSupport.QPrinter.Unit)",
    "PySide2.QtPrintSupport.QPrinter.setPaperSource(self,arg__1:PySide2.QtPrintSupport.QPrinter.PaperSource)",
    "PySide2.QtPrintSupport.QPrinter.setPdfVersion(self,version:PySide2.QtGui.QPagedPaintDevice.PdfVersion)",
    "PySide2.QtPrintSupport.QPrinter.setPrintProgram(self,arg__1:QString)",
    "PySide2.QtPrintSupport.QPrinter.setPrintRange(self,range:PySide2.QtPrintSupport.QPrinter.PrintRange)",
    "PySide2.QtPrintSupport.QPrinter.setPrinterName(self,arg__1:QString)",
    "PySide2.QtPrintSupport.QPrinter.setResolution(self,arg__1:int)",
    "PySide2.QtPrintSupport.QPrinter.setWinPageSize(self,winPageSize:int)",
    "PySide2.QtPrintSupport.QPrinter.supportedResolutions(self)->QList[int]",
    "PySide2.QtPrintSupport.QPrinter.supportsMultipleCopies(self)->bool",
    "PySide2.QtPrintSupport.QPrinter.toPage(self)->int",
    "PySide2.QtPrintSupport.QPrinter.winPageSize(self)->int",
    nullptr}; // Sentinel

void init_QPrinter(PyObject *module)
{
    _Sbk_QPrinter_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QPrinter",
        "QPrinter*",
        &Sbk_QPrinter_spec,
        &Shiboken::callCppDestructor< ::QPrinter >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QPrinter_Type);
    InitSignatureStrings(pyType, QPrinter_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QPrinter_Type), Sbk_QPrinter_PropertyStrings);
    SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QPrinter_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QPrinter_TypeF(),
        QPrinter_PythonToCpp_QPrinter_PTR,
        is_QPrinter_PythonToCpp_QPrinter_PTR_Convertible,
        QPrinter_PTR_CppToPython_QPrinter);

    Shiboken::Conversions::registerConverterName(converter, "QPrinter");
    Shiboken::Conversions::registerConverterName(converter, "QPrinter*");
    Shiboken::Conversions::registerConverterName(converter, "QPrinter&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QPrinter).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QPrinterWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QPrinter_TypeF(), &Sbk_QPrinter_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'PrinterMode'.
    SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PRINTERMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QPrinter_TypeF(),
        "PrinterMode",
        "2:PySide2.QtPrintSupport.QPrinter.PrinterMode",
        "QPrinter::PrinterMode");
    if (!SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PRINTERMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PRINTERMODE_IDX],
        Sbk_QPrinter_TypeF(), "ScreenResolution", (long) QPrinter::PrinterMode::ScreenResolution))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PRINTERMODE_IDX],
        Sbk_QPrinter_TypeF(), "PrinterResolution", (long) QPrinter::PrinterMode::PrinterResolution))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PRINTERMODE_IDX],
        Sbk_QPrinter_TypeF(), "HighResolution", (long) QPrinter::PrinterMode::HighResolution))
        return;
    // Register converter for enum 'QPrinter::PrinterMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PRINTERMODE_IDX],
            QPrinter_PrinterMode_CppToPython_QPrinter_PrinterMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QPrinter_PrinterMode_PythonToCpp_QPrinter_PrinterMode,
            is_QPrinter_PrinterMode_PythonToCpp_QPrinter_PrinterMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PRINTERMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QPrinter::PrinterMode");
        Shiboken::Conversions::registerConverterName(converter, "PrinterMode");
    }
    // End of 'PrinterMode' enum.

    // Initialization of enum 'Orientation'.
    SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_ORIENTATION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QPrinter_TypeF(),
        "Orientation",
        "2:PySide2.QtPrintSupport.QPrinter.Orientation",
        "QPrinter::Orientation");
    if (!SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_ORIENTATION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_ORIENTATION_IDX],
        Sbk_QPrinter_TypeF(), "Portrait", (long) QPrinter::Orientation::Portrait))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_ORIENTATION_IDX],
        Sbk_QPrinter_TypeF(), "Landscape", (long) QPrinter::Orientation::Landscape))
        return;
    // Register converter for enum 'QPrinter::Orientation'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_ORIENTATION_IDX],
            QPrinter_Orientation_CppToPython_QPrinter_Orientation);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QPrinter_Orientation_PythonToCpp_QPrinter_Orientation,
            is_QPrinter_Orientation_PythonToCpp_QPrinter_Orientation_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_ORIENTATION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QPrinter::Orientation");
        Shiboken::Conversions::registerConverterName(converter, "Orientation");
    }
    // End of 'Orientation' enum.

    // Initialization of enum 'PageOrder'.
    SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PAGEORDER_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QPrinter_TypeF(),
        "PageOrder",
        "2:PySide2.QtPrintSupport.QPrinter.PageOrder",
        "QPrinter::PageOrder");
    if (!SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PAGEORDER_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PAGEORDER_IDX],
        Sbk_QPrinter_TypeF(), "FirstPageFirst", (long) QPrinter::PageOrder::FirstPageFirst))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PAGEORDER_IDX],
        Sbk_QPrinter_TypeF(), "LastPageFirst", (long) QPrinter::PageOrder::LastPageFirst))
        return;
    // Register converter for enum 'QPrinter::PageOrder'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PAGEORDER_IDX],
            QPrinter_PageOrder_CppToPython_QPrinter_PageOrder);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QPrinter_PageOrder_PythonToCpp_QPrinter_PageOrder,
            is_QPrinter_PageOrder_PythonToCpp_QPrinter_PageOrder_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PAGEORDER_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QPrinter::PageOrder");
        Shiboken::Conversions::registerConverterName(converter, "PageOrder");
    }
    // End of 'PageOrder' enum.

    // Initialization of enum 'ColorMode'.
    SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_COLORMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QPrinter_TypeF(),
        "ColorMode",
        "2:PySide2.QtPrintSupport.QPrinter.ColorMode",
        "QPrinter::ColorMode");
    if (!SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_COLORMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_COLORMODE_IDX],
        Sbk_QPrinter_TypeF(), "GrayScale", (long) QPrinter::ColorMode::GrayScale))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_COLORMODE_IDX],
        Sbk_QPrinter_TypeF(), "Color", (long) QPrinter::ColorMode::Color))
        return;
    // Register converter for enum 'QPrinter::ColorMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_COLORMODE_IDX],
            QPrinter_ColorMode_CppToPython_QPrinter_ColorMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QPrinter_ColorMode_PythonToCpp_QPrinter_ColorMode,
            is_QPrinter_ColorMode_PythonToCpp_QPrinter_ColorMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_COLORMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QPrinter::ColorMode");
        Shiboken::Conversions::registerConverterName(converter, "ColorMode");
    }
    // End of 'ColorMode' enum.

    // Initialization of enum 'PaperSource'.
    SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PAPERSOURCE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QPrinter_TypeF(),
        "PaperSource",
        "2:PySide2.QtPrintSupport.QPrinter.PaperSource",
        "QPrinter::PaperSource");
    if (!SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PAPERSOURCE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PAPERSOURCE_IDX],
        Sbk_QPrinter_TypeF(), "OnlyOne", (long) QPrinter::PaperSource::OnlyOne))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PAPERSOURCE_IDX],
        Sbk_QPrinter_TypeF(), "Lower", (long) QPrinter::PaperSource::Lower))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PAPERSOURCE_IDX],
        Sbk_QPrinter_TypeF(), "Middle", (long) QPrinter::PaperSource::Middle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PAPERSOURCE_IDX],
        Sbk_QPrinter_TypeF(), "Manual", (long) QPrinter::PaperSource::Manual))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PAPERSOURCE_IDX],
        Sbk_QPrinter_TypeF(), "Envelope", (long) QPrinter::PaperSource::Envelope))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PAPERSOURCE_IDX],
        Sbk_QPrinter_TypeF(), "EnvelopeManual", (long) QPrinter::PaperSource::EnvelopeManual))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PAPERSOURCE_IDX],
        Sbk_QPrinter_TypeF(), "Auto", (long) QPrinter::PaperSource::Auto))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PAPERSOURCE_IDX],
        Sbk_QPrinter_TypeF(), "Tractor", (long) QPrinter::PaperSource::Tractor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PAPERSOURCE_IDX],
        Sbk_QPrinter_TypeF(), "SmallFormat", (long) QPrinter::PaperSource::SmallFormat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PAPERSOURCE_IDX],
        Sbk_QPrinter_TypeF(), "LargeFormat", (long) QPrinter::PaperSource::LargeFormat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PAPERSOURCE_IDX],
        Sbk_QPrinter_TypeF(), "LargeCapacity", (long) QPrinter::PaperSource::LargeCapacity))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PAPERSOURCE_IDX],
        Sbk_QPrinter_TypeF(), "Cassette", (long) QPrinter::PaperSource::Cassette))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PAPERSOURCE_IDX],
        Sbk_QPrinter_TypeF(), "FormSource", (long) QPrinter::PaperSource::FormSource))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PAPERSOURCE_IDX],
        Sbk_QPrinter_TypeF(), "MaxPageSource", (long) QPrinter::PaperSource::MaxPageSource))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PAPERSOURCE_IDX],
        Sbk_QPrinter_TypeF(), "CustomSource", (long) QPrinter::PaperSource::CustomSource))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PAPERSOURCE_IDX],
        Sbk_QPrinter_TypeF(), "LastPaperSource", (long) QPrinter::PaperSource::LastPaperSource))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PAPERSOURCE_IDX],
        Sbk_QPrinter_TypeF(), "Upper", (long) QPrinter::PaperSource::Upper))
        return;
    // Register converter for enum 'QPrinter::PaperSource'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PAPERSOURCE_IDX],
            QPrinter_PaperSource_CppToPython_QPrinter_PaperSource);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QPrinter_PaperSource_PythonToCpp_QPrinter_PaperSource,
            is_QPrinter_PaperSource_PythonToCpp_QPrinter_PaperSource_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PAPERSOURCE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QPrinter::PaperSource");
        Shiboken::Conversions::registerConverterName(converter, "PaperSource");
    }
    // End of 'PaperSource' enum.

    // Initialization of enum 'PrinterState'.
    SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PRINTERSTATE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QPrinter_TypeF(),
        "PrinterState",
        "2:PySide2.QtPrintSupport.QPrinter.PrinterState",
        "QPrinter::PrinterState");
    if (!SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PRINTERSTATE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PRINTERSTATE_IDX],
        Sbk_QPrinter_TypeF(), "Idle", (long) QPrinter::PrinterState::Idle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PRINTERSTATE_IDX],
        Sbk_QPrinter_TypeF(), "Active", (long) QPrinter::PrinterState::Active))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PRINTERSTATE_IDX],
        Sbk_QPrinter_TypeF(), "Aborted", (long) QPrinter::PrinterState::Aborted))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PRINTERSTATE_IDX],
        Sbk_QPrinter_TypeF(), "Error", (long) QPrinter::PrinterState::Error))
        return;
    // Register converter for enum 'QPrinter::PrinterState'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PRINTERSTATE_IDX],
            QPrinter_PrinterState_CppToPython_QPrinter_PrinterState);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QPrinter_PrinterState_PythonToCpp_QPrinter_PrinterState,
            is_QPrinter_PrinterState_PythonToCpp_QPrinter_PrinterState_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PRINTERSTATE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QPrinter::PrinterState");
        Shiboken::Conversions::registerConverterName(converter, "PrinterState");
    }
    // End of 'PrinterState' enum.

    // Initialization of enum 'OutputFormat'.
    SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_OUTPUTFORMAT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QPrinter_TypeF(),
        "OutputFormat",
        "2:PySide2.QtPrintSupport.QPrinter.OutputFormat",
        "QPrinter::OutputFormat");
    if (!SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_OUTPUTFORMAT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_OUTPUTFORMAT_IDX],
        Sbk_QPrinter_TypeF(), "NativeFormat", (long) QPrinter::OutputFormat::NativeFormat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_OUTPUTFORMAT_IDX],
        Sbk_QPrinter_TypeF(), "PdfFormat", (long) QPrinter::OutputFormat::PdfFormat))
        return;
    // Register converter for enum 'QPrinter::OutputFormat'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_OUTPUTFORMAT_IDX],
            QPrinter_OutputFormat_CppToPython_QPrinter_OutputFormat);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QPrinter_OutputFormat_PythonToCpp_QPrinter_OutputFormat,
            is_QPrinter_OutputFormat_PythonToCpp_QPrinter_OutputFormat_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_OUTPUTFORMAT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QPrinter::OutputFormat");
        Shiboken::Conversions::registerConverterName(converter, "OutputFormat");
    }
    // End of 'OutputFormat' enum.

    // Initialization of enum 'PrintRange'.
    SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PRINTRANGE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QPrinter_TypeF(),
        "PrintRange",
        "2:PySide2.QtPrintSupport.QPrinter.PrintRange",
        "QPrinter::PrintRange");
    if (!SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PRINTRANGE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PRINTRANGE_IDX],
        Sbk_QPrinter_TypeF(), "AllPages", (long) QPrinter::PrintRange::AllPages))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PRINTRANGE_IDX],
        Sbk_QPrinter_TypeF(), "Selection", (long) QPrinter::PrintRange::Selection))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PRINTRANGE_IDX],
        Sbk_QPrinter_TypeF(), "PageRange", (long) QPrinter::PrintRange::PageRange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PRINTRANGE_IDX],
        Sbk_QPrinter_TypeF(), "CurrentPage", (long) QPrinter::PrintRange::CurrentPage))
        return;
    // Register converter for enum 'QPrinter::PrintRange'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PRINTRANGE_IDX],
            QPrinter_PrintRange_CppToPython_QPrinter_PrintRange);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QPrinter_PrintRange_PythonToCpp_QPrinter_PrintRange,
            is_QPrinter_PrintRange_PythonToCpp_QPrinter_PrintRange_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PRINTRANGE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QPrinter::PrintRange");
        Shiboken::Conversions::registerConverterName(converter, "PrintRange");
    }
    // End of 'PrintRange' enum.

    // Initialization of enum 'Unit'.
    SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_UNIT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QPrinter_TypeF(),
        "Unit",
        "2:PySide2.QtPrintSupport.QPrinter.Unit",
        "QPrinter::Unit");
    if (!SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_UNIT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_UNIT_IDX],
        Sbk_QPrinter_TypeF(), "Millimeter", (long) QPrinter::Unit::Millimeter))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_UNIT_IDX],
        Sbk_QPrinter_TypeF(), "Point", (long) QPrinter::Unit::Point))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_UNIT_IDX],
        Sbk_QPrinter_TypeF(), "Inch", (long) QPrinter::Unit::Inch))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_UNIT_IDX],
        Sbk_QPrinter_TypeF(), "Pica", (long) QPrinter::Unit::Pica))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_UNIT_IDX],
        Sbk_QPrinter_TypeF(), "Didot", (long) QPrinter::Unit::Didot))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_UNIT_IDX],
        Sbk_QPrinter_TypeF(), "Cicero", (long) QPrinter::Unit::Cicero))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_UNIT_IDX],
        Sbk_QPrinter_TypeF(), "DevicePixel", (long) QPrinter::Unit::DevicePixel))
        return;
    // Register converter for enum 'QPrinter::Unit'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_UNIT_IDX],
            QPrinter_Unit_CppToPython_QPrinter_Unit);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QPrinter_Unit_PythonToCpp_QPrinter_Unit,
            is_QPrinter_Unit_PythonToCpp_QPrinter_Unit_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_UNIT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QPrinter::Unit");
        Shiboken::Conversions::registerConverterName(converter, "Unit");
    }
    // End of 'Unit' enum.

    // Initialization of enum 'DuplexMode'.
    SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_DUPLEXMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QPrinter_TypeF(),
        "DuplexMode",
        "2:PySide2.QtPrintSupport.QPrinter.DuplexMode",
        "QPrinter::DuplexMode");
    if (!SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_DUPLEXMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_DUPLEXMODE_IDX],
        Sbk_QPrinter_TypeF(), "DuplexNone", (long) QPrinter::DuplexMode::DuplexNone))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_DUPLEXMODE_IDX],
        Sbk_QPrinter_TypeF(), "DuplexAuto", (long) QPrinter::DuplexMode::DuplexAuto))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_DUPLEXMODE_IDX],
        Sbk_QPrinter_TypeF(), "DuplexLongSide", (long) QPrinter::DuplexMode::DuplexLongSide))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_DUPLEXMODE_IDX],
        Sbk_QPrinter_TypeF(), "DuplexShortSide", (long) QPrinter::DuplexMode::DuplexShortSide))
        return;
    // Register converter for enum 'QPrinter::DuplexMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_DUPLEXMODE_IDX],
            QPrinter_DuplexMode_CppToPython_QPrinter_DuplexMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QPrinter_DuplexMode_PythonToCpp_QPrinter_DuplexMode,
            is_QPrinter_DuplexMode_PythonToCpp_QPrinter_DuplexMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_DUPLEXMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QPrinter::DuplexMode");
        Shiboken::Conversions::registerConverterName(converter, "DuplexMode");
    }
    // End of 'DuplexMode' enum.

    qRegisterMetaType< ::QPrinter::PrinterMode >("QPrinter::PrinterMode");
    qRegisterMetaType< ::QPrinter::Orientation >("QPrinter::Orientation");
    qRegisterMetaType< ::QPrinter::PageOrder >("QPrinter::PageOrder");
    qRegisterMetaType< ::QPrinter::ColorMode >("QPrinter::ColorMode");
    qRegisterMetaType< ::QPrinter::PaperSource >("QPrinter::PaperSource");
    qRegisterMetaType< ::QPrinter::PrinterState >("QPrinter::PrinterState");
    qRegisterMetaType< ::QPrinter::OutputFormat >("QPrinter::OutputFormat");
    qRegisterMetaType< ::QPrinter::PrintRange >("QPrinter::PrintRange");
    qRegisterMetaType< ::QPrinter::Unit >("QPrinter::Unit");
    qRegisterMetaType< ::QPrinter::DuplexMode >("QPrinter::DuplexMode");
}
