/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtprintsupport_python.h"

// main header
#include "qprintengine_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QPrintEngineWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QPrintEngineWrapper::QPrintEngineWrapper() : QPrintEngine()
{
    resetPyMethodCache();
    // ... middle
}

bool QPrintEngineWrapper::abort()
{
    if (m_PyMethodCache[0]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPrintEngine.abort()' not implemented.");
        return false;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "abort";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPrintEngine.abort()' not implemented.");
        return false;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPrintEngine.abort", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

int QPrintEngineWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    if (m_PyMethodCache[1]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPrintEngine.metric()' not implemented.");
        return 0;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "metric";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPrintEngine.metric()' not implemented.");
        return 0;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_PAINTDEVICEMETRIC_IDX])->converter, &arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPrintEngine.metric", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QPrintEngineWrapper::newPage()
{
    if (m_PyMethodCache[2]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPrintEngine.newPage()' not implemented.");
        return false;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "newPage";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPrintEngine.newPage()' not implemented.");
        return false;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPrintEngine.newPage", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QPrinter::PrinterState QPrintEngineWrapper::printerState() const
{
    if (m_PyMethodCache[3]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPrintEngine.printerState()' not implemented.");
        return QPrinter::Idle;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QPrinter::Idle;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "printerState";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPrintEngine.printerState()' not implemented.");
        return QPrinter::Idle;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QPrinter::Idle;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PRINTERSTATE_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPrintEngine.printerState", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QPrinter::PrinterState >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QPrinter::Idle;
    }
    ::QPrinter::PrinterState cppResult{QPrinter::Idle};
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QVariant QPrintEngineWrapper::property(::QPrintEngine::PrintEnginePropertyKey key) const
{
    if (m_PyMethodCache[4]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPrintEngine.property()' not implemented.");
        return ::QVariant();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QVariant();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "property";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPrintEngine.property()' not implemented.");
        return ::QVariant();
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX])->converter, &key)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QVariant();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPrintEngine.property", "QVariant", Py_TYPE(pyResult)->tp_name);
        return ::QVariant();
    }
    ::QVariant cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QPrintEngineWrapper::setProperty(::QPrintEngine::PrintEnginePropertyKey key, const ::QVariant & value)
{
    if (m_PyMethodCache[5]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPrintEngine.setProperty()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setProperty";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPrintEngine.setProperty()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX])->converter, &key),
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &value)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

QPrintEngineWrapper::~QPrintEngineWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QPrintEngine_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QPrintEngine' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QPrintEngine >()))
        return -1;

    ::QPrintEngineWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrintEngine.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QPrintEngine()
            cptr = new ::QPrintEngineWrapper();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QPrintEngine >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QPrintEngineFunc_abort(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrintEngine.abort";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // abort()
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPrintEngine.abort()' not implemented.");
                return {};
            }
            bool cppResult = cppSelf->abort();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrintEngineFunc_metric(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrintEngine.metric";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPrintEngine::metric(QPaintDevice::PaintDeviceMetric)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_PAINTDEVICEMETRIC_IDX])->converter, (pyArg)))) {
        overloadId = 0; // metric(QPaintDevice::PaintDeviceMetric)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPrintEngineFunc_metric_TypeError;

    // Call function/method
    {
        ::QPaintDevice::PaintDeviceMetric cppArg0 = static_cast< ::QPaintDevice::PaintDeviceMetric>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // metric(QPaintDevice::PaintDeviceMetric)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPrintEngine.metric()' not implemented.");
                return {};
            }
            int cppResult = const_cast<const ::QPrintEngine *>(cppSelf)->metric(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPrintEngineFunc_metric_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPrintEngineFunc_newPage(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrintEngine.newPage";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // newPage()
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPrintEngine.newPage()' not implemented.");
                return {};
            }
            bool cppResult = cppSelf->newPage();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrintEngineFunc_printerState(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrintEngine.printerState";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // printerState()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPrintEngine.printerState()' not implemented.");
                return {};
            }
            QPrinter::PrinterState cppResult = const_cast<const ::QPrintEngine *>(cppSelf)->printerState();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTER_PRINTERSTATE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPrintEngineFunc_property(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrintEngine.property";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPrintEngine::property(QPrintEngine::PrintEnginePropertyKey)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX])->converter, (pyArg)))) {
        overloadId = 0; // property(QPrintEngine::PrintEnginePropertyKey)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPrintEngineFunc_property_TypeError;

    // Call function/method
    {
        ::QPrintEngine::PrintEnginePropertyKey cppArg0{QPrintEngine::PPK_CollateCopies};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // property(QPrintEngine::PrintEnginePropertyKey)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPrintEngine.property()' not implemented.");
                return {};
            }
            QVariant cppResult = const_cast<const ::QPrintEngine *>(cppSelf)->property(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPrintEngineFunc_property_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPrintEngineFunc_setProperty(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPrintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPrintSupport.QPrintEngine.setProperty";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setProperty", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QPrintEngine::setProperty(QPrintEngine::PrintEnginePropertyKey,QVariant)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[1])))) {
        overloadId = 0; // setProperty(QPrintEngine::PrintEnginePropertyKey,QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPrintEngineFunc_setProperty_TypeError;

    // Call function/method
    {
        ::QPrintEngine::PrintEnginePropertyKey cppArg0{QPrintEngine::PPK_CollateCopies};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QVariant cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setProperty(QPrintEngine::PrintEnginePropertyKey,QVariant)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPrintEngine.setProperty()' not implemented.");
                return {};
            }
            cppSelf->setProperty(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPrintEngineFunc_setProperty_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QPrintEngine_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QPrintEngine_methods[] = {
    {"abort", reinterpret_cast<PyCFunction>(Sbk_QPrintEngineFunc_abort), METH_NOARGS},
    {"metric", reinterpret_cast<PyCFunction>(Sbk_QPrintEngineFunc_metric), METH_O},
    {"newPage", reinterpret_cast<PyCFunction>(Sbk_QPrintEngineFunc_newPage), METH_NOARGS},
    {"printerState", reinterpret_cast<PyCFunction>(Sbk_QPrintEngineFunc_printerState), METH_NOARGS},
    {"property", reinterpret_cast<PyCFunction>(Sbk_QPrintEngineFunc_property), METH_O},
    {"setProperty", reinterpret_cast<PyCFunction>(Sbk_QPrintEngineFunc_setProperty), METH_VARARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QPrintEngine_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QPrintEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QPrintEngineWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QPrintEngine_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QPrintEngine_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QPrintEngine_Type = nullptr;
static SbkObjectType *Sbk_QPrintEngine_TypeF(void)
{
    return _Sbk_QPrintEngine_Type;
}

static PyType_Slot Sbk_QPrintEngine_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QPrintEngine_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QPrintEngine_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QPrintEngine_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QPrintEngine_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QPrintEngine_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QPrintEngine_spec = {
    "2:PySide2.QtPrintSupport.QPrintEngine",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QPrintEngine_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QPrintEngine_PrintEnginePropertyKey_PythonToCpp_QPrintEngine_PrintEnginePropertyKey(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPrintEngine::PrintEnginePropertyKey *>(cppOut) =
        static_cast<::QPrintEngine::PrintEnginePropertyKey>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QPrintEngine_PrintEnginePropertyKey_PythonToCpp_QPrintEngine_PrintEnginePropertyKey_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX]))
        return QPrintEngine_PrintEnginePropertyKey_PythonToCpp_QPrintEngine_PrintEnginePropertyKey;
    return {};
}
static PyObject *QPrintEngine_PrintEnginePropertyKey_CppToPython_QPrintEngine_PrintEnginePropertyKey(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QPrintEngine::PrintEnginePropertyKey *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QPrintEngine_PythonToCpp_QPrintEngine_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QPrintEngine_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QPrintEngine_PythonToCpp_QPrintEngine_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QPrintEngine_TypeF())))
        return QPrintEngine_PythonToCpp_QPrintEngine_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QPrintEngine_PTR_CppToPython_QPrintEngine(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QPrintEngine *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QPrintEngine_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QPrintEngine_SignatureStrings[] = {
    "PySide2.QtPrintSupport.QPrintEngine(self)",
    "PySide2.QtPrintSupport.QPrintEngine.abort(self)->bool",
    "PySide2.QtPrintSupport.QPrintEngine.metric(self,arg__1:PySide2.QtGui.QPaintDevice.PaintDeviceMetric)->int",
    "PySide2.QtPrintSupport.QPrintEngine.newPage(self)->bool",
    "PySide2.QtPrintSupport.QPrintEngine.printerState(self)->PySide2.QtPrintSupport.QPrinter.PrinterState",
    "PySide2.QtPrintSupport.QPrintEngine.property(self,key:PySide2.QtPrintSupport.QPrintEngine.PrintEnginePropertyKey)->QVariant",
    "PySide2.QtPrintSupport.QPrintEngine.setProperty(self,key:PySide2.QtPrintSupport.QPrintEngine.PrintEnginePropertyKey,value:QVariant)",
    nullptr}; // Sentinel

void init_QPrintEngine(PyObject *module)
{
    _Sbk_QPrintEngine_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QPrintEngine",
        "QPrintEngine*",
        &Sbk_QPrintEngine_spec,
        &Shiboken::callCppDestructor< ::QPrintEngine >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QPrintEngine_Type);
    InitSignatureStrings(pyType, QPrintEngine_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QPrintEngine_Type), Sbk_QPrintEngine_PropertyStrings);
    SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QPrintEngine_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QPrintEngine_TypeF(),
        QPrintEngine_PythonToCpp_QPrintEngine_PTR,
        is_QPrintEngine_PythonToCpp_QPrintEngine_PTR_Convertible,
        QPrintEngine_PTR_CppToPython_QPrintEngine);

    Shiboken::Conversions::registerConverterName(converter, "QPrintEngine");
    Shiboken::Conversions::registerConverterName(converter, "QPrintEngine*");
    Shiboken::Conversions::registerConverterName(converter, "QPrintEngine&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QPrintEngine).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QPrintEngineWrapper).name());


    // Initialization of enums.

    // Initialization of enum 'PrintEnginePropertyKey'.
    SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QPrintEngine_TypeF(),
        "PrintEnginePropertyKey",
        "2:PySide2.QtPrintSupport.QPrintEngine.PrintEnginePropertyKey",
        "QPrintEngine::PrintEnginePropertyKey");
    if (!SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX],
        Sbk_QPrintEngine_TypeF(), "PPK_CollateCopies", (long) QPrintEngine::PrintEnginePropertyKey::PPK_CollateCopies))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX],
        Sbk_QPrintEngine_TypeF(), "PPK_ColorMode", (long) QPrintEngine::PrintEnginePropertyKey::PPK_ColorMode))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX],
        Sbk_QPrintEngine_TypeF(), "PPK_Creator", (long) QPrintEngine::PrintEnginePropertyKey::PPK_Creator))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX],
        Sbk_QPrintEngine_TypeF(), "PPK_DocumentName", (long) QPrintEngine::PrintEnginePropertyKey::PPK_DocumentName))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX],
        Sbk_QPrintEngine_TypeF(), "PPK_FullPage", (long) QPrintEngine::PrintEnginePropertyKey::PPK_FullPage))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX],
        Sbk_QPrintEngine_TypeF(), "PPK_NumberOfCopies", (long) QPrintEngine::PrintEnginePropertyKey::PPK_NumberOfCopies))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX],
        Sbk_QPrintEngine_TypeF(), "PPK_Orientation", (long) QPrintEngine::PrintEnginePropertyKey::PPK_Orientation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX],
        Sbk_QPrintEngine_TypeF(), "PPK_OutputFileName", (long) QPrintEngine::PrintEnginePropertyKey::PPK_OutputFileName))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX],
        Sbk_QPrintEngine_TypeF(), "PPK_PageOrder", (long) QPrintEngine::PrintEnginePropertyKey::PPK_PageOrder))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX],
        Sbk_QPrintEngine_TypeF(), "PPK_PageRect", (long) QPrintEngine::PrintEnginePropertyKey::PPK_PageRect))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX],
        Sbk_QPrintEngine_TypeF(), "PPK_PageSize", (long) QPrintEngine::PrintEnginePropertyKey::PPK_PageSize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX],
        Sbk_QPrintEngine_TypeF(), "PPK_PaperRect", (long) QPrintEngine::PrintEnginePropertyKey::PPK_PaperRect))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX],
        Sbk_QPrintEngine_TypeF(), "PPK_PaperSource", (long) QPrintEngine::PrintEnginePropertyKey::PPK_PaperSource))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX],
        Sbk_QPrintEngine_TypeF(), "PPK_PrinterName", (long) QPrintEngine::PrintEnginePropertyKey::PPK_PrinterName))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX],
        Sbk_QPrintEngine_TypeF(), "PPK_PrinterProgram", (long) QPrintEngine::PrintEnginePropertyKey::PPK_PrinterProgram))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX],
        Sbk_QPrintEngine_TypeF(), "PPK_Resolution", (long) QPrintEngine::PrintEnginePropertyKey::PPK_Resolution))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX],
        Sbk_QPrintEngine_TypeF(), "PPK_SelectionOption", (long) QPrintEngine::PrintEnginePropertyKey::PPK_SelectionOption))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX],
        Sbk_QPrintEngine_TypeF(), "PPK_SupportedResolutions", (long) QPrintEngine::PrintEnginePropertyKey::PPK_SupportedResolutions))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX],
        Sbk_QPrintEngine_TypeF(), "PPK_WindowsPageSize", (long) QPrintEngine::PrintEnginePropertyKey::PPK_WindowsPageSize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX],
        Sbk_QPrintEngine_TypeF(), "PPK_FontEmbedding", (long) QPrintEngine::PrintEnginePropertyKey::PPK_FontEmbedding))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX],
        Sbk_QPrintEngine_TypeF(), "PPK_Duplex", (long) QPrintEngine::PrintEnginePropertyKey::PPK_Duplex))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX],
        Sbk_QPrintEngine_TypeF(), "PPK_PaperSources", (long) QPrintEngine::PrintEnginePropertyKey::PPK_PaperSources))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX],
        Sbk_QPrintEngine_TypeF(), "PPK_CustomPaperSize", (long) QPrintEngine::PrintEnginePropertyKey::PPK_CustomPaperSize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX],
        Sbk_QPrintEngine_TypeF(), "PPK_PageMargins", (long) QPrintEngine::PrintEnginePropertyKey::PPK_PageMargins))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX],
        Sbk_QPrintEngine_TypeF(), "PPK_CopyCount", (long) QPrintEngine::PrintEnginePropertyKey::PPK_CopyCount))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX],
        Sbk_QPrintEngine_TypeF(), "PPK_SupportsMultipleCopies", (long) QPrintEngine::PrintEnginePropertyKey::PPK_SupportsMultipleCopies))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX],
        Sbk_QPrintEngine_TypeF(), "PPK_PaperName", (long) QPrintEngine::PrintEnginePropertyKey::PPK_PaperName))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX],
        Sbk_QPrintEngine_TypeF(), "PPK_QPageSize", (long) QPrintEngine::PrintEnginePropertyKey::PPK_QPageSize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX],
        Sbk_QPrintEngine_TypeF(), "PPK_QPageMargins", (long) QPrintEngine::PrintEnginePropertyKey::PPK_QPageMargins))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX],
        Sbk_QPrintEngine_TypeF(), "PPK_QPageLayout", (long) QPrintEngine::PrintEnginePropertyKey::PPK_QPageLayout))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX],
        Sbk_QPrintEngine_TypeF(), "PPK_PaperSize", (long) QPrintEngine::PrintEnginePropertyKey::PPK_PaperSize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX],
        Sbk_QPrintEngine_TypeF(), "PPK_CustomBase", (long) QPrintEngine::PrintEnginePropertyKey::PPK_CustomBase))
        return;
    // Register converter for enum 'QPrintEngine::PrintEnginePropertyKey'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX],
            QPrintEngine_PrintEnginePropertyKey_CppToPython_QPrintEngine_PrintEnginePropertyKey);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QPrintEngine_PrintEnginePropertyKey_PythonToCpp_QPrintEngine_PrintEnginePropertyKey,
            is_QPrintEngine_PrintEnginePropertyKey_PythonToCpp_QPrintEngine_PrintEnginePropertyKey_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtPrintSupportTypes[SBK_QPRINTENGINE_PRINTENGINEPROPERTYKEY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QPrintEngine::PrintEnginePropertyKey");
        Shiboken::Conversions::registerConverterName(converter, "PrintEnginePropertyKey");
    }
    // End of 'PrintEnginePropertyKey' enum.

    qRegisterMetaType< ::QPrintEngine::PrintEnginePropertyKey >("QPrintEngine::PrintEnginePropertyKey");
}
