/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtpositioning_python.h"

// main header
#include "qgeopositioninfo_wrapper.h"

// inner classes

// Extra includes
#include <QtPositioning/qgeocoordinate.h>
#include <QtPositioning/qgeopositioninfo.h>
#include <qdatastream.h>
#include <qdatetime.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QGeoPositionInfo_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QGeoPositionInfo >()))
        return -1;

    ::QGeoPositionInfo *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPositionInfo.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QGeoPositionInfo", 0, 2, &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QGeoPositionInfo::QGeoPositionInfo()
    // 1: QGeoPositionInfo::QGeoPositionInfo(QGeoCoordinate,QDateTime)
    // 2: QGeoPositionInfo::QGeoPositionInfo(QGeoPositionInfo)
    if (numArgs == 0) {
        overloadId = 0; // QGeoPositionInfo()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QGeoPositionInfo(QGeoPositionInfo)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), (pyArgs[1])))) {
        overloadId = 1; // QGeoPositionInfo(QGeoCoordinate,QDateTime)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoPositionInfo_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QGeoPositionInfo()
        {

            if (!PyErr_Occurred()) {
                // QGeoPositionInfo()
                cptr = new ::QGeoPositionInfo();
            }
            break;
        }
        case 1: // QGeoPositionInfo(const QGeoCoordinate & coordinate, const QDateTime & updateTime)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QGeoCoordinate cppArg0_local;
            ::QGeoCoordinate *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QDateTime cppArg1_local;
            ::QDateTime *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // QGeoPositionInfo(QGeoCoordinate,QDateTime)
                cptr = new ::QGeoPositionInfo(*cppArg0, *cppArg1);
            }
            break;
        }
        case 2: // QGeoPositionInfo(const QGeoPositionInfo & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QGeoPositionInfo cppArg0_local;
            ::QGeoPositionInfo *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QGeoPositionInfo(QGeoPositionInfo)
                cptr = new ::QGeoPositionInfo(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QGeoPositionInfo >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QGeoPositionInfo_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QGeoPositionInfo_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QGeoPositionInfoFunc_attribute(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPositionInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPositionInfo.attribute";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoPositionInfo::attribute(QGeoPositionInfo::Attribute)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_ATTRIBUTE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // attribute(QGeoPositionInfo::Attribute)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoPositionInfoFunc_attribute_TypeError;

    // Call function/method
    {
        ::QGeoPositionInfo::Attribute cppArg0{QGeoPositionInfo::Direction};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // attribute(QGeoPositionInfo::Attribute)const
            qreal cppResult = const_cast<const ::QGeoPositionInfo *>(cppSelf)->attribute(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoPositionInfoFunc_attribute_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoPositionInfoFunc_coordinate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPositionInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPositionInfo.coordinate";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // coordinate()const
            QGeoCoordinate cppResult = const_cast<const ::QGeoPositionInfo *>(cppSelf)->coordinate();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoPositionInfoFunc_hasAttribute(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPositionInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPositionInfo.hasAttribute";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoPositionInfo::hasAttribute(QGeoPositionInfo::Attribute)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_ATTRIBUTE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // hasAttribute(QGeoPositionInfo::Attribute)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoPositionInfoFunc_hasAttribute_TypeError;

    // Call function/method
    {
        ::QGeoPositionInfo::Attribute cppArg0{QGeoPositionInfo::Direction};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // hasAttribute(QGeoPositionInfo::Attribute)const
            bool cppResult = const_cast<const ::QGeoPositionInfo *>(cppSelf)->hasAttribute(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoPositionInfoFunc_hasAttribute_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoPositionInfoFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPositionInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPositionInfo.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QGeoPositionInfo *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoPositionInfoFunc_removeAttribute(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPositionInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPositionInfo.removeAttribute";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoPositionInfo::removeAttribute(QGeoPositionInfo::Attribute)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_ATTRIBUTE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // removeAttribute(QGeoPositionInfo::Attribute)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoPositionInfoFunc_removeAttribute_TypeError;

    // Call function/method
    {
        ::QGeoPositionInfo::Attribute cppArg0{QGeoPositionInfo::Direction};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // removeAttribute(QGeoPositionInfo::Attribute)
            cppSelf->removeAttribute(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoPositionInfoFunc_removeAttribute_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoPositionInfoFunc_setAttribute(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPositionInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPositionInfo.setAttribute";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setAttribute", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGeoPositionInfo::setAttribute(QGeoPositionInfo::Attribute,qreal)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_ATTRIBUTE_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))) {
        overloadId = 0; // setAttribute(QGeoPositionInfo::Attribute,qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoPositionInfoFunc_setAttribute_TypeError;

    // Call function/method
    {
        ::QGeoPositionInfo::Attribute cppArg0{QGeoPositionInfo::Direction};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        qreal cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setAttribute(QGeoPositionInfo::Attribute,qreal)
            cppSelf->setAttribute(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoPositionInfoFunc_setAttribute_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoPositionInfoFunc_setCoordinate(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPositionInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPositionInfo.setCoordinate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoPositionInfo::setCoordinate(QGeoCoordinate)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), (pyArg)))) {
        overloadId = 0; // setCoordinate(QGeoCoordinate)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoPositionInfoFunc_setCoordinate_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGeoCoordinate cppArg0_local;
        ::QGeoCoordinate *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setCoordinate(QGeoCoordinate)
            cppSelf->setCoordinate(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoPositionInfoFunc_setCoordinate_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoPositionInfoFunc_setTimestamp(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPositionInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPositionInfo.setTimestamp";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoPositionInfo::setTimestamp(QDateTime)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), (pyArg)))) {
        overloadId = 0; // setTimestamp(QDateTime)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoPositionInfoFunc_setTimestamp_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDateTime cppArg0_local;
        ::QDateTime *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setTimestamp(QDateTime)
            cppSelf->setTimestamp(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoPositionInfoFunc_setTimestamp_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoPositionInfoFunc_timestamp(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPositionInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPositionInfo.timestamp";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // timestamp()const
            QDateTime cppResult = const_cast<const ::QGeoPositionInfo *>(cppSelf)->timestamp();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoPositionInfo___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QGeoPositionInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QGeoPositionInfo_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QGeoPositionInfo_methods[] = {
    {"attribute", reinterpret_cast<PyCFunction>(Sbk_QGeoPositionInfoFunc_attribute), METH_O},
    {"coordinate", reinterpret_cast<PyCFunction>(Sbk_QGeoPositionInfoFunc_coordinate), METH_NOARGS},
    {"hasAttribute", reinterpret_cast<PyCFunction>(Sbk_QGeoPositionInfoFunc_hasAttribute), METH_O},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QGeoPositionInfoFunc_isValid), METH_NOARGS},
    {"removeAttribute", reinterpret_cast<PyCFunction>(Sbk_QGeoPositionInfoFunc_removeAttribute), METH_O},
    {"setAttribute", reinterpret_cast<PyCFunction>(Sbk_QGeoPositionInfoFunc_setAttribute), METH_VARARGS},
    {"setCoordinate", reinterpret_cast<PyCFunction>(Sbk_QGeoPositionInfoFunc_setCoordinate), METH_O},
    {"setTimestamp", reinterpret_cast<PyCFunction>(Sbk_QGeoPositionInfoFunc_setTimestamp), METH_O},
    {"timestamp", reinterpret_cast<PyCFunction>(Sbk_QGeoPositionInfoFunc_timestamp), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QGeoPositionInfo___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QGeoPositionInfoFunc___lshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPositionInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPositionInfo.__lshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rlshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QGeoPositionInfo::operator<<(QDataStream&,QGeoPositionInfo)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator<<(QDataStream&,QGeoPositionInfo)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QGeoPositionInfoFunc___lshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDataStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator<<(QDataStream&,QGeoPositionInfo) [reverse operator]
                QDataStream & cppResult = (*cppArg0) << (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoPositionInfoFunc___lshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoPositionInfoFunc___rshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPositionInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtPositioning.QGeoPositionInfo.__rshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rrshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QGeoPositionInfo::operator>>(QDataStream&,QGeoPositionInfo&)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator>>(QDataStream&,QGeoPositionInfo&)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QGeoPositionInfoFunc___rshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDataStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator>>(QDataStream&,QGeoPositionInfo&) [reverse operator]
                QDataStream & cppResult = (*cppArg0) >> (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoPositionInfoFunc___rshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

// Rich comparison
static PyObject * Sbk_QGeoPositionInfo_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QGeoPositionInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_IDX]), (pyArg)))) {
                // operator!=(const QGeoPositionInfo & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QGeoPositionInfo cppArg0_local;
                ::QGeoPositionInfo *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_IDX]), (pyArg)))) {
                // operator==(const QGeoPositionInfo & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QGeoPositionInfo cppArg0_local;
                ::QGeoPositionInfo *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QGeoPositionInfo_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QGeoPositionInfo_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QGeoPositionInfo_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QGeoPositionInfo_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QGeoPositionInfo__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoPositionInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QGeoPositionInfo_Type = nullptr;
static SbkObjectType *Sbk_QGeoPositionInfo_TypeF(void)
{
    return _Sbk_QGeoPositionInfo_Type;
}

static PyType_Slot Sbk_QGeoPositionInfo_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QGeoPositionInfo__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QGeoPositionInfo_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QGeoPositionInfo_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QGeoPositionInfo_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QGeoPositionInfo_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QGeoPositionInfo_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
    {Py_nb_rshift, (void *)Sbk_QGeoPositionInfoFunc___rshift__},
    {Py_nb_lshift, (void *)Sbk_QGeoPositionInfoFunc___lshift__},
    {0, nullptr}
};
static PyType_Spec Sbk_QGeoPositionInfo_spec = {
    "2:PySide2.QtPositioning.QGeoPositionInfo",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QGeoPositionInfo_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QGeoPositionInfo_Attribute_PythonToCpp_QGeoPositionInfo_Attribute(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGeoPositionInfo::Attribute *>(cppOut) =
        static_cast<::QGeoPositionInfo::Attribute>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGeoPositionInfo_Attribute_PythonToCpp_QGeoPositionInfo_Attribute_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_ATTRIBUTE_IDX]))
        return QGeoPositionInfo_Attribute_PythonToCpp_QGeoPositionInfo_Attribute;
    return {};
}
static PyObject *QGeoPositionInfo_Attribute_CppToPython_QGeoPositionInfo_Attribute(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGeoPositionInfo::Attribute *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_ATTRIBUTE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QGeoPositionInfo_PythonToCpp_QGeoPositionInfo_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QGeoPositionInfo_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QGeoPositionInfo_PythonToCpp_QGeoPositionInfo_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGeoPositionInfo_TypeF())))
        return QGeoPositionInfo_PythonToCpp_QGeoPositionInfo_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QGeoPositionInfo_PTR_CppToPython_QGeoPositionInfo(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QGeoPositionInfo *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QGeoPositionInfo_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QGeoPositionInfo_COPY_CppToPython_QGeoPositionInfo(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QGeoPositionInfo_TypeF(), new ::QGeoPositionInfo(*reinterpret_cast<const ::QGeoPositionInfo *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QGeoPositionInfo_PythonToCpp_QGeoPositionInfo_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGeoPositionInfo *>(cppOut) = *reinterpret_cast< ::QGeoPositionInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QGeoPositionInfo_PythonToCpp_QGeoPositionInfo_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGeoPositionInfo_TypeF())))
        return QGeoPositionInfo_PythonToCpp_QGeoPositionInfo_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QGeoPositionInfo_SignatureStrings[] = {
    "2:PySide2.QtPositioning.QGeoPositionInfo(self)",
    "1:PySide2.QtPositioning.QGeoPositionInfo(self,coordinate:PySide2.QtPositioning.QGeoCoordinate,updateTime:PySide2.QtCore.QDateTime)",
    "0:PySide2.QtPositioning.QGeoPositionInfo(self,other:PySide2.QtPositioning.QGeoPositionInfo)",
    "PySide2.QtPositioning.QGeoPositionInfo.attribute(self,attribute:PySide2.QtPositioning.QGeoPositionInfo.Attribute)->qreal",
    "PySide2.QtPositioning.QGeoPositionInfo.coordinate(self)->PySide2.QtPositioning.QGeoCoordinate",
    "PySide2.QtPositioning.QGeoPositionInfo.hasAttribute(self,attribute:PySide2.QtPositioning.QGeoPositionInfo.Attribute)->bool",
    "PySide2.QtPositioning.QGeoPositionInfo.isValid(self)->bool",
    "PySide2.QtPositioning.QGeoPositionInfo.removeAttribute(self,attribute:PySide2.QtPositioning.QGeoPositionInfo.Attribute)",
    "PySide2.QtPositioning.QGeoPositionInfo.setAttribute(self,attribute:PySide2.QtPositioning.QGeoPositionInfo.Attribute,value:qreal)",
    "PySide2.QtPositioning.QGeoPositionInfo.setCoordinate(self,coordinate:PySide2.QtPositioning.QGeoCoordinate)",
    "PySide2.QtPositioning.QGeoPositionInfo.setTimestamp(self,timestamp:PySide2.QtCore.QDateTime)",
    "PySide2.QtPositioning.QGeoPositionInfo.timestamp(self)->PySide2.QtCore.QDateTime",
    "PySide2.QtPositioning.QGeoPositionInfo.__copy__()",
    "PySide2.QtPositioning.QGeoPositionInfo.__lshift__(self,stream:PySide2.QtCore.QDataStream)->PySide2.QtCore.QDataStream",
    "PySide2.QtPositioning.QGeoPositionInfo.__rshift__(self,stream:PySide2.QtCore.QDataStream)->PySide2.QtCore.QDataStream",
    nullptr}; // Sentinel

void init_QGeoPositionInfo(PyObject *module)
{
    _Sbk_QGeoPositionInfo_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QGeoPositionInfo",
        "QGeoPositionInfo",
        &Sbk_QGeoPositionInfo_spec,
        &Shiboken::callCppDestructor< ::QGeoPositionInfo >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QGeoPositionInfo_Type);
    InitSignatureStrings(pyType, QGeoPositionInfo_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QGeoPositionInfo_Type), Sbk_QGeoPositionInfo_PropertyStrings);
    SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QGeoPositionInfo_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QGeoPositionInfo_TypeF(),
        QGeoPositionInfo_PythonToCpp_QGeoPositionInfo_PTR,
        is_QGeoPositionInfo_PythonToCpp_QGeoPositionInfo_PTR_Convertible,
        QGeoPositionInfo_PTR_CppToPython_QGeoPositionInfo,
        QGeoPositionInfo_COPY_CppToPython_QGeoPositionInfo);

    Shiboken::Conversions::registerConverterName(converter, "QGeoPositionInfo");
    Shiboken::Conversions::registerConverterName(converter, "QGeoPositionInfo*");
    Shiboken::Conversions::registerConverterName(converter, "QGeoPositionInfo&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGeoPositionInfo).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QGeoPositionInfo_PythonToCpp_QGeoPositionInfo_COPY,
        is_QGeoPositionInfo_PythonToCpp_QGeoPositionInfo_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'Attribute'.
    SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_ATTRIBUTE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGeoPositionInfo_TypeF(),
        "Attribute",
        "2:PySide2.QtPositioning.QGeoPositionInfo.Attribute",
        "QGeoPositionInfo::Attribute");
    if (!SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_ATTRIBUTE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_ATTRIBUTE_IDX],
        Sbk_QGeoPositionInfo_TypeF(), "Direction", (long) QGeoPositionInfo::Attribute::Direction))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_ATTRIBUTE_IDX],
        Sbk_QGeoPositionInfo_TypeF(), "GroundSpeed", (long) QGeoPositionInfo::Attribute::GroundSpeed))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_ATTRIBUTE_IDX],
        Sbk_QGeoPositionInfo_TypeF(), "VerticalSpeed", (long) QGeoPositionInfo::Attribute::VerticalSpeed))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_ATTRIBUTE_IDX],
        Sbk_QGeoPositionInfo_TypeF(), "MagneticVariation", (long) QGeoPositionInfo::Attribute::MagneticVariation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_ATTRIBUTE_IDX],
        Sbk_QGeoPositionInfo_TypeF(), "HorizontalAccuracy", (long) QGeoPositionInfo::Attribute::HorizontalAccuracy))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_ATTRIBUTE_IDX],
        Sbk_QGeoPositionInfo_TypeF(), "VerticalAccuracy", (long) QGeoPositionInfo::Attribute::VerticalAccuracy))
        return;
    // Register converter for enum 'QGeoPositionInfo::Attribute'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_ATTRIBUTE_IDX],
            QGeoPositionInfo_Attribute_CppToPython_QGeoPositionInfo_Attribute);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGeoPositionInfo_Attribute_PythonToCpp_QGeoPositionInfo_Attribute,
            is_QGeoPositionInfo_Attribute_PythonToCpp_QGeoPositionInfo_Attribute_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtPositioningTypes[SBK_QGEOPOSITIONINFO_ATTRIBUTE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGeoPositionInfo::Attribute");
        Shiboken::Conversions::registerConverterName(converter, "Attribute");
    }
    // End of 'Attribute' enum.

    qRegisterMetaType< ::QGeoPositionInfo >("QGeoPositionInfo");
    qRegisterMetaType< ::QGeoPositionInfo::Attribute >("QGeoPositionInfo::Attribute");
}
