/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef SBK_QGEOAREAMONITORSOURCEWRAPPER_H
#define SBK_QGEOAREAMONITORSOURCEWRAPPER_H

#define protected public

#include <QtPositioning/qgeoareamonitorsource.h>


// Extra includes
#include <qobject.h>
#include <QtPositioning/qgeoareamonitorsource.h>
#include <QtPositioning/qgeopositioninfosource.h>
#include <QtPositioning/qgeoareamonitorinfo.h>
#include <QList>
#include <QtPositioning/qgeoshape.h>
#include <QtPositioning/qgeopositioninfo.h>
#include <qmetaobject.h>
#include <qthread.h>
#include <qobjectdefs.h>
#include <qcoreevent.h>
#include <qbytearray.h>
namespace PySide { class DynamicQMetaObject; }

class QGeoAreaMonitorSourceWrapper : public QGeoAreaMonitorSource
{
public:
    QGeoAreaMonitorSourceWrapper(::QObject * parent);
    ::QList<QGeoAreaMonitorInfo > activeMonitors() const override;
    ::QList<QGeoAreaMonitorInfo > activeMonitors(const ::QGeoShape & lookupArea) const override;
    void childEvent(::QChildEvent * event) override;
    void connectNotify(const ::QMetaMethod & signal) override;
    void customEvent(::QEvent * event) override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    ::QGeoAreaMonitorSource::Error error() const override;
    bool event(::QEvent * event) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    const ::QMetaObject * metaObject() const override;
    ::QGeoPositionInfoSource * positionInfoSource() const override;
    bool requestUpdate(const ::QGeoAreaMonitorInfo & monitor, const char * signal) override;
    void setPositionInfoSource(::QGeoPositionInfoSource * source) override;
    bool startMonitoring(const ::QGeoAreaMonitorInfo & monitor) override;
    bool stopMonitoring(const ::QGeoAreaMonitorInfo & monitor) override;
    ::QFlags<QGeoAreaMonitorSource::AreaMonitorFeature> supportedAreaMonitorFeatures() const override;
    void timerEvent(::QTimerEvent * event) override;
    ~QGeoAreaMonitorSourceWrapper();
public:
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    // Inherited overloads, because the using keyword sux
    inline void error(::QGeoAreaMonitorSource::Error error) { QGeoAreaMonitorSource::error(QGeoAreaMonitorSource::Error(error)); }
    static void pysideInitQtMetaTypes();
    void resetPyMethodCache();
private:
    mutable bool m_PyMethodCache[17];
};

#endif // SBK_QGEOAREAMONITORSOURCEWRAPPER_H

