/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtopengl_python.h"

// main header
#include "qglframebufferobjectformat_wrapper.h"

// inner classes

// Extra includes
#include <QtOpenGL/qglframebufferobject.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QGLFramebufferObjectFormat_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QGLFramebufferObjectFormat >()))
        return -1;

    ::QGLFramebufferObjectFormat *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFramebufferObjectFormat.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QGLFramebufferObjectFormat", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QGLFramebufferObjectFormat::QGLFramebufferObjectFormat()
    // 1: QGLFramebufferObjectFormat::QGLFramebufferObjectFormat(QGLFramebufferObjectFormat)
    if (numArgs == 0) {
        overloadId = 0; // QGLFramebufferObjectFormat()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECTFORMAT_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QGLFramebufferObjectFormat(QGLFramebufferObjectFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLFramebufferObjectFormat_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QGLFramebufferObjectFormat()
        {

            if (!PyErr_Occurred()) {
                // QGLFramebufferObjectFormat()
                cptr = new ::QGLFramebufferObjectFormat();
            }
            break;
        }
        case 1: // QGLFramebufferObjectFormat(const QGLFramebufferObjectFormat & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QGLFramebufferObjectFormat cppArg0_local;
            ::QGLFramebufferObjectFormat *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECTFORMAT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QGLFramebufferObjectFormat(QGLFramebufferObjectFormat)
                cptr = new ::QGLFramebufferObjectFormat(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QGLFramebufferObjectFormat >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QGLFramebufferObjectFormat_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QGLFramebufferObjectFormat_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QGLFramebufferObjectFormatFunc_attachment(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFramebufferObjectFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFramebufferObjectFormat.attachment";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // attachment()const
            QGLFramebufferObject::Attachment cppResult = const_cast<const ::QGLFramebufferObjectFormat *>(cppSelf)->attachment();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECT_ATTACHMENT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFramebufferObjectFormatFunc_internalTextureFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFramebufferObjectFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFramebufferObjectFormat.internalTextureFormat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // internalTextureFormat()const
            GLenum cppResult = const_cast<const ::QGLFramebufferObjectFormat *>(cppSelf)->internalTextureFormat();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFramebufferObjectFormatFunc_mipmap(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFramebufferObjectFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFramebufferObjectFormat.mipmap";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mipmap()const
            bool cppResult = const_cast<const ::QGLFramebufferObjectFormat *>(cppSelf)->mipmap();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFramebufferObjectFormatFunc_samples(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFramebufferObjectFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFramebufferObjectFormat.samples";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // samples()const
            int cppResult = const_cast<const ::QGLFramebufferObjectFormat *>(cppSelf)->samples();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFramebufferObjectFormatFunc_setAttachment(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFramebufferObjectFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFramebufferObjectFormat.setAttachment";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLFramebufferObjectFormat::setAttachment(QGLFramebufferObject::Attachment)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECT_ATTACHMENT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setAttachment(QGLFramebufferObject::Attachment)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLFramebufferObjectFormatFunc_setAttachment_TypeError;

    // Call function/method
    {
        ::QGLFramebufferObject::Attachment cppArg0{QGLFramebufferObject::NoAttachment};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAttachment(QGLFramebufferObject::Attachment)
            cppSelf->setAttachment(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLFramebufferObjectFormatFunc_setAttachment_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLFramebufferObjectFormatFunc_setInternalTextureFormat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFramebufferObjectFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFramebufferObjectFormat.setInternalTextureFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLFramebufferObjectFormat::setInternalTextureFormat(GLenum)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), (pyArg)))) {
        overloadId = 0; // setInternalTextureFormat(GLenum)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLFramebufferObjectFormatFunc_setInternalTextureFormat_TypeError;

    // Call function/method
    {
        GLenum cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setInternalTextureFormat(GLenum)
            cppSelf->setInternalTextureFormat(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLFramebufferObjectFormatFunc_setInternalTextureFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLFramebufferObjectFormatFunc_setMipmap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFramebufferObjectFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFramebufferObjectFormat.setMipmap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLFramebufferObjectFormat::setMipmap(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setMipmap(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLFramebufferObjectFormatFunc_setMipmap_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMipmap(bool)
            cppSelf->setMipmap(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLFramebufferObjectFormatFunc_setMipmap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLFramebufferObjectFormatFunc_setSamples(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFramebufferObjectFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFramebufferObjectFormat.setSamples";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLFramebufferObjectFormat::setSamples(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setSamples(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLFramebufferObjectFormatFunc_setSamples_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSamples(int)
            cppSelf->setSamples(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLFramebufferObjectFormatFunc_setSamples_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLFramebufferObjectFormatFunc_setTextureTarget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFramebufferObjectFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFramebufferObjectFormat.setTextureTarget";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLFramebufferObjectFormat::setTextureTarget(GLenum)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), (pyArg)))) {
        overloadId = 0; // setTextureTarget(GLenum)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLFramebufferObjectFormatFunc_setTextureTarget_TypeError;

    // Call function/method
    {
        GLenum cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTextureTarget(GLenum)
            cppSelf->setTextureTarget(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLFramebufferObjectFormatFunc_setTextureTarget_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLFramebufferObjectFormatFunc_textureTarget(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFramebufferObjectFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFramebufferObjectFormat.textureTarget";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // textureTarget()const
            GLenum cppResult = const_cast<const ::QGLFramebufferObjectFormat *>(cppSelf)->textureTarget();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFramebufferObjectFormat___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QGLFramebufferObjectFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECTFORMAT_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QGLFramebufferObjectFormat_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QGLFramebufferObjectFormat_methods[] = {
    {"attachment", reinterpret_cast<PyCFunction>(Sbk_QGLFramebufferObjectFormatFunc_attachment), METH_NOARGS},
    {"internalTextureFormat", reinterpret_cast<PyCFunction>(Sbk_QGLFramebufferObjectFormatFunc_internalTextureFormat), METH_NOARGS},
    {"mipmap", reinterpret_cast<PyCFunction>(Sbk_QGLFramebufferObjectFormatFunc_mipmap), METH_NOARGS},
    {"samples", reinterpret_cast<PyCFunction>(Sbk_QGLFramebufferObjectFormatFunc_samples), METH_NOARGS},
    {"setAttachment", reinterpret_cast<PyCFunction>(Sbk_QGLFramebufferObjectFormatFunc_setAttachment), METH_O},
    {"setInternalTextureFormat", reinterpret_cast<PyCFunction>(Sbk_QGLFramebufferObjectFormatFunc_setInternalTextureFormat), METH_O},
    {"setMipmap", reinterpret_cast<PyCFunction>(Sbk_QGLFramebufferObjectFormatFunc_setMipmap), METH_O},
    {"setSamples", reinterpret_cast<PyCFunction>(Sbk_QGLFramebufferObjectFormatFunc_setSamples), METH_O},
    {"setTextureTarget", reinterpret_cast<PyCFunction>(Sbk_QGLFramebufferObjectFormatFunc_setTextureTarget), METH_O},
    {"textureTarget", reinterpret_cast<PyCFunction>(Sbk_QGLFramebufferObjectFormatFunc_textureTarget), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QGLFramebufferObjectFormat___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QGLFramebufferObjectFormat_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QGLFramebufferObjectFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECTFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECTFORMAT_IDX]), (pyArg)))) {
                // operator!=(const QGLFramebufferObjectFormat & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QGLFramebufferObjectFormat cppArg0_local;
                ::QGLFramebufferObjectFormat *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECTFORMAT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECTFORMAT_IDX]), (pyArg)))) {
                // operator==(const QGLFramebufferObjectFormat & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QGLFramebufferObjectFormat cppArg0_local;
                ::QGLFramebufferObjectFormat *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECTFORMAT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QGLFramebufferObjectFormat_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QGLFramebufferObjectFormat_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QGLFramebufferObjectFormat_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QGLFramebufferObjectFormat_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QGLFramebufferObjectFormat_Type = nullptr;
static SbkObjectType *Sbk_QGLFramebufferObjectFormat_TypeF(void)
{
    return _Sbk_QGLFramebufferObjectFormat_Type;
}

static PyType_Slot Sbk_QGLFramebufferObjectFormat_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QGLFramebufferObjectFormat_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QGLFramebufferObjectFormat_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QGLFramebufferObjectFormat_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QGLFramebufferObjectFormat_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QGLFramebufferObjectFormat_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QGLFramebufferObjectFormat_spec = {
    "2:PySide2.QtOpenGL.QGLFramebufferObjectFormat",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QGLFramebufferObjectFormat_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QGLFramebufferObjectFormat_PythonToCpp_QGLFramebufferObjectFormat_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QGLFramebufferObjectFormat_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QGLFramebufferObjectFormat_PythonToCpp_QGLFramebufferObjectFormat_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGLFramebufferObjectFormat_TypeF())))
        return QGLFramebufferObjectFormat_PythonToCpp_QGLFramebufferObjectFormat_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QGLFramebufferObjectFormat_PTR_CppToPython_QGLFramebufferObjectFormat(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QGLFramebufferObjectFormat *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QGLFramebufferObjectFormat_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QGLFramebufferObjectFormat_COPY_CppToPython_QGLFramebufferObjectFormat(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QGLFramebufferObjectFormat_TypeF(), new ::QGLFramebufferObjectFormat(*reinterpret_cast<const ::QGLFramebufferObjectFormat *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QGLFramebufferObjectFormat_PythonToCpp_QGLFramebufferObjectFormat_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGLFramebufferObjectFormat *>(cppOut) = *reinterpret_cast< ::QGLFramebufferObjectFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECTFORMAT_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QGLFramebufferObjectFormat_PythonToCpp_QGLFramebufferObjectFormat_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGLFramebufferObjectFormat_TypeF())))
        return QGLFramebufferObjectFormat_PythonToCpp_QGLFramebufferObjectFormat_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QGLFramebufferObjectFormat_SignatureStrings[] = {
    "1:PySide2.QtOpenGL.QGLFramebufferObjectFormat(self)",
    "0:PySide2.QtOpenGL.QGLFramebufferObjectFormat(self,other:PySide2.QtOpenGL.QGLFramebufferObjectFormat)",
    "PySide2.QtOpenGL.QGLFramebufferObjectFormat.attachment(self)->PySide2.QtOpenGL.QGLFramebufferObject.Attachment",
    "PySide2.QtOpenGL.QGLFramebufferObjectFormat.internalTextureFormat(self)->GLenum",
    "PySide2.QtOpenGL.QGLFramebufferObjectFormat.mipmap(self)->bool",
    "PySide2.QtOpenGL.QGLFramebufferObjectFormat.samples(self)->int",
    "PySide2.QtOpenGL.QGLFramebufferObjectFormat.setAttachment(self,attachment:PySide2.QtOpenGL.QGLFramebufferObject.Attachment)",
    "PySide2.QtOpenGL.QGLFramebufferObjectFormat.setInternalTextureFormat(self,internalTextureFormat:GLenum)",
    "PySide2.QtOpenGL.QGLFramebufferObjectFormat.setMipmap(self,enabled:bool)",
    "PySide2.QtOpenGL.QGLFramebufferObjectFormat.setSamples(self,samples:int)",
    "PySide2.QtOpenGL.QGLFramebufferObjectFormat.setTextureTarget(self,target:GLenum)",
    "PySide2.QtOpenGL.QGLFramebufferObjectFormat.textureTarget(self)->GLenum",
    "PySide2.QtOpenGL.QGLFramebufferObjectFormat.__copy__()",
    nullptr}; // Sentinel

void init_QGLFramebufferObjectFormat(PyObject *module)
{
    _Sbk_QGLFramebufferObjectFormat_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QGLFramebufferObjectFormat",
        "QGLFramebufferObjectFormat",
        &Sbk_QGLFramebufferObjectFormat_spec,
        &Shiboken::callCppDestructor< ::QGLFramebufferObjectFormat >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QGLFramebufferObjectFormat_Type);
    InitSignatureStrings(pyType, QGLFramebufferObjectFormat_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QGLFramebufferObjectFormat_Type), Sbk_QGLFramebufferObjectFormat_PropertyStrings);
    SbkPySide2_QtOpenGLTypes[SBK_QGLFRAMEBUFFEROBJECTFORMAT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QGLFramebufferObjectFormat_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QGLFramebufferObjectFormat_TypeF(),
        QGLFramebufferObjectFormat_PythonToCpp_QGLFramebufferObjectFormat_PTR,
        is_QGLFramebufferObjectFormat_PythonToCpp_QGLFramebufferObjectFormat_PTR_Convertible,
        QGLFramebufferObjectFormat_PTR_CppToPython_QGLFramebufferObjectFormat,
        QGLFramebufferObjectFormat_COPY_CppToPython_QGLFramebufferObjectFormat);

    Shiboken::Conversions::registerConverterName(converter, "QGLFramebufferObjectFormat");
    Shiboken::Conversions::registerConverterName(converter, "QGLFramebufferObjectFormat*");
    Shiboken::Conversions::registerConverterName(converter, "QGLFramebufferObjectFormat&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGLFramebufferObjectFormat).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QGLFramebufferObjectFormat_PythonToCpp_QGLFramebufferObjectFormat_COPY,
        is_QGLFramebufferObjectFormat_PythonToCpp_QGLFramebufferObjectFormat_COPY_Convertible);

    qRegisterMetaType< ::QGLFramebufferObjectFormat >("QGLFramebufferObjectFormat");
}
