/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtopengl_python.h"

// main header
#include "qglformat_wrapper.h"

// inner classes

// Extra includes
#include <QtGui/qsurfaceformat.h>
#include <QtOpenGL/qgl.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QGLFormat_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QGLFormat >()))
        return -1;

    ::QGLFormat *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGLFormat_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:QGLFormat", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QGLFormat::QGLFormat()
    // 1: QGLFormat::QGLFormat(QFlags<QGL::FormatOption>,int)
    // 2: QGLFormat::QGLFormat(QGLFormat)
    if (numArgs == 0) {
        overloadId = 0; // QGLFormat()
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGL_FORMATOPTION_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // QGLFormat(QFlags<QGL::FormatOption>,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 1; // QGLFormat(QFlags<QGL::FormatOption>,int)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QGLFormat(QGLFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLFormat_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QGLFormat()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QGLFormat_Init_TypeError;
            }

            if (!PyErr_Occurred()) {
                // QGLFormat()
                cptr = new ::QGLFormat();
            }
            break;
        }
        case 1: // QGLFormat(QFlags<QGL::FormatOption> options, int plane)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_plane = Shiboken::String::createStaticString("plane");
                if (PyDict_Contains(kwds, key_plane)) {
                    value = PyDict_GetItem(kwds, key_plane);
                    if (value && pyArgs[1]) {
                        errInfo = key_plane;
                        Py_INCREF(errInfo);
                        goto Sbk_QGLFormat_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                            goto Sbk_QGLFormat_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_plane);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGLFormat_Init_TypeError;
                }
            }
            ::QFlags<QGL::FormatOption> cppArg0 = QFlags<QGL::FormatOption>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1 = 0;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QGLFormat(QFlags<QGL::FormatOption>,int)
                cptr = new ::QGLFormat(cppArg0, cppArg1);
            }
            break;
        }
        case 2: // QGLFormat(const QGLFormat & other)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QGLFormat_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QGLFormat cppArg0_local;
            ::QGLFormat *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QGLFormat(QGLFormat)
                cptr = new ::QGLFormat(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QGLFormat >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QGLFormat_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QGLFormat_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QGLFormatFunc_accum(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.accum";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // accum()const
            bool cppResult = const_cast<const ::QGLFormat *>(cppSelf)->accum();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFormatFunc_accumBufferSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.accumBufferSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // accumBufferSize()const
            int cppResult = const_cast<const ::QGLFormat *>(cppSelf)->accumBufferSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFormatFunc_alpha(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.alpha";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // alpha()const
            bool cppResult = const_cast<const ::QGLFormat *>(cppSelf)->alpha();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFormatFunc_alphaBufferSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.alphaBufferSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // alphaBufferSize()const
            int cppResult = const_cast<const ::QGLFormat *>(cppSelf)->alphaBufferSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFormatFunc_blueBufferSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.blueBufferSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // blueBufferSize()const
            int cppResult = const_cast<const ::QGLFormat *>(cppSelf)->blueBufferSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFormatFunc_defaultFormat(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.defaultFormat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultFormat()
            QGLFormat cppResult = ::QGLFormat::defaultFormat();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFormatFunc_defaultOverlayFormat(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.defaultOverlayFormat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultOverlayFormat()
            QGLFormat cppResult = ::QGLFormat::defaultOverlayFormat();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFormatFunc_depth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.depth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // depth()const
            bool cppResult = const_cast<const ::QGLFormat *>(cppSelf)->depth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFormatFunc_depthBufferSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.depthBufferSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // depthBufferSize()const
            int cppResult = const_cast<const ::QGLFormat *>(cppSelf)->depthBufferSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFormatFunc_directRendering(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.directRendering";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // directRendering()const
            bool cppResult = const_cast<const ::QGLFormat *>(cppSelf)->directRendering();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFormatFunc_doubleBuffer(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.doubleBuffer";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // doubleBuffer()const
            bool cppResult = const_cast<const ::QGLFormat *>(cppSelf)->doubleBuffer();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFormatFunc_fromSurfaceFormat(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.fromSurfaceFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QGLFormat::fromSurfaceFormat(QSurfaceFormat)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX]), (pyArg)))) {
        overloadId = 0; // fromSurfaceFormat(QSurfaceFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLFormatFunc_fromSurfaceFormat_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSurfaceFormat cppArg0_local;
        ::QSurfaceFormat *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // fromSurfaceFormat(QSurfaceFormat)
            QGLFormat cppResult = ::QGLFormat::fromSurfaceFormat(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGLFormatFunc_fromSurfaceFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLFormatFunc_greenBufferSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.greenBufferSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // greenBufferSize()const
            int cppResult = const_cast<const ::QGLFormat *>(cppSelf)->greenBufferSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFormatFunc_hasOpenGL(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.hasOpenGL";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasOpenGL()
            bool cppResult = ::QGLFormat::hasOpenGL();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFormatFunc_hasOpenGLOverlays(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.hasOpenGLOverlays";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasOpenGLOverlays()
            bool cppResult = ::QGLFormat::hasOpenGLOverlays();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFormatFunc_hasOverlay(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.hasOverlay";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasOverlay()const
            bool cppResult = const_cast<const ::QGLFormat *>(cppSelf)->hasOverlay();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFormatFunc_majorVersion(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.majorVersion";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // majorVersion()const
            int cppResult = const_cast<const ::QGLFormat *>(cppSelf)->majorVersion();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFormatFunc_minorVersion(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.minorVersion";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // minorVersion()const
            int cppResult = const_cast<const ::QGLFormat *>(cppSelf)->minorVersion();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFormatFunc_openGLVersionFlags(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.openGLVersionFlags";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // openGLVersionFlags()
            QFlags<QGLFormat::OpenGLVersionFlag> cppResult = ::QGLFormat::openGLVersionFlags();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGLFORMAT_OPENGLVERSIONFLAG_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFormatFunc_plane(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.plane";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // plane()const
            int cppResult = const_cast<const ::QGLFormat *>(cppSelf)->plane();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFormatFunc_profile(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.profile";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // profile()const
            QGLFormat::OpenGLContextProfile cppResult = const_cast<const ::QGLFormat *>(cppSelf)->profile();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLCONTEXTPROFILE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFormatFunc_redBufferSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.redBufferSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // redBufferSize()const
            int cppResult = const_cast<const ::QGLFormat *>(cppSelf)->redBufferSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFormatFunc_rgba(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.rgba";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rgba()const
            bool cppResult = const_cast<const ::QGLFormat *>(cppSelf)->rgba();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFormatFunc_sampleBuffers(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.sampleBuffers";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sampleBuffers()const
            bool cppResult = const_cast<const ::QGLFormat *>(cppSelf)->sampleBuffers();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFormatFunc_samples(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.samples";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // samples()const
            int cppResult = const_cast<const ::QGLFormat *>(cppSelf)->samples();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFormatFunc_setAccum(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.setAccum";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLFormat::setAccum(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAccum(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLFormatFunc_setAccum_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAccum(bool)
            cppSelf->setAccum(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLFormatFunc_setAccum_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLFormatFunc_setAccumBufferSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.setAccumBufferSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLFormat::setAccumBufferSize(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setAccumBufferSize(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLFormatFunc_setAccumBufferSize_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAccumBufferSize(int)
            cppSelf->setAccumBufferSize(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLFormatFunc_setAccumBufferSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLFormatFunc_setAlpha(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.setAlpha";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLFormat::setAlpha(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAlpha(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLFormatFunc_setAlpha_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAlpha(bool)
            cppSelf->setAlpha(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLFormatFunc_setAlpha_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLFormatFunc_setAlphaBufferSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.setAlphaBufferSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLFormat::setAlphaBufferSize(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setAlphaBufferSize(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLFormatFunc_setAlphaBufferSize_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAlphaBufferSize(int)
            cppSelf->setAlphaBufferSize(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLFormatFunc_setAlphaBufferSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLFormatFunc_setBlueBufferSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.setBlueBufferSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLFormat::setBlueBufferSize(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setBlueBufferSize(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLFormatFunc_setBlueBufferSize_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setBlueBufferSize(int)
            cppSelf->setBlueBufferSize(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLFormatFunc_setBlueBufferSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLFormatFunc_setDefaultFormat(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.setDefaultFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QGLFormat::setDefaultFormat(QGLFormat)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX]), (pyArg)))) {
        overloadId = 0; // setDefaultFormat(QGLFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLFormatFunc_setDefaultFormat_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGLFormat cppArg0_local;
        ::QGLFormat *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setDefaultFormat(QGLFormat)
            ::QGLFormat::setDefaultFormat(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLFormatFunc_setDefaultFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLFormatFunc_setDefaultOverlayFormat(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.setDefaultOverlayFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QGLFormat::setDefaultOverlayFormat(QGLFormat)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX]), (pyArg)))) {
        overloadId = 0; // setDefaultOverlayFormat(QGLFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLFormatFunc_setDefaultOverlayFormat_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGLFormat cppArg0_local;
        ::QGLFormat *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setDefaultOverlayFormat(QGLFormat)
            ::QGLFormat::setDefaultOverlayFormat(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLFormatFunc_setDefaultOverlayFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLFormatFunc_setDepth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.setDepth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLFormat::setDepth(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setDepth(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLFormatFunc_setDepth_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDepth(bool)
            cppSelf->setDepth(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLFormatFunc_setDepth_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLFormatFunc_setDepthBufferSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.setDepthBufferSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLFormat::setDepthBufferSize(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setDepthBufferSize(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLFormatFunc_setDepthBufferSize_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDepthBufferSize(int)
            cppSelf->setDepthBufferSize(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLFormatFunc_setDepthBufferSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLFormatFunc_setDirectRendering(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.setDirectRendering";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLFormat::setDirectRendering(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setDirectRendering(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLFormatFunc_setDirectRendering_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDirectRendering(bool)
            cppSelf->setDirectRendering(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLFormatFunc_setDirectRendering_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLFormatFunc_setDoubleBuffer(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.setDoubleBuffer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLFormat::setDoubleBuffer(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setDoubleBuffer(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLFormatFunc_setDoubleBuffer_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDoubleBuffer(bool)
            cppSelf->setDoubleBuffer(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLFormatFunc_setDoubleBuffer_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLFormatFunc_setGreenBufferSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.setGreenBufferSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLFormat::setGreenBufferSize(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setGreenBufferSize(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLFormatFunc_setGreenBufferSize_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setGreenBufferSize(int)
            cppSelf->setGreenBufferSize(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLFormatFunc_setGreenBufferSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLFormatFunc_setOption(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.setOption";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLFormat::setOption(QFlags<QGL::FormatOption>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGL_FORMATOPTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setOption(QFlags<QGL::FormatOption>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLFormatFunc_setOption_TypeError;

    // Call function/method
    {
        ::QFlags<QGL::FormatOption> cppArg0 = QFlags<QGL::FormatOption>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setOption(QFlags<QGL::FormatOption>)
            cppSelf->setOption(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLFormatFunc_setOption_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLFormatFunc_setOverlay(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.setOverlay";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLFormat::setOverlay(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setOverlay(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLFormatFunc_setOverlay_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setOverlay(bool)
            cppSelf->setOverlay(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLFormatFunc_setOverlay_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLFormatFunc_setPlane(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.setPlane";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLFormat::setPlane(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setPlane(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLFormatFunc_setPlane_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPlane(int)
            cppSelf->setPlane(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLFormatFunc_setPlane_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLFormatFunc_setProfile(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.setProfile";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLFormat::setProfile(QGLFormat::OpenGLContextProfile)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLCONTEXTPROFILE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setProfile(QGLFormat::OpenGLContextProfile)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLFormatFunc_setProfile_TypeError;

    // Call function/method
    {
        ::QGLFormat::OpenGLContextProfile cppArg0{QGLFormat::NoProfile};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setProfile(QGLFormat::OpenGLContextProfile)
            cppSelf->setProfile(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLFormatFunc_setProfile_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLFormatFunc_setRedBufferSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.setRedBufferSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLFormat::setRedBufferSize(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setRedBufferSize(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLFormatFunc_setRedBufferSize_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRedBufferSize(int)
            cppSelf->setRedBufferSize(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLFormatFunc_setRedBufferSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLFormatFunc_setRgba(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.setRgba";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLFormat::setRgba(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setRgba(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLFormatFunc_setRgba_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRgba(bool)
            cppSelf->setRgba(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLFormatFunc_setRgba_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLFormatFunc_setSampleBuffers(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.setSampleBuffers";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLFormat::setSampleBuffers(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setSampleBuffers(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLFormatFunc_setSampleBuffers_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSampleBuffers(bool)
            cppSelf->setSampleBuffers(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLFormatFunc_setSampleBuffers_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLFormatFunc_setSamples(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.setSamples";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLFormat::setSamples(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setSamples(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLFormatFunc_setSamples_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSamples(int)
            cppSelf->setSamples(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLFormatFunc_setSamples_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLFormatFunc_setStencil(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.setStencil";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLFormat::setStencil(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setStencil(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLFormatFunc_setStencil_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setStencil(bool)
            cppSelf->setStencil(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLFormatFunc_setStencil_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLFormatFunc_setStencilBufferSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.setStencilBufferSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLFormat::setStencilBufferSize(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setStencilBufferSize(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLFormatFunc_setStencilBufferSize_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setStencilBufferSize(int)
            cppSelf->setStencilBufferSize(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLFormatFunc_setStencilBufferSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLFormatFunc_setStereo(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.setStereo";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLFormat::setStereo(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setStereo(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLFormatFunc_setStereo_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setStereo(bool)
            cppSelf->setStereo(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLFormatFunc_setStereo_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLFormatFunc_setSwapInterval(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.setSwapInterval";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLFormat::setSwapInterval(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setSwapInterval(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLFormatFunc_setSwapInterval_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSwapInterval(int)
            cppSelf->setSwapInterval(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLFormatFunc_setSwapInterval_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLFormatFunc_setVersion(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.setVersion";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setVersion", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGLFormat::setVersion(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // setVersion(int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLFormatFunc_setVersion_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setVersion(int,int)
            cppSelf->setVersion(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLFormatFunc_setVersion_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLFormatFunc_stencil(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.stencil";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // stencil()const
            bool cppResult = const_cast<const ::QGLFormat *>(cppSelf)->stencil();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFormatFunc_stencilBufferSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.stencilBufferSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // stencilBufferSize()const
            int cppResult = const_cast<const ::QGLFormat *>(cppSelf)->stencilBufferSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFormatFunc_stereo(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.stereo";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // stereo()const
            bool cppResult = const_cast<const ::QGLFormat *>(cppSelf)->stereo();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFormatFunc_swapInterval(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.swapInterval";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // swapInterval()const
            int cppResult = const_cast<const ::QGLFormat *>(cppSelf)->swapInterval();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLFormatFunc_testOption(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.testOption";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLFormat::testOption(QFlags<QGL::FormatOption>)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGL_FORMATOPTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // testOption(QFlags<QGL::FormatOption>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLFormatFunc_testOption_TypeError;

    // Call function/method
    {
        ::QFlags<QGL::FormatOption> cppArg0 = QFlags<QGL::FormatOption>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // testOption(QFlags<QGL::FormatOption>)const
            bool cppResult = const_cast<const ::QGLFormat *>(cppSelf)->testOption(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGLFormatFunc_testOption_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLFormatFunc_toSurfaceFormat(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLFormat.toSurfaceFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QGLFormat::toSurfaceFormat(QGLFormat)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX]), (pyArg)))) {
        overloadId = 0; // toSurfaceFormat(QGLFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLFormatFunc_toSurfaceFormat_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGLFormat cppArg0_local;
        ::QGLFormat *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // toSurfaceFormat(QGLFormat)
            QSurfaceFormat cppResult = ::QGLFormat::toSurfaceFormat(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGLFormatFunc_toSurfaceFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLFormat___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QGLFormat_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QGLFormat_methods[] = {
    {"accum", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_accum), METH_NOARGS},
    {"accumBufferSize", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_accumBufferSize), METH_NOARGS},
    {"alpha", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_alpha), METH_NOARGS},
    {"alphaBufferSize", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_alphaBufferSize), METH_NOARGS},
    {"blueBufferSize", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_blueBufferSize), METH_NOARGS},
    {"defaultFormat", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_defaultFormat), METH_NOARGS|METH_STATIC},
    {"defaultOverlayFormat", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_defaultOverlayFormat), METH_NOARGS|METH_STATIC},
    {"depth", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_depth), METH_NOARGS},
    {"depthBufferSize", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_depthBufferSize), METH_NOARGS},
    {"directRendering", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_directRendering), METH_NOARGS},
    {"doubleBuffer", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_doubleBuffer), METH_NOARGS},
    {"fromSurfaceFormat", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_fromSurfaceFormat), METH_O|METH_STATIC},
    {"greenBufferSize", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_greenBufferSize), METH_NOARGS},
    {"hasOpenGL", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_hasOpenGL), METH_NOARGS|METH_STATIC},
    {"hasOpenGLOverlays", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_hasOpenGLOverlays), METH_NOARGS|METH_STATIC},
    {"hasOverlay", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_hasOverlay), METH_NOARGS},
    {"majorVersion", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_majorVersion), METH_NOARGS},
    {"minorVersion", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_minorVersion), METH_NOARGS},
    {"openGLVersionFlags", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_openGLVersionFlags), METH_NOARGS|METH_STATIC},
    {"plane", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_plane), METH_NOARGS},
    {"profile", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_profile), METH_NOARGS},
    {"redBufferSize", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_redBufferSize), METH_NOARGS},
    {"rgba", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_rgba), METH_NOARGS},
    {"sampleBuffers", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_sampleBuffers), METH_NOARGS},
    {"samples", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_samples), METH_NOARGS},
    {"setAccum", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_setAccum), METH_O},
    {"setAccumBufferSize", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_setAccumBufferSize), METH_O},
    {"setAlpha", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_setAlpha), METH_O},
    {"setAlphaBufferSize", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_setAlphaBufferSize), METH_O},
    {"setBlueBufferSize", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_setBlueBufferSize), METH_O},
    {"setDefaultFormat", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_setDefaultFormat), METH_O|METH_STATIC},
    {"setDefaultOverlayFormat", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_setDefaultOverlayFormat), METH_O|METH_STATIC},
    {"setDepth", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_setDepth), METH_O},
    {"setDepthBufferSize", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_setDepthBufferSize), METH_O},
    {"setDirectRendering", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_setDirectRendering), METH_O},
    {"setDoubleBuffer", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_setDoubleBuffer), METH_O},
    {"setGreenBufferSize", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_setGreenBufferSize), METH_O},
    {"setOption", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_setOption), METH_O},
    {"setOverlay", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_setOverlay), METH_O},
    {"setPlane", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_setPlane), METH_O},
    {"setProfile", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_setProfile), METH_O},
    {"setRedBufferSize", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_setRedBufferSize), METH_O},
    {"setRgba", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_setRgba), METH_O},
    {"setSampleBuffers", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_setSampleBuffers), METH_O},
    {"setSamples", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_setSamples), METH_O},
    {"setStencil", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_setStencil), METH_O},
    {"setStencilBufferSize", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_setStencilBufferSize), METH_O},
    {"setStereo", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_setStereo), METH_O},
    {"setSwapInterval", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_setSwapInterval), METH_O},
    {"setVersion", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_setVersion), METH_VARARGS},
    {"stencil", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_stencil), METH_NOARGS},
    {"stencilBufferSize", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_stencilBufferSize), METH_NOARGS},
    {"stereo", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_stereo), METH_NOARGS},
    {"swapInterval", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_swapInterval), METH_NOARGS},
    {"testOption", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_testOption), METH_O},
    {"toSurfaceFormat", reinterpret_cast<PyCFunction>(Sbk_QGLFormatFunc_toSurfaceFormat), METH_O|METH_STATIC},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QGLFormat___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QGLFormat_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX]), (pyArg)))) {
                // operator!=(const QGLFormat & arg__2)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QGLFormat cppArg0_local;
                ::QGLFormat *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX]), (pyArg)))) {
                // operator==(const QGLFormat & arg__2)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QGLFormat cppArg0_local;
                ::QGLFormat *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QGLFormat_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QGLFormat_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QGLFormat_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QGLFormat_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QGLFormat__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QGLFormat_Type = nullptr;
static SbkObjectType *Sbk_QGLFormat_TypeF(void)
{
    return _Sbk_QGLFormat_Type;
}

static PyType_Slot Sbk_QGLFormat_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QGLFormat__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QGLFormat_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QGLFormat_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QGLFormat_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QGLFormat_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QGLFormat_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QGLFormat_spec = {
    "2:PySide2.QtOpenGL.QGLFormat",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QGLFormat_slots
};

} //extern "C"

PyObject *SbkPySide2_QtOpenGL_QGLFormat_OpenGLVersionFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::QGLFormat::OpenGLVersionFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGLFormat::OpenGLVersionFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGLFormat::OpenGLVersionFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGLFormat::OpenGLVersionFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGLFormat::OpenGLVersionFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGLFORMAT_OPENGLVERSIONFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtOpenGL_QGLFormat_OpenGLVersionFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::QGLFormat::OpenGLVersionFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGLFormat::OpenGLVersionFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGLFormat::OpenGLVersionFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGLFormat::OpenGLVersionFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGLFormat::OpenGLVersionFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGLFORMAT_OPENGLVERSIONFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtOpenGL_QGLFormat_OpenGLVersionFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QGLFormat::OpenGLVersionFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGLFormat::OpenGLVersionFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGLFormat::OpenGLVersionFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGLFormat::OpenGLVersionFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGLFormat::OpenGLVersionFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGLFORMAT_OPENGLVERSIONFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtOpenGL_QGLFormat_OpenGLVersionFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QGLFormat::OpenGLVersionFlags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGLFORMAT_OPENGLVERSIONFLAG_IDX])->converter, self, &cppSelf);
    ::QGLFormat::OpenGLVersionFlags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGLFORMAT_OPENGLVERSIONFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtOpenGL_QGLFormat_OpenGLVersionFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGLFORMAT_OPENGLVERSIONFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtOpenGL_QGLFormat_OpenGLVersionFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGLFORMAT_OPENGLVERSIONFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtOpenGL_QGLFormat_OpenGLVersionFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtOpenGL_QGLFormat_OpenGLVersionFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtOpenGL_QGLFormat_OpenGLVersionFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtOpenGL_QGLFormat_OpenGLVersionFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtOpenGL_QGLFormat_OpenGLVersionFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtOpenGL_QGLFormat_OpenGLVersionFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtOpenGL_QGLFormat_OpenGLVersionFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtOpenGL_QGLFormat_OpenGLVersionFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtOpenGL_QGLFormat_OpenGLVersionFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtOpenGL_QGLFormat_OpenGLVersionFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtOpenGL_QGLFormat_OpenGLVersionFlag_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QGLFormat_OpenGLContextProfile_PythonToCpp_QGLFormat_OpenGLContextProfile(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGLFormat::OpenGLContextProfile *>(cppOut) =
        static_cast<::QGLFormat::OpenGLContextProfile>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGLFormat_OpenGLContextProfile_PythonToCpp_QGLFormat_OpenGLContextProfile_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLCONTEXTPROFILE_IDX]))
        return QGLFormat_OpenGLContextProfile_PythonToCpp_QGLFormat_OpenGLContextProfile;
    return {};
}
static PyObject *QGLFormat_OpenGLContextProfile_CppToPython_QGLFormat_OpenGLContextProfile(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGLFormat::OpenGLContextProfile *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLCONTEXTPROFILE_IDX], castCppIn);

}

static void QGLFormat_OpenGLVersionFlag_PythonToCpp_QGLFormat_OpenGLVersionFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGLFormat::OpenGLVersionFlag *>(cppOut) =
        static_cast<::QGLFormat::OpenGLVersionFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGLFormat_OpenGLVersionFlag_PythonToCpp_QGLFormat_OpenGLVersionFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLVERSIONFLAG_IDX]))
        return QGLFormat_OpenGLVersionFlag_PythonToCpp_QGLFormat_OpenGLVersionFlag;
    return {};
}
static PyObject *QGLFormat_OpenGLVersionFlag_CppToPython_QGLFormat_OpenGLVersionFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGLFormat::OpenGLVersionFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLVERSIONFLAG_IDX], castCppIn);

}

static void QFlags_QGLFormat_OpenGLVersionFlag__PythonToCpp_QFlags_QGLFormat_OpenGLVersionFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QGLFormat::OpenGLVersionFlag> *>(cppOut) =
        ::QFlags<QGLFormat::OpenGLVersionFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QGLFormat_OpenGLVersionFlag__PythonToCpp_QFlags_QGLFormat_OpenGLVersionFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGLFORMAT_OPENGLVERSIONFLAG_IDX]))
        return QFlags_QGLFormat_OpenGLVersionFlag__PythonToCpp_QFlags_QGLFormat_OpenGLVersionFlag_;
    return {};
}
static PyObject *QFlags_QGLFormat_OpenGLVersionFlag__CppToPython_QFlags_QGLFormat_OpenGLVersionFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QGLFormat::OpenGLVersionFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGLFORMAT_OPENGLVERSIONFLAG_IDX]));

}

static void QGLFormat_OpenGLVersionFlag_PythonToCpp_QFlags_QGLFormat_OpenGLVersionFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QGLFormat::OpenGLVersionFlag> *>(cppOut) =
        ::QFlags<QGLFormat::OpenGLVersionFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QGLFormat_OpenGLVersionFlag_PythonToCpp_QFlags_QGLFormat_OpenGLVersionFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLVERSIONFLAG_IDX]))
        return QGLFormat_OpenGLVersionFlag_PythonToCpp_QFlags_QGLFormat_OpenGLVersionFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_QGLFormat_OpenGLVersionFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QGLFormat::OpenGLVersionFlag> *>(cppOut) =
        ::QFlags<QGLFormat::OpenGLVersionFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QGLFormat_OpenGLVersionFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLVERSIONFLAG_IDX]))
        return number_PythonToCpp_QFlags_QGLFormat_OpenGLVersionFlag_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QGLFormat_PythonToCpp_QGLFormat_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QGLFormat_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QGLFormat_PythonToCpp_QGLFormat_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGLFormat_TypeF())))
        return QGLFormat_PythonToCpp_QGLFormat_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QGLFormat_PTR_CppToPython_QGLFormat(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QGLFormat *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QGLFormat_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QGLFormat_COPY_CppToPython_QGLFormat(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QGLFormat_TypeF(), new ::QGLFormat(*reinterpret_cast<const ::QGLFormat *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QGLFormat_PythonToCpp_QGLFormat_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGLFormat *>(cppOut) = *reinterpret_cast< ::QGLFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QGLFormat_PythonToCpp_QGLFormat_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGLFormat_TypeF())))
        return QGLFormat_PythonToCpp_QGLFormat_COPY;
    return {};
}

// Implicit conversions.
static void QFlags_QGL_FormatOption__PythonToCpp_QGLFormat(PyObject *pyIn, void *cppOut) {
    ::QFlags<QGL::FormatOption> cppIn = QFlags<QGL::FormatOption>(0);
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGL_FORMATOPTION_IDX])->converter, pyIn, &cppIn);
    *reinterpret_cast<::QGLFormat *>(cppOut) = ::QGLFormat(cppIn);
}
static PythonToCppFunc is_QFlags_QGL_FormatOption__PythonToCpp_QGLFormat_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGL_FORMATOPTION_IDX], pyIn))
        return QFlags_QGL_FormatOption__PythonToCpp_QGLFormat;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QGLFormat_SignatureStrings[] = {
    "2:PySide2.QtOpenGL.QGLFormat(self)",
    "1:PySide2.QtOpenGL.QGLFormat(self,options:PySide2.QtOpenGL.QGL.FormatOptions,plane:int=0)",
    "0:PySide2.QtOpenGL.QGLFormat(self,other:PySide2.QtOpenGL.QGLFormat)",
    "PySide2.QtOpenGL.QGLFormat.accum(self)->bool",
    "PySide2.QtOpenGL.QGLFormat.accumBufferSize(self)->int",
    "PySide2.QtOpenGL.QGLFormat.alpha(self)->bool",
    "PySide2.QtOpenGL.QGLFormat.alphaBufferSize(self)->int",
    "PySide2.QtOpenGL.QGLFormat.blueBufferSize(self)->int",
    "PySide2.QtOpenGL.QGLFormat.defaultFormat()->PySide2.QtOpenGL.QGLFormat",
    "PySide2.QtOpenGL.QGLFormat.defaultOverlayFormat()->PySide2.QtOpenGL.QGLFormat",
    "PySide2.QtOpenGL.QGLFormat.depth(self)->bool",
    "PySide2.QtOpenGL.QGLFormat.depthBufferSize(self)->int",
    "PySide2.QtOpenGL.QGLFormat.directRendering(self)->bool",
    "PySide2.QtOpenGL.QGLFormat.doubleBuffer(self)->bool",
    "PySide2.QtOpenGL.QGLFormat.fromSurfaceFormat(format:PySide2.QtGui.QSurfaceFormat)->PySide2.QtOpenGL.QGLFormat",
    "PySide2.QtOpenGL.QGLFormat.greenBufferSize(self)->int",
    "PySide2.QtOpenGL.QGLFormat.hasOpenGL()->bool",
    "PySide2.QtOpenGL.QGLFormat.hasOpenGLOverlays()->bool",
    "PySide2.QtOpenGL.QGLFormat.hasOverlay(self)->bool",
    "PySide2.QtOpenGL.QGLFormat.majorVersion(self)->int",
    "PySide2.QtOpenGL.QGLFormat.minorVersion(self)->int",
    "PySide2.QtOpenGL.QGLFormat.openGLVersionFlags()->PySide2.QtOpenGL.QGLFormat.OpenGLVersionFlags",
    "PySide2.QtOpenGL.QGLFormat.plane(self)->int",
    "PySide2.QtOpenGL.QGLFormat.profile(self)->PySide2.QtOpenGL.QGLFormat.OpenGLContextProfile",
    "PySide2.QtOpenGL.QGLFormat.redBufferSize(self)->int",
    "PySide2.QtOpenGL.QGLFormat.rgba(self)->bool",
    "PySide2.QtOpenGL.QGLFormat.sampleBuffers(self)->bool",
    "PySide2.QtOpenGL.QGLFormat.samples(self)->int",
    "PySide2.QtOpenGL.QGLFormat.setAccum(self,enable:bool)",
    "PySide2.QtOpenGL.QGLFormat.setAccumBufferSize(self,size:int)",
    "PySide2.QtOpenGL.QGLFormat.setAlpha(self,enable:bool)",
    "PySide2.QtOpenGL.QGLFormat.setAlphaBufferSize(self,size:int)",
    "PySide2.QtOpenGL.QGLFormat.setBlueBufferSize(self,size:int)",
    "PySide2.QtOpenGL.QGLFormat.setDefaultFormat(f:PySide2.QtOpenGL.QGLFormat)",
    "PySide2.QtOpenGL.QGLFormat.setDefaultOverlayFormat(f:PySide2.QtOpenGL.QGLFormat)",
    "PySide2.QtOpenGL.QGLFormat.setDepth(self,enable:bool)",
    "PySide2.QtOpenGL.QGLFormat.setDepthBufferSize(self,size:int)",
    "PySide2.QtOpenGL.QGLFormat.setDirectRendering(self,enable:bool)",
    "PySide2.QtOpenGL.QGLFormat.setDoubleBuffer(self,enable:bool)",
    "PySide2.QtOpenGL.QGLFormat.setGreenBufferSize(self,size:int)",
    "PySide2.QtOpenGL.QGLFormat.setOption(self,opt:PySide2.QtOpenGL.QGL.FormatOptions)",
    "PySide2.QtOpenGL.QGLFormat.setOverlay(self,enable:bool)",
    "PySide2.QtOpenGL.QGLFormat.setPlane(self,plane:int)",
    "PySide2.QtOpenGL.QGLFormat.setProfile(self,profile:PySide2.QtOpenGL.QGLFormat.OpenGLContextProfile)",
    "PySide2.QtOpenGL.QGLFormat.setRedBufferSize(self,size:int)",
    "PySide2.QtOpenGL.QGLFormat.setRgba(self,enable:bool)",
    "PySide2.QtOpenGL.QGLFormat.setSampleBuffers(self,enable:bool)",
    "PySide2.QtOpenGL.QGLFormat.setSamples(self,numSamples:int)",
    "PySide2.QtOpenGL.QGLFormat.setStencil(self,enable:bool)",
    "PySide2.QtOpenGL.QGLFormat.setStencilBufferSize(self,size:int)",
    "PySide2.QtOpenGL.QGLFormat.setStereo(self,enable:bool)",
    "PySide2.QtOpenGL.QGLFormat.setSwapInterval(self,interval:int)",
    "PySide2.QtOpenGL.QGLFormat.setVersion(self,major:int,minor:int)",
    "PySide2.QtOpenGL.QGLFormat.stencil(self)->bool",
    "PySide2.QtOpenGL.QGLFormat.stencilBufferSize(self)->int",
    "PySide2.QtOpenGL.QGLFormat.stereo(self)->bool",
    "PySide2.QtOpenGL.QGLFormat.swapInterval(self)->int",
    "PySide2.QtOpenGL.QGLFormat.testOption(self,opt:PySide2.QtOpenGL.QGL.FormatOptions)->bool",
    "PySide2.QtOpenGL.QGLFormat.toSurfaceFormat(format:PySide2.QtOpenGL.QGLFormat)->PySide2.QtGui.QSurfaceFormat",
    "PySide2.QtOpenGL.QGLFormat.__copy__()",
    nullptr}; // Sentinel

void init_QGLFormat(PyObject *module)
{
    _Sbk_QGLFormat_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QGLFormat",
        "QGLFormat",
        &Sbk_QGLFormat_spec,
        &Shiboken::callCppDestructor< ::QGLFormat >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QGLFormat_Type);
    InitSignatureStrings(pyType, QGLFormat_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QGLFormat_Type), Sbk_QGLFormat_PropertyStrings);
    SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QGLFormat_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QGLFormat_TypeF(),
        QGLFormat_PythonToCpp_QGLFormat_PTR,
        is_QGLFormat_PythonToCpp_QGLFormat_PTR_Convertible,
        QGLFormat_PTR_CppToPython_QGLFormat,
        QGLFormat_COPY_CppToPython_QGLFormat);

    Shiboken::Conversions::registerConverterName(converter, "QGLFormat");
    Shiboken::Conversions::registerConverterName(converter, "QGLFormat*");
    Shiboken::Conversions::registerConverterName(converter, "QGLFormat&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGLFormat).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QGLFormat_PythonToCpp_QGLFormat_COPY,
        is_QGLFormat_PythonToCpp_QGLFormat_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QFlags_QGL_FormatOption__PythonToCpp_QGLFormat,
        is_QFlags_QGL_FormatOption__PythonToCpp_QGLFormat_Convertible);

    // Initialization of enums.

    // Initialization of enum 'OpenGLContextProfile'.
    SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLCONTEXTPROFILE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGLFormat_TypeF(),
        "OpenGLContextProfile",
        "2:PySide2.QtOpenGL.QGLFormat.OpenGLContextProfile",
        "QGLFormat::OpenGLContextProfile");
    if (!SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLCONTEXTPROFILE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLCONTEXTPROFILE_IDX],
        Sbk_QGLFormat_TypeF(), "NoProfile", (long) QGLFormat::OpenGLContextProfile::NoProfile))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLCONTEXTPROFILE_IDX],
        Sbk_QGLFormat_TypeF(), "CoreProfile", (long) QGLFormat::OpenGLContextProfile::CoreProfile))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLCONTEXTPROFILE_IDX],
        Sbk_QGLFormat_TypeF(), "CompatibilityProfile", (long) QGLFormat::OpenGLContextProfile::CompatibilityProfile))
        return;
    // Register converter for enum 'QGLFormat::OpenGLContextProfile'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLCONTEXTPROFILE_IDX],
            QGLFormat_OpenGLContextProfile_CppToPython_QGLFormat_OpenGLContextProfile);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGLFormat_OpenGLContextProfile_PythonToCpp_QGLFormat_OpenGLContextProfile,
            is_QGLFormat_OpenGLContextProfile_PythonToCpp_QGLFormat_OpenGLContextProfile_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLCONTEXTPROFILE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGLFormat::OpenGLContextProfile");
        Shiboken::Conversions::registerConverterName(converter, "OpenGLContextProfile");
    }
    // End of 'OpenGLContextProfile' enum.

    // Initialization of enum 'OpenGLVersionFlag'.
    SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGLFORMAT_OPENGLVERSIONFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtOpenGL.QGLFormat.OpenGLVersionFlags", SbkPySide2_QtOpenGL_QGLFormat_OpenGLVersionFlag_number_slots);
    SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLVERSIONFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGLFormat_TypeF(),
        "OpenGLVersionFlag",
        "2:PySide2.QtOpenGL.QGLFormat.OpenGLVersionFlag",
        "QGLFormat::OpenGLVersionFlag",
        SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGLFORMAT_OPENGLVERSIONFLAG_IDX]);
    if (!SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLVERSIONFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLVERSIONFLAG_IDX],
        Sbk_QGLFormat_TypeF(), "OpenGL_Version_None", (long) QGLFormat::OpenGLVersionFlag::OpenGL_Version_None))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLVERSIONFLAG_IDX],
        Sbk_QGLFormat_TypeF(), "OpenGL_Version_1_1", (long) QGLFormat::OpenGLVersionFlag::OpenGL_Version_1_1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLVERSIONFLAG_IDX],
        Sbk_QGLFormat_TypeF(), "OpenGL_Version_1_2", (long) QGLFormat::OpenGLVersionFlag::OpenGL_Version_1_2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLVERSIONFLAG_IDX],
        Sbk_QGLFormat_TypeF(), "OpenGL_Version_1_3", (long) QGLFormat::OpenGLVersionFlag::OpenGL_Version_1_3))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLVERSIONFLAG_IDX],
        Sbk_QGLFormat_TypeF(), "OpenGL_Version_1_4", (long) QGLFormat::OpenGLVersionFlag::OpenGL_Version_1_4))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLVERSIONFLAG_IDX],
        Sbk_QGLFormat_TypeF(), "OpenGL_Version_1_5", (long) QGLFormat::OpenGLVersionFlag::OpenGL_Version_1_5))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLVERSIONFLAG_IDX],
        Sbk_QGLFormat_TypeF(), "OpenGL_Version_2_0", (long) QGLFormat::OpenGLVersionFlag::OpenGL_Version_2_0))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLVERSIONFLAG_IDX],
        Sbk_QGLFormat_TypeF(), "OpenGL_Version_2_1", (long) QGLFormat::OpenGLVersionFlag::OpenGL_Version_2_1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLVERSIONFLAG_IDX],
        Sbk_QGLFormat_TypeF(), "OpenGL_ES_Common_Version_1_0", (long) QGLFormat::OpenGLVersionFlag::OpenGL_ES_Common_Version_1_0))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLVERSIONFLAG_IDX],
        Sbk_QGLFormat_TypeF(), "OpenGL_ES_CommonLite_Version_1_0", (long) QGLFormat::OpenGLVersionFlag::OpenGL_ES_CommonLite_Version_1_0))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLVERSIONFLAG_IDX],
        Sbk_QGLFormat_TypeF(), "OpenGL_ES_Common_Version_1_1", (long) QGLFormat::OpenGLVersionFlag::OpenGL_ES_Common_Version_1_1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLVERSIONFLAG_IDX],
        Sbk_QGLFormat_TypeF(), "OpenGL_ES_CommonLite_Version_1_1", (long) QGLFormat::OpenGLVersionFlag::OpenGL_ES_CommonLite_Version_1_1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLVERSIONFLAG_IDX],
        Sbk_QGLFormat_TypeF(), "OpenGL_ES_Version_2_0", (long) QGLFormat::OpenGLVersionFlag::OpenGL_ES_Version_2_0))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLVERSIONFLAG_IDX],
        Sbk_QGLFormat_TypeF(), "OpenGL_Version_3_0", (long) QGLFormat::OpenGLVersionFlag::OpenGL_Version_3_0))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLVERSIONFLAG_IDX],
        Sbk_QGLFormat_TypeF(), "OpenGL_Version_3_1", (long) QGLFormat::OpenGLVersionFlag::OpenGL_Version_3_1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLVERSIONFLAG_IDX],
        Sbk_QGLFormat_TypeF(), "OpenGL_Version_3_2", (long) QGLFormat::OpenGLVersionFlag::OpenGL_Version_3_2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLVERSIONFLAG_IDX],
        Sbk_QGLFormat_TypeF(), "OpenGL_Version_3_3", (long) QGLFormat::OpenGLVersionFlag::OpenGL_Version_3_3))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLVERSIONFLAG_IDX],
        Sbk_QGLFormat_TypeF(), "OpenGL_Version_4_0", (long) QGLFormat::OpenGLVersionFlag::OpenGL_Version_4_0))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLVERSIONFLAG_IDX],
        Sbk_QGLFormat_TypeF(), "OpenGL_Version_4_1", (long) QGLFormat::OpenGLVersionFlag::OpenGL_Version_4_1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLVERSIONFLAG_IDX],
        Sbk_QGLFormat_TypeF(), "OpenGL_Version_4_2", (long) QGLFormat::OpenGLVersionFlag::OpenGL_Version_4_2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLVERSIONFLAG_IDX],
        Sbk_QGLFormat_TypeF(), "OpenGL_Version_4_3", (long) QGLFormat::OpenGLVersionFlag::OpenGL_Version_4_3))
        return;
    // Register converter for enum 'QGLFormat::OpenGLVersionFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLVERSIONFLAG_IDX],
            QGLFormat_OpenGLVersionFlag_CppToPython_QGLFormat_OpenGLVersionFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGLFormat_OpenGLVersionFlag_PythonToCpp_QGLFormat_OpenGLVersionFlag,
            is_QGLFormat_OpenGLVersionFlag_PythonToCpp_QGLFormat_OpenGLVersionFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_OPENGLVERSIONFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGLFormat::OpenGLVersionFlag");
        Shiboken::Conversions::registerConverterName(converter, "OpenGLVersionFlag");
    }
    // Register converter for flag 'QFlags<QGLFormat::OpenGLVersionFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGLFORMAT_OPENGLVERSIONFLAG_IDX],
            QFlags_QGLFormat_OpenGLVersionFlag__CppToPython_QFlags_QGLFormat_OpenGLVersionFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGLFormat_OpenGLVersionFlag_PythonToCpp_QFlags_QGLFormat_OpenGLVersionFlag_,
            is_QGLFormat_OpenGLVersionFlag_PythonToCpp_QFlags_QGLFormat_OpenGLVersionFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QGLFormat_OpenGLVersionFlag__PythonToCpp_QFlags_QGLFormat_OpenGLVersionFlag_,
            is_QFlags_QGLFormat_OpenGLVersionFlag__PythonToCpp_QFlags_QGLFormat_OpenGLVersionFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QGLFormat_OpenGLVersionFlag_,
            is_number_PythonToCpp_QFlags_QGLFormat_OpenGLVersionFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGLFORMAT_OPENGLVERSIONFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGLFormat::OpenGLVersionFlags");
        Shiboken::Conversions::registerConverterName(converter, "OpenGLVersionFlags");
    }
    // End of 'OpenGLVersionFlag' enum/flags.

    qRegisterMetaType< ::QGLFormat >("QGLFormat");
    qRegisterMetaType< ::QGLFormat::OpenGLContextProfile >("QGLFormat::OpenGLContextProfile");
    qRegisterMetaType< ::QGLFormat::OpenGLVersionFlag >("QGLFormat::OpenGLVersionFlag");
    qRegisterMetaType< ::QGLFormat::OpenGLVersionFlags >("QGLFormat::OpenGLVersionFlags");
}
