/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtopengl_python.h"

// main header
#include "qglcontext_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QGLContextWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QGLContextWrapper::QGLContextWrapper(const ::QGLFormat & format) : QGLContext(format)
{
    resetPyMethodCache();
    // ... middle
}

bool QGLContextWrapper::chooseContext(const ::QGLContext * shareContext)
{
    if (m_PyMethodCache[0])
        return this->::QGLContext::chooseContext(shareContext);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "chooseContext";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QGLContext::chooseContext(shareContext);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_IDX]), shareContext)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGLContext.chooseContext", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QGLContextWrapper::create(const ::QGLContext * shareContext)
{
    if (m_PyMethodCache[1])
        return this->::QGLContext::create(shareContext);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "create";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QGLContext::create(shareContext);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_IDX]), shareContext)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGLContext.create", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

void QGLContextWrapper::doneCurrent()
{
    if (m_PyMethodCache[2]) {
        return this->::QGLContext::doneCurrent();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "doneCurrent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QGLContext::doneCurrent();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QGLContextWrapper::makeCurrent()
{
    if (m_PyMethodCache[3]) {
        return this->::QGLContext::makeCurrent();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "makeCurrent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QGLContext::makeCurrent();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QGLContextWrapper::swapBuffers() const
{
    if (m_PyMethodCache[4]) {
        return this->::QGLContext::swapBuffers();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "swapBuffers";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QGLContext::swapBuffers();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

QGLContextWrapper::~QGLContextWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QGLContext_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QGLContext >()))
        return -1;

    ::QGLContextWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLContext.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QGLContext", 1, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QGLContext::QGLContext(QGLFormat)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QGLContext(QGLFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLContext_Init_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QGLFormat cppArg0_local;
        ::QGLFormat *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);


        if (!PyErr_Occurred()) {
            // QGLContext(QGLFormat)
            cptr = new ::QGLContextWrapper(*cppArg0);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QGLContext >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QGLContext_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QGLContext_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QGLContextFunc_areSharing(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLContext.areSharing";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "areSharing", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QGLContext::areSharing(const QGLContext*,const QGLContext*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_IDX]), (pyArgs[1])))) {
        overloadId = 0; // areSharing(const QGLContext*,const QGLContext*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLContextFunc_areSharing_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QGLContext *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QGLContext *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // areSharing(const QGLContext*,const QGLContext*)
            bool cppResult = ::QGLContext::areSharing(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGLContextFunc_areSharing_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLContextFunc_bindTexture(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLContext.bindTexture";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGLContextFunc_bindTexture_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QGLContextFunc_bindTexture_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:bindTexture", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QGLContext::bindTexture(QImage,GLenum,GLint)
    // 1: QGLContext::bindTexture(QImage,GLenum,GLint,QFlags<QGLContext::BindOption>)
    // 2: QGLContext::bindTexture(QPixmap,GLenum,GLint)
    // 3: QGLContext::bindTexture(QPixmap,GLenum,GLint,QFlags<QGLContext::BindOption>)
    // 4: QGLContext::bindTexture(QString)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 4; // bindTexture(QString)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // bindTexture(QImage,GLenum,GLint)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // bindTexture(QImage,GLenum,GLint)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLint>(), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // bindTexture(QImage,GLenum,GLint)
                } else if (numArgs == 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGLCONTEXT_BINDOPTION_IDX])->converter, (pyArgs[3])))) {
                    overloadId = 1; // bindTexture(QImage,GLenum,GLint,QFlags<QGLContext::BindOption>)
                }
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // bindTexture(QPixmap,GLenum,GLint)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 2; // bindTexture(QPixmap,GLenum,GLint)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLint>(), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 2; // bindTexture(QPixmap,GLenum,GLint)
                } else if (numArgs == 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGLCONTEXT_BINDOPTION_IDX])->converter, (pyArgs[3])))) {
                    overloadId = 3; // bindTexture(QPixmap,GLenum,GLint,QFlags<QGLContext::BindOption>)
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLContextFunc_bindTexture_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // bindTexture(const QImage & image, GLenum target, GLint format)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_target = Shiboken::String::createStaticString("target");
                if (PyDict_Contains(kwds, key_target)) {
                    value = PyDict_GetItem(kwds, key_target);
                    if (value && pyArgs[1]) {
                        errInfo = key_target;
                        Py_INCREF(errInfo);
                        goto Sbk_QGLContextFunc_bindTexture_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), (pyArgs[1]))))
                            goto Sbk_QGLContextFunc_bindTexture_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_target);
                }
                static PyObject *const key_format = Shiboken::String::createStaticString("format");
                if (PyDict_Contains(kwds, key_format)) {
                    value = PyDict_GetItem(kwds, key_format);
                    if (value && pyArgs[2]) {
                        errInfo = key_format;
                        Py_INCREF(errInfo);
                        goto Sbk_QGLContextFunc_bindTexture_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLint>(), (pyArgs[2]))))
                            goto Sbk_QGLContextFunc_bindTexture_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_format);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGLContextFunc_bindTexture_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QImage cppArg0_local;
            ::QImage *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            GLenum cppArg1 = GL_TEXTURE_2D;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            GLint cppArg2 = GL_RGBA;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // bindTexture(QImage,GLenum,GLint)
                GLuint cppResult = cppSelf->bindTexture(*cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<GLuint>(), &cppResult);
            }
            break;
        }
        case 1: // bindTexture(const QImage & image, GLenum target, GLint format, QFlags<QGLContext::BindOption> options)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QGLContextFunc_bindTexture_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QImage cppArg0_local;
            ::QImage *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            GLenum cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            GLint cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QFlags<QGLContext::BindOption> cppArg3 = QFlags<QGLContext::BindOption>(0);
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // bindTexture(QImage,GLenum,GLint,QFlags<QGLContext::BindOption>)
                GLuint cppResult = cppSelf->bindTexture(*cppArg0, cppArg1, cppArg2, cppArg3);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<GLuint>(), &cppResult);
            }
            break;
        }
        case 2: // bindTexture(const QPixmap & pixmap, GLenum target, GLint format)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_target = Shiboken::String::createStaticString("target");
                if (PyDict_Contains(kwds, key_target)) {
                    value = PyDict_GetItem(kwds, key_target);
                    if (value && pyArgs[1]) {
                        errInfo = key_target;
                        Py_INCREF(errInfo);
                        goto Sbk_QGLContextFunc_bindTexture_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), (pyArgs[1]))))
                            goto Sbk_QGLContextFunc_bindTexture_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_target);
                }
                static PyObject *const key_format = Shiboken::String::createStaticString("format");
                if (PyDict_Contains(kwds, key_format)) {
                    value = PyDict_GetItem(kwds, key_format);
                    if (value && pyArgs[2]) {
                        errInfo = key_format;
                        Py_INCREF(errInfo);
                        goto Sbk_QGLContextFunc_bindTexture_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLint>(), (pyArgs[2]))))
                            goto Sbk_QGLContextFunc_bindTexture_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_format);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGLContextFunc_bindTexture_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPixmap cppArg0_local;
            ::QPixmap *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            GLenum cppArg1 = GL_TEXTURE_2D;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            GLint cppArg2 = GL_RGBA;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // bindTexture(QPixmap,GLenum,GLint)
                GLuint cppResult = cppSelf->bindTexture(*cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<GLuint>(), &cppResult);
            }
            break;
        }
        case 3: // bindTexture(const QPixmap & pixmap, GLenum target, GLint format, QFlags<QGLContext::BindOption> options)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QGLContextFunc_bindTexture_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPixmap cppArg0_local;
            ::QPixmap *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            GLenum cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            GLint cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QFlags<QGLContext::BindOption> cppArg3 = QFlags<QGLContext::BindOption>(0);
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // bindTexture(QPixmap,GLenum,GLint,QFlags<QGLContext::BindOption>)
                GLuint cppResult = cppSelf->bindTexture(*cppArg0, cppArg1, cppArg2, cppArg3);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<GLuint>(), &cppResult);
            }
            break;
        }
        case 4: // bindTexture(const QString & fileName)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QGLContextFunc_bindTexture_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // bindTexture(QString)
                GLuint cppResult = cppSelf->bindTexture(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<GLuint>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGLContextFunc_bindTexture_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLContextFunc_chooseContext(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLContext.chooseContext";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGLContextFunc_chooseContext_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:chooseContext", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QGLContext::chooseContext(const QGLContext*)
    if (numArgs == 0) {
        overloadId = 0; // chooseContext(const QGLContext*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // chooseContext(const QGLContext*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLContextFunc_chooseContext_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_shareContext = Shiboken::String::createStaticString("shareContext");
            if (PyDict_Contains(kwds, key_shareContext)) {
                value = PyDict_GetItem(kwds, key_shareContext);
                if (value && pyArgs[0]) {
                    errInfo = key_shareContext;
                    Py_INCREF(errInfo);
                    goto Sbk_QGLContextFunc_chooseContext_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_IDX]), (pyArgs[0]))))
                        goto Sbk_QGLContextFunc_chooseContext_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_shareContext);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QGLContextFunc_chooseContext_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QGLContext *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // chooseContext(const QGLContext*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QGLContext::chooseContext(cppArg0)
                : cppSelf->chooseContext(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGLContextFunc_chooseContext_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLContextFunc_colorIndex(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLContext.colorIndex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLContext::colorIndex(QColor)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArg)))) {
        overloadId = 0; // colorIndex(QColor)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLContextFunc_colorIndex_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // colorIndex(QColor)const
            uint cppResult = const_cast<const ::QGLContext *>(cppSelf)->colorIndex(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGLContextFunc_colorIndex_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLContextFunc_contextHandle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLContext.contextHandle";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // contextHandle()const
            QOpenGLContext * cppResult = const_cast<const ::QGLContext *>(cppSelf)->contextHandle();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLContextFunc_create(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLContext.create";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGLContextFunc_create_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:create", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QGLContext::create(const QGLContext*)
    if (numArgs == 0) {
        overloadId = 0; // create(const QGLContext*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // create(const QGLContext*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLContextFunc_create_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_shareContext = Shiboken::String::createStaticString("shareContext");
            if (PyDict_Contains(kwds, key_shareContext)) {
                value = PyDict_GetItem(kwds, key_shareContext);
                if (value && pyArgs[0]) {
                    errInfo = key_shareContext;
                    Py_INCREF(errInfo);
                    goto Sbk_QGLContextFunc_create_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_IDX]), (pyArgs[0]))))
                        goto Sbk_QGLContextFunc_create_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_shareContext);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QGLContextFunc_create_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QGLContext *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // create(const QGLContext*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QGLContext::create(cppArg0)
                : cppSelf->create(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGLContextFunc_create_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLContextFunc_currentContext(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLContext.currentContext";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentContext()
            const QGLContext * cppResult = ::QGLContext::currentContext();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_IDX]), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLContextFunc_deleteTexture(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLContext.deleteTexture";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLContext::deleteTexture(GLuint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLuint>(), (pyArg)))) {
        overloadId = 0; // deleteTexture(GLuint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLContextFunc_deleteTexture_TypeError;

    // Call function/method
    {
        GLuint cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // deleteTexture(GLuint)
            cppSelf->deleteTexture(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLContextFunc_deleteTexture_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLContextFunc_device(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLContext.device";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // device()const
            QPaintDevice * cppResult = const_cast<const ::QGLContext *>(cppSelf)->device();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLContextFunc_deviceIsPixmap(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLContext.deviceIsPixmap";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // deviceIsPixmap()const
            bool cppResult = const_cast<const ::QGLContext *>(cppSelf)->deviceIsPixmap();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLContextFunc_doneCurrent(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLContext.doneCurrent";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // doneCurrent()
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QGLContext::doneCurrent()
                : cppSelf->doneCurrent();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QGLContextFunc_drawTexture(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLContext.drawTexture";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGLContextFunc_drawTexture_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QGLContextFunc_drawTexture_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:drawTexture", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QGLContext::drawTexture(QPointF,GLuint,GLenum)
    // 1: QGLContext::drawTexture(QRectF,GLuint,GLenum)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLuint>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 1; // drawTexture(QRectF,GLuint,GLenum)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), (pyArgs[2])))) {
            overloadId = 1; // drawTexture(QRectF,GLuint,GLenum)
        }
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLuint>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // drawTexture(QPointF,GLuint,GLenum)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), (pyArgs[2])))) {
            overloadId = 0; // drawTexture(QPointF,GLuint,GLenum)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLContextFunc_drawTexture_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // drawTexture(const QPointF & point, GLuint textureId, GLenum textureTarget)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_textureTarget = Shiboken::String::createStaticString("textureTarget");
                if (PyDict_Contains(kwds, key_textureTarget)) {
                    value = PyDict_GetItem(kwds, key_textureTarget);
                    if (value && pyArgs[2]) {
                        errInfo = key_textureTarget;
                        Py_INCREF(errInfo);
                        goto Sbk_QGLContextFunc_drawTexture_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), (pyArgs[2]))))
                            goto Sbk_QGLContextFunc_drawTexture_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_textureTarget);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGLContextFunc_drawTexture_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPointF cppArg0_local;
            ::QPointF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            GLuint cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            GLenum cppArg2 = GL_TEXTURE_2D;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // drawTexture(QPointF,GLuint,GLenum)
                cppSelf->drawTexture(*cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 1: // drawTexture(const QRectF & target, GLuint textureId, GLenum textureTarget)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_textureTarget = Shiboken::String::createStaticString("textureTarget");
                if (PyDict_Contains(kwds, key_textureTarget)) {
                    value = PyDict_GetItem(kwds, key_textureTarget);
                    if (value && pyArgs[2]) {
                        errInfo = key_textureTarget;
                        Py_INCREF(errInfo);
                        goto Sbk_QGLContextFunc_drawTexture_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<GLenum>(), (pyArgs[2]))))
                            goto Sbk_QGLContextFunc_drawTexture_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_textureTarget);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGLContextFunc_drawTexture_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRectF cppArg0_local;
            ::QRectF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            GLuint cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            GLenum cppArg2 = GL_TEXTURE_2D;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // drawTexture(QRectF,GLuint,GLenum)
                cppSelf->drawTexture(*cppArg0, cppArg1, cppArg2);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLContextFunc_drawTexture_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLContextFunc_format(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLContext.format";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // format()const
            QGLFormat cppResult = const_cast<const ::QGLContext *>(cppSelf)->format();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLContextFunc_fromOpenGLContext(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLContext.fromOpenGLContext";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QGLContext::fromOpenGLContext(QOpenGLContext*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLCONTEXT_IDX]), (pyArg)))) {
        overloadId = 0; // fromOpenGLContext(QOpenGLContext*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLContextFunc_fromOpenGLContext_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QOpenGLContext *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // fromOpenGLContext(QOpenGLContext*)
            QGLContext * cppResult = ::QGLContext::fromOpenGLContext(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_IDX]), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGLContextFunc_fromOpenGLContext_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLContextFunc_initialized(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLContext.initialized";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // initialized()const
            bool cppResult = const_cast<const ::QGLContext *>(cppSelf)->initialized();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLContextFunc_isSharing(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLContext.isSharing";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isSharing()const
            bool cppResult = const_cast<const ::QGLContext *>(cppSelf)->isSharing();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLContextFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLContext.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QGLContext *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLContextFunc_makeCurrent(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLContext.makeCurrent";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // makeCurrent()
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QGLContext::makeCurrent()
                : cppSelf->makeCurrent();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QGLContextFunc_moveToThread(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLContext.moveToThread";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLContext::moveToThread(QThread*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTHREAD_IDX]), (pyArg)))) {
        overloadId = 0; // moveToThread(QThread*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLContextFunc_moveToThread_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QThread *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // moveToThread(QThread*)
            cppSelf->moveToThread(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLContextFunc_moveToThread_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLContextFunc_overlayTransparentColor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLContext.overlayTransparentColor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // overlayTransparentColor()const
            QColor cppResult = const_cast<const ::QGLContext *>(cppSelf)->overlayTransparentColor();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLContextFunc_requestedFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLContext.requestedFormat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // requestedFormat()const
            QGLFormat cppResult = const_cast<const ::QGLContext *>(cppSelf)->requestedFormat();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLContextFunc_reset(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLContext.reset";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // reset()
            cppSelf->reset();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QGLContextFunc_setDevice(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLContext.setDevice";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLContext::setDevice(QPaintDevice*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_IDX]), (pyArg)))) {
        overloadId = 0; // setDevice(QPaintDevice*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLContextFunc_setDevice_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPaintDevice *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDevice(QPaintDevice*)
            cppSelf->setDevice(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLContextFunc_setDevice_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLContextFunc_setFormat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLContext.setFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLContext::setFormat(QGLFormat)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX]), (pyArg)))) {
        overloadId = 0; // setFormat(QGLFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLContextFunc_setFormat_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGLFormat cppArg0_local;
        ::QGLFormat *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtOpenGLTypes[SBK_QGLFORMAT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setFormat(QGLFormat)
            cppSelf->setFormat(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLContextFunc_setFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLContextFunc_setInitialized(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLContext.setInitialized";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLContext::setInitialized(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setInitialized(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLContextFunc_setInitialized_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setInitialized(bool)
            cppSelf->setInitialized(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLContextFunc_setInitialized_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLContextFunc_setTextureCacheLimit(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLContext.setTextureCacheLimit";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QGLContext::setTextureCacheLimit(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setTextureCacheLimit(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLContextFunc_setTextureCacheLimit_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTextureCacheLimit(int)
            ::QGLContext::setTextureCacheLimit(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLContextFunc_setTextureCacheLimit_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLContextFunc_setValid(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLContext.setValid";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLContext::setValid(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setValid(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLContextFunc_setValid_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setValid(bool)
            cppSelf->setValid(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLContextFunc_setValid_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLContextFunc_setWindowCreated(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLContext.setWindowCreated";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGLContext::setWindowCreated(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setWindowCreated(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGLContextFunc_setWindowCreated_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setWindowCreated(bool)
            cppSelf->setWindowCreated(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGLContextFunc_setWindowCreated_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGLContextFunc_swapBuffers(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLContext.swapBuffers";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // swapBuffers()const
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QGLContext *>(cppSelf)->::QGLContext::swapBuffers()
                : const_cast<const ::QGLContext *>(cppSelf)->swapBuffers();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QGLContextFunc_textureCacheLimit(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLContext.textureCacheLimit";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // textureCacheLimit()
            int cppResult = ::QGLContext::textureCacheLimit();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGLContextFunc_windowCreated(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtOpenGL.QGLContext.windowCreated";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // windowCreated()const
            bool cppResult = const_cast<const ::QGLContext *>(cppSelf)->windowCreated();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QGLContext_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QGLContext_methods[] = {
    {"areSharing", reinterpret_cast<PyCFunction>(Sbk_QGLContextFunc_areSharing), METH_VARARGS|METH_STATIC},
    {"bindTexture", reinterpret_cast<PyCFunction>(Sbk_QGLContextFunc_bindTexture), METH_VARARGS|METH_KEYWORDS},
    {"chooseContext", reinterpret_cast<PyCFunction>(Sbk_QGLContextFunc_chooseContext), METH_VARARGS|METH_KEYWORDS},
    {"colorIndex", reinterpret_cast<PyCFunction>(Sbk_QGLContextFunc_colorIndex), METH_O},
    {"contextHandle", reinterpret_cast<PyCFunction>(Sbk_QGLContextFunc_contextHandle), METH_NOARGS},
    {"create", reinterpret_cast<PyCFunction>(Sbk_QGLContextFunc_create), METH_VARARGS|METH_KEYWORDS},
    {"currentContext", reinterpret_cast<PyCFunction>(Sbk_QGLContextFunc_currentContext), METH_NOARGS|METH_STATIC},
    {"deleteTexture", reinterpret_cast<PyCFunction>(Sbk_QGLContextFunc_deleteTexture), METH_O},
    {"device", reinterpret_cast<PyCFunction>(Sbk_QGLContextFunc_device), METH_NOARGS},
    {"deviceIsPixmap", reinterpret_cast<PyCFunction>(Sbk_QGLContextFunc_deviceIsPixmap), METH_NOARGS},
    {"doneCurrent", reinterpret_cast<PyCFunction>(Sbk_QGLContextFunc_doneCurrent), METH_NOARGS},
    {"drawTexture", reinterpret_cast<PyCFunction>(Sbk_QGLContextFunc_drawTexture), METH_VARARGS|METH_KEYWORDS},
    {"format", reinterpret_cast<PyCFunction>(Sbk_QGLContextFunc_format), METH_NOARGS},
    {"fromOpenGLContext", reinterpret_cast<PyCFunction>(Sbk_QGLContextFunc_fromOpenGLContext), METH_O|METH_STATIC},
    {"initialized", reinterpret_cast<PyCFunction>(Sbk_QGLContextFunc_initialized), METH_NOARGS},
    {"isSharing", reinterpret_cast<PyCFunction>(Sbk_QGLContextFunc_isSharing), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QGLContextFunc_isValid), METH_NOARGS},
    {"makeCurrent", reinterpret_cast<PyCFunction>(Sbk_QGLContextFunc_makeCurrent), METH_NOARGS},
    {"moveToThread", reinterpret_cast<PyCFunction>(Sbk_QGLContextFunc_moveToThread), METH_O},
    {"overlayTransparentColor", reinterpret_cast<PyCFunction>(Sbk_QGLContextFunc_overlayTransparentColor), METH_NOARGS},
    {"requestedFormat", reinterpret_cast<PyCFunction>(Sbk_QGLContextFunc_requestedFormat), METH_NOARGS},
    {"reset", reinterpret_cast<PyCFunction>(Sbk_QGLContextFunc_reset), METH_NOARGS},
    {"setDevice", reinterpret_cast<PyCFunction>(Sbk_QGLContextFunc_setDevice), METH_O},
    {"setFormat", reinterpret_cast<PyCFunction>(Sbk_QGLContextFunc_setFormat), METH_O},
    {"setInitialized", reinterpret_cast<PyCFunction>(Sbk_QGLContextFunc_setInitialized), METH_O},
    {"setTextureCacheLimit", reinterpret_cast<PyCFunction>(Sbk_QGLContextFunc_setTextureCacheLimit), METH_O|METH_STATIC},
    {"setValid", reinterpret_cast<PyCFunction>(Sbk_QGLContextFunc_setValid), METH_O},
    {"setWindowCreated", reinterpret_cast<PyCFunction>(Sbk_QGLContextFunc_setWindowCreated), METH_O},
    {"swapBuffers", reinterpret_cast<PyCFunction>(Sbk_QGLContextFunc_swapBuffers), METH_NOARGS},
    {"textureCacheLimit", reinterpret_cast<PyCFunction>(Sbk_QGLContextFunc_textureCacheLimit), METH_NOARGS|METH_STATIC},
    {"windowCreated", reinterpret_cast<PyCFunction>(Sbk_QGLContextFunc_windowCreated), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QGLContext_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QGLContext *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QGLContextWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QGLContext_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QGLContext_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QGLContext_Type = nullptr;
static SbkObjectType *Sbk_QGLContext_TypeF(void)
{
    return _Sbk_QGLContext_Type;
}

static PyType_Slot Sbk_QGLContext_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QGLContext_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QGLContext_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QGLContext_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QGLContext_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QGLContext_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QGLContext_spec = {
    "2:PySide2.QtOpenGL.QGLContext",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QGLContext_slots
};

} //extern "C"

PyObject *SbkPySide2_QtOpenGL_QGLContext_BindOption___and__(PyObject *self, PyObject *pyArg)
{
    ::QGLContext::BindOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGLContext::BindOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGLContext::BindOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGLContext::BindOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGLContext::BindOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGLCONTEXT_BINDOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtOpenGL_QGLContext_BindOption___or__(PyObject *self, PyObject *pyArg)
{
    ::QGLContext::BindOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGLContext::BindOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGLContext::BindOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGLContext::BindOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGLContext::BindOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGLCONTEXT_BINDOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtOpenGL_QGLContext_BindOption___xor__(PyObject *self, PyObject *pyArg)
{
    ::QGLContext::BindOptions cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QGLContext::BindOptions>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QGLContext::BindOptions>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QGLContext::BindOptions>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QGLContext::BindOptions>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGLCONTEXT_BINDOPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtOpenGL_QGLContext_BindOption___invert__(PyObject *self, PyObject *pyArg)
{
    ::QGLContext::BindOptions cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGLCONTEXT_BINDOPTION_IDX])->converter, self, &cppSelf);
    ::QGLContext::BindOptions cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGLCONTEXT_BINDOPTION_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtOpenGL_QGLContext_BindOption_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGLCONTEXT_BINDOPTION_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtOpenGL_QGLContext_BindOption__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGLCONTEXT_BINDOPTION_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtOpenGL_QGLContext_BindOption_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtOpenGL_QGLContext_BindOption__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtOpenGL_QGLContext_BindOption__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtOpenGL_QGLContext_BindOption_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtOpenGL_QGLContext_BindOption___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtOpenGL_QGLContext_BindOption___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtOpenGL_QGLContext_BindOption___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtOpenGL_QGLContext_BindOption___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtOpenGL_QGLContext_BindOption_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtOpenGL_QGLContext_BindOption_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtOpenGL_QGLContext_BindOption_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QGLContext_BindOption_PythonToCpp_QGLContext_BindOption(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGLContext::BindOption *>(cppOut) =
        static_cast<::QGLContext::BindOption>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGLContext_BindOption_PythonToCpp_QGLContext_BindOption_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_BINDOPTION_IDX]))
        return QGLContext_BindOption_PythonToCpp_QGLContext_BindOption;
    return {};
}
static PyObject *QGLContext_BindOption_CppToPython_QGLContext_BindOption(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGLContext::BindOption *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_BINDOPTION_IDX], castCppIn);

}

static void QFlags_QGLContext_BindOption__PythonToCpp_QFlags_QGLContext_BindOption_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QGLContext::BindOption> *>(cppOut) =
        ::QFlags<QGLContext::BindOption>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QGLContext_BindOption__PythonToCpp_QFlags_QGLContext_BindOption__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGLCONTEXT_BINDOPTION_IDX]))
        return QFlags_QGLContext_BindOption__PythonToCpp_QFlags_QGLContext_BindOption_;
    return {};
}
static PyObject *QFlags_QGLContext_BindOption__CppToPython_QFlags_QGLContext_BindOption_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QGLContext::BindOption> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGLCONTEXT_BINDOPTION_IDX]));

}

static void QGLContext_BindOption_PythonToCpp_QFlags_QGLContext_BindOption_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QGLContext::BindOption> *>(cppOut) =
        ::QFlags<QGLContext::BindOption>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QGLContext_BindOption_PythonToCpp_QFlags_QGLContext_BindOption__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_BINDOPTION_IDX]))
        return QGLContext_BindOption_PythonToCpp_QFlags_QGLContext_BindOption_;
    return {};
}
static void number_PythonToCpp_QFlags_QGLContext_BindOption_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QGLContext::BindOption> *>(cppOut) =
        ::QFlags<QGLContext::BindOption>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QGLContext_BindOption__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_BINDOPTION_IDX]))
        return number_PythonToCpp_QFlags_QGLContext_BindOption_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QGLContext_PythonToCpp_QGLContext_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QGLContext_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QGLContext_PythonToCpp_QGLContext_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGLContext_TypeF())))
        return QGLContext_PythonToCpp_QGLContext_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QGLContext_PTR_CppToPython_QGLContext(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QGLContext *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QGLContext_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QGLContext_SignatureStrings[] = {
    "PySide2.QtOpenGL.QGLContext(self,format:PySide2.QtOpenGL.QGLFormat)",
    "PySide2.QtOpenGL.QGLContext.areSharing(context1:PySide2.QtOpenGL.QGLContext,context2:PySide2.QtOpenGL.QGLContext)->bool",
    "4:PySide2.QtOpenGL.QGLContext.bindTexture(self,image:PySide2.QtGui.QImage,target:GLenum=GL_TEXTURE_2D,format:GLint=GL_RGBA)->GLuint",
    "3:PySide2.QtOpenGL.QGLContext.bindTexture(self,image:PySide2.QtGui.QImage,target:GLenum,format:GLint,options:PySide2.QtOpenGL.QGLContext.BindOptions)->GLuint",
    "2:PySide2.QtOpenGL.QGLContext.bindTexture(self,pixmap:PySide2.QtGui.QPixmap,target:GLenum=GL_TEXTURE_2D,format:GLint=GL_RGBA)->GLuint",
    "1:PySide2.QtOpenGL.QGLContext.bindTexture(self,pixmap:PySide2.QtGui.QPixmap,target:GLenum,format:GLint,options:PySide2.QtOpenGL.QGLContext.BindOptions)->GLuint",
    "0:PySide2.QtOpenGL.QGLContext.bindTexture(self,fileName:QString)->GLuint",
    "PySide2.QtOpenGL.QGLContext.chooseContext(self,shareContext:PySide2.QtOpenGL.QGLContext=nullptr)->bool",
    "PySide2.QtOpenGL.QGLContext.colorIndex(self,c:PySide2.QtGui.QColor)->uint",
    "PySide2.QtOpenGL.QGLContext.contextHandle(self)->PySide2.QtGui.QOpenGLContext",
    "PySide2.QtOpenGL.QGLContext.create(self,shareContext:PySide2.QtOpenGL.QGLContext=nullptr)->bool",
    "PySide2.QtOpenGL.QGLContext.currentContext()->PySide2.QtOpenGL.QGLContext",
    "PySide2.QtOpenGL.QGLContext.deleteTexture(self,tx_id:GLuint)",
    "PySide2.QtOpenGL.QGLContext.device(self)->PySide2.QtGui.QPaintDevice",
    "PySide2.QtOpenGL.QGLContext.deviceIsPixmap(self)->bool",
    "PySide2.QtOpenGL.QGLContext.doneCurrent(self)",
    "1:PySide2.QtOpenGL.QGLContext.drawTexture(self,point:PySide2.QtCore.QPointF,textureId:GLuint,textureTarget:GLenum=GL_TEXTURE_2D)",
    "0:PySide2.QtOpenGL.QGLContext.drawTexture(self,target:PySide2.QtCore.QRectF,textureId:GLuint,textureTarget:GLenum=GL_TEXTURE_2D)",
    "PySide2.QtOpenGL.QGLContext.format(self)->PySide2.QtOpenGL.QGLFormat",
    "PySide2.QtOpenGL.QGLContext.fromOpenGLContext(platformContext:PySide2.QtGui.QOpenGLContext)->PySide2.QtOpenGL.QGLContext",
    "PySide2.QtOpenGL.QGLContext.initialized(self)->bool",
    "PySide2.QtOpenGL.QGLContext.isSharing(self)->bool",
    "PySide2.QtOpenGL.QGLContext.isValid(self)->bool",
    "PySide2.QtOpenGL.QGLContext.makeCurrent(self)",
    "PySide2.QtOpenGL.QGLContext.moveToThread(self,thread:PySide2.QtCore.QThread)",
    "PySide2.QtOpenGL.QGLContext.overlayTransparentColor(self)->PySide2.QtGui.QColor",
    "PySide2.QtOpenGL.QGLContext.requestedFormat(self)->PySide2.QtOpenGL.QGLFormat",
    "PySide2.QtOpenGL.QGLContext.reset(self)",
    "PySide2.QtOpenGL.QGLContext.setDevice(self,pDev:PySide2.QtGui.QPaintDevice)",
    "PySide2.QtOpenGL.QGLContext.setFormat(self,format:PySide2.QtOpenGL.QGLFormat)",
    "PySide2.QtOpenGL.QGLContext.setInitialized(self,on:bool)",
    "PySide2.QtOpenGL.QGLContext.setTextureCacheLimit(size:int)",
    "PySide2.QtOpenGL.QGLContext.setValid(self,valid:bool)",
    "PySide2.QtOpenGL.QGLContext.setWindowCreated(self,on:bool)",
    "PySide2.QtOpenGL.QGLContext.swapBuffers(self)",
    "PySide2.QtOpenGL.QGLContext.textureCacheLimit()->int",
    "PySide2.QtOpenGL.QGLContext.windowCreated(self)->bool",
    nullptr}; // Sentinel

void init_QGLContext(PyObject *module)
{
    _Sbk_QGLContext_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QGLContext",
        "QGLContext*",
        &Sbk_QGLContext_spec,
        &Shiboken::callCppDestructor< ::QGLContext >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QGLContext_Type);
    InitSignatureStrings(pyType, QGLContext_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QGLContext_Type), Sbk_QGLContext_PropertyStrings);
    SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QGLContext_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QGLContext_TypeF(),
        QGLContext_PythonToCpp_QGLContext_PTR,
        is_QGLContext_PythonToCpp_QGLContext_PTR_Convertible,
        QGLContext_PTR_CppToPython_QGLContext);

    Shiboken::Conversions::registerConverterName(converter, "QGLContext");
    Shiboken::Conversions::registerConverterName(converter, "QGLContext*");
    Shiboken::Conversions::registerConverterName(converter, "QGLContext&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGLContext).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGLContextWrapper).name());


    // Initialization of enums.

    // Initialization of enum 'BindOption'.
    SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGLCONTEXT_BINDOPTION_IDX] = PySide::QFlags::create("2:PySide2.QtOpenGL.QGLContext.BindOptions", SbkPySide2_QtOpenGL_QGLContext_BindOption_number_slots);
    SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_BINDOPTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGLContext_TypeF(),
        "BindOption",
        "2:PySide2.QtOpenGL.QGLContext.BindOption",
        "QGLContext::BindOption",
        SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGLCONTEXT_BINDOPTION_IDX]);
    if (!SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_BINDOPTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_BINDOPTION_IDX],
        Sbk_QGLContext_TypeF(), "NoBindOption", (long) QGLContext::BindOption::NoBindOption))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_BINDOPTION_IDX],
        Sbk_QGLContext_TypeF(), "InvertedYBindOption", (long) QGLContext::BindOption::InvertedYBindOption))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_BINDOPTION_IDX],
        Sbk_QGLContext_TypeF(), "MipmapBindOption", (long) QGLContext::BindOption::MipmapBindOption))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_BINDOPTION_IDX],
        Sbk_QGLContext_TypeF(), "PremultipliedAlphaBindOption", (long) QGLContext::BindOption::PremultipliedAlphaBindOption))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_BINDOPTION_IDX],
        Sbk_QGLContext_TypeF(), "LinearFilteringBindOption", (long) QGLContext::BindOption::LinearFilteringBindOption))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_BINDOPTION_IDX],
        Sbk_QGLContext_TypeF(), "MemoryManagedBindOption", (long) QGLContext::BindOption::MemoryManagedBindOption))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_BINDOPTION_IDX],
        Sbk_QGLContext_TypeF(), "CanFlipNativePixmapBindOption", (long) QGLContext::BindOption::CanFlipNativePixmapBindOption))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_BINDOPTION_IDX],
        Sbk_QGLContext_TypeF(), "TemporarilyCachedBindOption", (long) QGLContext::BindOption::TemporarilyCachedBindOption))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_BINDOPTION_IDX],
        Sbk_QGLContext_TypeF(), "DefaultBindOption", (long) QGLContext::BindOption::DefaultBindOption))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_BINDOPTION_IDX],
        Sbk_QGLContext_TypeF(), "InternalBindOption", (long) QGLContext::BindOption::InternalBindOption))
        return;
    // Register converter for enum 'QGLContext::BindOption'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_BINDOPTION_IDX],
            QGLContext_BindOption_CppToPython_QGLContext_BindOption);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGLContext_BindOption_PythonToCpp_QGLContext_BindOption,
            is_QGLContext_BindOption_PythonToCpp_QGLContext_BindOption_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtOpenGLTypes[SBK_QGLCONTEXT_BINDOPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGLContext::BindOption");
        Shiboken::Conversions::registerConverterName(converter, "BindOption");
    }
    // Register converter for flag 'QFlags<QGLContext::BindOption>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGLCONTEXT_BINDOPTION_IDX],
            QFlags_QGLContext_BindOption__CppToPython_QFlags_QGLContext_BindOption_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGLContext_BindOption_PythonToCpp_QFlags_QGLContext_BindOption_,
            is_QGLContext_BindOption_PythonToCpp_QFlags_QGLContext_BindOption__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QGLContext_BindOption__PythonToCpp_QFlags_QGLContext_BindOption_,
            is_QFlags_QGLContext_BindOption__PythonToCpp_QFlags_QGLContext_BindOption__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QGLContext_BindOption_,
            is_number_PythonToCpp_QFlags_QGLContext_BindOption__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtOpenGLTypes[SBK_QFLAGS_QGLCONTEXT_BINDOPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGLContext::BindOptions");
        Shiboken::Conversions::registerConverterName(converter, "BindOptions");
    }
    // End of 'BindOption' enum/flags.

    qRegisterMetaType< ::QGLContext::BindOption >("QGLContext::BindOption");
    qRegisterMetaType< ::QGLContext::BindOptions >("QGLContext::BindOptions");
}
