/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtnetwork_python.h"

// main header
#include "qsslcipher_wrapper.h"

// inner classes

// Extra includes
#include <QtNetwork/qsslcipher.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QSslCipher_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QSslCipher >()))
        return -1;

    ::QSslCipher *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCipher.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QSslCipher", 0, 2, &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QSslCipher::QSslCipher()
    // 1: QSslCipher::QSslCipher(QSslCipher)
    // 2: QSslCipher::QSslCipher(QString)
    // 3: QSslCipher::QSslCipher(QString,QSsl::SslProtocol)
    if (numArgs == 0) {
        overloadId = 0; // QSslCipher()
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // QSslCipher(QString)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLPROTOCOL_IDX])->converter, (pyArgs[1])))) {
            overloadId = 3; // QSslCipher(QString,QSsl::SslProtocol)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCIPHER_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QSslCipher(QSslCipher)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslCipher_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QSslCipher()
        {

            if (!PyErr_Occurred()) {
                // QSslCipher()
                cptr = new ::QSslCipher();
            }
            break;
        }
        case 1: // QSslCipher(const QSslCipher & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QSslCipher cppArg0_local;
            ::QSslCipher *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCIPHER_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QSslCipher(QSslCipher)
                cptr = new ::QSslCipher(*cppArg0);
            }
            break;
        }
        case 2: // QSslCipher(const QString & name)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QSslCipher(QString)
                cptr = new ::QSslCipher(cppArg0);
            }
            break;
        }
        case 3: // QSslCipher(const QString & name, QSsl::SslProtocol protocol)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QSsl::SslProtocol cppArg1{QSsl::SslV3};
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QSslCipher(QString,QSsl::SslProtocol)
                cptr = new ::QSslCipher(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QSslCipher >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QSslCipher_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QSslCipher_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QSslCipherFunc_authenticationMethod(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslCipher *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCIPHER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCipher.authenticationMethod";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // authenticationMethod()const
            QString cppResult = const_cast<const ::QSslCipher *>(cppSelf)->authenticationMethod();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslCipherFunc_encryptionMethod(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslCipher *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCIPHER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCipher.encryptionMethod";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // encryptionMethod()const
            QString cppResult = const_cast<const ::QSslCipher *>(cppSelf)->encryptionMethod();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslCipherFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslCipher *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCIPHER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCipher.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QSslCipher *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslCipherFunc_keyExchangeMethod(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslCipher *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCIPHER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCipher.keyExchangeMethod";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // keyExchangeMethod()const
            QString cppResult = const_cast<const ::QSslCipher *>(cppSelf)->keyExchangeMethod();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslCipherFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslCipher *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCIPHER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCipher.name";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // name()const
            QString cppResult = const_cast<const ::QSslCipher *>(cppSelf)->name();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslCipherFunc_protocol(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslCipher *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCIPHER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCipher.protocol";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // protocol()const
            QSsl::SslProtocol cppResult = const_cast<const ::QSslCipher *>(cppSelf)->protocol();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLPROTOCOL_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslCipherFunc_protocolString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslCipher *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCIPHER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCipher.protocolString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // protocolString()const
            QString cppResult = const_cast<const ::QSslCipher *>(cppSelf)->protocolString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslCipherFunc_supportedBits(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslCipher *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCIPHER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCipher.supportedBits";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedBits()const
            int cppResult = const_cast<const ::QSslCipher *>(cppSelf)->supportedBits();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslCipherFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslCipher *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCIPHER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCipher.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QSslCipher::swap(QSslCipher&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCIPHER_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QSslCipher&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QSslCipherFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSslCipher cppArg0_local;
        ::QSslCipher *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCIPHER_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QSslCipher&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QSslCipherFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QSslCipherFunc_usedBits(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslCipher *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCIPHER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QSslCipher.usedBits";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // usedBits()const
            int cppResult = const_cast<const ::QSslCipher *>(cppSelf)->usedBits();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QSslCipher___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QSslCipher *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCIPHER_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCIPHER_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QSslCipher_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QSslCipher_methods[] = {
    {"authenticationMethod", reinterpret_cast<PyCFunction>(Sbk_QSslCipherFunc_authenticationMethod), METH_NOARGS},
    {"encryptionMethod", reinterpret_cast<PyCFunction>(Sbk_QSslCipherFunc_encryptionMethod), METH_NOARGS},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QSslCipherFunc_isNull), METH_NOARGS},
    {"keyExchangeMethod", reinterpret_cast<PyCFunction>(Sbk_QSslCipherFunc_keyExchangeMethod), METH_NOARGS},
    {"name", reinterpret_cast<PyCFunction>(Sbk_QSslCipherFunc_name), METH_NOARGS},
    {"protocol", reinterpret_cast<PyCFunction>(Sbk_QSslCipherFunc_protocol), METH_NOARGS},
    {"protocolString", reinterpret_cast<PyCFunction>(Sbk_QSslCipherFunc_protocolString), METH_NOARGS},
    {"supportedBits", reinterpret_cast<PyCFunction>(Sbk_QSslCipherFunc_supportedBits), METH_NOARGS},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QSslCipherFunc_swap), METH_O},
    {"usedBits", reinterpret_cast<PyCFunction>(Sbk_QSslCipherFunc_usedBits), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QSslCipher___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QSslCipher___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QSslCipher *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCIPHER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

// Rich comparison
static PyObject * Sbk_QSslCipher_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QSslCipher *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCIPHER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCIPHER_IDX]), (pyArg)))) {
                // operator!=(const QSslCipher & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QSslCipher cppArg0_local;
                ::QSslCipher *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCIPHER_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCIPHER_IDX]), (pyArg)))) {
                // operator==(const QSslCipher & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QSslCipher cppArg0_local;
                ::QSslCipher *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCIPHER_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QSslCipher_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QSslCipher_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QSslCipher_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QSslCipher_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QSslCipher__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QSslCipher *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCIPHER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QSslCipher_Type = nullptr;
static SbkObjectType *Sbk_QSslCipher_TypeF(void)
{
    return _Sbk_QSslCipher_Type;
}

static PyType_Slot Sbk_QSslCipher_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QSslCipher__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QSslCipher_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QSslCipher_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QSslCipher_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QSslCipher_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QSslCipher_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QSslCipher___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QSslCipher___nb_bool},
#endif
    {0, nullptr}
};
static PyType_Spec Sbk_QSslCipher_spec = {
    "2:PySide2.QtNetwork.QSslCipher",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QSslCipher_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QSslCipher_PythonToCpp_QSslCipher_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QSslCipher_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QSslCipher_PythonToCpp_QSslCipher_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSslCipher_TypeF())))
        return QSslCipher_PythonToCpp_QSslCipher_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QSslCipher_PTR_CppToPython_QSslCipher(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QSslCipher *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QSslCipher_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QSslCipher_COPY_CppToPython_QSslCipher(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QSslCipher_TypeF(), new ::QSslCipher(*reinterpret_cast<const ::QSslCipher *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QSslCipher_PythonToCpp_QSslCipher_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QSslCipher *>(cppOut) = *reinterpret_cast< ::QSslCipher *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QSSLCIPHER_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QSslCipher_PythonToCpp_QSslCipher_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QSslCipher_TypeF())))
        return QSslCipher_PythonToCpp_QSslCipher_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QSslCipher_SignatureStrings[] = {
    "3:PySide2.QtNetwork.QSslCipher(self)",
    "2:PySide2.QtNetwork.QSslCipher(self,other:PySide2.QtNetwork.QSslCipher)",
    "1:PySide2.QtNetwork.QSslCipher(self,name:QString)",
    "0:PySide2.QtNetwork.QSslCipher(self,name:QString,protocol:PySide2.QtNetwork.QSsl.SslProtocol)",
    "PySide2.QtNetwork.QSslCipher.authenticationMethod(self)->QString",
    "PySide2.QtNetwork.QSslCipher.encryptionMethod(self)->QString",
    "PySide2.QtNetwork.QSslCipher.isNull(self)->bool",
    "PySide2.QtNetwork.QSslCipher.keyExchangeMethod(self)->QString",
    "PySide2.QtNetwork.QSslCipher.name(self)->QString",
    "PySide2.QtNetwork.QSslCipher.protocol(self)->PySide2.QtNetwork.QSsl.SslProtocol",
    "PySide2.QtNetwork.QSslCipher.protocolString(self)->QString",
    "PySide2.QtNetwork.QSslCipher.supportedBits(self)->int",
    "PySide2.QtNetwork.QSslCipher.swap(self,other:PySide2.QtNetwork.QSslCipher)",
    "PySide2.QtNetwork.QSslCipher.usedBits(self)->int",
    "PySide2.QtNetwork.QSslCipher.__copy__()",
    nullptr}; // Sentinel

void init_QSslCipher(PyObject *module)
{
    _Sbk_QSslCipher_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QSslCipher",
        "QSslCipher",
        &Sbk_QSslCipher_spec,
        &Shiboken::callCppDestructor< ::QSslCipher >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QSslCipher_Type);
    InitSignatureStrings(pyType, QSslCipher_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QSslCipher_Type), Sbk_QSslCipher_PropertyStrings);
    SbkPySide2_QtNetworkTypes[SBK_QSSLCIPHER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QSslCipher_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QSslCipher_TypeF(),
        QSslCipher_PythonToCpp_QSslCipher_PTR,
        is_QSslCipher_PythonToCpp_QSslCipher_PTR_Convertible,
        QSslCipher_PTR_CppToPython_QSslCipher,
        QSslCipher_COPY_CppToPython_QSslCipher);

    Shiboken::Conversions::registerConverterName(converter, "QSslCipher");
    Shiboken::Conversions::registerConverterName(converter, "QSslCipher*");
    Shiboken::Conversions::registerConverterName(converter, "QSslCipher&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QSslCipher).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QSslCipher_PythonToCpp_QSslCipher_COPY,
        is_QSslCipher_PythonToCpp_QSslCipher_COPY_Convertible);

    qRegisterMetaType< ::QSslCipher >("QSslCipher");
}
