/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtnetwork_python.h"

// main header
#include "qnetworksession_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QNetworkSessionWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QNetworkSessionWrapper::QNetworkSessionWrapper(const ::QNetworkConfiguration & connConfig, ::QObject * parent) : QNetworkSession(connConfig, parent)
{
    resetPyMethodCache();
    // ... middle
}

void QNetworkSessionWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QNetworkSessionWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QNetworkSession::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QNetworkSession::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QNetworkSessionWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QNetworkSessionWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QNetworkSession::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QNetworkSession::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QNetworkSessionWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QNetworkSession.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QNetworkSessionWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QNetworkSession.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QNetworkSessionWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QNetworkSessionWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QNetworkSession::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QNetworkSessionWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QNetworkSession::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QNetworkSessionWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QNetworkSessionWrapper *>(this));
        return QNetworkSession::qt_metacast(_clname);
}

QNetworkSessionWrapper::~QNetworkSessionWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QNetworkSession_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QNetworkSession >()))
        return -1;

    ::QNetworkSessionWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkSession.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QNetworkSession_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:QNetworkSession", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QNetworkSession::QNetworkSession(QNetworkConfiguration,QObject*)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // QNetworkSession(QNetworkConfiguration,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
            overloadId = 0; // QNetworkSession(QNetworkConfiguration,QObject*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkSession_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[1]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QNetworkSession_Init_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1]))))
                        goto Sbk_QNetworkSession_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QNetworkConfiguration cppArg0_local;
        ::QNetworkConfiguration *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return -1;
        ::QObject *cppArg1 = nullptr;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // QNetworkSession(QNetworkConfiguration,QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QNetworkSessionWrapper(*cppArg0, cppArg1);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QNetworkSessionWrapper(*cppArg0, cppArg1);
            }

            Shiboken::Object::setParent(pyArgs[1], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QNetworkSession >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QNetworkSession_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QNetworkSession_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QNetworkSession_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QNetworkSessionFunc_accept(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkSession *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkSession.accept";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // accept()
            cppSelf->accept();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QNetworkSessionFunc_activeTime(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkSession *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkSession.activeTime";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // activeTime()const
            quint64 cppResult = const_cast<const ::QNetworkSession *>(cppSelf)->activeTime();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkSessionFunc_bytesReceived(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkSession *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkSession.bytesReceived";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bytesReceived()const
            quint64 cppResult = const_cast<const ::QNetworkSession *>(cppSelf)->bytesReceived();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkSessionFunc_bytesWritten(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkSession *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkSession.bytesWritten";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bytesWritten()const
            quint64 cppResult = const_cast<const ::QNetworkSession *>(cppSelf)->bytesWritten();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkSessionFunc_close(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkSession *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkSession.close";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // close()
            cppSelf->close();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QNetworkSessionFunc_configuration(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkSession *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkSession.configuration";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // configuration()const
            QNetworkConfiguration cppResult = const_cast<const ::QNetworkSession *>(cppSelf)->configuration();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkSessionFunc_connectNotify(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkSession *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkSession.connectNotify";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::connectNotify(QMetaMethod)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), (pyArg)))) {
        overloadId = 0; // connectNotify(QMetaMethod)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkSessionFunc_connectNotify_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMetaMethod cppArg0_local;
        ::QMetaMethod *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // connectNotify(QMetaMethod)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QNetworkSession::connectNotify(*cppArg0)
                : cppSelf->connectNotify(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkSessionFunc_connectNotify_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkSessionFunc_disconnectNotify(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkSession *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkSession.disconnectNotify";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::disconnectNotify(QMetaMethod)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), (pyArg)))) {
        overloadId = 0; // disconnectNotify(QMetaMethod)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkSessionFunc_disconnectNotify_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMetaMethod cppArg0_local;
        ::QMetaMethod *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // disconnectNotify(QMetaMethod)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QNetworkSession::disconnectNotify(*cppArg0)
                : cppSelf->disconnectNotify(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkSessionFunc_disconnectNotify_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkSessionFunc_error(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkSession *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkSession.error";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // error()const
            QNetworkSession::SessionError cppResult = const_cast<const ::QNetworkSession *>(cppSelf)->error();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_SESSIONERROR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkSessionFunc_errorString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkSession *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkSession.errorString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // errorString()const
            QString cppResult = const_cast<const ::QNetworkSession *>(cppSelf)->errorString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkSessionFunc_ignore(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkSession *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkSession.ignore";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // ignore()
            cppSelf->ignore();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QNetworkSessionFunc_interface(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkSession *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkSession.interface";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // interface()const
            QNetworkInterface cppResult = const_cast<const ::QNetworkSession *>(cppSelf)->interface();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkSessionFunc_isOpen(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkSession *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkSession.isOpen";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isOpen()const
            bool cppResult = const_cast<const ::QNetworkSession *>(cppSelf)->isOpen();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkSessionFunc_migrate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkSession *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkSession.migrate";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // migrate()
            cppSelf->migrate();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QNetworkSessionFunc_open(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkSession *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkSession.open";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // open()
            cppSelf->open();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QNetworkSessionFunc_reject(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkSession *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkSession.reject";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // reject()
            cppSelf->reject();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QNetworkSessionFunc_sessionProperty(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkSession *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkSession.sessionProperty";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkSession::sessionProperty(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // sessionProperty(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkSessionFunc_sessionProperty_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // sessionProperty(QString)const
            QVariant cppResult = const_cast<const ::QNetworkSession *>(cppSelf)->sessionProperty(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QNetworkSessionFunc_sessionProperty_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkSessionFunc_setSessionProperty(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkSession *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkSession.setSessionProperty";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setSessionProperty", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QNetworkSession::setSessionProperty(QString,QVariant)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[1])))) {
        overloadId = 0; // setSessionProperty(QString,QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkSessionFunc_setSessionProperty_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QVariant cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setSessionProperty(QString,QVariant)
            cppSelf->setSessionProperty(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkSessionFunc_setSessionProperty_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkSessionFunc_state(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkSession *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkSession.state";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // state()const
            QNetworkSession::State cppResult = const_cast<const ::QNetworkSession *>(cppSelf)->state();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_STATE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkSessionFunc_stop(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkSession *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkSession.stop";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // stop()
            cppSelf->stop();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QNetworkSessionFunc_usagePolicies(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkSession *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkSession.usagePolicies";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // usagePolicies()const
            QFlags<QNetworkSession::UsagePolicy> cppResult = const_cast<const ::QNetworkSession *>(cppSelf)->usagePolicies();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKSESSION_USAGEPOLICY_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkSessionFunc_waitForOpened(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkSession *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkSession.waitForOpened";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QNetworkSessionFunc_waitForOpened_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:waitForOpened", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QNetworkSession::waitForOpened(int)
    if (numArgs == 0) {
        overloadId = 0; // waitForOpened(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // waitForOpened(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkSessionFunc_waitForOpened_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_msecs = Shiboken::String::createStaticString("msecs");
            if (PyDict_Contains(kwds, key_msecs)) {
                value = PyDict_GetItem(kwds, key_msecs);
                if (value && pyArgs[0]) {
                    errInfo = key_msecs;
                    Py_INCREF(errInfo);
                    goto Sbk_QNetworkSessionFunc_waitForOpened_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QNetworkSessionFunc_waitForOpened_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_msecs);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QNetworkSessionFunc_waitForOpened_TypeError;
            }
        }
        int cppArg0 = 30000;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // waitForOpened(int)
            bool cppResult = cppSelf->waitForOpened(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QNetworkSessionFunc_waitForOpened_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QNetworkSession_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QNetworkSession_methods[] = {
    {"accept", reinterpret_cast<PyCFunction>(Sbk_QNetworkSessionFunc_accept), METH_NOARGS},
    {"activeTime", reinterpret_cast<PyCFunction>(Sbk_QNetworkSessionFunc_activeTime), METH_NOARGS},
    {"bytesReceived", reinterpret_cast<PyCFunction>(Sbk_QNetworkSessionFunc_bytesReceived), METH_NOARGS},
    {"bytesWritten", reinterpret_cast<PyCFunction>(Sbk_QNetworkSessionFunc_bytesWritten), METH_NOARGS},
    {"close", reinterpret_cast<PyCFunction>(Sbk_QNetworkSessionFunc_close), METH_NOARGS},
    {"configuration", reinterpret_cast<PyCFunction>(Sbk_QNetworkSessionFunc_configuration), METH_NOARGS},
    {"connectNotify", reinterpret_cast<PyCFunction>(Sbk_QNetworkSessionFunc_connectNotify), METH_O},
    {"disconnectNotify", reinterpret_cast<PyCFunction>(Sbk_QNetworkSessionFunc_disconnectNotify), METH_O},
    {"error", reinterpret_cast<PyCFunction>(Sbk_QNetworkSessionFunc_error), METH_NOARGS},
    {"errorString", reinterpret_cast<PyCFunction>(Sbk_QNetworkSessionFunc_errorString), METH_NOARGS},
    {"ignore", reinterpret_cast<PyCFunction>(Sbk_QNetworkSessionFunc_ignore), METH_NOARGS},
    {"interface", reinterpret_cast<PyCFunction>(Sbk_QNetworkSessionFunc_interface), METH_NOARGS},
    {"isOpen", reinterpret_cast<PyCFunction>(Sbk_QNetworkSessionFunc_isOpen), METH_NOARGS},
    {"migrate", reinterpret_cast<PyCFunction>(Sbk_QNetworkSessionFunc_migrate), METH_NOARGS},
    {"open", reinterpret_cast<PyCFunction>(Sbk_QNetworkSessionFunc_open), METH_NOARGS},
    {"reject", reinterpret_cast<PyCFunction>(Sbk_QNetworkSessionFunc_reject), METH_NOARGS},
    {"sessionProperty", reinterpret_cast<PyCFunction>(Sbk_QNetworkSessionFunc_sessionProperty), METH_O},
    {"setSessionProperty", reinterpret_cast<PyCFunction>(Sbk_QNetworkSessionFunc_setSessionProperty), METH_VARARGS},
    {"state", reinterpret_cast<PyCFunction>(Sbk_QNetworkSessionFunc_state), METH_NOARGS},
    {"stop", reinterpret_cast<PyCFunction>(Sbk_QNetworkSessionFunc_stop), METH_NOARGS},
    {"usagePolicies", reinterpret_cast<PyCFunction>(Sbk_QNetworkSessionFunc_usagePolicies), METH_NOARGS},
    {"waitForOpened", reinterpret_cast<PyCFunction>(Sbk_QNetworkSessionFunc_waitForOpened), METH_VARARGS|METH_KEYWORDS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QNetworkSession_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QNetworkSession *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QNetworkSessionWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QNetworkSession_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QNetworkSession_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QNetworkSession_Type = nullptr;
static SbkObjectType *Sbk_QNetworkSession_TypeF(void)
{
    return _Sbk_QNetworkSession_Type;
}

static PyType_Slot Sbk_QNetworkSession_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QNetworkSession_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QNetworkSession_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QNetworkSession_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QNetworkSession_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QNetworkSession_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QNetworkSession_spec = {
    "2:PySide2.QtNetwork.QNetworkSession",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QNetworkSession_slots
};

} //extern "C"

static void *Sbk_QNetworkSession_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QNetworkSession *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}

PyObject *SbkPySide2_QtNetwork_QNetworkSession_UsagePolicy___and__(PyObject *self, PyObject *pyArg)
{
    ::QNetworkSession::UsagePolicies cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QNetworkSession::UsagePolicies>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QNetworkSession::UsagePolicies>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QNetworkSession::UsagePolicies>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QNetworkSession::UsagePolicies>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKSESSION_USAGEPOLICY_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtNetwork_QNetworkSession_UsagePolicy___or__(PyObject *self, PyObject *pyArg)
{
    ::QNetworkSession::UsagePolicies cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QNetworkSession::UsagePolicies>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QNetworkSession::UsagePolicies>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QNetworkSession::UsagePolicies>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QNetworkSession::UsagePolicies>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKSESSION_USAGEPOLICY_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtNetwork_QNetworkSession_UsagePolicy___xor__(PyObject *self, PyObject *pyArg)
{
    ::QNetworkSession::UsagePolicies cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QNetworkSession::UsagePolicies>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QNetworkSession::UsagePolicies>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QNetworkSession::UsagePolicies>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QNetworkSession::UsagePolicies>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKSESSION_USAGEPOLICY_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtNetwork_QNetworkSession_UsagePolicy___invert__(PyObject *self, PyObject *pyArg)
{
    ::QNetworkSession::UsagePolicies cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKSESSION_USAGEPOLICY_IDX])->converter, self, &cppSelf);
    ::QNetworkSession::UsagePolicies cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKSESSION_USAGEPOLICY_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtNetwork_QNetworkSession_UsagePolicy_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKSESSION_USAGEPOLICY_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtNetwork_QNetworkSession_UsagePolicy__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKSESSION_USAGEPOLICY_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtNetwork_QNetworkSession_UsagePolicy_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkSession_UsagePolicy__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkSession_UsagePolicy__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkSession_UsagePolicy_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkSession_UsagePolicy___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkSession_UsagePolicy___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkSession_UsagePolicy___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkSession_UsagePolicy___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkSession_UsagePolicy_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkSession_UsagePolicy_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkSession_UsagePolicy_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QNetworkSession_State_PythonToCpp_QNetworkSession_State(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QNetworkSession::State *>(cppOut) =
        static_cast<::QNetworkSession::State>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QNetworkSession_State_PythonToCpp_QNetworkSession_State_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_STATE_IDX]))
        return QNetworkSession_State_PythonToCpp_QNetworkSession_State;
    return {};
}
static PyObject *QNetworkSession_State_CppToPython_QNetworkSession_State(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QNetworkSession::State *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_STATE_IDX], castCppIn);

}

static void QNetworkSession_SessionError_PythonToCpp_QNetworkSession_SessionError(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QNetworkSession::SessionError *>(cppOut) =
        static_cast<::QNetworkSession::SessionError>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QNetworkSession_SessionError_PythonToCpp_QNetworkSession_SessionError_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_SESSIONERROR_IDX]))
        return QNetworkSession_SessionError_PythonToCpp_QNetworkSession_SessionError;
    return {};
}
static PyObject *QNetworkSession_SessionError_CppToPython_QNetworkSession_SessionError(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QNetworkSession::SessionError *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_SESSIONERROR_IDX], castCppIn);

}

static void QNetworkSession_UsagePolicy_PythonToCpp_QNetworkSession_UsagePolicy(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QNetworkSession::UsagePolicy *>(cppOut) =
        static_cast<::QNetworkSession::UsagePolicy>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QNetworkSession_UsagePolicy_PythonToCpp_QNetworkSession_UsagePolicy_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_USAGEPOLICY_IDX]))
        return QNetworkSession_UsagePolicy_PythonToCpp_QNetworkSession_UsagePolicy;
    return {};
}
static PyObject *QNetworkSession_UsagePolicy_CppToPython_QNetworkSession_UsagePolicy(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QNetworkSession::UsagePolicy *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_USAGEPOLICY_IDX], castCppIn);

}

static void QFlags_QNetworkSession_UsagePolicy__PythonToCpp_QFlags_QNetworkSession_UsagePolicy_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QNetworkSession::UsagePolicy> *>(cppOut) =
        ::QFlags<QNetworkSession::UsagePolicy>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QNetworkSession_UsagePolicy__PythonToCpp_QFlags_QNetworkSession_UsagePolicy__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKSESSION_USAGEPOLICY_IDX]))
        return QFlags_QNetworkSession_UsagePolicy__PythonToCpp_QFlags_QNetworkSession_UsagePolicy_;
    return {};
}
static PyObject *QFlags_QNetworkSession_UsagePolicy__CppToPython_QFlags_QNetworkSession_UsagePolicy_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QNetworkSession::UsagePolicy> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKSESSION_USAGEPOLICY_IDX]));

}

static void QNetworkSession_UsagePolicy_PythonToCpp_QFlags_QNetworkSession_UsagePolicy_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QNetworkSession::UsagePolicy> *>(cppOut) =
        ::QFlags<QNetworkSession::UsagePolicy>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QNetworkSession_UsagePolicy_PythonToCpp_QFlags_QNetworkSession_UsagePolicy__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_USAGEPOLICY_IDX]))
        return QNetworkSession_UsagePolicy_PythonToCpp_QFlags_QNetworkSession_UsagePolicy_;
    return {};
}
static void number_PythonToCpp_QFlags_QNetworkSession_UsagePolicy_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QNetworkSession::UsagePolicy> *>(cppOut) =
        ::QFlags<QNetworkSession::UsagePolicy>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QNetworkSession_UsagePolicy__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_USAGEPOLICY_IDX]))
        return number_PythonToCpp_QFlags_QNetworkSession_UsagePolicy_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QNetworkSession_PythonToCpp_QNetworkSession_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QNetworkSession_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QNetworkSession_PythonToCpp_QNetworkSession_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QNetworkSession_TypeF())))
        return QNetworkSession_PythonToCpp_QNetworkSession_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QNetworkSession_PTR_CppToPython_QNetworkSession(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QNetworkSession *>(const_cast<void *>(cppIn)), Sbk_QNetworkSession_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QNetworkSession_SignatureStrings[] = {
    "PySide2.QtNetwork.QNetworkSession(self,connConfig:PySide2.QtNetwork.QNetworkConfiguration,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtNetwork.QNetworkSession.accept(self)",
    "PySide2.QtNetwork.QNetworkSession.activeTime(self)->quint64",
    "PySide2.QtNetwork.QNetworkSession.bytesReceived(self)->quint64",
    "PySide2.QtNetwork.QNetworkSession.bytesWritten(self)->quint64",
    "PySide2.QtNetwork.QNetworkSession.close(self)",
    "PySide2.QtNetwork.QNetworkSession.configuration(self)->PySide2.QtNetwork.QNetworkConfiguration",
    "PySide2.QtNetwork.QNetworkSession.connectNotify(self,signal:PySide2.QtCore.QMetaMethod)",
    "PySide2.QtNetwork.QNetworkSession.disconnectNotify(self,signal:PySide2.QtCore.QMetaMethod)",
    "PySide2.QtNetwork.QNetworkSession.error(self)->PySide2.QtNetwork.QNetworkSession.SessionError",
    "PySide2.QtNetwork.QNetworkSession.errorString(self)->QString",
    "PySide2.QtNetwork.QNetworkSession.ignore(self)",
    "PySide2.QtNetwork.QNetworkSession.interface(self)->PySide2.QtNetwork.QNetworkInterface",
    "PySide2.QtNetwork.QNetworkSession.isOpen(self)->bool",
    "PySide2.QtNetwork.QNetworkSession.migrate(self)",
    "PySide2.QtNetwork.QNetworkSession.open(self)",
    "PySide2.QtNetwork.QNetworkSession.reject(self)",
    "PySide2.QtNetwork.QNetworkSession.sessionProperty(self,key:QString)->QVariant",
    "PySide2.QtNetwork.QNetworkSession.setSessionProperty(self,key:QString,value:QVariant)",
    "PySide2.QtNetwork.QNetworkSession.state(self)->PySide2.QtNetwork.QNetworkSession.State",
    "PySide2.QtNetwork.QNetworkSession.stop(self)",
    "PySide2.QtNetwork.QNetworkSession.usagePolicies(self)->PySide2.QtNetwork.QNetworkSession.UsagePolicies",
    "PySide2.QtNetwork.QNetworkSession.waitForOpened(self,msecs:int=30000)->bool",
    nullptr}; // Sentinel

void init_QNetworkSession(PyObject *module)
{
    _Sbk_QNetworkSession_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QNetworkSession",
        "QNetworkSession*",
        &Sbk_QNetworkSession_spec,
        &Shiboken::callCppDestructor< ::QNetworkSession >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QNetworkSession_Type);
    InitSignatureStrings(pyType, QNetworkSession_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QNetworkSession_Type), Sbk_QNetworkSession_PropertyStrings);
    SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QNetworkSession_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QNetworkSession_TypeF(),
        QNetworkSession_PythonToCpp_QNetworkSession_PTR,
        is_QNetworkSession_PythonToCpp_QNetworkSession_PTR_Convertible,
        QNetworkSession_PTR_CppToPython_QNetworkSession);

    Shiboken::Conversions::registerConverterName(converter, "QNetworkSession");
    Shiboken::Conversions::registerConverterName(converter, "QNetworkSession*");
    Shiboken::Conversions::registerConverterName(converter, "QNetworkSession&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QNetworkSession).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QNetworkSessionWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QNetworkSession_TypeF(), &Sbk_QNetworkSession_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'State'.
    SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_STATE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QNetworkSession_TypeF(),
        "State",
        "2:PySide2.QtNetwork.QNetworkSession.State",
        "QNetworkSession::State");
    if (!SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_STATE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_STATE_IDX],
        Sbk_QNetworkSession_TypeF(), "Invalid", (long) QNetworkSession::State::Invalid))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_STATE_IDX],
        Sbk_QNetworkSession_TypeF(), "NotAvailable", (long) QNetworkSession::State::NotAvailable))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_STATE_IDX],
        Sbk_QNetworkSession_TypeF(), "Connecting", (long) QNetworkSession::State::Connecting))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_STATE_IDX],
        Sbk_QNetworkSession_TypeF(), "Connected", (long) QNetworkSession::State::Connected))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_STATE_IDX],
        Sbk_QNetworkSession_TypeF(), "Closing", (long) QNetworkSession::State::Closing))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_STATE_IDX],
        Sbk_QNetworkSession_TypeF(), "Disconnected", (long) QNetworkSession::State::Disconnected))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_STATE_IDX],
        Sbk_QNetworkSession_TypeF(), "Roaming", (long) QNetworkSession::State::Roaming))
        return;
    // Register converter for enum 'QNetworkSession::State'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_STATE_IDX],
            QNetworkSession_State_CppToPython_QNetworkSession_State);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QNetworkSession_State_PythonToCpp_QNetworkSession_State,
            is_QNetworkSession_State_PythonToCpp_QNetworkSession_State_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_STATE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QNetworkSession::State");
        Shiboken::Conversions::registerConverterName(converter, "State");
    }
    // End of 'State' enum.

    // Initialization of enum 'SessionError'.
    SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_SESSIONERROR_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QNetworkSession_TypeF(),
        "SessionError",
        "2:PySide2.QtNetwork.QNetworkSession.SessionError",
        "QNetworkSession::SessionError");
    if (!SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_SESSIONERROR_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_SESSIONERROR_IDX],
        Sbk_QNetworkSession_TypeF(), "UnknownSessionError", (long) QNetworkSession::SessionError::UnknownSessionError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_SESSIONERROR_IDX],
        Sbk_QNetworkSession_TypeF(), "SessionAbortedError", (long) QNetworkSession::SessionError::SessionAbortedError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_SESSIONERROR_IDX],
        Sbk_QNetworkSession_TypeF(), "RoamingError", (long) QNetworkSession::SessionError::RoamingError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_SESSIONERROR_IDX],
        Sbk_QNetworkSession_TypeF(), "OperationNotSupportedError", (long) QNetworkSession::SessionError::OperationNotSupportedError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_SESSIONERROR_IDX],
        Sbk_QNetworkSession_TypeF(), "InvalidConfigurationError", (long) QNetworkSession::SessionError::InvalidConfigurationError))
        return;
    // Register converter for enum 'QNetworkSession::SessionError'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_SESSIONERROR_IDX],
            QNetworkSession_SessionError_CppToPython_QNetworkSession_SessionError);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QNetworkSession_SessionError_PythonToCpp_QNetworkSession_SessionError,
            is_QNetworkSession_SessionError_PythonToCpp_QNetworkSession_SessionError_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_SESSIONERROR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QNetworkSession::SessionError");
        Shiboken::Conversions::registerConverterName(converter, "SessionError");
    }
    // End of 'SessionError' enum.

    // Initialization of enum 'UsagePolicy'.
    SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKSESSION_USAGEPOLICY_IDX] = PySide::QFlags::create("2:PySide2.QtNetwork.QNetworkSession.UsagePolicies", SbkPySide2_QtNetwork_QNetworkSession_UsagePolicy_number_slots);
    SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_USAGEPOLICY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QNetworkSession_TypeF(),
        "UsagePolicy",
        "2:PySide2.QtNetwork.QNetworkSession.UsagePolicy",
        "QNetworkSession::UsagePolicy",
        SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKSESSION_USAGEPOLICY_IDX]);
    if (!SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_USAGEPOLICY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_USAGEPOLICY_IDX],
        Sbk_QNetworkSession_TypeF(), "NoPolicy", (long) QNetworkSession::UsagePolicy::NoPolicy))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_USAGEPOLICY_IDX],
        Sbk_QNetworkSession_TypeF(), "NoBackgroundTrafficPolicy", (long) QNetworkSession::UsagePolicy::NoBackgroundTrafficPolicy))
        return;
    // Register converter for enum 'QNetworkSession::UsagePolicy'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_USAGEPOLICY_IDX],
            QNetworkSession_UsagePolicy_CppToPython_QNetworkSession_UsagePolicy);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QNetworkSession_UsagePolicy_PythonToCpp_QNetworkSession_UsagePolicy,
            is_QNetworkSession_UsagePolicy_PythonToCpp_QNetworkSession_UsagePolicy_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKSESSION_USAGEPOLICY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QNetworkSession::UsagePolicy");
        Shiboken::Conversions::registerConverterName(converter, "UsagePolicy");
    }
    // Register converter for flag 'QFlags<QNetworkSession::UsagePolicy>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKSESSION_USAGEPOLICY_IDX],
            QFlags_QNetworkSession_UsagePolicy__CppToPython_QFlags_QNetworkSession_UsagePolicy_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QNetworkSession_UsagePolicy_PythonToCpp_QFlags_QNetworkSession_UsagePolicy_,
            is_QNetworkSession_UsagePolicy_PythonToCpp_QFlags_QNetworkSession_UsagePolicy__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QNetworkSession_UsagePolicy__PythonToCpp_QFlags_QNetworkSession_UsagePolicy_,
            is_QFlags_QNetworkSession_UsagePolicy__PythonToCpp_QFlags_QNetworkSession_UsagePolicy__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QNetworkSession_UsagePolicy_,
            is_number_PythonToCpp_QFlags_QNetworkSession_UsagePolicy__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKSESSION_USAGEPOLICY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QNetworkSession::UsagePolicies");
        Shiboken::Conversions::registerConverterName(converter, "UsagePolicies");
    }
    // End of 'UsagePolicy' enum/flags.

    PySide::Signal::registerSignals(Sbk_QNetworkSession_TypeF(), &::QNetworkSession::staticMetaObject);
    qRegisterMetaType< ::QNetworkSession::State >("QNetworkSession::State");
    qRegisterMetaType< ::QNetworkSession::SessionError >("QNetworkSession::SessionError");
    qRegisterMetaType< ::QNetworkSession::UsagePolicy >("QNetworkSession::UsagePolicy");
    qRegisterMetaType< ::QNetworkSession::UsagePolicies >("QNetworkSession::UsagePolicies");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QNetworkSession_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QNetworkSession_TypeF(), &::QNetworkSession::staticMetaObject, sizeof(QNetworkSessionWrapper));
}
