/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtnetwork_python.h"

// main header
#include "qnetworkproxyquery_wrapper.h"

// inner classes

// Extra includes
#include <QtNetwork/qnetworkconfiguration.h>
#include <QtNetwork/qnetworkproxy.h>
#include <qobject.h>
#include <qurl.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QNetworkProxyQuery_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QNetworkProxyQuery >()))
        return -1;

    ::QNetworkProxyQuery *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxyQuery.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 5) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QNetworkProxyQuery_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOO:QNetworkProxyQuery", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return -1;


    // Overloaded function decisor
    // 0: QNetworkProxyQuery::QNetworkProxyQuery()
    // 1: QNetworkProxyQuery::QNetworkProxyQuery(QNetworkConfiguration,QString,int,QString,QNetworkProxyQuery::QueryType)
    // 2: QNetworkProxyQuery::QNetworkProxyQuery(QNetworkConfiguration,QUrl,QNetworkProxyQuery::QueryType)
    // 3: QNetworkProxyQuery::QNetworkProxyQuery(QNetworkConfiguration,quint16,QString,QNetworkProxyQuery::QueryType)
    // 4: QNetworkProxyQuery::QNetworkProxyQuery(QNetworkProxyQuery)
    // 5: QNetworkProxyQuery::QNetworkProxyQuery(QString,int,QString,QNetworkProxyQuery::QueryType)
    // 6: QNetworkProxyQuery::QNetworkProxyQuery(QUrl,QNetworkProxyQuery::QueryType)
    // 7: QNetworkProxyQuery::QNetworkProxyQuery(quint16,QString,QNetworkProxyQuery::QueryType)
    if (numArgs == 0) {
        overloadId = 0; // QNetworkProxyQuery()
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint16>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 7; // QNetworkProxyQuery(quint16,QString,QNetworkProxyQuery::QueryType)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 7; // QNetworkProxyQuery(quint16,QString,QNetworkProxyQuery::QueryType)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_QUERYTYPE_IDX])->converter, (pyArgs[2])))) {
                overloadId = 7; // QNetworkProxyQuery(quint16,QString,QNetworkProxyQuery::QueryType)
            }
        }
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 5; // QNetworkProxyQuery(QString,int,QString,QNetworkProxyQuery::QueryType)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 5; // QNetworkProxyQuery(QString,int,QString,QNetworkProxyQuery::QueryType)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_QUERYTYPE_IDX])->converter, (pyArgs[3])))) {
                overloadId = 5; // QNetworkProxyQuery(QString,int,QString,QNetworkProxyQuery::QueryType)
            }
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 6; // QNetworkProxyQuery(QUrl,QNetworkProxyQuery::QueryType)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_QUERYTYPE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 6; // QNetworkProxyQuery(QUrl,QNetworkProxyQuery::QueryType)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_IDX]), (pyArgs[0])))) {
        overloadId = 4; // QNetworkProxyQuery(QNetworkProxyQuery)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX]), (pyArgs[0])))) {
        if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint16>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 3; // QNetworkProxyQuery(QNetworkConfiguration,quint16,QString,QNetworkProxyQuery::QueryType)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 3; // QNetworkProxyQuery(QNetworkConfiguration,quint16,QString,QNetworkProxyQuery::QueryType)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_QUERYTYPE_IDX])->converter, (pyArgs[3])))) {
                    overloadId = 3; // QNetworkProxyQuery(QNetworkConfiguration,quint16,QString,QNetworkProxyQuery::QueryType)
                }
            }
        } else if (numArgs >= 3
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 1; // QNetworkProxyQuery(QNetworkConfiguration,QString,int,QString,QNetworkProxyQuery::QueryType)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3])))) {
                if (numArgs == 4) {
                    overloadId = 1; // QNetworkProxyQuery(QNetworkConfiguration,QString,int,QString,QNetworkProxyQuery::QueryType)
                } else if (numArgs >= 5
                    && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_QUERYTYPE_IDX])->converter, (pyArgs[4])))) {
                    overloadId = 1; // QNetworkProxyQuery(QNetworkConfiguration,QString,int,QString,QNetworkProxyQuery::QueryType)
                }
            }
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 2; // QNetworkProxyQuery(QNetworkConfiguration,QUrl,QNetworkProxyQuery::QueryType)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_QUERYTYPE_IDX])->converter, (pyArgs[2])))) {
                overloadId = 2; // QNetworkProxyQuery(QNetworkConfiguration,QUrl,QNetworkProxyQuery::QueryType)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkProxyQuery_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QNetworkProxyQuery()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QNetworkProxyQuery_Init_TypeError;
            }

            if (!PyErr_Occurred()) {
                // QNetworkProxyQuery()
                cptr = new ::QNetworkProxyQuery();
            }
            break;
        }
        case 1: // QNetworkProxyQuery(const QNetworkConfiguration & networkConfiguration, const QString & hostname, int port, const QString & protocolTag, QNetworkProxyQuery::QueryType queryType)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_protocolTag = Shiboken::String::createStaticString("protocolTag");
                if (PyDict_Contains(kwds, key_protocolTag)) {
                    value = PyDict_GetItem(kwds, key_protocolTag);
                    if (value && pyArgs[3]) {
                        errInfo = key_protocolTag;
                        Py_INCREF(errInfo);
                        goto Sbk_QNetworkProxyQuery_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3]))))
                            goto Sbk_QNetworkProxyQuery_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_protocolTag);
                }
                static PyObject *const key_queryType = Shiboken::String::createStaticString("queryType");
                if (PyDict_Contains(kwds, key_queryType)) {
                    value = PyDict_GetItem(kwds, key_queryType);
                    if (value && pyArgs[4]) {
                        errInfo = key_queryType;
                        Py_INCREF(errInfo);
                        goto Sbk_QNetworkProxyQuery_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_QUERYTYPE_IDX])->converter, (pyArgs[4]))))
                            goto Sbk_QNetworkProxyQuery_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_queryType);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QNetworkProxyQuery_Init_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QNetworkConfiguration cppArg0_local;
            ::QNetworkConfiguration *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3 = QString();
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
            ::QNetworkProxyQuery::QueryType cppArg4 = QNetworkProxyQuery::QueryType::TcpSocket;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // QNetworkProxyQuery(QNetworkConfiguration,QString,int,QString,QNetworkProxyQuery::QueryType)
                cptr = new ::QNetworkProxyQuery(*cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QNetworkProxyQuery.QNetworkProxyQuery(const QNetworkConfiguration & networkConfiguration, const QString & hostname, int port, const QString & protocolTag, QNetworkProxyQuery::QueryType queryType) is deprecated", 1);
            break;
        }
        case 2: // QNetworkProxyQuery(const QNetworkConfiguration & networkConfiguration, const QUrl & requestUrl, QNetworkProxyQuery::QueryType queryType)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_queryType = Shiboken::String::createStaticString("queryType");
                if (PyDict_Contains(kwds, key_queryType)) {
                    value = PyDict_GetItem(kwds, key_queryType);
                    if (value && pyArgs[2]) {
                        errInfo = key_queryType;
                        Py_INCREF(errInfo);
                        goto Sbk_QNetworkProxyQuery_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_QUERYTYPE_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QNetworkProxyQuery_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_queryType);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QNetworkProxyQuery_Init_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QNetworkConfiguration cppArg0_local;
            ::QNetworkConfiguration *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QUrl cppArg1_local;
            ::QUrl *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            ::QNetworkProxyQuery::QueryType cppArg2 = QNetworkProxyQuery::QueryType::UrlRequest;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QNetworkProxyQuery(QNetworkConfiguration,QUrl,QNetworkProxyQuery::QueryType)
                cptr = new ::QNetworkProxyQuery(*cppArg0, *cppArg1, cppArg2);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QNetworkProxyQuery.QNetworkProxyQuery(const QNetworkConfiguration & networkConfiguration, const QUrl & requestUrl, QNetworkProxyQuery::QueryType queryType) is deprecated", 1);
            break;
        }
        case 3: // QNetworkProxyQuery(const QNetworkConfiguration & networkConfiguration, quint16 bindPort, const QString & protocolTag, QNetworkProxyQuery::QueryType queryType)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_protocolTag = Shiboken::String::createStaticString("protocolTag");
                if (PyDict_Contains(kwds, key_protocolTag)) {
                    value = PyDict_GetItem(kwds, key_protocolTag);
                    if (value && pyArgs[2]) {
                        errInfo = key_protocolTag;
                        Py_INCREF(errInfo);
                        goto Sbk_QNetworkProxyQuery_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2]))))
                            goto Sbk_QNetworkProxyQuery_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_protocolTag);
                }
                static PyObject *const key_queryType = Shiboken::String::createStaticString("queryType");
                if (PyDict_Contains(kwds, key_queryType)) {
                    value = PyDict_GetItem(kwds, key_queryType);
                    if (value && pyArgs[3]) {
                        errInfo = key_queryType;
                        Py_INCREF(errInfo);
                        goto Sbk_QNetworkProxyQuery_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_QUERYTYPE_IDX])->converter, (pyArgs[3]))))
                            goto Sbk_QNetworkProxyQuery_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_queryType);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QNetworkProxyQuery_Init_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QNetworkConfiguration cppArg0_local;
            ::QNetworkConfiguration *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            quint16 cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2 = QString();
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QNetworkProxyQuery::QueryType cppArg3 = QNetworkProxyQuery::QueryType::TcpServer;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // QNetworkProxyQuery(QNetworkConfiguration,quint16,QString,QNetworkProxyQuery::QueryType)
                cptr = new ::QNetworkProxyQuery(*cppArg0, cppArg1, cppArg2, cppArg3);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QNetworkProxyQuery.QNetworkProxyQuery(const QNetworkConfiguration & networkConfiguration, quint16 bindPort, const QString & protocolTag, QNetworkProxyQuery::QueryType queryType) is deprecated", 1);
            break;
        }
        case 4: // QNetworkProxyQuery(const QNetworkProxyQuery & other)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QNetworkProxyQuery_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QNetworkProxyQuery cppArg0_local;
            ::QNetworkProxyQuery *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QNetworkProxyQuery(QNetworkProxyQuery)
                cptr = new ::QNetworkProxyQuery(*cppArg0);
            }
            break;
        }
        case 5: // QNetworkProxyQuery(const QString & hostname, int port, const QString & protocolTag, QNetworkProxyQuery::QueryType queryType)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_protocolTag = Shiboken::String::createStaticString("protocolTag");
                if (PyDict_Contains(kwds, key_protocolTag)) {
                    value = PyDict_GetItem(kwds, key_protocolTag);
                    if (value && pyArgs[2]) {
                        errInfo = key_protocolTag;
                        Py_INCREF(errInfo);
                        goto Sbk_QNetworkProxyQuery_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2]))))
                            goto Sbk_QNetworkProxyQuery_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_protocolTag);
                }
                static PyObject *const key_queryType = Shiboken::String::createStaticString("queryType");
                if (PyDict_Contains(kwds, key_queryType)) {
                    value = PyDict_GetItem(kwds, key_queryType);
                    if (value && pyArgs[3]) {
                        errInfo = key_queryType;
                        Py_INCREF(errInfo);
                        goto Sbk_QNetworkProxyQuery_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_QUERYTYPE_IDX])->converter, (pyArgs[3]))))
                            goto Sbk_QNetworkProxyQuery_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_queryType);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QNetworkProxyQuery_Init_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2 = QString();
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QNetworkProxyQuery::QueryType cppArg3 = QNetworkProxyQuery::QueryType::TcpSocket;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // QNetworkProxyQuery(QString,int,QString,QNetworkProxyQuery::QueryType)
                cptr = new ::QNetworkProxyQuery(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 6: // QNetworkProxyQuery(const QUrl & requestUrl, QNetworkProxyQuery::QueryType queryType)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_queryType = Shiboken::String::createStaticString("queryType");
                if (PyDict_Contains(kwds, key_queryType)) {
                    value = PyDict_GetItem(kwds, key_queryType);
                    if (value && pyArgs[1]) {
                        errInfo = key_queryType;
                        Py_INCREF(errInfo);
                        goto Sbk_QNetworkProxyQuery_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_QUERYTYPE_IDX])->converter, (pyArgs[1]))))
                            goto Sbk_QNetworkProxyQuery_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_queryType);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QNetworkProxyQuery_Init_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QUrl cppArg0_local;
            ::QUrl *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QNetworkProxyQuery::QueryType cppArg1 = QNetworkProxyQuery::QueryType::UrlRequest;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QNetworkProxyQuery(QUrl,QNetworkProxyQuery::QueryType)
                cptr = new ::QNetworkProxyQuery(*cppArg0, cppArg1);
            }
            break;
        }
        case 7: // QNetworkProxyQuery(quint16 bindPort, const QString & protocolTag, QNetworkProxyQuery::QueryType queryType)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_protocolTag = Shiboken::String::createStaticString("protocolTag");
                if (PyDict_Contains(kwds, key_protocolTag)) {
                    value = PyDict_GetItem(kwds, key_protocolTag);
                    if (value && pyArgs[1]) {
                        errInfo = key_protocolTag;
                        Py_INCREF(errInfo);
                        goto Sbk_QNetworkProxyQuery_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                            goto Sbk_QNetworkProxyQuery_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_protocolTag);
                }
                static PyObject *const key_queryType = Shiboken::String::createStaticString("queryType");
                if (PyDict_Contains(kwds, key_queryType)) {
                    value = PyDict_GetItem(kwds, key_queryType);
                    if (value && pyArgs[2]) {
                        errInfo = key_queryType;
                        Py_INCREF(errInfo);
                        goto Sbk_QNetworkProxyQuery_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_QUERYTYPE_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QNetworkProxyQuery_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_queryType);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QNetworkProxyQuery_Init_TypeError;
                }
            }
            quint16 cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1 = QString();
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QNetworkProxyQuery::QueryType cppArg2 = QNetworkProxyQuery::QueryType::TcpServer;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QNetworkProxyQuery(quint16,QString,QNetworkProxyQuery::QueryType)
                cptr = new ::QNetworkProxyQuery(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QNetworkProxyQuery >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QNetworkProxyQuery_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QNetworkProxyQuery_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QNetworkProxyQueryFunc_localPort(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkProxyQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxyQuery.localPort";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // localPort()const
            int cppResult = const_cast<const ::QNetworkProxyQuery *>(cppSelf)->localPort();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkProxyQueryFunc_networkConfiguration(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkProxyQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxyQuery.networkConfiguration";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // networkConfiguration()const
            QNetworkConfiguration cppResult = const_cast<const ::QNetworkProxyQuery *>(cppSelf)->networkConfiguration();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkProxyQueryFunc_peerHostName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkProxyQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxyQuery.peerHostName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // peerHostName()const
            QString cppResult = const_cast<const ::QNetworkProxyQuery *>(cppSelf)->peerHostName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkProxyQueryFunc_peerPort(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkProxyQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxyQuery.peerPort";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // peerPort()const
            int cppResult = const_cast<const ::QNetworkProxyQuery *>(cppSelf)->peerPort();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkProxyQueryFunc_protocolTag(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkProxyQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxyQuery.protocolTag";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // protocolTag()const
            QString cppResult = const_cast<const ::QNetworkProxyQuery *>(cppSelf)->protocolTag();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkProxyQueryFunc_queryType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkProxyQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxyQuery.queryType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // queryType()const
            QNetworkProxyQuery::QueryType cppResult = const_cast<const ::QNetworkProxyQuery *>(cppSelf)->queryType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_QUERYTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkProxyQueryFunc_setLocalPort(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkProxyQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxyQuery.setLocalPort";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkProxyQuery::setLocalPort(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setLocalPort(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkProxyQueryFunc_setLocalPort_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLocalPort(int)
            cppSelf->setLocalPort(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkProxyQueryFunc_setLocalPort_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkProxyQueryFunc_setNetworkConfiguration(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkProxyQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxyQuery.setNetworkConfiguration";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkProxyQuery::setNetworkConfiguration(QNetworkConfiguration)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX]), (pyArg)))) {
        overloadId = 0; // setNetworkConfiguration(QNetworkConfiguration)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkProxyQueryFunc_setNetworkConfiguration_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QNetworkConfiguration cppArg0_local;
        ::QNetworkConfiguration *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setNetworkConfiguration(QNetworkConfiguration)
            cppSelf->setNetworkConfiguration(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkProxyQueryFunc_setNetworkConfiguration_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkProxyQueryFunc_setPeerHostName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkProxyQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxyQuery.setPeerHostName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkProxyQuery::setPeerHostName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setPeerHostName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkProxyQueryFunc_setPeerHostName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPeerHostName(QString)
            cppSelf->setPeerHostName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkProxyQueryFunc_setPeerHostName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkProxyQueryFunc_setPeerPort(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkProxyQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxyQuery.setPeerPort";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkProxyQuery::setPeerPort(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setPeerPort(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkProxyQueryFunc_setPeerPort_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPeerPort(int)
            cppSelf->setPeerPort(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkProxyQueryFunc_setPeerPort_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkProxyQueryFunc_setProtocolTag(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkProxyQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxyQuery.setProtocolTag";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkProxyQuery::setProtocolTag(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setProtocolTag(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkProxyQueryFunc_setProtocolTag_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setProtocolTag(QString)
            cppSelf->setProtocolTag(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkProxyQueryFunc_setProtocolTag_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkProxyQueryFunc_setQueryType(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkProxyQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxyQuery.setQueryType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkProxyQuery::setQueryType(QNetworkProxyQuery::QueryType)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_QUERYTYPE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setQueryType(QNetworkProxyQuery::QueryType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkProxyQueryFunc_setQueryType_TypeError;

    // Call function/method
    {
        ::QNetworkProxyQuery::QueryType cppArg0{QNetworkProxyQuery::TcpSocket};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setQueryType(QNetworkProxyQuery::QueryType)
            cppSelf->setQueryType(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkProxyQueryFunc_setQueryType_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkProxyQueryFunc_setUrl(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkProxyQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxyQuery.setUrl";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkProxyQuery::setUrl(QUrl)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
        overloadId = 0; // setUrl(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkProxyQueryFunc_setUrl_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setUrl(QUrl)
            cppSelf->setUrl(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkProxyQueryFunc_setUrl_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkProxyQueryFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkProxyQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxyQuery.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkProxyQuery::swap(QNetworkProxyQuery&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QNetworkProxyQuery&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkProxyQueryFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QNetworkProxyQuery cppArg0_local;
        ::QNetworkProxyQuery *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QNetworkProxyQuery&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkProxyQueryFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkProxyQueryFunc_url(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkProxyQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxyQuery.url";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // url()const
            QUrl cppResult = const_cast<const ::QNetworkProxyQuery *>(cppSelf)->url();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkProxyQuery___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QNetworkProxyQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QNetworkProxyQuery_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QNetworkProxyQuery_methods[] = {
    {"localPort", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyQueryFunc_localPort), METH_NOARGS},
    {"networkConfiguration", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyQueryFunc_networkConfiguration), METH_NOARGS},
    {"peerHostName", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyQueryFunc_peerHostName), METH_NOARGS},
    {"peerPort", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyQueryFunc_peerPort), METH_NOARGS},
    {"protocolTag", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyQueryFunc_protocolTag), METH_NOARGS},
    {"queryType", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyQueryFunc_queryType), METH_NOARGS},
    {"setLocalPort", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyQueryFunc_setLocalPort), METH_O},
    {"setNetworkConfiguration", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyQueryFunc_setNetworkConfiguration), METH_O},
    {"setPeerHostName", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyQueryFunc_setPeerHostName), METH_O},
    {"setPeerPort", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyQueryFunc_setPeerPort), METH_O},
    {"setProtocolTag", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyQueryFunc_setProtocolTag), METH_O},
    {"setQueryType", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyQueryFunc_setQueryType), METH_O},
    {"setUrl", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyQueryFunc_setUrl), METH_O},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyQueryFunc_swap), METH_O},
    {"url", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyQueryFunc_url), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyQuery___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QNetworkProxyQuery_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QNetworkProxyQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_IDX]), (pyArg)))) {
                // operator!=(const QNetworkProxyQuery & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QNetworkProxyQuery cppArg0_local;
                ::QNetworkProxyQuery *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_IDX]), (pyArg)))) {
                // operator==(const QNetworkProxyQuery & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QNetworkProxyQuery cppArg0_local;
                ::QNetworkProxyQuery *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QNetworkProxyQuery_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QNetworkProxyQuery_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QNetworkProxyQuery_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QNetworkProxyQuery_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QNetworkProxyQuery__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkProxyQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QNetworkProxyQuery_Type = nullptr;
static SbkObjectType *Sbk_QNetworkProxyQuery_TypeF(void)
{
    return _Sbk_QNetworkProxyQuery_Type;
}

static PyType_Slot Sbk_QNetworkProxyQuery_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QNetworkProxyQuery__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QNetworkProxyQuery_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QNetworkProxyQuery_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QNetworkProxyQuery_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QNetworkProxyQuery_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QNetworkProxyQuery_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QNetworkProxyQuery_spec = {
    "2:PySide2.QtNetwork.QNetworkProxyQuery",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QNetworkProxyQuery_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QNetworkProxyQuery_QueryType_PythonToCpp_QNetworkProxyQuery_QueryType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QNetworkProxyQuery::QueryType *>(cppOut) =
        static_cast<::QNetworkProxyQuery::QueryType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QNetworkProxyQuery_QueryType_PythonToCpp_QNetworkProxyQuery_QueryType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_QUERYTYPE_IDX]))
        return QNetworkProxyQuery_QueryType_PythonToCpp_QNetworkProxyQuery_QueryType;
    return {};
}
static PyObject *QNetworkProxyQuery_QueryType_CppToPython_QNetworkProxyQuery_QueryType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QNetworkProxyQuery::QueryType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_QUERYTYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QNetworkProxyQuery_PythonToCpp_QNetworkProxyQuery_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QNetworkProxyQuery_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QNetworkProxyQuery_PythonToCpp_QNetworkProxyQuery_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QNetworkProxyQuery_TypeF())))
        return QNetworkProxyQuery_PythonToCpp_QNetworkProxyQuery_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QNetworkProxyQuery_PTR_CppToPython_QNetworkProxyQuery(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QNetworkProxyQuery *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QNetworkProxyQuery_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QNetworkProxyQuery_COPY_CppToPython_QNetworkProxyQuery(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QNetworkProxyQuery_TypeF(), new ::QNetworkProxyQuery(*reinterpret_cast<const ::QNetworkProxyQuery *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QNetworkProxyQuery_PythonToCpp_QNetworkProxyQuery_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QNetworkProxyQuery *>(cppOut) = *reinterpret_cast< ::QNetworkProxyQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QNetworkProxyQuery_PythonToCpp_QNetworkProxyQuery_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QNetworkProxyQuery_TypeF())))
        return QNetworkProxyQuery_PythonToCpp_QNetworkProxyQuery_COPY;
    return {};
}

// Implicit conversions.
static void PySide2_QtCore_constQUrlREF_PythonToCpp_QNetworkProxyQuery(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QNetworkProxyQuery *>(cppOut) = ::QNetworkProxyQuery( *reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_PySide2_QtCore_constQUrlREF_PythonToCpp_QNetworkProxyQuery_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QURL_IDX], pyIn))
        return PySide2_QtCore_constQUrlREF_PythonToCpp_QNetworkProxyQuery;
    return {};
}

static void PySide2_QtCore_quint16_PythonToCpp_QNetworkProxyQuery(PyObject *pyIn, void *cppOut) {
    quint16 cppIn;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<quint16>(), pyIn, &cppIn);
    *reinterpret_cast<::QNetworkProxyQuery *>(cppOut) = ::QNetworkProxyQuery(cppIn);
}
static PythonToCppFunc is_PySide2_QtCore_quint16_PythonToCpp_QNetworkProxyQuery_Convertible(PyObject *pyIn) {
    if (PyInt_Check(pyIn))
        return PySide2_QtCore_quint16_PythonToCpp_QNetworkProxyQuery;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QNetworkProxyQuery_SignatureStrings[] = {
    "7:PySide2.QtNetwork.QNetworkProxyQuery(self)",
    "6:PySide2.QtNetwork.QNetworkProxyQuery(self,networkConfiguration:PySide2.QtNetwork.QNetworkConfiguration,hostname:QString,port:int,protocolTag:QString=QString(),queryType:PySide2.QtNetwork.QNetworkProxyQuery.QueryType=TcpSocket)",
    "5:PySide2.QtNetwork.QNetworkProxyQuery(self,networkConfiguration:PySide2.QtNetwork.QNetworkConfiguration,requestUrl:PySide2.QtCore.QUrl,queryType:PySide2.QtNetwork.QNetworkProxyQuery.QueryType=UrlRequest)",
    "4:PySide2.QtNetwork.QNetworkProxyQuery(self,networkConfiguration:PySide2.QtNetwork.QNetworkConfiguration,bindPort:quint16,protocolTag:QString=QString(),queryType:PySide2.QtNetwork.QNetworkProxyQuery.QueryType=TcpServer)",
    "3:PySide2.QtNetwork.QNetworkProxyQuery(self,other:PySide2.QtNetwork.QNetworkProxyQuery)",
    "2:PySide2.QtNetwork.QNetworkProxyQuery(self,hostname:QString,port:int,protocolTag:QString=QString(),queryType:PySide2.QtNetwork.QNetworkProxyQuery.QueryType=TcpSocket)",
    "1:PySide2.QtNetwork.QNetworkProxyQuery(self,requestUrl:PySide2.QtCore.QUrl,queryType:PySide2.QtNetwork.QNetworkProxyQuery.QueryType=UrlRequest)",
    "0:PySide2.QtNetwork.QNetworkProxyQuery(self,bindPort:quint16,protocolTag:QString=QString(),queryType:PySide2.QtNetwork.QNetworkProxyQuery.QueryType=TcpServer)",
    "PySide2.QtNetwork.QNetworkProxyQuery.localPort(self)->int",
    "PySide2.QtNetwork.QNetworkProxyQuery.networkConfiguration(self)->PySide2.QtNetwork.QNetworkConfiguration",
    "PySide2.QtNetwork.QNetworkProxyQuery.peerHostName(self)->QString",
    "PySide2.QtNetwork.QNetworkProxyQuery.peerPort(self)->int",
    "PySide2.QtNetwork.QNetworkProxyQuery.protocolTag(self)->QString",
    "PySide2.QtNetwork.QNetworkProxyQuery.queryType(self)->PySide2.QtNetwork.QNetworkProxyQuery.QueryType",
    "PySide2.QtNetwork.QNetworkProxyQuery.setLocalPort(self,port:int)",
    "PySide2.QtNetwork.QNetworkProxyQuery.setNetworkConfiguration(self,networkConfiguration:PySide2.QtNetwork.QNetworkConfiguration)",
    "PySide2.QtNetwork.QNetworkProxyQuery.setPeerHostName(self,hostname:QString)",
    "PySide2.QtNetwork.QNetworkProxyQuery.setPeerPort(self,port:int)",
    "PySide2.QtNetwork.QNetworkProxyQuery.setProtocolTag(self,protocolTag:QString)",
    "PySide2.QtNetwork.QNetworkProxyQuery.setQueryType(self,type:PySide2.QtNetwork.QNetworkProxyQuery.QueryType)",
    "PySide2.QtNetwork.QNetworkProxyQuery.setUrl(self,url:PySide2.QtCore.QUrl)",
    "PySide2.QtNetwork.QNetworkProxyQuery.swap(self,other:PySide2.QtNetwork.QNetworkProxyQuery)",
    "PySide2.QtNetwork.QNetworkProxyQuery.url(self)->PySide2.QtCore.QUrl",
    "PySide2.QtNetwork.QNetworkProxyQuery.__copy__()",
    nullptr}; // Sentinel

void init_QNetworkProxyQuery(PyObject *module)
{
    _Sbk_QNetworkProxyQuery_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QNetworkProxyQuery",
        "QNetworkProxyQuery",
        &Sbk_QNetworkProxyQuery_spec,
        &Shiboken::callCppDestructor< ::QNetworkProxyQuery >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QNetworkProxyQuery_Type);
    InitSignatureStrings(pyType, QNetworkProxyQuery_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QNetworkProxyQuery_Type), Sbk_QNetworkProxyQuery_PropertyStrings);
    SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QNetworkProxyQuery_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QNetworkProxyQuery_TypeF(),
        QNetworkProxyQuery_PythonToCpp_QNetworkProxyQuery_PTR,
        is_QNetworkProxyQuery_PythonToCpp_QNetworkProxyQuery_PTR_Convertible,
        QNetworkProxyQuery_PTR_CppToPython_QNetworkProxyQuery,
        QNetworkProxyQuery_COPY_CppToPython_QNetworkProxyQuery);

    Shiboken::Conversions::registerConverterName(converter, "QNetworkProxyQuery");
    Shiboken::Conversions::registerConverterName(converter, "QNetworkProxyQuery*");
    Shiboken::Conversions::registerConverterName(converter, "QNetworkProxyQuery&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QNetworkProxyQuery).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QNetworkProxyQuery_PythonToCpp_QNetworkProxyQuery_COPY,
        is_QNetworkProxyQuery_PythonToCpp_QNetworkProxyQuery_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtCore_constQUrlREF_PythonToCpp_QNetworkProxyQuery,
        is_PySide2_QtCore_constQUrlREF_PythonToCpp_QNetworkProxyQuery_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtCore_quint16_PythonToCpp_QNetworkProxyQuery,
        is_PySide2_QtCore_quint16_PythonToCpp_QNetworkProxyQuery_Convertible);

    // Initialization of enums.

    // Initialization of enum 'QueryType'.
    SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_QUERYTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QNetworkProxyQuery_TypeF(),
        "QueryType",
        "2:PySide2.QtNetwork.QNetworkProxyQuery.QueryType",
        "QNetworkProxyQuery::QueryType");
    if (!SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_QUERYTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_QUERYTYPE_IDX],
        Sbk_QNetworkProxyQuery_TypeF(), "TcpSocket", (long) QNetworkProxyQuery::QueryType::TcpSocket))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_QUERYTYPE_IDX],
        Sbk_QNetworkProxyQuery_TypeF(), "UdpSocket", (long) QNetworkProxyQuery::QueryType::UdpSocket))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_QUERYTYPE_IDX],
        Sbk_QNetworkProxyQuery_TypeF(), "SctpSocket", (long) QNetworkProxyQuery::QueryType::SctpSocket))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_QUERYTYPE_IDX],
        Sbk_QNetworkProxyQuery_TypeF(), "TcpServer", (long) QNetworkProxyQuery::QueryType::TcpServer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_QUERYTYPE_IDX],
        Sbk_QNetworkProxyQuery_TypeF(), "UrlRequest", (long) QNetworkProxyQuery::QueryType::UrlRequest))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_QUERYTYPE_IDX],
        Sbk_QNetworkProxyQuery_TypeF(), "SctpServer", (long) QNetworkProxyQuery::QueryType::SctpServer))
        return;
    // Register converter for enum 'QNetworkProxyQuery::QueryType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_QUERYTYPE_IDX],
            QNetworkProxyQuery_QueryType_CppToPython_QNetworkProxyQuery_QueryType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QNetworkProxyQuery_QueryType_PythonToCpp_QNetworkProxyQuery_QueryType,
            is_QNetworkProxyQuery_QueryType_PythonToCpp_QNetworkProxyQuery_QueryType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYQUERY_QUERYTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QNetworkProxyQuery::QueryType");
        Shiboken::Conversions::registerConverterName(converter, "QueryType");
    }
    // End of 'QueryType' enum.

    qRegisterMetaType< ::QNetworkProxyQuery >("QNetworkProxyQuery");
    qRegisterMetaType< ::QNetworkProxyQuery::QueryType >("QNetworkProxyQuery::QueryType");
}
