/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtnetwork_python.h"

// main header
#include "qnetworkproxy_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <QtNetwork/qnetworkproxy.h>
#include <qbytearray.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QNetworkProxy_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QNetworkProxy >()))
        return -1;

    ::QNetworkProxy *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxy.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 5) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QNetworkProxy_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOO:QNetworkProxy", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return -1;


    // Overloaded function decisor
    // 0: QNetworkProxy::QNetworkProxy()
    // 1: QNetworkProxy::QNetworkProxy(QNetworkProxy::ProxyType,QString,quint16,QString,QString)
    // 2: QNetworkProxy::QNetworkProxy(QNetworkProxy)
    if (numArgs == 0) {
        overloadId = 0; // QNetworkProxy()
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_PROXYTYPE_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // QNetworkProxy(QNetworkProxy::ProxyType,QString,quint16,QString,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // QNetworkProxy(QNetworkProxy::ProxyType,QString,quint16,QString,QString)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint16>(), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 1; // QNetworkProxy(QNetworkProxy::ProxyType,QString,quint16,QString,QString)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 1; // QNetworkProxy(QNetworkProxy::ProxyType,QString,quint16,QString,QString)
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[4])))) {
                        overloadId = 1; // QNetworkProxy(QNetworkProxy::ProxyType,QString,quint16,QString,QString)
                    }
                }
            }
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QNetworkProxy(QNetworkProxy)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkProxy_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QNetworkProxy()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QNetworkProxy_Init_TypeError;
            }

            if (!PyErr_Occurred()) {
                // QNetworkProxy()
                cptr = new ::QNetworkProxy();
            }
            break;
        }
        case 1: // QNetworkProxy(QNetworkProxy::ProxyType type, const QString & hostName, quint16 port, const QString & user, const QString & password)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_hostName = Shiboken::String::createStaticString("hostName");
                if (PyDict_Contains(kwds, key_hostName)) {
                    value = PyDict_GetItem(kwds, key_hostName);
                    if (value && pyArgs[1]) {
                        errInfo = key_hostName;
                        Py_INCREF(errInfo);
                        goto Sbk_QNetworkProxy_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                            goto Sbk_QNetworkProxy_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_hostName);
                }
                static PyObject *const key_port = Shiboken::String::createStaticString("port");
                if (PyDict_Contains(kwds, key_port)) {
                    value = PyDict_GetItem(kwds, key_port);
                    if (value && pyArgs[2]) {
                        errInfo = key_port;
                        Py_INCREF(errInfo);
                        goto Sbk_QNetworkProxy_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint16>(), (pyArgs[2]))))
                            goto Sbk_QNetworkProxy_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_port);
                }
                static PyObject *const key_user = Shiboken::String::createStaticString("user");
                if (PyDict_Contains(kwds, key_user)) {
                    value = PyDict_GetItem(kwds, key_user);
                    if (value && pyArgs[3]) {
                        errInfo = key_user;
                        Py_INCREF(errInfo);
                        goto Sbk_QNetworkProxy_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3]))))
                            goto Sbk_QNetworkProxy_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_user);
                }
                static PyObject *const key_password = Shiboken::String::createStaticString("password");
                if (PyDict_Contains(kwds, key_password)) {
                    value = PyDict_GetItem(kwds, key_password);
                    if (value && pyArgs[4]) {
                        errInfo = key_password;
                        Py_INCREF(errInfo);
                        goto Sbk_QNetworkProxy_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[4]))))
                            goto Sbk_QNetworkProxy_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_password);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QNetworkProxy_Init_TypeError;
                }
            }
            ::QNetworkProxy::ProxyType cppArg0{QNetworkProxy::DefaultProxy};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1 = QString();
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            quint16 cppArg2 = 0;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3 = QString();
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
            ::QString cppArg4 = QString();
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // QNetworkProxy(QNetworkProxy::ProxyType,QString,quint16,QString,QString)
                cptr = new ::QNetworkProxy(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
        case 2: // QNetworkProxy(const QNetworkProxy & other)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QNetworkProxy_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QNetworkProxy cppArg0_local;
            ::QNetworkProxy *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QNetworkProxy(QNetworkProxy)
                cptr = new ::QNetworkProxy(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QNetworkProxy >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QNetworkProxy_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QNetworkProxy_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QNetworkProxyFunc_applicationProxy(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxy.applicationProxy";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // applicationProxy()
            QNetworkProxy cppResult = ::QNetworkProxy::applicationProxy();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkProxyFunc_capabilities(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxy.capabilities";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // capabilities()const
            QFlags<QNetworkProxy::Capability> cppResult = const_cast<const ::QNetworkProxy *>(cppSelf)->capabilities();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKPROXY_CAPABILITY_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkProxyFunc_hasRawHeader(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxy.hasRawHeader";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkProxy::hasRawHeader(QByteArray)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // hasRawHeader(QByteArray)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkProxyFunc_hasRawHeader_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // hasRawHeader(QByteArray)const
            bool cppResult = const_cast<const ::QNetworkProxy *>(cppSelf)->hasRawHeader(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QNetworkProxyFunc_hasRawHeader_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkProxyFunc_header(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxy.header";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkProxy::header(QNetworkRequest::KnownHeaders)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_KNOWNHEADERS_IDX])->converter, (pyArg)))) {
        overloadId = 0; // header(QNetworkRequest::KnownHeaders)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkProxyFunc_header_TypeError;

    // Call function/method
    {
        ::QNetworkRequest::KnownHeaders cppArg0{QNetworkRequest::ContentTypeHeader};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // header(QNetworkRequest::KnownHeaders)const
            QVariant cppResult = const_cast<const ::QNetworkProxy *>(cppSelf)->header(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QNetworkProxyFunc_header_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkProxyFunc_hostName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxy.hostName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hostName()const
            QString cppResult = const_cast<const ::QNetworkProxy *>(cppSelf)->hostName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkProxyFunc_isCachingProxy(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxy.isCachingProxy";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isCachingProxy()const
            bool cppResult = const_cast<const ::QNetworkProxy *>(cppSelf)->isCachingProxy();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkProxyFunc_isTransparentProxy(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxy.isTransparentProxy";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isTransparentProxy()const
            bool cppResult = const_cast<const ::QNetworkProxy *>(cppSelf)->isTransparentProxy();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkProxyFunc_password(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxy.password";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // password()const
            QString cppResult = const_cast<const ::QNetworkProxy *>(cppSelf)->password();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkProxyFunc_port(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxy.port";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // port()const
            quint16 cppResult = const_cast<const ::QNetworkProxy *>(cppSelf)->port();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint16>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkProxyFunc_rawHeader(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxy.rawHeader";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkProxy::rawHeader(QByteArray)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // rawHeader(QByteArray)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkProxyFunc_rawHeader_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // rawHeader(QByteArray)const
            QByteArray cppResult = const_cast<const ::QNetworkProxy *>(cppSelf)->rawHeader(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QNetworkProxyFunc_rawHeader_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkProxyFunc_rawHeaderList(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxy.rawHeaderList";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rawHeaderList()const
            QList<QByteArray > cppResult = const_cast<const ::QNetworkProxy *>(cppSelf)->rawHeaderList();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QBYTEARRAY_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkProxyFunc_setApplicationProxy(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxy.setApplicationProxy";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QNetworkProxy::setApplicationProxy(QNetworkProxy)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX]), (pyArg)))) {
        overloadId = 0; // setApplicationProxy(QNetworkProxy)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkProxyFunc_setApplicationProxy_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QNetworkProxy cppArg0_local;
        ::QNetworkProxy *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setApplicationProxy(QNetworkProxy)
            ::QNetworkProxy::setApplicationProxy(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkProxyFunc_setApplicationProxy_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkProxyFunc_setCapabilities(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxy.setCapabilities";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkProxy::setCapabilities(QFlags<QNetworkProxy::Capability>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKPROXY_CAPABILITY_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setCapabilities(QFlags<QNetworkProxy::Capability>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkProxyFunc_setCapabilities_TypeError;

    // Call function/method
    {
        ::QFlags<QNetworkProxy::Capability> cppArg0 = QFlags<QNetworkProxy::Capability>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCapabilities(QFlags<QNetworkProxy::Capability>)
            cppSelf->setCapabilities(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkProxyFunc_setCapabilities_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkProxyFunc_setHeader(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxy.setHeader";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setHeader", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QNetworkProxy::setHeader(QNetworkRequest::KnownHeaders,QVariant)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_KNOWNHEADERS_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[1])))) {
        overloadId = 0; // setHeader(QNetworkRequest::KnownHeaders,QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkProxyFunc_setHeader_TypeError;

    // Call function/method
    {
        ::QNetworkRequest::KnownHeaders cppArg0{QNetworkRequest::ContentTypeHeader};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QVariant cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setHeader(QNetworkRequest::KnownHeaders,QVariant)
            cppSelf->setHeader(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkProxyFunc_setHeader_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkProxyFunc_setHostName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxy.setHostName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkProxy::setHostName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setHostName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkProxyFunc_setHostName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setHostName(QString)
            cppSelf->setHostName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkProxyFunc_setHostName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkProxyFunc_setPassword(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxy.setPassword";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkProxy::setPassword(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setPassword(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkProxyFunc_setPassword_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPassword(QString)
            cppSelf->setPassword(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkProxyFunc_setPassword_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkProxyFunc_setPort(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxy.setPort";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkProxy::setPort(quint16)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint16>(), (pyArg)))) {
        overloadId = 0; // setPort(quint16)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkProxyFunc_setPort_TypeError;

    // Call function/method
    {
        quint16 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPort(quint16)
            cppSelf->setPort(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkProxyFunc_setPort_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkProxyFunc_setRawHeader(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxy.setRawHeader";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setRawHeader", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QNetworkProxy::setRawHeader(QByteArray,QByteArray)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[1])))) {
        overloadId = 0; // setRawHeader(QByteArray,QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkProxyFunc_setRawHeader_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QByteArray cppArg1_local;
        ::QByteArray *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // setRawHeader(QByteArray,QByteArray)
            cppSelf->setRawHeader(*cppArg0, *cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkProxyFunc_setRawHeader_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkProxyFunc_setType(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxy.setType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkProxy::setType(QNetworkProxy::ProxyType)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_PROXYTYPE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setType(QNetworkProxy::ProxyType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkProxyFunc_setType_TypeError;

    // Call function/method
    {
        ::QNetworkProxy::ProxyType cppArg0{QNetworkProxy::DefaultProxy};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setType(QNetworkProxy::ProxyType)
            cppSelf->setType(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkProxyFunc_setType_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkProxyFunc_setUser(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxy.setUser";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkProxy::setUser(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setUser(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkProxyFunc_setUser_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setUser(QString)
            cppSelf->setUser(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkProxyFunc_setUser_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkProxyFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxy.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkProxy::swap(QNetworkProxy&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QNetworkProxy&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkProxyFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QNetworkProxy cppArg0_local;
        ::QNetworkProxy *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QNetworkProxy&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkProxyFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkProxyFunc_type(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxy.type";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // type()const
            QNetworkProxy::ProxyType cppResult = const_cast<const ::QNetworkProxy *>(cppSelf)->type();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_PROXYTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkProxyFunc_user(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkProxy.user";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // user()const
            QString cppResult = const_cast<const ::QNetworkProxy *>(cppSelf)->user();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkProxy___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QNetworkProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QNetworkProxy_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QNetworkProxy_methods[] = {
    {"applicationProxy", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyFunc_applicationProxy), METH_NOARGS|METH_STATIC},
    {"capabilities", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyFunc_capabilities), METH_NOARGS},
    {"hasRawHeader", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyFunc_hasRawHeader), METH_O},
    {"header", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyFunc_header), METH_O},
    {"hostName", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyFunc_hostName), METH_NOARGS},
    {"isCachingProxy", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyFunc_isCachingProxy), METH_NOARGS},
    {"isTransparentProxy", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyFunc_isTransparentProxy), METH_NOARGS},
    {"password", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyFunc_password), METH_NOARGS},
    {"port", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyFunc_port), METH_NOARGS},
    {"rawHeader", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyFunc_rawHeader), METH_O},
    {"rawHeaderList", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyFunc_rawHeaderList), METH_NOARGS},
    {"setApplicationProxy", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyFunc_setApplicationProxy), METH_O|METH_STATIC},
    {"setCapabilities", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyFunc_setCapabilities), METH_O},
    {"setHeader", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyFunc_setHeader), METH_VARARGS},
    {"setHostName", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyFunc_setHostName), METH_O},
    {"setPassword", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyFunc_setPassword), METH_O},
    {"setPort", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyFunc_setPort), METH_O},
    {"setRawHeader", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyFunc_setRawHeader), METH_VARARGS},
    {"setType", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyFunc_setType), METH_O},
    {"setUser", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyFunc_setUser), METH_O},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyFunc_swap), METH_O},
    {"type", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyFunc_type), METH_NOARGS},
    {"user", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxyFunc_user), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QNetworkProxy___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QNetworkProxy_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QNetworkProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX]), (pyArg)))) {
                // operator!=(const QNetworkProxy & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QNetworkProxy cppArg0_local;
                ::QNetworkProxy *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX]), (pyArg)))) {
                // operator==(const QNetworkProxy & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QNetworkProxy cppArg0_local;
                ::QNetworkProxy *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QNetworkProxy_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QNetworkProxy_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QNetworkProxy_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QNetworkProxy_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QNetworkProxy__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QNetworkProxy_Type = nullptr;
static SbkObjectType *Sbk_QNetworkProxy_TypeF(void)
{
    return _Sbk_QNetworkProxy_Type;
}

static PyType_Slot Sbk_QNetworkProxy_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QNetworkProxy__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QNetworkProxy_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QNetworkProxy_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QNetworkProxy_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QNetworkProxy_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QNetworkProxy_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QNetworkProxy_spec = {
    "2:PySide2.QtNetwork.QNetworkProxy",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QNetworkProxy_slots
};

} //extern "C"

PyObject *SbkPySide2_QtNetwork_QNetworkProxy_Capability___and__(PyObject *self, PyObject *pyArg)
{
    ::QNetworkProxy::Capabilities cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QNetworkProxy::Capabilities>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QNetworkProxy::Capabilities>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QNetworkProxy::Capabilities>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QNetworkProxy::Capabilities>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKPROXY_CAPABILITY_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtNetwork_QNetworkProxy_Capability___or__(PyObject *self, PyObject *pyArg)
{
    ::QNetworkProxy::Capabilities cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QNetworkProxy::Capabilities>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QNetworkProxy::Capabilities>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QNetworkProxy::Capabilities>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QNetworkProxy::Capabilities>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKPROXY_CAPABILITY_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtNetwork_QNetworkProxy_Capability___xor__(PyObject *self, PyObject *pyArg)
{
    ::QNetworkProxy::Capabilities cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QNetworkProxy::Capabilities>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QNetworkProxy::Capabilities>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QNetworkProxy::Capabilities>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QNetworkProxy::Capabilities>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKPROXY_CAPABILITY_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtNetwork_QNetworkProxy_Capability___invert__(PyObject *self, PyObject *pyArg)
{
    ::QNetworkProxy::Capabilities cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKPROXY_CAPABILITY_IDX])->converter, self, &cppSelf);
    ::QNetworkProxy::Capabilities cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKPROXY_CAPABILITY_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtNetwork_QNetworkProxy_Capability_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKPROXY_CAPABILITY_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtNetwork_QNetworkProxy_Capability__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKPROXY_CAPABILITY_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtNetwork_QNetworkProxy_Capability_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkProxy_Capability__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkProxy_Capability__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkProxy_Capability_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkProxy_Capability___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkProxy_Capability___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkProxy_Capability___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkProxy_Capability___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkProxy_Capability_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkProxy_Capability_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkProxy_Capability_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QNetworkProxy_ProxyType_PythonToCpp_QNetworkProxy_ProxyType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QNetworkProxy::ProxyType *>(cppOut) =
        static_cast<::QNetworkProxy::ProxyType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QNetworkProxy_ProxyType_PythonToCpp_QNetworkProxy_ProxyType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_PROXYTYPE_IDX]))
        return QNetworkProxy_ProxyType_PythonToCpp_QNetworkProxy_ProxyType;
    return {};
}
static PyObject *QNetworkProxy_ProxyType_CppToPython_QNetworkProxy_ProxyType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QNetworkProxy::ProxyType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_PROXYTYPE_IDX], castCppIn);

}

static void QNetworkProxy_Capability_PythonToCpp_QNetworkProxy_Capability(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QNetworkProxy::Capability *>(cppOut) =
        static_cast<::QNetworkProxy::Capability>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QNetworkProxy_Capability_PythonToCpp_QNetworkProxy_Capability_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_CAPABILITY_IDX]))
        return QNetworkProxy_Capability_PythonToCpp_QNetworkProxy_Capability;
    return {};
}
static PyObject *QNetworkProxy_Capability_CppToPython_QNetworkProxy_Capability(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QNetworkProxy::Capability *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_CAPABILITY_IDX], castCppIn);

}

static void QFlags_QNetworkProxy_Capability__PythonToCpp_QFlags_QNetworkProxy_Capability_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QNetworkProxy::Capability> *>(cppOut) =
        ::QFlags<QNetworkProxy::Capability>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QNetworkProxy_Capability__PythonToCpp_QFlags_QNetworkProxy_Capability__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKPROXY_CAPABILITY_IDX]))
        return QFlags_QNetworkProxy_Capability__PythonToCpp_QFlags_QNetworkProxy_Capability_;
    return {};
}
static PyObject *QFlags_QNetworkProxy_Capability__CppToPython_QFlags_QNetworkProxy_Capability_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QNetworkProxy::Capability> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKPROXY_CAPABILITY_IDX]));

}

static void QNetworkProxy_Capability_PythonToCpp_QFlags_QNetworkProxy_Capability_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QNetworkProxy::Capability> *>(cppOut) =
        ::QFlags<QNetworkProxy::Capability>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QNetworkProxy_Capability_PythonToCpp_QFlags_QNetworkProxy_Capability__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_CAPABILITY_IDX]))
        return QNetworkProxy_Capability_PythonToCpp_QFlags_QNetworkProxy_Capability_;
    return {};
}
static void number_PythonToCpp_QFlags_QNetworkProxy_Capability_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QNetworkProxy::Capability> *>(cppOut) =
        ::QFlags<QNetworkProxy::Capability>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QNetworkProxy_Capability__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_CAPABILITY_IDX]))
        return number_PythonToCpp_QFlags_QNetworkProxy_Capability_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QNetworkProxy_PythonToCpp_QNetworkProxy_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QNetworkProxy_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QNetworkProxy_PythonToCpp_QNetworkProxy_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QNetworkProxy_TypeF())))
        return QNetworkProxy_PythonToCpp_QNetworkProxy_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QNetworkProxy_PTR_CppToPython_QNetworkProxy(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QNetworkProxy *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QNetworkProxy_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QNetworkProxy_COPY_CppToPython_QNetworkProxy(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QNetworkProxy_TypeF(), new ::QNetworkProxy(*reinterpret_cast<const ::QNetworkProxy *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QNetworkProxy_PythonToCpp_QNetworkProxy_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QNetworkProxy *>(cppOut) = *reinterpret_cast< ::QNetworkProxy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QNetworkProxy_PythonToCpp_QNetworkProxy_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QNetworkProxy_TypeF())))
        return QNetworkProxy_PythonToCpp_QNetworkProxy_COPY;
    return {};
}

// Implicit conversions.
static void QNetworkProxy_ProxyType_PythonToCpp_QNetworkProxy(PyObject *pyIn, void *cppOut) {
    ::QNetworkProxy::ProxyType cppIn{QNetworkProxy::DefaultProxy};
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_PROXYTYPE_IDX])->converter, pyIn, &cppIn);
    *reinterpret_cast<::QNetworkProxy *>(cppOut) = ::QNetworkProxy(cppIn);
}
static PythonToCppFunc is_QNetworkProxy_ProxyType_PythonToCpp_QNetworkProxy_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_PROXYTYPE_IDX], pyIn))
        return QNetworkProxy_ProxyType_PythonToCpp_QNetworkProxy;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QNetworkProxy_SignatureStrings[] = {
    "2:PySide2.QtNetwork.QNetworkProxy(self)",
    "1:PySide2.QtNetwork.QNetworkProxy(self,type:PySide2.QtNetwork.QNetworkProxy.ProxyType,hostName:QString=QString(),port:quint16=0,user:QString=QString(),password:QString=QString())",
    "0:PySide2.QtNetwork.QNetworkProxy(self,other:PySide2.QtNetwork.QNetworkProxy)",
    "PySide2.QtNetwork.QNetworkProxy.applicationProxy()->PySide2.QtNetwork.QNetworkProxy",
    "PySide2.QtNetwork.QNetworkProxy.capabilities(self)->PySide2.QtNetwork.QNetworkProxy.Capabilities",
    "PySide2.QtNetwork.QNetworkProxy.hasRawHeader(self,headerName:PySide2.QtCore.QByteArray)->bool",
    "PySide2.QtNetwork.QNetworkProxy.header(self,header:PySide2.QtNetwork.QNetworkRequest.KnownHeaders)->QVariant",
    "PySide2.QtNetwork.QNetworkProxy.hostName(self)->QString",
    "PySide2.QtNetwork.QNetworkProxy.isCachingProxy(self)->bool",
    "PySide2.QtNetwork.QNetworkProxy.isTransparentProxy(self)->bool",
    "PySide2.QtNetwork.QNetworkProxy.password(self)->QString",
    "PySide2.QtNetwork.QNetworkProxy.port(self)->quint16",
    "PySide2.QtNetwork.QNetworkProxy.rawHeader(self,headerName:PySide2.QtCore.QByteArray)->PySide2.QtCore.QByteArray",
    "PySide2.QtNetwork.QNetworkProxy.rawHeaderList(self)->QList[PySide2.QtCore.QByteArray]",
    "PySide2.QtNetwork.QNetworkProxy.setApplicationProxy(proxy:PySide2.QtNetwork.QNetworkProxy)",
    "PySide2.QtNetwork.QNetworkProxy.setCapabilities(self,capab:PySide2.QtNetwork.QNetworkProxy.Capabilities)",
    "PySide2.QtNetwork.QNetworkProxy.setHeader(self,header:PySide2.QtNetwork.QNetworkRequest.KnownHeaders,value:QVariant)",
    "PySide2.QtNetwork.QNetworkProxy.setHostName(self,hostName:QString)",
    "PySide2.QtNetwork.QNetworkProxy.setPassword(self,password:QString)",
    "PySide2.QtNetwork.QNetworkProxy.setPort(self,port:quint16)",
    "PySide2.QtNetwork.QNetworkProxy.setRawHeader(self,headerName:PySide2.QtCore.QByteArray,value:PySide2.QtCore.QByteArray)",
    "PySide2.QtNetwork.QNetworkProxy.setType(self,type:PySide2.QtNetwork.QNetworkProxy.ProxyType)",
    "PySide2.QtNetwork.QNetworkProxy.setUser(self,userName:QString)",
    "PySide2.QtNetwork.QNetworkProxy.swap(self,other:PySide2.QtNetwork.QNetworkProxy)",
    "PySide2.QtNetwork.QNetworkProxy.type(self)->PySide2.QtNetwork.QNetworkProxy.ProxyType",
    "PySide2.QtNetwork.QNetworkProxy.user(self)->QString",
    "PySide2.QtNetwork.QNetworkProxy.__copy__()",
    nullptr}; // Sentinel

void init_QNetworkProxy(PyObject *module)
{
    _Sbk_QNetworkProxy_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QNetworkProxy",
        "QNetworkProxy",
        &Sbk_QNetworkProxy_spec,
        &Shiboken::callCppDestructor< ::QNetworkProxy >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QNetworkProxy_Type);
    InitSignatureStrings(pyType, QNetworkProxy_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QNetworkProxy_Type), Sbk_QNetworkProxy_PropertyStrings);
    SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QNetworkProxy_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QNetworkProxy_TypeF(),
        QNetworkProxy_PythonToCpp_QNetworkProxy_PTR,
        is_QNetworkProxy_PythonToCpp_QNetworkProxy_PTR_Convertible,
        QNetworkProxy_PTR_CppToPython_QNetworkProxy,
        QNetworkProxy_COPY_CppToPython_QNetworkProxy);

    Shiboken::Conversions::registerConverterName(converter, "QNetworkProxy");
    Shiboken::Conversions::registerConverterName(converter, "QNetworkProxy*");
    Shiboken::Conversions::registerConverterName(converter, "QNetworkProxy&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QNetworkProxy).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QNetworkProxy_PythonToCpp_QNetworkProxy_COPY,
        is_QNetworkProxy_PythonToCpp_QNetworkProxy_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QNetworkProxy_ProxyType_PythonToCpp_QNetworkProxy,
        is_QNetworkProxy_ProxyType_PythonToCpp_QNetworkProxy_Convertible);

    // Initialization of enums.

    // Initialization of enum 'ProxyType'.
    SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_PROXYTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QNetworkProxy_TypeF(),
        "ProxyType",
        "2:PySide2.QtNetwork.QNetworkProxy.ProxyType",
        "QNetworkProxy::ProxyType");
    if (!SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_PROXYTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_PROXYTYPE_IDX],
        Sbk_QNetworkProxy_TypeF(), "DefaultProxy", (long) QNetworkProxy::ProxyType::DefaultProxy))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_PROXYTYPE_IDX],
        Sbk_QNetworkProxy_TypeF(), "Socks5Proxy", (long) QNetworkProxy::ProxyType::Socks5Proxy))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_PROXYTYPE_IDX],
        Sbk_QNetworkProxy_TypeF(), "NoProxy", (long) QNetworkProxy::ProxyType::NoProxy))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_PROXYTYPE_IDX],
        Sbk_QNetworkProxy_TypeF(), "HttpProxy", (long) QNetworkProxy::ProxyType::HttpProxy))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_PROXYTYPE_IDX],
        Sbk_QNetworkProxy_TypeF(), "HttpCachingProxy", (long) QNetworkProxy::ProxyType::HttpCachingProxy))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_PROXYTYPE_IDX],
        Sbk_QNetworkProxy_TypeF(), "FtpCachingProxy", (long) QNetworkProxy::ProxyType::FtpCachingProxy))
        return;
    // Register converter for enum 'QNetworkProxy::ProxyType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_PROXYTYPE_IDX],
            QNetworkProxy_ProxyType_CppToPython_QNetworkProxy_ProxyType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QNetworkProxy_ProxyType_PythonToCpp_QNetworkProxy_ProxyType,
            is_QNetworkProxy_ProxyType_PythonToCpp_QNetworkProxy_ProxyType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_PROXYTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QNetworkProxy::ProxyType");
        Shiboken::Conversions::registerConverterName(converter, "ProxyType");
    }
    // End of 'ProxyType' enum.

    // Initialization of enum 'Capability'.
    SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKPROXY_CAPABILITY_IDX] = PySide::QFlags::create("2:PySide2.QtNetwork.QNetworkProxy.Capabilities", SbkPySide2_QtNetwork_QNetworkProxy_Capability_number_slots);
    SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_CAPABILITY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QNetworkProxy_TypeF(),
        "Capability",
        "2:PySide2.QtNetwork.QNetworkProxy.Capability",
        "QNetworkProxy::Capability",
        SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKPROXY_CAPABILITY_IDX]);
    if (!SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_CAPABILITY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_CAPABILITY_IDX],
        Sbk_QNetworkProxy_TypeF(), "TunnelingCapability", (long) QNetworkProxy::Capability::TunnelingCapability))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_CAPABILITY_IDX],
        Sbk_QNetworkProxy_TypeF(), "ListeningCapability", (long) QNetworkProxy::Capability::ListeningCapability))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_CAPABILITY_IDX],
        Sbk_QNetworkProxy_TypeF(), "UdpTunnelingCapability", (long) QNetworkProxy::Capability::UdpTunnelingCapability))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_CAPABILITY_IDX],
        Sbk_QNetworkProxy_TypeF(), "CachingCapability", (long) QNetworkProxy::Capability::CachingCapability))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_CAPABILITY_IDX],
        Sbk_QNetworkProxy_TypeF(), "HostNameLookupCapability", (long) QNetworkProxy::Capability::HostNameLookupCapability))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_CAPABILITY_IDX],
        Sbk_QNetworkProxy_TypeF(), "SctpTunnelingCapability", (long) QNetworkProxy::Capability::SctpTunnelingCapability))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_CAPABILITY_IDX],
        Sbk_QNetworkProxy_TypeF(), "SctpListeningCapability", (long) QNetworkProxy::Capability::SctpListeningCapability))
        return;
    // Register converter for enum 'QNetworkProxy::Capability'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_CAPABILITY_IDX],
            QNetworkProxy_Capability_CppToPython_QNetworkProxy_Capability);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QNetworkProxy_Capability_PythonToCpp_QNetworkProxy_Capability,
            is_QNetworkProxy_Capability_PythonToCpp_QNetworkProxy_Capability_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_CAPABILITY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QNetworkProxy::Capability");
        Shiboken::Conversions::registerConverterName(converter, "Capability");
    }
    // Register converter for flag 'QFlags<QNetworkProxy::Capability>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKPROXY_CAPABILITY_IDX],
            QFlags_QNetworkProxy_Capability__CppToPython_QFlags_QNetworkProxy_Capability_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QNetworkProxy_Capability_PythonToCpp_QFlags_QNetworkProxy_Capability_,
            is_QNetworkProxy_Capability_PythonToCpp_QFlags_QNetworkProxy_Capability__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QNetworkProxy_Capability__PythonToCpp_QFlags_QNetworkProxy_Capability_,
            is_QFlags_QNetworkProxy_Capability__PythonToCpp_QFlags_QNetworkProxy_Capability__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QNetworkProxy_Capability_,
            is_number_PythonToCpp_QFlags_QNetworkProxy_Capability__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKPROXY_CAPABILITY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QNetworkProxy::Capabilities");
        Shiboken::Conversions::registerConverterName(converter, "Capabilities");
    }
    // End of 'Capability' enum/flags.

    qRegisterMetaType< ::QNetworkProxy >("QNetworkProxy");
    qRegisterMetaType< ::QNetworkProxy::ProxyType >("QNetworkProxy::ProxyType");
    qRegisterMetaType< ::QNetworkProxy::Capability >("QNetworkProxy::Capability");
    qRegisterMetaType< ::QNetworkProxy::Capabilities >("QNetworkProxy::Capabilities");
}
