/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtnetwork_python.h"

// main header
#include "qnetworkinterface_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <QtNetwork/qhostaddress.h>
#include <QtNetwork/qnetworkinterface.h>
#include <qobject.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QNetworkInterface_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QNetworkInterface >()))
        return -1;

    ::QNetworkInterface *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkInterface.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QNetworkInterface", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QNetworkInterface::QNetworkInterface()
    // 1: QNetworkInterface::QNetworkInterface(QNetworkInterface)
    if (numArgs == 0) {
        overloadId = 0; // QNetworkInterface()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QNetworkInterface(QNetworkInterface)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkInterface_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QNetworkInterface()
        {

            if (!PyErr_Occurred()) {
                // QNetworkInterface()
                cptr = new ::QNetworkInterface();
            }
            break;
        }
        case 1: // QNetworkInterface(const QNetworkInterface & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QNetworkInterface cppArg0_local;
            ::QNetworkInterface *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QNetworkInterface(QNetworkInterface)
                cptr = new ::QNetworkInterface(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QNetworkInterface >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QNetworkInterface_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QNetworkInterface_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QNetworkInterfaceFunc_addressEntries(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkInterface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkInterface.addressEntries";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // addressEntries()const
            QList<QNetworkAddressEntry > cppResult = const_cast<const ::QNetworkInterface *>(cppSelf)->addressEntries();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QNETWORKADDRESSENTRY_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkInterfaceFunc_allAddresses(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkInterface.allAddresses";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // allAddresses()
            QList<QHostAddress > cppResult = ::QNetworkInterface::allAddresses();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QHOSTADDRESS_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkInterfaceFunc_allInterfaces(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkInterface.allInterfaces";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // allInterfaces()
            QList<QNetworkInterface > cppResult = ::QNetworkInterface::allInterfaces();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QNETWORKINTERFACE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkInterfaceFunc_flags(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkInterface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkInterface.flags";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // flags()const
            QFlags<QNetworkInterface::InterfaceFlag> cppResult = const_cast<const ::QNetworkInterface *>(cppSelf)->flags();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKINTERFACE_INTERFACEFLAG_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkInterfaceFunc_hardwareAddress(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkInterface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkInterface.hardwareAddress";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hardwareAddress()const
            QString cppResult = const_cast<const ::QNetworkInterface *>(cppSelf)->hardwareAddress();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkInterfaceFunc_humanReadableName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkInterface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkInterface.humanReadableName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // humanReadableName()const
            QString cppResult = const_cast<const ::QNetworkInterface *>(cppSelf)->humanReadableName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkInterfaceFunc_index(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkInterface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkInterface.index";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // index()const
            int cppResult = const_cast<const ::QNetworkInterface *>(cppSelf)->index();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkInterfaceFunc_interfaceFromIndex(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkInterface.interfaceFromIndex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QNetworkInterface::interfaceFromIndex(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // interfaceFromIndex(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkInterfaceFunc_interfaceFromIndex_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // interfaceFromIndex(int)
            QNetworkInterface cppResult = ::QNetworkInterface::interfaceFromIndex(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QNetworkInterfaceFunc_interfaceFromIndex_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkInterfaceFunc_interfaceFromName(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkInterface.interfaceFromName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QNetworkInterface::interfaceFromName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // interfaceFromName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkInterfaceFunc_interfaceFromName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // interfaceFromName(QString)
            QNetworkInterface cppResult = ::QNetworkInterface::interfaceFromName(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QNetworkInterfaceFunc_interfaceFromName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkInterfaceFunc_interfaceIndexFromName(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkInterface.interfaceIndexFromName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QNetworkInterface::interfaceIndexFromName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // interfaceIndexFromName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkInterfaceFunc_interfaceIndexFromName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // interfaceIndexFromName(QString)
            int cppResult = ::QNetworkInterface::interfaceIndexFromName(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QNetworkInterfaceFunc_interfaceIndexFromName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkInterfaceFunc_interfaceNameFromIndex(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkInterface.interfaceNameFromIndex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QNetworkInterface::interfaceNameFromIndex(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // interfaceNameFromIndex(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkInterfaceFunc_interfaceNameFromIndex_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // interfaceNameFromIndex(int)
            QString cppResult = ::QNetworkInterface::interfaceNameFromIndex(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QNetworkInterfaceFunc_interfaceNameFromIndex_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkInterfaceFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkInterface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkInterface.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QNetworkInterface *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkInterfaceFunc_maximumTransmissionUnit(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkInterface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkInterface.maximumTransmissionUnit";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maximumTransmissionUnit()const
            int cppResult = const_cast<const ::QNetworkInterface *>(cppSelf)->maximumTransmissionUnit();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkInterfaceFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkInterface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkInterface.name";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // name()const
            QString cppResult = const_cast<const ::QNetworkInterface *>(cppSelf)->name();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkInterfaceFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkInterface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkInterface.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkInterface::swap(QNetworkInterface&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QNetworkInterface&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkInterfaceFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QNetworkInterface cppArg0_local;
        ::QNetworkInterface *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QNetworkInterface&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkInterfaceFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkInterfaceFunc_type(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkInterface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkInterface.type";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // type()const
            QNetworkInterface::InterfaceType cppResult = const_cast<const ::QNetworkInterface *>(cppSelf)->type();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_INTERFACETYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkInterface___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QNetworkInterface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QNetworkInterface_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QNetworkInterface_methods[] = {
    {"addressEntries", reinterpret_cast<PyCFunction>(Sbk_QNetworkInterfaceFunc_addressEntries), METH_NOARGS},
    {"allAddresses", reinterpret_cast<PyCFunction>(Sbk_QNetworkInterfaceFunc_allAddresses), METH_NOARGS|METH_STATIC},
    {"allInterfaces", reinterpret_cast<PyCFunction>(Sbk_QNetworkInterfaceFunc_allInterfaces), METH_NOARGS|METH_STATIC},
    {"flags", reinterpret_cast<PyCFunction>(Sbk_QNetworkInterfaceFunc_flags), METH_NOARGS},
    {"hardwareAddress", reinterpret_cast<PyCFunction>(Sbk_QNetworkInterfaceFunc_hardwareAddress), METH_NOARGS},
    {"humanReadableName", reinterpret_cast<PyCFunction>(Sbk_QNetworkInterfaceFunc_humanReadableName), METH_NOARGS},
    {"index", reinterpret_cast<PyCFunction>(Sbk_QNetworkInterfaceFunc_index), METH_NOARGS},
    {"interfaceFromIndex", reinterpret_cast<PyCFunction>(Sbk_QNetworkInterfaceFunc_interfaceFromIndex), METH_O|METH_STATIC},
    {"interfaceFromName", reinterpret_cast<PyCFunction>(Sbk_QNetworkInterfaceFunc_interfaceFromName), METH_O|METH_STATIC},
    {"interfaceIndexFromName", reinterpret_cast<PyCFunction>(Sbk_QNetworkInterfaceFunc_interfaceIndexFromName), METH_O|METH_STATIC},
    {"interfaceNameFromIndex", reinterpret_cast<PyCFunction>(Sbk_QNetworkInterfaceFunc_interfaceNameFromIndex), METH_O|METH_STATIC},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QNetworkInterfaceFunc_isValid), METH_NOARGS},
    {"maximumTransmissionUnit", reinterpret_cast<PyCFunction>(Sbk_QNetworkInterfaceFunc_maximumTransmissionUnit), METH_NOARGS},
    {"name", reinterpret_cast<PyCFunction>(Sbk_QNetworkInterfaceFunc_name), METH_NOARGS},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QNetworkInterfaceFunc_swap), METH_O},
    {"type", reinterpret_cast<PyCFunction>(Sbk_QNetworkInterfaceFunc_type), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QNetworkInterface___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QNetworkInterface_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QNetworkInterface_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QNetworkInterface__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkInterface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QNetworkInterface_Type = nullptr;
static SbkObjectType *Sbk_QNetworkInterface_TypeF(void)
{
    return _Sbk_QNetworkInterface_Type;
}

static PyType_Slot Sbk_QNetworkInterface_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QNetworkInterface__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QNetworkInterface_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QNetworkInterface_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QNetworkInterface_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QNetworkInterface_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QNetworkInterface_spec = {
    "2:PySide2.QtNetwork.QNetworkInterface",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QNetworkInterface_slots
};

} //extern "C"

PyObject *SbkPySide2_QtNetwork_QNetworkInterface_InterfaceFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::QNetworkInterface::InterfaceFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QNetworkInterface::InterfaceFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QNetworkInterface::InterfaceFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QNetworkInterface::InterfaceFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QNetworkInterface::InterfaceFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKINTERFACE_INTERFACEFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtNetwork_QNetworkInterface_InterfaceFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::QNetworkInterface::InterfaceFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QNetworkInterface::InterfaceFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QNetworkInterface::InterfaceFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QNetworkInterface::InterfaceFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QNetworkInterface::InterfaceFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKINTERFACE_INTERFACEFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtNetwork_QNetworkInterface_InterfaceFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QNetworkInterface::InterfaceFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QNetworkInterface::InterfaceFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QNetworkInterface::InterfaceFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QNetworkInterface::InterfaceFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QNetworkInterface::InterfaceFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKINTERFACE_INTERFACEFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtNetwork_QNetworkInterface_InterfaceFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QNetworkInterface::InterfaceFlags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKINTERFACE_INTERFACEFLAG_IDX])->converter, self, &cppSelf);
    ::QNetworkInterface::InterfaceFlags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKINTERFACE_INTERFACEFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtNetwork_QNetworkInterface_InterfaceFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKINTERFACE_INTERFACEFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtNetwork_QNetworkInterface_InterfaceFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKINTERFACE_INTERFACEFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtNetwork_QNetworkInterface_InterfaceFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkInterface_InterfaceFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkInterface_InterfaceFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkInterface_InterfaceFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkInterface_InterfaceFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkInterface_InterfaceFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkInterface_InterfaceFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkInterface_InterfaceFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkInterface_InterfaceFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkInterface_InterfaceFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtNetwork_QNetworkInterface_InterfaceFlag_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QNetworkInterface_InterfaceFlag_PythonToCpp_QNetworkInterface_InterfaceFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QNetworkInterface::InterfaceFlag *>(cppOut) =
        static_cast<::QNetworkInterface::InterfaceFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QNetworkInterface_InterfaceFlag_PythonToCpp_QNetworkInterface_InterfaceFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_INTERFACEFLAG_IDX]))
        return QNetworkInterface_InterfaceFlag_PythonToCpp_QNetworkInterface_InterfaceFlag;
    return {};
}
static PyObject *QNetworkInterface_InterfaceFlag_CppToPython_QNetworkInterface_InterfaceFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QNetworkInterface::InterfaceFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_INTERFACEFLAG_IDX], castCppIn);

}

static void QFlags_QNetworkInterface_InterfaceFlag__PythonToCpp_QFlags_QNetworkInterface_InterfaceFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QNetworkInterface::InterfaceFlag> *>(cppOut) =
        ::QFlags<QNetworkInterface::InterfaceFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QNetworkInterface_InterfaceFlag__PythonToCpp_QFlags_QNetworkInterface_InterfaceFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKINTERFACE_INTERFACEFLAG_IDX]))
        return QFlags_QNetworkInterface_InterfaceFlag__PythonToCpp_QFlags_QNetworkInterface_InterfaceFlag_;
    return {};
}
static PyObject *QFlags_QNetworkInterface_InterfaceFlag__CppToPython_QFlags_QNetworkInterface_InterfaceFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QNetworkInterface::InterfaceFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKINTERFACE_INTERFACEFLAG_IDX]));

}

static void QNetworkInterface_InterfaceFlag_PythonToCpp_QFlags_QNetworkInterface_InterfaceFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QNetworkInterface::InterfaceFlag> *>(cppOut) =
        ::QFlags<QNetworkInterface::InterfaceFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QNetworkInterface_InterfaceFlag_PythonToCpp_QFlags_QNetworkInterface_InterfaceFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_INTERFACEFLAG_IDX]))
        return QNetworkInterface_InterfaceFlag_PythonToCpp_QFlags_QNetworkInterface_InterfaceFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_QNetworkInterface_InterfaceFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QNetworkInterface::InterfaceFlag> *>(cppOut) =
        ::QFlags<QNetworkInterface::InterfaceFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QNetworkInterface_InterfaceFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_INTERFACEFLAG_IDX]))
        return number_PythonToCpp_QFlags_QNetworkInterface_InterfaceFlag_;
    return {};
}
static void QNetworkInterface_InterfaceType_PythonToCpp_QNetworkInterface_InterfaceType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QNetworkInterface::InterfaceType *>(cppOut) =
        static_cast<::QNetworkInterface::InterfaceType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QNetworkInterface_InterfaceType_PythonToCpp_QNetworkInterface_InterfaceType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_INTERFACETYPE_IDX]))
        return QNetworkInterface_InterfaceType_PythonToCpp_QNetworkInterface_InterfaceType;
    return {};
}
static PyObject *QNetworkInterface_InterfaceType_CppToPython_QNetworkInterface_InterfaceType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QNetworkInterface::InterfaceType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_INTERFACETYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QNetworkInterface_PythonToCpp_QNetworkInterface_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QNetworkInterface_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QNetworkInterface_PythonToCpp_QNetworkInterface_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QNetworkInterface_TypeF())))
        return QNetworkInterface_PythonToCpp_QNetworkInterface_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QNetworkInterface_PTR_CppToPython_QNetworkInterface(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QNetworkInterface *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QNetworkInterface_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QNetworkInterface_COPY_CppToPython_QNetworkInterface(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QNetworkInterface_TypeF(), new ::QNetworkInterface(*reinterpret_cast<const ::QNetworkInterface *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QNetworkInterface_PythonToCpp_QNetworkInterface_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QNetworkInterface *>(cppOut) = *reinterpret_cast< ::QNetworkInterface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QNetworkInterface_PythonToCpp_QNetworkInterface_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QNetworkInterface_TypeF())))
        return QNetworkInterface_PythonToCpp_QNetworkInterface_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QNetworkInterface_SignatureStrings[] = {
    "1:PySide2.QtNetwork.QNetworkInterface(self)",
    "0:PySide2.QtNetwork.QNetworkInterface(self,other:PySide2.QtNetwork.QNetworkInterface)",
    "PySide2.QtNetwork.QNetworkInterface.addressEntries(self)->QList[PySide2.QtNetwork.QNetworkAddressEntry]",
    "PySide2.QtNetwork.QNetworkInterface.allAddresses()->QList[PySide2.QtNetwork.QHostAddress]",
    "PySide2.QtNetwork.QNetworkInterface.allInterfaces()->QList[PySide2.QtNetwork.QNetworkInterface]",
    "PySide2.QtNetwork.QNetworkInterface.flags(self)->PySide2.QtNetwork.QNetworkInterface.InterfaceFlags",
    "PySide2.QtNetwork.QNetworkInterface.hardwareAddress(self)->QString",
    "PySide2.QtNetwork.QNetworkInterface.humanReadableName(self)->QString",
    "PySide2.QtNetwork.QNetworkInterface.index(self)->int",
    "PySide2.QtNetwork.QNetworkInterface.interfaceFromIndex(index:int)->PySide2.QtNetwork.QNetworkInterface",
    "PySide2.QtNetwork.QNetworkInterface.interfaceFromName(name:QString)->PySide2.QtNetwork.QNetworkInterface",
    "PySide2.QtNetwork.QNetworkInterface.interfaceIndexFromName(name:QString)->int",
    "PySide2.QtNetwork.QNetworkInterface.interfaceNameFromIndex(index:int)->QString",
    "PySide2.QtNetwork.QNetworkInterface.isValid(self)->bool",
    "PySide2.QtNetwork.QNetworkInterface.maximumTransmissionUnit(self)->int",
    "PySide2.QtNetwork.QNetworkInterface.name(self)->QString",
    "PySide2.QtNetwork.QNetworkInterface.swap(self,other:PySide2.QtNetwork.QNetworkInterface)",
    "PySide2.QtNetwork.QNetworkInterface.type(self)->PySide2.QtNetwork.QNetworkInterface.InterfaceType",
    "PySide2.QtNetwork.QNetworkInterface.__copy__()",
    nullptr}; // Sentinel

void init_QNetworkInterface(PyObject *module)
{
    _Sbk_QNetworkInterface_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QNetworkInterface",
        "QNetworkInterface",
        &Sbk_QNetworkInterface_spec,
        &Shiboken::callCppDestructor< ::QNetworkInterface >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QNetworkInterface_Type);
    InitSignatureStrings(pyType, QNetworkInterface_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QNetworkInterface_Type), Sbk_QNetworkInterface_PropertyStrings);
    SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QNetworkInterface_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QNetworkInterface_TypeF(),
        QNetworkInterface_PythonToCpp_QNetworkInterface_PTR,
        is_QNetworkInterface_PythonToCpp_QNetworkInterface_PTR_Convertible,
        QNetworkInterface_PTR_CppToPython_QNetworkInterface,
        QNetworkInterface_COPY_CppToPython_QNetworkInterface);

    Shiboken::Conversions::registerConverterName(converter, "QNetworkInterface");
    Shiboken::Conversions::registerConverterName(converter, "QNetworkInterface*");
    Shiboken::Conversions::registerConverterName(converter, "QNetworkInterface&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QNetworkInterface).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QNetworkInterface_PythonToCpp_QNetworkInterface_COPY,
        is_QNetworkInterface_PythonToCpp_QNetworkInterface_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'InterfaceFlag'.
    SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKINTERFACE_INTERFACEFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtNetwork.QNetworkInterface.InterfaceFlags", SbkPySide2_QtNetwork_QNetworkInterface_InterfaceFlag_number_slots);
    SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_INTERFACEFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QNetworkInterface_TypeF(),
        "InterfaceFlag",
        "2:PySide2.QtNetwork.QNetworkInterface.InterfaceFlag",
        "QNetworkInterface::InterfaceFlag",
        SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKINTERFACE_INTERFACEFLAG_IDX]);
    if (!SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_INTERFACEFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_INTERFACEFLAG_IDX],
        Sbk_QNetworkInterface_TypeF(), "IsUp", (long) QNetworkInterface::InterfaceFlag::IsUp))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_INTERFACEFLAG_IDX],
        Sbk_QNetworkInterface_TypeF(), "IsRunning", (long) QNetworkInterface::InterfaceFlag::IsRunning))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_INTERFACEFLAG_IDX],
        Sbk_QNetworkInterface_TypeF(), "CanBroadcast", (long) QNetworkInterface::InterfaceFlag::CanBroadcast))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_INTERFACEFLAG_IDX],
        Sbk_QNetworkInterface_TypeF(), "IsLoopBack", (long) QNetworkInterface::InterfaceFlag::IsLoopBack))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_INTERFACEFLAG_IDX],
        Sbk_QNetworkInterface_TypeF(), "IsPointToPoint", (long) QNetworkInterface::InterfaceFlag::IsPointToPoint))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_INTERFACEFLAG_IDX],
        Sbk_QNetworkInterface_TypeF(), "CanMulticast", (long) QNetworkInterface::InterfaceFlag::CanMulticast))
        return;
    // Register converter for enum 'QNetworkInterface::InterfaceFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_INTERFACEFLAG_IDX],
            QNetworkInterface_InterfaceFlag_CppToPython_QNetworkInterface_InterfaceFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QNetworkInterface_InterfaceFlag_PythonToCpp_QNetworkInterface_InterfaceFlag,
            is_QNetworkInterface_InterfaceFlag_PythonToCpp_QNetworkInterface_InterfaceFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_INTERFACEFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QNetworkInterface::InterfaceFlag");
        Shiboken::Conversions::registerConverterName(converter, "InterfaceFlag");
    }
    // Register converter for flag 'QFlags<QNetworkInterface::InterfaceFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKINTERFACE_INTERFACEFLAG_IDX],
            QFlags_QNetworkInterface_InterfaceFlag__CppToPython_QFlags_QNetworkInterface_InterfaceFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QNetworkInterface_InterfaceFlag_PythonToCpp_QFlags_QNetworkInterface_InterfaceFlag_,
            is_QNetworkInterface_InterfaceFlag_PythonToCpp_QFlags_QNetworkInterface_InterfaceFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QNetworkInterface_InterfaceFlag__PythonToCpp_QFlags_QNetworkInterface_InterfaceFlag_,
            is_QFlags_QNetworkInterface_InterfaceFlag__PythonToCpp_QFlags_QNetworkInterface_InterfaceFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QNetworkInterface_InterfaceFlag_,
            is_number_PythonToCpp_QFlags_QNetworkInterface_InterfaceFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QNETWORKINTERFACE_INTERFACEFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QNetworkInterface::InterfaceFlags");
        Shiboken::Conversions::registerConverterName(converter, "InterfaceFlags");
    }
    // End of 'InterfaceFlag' enum/flags.

    // Initialization of enum 'InterfaceType'.
    SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_INTERFACETYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QNetworkInterface_TypeF(),
        "InterfaceType",
        "2:PySide2.QtNetwork.QNetworkInterface.InterfaceType",
        "QNetworkInterface::InterfaceType");
    if (!SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_INTERFACETYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_INTERFACETYPE_IDX],
        Sbk_QNetworkInterface_TypeF(), "Loopback", (long) QNetworkInterface::InterfaceType::Loopback))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_INTERFACETYPE_IDX],
        Sbk_QNetworkInterface_TypeF(), "Virtual", (long) QNetworkInterface::InterfaceType::Virtual))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_INTERFACETYPE_IDX],
        Sbk_QNetworkInterface_TypeF(), "Ethernet", (long) QNetworkInterface::InterfaceType::Ethernet))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_INTERFACETYPE_IDX],
        Sbk_QNetworkInterface_TypeF(), "Slip", (long) QNetworkInterface::InterfaceType::Slip))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_INTERFACETYPE_IDX],
        Sbk_QNetworkInterface_TypeF(), "CanBus", (long) QNetworkInterface::InterfaceType::CanBus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_INTERFACETYPE_IDX],
        Sbk_QNetworkInterface_TypeF(), "Ppp", (long) QNetworkInterface::InterfaceType::Ppp))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_INTERFACETYPE_IDX],
        Sbk_QNetworkInterface_TypeF(), "Fddi", (long) QNetworkInterface::InterfaceType::Fddi))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_INTERFACETYPE_IDX],
        Sbk_QNetworkInterface_TypeF(), "Wifi", (long) QNetworkInterface::InterfaceType::Wifi))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_INTERFACETYPE_IDX],
        Sbk_QNetworkInterface_TypeF(), "Ieee80211", (long) QNetworkInterface::InterfaceType::Ieee80211))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_INTERFACETYPE_IDX],
        Sbk_QNetworkInterface_TypeF(), "Phonet", (long) QNetworkInterface::InterfaceType::Phonet))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_INTERFACETYPE_IDX],
        Sbk_QNetworkInterface_TypeF(), "Ieee802154", (long) QNetworkInterface::InterfaceType::Ieee802154))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_INTERFACETYPE_IDX],
        Sbk_QNetworkInterface_TypeF(), "SixLoWPAN", (long) QNetworkInterface::InterfaceType::SixLoWPAN))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_INTERFACETYPE_IDX],
        Sbk_QNetworkInterface_TypeF(), "Ieee80216", (long) QNetworkInterface::InterfaceType::Ieee80216))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_INTERFACETYPE_IDX],
        Sbk_QNetworkInterface_TypeF(), "Ieee1394", (long) QNetworkInterface::InterfaceType::Ieee1394))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_INTERFACETYPE_IDX],
        Sbk_QNetworkInterface_TypeF(), "Unknown", (long) QNetworkInterface::InterfaceType::Unknown))
        return;
    // Register converter for enum 'QNetworkInterface::InterfaceType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_INTERFACETYPE_IDX],
            QNetworkInterface_InterfaceType_CppToPython_QNetworkInterface_InterfaceType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QNetworkInterface_InterfaceType_PythonToCpp_QNetworkInterface_InterfaceType,
            is_QNetworkInterface_InterfaceType_PythonToCpp_QNetworkInterface_InterfaceType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKINTERFACE_INTERFACETYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QNetworkInterface::InterfaceType");
        Shiboken::Conversions::registerConverterName(converter, "InterfaceType");
    }
    // End of 'InterfaceType' enum.

    qRegisterMetaType< ::QNetworkInterface >("QNetworkInterface");
    qRegisterMetaType< ::QNetworkInterface::InterfaceFlag >("QNetworkInterface::InterfaceFlag");
    qRegisterMetaType< ::QNetworkInterface::InterfaceFlags >("QNetworkInterface::InterfaceFlags");
    qRegisterMetaType< ::QNetworkInterface::InterfaceType >("QNetworkInterface::InterfaceType");
}
