/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtnetwork_python.h"

// main header
#include "qnetworkaccessmanager_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QNetworkAccessManagerWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QNetworkAccessManagerWrapper::QNetworkAccessManagerWrapper(::QObject * parent) : QNetworkAccessManager(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QNetworkAccessManagerWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QNetworkAccessManagerWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QNetworkReply * QNetworkAccessManagerWrapper::createRequest(::QNetworkAccessManager::Operation op, const ::QNetworkRequest & request, ::QIODevice * outgoingData)
{
    if (m_PyMethodCache[2])
        return this->::QNetworkAccessManager::createRequest(op, request, outgoingData);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "createRequest";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QNetworkAccessManager::createRequest(op, request, outgoingData);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNN)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_OPERATION_IDX])->converter, &op),
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX]), &request),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), outgoingData)
    ));
    bool invalidateArg3 = PyTuple_GET_ITEM(pyArgs, 2)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREPLY_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QNetworkAccessManager.createRequest", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QNetworkReply >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QNetworkReply *cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg3)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 2));
    return cppResult;
}

void QNetworkAccessManagerWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QNetworkAccessManagerWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[4]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QNetworkAccessManagerWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QNetworkAccessManager.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QNetworkAccessManagerWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[6])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QNetworkAccessManager.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QNetworkAccessManagerWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[8]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QNetworkAccessManagerWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QNetworkAccessManager::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QNetworkAccessManagerWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QNetworkAccessManager::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QNetworkAccessManagerWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QNetworkAccessManagerWrapper *>(this));
        return QNetworkAccessManager::qt_metacast(_clname);
}

QNetworkAccessManagerWrapper::~QNetworkAccessManagerWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QNetworkAccessManager_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QNetworkAccessManager >()))
        return -1;

    ::QNetworkAccessManagerWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAccessManager.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QNetworkAccessManager", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QNetworkAccessManager::QNetworkAccessManager(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QNetworkAccessManager(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QNetworkAccessManager(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkAccessManager_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QNetworkAccessManager_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_QNetworkAccessManager_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QNetworkAccessManager(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QNetworkAccessManagerWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QNetworkAccessManagerWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QNetworkAccessManager >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QNetworkAccessManager_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QNetworkAccessManager_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QNetworkAccessManager_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QNetworkAccessManagerFunc_activeConfiguration(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAccessManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAccessManager.activeConfiguration";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // activeConfiguration()const
            QNetworkConfiguration cppResult = const_cast<const ::QNetworkAccessManager *>(cppSelf)->activeConfiguration();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkAccessManagerFunc_addStrictTransportSecurityHosts(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAccessManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAccessManager.addStrictTransportSecurityHosts";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkAccessManager::addStrictTransportSecurityHosts(QVector<QHstsPolicy>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QVECTOR_QHSTSPOLICY_IDX], (pyArg)))) {
        overloadId = 0; // addStrictTransportSecurityHosts(QVector<QHstsPolicy>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkAccessManagerFunc_addStrictTransportSecurityHosts_TypeError;

    // Call function/method
    {
        ::QVector<QHstsPolicy > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // addStrictTransportSecurityHosts(QVector<QHstsPolicy>)
            cppSelf->addStrictTransportSecurityHosts(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkAccessManagerFunc_addStrictTransportSecurityHosts_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkAccessManagerFunc_autoDeleteReplies(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAccessManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAccessManager.autoDeleteReplies";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // autoDeleteReplies()const
            bool cppResult = const_cast<const ::QNetworkAccessManager *>(cppSelf)->autoDeleteReplies();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkAccessManagerFunc_cache(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAccessManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAccessManager.cache";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // cache()const
            QAbstractNetworkCache * cppResult = const_cast<const ::QNetworkAccessManager *>(cppSelf)->cache();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTNETWORKCACHE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkAccessManagerFunc_clearAccessCache(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAccessManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAccessManager.clearAccessCache";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clearAccessCache()
            cppSelf->clearAccessCache();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QNetworkAccessManagerFunc_clearConnectionCache(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAccessManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAccessManager.clearConnectionCache";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clearConnectionCache()
            cppSelf->clearConnectionCache();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QNetworkAccessManagerFunc_configuration(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAccessManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAccessManager.configuration";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // configuration()const
            QNetworkConfiguration cppResult = const_cast<const ::QNetworkAccessManager *>(cppSelf)->configuration();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkAccessManagerFunc_connectToHost(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAccessManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAccessManager.connectToHost";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QNetworkAccessManagerFunc_connectToHost_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QNetworkAccessManagerFunc_connectToHost_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:connectToHost", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QNetworkAccessManager::connectToHost(QString,quint16)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // connectToHost(QString,quint16)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint16>(), (pyArgs[1])))) {
            overloadId = 0; // connectToHost(QString,quint16)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkAccessManagerFunc_connectToHost_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_port = Shiboken::String::createStaticString("port");
            if (PyDict_Contains(kwds, key_port)) {
                value = PyDict_GetItem(kwds, key_port);
                if (value && pyArgs[1]) {
                    errInfo = key_port;
                    Py_INCREF(errInfo);
                    goto Sbk_QNetworkAccessManagerFunc_connectToHost_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint16>(), (pyArgs[1]))))
                        goto Sbk_QNetworkAccessManagerFunc_connectToHost_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_port);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QNetworkAccessManagerFunc_connectToHost_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        quint16 cppArg1 = 80;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // connectToHost(QString,quint16)
            cppSelf->connectToHost(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkAccessManagerFunc_connectToHost_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkAccessManagerFunc_connectToHostEncrypted(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAccessManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAccessManager.connectToHostEncrypted";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QNetworkAccessManagerFunc_connectToHostEncrypted_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QNetworkAccessManagerFunc_connectToHostEncrypted_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:connectToHostEncrypted", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QNetworkAccessManager::connectToHostEncrypted(QString,quint16,QSslConfiguration)
    // 1: QNetworkAccessManager::connectToHostEncrypted(QString,quint16,QSslConfiguration,QString)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // connectToHostEncrypted(QString,quint16,QSslConfiguration)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint16>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // connectToHostEncrypted(QString,quint16,QSslConfiguration)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX]), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // connectToHostEncrypted(QString,quint16,QSslConfiguration)
                } else if (numArgs == 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3])))) {
                    overloadId = 1; // connectToHostEncrypted(QString,quint16,QSslConfiguration,QString)
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkAccessManagerFunc_connectToHostEncrypted_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // connectToHostEncrypted(const QString & hostName, quint16 port, const QSslConfiguration & sslConfiguration)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_port = Shiboken::String::createStaticString("port");
                if (PyDict_Contains(kwds, key_port)) {
                    value = PyDict_GetItem(kwds, key_port);
                    if (value && pyArgs[1]) {
                        errInfo = key_port;
                        Py_INCREF(errInfo);
                        goto Sbk_QNetworkAccessManagerFunc_connectToHostEncrypted_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint16>(), (pyArgs[1]))))
                            goto Sbk_QNetworkAccessManagerFunc_connectToHostEncrypted_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_port);
                }
                static PyObject *const key_sslConfiguration = Shiboken::String::createStaticString("sslConfiguration");
                if (PyDict_Contains(kwds, key_sslConfiguration)) {
                    value = PyDict_GetItem(kwds, key_sslConfiguration);
                    if (value && pyArgs[2]) {
                        errInfo = key_sslConfiguration;
                        Py_INCREF(errInfo);
                        goto Sbk_QNetworkAccessManagerFunc_connectToHostEncrypted_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX]), (pyArgs[2]))))
                            goto Sbk_QNetworkAccessManagerFunc_connectToHostEncrypted_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_sslConfiguration);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QNetworkAccessManagerFunc_connectToHostEncrypted_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            quint16 cppArg1 = 443;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QSslConfiguration cppArg2_local = QSslConfiguration::defaultConfiguration();
            ::QSslConfiguration *cppArg2 = &cppArg2_local;
            if (pythonToCpp[2]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);
            }

            if (!PyErr_Occurred()) {
                // connectToHostEncrypted(QString,quint16,QSslConfiguration)
                cppSelf->connectToHostEncrypted(cppArg0, cppArg1, *cppArg2);
            }
            break;
        }
        case 1: // connectToHostEncrypted(const QString & hostName, quint16 port, const QSslConfiguration & sslConfiguration, const QString & peerName)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QNetworkAccessManagerFunc_connectToHostEncrypted_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            quint16 cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QSslConfiguration cppArg2_local;
            ::QSslConfiguration *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);

            ::QString cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // connectToHostEncrypted(QString,quint16,QSslConfiguration,QString)
                cppSelf->connectToHostEncrypted(cppArg0, cppArg1, *cppArg2, cppArg3);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkAccessManagerFunc_connectToHostEncrypted_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkAccessManagerFunc_cookieJar(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAccessManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAccessManager.cookieJar";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // cookieJar()const
            QNetworkCookieJar * cppResult = const_cast<const ::QNetworkAccessManager *>(cppSelf)->cookieJar();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCOOKIEJAR_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkAccessManagerFunc_createRequest(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAccessManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAccessManager.createRequest";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QNetworkAccessManagerFunc_createRequest_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QNetworkAccessManagerFunc_createRequest_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:createRequest", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QNetworkAccessManager::createRequest(QNetworkAccessManager::Operation,QNetworkRequest,QIODevice*)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_OPERATION_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // createRequest(QNetworkAccessManager::Operation,QNetworkRequest,QIODevice*)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArgs[2])))) {
            overloadId = 0; // createRequest(QNetworkAccessManager::Operation,QNetworkRequest,QIODevice*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkAccessManagerFunc_createRequest_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_outgoingData = Shiboken::String::createStaticString("outgoingData");
            if (PyDict_Contains(kwds, key_outgoingData)) {
                value = PyDict_GetItem(kwds, key_outgoingData);
                if (value && pyArgs[2]) {
                    errInfo = key_outgoingData;
                    Py_INCREF(errInfo);
                    goto Sbk_QNetworkAccessManagerFunc_createRequest_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArgs[2]))))
                        goto Sbk_QNetworkAccessManagerFunc_createRequest_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_outgoingData);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QNetworkAccessManagerFunc_createRequest_TypeError;
            }
        }
        ::QNetworkAccessManager::Operation cppArg0{QNetworkAccessManager::UnknownOperation};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QNetworkRequest cppArg1_local;
        ::QNetworkRequest *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QIODevice *cppArg2 = nullptr;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // createRequest(QNetworkAccessManager::Operation,QNetworkRequest,QIODevice*)
            QNetworkReply * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QNetworkAccessManager::createRequest(cppArg0, *cppArg1, cppArg2)
                : cppSelf->createRequest(cppArg0, *cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREPLY_IDX]), cppResult);

            // Ownership transferences.
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QNetworkAccessManagerFunc_createRequest_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkAccessManagerFunc_deleteResource(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAccessManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAccessManager.deleteResource";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkAccessManager::deleteResource(QNetworkRequest)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX]), (pyArg)))) {
        overloadId = 0; // deleteResource(QNetworkRequest)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkAccessManagerFunc_deleteResource_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QNetworkRequest cppArg0_local;
        ::QNetworkRequest *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // deleteResource(QNetworkRequest)
            QNetworkReply * cppResult = cppSelf->deleteResource(*cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREPLY_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QNetworkAccessManagerFunc_deleteResource_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkAccessManagerFunc_enableStrictTransportSecurityStore(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAccessManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAccessManager.enableStrictTransportSecurityStore";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QNetworkAccessManagerFunc_enableStrictTransportSecurityStore_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QNetworkAccessManagerFunc_enableStrictTransportSecurityStore_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:enableStrictTransportSecurityStore", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QNetworkAccessManager::enableStrictTransportSecurityStore(bool,QString)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // enableStrictTransportSecurityStore(bool,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 0; // enableStrictTransportSecurityStore(bool,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkAccessManagerFunc_enableStrictTransportSecurityStore_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_storeDir = Shiboken::String::createStaticString("storeDir");
            if (PyDict_Contains(kwds, key_storeDir)) {
                value = PyDict_GetItem(kwds, key_storeDir);
                if (value && pyArgs[1]) {
                    errInfo = key_storeDir;
                    Py_INCREF(errInfo);
                    goto Sbk_QNetworkAccessManagerFunc_enableStrictTransportSecurityStore_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                        goto Sbk_QNetworkAccessManagerFunc_enableStrictTransportSecurityStore_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_storeDir);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QNetworkAccessManagerFunc_enableStrictTransportSecurityStore_TypeError;
            }
        }
        bool cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1 = QString();
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // enableStrictTransportSecurityStore(bool,QString)
            cppSelf->enableStrictTransportSecurityStore(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkAccessManagerFunc_enableStrictTransportSecurityStore_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkAccessManagerFunc_get(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAccessManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAccessManager.get";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkAccessManager::get(QNetworkRequest)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX]), (pyArg)))) {
        overloadId = 0; // get(QNetworkRequest)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkAccessManagerFunc_get_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QNetworkRequest cppArg0_local;
        ::QNetworkRequest *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // get(QNetworkRequest)
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            QNetworkReply * cppResult = cppSelf->get(*cppArg0);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREPLY_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QNetworkAccessManagerFunc_get_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkAccessManagerFunc_head(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAccessManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAccessManager.head";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkAccessManager::head(QNetworkRequest)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX]), (pyArg)))) {
        overloadId = 0; // head(QNetworkRequest)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkAccessManagerFunc_head_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QNetworkRequest cppArg0_local;
        ::QNetworkRequest *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // head(QNetworkRequest)
            QNetworkReply * cppResult = cppSelf->head(*cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREPLY_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QNetworkAccessManagerFunc_head_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkAccessManagerFunc_isStrictTransportSecurityEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAccessManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAccessManager.isStrictTransportSecurityEnabled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isStrictTransportSecurityEnabled()const
            bool cppResult = const_cast<const ::QNetworkAccessManager *>(cppSelf)->isStrictTransportSecurityEnabled();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkAccessManagerFunc_isStrictTransportSecurityStoreEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAccessManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAccessManager.isStrictTransportSecurityStoreEnabled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isStrictTransportSecurityStoreEnabled()const
            bool cppResult = const_cast<const ::QNetworkAccessManager *>(cppSelf)->isStrictTransportSecurityStoreEnabled();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkAccessManagerFunc_networkAccessible(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAccessManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAccessManager.networkAccessible";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // networkAccessible()const
            QNetworkAccessManager::NetworkAccessibility cppResult = const_cast<const ::QNetworkAccessManager *>(cppSelf)->networkAccessible();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_NETWORKACCESSIBILITY_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkAccessManagerFunc_post(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAccessManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAccessManager.post";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "post", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QNetworkAccessManager::post(QNetworkRequest,QHttpMultiPart*)
    // 1: QNetworkAccessManager::post(QNetworkRequest,QIODevice*)
    // 2: QNetworkAccessManager::post(QNetworkRequest,QByteArray)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX]), (pyArgs[0])))) {
        if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[1])))) {
            overloadId = 2; // post(QNetworkRequest,QByteArray)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArgs[1])))) {
            overloadId = 1; // post(QNetworkRequest,QIODevice*)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHTTPMULTIPART_IDX]), (pyArgs[1])))) {
            overloadId = 0; // post(QNetworkRequest,QHttpMultiPart*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkAccessManagerFunc_post_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // post(const QNetworkRequest & request, QHttpMultiPart * multiPart)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QNetworkRequest cppArg0_local;
            ::QNetworkRequest *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QHttpMultiPart *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // post(QNetworkRequest,QHttpMultiPart*)
                QNetworkReply * cppResult = cppSelf->post(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREPLY_IDX]), cppResult);
                Shiboken::Object::setParent(self, pyResult);
            }
            break;
        }
        case 1: // post(const QNetworkRequest & request, QIODevice * data)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QNetworkRequest cppArg0_local;
            ::QNetworkRequest *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QIODevice *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // post(QNetworkRequest,QIODevice*)
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                QNetworkReply * cppResult = cppSelf->post(*cppArg0, cppArg1);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREPLY_IDX]), cppResult);
                Shiboken::Object::setParent(self, pyResult);
            }
            break;
        }
        case 2: // post(const QNetworkRequest & request, const QByteArray & data)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QNetworkRequest cppArg0_local;
            ::QNetworkRequest *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QByteArray cppArg1_local;
            ::QByteArray *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // post(QNetworkRequest,QByteArray)
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                QNetworkReply * cppResult = cppSelf->post(*cppArg0, *cppArg1);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREPLY_IDX]), cppResult);
                Shiboken::Object::setParent(self, pyResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QNetworkAccessManagerFunc_post_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkAccessManagerFunc_proxy(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAccessManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAccessManager.proxy";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // proxy()const
            QNetworkProxy cppResult = const_cast<const ::QNetworkAccessManager *>(cppSelf)->proxy();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkAccessManagerFunc_proxyFactory(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAccessManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAccessManager.proxyFactory";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // proxyFactory()const
            QNetworkProxyFactory * cppResult = const_cast<const ::QNetworkAccessManager *>(cppSelf)->proxyFactory();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYFACTORY_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkAccessManagerFunc_put(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAccessManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAccessManager.put";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "put", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QNetworkAccessManager::put(QNetworkRequest,QHttpMultiPart*)
    // 1: QNetworkAccessManager::put(QNetworkRequest,QIODevice*)
    // 2: QNetworkAccessManager::put(QNetworkRequest,QByteArray)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX]), (pyArgs[0])))) {
        if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[1])))) {
            overloadId = 2; // put(QNetworkRequest,QByteArray)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArgs[1])))) {
            overloadId = 1; // put(QNetworkRequest,QIODevice*)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHTTPMULTIPART_IDX]), (pyArgs[1])))) {
            overloadId = 0; // put(QNetworkRequest,QHttpMultiPart*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkAccessManagerFunc_put_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // put(const QNetworkRequest & request, QHttpMultiPart * multiPart)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QNetworkRequest cppArg0_local;
            ::QNetworkRequest *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QHttpMultiPart *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // put(QNetworkRequest,QHttpMultiPart*)
                QNetworkReply * cppResult = cppSelf->put(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREPLY_IDX]), cppResult);
                Shiboken::Object::setParent(self, pyResult);
            }
            break;
        }
        case 1: // put(const QNetworkRequest & request, QIODevice * data)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QNetworkRequest cppArg0_local;
            ::QNetworkRequest *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QIODevice *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // put(QNetworkRequest,QIODevice*)
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                QNetworkReply * cppResult = cppSelf->put(*cppArg0, cppArg1);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREPLY_IDX]), cppResult);
                Shiboken::Object::setParent(self, pyResult);
            }
            break;
        }
        case 2: // put(const QNetworkRequest & request, const QByteArray & data)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QNetworkRequest cppArg0_local;
            ::QNetworkRequest *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QByteArray cppArg1_local;
            ::QByteArray *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // put(QNetworkRequest,QByteArray)
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                QNetworkReply * cppResult = cppSelf->put(*cppArg0, *cppArg1);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREPLY_IDX]), cppResult);
                Shiboken::Object::setParent(self, pyResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QNetworkAccessManagerFunc_put_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkAccessManagerFunc_redirectPolicy(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAccessManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAccessManager.redirectPolicy";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // redirectPolicy()const
            QNetworkRequest::RedirectPolicy cppResult = const_cast<const ::QNetworkAccessManager *>(cppSelf)->redirectPolicy();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_REDIRECTPOLICY_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkAccessManagerFunc_sendCustomRequest(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAccessManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAccessManager.sendCustomRequest";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QNetworkAccessManagerFunc_sendCustomRequest_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QNetworkAccessManagerFunc_sendCustomRequest_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:sendCustomRequest", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QNetworkAccessManager::sendCustomRequest(QNetworkRequest,QByteArray,QHttpMultiPart*)
    // 1: QNetworkAccessManager::sendCustomRequest(QNetworkRequest,QByteArray,QIODevice*)
    // 2: QNetworkAccessManager::sendCustomRequest(QNetworkRequest,QByteArray,QByteArray)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 1; // sendCustomRequest(QNetworkRequest,QByteArray,QIODevice*)
        } else if (numArgs == 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[2])))) {
            overloadId = 2; // sendCustomRequest(QNetworkRequest,QByteArray,QByteArray)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArgs[2])))) {
            overloadId = 1; // sendCustomRequest(QNetworkRequest,QByteArray,QIODevice*)
        } else if (numArgs == 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHTTPMULTIPART_IDX]), (pyArgs[2])))) {
            overloadId = 0; // sendCustomRequest(QNetworkRequest,QByteArray,QHttpMultiPart*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkAccessManagerFunc_sendCustomRequest_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // sendCustomRequest(const QNetworkRequest & request, const QByteArray & verb, QHttpMultiPart * multiPart)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QNetworkAccessManagerFunc_sendCustomRequest_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QNetworkRequest cppArg0_local;
            ::QNetworkRequest *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QByteArray cppArg1_local;
            ::QByteArray *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QHttpMultiPart *cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // sendCustomRequest(QNetworkRequest,QByteArray,QHttpMultiPart*)
                QNetworkReply * cppResult = cppSelf->sendCustomRequest(*cppArg0, *cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREPLY_IDX]), cppResult);
                Shiboken::Object::setParent(self, pyResult);
            }
            break;
        }
        case 1: // sendCustomRequest(const QNetworkRequest & request, const QByteArray & verb, QIODevice * data)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_data = Shiboken::String::createStaticString("data");
                if (PyDict_Contains(kwds, key_data)) {
                    value = PyDict_GetItem(kwds, key_data);
                    if (value && pyArgs[2]) {
                        errInfo = key_data;
                        Py_INCREF(errInfo);
                        goto Sbk_QNetworkAccessManagerFunc_sendCustomRequest_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArgs[2]))))
                            goto Sbk_QNetworkAccessManagerFunc_sendCustomRequest_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_data);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QNetworkAccessManagerFunc_sendCustomRequest_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QNetworkRequest cppArg0_local;
            ::QNetworkRequest *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QByteArray cppArg1_local;
            ::QByteArray *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QIODevice *cppArg2 = nullptr;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // sendCustomRequest(QNetworkRequest,QByteArray,QIODevice*)
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                QNetworkReply * cppResult = cppSelf->sendCustomRequest(*cppArg0, *cppArg1, cppArg2);
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREPLY_IDX]), cppResult);
                Shiboken::Object::setParent(self, pyResult);
            }
            break;
        }
        case 2: // sendCustomRequest(const QNetworkRequest & request, const QByteArray & verb, const QByteArray & data)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QNetworkAccessManagerFunc_sendCustomRequest_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QNetworkRequest cppArg0_local;
            ::QNetworkRequest *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QByteArray cppArg1_local;
            ::QByteArray *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QByteArray cppArg2_local;
            ::QByteArray *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);


            if (!PyErr_Occurred()) {
                // sendCustomRequest(QNetworkRequest,QByteArray,QByteArray)
                QNetworkReply * cppResult = cppSelf->sendCustomRequest(*cppArg0, *cppArg1, *cppArg2);
                pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREPLY_IDX]), cppResult);
                Shiboken::Object::setParent(self, pyResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QNetworkAccessManagerFunc_sendCustomRequest_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkAccessManagerFunc_setAutoDeleteReplies(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAccessManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAccessManager.setAutoDeleteReplies";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkAccessManager::setAutoDeleteReplies(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setAutoDeleteReplies(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkAccessManagerFunc_setAutoDeleteReplies_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAutoDeleteReplies(bool)
            cppSelf->setAutoDeleteReplies(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkAccessManagerFunc_setAutoDeleteReplies_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkAccessManagerFunc_setCache(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAccessManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAccessManager.setCache";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkAccessManager::setCache(QAbstractNetworkCache*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTNETWORKCACHE_IDX]), (pyArg)))) {
        overloadId = 0; // setCache(QAbstractNetworkCache*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkAccessManagerFunc_setCache_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAbstractNetworkCache *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCache(QAbstractNetworkCache*)
            cppSelf->setCache(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkAccessManagerFunc_setCache_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkAccessManagerFunc_setConfiguration(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAccessManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAccessManager.setConfiguration";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkAccessManager::setConfiguration(QNetworkConfiguration)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX]), (pyArg)))) {
        overloadId = 0; // setConfiguration(QNetworkConfiguration)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkAccessManagerFunc_setConfiguration_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QNetworkConfiguration cppArg0_local;
        ::QNetworkConfiguration *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setConfiguration(QNetworkConfiguration)
            cppSelf->setConfiguration(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkAccessManagerFunc_setConfiguration_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkAccessManagerFunc_setCookieJar(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAccessManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAccessManager.setCookieJar";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkAccessManager::setCookieJar(QNetworkCookieJar*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCOOKIEJAR_IDX]), (pyArg)))) {
        overloadId = 0; // setCookieJar(QNetworkCookieJar*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkAccessManagerFunc_setCookieJar_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QNetworkCookieJar *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCookieJar(QNetworkCookieJar*)
            cppSelf->setCookieJar(cppArg0);

            // Ownership transferences.
            Shiboken::Object::releaseOwnership(pyArg);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkAccessManagerFunc_setCookieJar_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkAccessManagerFunc_setNetworkAccessible(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAccessManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAccessManager.setNetworkAccessible";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkAccessManager::setNetworkAccessible(QNetworkAccessManager::NetworkAccessibility)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_NETWORKACCESSIBILITY_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setNetworkAccessible(QNetworkAccessManager::NetworkAccessibility)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkAccessManagerFunc_setNetworkAccessible_TypeError;

    // Call function/method
    {
        ::QNetworkAccessManager::NetworkAccessibility cppArg0{QNetworkAccessManager::NotAccessible};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setNetworkAccessible(QNetworkAccessManager::NetworkAccessibility)
            cppSelf->setNetworkAccessible(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkAccessManagerFunc_setNetworkAccessible_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkAccessManagerFunc_setProxy(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAccessManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAccessManager.setProxy";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkAccessManager::setProxy(QNetworkProxy)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX]), (pyArg)))) {
        overloadId = 0; // setProxy(QNetworkProxy)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkAccessManagerFunc_setProxy_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QNetworkProxy cppArg0_local;
        ::QNetworkProxy *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setProxy(QNetworkProxy)
            cppSelf->setProxy(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkAccessManagerFunc_setProxy_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkAccessManagerFunc_setProxyFactory(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAccessManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAccessManager.setProxyFactory";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkAccessManager::setProxyFactory(QNetworkProxyFactory*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXYFACTORY_IDX]), (pyArg)))) {
        overloadId = 0; // setProxyFactory(QNetworkProxyFactory*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkAccessManagerFunc_setProxyFactory_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QNetworkProxyFactory *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setProxyFactory(QNetworkProxyFactory*)
            cppSelf->setProxyFactory(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkAccessManagerFunc_setProxyFactory_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkAccessManagerFunc_setRedirectPolicy(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAccessManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAccessManager.setRedirectPolicy";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkAccessManager::setRedirectPolicy(QNetworkRequest::RedirectPolicy)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QNETWORKREQUEST_REDIRECTPOLICY_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setRedirectPolicy(QNetworkRequest::RedirectPolicy)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkAccessManagerFunc_setRedirectPolicy_TypeError;

    // Call function/method
    {
        ::QNetworkRequest::RedirectPolicy cppArg0{QNetworkRequest::ManualRedirectPolicy};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRedirectPolicy(QNetworkRequest::RedirectPolicy)
            cppSelf->setRedirectPolicy(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkAccessManagerFunc_setRedirectPolicy_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkAccessManagerFunc_setStrictTransportSecurityEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAccessManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAccessManager.setStrictTransportSecurityEnabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QNetworkAccessManager::setStrictTransportSecurityEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setStrictTransportSecurityEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkAccessManagerFunc_setStrictTransportSecurityEnabled_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setStrictTransportSecurityEnabled(bool)
            cppSelf->setStrictTransportSecurityEnabled(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkAccessManagerFunc_setStrictTransportSecurityEnabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkAccessManagerFunc_setTransferTimeout(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAccessManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAccessManager.setTransferTimeout";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QNetworkAccessManagerFunc_setTransferTimeout_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:setTransferTimeout", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QNetworkAccessManager::setTransferTimeout(int)
    if (numArgs == 0) {
        overloadId = 0; // setTransferTimeout(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 0; // setTransferTimeout(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QNetworkAccessManagerFunc_setTransferTimeout_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_timeout = Shiboken::String::createStaticString("timeout");
            if (PyDict_Contains(kwds, key_timeout)) {
                value = PyDict_GetItem(kwds, key_timeout);
                if (value && pyArgs[0]) {
                    errInfo = key_timeout;
                    Py_INCREF(errInfo);
                    goto Sbk_QNetworkAccessManagerFunc_setTransferTimeout_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QNetworkAccessManagerFunc_setTransferTimeout_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_timeout);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QNetworkAccessManagerFunc_setTransferTimeout_TypeError;
            }
        }
        int cppArg0 = QNetworkRequest::DefaultTransferTimeoutConstant;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // setTransferTimeout(int)
            cppSelf->setTransferTimeout(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QNetworkAccessManagerFunc_setTransferTimeout_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QNetworkAccessManagerFunc_strictTransportSecurityHosts(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAccessManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAccessManager.strictTransportSecurityHosts";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // strictTransportSecurityHosts()const
            QVector<QHstsPolicy > cppResult = const_cast<const ::QNetworkAccessManager *>(cppSelf)->strictTransportSecurityHosts();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QVECTOR_QHSTSPOLICY_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkAccessManagerFunc_supportedSchemes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAccessManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAccessManager.supportedSchemes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedSchemes()const
            QStringList cppResult = const_cast<const ::QNetworkAccessManager *>(cppSelf)->supportedSchemes();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkAccessManagerFunc_supportedSchemesImplementation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAccessManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAccessManager.supportedSchemesImplementation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedSchemesImplementation()const
            QStringList cppResult = const_cast<const ::QNetworkAccessManager *>(cppSelf)->supportedSchemesImplementation();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QNetworkAccessManagerFunc_transferTimeout(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QNetworkAccessManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QNetworkAccessManager.transferTimeout";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // transferTimeout()const
            int cppResult = const_cast<const ::QNetworkAccessManager *>(cppSelf)->transferTimeout();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QNetworkAccessManager_PropertyStrings[] = {
    "networkAccessible::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QNetworkAccessManager_methods[] = {
    {"activeConfiguration", reinterpret_cast<PyCFunction>(Sbk_QNetworkAccessManagerFunc_activeConfiguration), METH_NOARGS},
    {"addStrictTransportSecurityHosts", reinterpret_cast<PyCFunction>(Sbk_QNetworkAccessManagerFunc_addStrictTransportSecurityHosts), METH_O},
    {"autoDeleteReplies", reinterpret_cast<PyCFunction>(Sbk_QNetworkAccessManagerFunc_autoDeleteReplies), METH_NOARGS},
    {"cache", reinterpret_cast<PyCFunction>(Sbk_QNetworkAccessManagerFunc_cache), METH_NOARGS},
    {"clearAccessCache", reinterpret_cast<PyCFunction>(Sbk_QNetworkAccessManagerFunc_clearAccessCache), METH_NOARGS},
    {"clearConnectionCache", reinterpret_cast<PyCFunction>(Sbk_QNetworkAccessManagerFunc_clearConnectionCache), METH_NOARGS},
    {"configuration", reinterpret_cast<PyCFunction>(Sbk_QNetworkAccessManagerFunc_configuration), METH_NOARGS},
    {"connectToHost", reinterpret_cast<PyCFunction>(Sbk_QNetworkAccessManagerFunc_connectToHost), METH_VARARGS|METH_KEYWORDS},
    {"connectToHostEncrypted", reinterpret_cast<PyCFunction>(Sbk_QNetworkAccessManagerFunc_connectToHostEncrypted), METH_VARARGS|METH_KEYWORDS},
    {"cookieJar", reinterpret_cast<PyCFunction>(Sbk_QNetworkAccessManagerFunc_cookieJar), METH_NOARGS},
    {"createRequest", reinterpret_cast<PyCFunction>(Sbk_QNetworkAccessManagerFunc_createRequest), METH_VARARGS|METH_KEYWORDS},
    {"deleteResource", reinterpret_cast<PyCFunction>(Sbk_QNetworkAccessManagerFunc_deleteResource), METH_O},
    {"enableStrictTransportSecurityStore", reinterpret_cast<PyCFunction>(Sbk_QNetworkAccessManagerFunc_enableStrictTransportSecurityStore), METH_VARARGS|METH_KEYWORDS},
    {"get", reinterpret_cast<PyCFunction>(Sbk_QNetworkAccessManagerFunc_get), METH_O},
    {"head", reinterpret_cast<PyCFunction>(Sbk_QNetworkAccessManagerFunc_head), METH_O},
    {"isStrictTransportSecurityEnabled", reinterpret_cast<PyCFunction>(Sbk_QNetworkAccessManagerFunc_isStrictTransportSecurityEnabled), METH_NOARGS},
    {"isStrictTransportSecurityStoreEnabled", reinterpret_cast<PyCFunction>(Sbk_QNetworkAccessManagerFunc_isStrictTransportSecurityStoreEnabled), METH_NOARGS},
    {"networkAccessible", reinterpret_cast<PyCFunction>(Sbk_QNetworkAccessManagerFunc_networkAccessible), METH_NOARGS},
    {"post", reinterpret_cast<PyCFunction>(Sbk_QNetworkAccessManagerFunc_post), METH_VARARGS},
    {"proxy", reinterpret_cast<PyCFunction>(Sbk_QNetworkAccessManagerFunc_proxy), METH_NOARGS},
    {"proxyFactory", reinterpret_cast<PyCFunction>(Sbk_QNetworkAccessManagerFunc_proxyFactory), METH_NOARGS},
    {"put", reinterpret_cast<PyCFunction>(Sbk_QNetworkAccessManagerFunc_put), METH_VARARGS},
    {"redirectPolicy", reinterpret_cast<PyCFunction>(Sbk_QNetworkAccessManagerFunc_redirectPolicy), METH_NOARGS},
    {"sendCustomRequest", reinterpret_cast<PyCFunction>(Sbk_QNetworkAccessManagerFunc_sendCustomRequest), METH_VARARGS|METH_KEYWORDS},
    {"setAutoDeleteReplies", reinterpret_cast<PyCFunction>(Sbk_QNetworkAccessManagerFunc_setAutoDeleteReplies), METH_O},
    {"setCache", reinterpret_cast<PyCFunction>(Sbk_QNetworkAccessManagerFunc_setCache), METH_O},
    {"setConfiguration", reinterpret_cast<PyCFunction>(Sbk_QNetworkAccessManagerFunc_setConfiguration), METH_O},
    {"setCookieJar", reinterpret_cast<PyCFunction>(Sbk_QNetworkAccessManagerFunc_setCookieJar), METH_O},
    {"setNetworkAccessible", reinterpret_cast<PyCFunction>(Sbk_QNetworkAccessManagerFunc_setNetworkAccessible), METH_O},
    {"setProxy", reinterpret_cast<PyCFunction>(Sbk_QNetworkAccessManagerFunc_setProxy), METH_O},
    {"setProxyFactory", reinterpret_cast<PyCFunction>(Sbk_QNetworkAccessManagerFunc_setProxyFactory), METH_O},
    {"setRedirectPolicy", reinterpret_cast<PyCFunction>(Sbk_QNetworkAccessManagerFunc_setRedirectPolicy), METH_O},
    {"setStrictTransportSecurityEnabled", reinterpret_cast<PyCFunction>(Sbk_QNetworkAccessManagerFunc_setStrictTransportSecurityEnabled), METH_O},
    {"setTransferTimeout", reinterpret_cast<PyCFunction>(Sbk_QNetworkAccessManagerFunc_setTransferTimeout), METH_VARARGS|METH_KEYWORDS},
    {"strictTransportSecurityHosts", reinterpret_cast<PyCFunction>(Sbk_QNetworkAccessManagerFunc_strictTransportSecurityHosts), METH_NOARGS},
    {"supportedSchemes", reinterpret_cast<PyCFunction>(Sbk_QNetworkAccessManagerFunc_supportedSchemes), METH_NOARGS},
    {"supportedSchemesImplementation", reinterpret_cast<PyCFunction>(Sbk_QNetworkAccessManagerFunc_supportedSchemesImplementation), METH_NOARGS},
    {"transferTimeout", reinterpret_cast<PyCFunction>(Sbk_QNetworkAccessManagerFunc_transferTimeout), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QNetworkAccessManager_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QNetworkAccessManager *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QNetworkAccessManagerWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QNetworkAccessManager_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QNetworkAccessManager_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QNetworkAccessManager_Type = nullptr;
static SbkObjectType *Sbk_QNetworkAccessManager_TypeF(void)
{
    return _Sbk_QNetworkAccessManager_Type;
}

static PyType_Slot Sbk_QNetworkAccessManager_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QNetworkAccessManager_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QNetworkAccessManager_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QNetworkAccessManager_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QNetworkAccessManager_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QNetworkAccessManager_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QNetworkAccessManager_spec = {
    "2:PySide2.QtNetwork.QNetworkAccessManager",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QNetworkAccessManager_slots
};

} //extern "C"

static void *Sbk_QNetworkAccessManager_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QNetworkAccessManager *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QNetworkAccessManager_Operation_PythonToCpp_QNetworkAccessManager_Operation(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QNetworkAccessManager::Operation *>(cppOut) =
        static_cast<::QNetworkAccessManager::Operation>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QNetworkAccessManager_Operation_PythonToCpp_QNetworkAccessManager_Operation_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_OPERATION_IDX]))
        return QNetworkAccessManager_Operation_PythonToCpp_QNetworkAccessManager_Operation;
    return {};
}
static PyObject *QNetworkAccessManager_Operation_CppToPython_QNetworkAccessManager_Operation(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QNetworkAccessManager::Operation *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_OPERATION_IDX], castCppIn);

}

static void QNetworkAccessManager_NetworkAccessibility_PythonToCpp_QNetworkAccessManager_NetworkAccessibility(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QNetworkAccessManager::NetworkAccessibility *>(cppOut) =
        static_cast<::QNetworkAccessManager::NetworkAccessibility>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QNetworkAccessManager_NetworkAccessibility_PythonToCpp_QNetworkAccessManager_NetworkAccessibility_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_NETWORKACCESSIBILITY_IDX]))
        return QNetworkAccessManager_NetworkAccessibility_PythonToCpp_QNetworkAccessManager_NetworkAccessibility;
    return {};
}
static PyObject *QNetworkAccessManager_NetworkAccessibility_CppToPython_QNetworkAccessManager_NetworkAccessibility(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QNetworkAccessManager::NetworkAccessibility *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_NETWORKACCESSIBILITY_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QNetworkAccessManager_PythonToCpp_QNetworkAccessManager_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QNetworkAccessManager_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QNetworkAccessManager_PythonToCpp_QNetworkAccessManager_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QNetworkAccessManager_TypeF())))
        return QNetworkAccessManager_PythonToCpp_QNetworkAccessManager_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QNetworkAccessManager_PTR_CppToPython_QNetworkAccessManager(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QNetworkAccessManager *>(const_cast<void *>(cppIn)), Sbk_QNetworkAccessManager_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QNetworkAccessManager_SignatureStrings[] = {
    "PySide2.QtNetwork.QNetworkAccessManager(self,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtNetwork.QNetworkAccessManager.activeConfiguration(self)->PySide2.QtNetwork.QNetworkConfiguration",
    "PySide2.QtNetwork.QNetworkAccessManager.addStrictTransportSecurityHosts(self,knownHosts:QVector[PySide2.QtNetwork.QHstsPolicy])",
    "PySide2.QtNetwork.QNetworkAccessManager.autoDeleteReplies(self)->bool",
    "PySide2.QtNetwork.QNetworkAccessManager.cache(self)->PySide2.QtNetwork.QAbstractNetworkCache",
    "PySide2.QtNetwork.QNetworkAccessManager.clearAccessCache(self)",
    "PySide2.QtNetwork.QNetworkAccessManager.clearConnectionCache(self)",
    "PySide2.QtNetwork.QNetworkAccessManager.configuration(self)->PySide2.QtNetwork.QNetworkConfiguration",
    "PySide2.QtNetwork.QNetworkAccessManager.connectToHost(self,hostName:QString,port:quint16=80)",
    "1:PySide2.QtNetwork.QNetworkAccessManager.connectToHostEncrypted(self,hostName:QString,port:quint16=443,sslConfiguration:PySide2.QtNetwork.QSslConfiguration=QSslConfiguration.defaultConfiguration())",
    "0:PySide2.QtNetwork.QNetworkAccessManager.connectToHostEncrypted(self,hostName:QString,port:quint16,sslConfiguration:PySide2.QtNetwork.QSslConfiguration,peerName:QString)",
    "PySide2.QtNetwork.QNetworkAccessManager.cookieJar(self)->PySide2.QtNetwork.QNetworkCookieJar",
    "PySide2.QtNetwork.QNetworkAccessManager.createRequest(self,op:PySide2.QtNetwork.QNetworkAccessManager.Operation,request:PySide2.QtNetwork.QNetworkRequest,outgoingData:PySide2.QtCore.QIODevice=nullptr)->PySide2.QtNetwork.QNetworkReply",
    "PySide2.QtNetwork.QNetworkAccessManager.deleteResource(self,request:PySide2.QtNetwork.QNetworkRequest)->PySide2.QtNetwork.QNetworkReply",
    "PySide2.QtNetwork.QNetworkAccessManager.enableStrictTransportSecurityStore(self,enabled:bool,storeDir:QString=QString())",
    "PySide2.QtNetwork.QNetworkAccessManager.get(self,request:PySide2.QtNetwork.QNetworkRequest)->PySide2.QtNetwork.QNetworkReply",
    "PySide2.QtNetwork.QNetworkAccessManager.head(self,request:PySide2.QtNetwork.QNetworkRequest)->PySide2.QtNetwork.QNetworkReply",
    "PySide2.QtNetwork.QNetworkAccessManager.isStrictTransportSecurityEnabled(self)->bool",
    "PySide2.QtNetwork.QNetworkAccessManager.isStrictTransportSecurityStoreEnabled(self)->bool",
    "PySide2.QtNetwork.QNetworkAccessManager.networkAccessible(self)->PySide2.QtNetwork.QNetworkAccessManager.NetworkAccessibility",
    "2:PySide2.QtNetwork.QNetworkAccessManager.post(self,request:PySide2.QtNetwork.QNetworkRequest,multiPart:PySide2.QtNetwork.QHttpMultiPart)->PySide2.QtNetwork.QNetworkReply",
    "1:PySide2.QtNetwork.QNetworkAccessManager.post(self,request:PySide2.QtNetwork.QNetworkRequest,data:PySide2.QtCore.QIODevice)->PySide2.QtNetwork.QNetworkReply",
    "0:PySide2.QtNetwork.QNetworkAccessManager.post(self,request:PySide2.QtNetwork.QNetworkRequest,data:PySide2.QtCore.QByteArray)->PySide2.QtNetwork.QNetworkReply",
    "PySide2.QtNetwork.QNetworkAccessManager.proxy(self)->PySide2.QtNetwork.QNetworkProxy",
    "PySide2.QtNetwork.QNetworkAccessManager.proxyFactory(self)->PySide2.QtNetwork.QNetworkProxyFactory",
    "2:PySide2.QtNetwork.QNetworkAccessManager.put(self,request:PySide2.QtNetwork.QNetworkRequest,multiPart:PySide2.QtNetwork.QHttpMultiPart)->PySide2.QtNetwork.QNetworkReply",
    "1:PySide2.QtNetwork.QNetworkAccessManager.put(self,request:PySide2.QtNetwork.QNetworkRequest,data:PySide2.QtCore.QIODevice)->PySide2.QtNetwork.QNetworkReply",
    "0:PySide2.QtNetwork.QNetworkAccessManager.put(self,request:PySide2.QtNetwork.QNetworkRequest,data:PySide2.QtCore.QByteArray)->PySide2.QtNetwork.QNetworkReply",
    "PySide2.QtNetwork.QNetworkAccessManager.redirectPolicy(self)->PySide2.QtNetwork.QNetworkRequest.RedirectPolicy",
    "2:PySide2.QtNetwork.QNetworkAccessManager.sendCustomRequest(self,request:PySide2.QtNetwork.QNetworkRequest,verb:PySide2.QtCore.QByteArray,multiPart:PySide2.QtNetwork.QHttpMultiPart)->PySide2.QtNetwork.QNetworkReply",
    "1:PySide2.QtNetwork.QNetworkAccessManager.sendCustomRequest(self,request:PySide2.QtNetwork.QNetworkRequest,verb:PySide2.QtCore.QByteArray,data:PySide2.QtCore.QIODevice=nullptr)->PySide2.QtNetwork.QNetworkReply",
    "0:PySide2.QtNetwork.QNetworkAccessManager.sendCustomRequest(self,request:PySide2.QtNetwork.QNetworkRequest,verb:PySide2.QtCore.QByteArray,data:PySide2.QtCore.QByteArray)->PySide2.QtNetwork.QNetworkReply",
    "PySide2.QtNetwork.QNetworkAccessManager.setAutoDeleteReplies(self,autoDelete:bool)",
    "PySide2.QtNetwork.QNetworkAccessManager.setCache(self,cache:PySide2.QtNetwork.QAbstractNetworkCache)",
    "PySide2.QtNetwork.QNetworkAccessManager.setConfiguration(self,config:PySide2.QtNetwork.QNetworkConfiguration)",
    "PySide2.QtNetwork.QNetworkAccessManager.setCookieJar(self,cookieJar:PySide2.QtNetwork.QNetworkCookieJar)",
    "PySide2.QtNetwork.QNetworkAccessManager.setNetworkAccessible(self,accessible:PySide2.QtNetwork.QNetworkAccessManager.NetworkAccessibility)",
    "PySide2.QtNetwork.QNetworkAccessManager.setProxy(self,proxy:PySide2.QtNetwork.QNetworkProxy)",
    "PySide2.QtNetwork.QNetworkAccessManager.setProxyFactory(self,factory:PySide2.QtNetwork.QNetworkProxyFactory)",
    "PySide2.QtNetwork.QNetworkAccessManager.setRedirectPolicy(self,policy:PySide2.QtNetwork.QNetworkRequest.RedirectPolicy)",
    "PySide2.QtNetwork.QNetworkAccessManager.setStrictTransportSecurityEnabled(self,enabled:bool)",
    "PySide2.QtNetwork.QNetworkAccessManager.setTransferTimeout(self,timeout:int=QNetworkRequest.DefaultTransferTimeoutConstant)",
    "PySide2.QtNetwork.QNetworkAccessManager.strictTransportSecurityHosts(self)->QVector[PySide2.QtNetwork.QHstsPolicy]",
    "PySide2.QtNetwork.QNetworkAccessManager.supportedSchemes(self)->QStringList",
    "PySide2.QtNetwork.QNetworkAccessManager.supportedSchemesImplementation(self)->QStringList",
    "PySide2.QtNetwork.QNetworkAccessManager.transferTimeout(self)->int",
    nullptr}; // Sentinel

void init_QNetworkAccessManager(PyObject *module)
{
    _Sbk_QNetworkAccessManager_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QNetworkAccessManager",
        "QNetworkAccessManager*",
        &Sbk_QNetworkAccessManager_spec,
        &Shiboken::callCppDestructor< ::QNetworkAccessManager >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QNetworkAccessManager_Type);
    InitSignatureStrings(pyType, QNetworkAccessManager_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QNetworkAccessManager_Type), Sbk_QNetworkAccessManager_PropertyStrings);
    SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QNetworkAccessManager_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QNetworkAccessManager_TypeF(),
        QNetworkAccessManager_PythonToCpp_QNetworkAccessManager_PTR,
        is_QNetworkAccessManager_PythonToCpp_QNetworkAccessManager_PTR_Convertible,
        QNetworkAccessManager_PTR_CppToPython_QNetworkAccessManager);

    Shiboken::Conversions::registerConverterName(converter, "QNetworkAccessManager");
    Shiboken::Conversions::registerConverterName(converter, "QNetworkAccessManager*");
    Shiboken::Conversions::registerConverterName(converter, "QNetworkAccessManager&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QNetworkAccessManager).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QNetworkAccessManagerWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QNetworkAccessManager_TypeF(), &Sbk_QNetworkAccessManager_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'Operation'.
    SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_OPERATION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QNetworkAccessManager_TypeF(),
        "Operation",
        "2:PySide2.QtNetwork.QNetworkAccessManager.Operation",
        "QNetworkAccessManager::Operation");
    if (!SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_OPERATION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_OPERATION_IDX],
        Sbk_QNetworkAccessManager_TypeF(), "HeadOperation", (long) QNetworkAccessManager::Operation::HeadOperation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_OPERATION_IDX],
        Sbk_QNetworkAccessManager_TypeF(), "GetOperation", (long) QNetworkAccessManager::Operation::GetOperation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_OPERATION_IDX],
        Sbk_QNetworkAccessManager_TypeF(), "PutOperation", (long) QNetworkAccessManager::Operation::PutOperation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_OPERATION_IDX],
        Sbk_QNetworkAccessManager_TypeF(), "PostOperation", (long) QNetworkAccessManager::Operation::PostOperation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_OPERATION_IDX],
        Sbk_QNetworkAccessManager_TypeF(), "DeleteOperation", (long) QNetworkAccessManager::Operation::DeleteOperation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_OPERATION_IDX],
        Sbk_QNetworkAccessManager_TypeF(), "CustomOperation", (long) QNetworkAccessManager::Operation::CustomOperation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_OPERATION_IDX],
        Sbk_QNetworkAccessManager_TypeF(), "UnknownOperation", (long) QNetworkAccessManager::Operation::UnknownOperation))
        return;
    // Register converter for enum 'QNetworkAccessManager::Operation'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_OPERATION_IDX],
            QNetworkAccessManager_Operation_CppToPython_QNetworkAccessManager_Operation);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QNetworkAccessManager_Operation_PythonToCpp_QNetworkAccessManager_Operation,
            is_QNetworkAccessManager_Operation_PythonToCpp_QNetworkAccessManager_Operation_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_OPERATION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QNetworkAccessManager::Operation");
        Shiboken::Conversions::registerConverterName(converter, "Operation");
    }
    // End of 'Operation' enum.

    // Initialization of enum 'NetworkAccessibility'.
    SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_NETWORKACCESSIBILITY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QNetworkAccessManager_TypeF(),
        "NetworkAccessibility",
        "2:PySide2.QtNetwork.QNetworkAccessManager.NetworkAccessibility",
        "QNetworkAccessManager::NetworkAccessibility");
    if (!SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_NETWORKACCESSIBILITY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_NETWORKACCESSIBILITY_IDX],
        Sbk_QNetworkAccessManager_TypeF(), "UnknownAccessibility", (long) QNetworkAccessManager::NetworkAccessibility::UnknownAccessibility))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_NETWORKACCESSIBILITY_IDX],
        Sbk_QNetworkAccessManager_TypeF(), "NotAccessible", (long) QNetworkAccessManager::NetworkAccessibility::NotAccessible))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_NETWORKACCESSIBILITY_IDX],
        Sbk_QNetworkAccessManager_TypeF(), "Accessible", (long) QNetworkAccessManager::NetworkAccessibility::Accessible))
        return;
    // Register converter for enum 'QNetworkAccessManager::NetworkAccessibility'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_NETWORKACCESSIBILITY_IDX],
            QNetworkAccessManager_NetworkAccessibility_CppToPython_QNetworkAccessManager_NetworkAccessibility);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QNetworkAccessManager_NetworkAccessibility_PythonToCpp_QNetworkAccessManager_NetworkAccessibility,
            is_QNetworkAccessManager_NetworkAccessibility_PythonToCpp_QNetworkAccessManager_NetworkAccessibility_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QNETWORKACCESSMANAGER_NETWORKACCESSIBILITY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QNetworkAccessManager::NetworkAccessibility");
        Shiboken::Conversions::registerConverterName(converter, "NetworkAccessibility");
    }
    // End of 'NetworkAccessibility' enum.

    PySide::Signal::registerSignals(Sbk_QNetworkAccessManager_TypeF(), &::QNetworkAccessManager::staticMetaObject);
    qRegisterMetaType< ::QNetworkAccessManager::Operation >("QNetworkAccessManager::Operation");
    qRegisterMetaType< ::QNetworkAccessManager::NetworkAccessibility >("QNetworkAccessManager::NetworkAccessibility");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QNetworkAccessManager_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QNetworkAccessManager_TypeF(), &::QNetworkAccessManager::staticMetaObject, sizeof(QNetworkAccessManagerWrapper));
}
