/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtnetwork_python.h"

// main header
#include "qipv6address_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QIPv6Address_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QIPv6Address >()))
        return -1;

    ::QIPv6Address *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QIPv6Address.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QIPv6Address", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QIPv6Address::QIPv6Address()
    // 1: QIPv6Address::QIPv6Address(QIPv6Address)
    if (numArgs == 0) {
        overloadId = 0; // QIPv6Address()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QIPV6ADDRESS_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QIPv6Address(QIPv6Address)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QIPv6Address_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QIPv6Address()
        {

            if (!PyErr_Occurred()) {
                // QIPv6Address()
                cptr = new ::QIPv6Address();
            }
            break;
        }
        case 1: // QIPv6Address(const QIPv6Address & QIPv6Address)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QIPv6Address cppArg0_local;
            ::QIPv6Address *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QIPV6ADDRESS_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QIPv6Address(QIPv6Address)
                cptr = new ::QIPv6Address(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QIPv6Address >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QIPv6Address_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QIPv6Address_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QIPv6Address___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QIPv6Address *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QIPV6ADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QIPV6ADDRESS_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QIPv6Address_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QIPv6Address_methods[] = {

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QIPv6Address___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

PyObject* Sbk_QIPv6AddressFunc___getitem__(PyObject *self, Py_ssize_t _i)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIPv6Address *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QIPV6ADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    // Begin code injection
    // ========================================================================
    // START of custom code block [file: ../glue/qtnetwork.cpp (qipv6address-getitem)]
    if (_i >= 16) {
        PyErr_SetString(PyExc_IndexError, "index out of bounds");
        return 0;
    }
    if (_i < 0)
        _i = 16 - qAbs(_i);

    uint item = cppSelf->c[_i];
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), &item);
    // END of custom code block [file: ../glue/qtnetwork.cpp (qipv6address-getitem)]
    // ========================================================================

    // End of code injection

}

int Sbk_QIPv6AddressFunc___setitem__(PyObject *self, Py_ssize_t _i, PyObject *_value)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIPv6Address *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QIPV6ADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    // Begin code injection
    // ========================================================================
    // START of custom code block [file: ../glue/qtnetwork.cpp (qipv6address-setitem)]
    if (_i >= 16) {
        PyErr_SetString(PyExc_IndexError, "index out of bounds");
        return -1;
    }
    if (_i < 0)
        _i = 16 - qAbs(_i);
    quint8 item;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<quint8>(), _value, &(item));
    cppSelf->c[_i] = item;
    return 0;
    // END of custom code block [file: ../glue/qtnetwork.cpp (qipv6address-setitem)]
    // ========================================================================

    // End of code injection

}

Py_ssize_t Sbk_QIPv6AddressFunc___len__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QIPv6Address *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QIPV6ADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    // Begin code injection
    // ========================================================================
    // START of custom code block [file: ../glue/qtnetwork.cpp (qipv6address-len)]
    return 16;
    // END of custom code block [file: ../glue/qtnetwork.cpp (qipv6address-len)]
    // ========================================================================

    // End of code injection

}

} // extern "C"

static int Sbk_QIPv6Address_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QIPv6Address_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QIPv6Address_Type = nullptr;
static SbkObjectType *Sbk_QIPv6Address_TypeF(void)
{
    return _Sbk_QIPv6Address_Type;
}

static PyType_Slot Sbk_QIPv6Address_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QIPv6Address_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QIPv6Address_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QIPv6Address_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QIPv6Address_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports sequence protocol
    {Py_sq_item, (void *)&Sbk_QIPv6AddressFunc___getitem__},
    {Py_sq_ass_item, (void *)&Sbk_QIPv6AddressFunc___setitem__},
    {Py_sq_length, (void *)&Sbk_QIPv6AddressFunc___len__},
    {0, nullptr}
};
static PyType_Spec Sbk_QIPv6Address_spec = {
    "2:PySide2.QtNetwork.QIPv6Address",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QIPv6Address_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QIPv6Address_PythonToCpp_QIPv6Address_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QIPv6Address_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QIPv6Address_PythonToCpp_QIPv6Address_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QIPv6Address_TypeF())))
        return QIPv6Address_PythonToCpp_QIPv6Address_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QIPv6Address_PTR_CppToPython_QIPv6Address(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QIPv6Address *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QIPv6Address_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QIPv6Address_COPY_CppToPython_QIPv6Address(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QIPv6Address_TypeF(), new ::QIPv6Address(*reinterpret_cast<const ::QIPv6Address *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QIPv6Address_PythonToCpp_QIPv6Address_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QIPv6Address *>(cppOut) = *reinterpret_cast< ::QIPv6Address *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QIPV6ADDRESS_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QIPv6Address_PythonToCpp_QIPv6Address_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QIPv6Address_TypeF())))
        return QIPv6Address_PythonToCpp_QIPv6Address_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QIPv6Address_SignatureStrings[] = {
    "1:PySide2.QtNetwork.QIPv6Address(self)",
    "0:PySide2.QtNetwork.QIPv6Address(self,QIPv6Address:PySide2.QtNetwork.QIPv6Address)",
    "PySide2.QtNetwork.QIPv6Address.__copy__()",
    nullptr}; // Sentinel

void init_QIPv6Address(PyObject *module)
{
    _Sbk_QIPv6Address_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QIPv6Address",
        "QIPv6Address",
        &Sbk_QIPv6Address_spec,
        &Shiboken::callCppDestructor< ::QIPv6Address >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QIPv6Address_Type);
    InitSignatureStrings(pyType, QIPv6Address_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QIPv6Address_Type), Sbk_QIPv6Address_PropertyStrings);
    SbkPySide2_QtNetworkTypes[SBK_QIPV6ADDRESS_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QIPv6Address_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QIPv6Address_TypeF(),
        QIPv6Address_PythonToCpp_QIPv6Address_PTR,
        is_QIPv6Address_PythonToCpp_QIPv6Address_PTR_Convertible,
        QIPv6Address_PTR_CppToPython_QIPv6Address,
        QIPv6Address_COPY_CppToPython_QIPv6Address);

    Shiboken::Conversions::registerConverterName(converter, "QIPv6Address");
    Shiboken::Conversions::registerConverterName(converter, "QIPv6Address*");
    Shiboken::Conversions::registerConverterName(converter, "QIPv6Address&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QIPv6Address).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QIPv6Address_PythonToCpp_QIPv6Address_COPY,
        is_QIPv6Address_PythonToCpp_QIPv6Address_COPY_Convertible);

    qRegisterMetaType< ::QIPv6Address >("QIPv6Address");
}
