/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtnetwork_python.h"

// main header
#include "qhstspolicy_wrapper.h"

// inner classes

// Extra includes
#include <QtNetwork/qhstspolicy.h>
#include <qdatetime.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QHstsPolicy_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QHstsPolicy >()))
        return -1;

    ::QHstsPolicy *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHstsPolicy.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QHstsPolicy_Init_TypeError;
    } else if (numArgs == 2)
        goto Sbk_QHstsPolicy_Init_TypeError;

    if (!PyArg_ParseTuple(args, "|OOOO:QHstsPolicy", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return -1;


    // Overloaded function decisor
    // 0: QHstsPolicy::QHstsPolicy()
    // 1: QHstsPolicy::QHstsPolicy(QDateTime,QFlags<QHstsPolicy::PolicyFlag>,QString,QUrl::ParsingMode)
    // 2: QHstsPolicy::QHstsPolicy(QHstsPolicy)
    if (numArgs == 0) {
        overloadId = 0; // QHstsPolicy()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHSTSPOLICY_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QHstsPolicy(QHstsPolicy)
    } else if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QHSTSPOLICY_POLICYFLAG_IDX])->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 1; // QHstsPolicy(QDateTime,QFlags<QHstsPolicy::PolicyFlag>,QString,QUrl::ParsingMode)
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QURL_PARSINGMODE_IDX])->converter, (pyArgs[3])))) {
            overloadId = 1; // QHstsPolicy(QDateTime,QFlags<QHstsPolicy::PolicyFlag>,QString,QUrl::ParsingMode)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QHstsPolicy_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QHstsPolicy()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QHstsPolicy_Init_TypeError;
            }

            if (!PyErr_Occurred()) {
                // QHstsPolicy()
                cptr = new ::QHstsPolicy();
            }
            break;
        }
        case 1: // QHstsPolicy(const QDateTime & expiry, QFlags<QHstsPolicy::PolicyFlag> flags, const QString & host, QUrl::ParsingMode mode)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
                if (PyDict_Contains(kwds, key_mode)) {
                    value = PyDict_GetItem(kwds, key_mode);
                    if (value && pyArgs[3]) {
                        errInfo = key_mode;
                        Py_INCREF(errInfo);
                        goto Sbk_QHstsPolicy_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QURL_PARSINGMODE_IDX])->converter, (pyArgs[3]))))
                            goto Sbk_QHstsPolicy_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_mode);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QHstsPolicy_Init_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QDateTime cppArg0_local;
            ::QDateTime *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QFlags<QHstsPolicy::PolicyFlag> cppArg1 = QFlags<QHstsPolicy::PolicyFlag>(0);
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QUrl::ParsingMode cppArg3 = QUrl::DecodedMode;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // QHstsPolicy(QDateTime,QFlags<QHstsPolicy::PolicyFlag>,QString,QUrl::ParsingMode)
                cptr = new ::QHstsPolicy(*cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
        case 2: // QHstsPolicy(const QHstsPolicy & rhs)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QHstsPolicy_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QHstsPolicy cppArg0_local;
            ::QHstsPolicy *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHSTSPOLICY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QHstsPolicy(QHstsPolicy)
                cptr = new ::QHstsPolicy(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QHstsPolicy >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QHstsPolicy_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QHstsPolicy_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QHstsPolicyFunc_expiry(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHstsPolicy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHSTSPOLICY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHstsPolicy.expiry";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // expiry()const
            QDateTime cppResult = const_cast<const ::QHstsPolicy *>(cppSelf)->expiry();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QHstsPolicyFunc_host(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHstsPolicy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHSTSPOLICY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHstsPolicy.host";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QHstsPolicyFunc_host_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:host", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QHstsPolicy::host(QFlags<QUrl::ComponentFormattingOption>)const
    if (numArgs == 0) {
        overloadId = 0; // host(QFlags<QUrl::ComponentFormattingOption>)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // host(QFlags<QUrl::ComponentFormattingOption>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QHstsPolicyFunc_host_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_options = Shiboken::String::createStaticString("options");
            if (PyDict_Contains(kwds, key_options)) {
                value = PyDict_GetItem(kwds, key_options);
                if (value && pyArgs[0]) {
                    errInfo = key_options;
                    Py_INCREF(errInfo);
                    goto Sbk_QHstsPolicyFunc_host_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QURL_COMPONENTFORMATTINGOPTION_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QHstsPolicyFunc_host_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_options);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QHstsPolicyFunc_host_TypeError;
            }
        }
        ::QFlags<QUrl::ComponentFormattingOption> cppArg0 = QUrl::FullyDecoded;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // host(QFlags<QUrl::ComponentFormattingOption>)const
            QString cppResult = const_cast<const ::QHstsPolicy *>(cppSelf)->host(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QHstsPolicyFunc_host_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QHstsPolicyFunc_includesSubDomains(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHstsPolicy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHSTSPOLICY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHstsPolicy.includesSubDomains";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // includesSubDomains()const
            bool cppResult = const_cast<const ::QHstsPolicy *>(cppSelf)->includesSubDomains();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QHstsPolicyFunc_isExpired(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHstsPolicy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHSTSPOLICY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHstsPolicy.isExpired";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isExpired()const
            bool cppResult = const_cast<const ::QHstsPolicy *>(cppSelf)->isExpired();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QHstsPolicyFunc_setExpiry(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHstsPolicy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHSTSPOLICY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHstsPolicy.setExpiry";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QHstsPolicy::setExpiry(QDateTime)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), (pyArg)))) {
        overloadId = 0; // setExpiry(QDateTime)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QHstsPolicyFunc_setExpiry_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QDateTime cppArg0_local;
        ::QDateTime *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATETIME_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setExpiry(QDateTime)
            cppSelf->setExpiry(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QHstsPolicyFunc_setExpiry_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QHstsPolicyFunc_setHost(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHstsPolicy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHSTSPOLICY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHstsPolicy.setHost";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QHstsPolicyFunc_setHost_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QHstsPolicyFunc_setHost_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setHost", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QHstsPolicy::setHost(QString,QUrl::ParsingMode)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setHost(QString,QUrl::ParsingMode)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QURL_PARSINGMODE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // setHost(QString,QUrl::ParsingMode)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QHstsPolicyFunc_setHost_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
            if (PyDict_Contains(kwds, key_mode)) {
                value = PyDict_GetItem(kwds, key_mode);
                if (value && pyArgs[1]) {
                    errInfo = key_mode;
                    Py_INCREF(errInfo);
                    goto Sbk_QHstsPolicyFunc_setHost_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QURL_PARSINGMODE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QHstsPolicyFunc_setHost_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QHstsPolicyFunc_setHost_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QUrl::ParsingMode cppArg1 = QUrl::DecodedMode;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setHost(QString,QUrl::ParsingMode)
            cppSelf->setHost(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QHstsPolicyFunc_setHost_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QHstsPolicyFunc_setIncludesSubDomains(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHstsPolicy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHSTSPOLICY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHstsPolicy.setIncludesSubDomains";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QHstsPolicy::setIncludesSubDomains(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setIncludesSubDomains(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QHstsPolicyFunc_setIncludesSubDomains_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setIncludesSubDomains(bool)
            cppSelf->setIncludesSubDomains(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QHstsPolicyFunc_setIncludesSubDomains_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QHstsPolicyFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHstsPolicy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHSTSPOLICY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHstsPolicy.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QHstsPolicy::swap(QHstsPolicy&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHSTSPOLICY_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QHstsPolicy&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QHstsPolicyFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QHstsPolicy cppArg0_local;
        ::QHstsPolicy *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHSTSPOLICY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QHstsPolicy&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QHstsPolicyFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QHstsPolicy___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QHstsPolicy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHSTSPOLICY_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHSTSPOLICY_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QHstsPolicy_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QHstsPolicy_methods[] = {
    {"expiry", reinterpret_cast<PyCFunction>(Sbk_QHstsPolicyFunc_expiry), METH_NOARGS},
    {"host", reinterpret_cast<PyCFunction>(Sbk_QHstsPolicyFunc_host), METH_VARARGS|METH_KEYWORDS},
    {"includesSubDomains", reinterpret_cast<PyCFunction>(Sbk_QHstsPolicyFunc_includesSubDomains), METH_NOARGS},
    {"isExpired", reinterpret_cast<PyCFunction>(Sbk_QHstsPolicyFunc_isExpired), METH_NOARGS},
    {"setExpiry", reinterpret_cast<PyCFunction>(Sbk_QHstsPolicyFunc_setExpiry), METH_O},
    {"setHost", reinterpret_cast<PyCFunction>(Sbk_QHstsPolicyFunc_setHost), METH_VARARGS|METH_KEYWORDS},
    {"setIncludesSubDomains", reinterpret_cast<PyCFunction>(Sbk_QHstsPolicyFunc_setIncludesSubDomains), METH_O},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QHstsPolicyFunc_swap), METH_O},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QHstsPolicy___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QHstsPolicy_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QHstsPolicy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHSTSPOLICY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHSTSPOLICY_IDX]), (pyArg)))) {
                // operator!=(const QHstsPolicy & rhs)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QHstsPolicy cppArg0_local;
                ::QHstsPolicy *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHSTSPOLICY_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHSTSPOLICY_IDX]), (pyArg)))) {
                // operator==(const QHstsPolicy & rhs)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QHstsPolicy cppArg0_local;
                ::QHstsPolicy *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHSTSPOLICY_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QHstsPolicy_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QHstsPolicy_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QHstsPolicy_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QHstsPolicy_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QHstsPolicy_Type = nullptr;
static SbkObjectType *Sbk_QHstsPolicy_TypeF(void)
{
    return _Sbk_QHstsPolicy_Type;
}

static PyType_Slot Sbk_QHstsPolicy_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QHstsPolicy_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QHstsPolicy_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QHstsPolicy_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QHstsPolicy_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QHstsPolicy_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QHstsPolicy_spec = {
    "2:PySide2.QtNetwork.QHstsPolicy",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QHstsPolicy_slots
};

} //extern "C"

PyObject *SbkPySide2_QtNetwork_QHstsPolicy_PolicyFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::QHstsPolicy::PolicyFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QHstsPolicy::PolicyFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QHstsPolicy::PolicyFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QHstsPolicy::PolicyFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QHstsPolicy::PolicyFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QHSTSPOLICY_POLICYFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtNetwork_QHstsPolicy_PolicyFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::QHstsPolicy::PolicyFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QHstsPolicy::PolicyFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QHstsPolicy::PolicyFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QHstsPolicy::PolicyFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QHstsPolicy::PolicyFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QHSTSPOLICY_POLICYFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtNetwork_QHstsPolicy_PolicyFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QHstsPolicy::PolicyFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QHstsPolicy::PolicyFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QHstsPolicy::PolicyFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QHstsPolicy::PolicyFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QHstsPolicy::PolicyFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QHSTSPOLICY_POLICYFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtNetwork_QHstsPolicy_PolicyFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QHstsPolicy::PolicyFlags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QHSTSPOLICY_POLICYFLAG_IDX])->converter, self, &cppSelf);
    ::QHstsPolicy::PolicyFlags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QHSTSPOLICY_POLICYFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtNetwork_QHstsPolicy_PolicyFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QHSTSPOLICY_POLICYFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtNetwork_QHstsPolicy_PolicyFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QHSTSPOLICY_POLICYFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtNetwork_QHstsPolicy_PolicyFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtNetwork_QHstsPolicy_PolicyFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtNetwork_QHstsPolicy_PolicyFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtNetwork_QHstsPolicy_PolicyFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtNetwork_QHstsPolicy_PolicyFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtNetwork_QHstsPolicy_PolicyFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtNetwork_QHstsPolicy_PolicyFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtNetwork_QHstsPolicy_PolicyFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtNetwork_QHstsPolicy_PolicyFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtNetwork_QHstsPolicy_PolicyFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtNetwork_QHstsPolicy_PolicyFlag_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QHstsPolicy_PolicyFlag_PythonToCpp_QHstsPolicy_PolicyFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QHstsPolicy::PolicyFlag *>(cppOut) =
        static_cast<::QHstsPolicy::PolicyFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QHstsPolicy_PolicyFlag_PythonToCpp_QHstsPolicy_PolicyFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QHSTSPOLICY_POLICYFLAG_IDX]))
        return QHstsPolicy_PolicyFlag_PythonToCpp_QHstsPolicy_PolicyFlag;
    return {};
}
static PyObject *QHstsPolicy_PolicyFlag_CppToPython_QHstsPolicy_PolicyFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QHstsPolicy::PolicyFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QHSTSPOLICY_POLICYFLAG_IDX], castCppIn);

}

static void QFlags_QHstsPolicy_PolicyFlag__PythonToCpp_QFlags_QHstsPolicy_PolicyFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QHstsPolicy::PolicyFlag> *>(cppOut) =
        ::QFlags<QHstsPolicy::PolicyFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QHstsPolicy_PolicyFlag__PythonToCpp_QFlags_QHstsPolicy_PolicyFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QHSTSPOLICY_POLICYFLAG_IDX]))
        return QFlags_QHstsPolicy_PolicyFlag__PythonToCpp_QFlags_QHstsPolicy_PolicyFlag_;
    return {};
}
static PyObject *QFlags_QHstsPolicy_PolicyFlag__CppToPython_QFlags_QHstsPolicy_PolicyFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QHstsPolicy::PolicyFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QHSTSPOLICY_POLICYFLAG_IDX]));

}

static void QHstsPolicy_PolicyFlag_PythonToCpp_QFlags_QHstsPolicy_PolicyFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QHstsPolicy::PolicyFlag> *>(cppOut) =
        ::QFlags<QHstsPolicy::PolicyFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QHstsPolicy_PolicyFlag_PythonToCpp_QFlags_QHstsPolicy_PolicyFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QHSTSPOLICY_POLICYFLAG_IDX]))
        return QHstsPolicy_PolicyFlag_PythonToCpp_QFlags_QHstsPolicy_PolicyFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_QHstsPolicy_PolicyFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QHstsPolicy::PolicyFlag> *>(cppOut) =
        ::QFlags<QHstsPolicy::PolicyFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QHstsPolicy_PolicyFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QHSTSPOLICY_POLICYFLAG_IDX]))
        return number_PythonToCpp_QFlags_QHstsPolicy_PolicyFlag_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QHstsPolicy_PythonToCpp_QHstsPolicy_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QHstsPolicy_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QHstsPolicy_PythonToCpp_QHstsPolicy_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QHstsPolicy_TypeF())))
        return QHstsPolicy_PythonToCpp_QHstsPolicy_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QHstsPolicy_PTR_CppToPython_QHstsPolicy(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QHstsPolicy *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QHstsPolicy_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QHstsPolicy_COPY_CppToPython_QHstsPolicy(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QHstsPolicy_TypeF(), new ::QHstsPolicy(*reinterpret_cast<const ::QHstsPolicy *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QHstsPolicy_PythonToCpp_QHstsPolicy_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QHstsPolicy *>(cppOut) = *reinterpret_cast< ::QHstsPolicy *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHSTSPOLICY_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QHstsPolicy_PythonToCpp_QHstsPolicy_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QHstsPolicy_TypeF())))
        return QHstsPolicy_PythonToCpp_QHstsPolicy_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QHstsPolicy_SignatureStrings[] = {
    "2:PySide2.QtNetwork.QHstsPolicy(self)",
    "1:PySide2.QtNetwork.QHstsPolicy(self,expiry:PySide2.QtCore.QDateTime,flags:PySide2.QtNetwork.QHstsPolicy.PolicyFlags,host:QString,mode:PySide2.QtCore.QUrl.ParsingMode=QUrl.DecodedMode)",
    "0:PySide2.QtNetwork.QHstsPolicy(self,rhs:PySide2.QtNetwork.QHstsPolicy)",
    "PySide2.QtNetwork.QHstsPolicy.expiry(self)->PySide2.QtCore.QDateTime",
    "PySide2.QtNetwork.QHstsPolicy.host(self,options:PySide2.QtCore.QUrl.ComponentFormattingOptions=QUrl.FullyDecoded)->QString",
    "PySide2.QtNetwork.QHstsPolicy.includesSubDomains(self)->bool",
    "PySide2.QtNetwork.QHstsPolicy.isExpired(self)->bool",
    "PySide2.QtNetwork.QHstsPolicy.setExpiry(self,expiry:PySide2.QtCore.QDateTime)",
    "PySide2.QtNetwork.QHstsPolicy.setHost(self,host:QString,mode:PySide2.QtCore.QUrl.ParsingMode=QUrl.DecodedMode)",
    "PySide2.QtNetwork.QHstsPolicy.setIncludesSubDomains(self,include:bool)",
    "PySide2.QtNetwork.QHstsPolicy.swap(self,other:PySide2.QtNetwork.QHstsPolicy)",
    "PySide2.QtNetwork.QHstsPolicy.__copy__()",
    nullptr}; // Sentinel

void init_QHstsPolicy(PyObject *module)
{
    _Sbk_QHstsPolicy_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QHstsPolicy",
        "QHstsPolicy",
        &Sbk_QHstsPolicy_spec,
        &Shiboken::callCppDestructor< ::QHstsPolicy >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QHstsPolicy_Type);
    InitSignatureStrings(pyType, QHstsPolicy_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QHstsPolicy_Type), Sbk_QHstsPolicy_PropertyStrings);
    SbkPySide2_QtNetworkTypes[SBK_QHSTSPOLICY_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QHstsPolicy_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QHstsPolicy_TypeF(),
        QHstsPolicy_PythonToCpp_QHstsPolicy_PTR,
        is_QHstsPolicy_PythonToCpp_QHstsPolicy_PTR_Convertible,
        QHstsPolicy_PTR_CppToPython_QHstsPolicy,
        QHstsPolicy_COPY_CppToPython_QHstsPolicy);

    Shiboken::Conversions::registerConverterName(converter, "QHstsPolicy");
    Shiboken::Conversions::registerConverterName(converter, "QHstsPolicy*");
    Shiboken::Conversions::registerConverterName(converter, "QHstsPolicy&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QHstsPolicy).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QHstsPolicy_PythonToCpp_QHstsPolicy_COPY,
        is_QHstsPolicy_PythonToCpp_QHstsPolicy_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'PolicyFlag'.
    SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QHSTSPOLICY_POLICYFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtNetwork.QHstsPolicy.PolicyFlags", SbkPySide2_QtNetwork_QHstsPolicy_PolicyFlag_number_slots);
    SbkPySide2_QtNetworkTypes[SBK_QHSTSPOLICY_POLICYFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QHstsPolicy_TypeF(),
        "PolicyFlag",
        "2:PySide2.QtNetwork.QHstsPolicy.PolicyFlag",
        "QHstsPolicy::PolicyFlag",
        SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QHSTSPOLICY_POLICYFLAG_IDX]);
    if (!SbkPySide2_QtNetworkTypes[SBK_QHSTSPOLICY_POLICYFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QHSTSPOLICY_POLICYFLAG_IDX],
        Sbk_QHstsPolicy_TypeF(), "IncludeSubDomains", (long) QHstsPolicy::PolicyFlag::IncludeSubDomains))
        return;
    // Register converter for enum 'QHstsPolicy::PolicyFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QHSTSPOLICY_POLICYFLAG_IDX],
            QHstsPolicy_PolicyFlag_CppToPython_QHstsPolicy_PolicyFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QHstsPolicy_PolicyFlag_PythonToCpp_QHstsPolicy_PolicyFlag,
            is_QHstsPolicy_PolicyFlag_PythonToCpp_QHstsPolicy_PolicyFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QHSTSPOLICY_POLICYFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QHstsPolicy::PolicyFlag");
        Shiboken::Conversions::registerConverterName(converter, "PolicyFlag");
    }
    // Register converter for flag 'QFlags<QHstsPolicy::PolicyFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QHSTSPOLICY_POLICYFLAG_IDX],
            QFlags_QHstsPolicy_PolicyFlag__CppToPython_QFlags_QHstsPolicy_PolicyFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QHstsPolicy_PolicyFlag_PythonToCpp_QFlags_QHstsPolicy_PolicyFlag_,
            is_QHstsPolicy_PolicyFlag_PythonToCpp_QFlags_QHstsPolicy_PolicyFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QHstsPolicy_PolicyFlag__PythonToCpp_QFlags_QHstsPolicy_PolicyFlag_,
            is_QFlags_QHstsPolicy_PolicyFlag__PythonToCpp_QFlags_QHstsPolicy_PolicyFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QHstsPolicy_PolicyFlag_,
            is_number_PythonToCpp_QFlags_QHstsPolicy_PolicyFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QHSTSPOLICY_POLICYFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QHstsPolicy::PolicyFlags");
        Shiboken::Conversions::registerConverterName(converter, "PolicyFlags");
    }
    // End of 'PolicyFlag' enum/flags.

    qRegisterMetaType< ::QHstsPolicy >("QHstsPolicy");
    qRegisterMetaType< ::QHstsPolicy::PolicyFlag >("QHstsPolicy::PolicyFlag");
    qRegisterMetaType< ::QHstsPolicy::PolicyFlags >("QHstsPolicy::PolicyFlags");
}
