/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtnetwork_python.h"

// main header
#include "qhostinfo_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <QtNetwork/qhostaddress.h>
#include <QtNetwork/qhostinfo.h>
#include <qobject.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QHostInfo_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QHostInfo >()))
        return -1;

    ::QHostInfo *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHostInfo.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QHostInfo_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:QHostInfo", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QHostInfo::QHostInfo(QHostInfo)
    // 1: QHostInfo::QHostInfo(int)
    if (numArgs == 0) {
        overloadId = 1; // QHostInfo(int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 1; // QHostInfo(int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTINFO_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QHostInfo(QHostInfo)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QHostInfo_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QHostInfo(const QHostInfo & d)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QHostInfo_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QHostInfo cppArg0_local;
            ::QHostInfo *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTINFO_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QHostInfo(QHostInfo)
                cptr = new ::QHostInfo(*cppArg0);
            }
            break;
        }
        case 1: // QHostInfo(int lookupId)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_lookupId = Shiboken::String::createStaticString("lookupId");
                if (PyDict_Contains(kwds, key_lookupId)) {
                    value = PyDict_GetItem(kwds, key_lookupId);
                    if (value && pyArgs[0]) {
                        errInfo = key_lookupId;
                        Py_INCREF(errInfo);
                        goto Sbk_QHostInfo_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                            goto Sbk_QHostInfo_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_lookupId);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QHostInfo_Init_TypeError;
                }
            }
            int cppArg0 = -1;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QHostInfo(int)
                cptr = new ::QHostInfo(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QHostInfo >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QHostInfo_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QHostInfo_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QHostInfoFunc_abortHostLookup(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHostInfo.abortHostLookup";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QHostInfo::abortHostLookup(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // abortHostLookup(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QHostInfoFunc_abortHostLookup_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // abortHostLookup(int)
            ::QHostInfo::abortHostLookup(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QHostInfoFunc_abortHostLookup_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QHostInfoFunc_addresses(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHostInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHOSTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHostInfo.addresses";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // addresses()const
            QList<QHostAddress > cppResult = const_cast<const ::QHostInfo *>(cppSelf)->addresses();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QHOSTADDRESS_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QHostInfoFunc_error(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHostInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHOSTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHostInfo.error";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // error()const
            QHostInfo::HostInfoError cppResult = const_cast<const ::QHostInfo *>(cppSelf)->error();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QHOSTINFO_HOSTINFOERROR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QHostInfoFunc_errorString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHostInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHOSTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHostInfo.errorString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // errorString()const
            QString cppResult = const_cast<const ::QHostInfo *>(cppSelf)->errorString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QHostInfoFunc_fromName(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHostInfo.fromName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QHostInfo::fromName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // fromName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QHostInfoFunc_fromName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // fromName(QString)
            QHostInfo cppResult = ::QHostInfo::fromName(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTINFO_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QHostInfoFunc_fromName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QHostInfoFunc_hostName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHostInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHOSTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHostInfo.hostName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hostName()const
            QString cppResult = const_cast<const ::QHostInfo *>(cppSelf)->hostName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QHostInfoFunc_localDomainName(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHostInfo.localDomainName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // localDomainName()
            QString cppResult = ::QHostInfo::localDomainName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QHostInfoFunc_localHostName(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHostInfo.localHostName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // localHostName()
            QString cppResult = ::QHostInfo::localHostName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QHostInfoFunc_lookupId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHostInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHOSTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHostInfo.lookupId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lookupId()const
            int cppResult = const_cast<const ::QHostInfo *>(cppSelf)->lookupId();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QHostInfoFunc_setAddresses(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHostInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHOSTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHostInfo.setAddresses";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QHostInfo::setAddresses(QList<QHostAddress>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QHOSTADDRESS_IDX], (pyArg)))) {
        overloadId = 0; // setAddresses(QList<QHostAddress>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QHostInfoFunc_setAddresses_TypeError;

    // Call function/method
    {
        ::QList<QHostAddress > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAddresses(QList<QHostAddress>)
            cppSelf->setAddresses(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QHostInfoFunc_setAddresses_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QHostInfoFunc_setError(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHostInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHOSTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHostInfo.setError";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QHostInfo::setError(QHostInfo::HostInfoError)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QHOSTINFO_HOSTINFOERROR_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setError(QHostInfo::HostInfoError)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QHostInfoFunc_setError_TypeError;

    // Call function/method
    {
        ::QHostInfo::HostInfoError cppArg0{QHostInfo::NoError};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setError(QHostInfo::HostInfoError)
            cppSelf->setError(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QHostInfoFunc_setError_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QHostInfoFunc_setErrorString(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHostInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHOSTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHostInfo.setErrorString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QHostInfo::setErrorString(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setErrorString(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QHostInfoFunc_setErrorString_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setErrorString(QString)
            cppSelf->setErrorString(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QHostInfoFunc_setErrorString_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QHostInfoFunc_setHostName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHostInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHOSTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHostInfo.setHostName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QHostInfo::setHostName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setHostName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QHostInfoFunc_setHostName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setHostName(QString)
            cppSelf->setHostName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QHostInfoFunc_setHostName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QHostInfoFunc_setLookupId(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHostInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHOSTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHostInfo.setLookupId";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QHostInfo::setLookupId(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setLookupId(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QHostInfoFunc_setLookupId_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLookupId(int)
            cppSelf->setLookupId(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QHostInfoFunc_setLookupId_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QHostInfoFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHostInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHOSTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHostInfo.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QHostInfo::swap(QHostInfo&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTINFO_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QHostInfo&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QHostInfoFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QHostInfo cppArg0_local;
        ::QHostInfo *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTINFO_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QHostInfo&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QHostInfoFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QHostInfo___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QHostInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHOSTINFO_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTINFO_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QHostInfo_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QHostInfo_methods[] = {
    {"abortHostLookup", reinterpret_cast<PyCFunction>(Sbk_QHostInfoFunc_abortHostLookup), METH_O|METH_STATIC},
    {"addresses", reinterpret_cast<PyCFunction>(Sbk_QHostInfoFunc_addresses), METH_NOARGS},
    {"error", reinterpret_cast<PyCFunction>(Sbk_QHostInfoFunc_error), METH_NOARGS},
    {"errorString", reinterpret_cast<PyCFunction>(Sbk_QHostInfoFunc_errorString), METH_NOARGS},
    {"fromName", reinterpret_cast<PyCFunction>(Sbk_QHostInfoFunc_fromName), METH_O|METH_STATIC},
    {"hostName", reinterpret_cast<PyCFunction>(Sbk_QHostInfoFunc_hostName), METH_NOARGS},
    {"localDomainName", reinterpret_cast<PyCFunction>(Sbk_QHostInfoFunc_localDomainName), METH_NOARGS|METH_STATIC},
    {"localHostName", reinterpret_cast<PyCFunction>(Sbk_QHostInfoFunc_localHostName), METH_NOARGS|METH_STATIC},
    {"lookupId", reinterpret_cast<PyCFunction>(Sbk_QHostInfoFunc_lookupId), METH_NOARGS},
    {"setAddresses", reinterpret_cast<PyCFunction>(Sbk_QHostInfoFunc_setAddresses), METH_O},
    {"setError", reinterpret_cast<PyCFunction>(Sbk_QHostInfoFunc_setError), METH_O},
    {"setErrorString", reinterpret_cast<PyCFunction>(Sbk_QHostInfoFunc_setErrorString), METH_O},
    {"setHostName", reinterpret_cast<PyCFunction>(Sbk_QHostInfoFunc_setHostName), METH_O},
    {"setLookupId", reinterpret_cast<PyCFunction>(Sbk_QHostInfoFunc_setLookupId), METH_O},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QHostInfoFunc_swap), METH_O},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QHostInfo___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QHostInfo_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QHostInfo_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QHostInfo_Type = nullptr;
static SbkObjectType *Sbk_QHostInfo_TypeF(void)
{
    return _Sbk_QHostInfo_Type;
}

static PyType_Slot Sbk_QHostInfo_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QHostInfo_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QHostInfo_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QHostInfo_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QHostInfo_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QHostInfo_spec = {
    "2:PySide2.QtNetwork.QHostInfo",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QHostInfo_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QHostInfo_HostInfoError_PythonToCpp_QHostInfo_HostInfoError(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QHostInfo::HostInfoError *>(cppOut) =
        static_cast<::QHostInfo::HostInfoError>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QHostInfo_HostInfoError_PythonToCpp_QHostInfo_HostInfoError_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QHOSTINFO_HOSTINFOERROR_IDX]))
        return QHostInfo_HostInfoError_PythonToCpp_QHostInfo_HostInfoError;
    return {};
}
static PyObject *QHostInfo_HostInfoError_CppToPython_QHostInfo_HostInfoError(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QHostInfo::HostInfoError *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QHOSTINFO_HOSTINFOERROR_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QHostInfo_PythonToCpp_QHostInfo_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QHostInfo_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QHostInfo_PythonToCpp_QHostInfo_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QHostInfo_TypeF())))
        return QHostInfo_PythonToCpp_QHostInfo_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QHostInfo_PTR_CppToPython_QHostInfo(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QHostInfo *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QHostInfo_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QHostInfo_COPY_CppToPython_QHostInfo(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QHostInfo_TypeF(), new ::QHostInfo(*reinterpret_cast<const ::QHostInfo *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QHostInfo_PythonToCpp_QHostInfo_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QHostInfo *>(cppOut) = *reinterpret_cast< ::QHostInfo *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHOSTINFO_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QHostInfo_PythonToCpp_QHostInfo_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QHostInfo_TypeF())))
        return QHostInfo_PythonToCpp_QHostInfo_COPY;
    return {};
}

// Implicit conversions.
static void PySide2_QtCore_int_PythonToCpp_QHostInfo(PyObject *pyIn, void *cppOut) {
    int cppIn;
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyIn, &cppIn);
    *reinterpret_cast<::QHostInfo *>(cppOut) = ::QHostInfo(cppIn);
}
static PythonToCppFunc is_PySide2_QtCore_int_PythonToCpp_QHostInfo_Convertible(PyObject *pyIn) {
    if (PyInt_Check(pyIn))
        return PySide2_QtCore_int_PythonToCpp_QHostInfo;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QHostInfo_SignatureStrings[] = {
    "1:PySide2.QtNetwork.QHostInfo(self,d:PySide2.QtNetwork.QHostInfo)",
    "0:PySide2.QtNetwork.QHostInfo(self,lookupId:int=-1)",
    "PySide2.QtNetwork.QHostInfo.abortHostLookup(lookupId:int)",
    "PySide2.QtNetwork.QHostInfo.addresses(self)->QList[PySide2.QtNetwork.QHostAddress]",
    "PySide2.QtNetwork.QHostInfo.error(self)->PySide2.QtNetwork.QHostInfo.HostInfoError",
    "PySide2.QtNetwork.QHostInfo.errorString(self)->QString",
    "PySide2.QtNetwork.QHostInfo.fromName(name:QString)->PySide2.QtNetwork.QHostInfo",
    "PySide2.QtNetwork.QHostInfo.hostName(self)->QString",
    "PySide2.QtNetwork.QHostInfo.localDomainName()->QString",
    "PySide2.QtNetwork.QHostInfo.localHostName()->QString",
    "PySide2.QtNetwork.QHostInfo.lookupId(self)->int",
    "PySide2.QtNetwork.QHostInfo.setAddresses(self,addresses:QList[PySide2.QtNetwork.QHostAddress])",
    "PySide2.QtNetwork.QHostInfo.setError(self,error:PySide2.QtNetwork.QHostInfo.HostInfoError)",
    "PySide2.QtNetwork.QHostInfo.setErrorString(self,errorString:QString)",
    "PySide2.QtNetwork.QHostInfo.setHostName(self,name:QString)",
    "PySide2.QtNetwork.QHostInfo.setLookupId(self,id:int)",
    "PySide2.QtNetwork.QHostInfo.swap(self,other:PySide2.QtNetwork.QHostInfo)",
    "PySide2.QtNetwork.QHostInfo.__copy__()",
    nullptr}; // Sentinel

void init_QHostInfo(PyObject *module)
{
    _Sbk_QHostInfo_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QHostInfo",
        "QHostInfo",
        &Sbk_QHostInfo_spec,
        &Shiboken::callCppDestructor< ::QHostInfo >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QHostInfo_Type);
    InitSignatureStrings(pyType, QHostInfo_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QHostInfo_Type), Sbk_QHostInfo_PropertyStrings);
    SbkPySide2_QtNetworkTypes[SBK_QHOSTINFO_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QHostInfo_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QHostInfo_TypeF(),
        QHostInfo_PythonToCpp_QHostInfo_PTR,
        is_QHostInfo_PythonToCpp_QHostInfo_PTR_Convertible,
        QHostInfo_PTR_CppToPython_QHostInfo,
        QHostInfo_COPY_CppToPython_QHostInfo);

    Shiboken::Conversions::registerConverterName(converter, "QHostInfo");
    Shiboken::Conversions::registerConverterName(converter, "QHostInfo*");
    Shiboken::Conversions::registerConverterName(converter, "QHostInfo&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QHostInfo).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QHostInfo_PythonToCpp_QHostInfo_COPY,
        is_QHostInfo_PythonToCpp_QHostInfo_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtCore_int_PythonToCpp_QHostInfo,
        is_PySide2_QtCore_int_PythonToCpp_QHostInfo_Convertible);

    // Initialization of enums.

    // Initialization of enum 'HostInfoError'.
    SbkPySide2_QtNetworkTypes[SBK_QHOSTINFO_HOSTINFOERROR_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QHostInfo_TypeF(),
        "HostInfoError",
        "2:PySide2.QtNetwork.QHostInfo.HostInfoError",
        "QHostInfo::HostInfoError");
    if (!SbkPySide2_QtNetworkTypes[SBK_QHOSTINFO_HOSTINFOERROR_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QHOSTINFO_HOSTINFOERROR_IDX],
        Sbk_QHostInfo_TypeF(), "NoError", (long) QHostInfo::HostInfoError::NoError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QHOSTINFO_HOSTINFOERROR_IDX],
        Sbk_QHostInfo_TypeF(), "HostNotFound", (long) QHostInfo::HostInfoError::HostNotFound))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QHOSTINFO_HOSTINFOERROR_IDX],
        Sbk_QHostInfo_TypeF(), "UnknownError", (long) QHostInfo::HostInfoError::UnknownError))
        return;
    // Register converter for enum 'QHostInfo::HostInfoError'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QHOSTINFO_HOSTINFOERROR_IDX],
            QHostInfo_HostInfoError_CppToPython_QHostInfo_HostInfoError);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QHostInfo_HostInfoError_PythonToCpp_QHostInfo_HostInfoError,
            is_QHostInfo_HostInfoError_PythonToCpp_QHostInfo_HostInfoError_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QHOSTINFO_HOSTINFOERROR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QHostInfo::HostInfoError");
        Shiboken::Conversions::registerConverterName(converter, "HostInfoError");
    }
    // End of 'HostInfoError' enum.

    qRegisterMetaType< ::QHostInfo::HostInfoError >("QHostInfo::HostInfoError");
}
