/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtnetwork_python.h"

// main header
#include "qhostaddress_wrapper.h"

// inner classes

// Extra includes
#include <QPair>
#include <QtNetwork/qhostaddress.h>
#include <qdatastream.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QHostAddress_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QHostAddress >()))
        return -1;

    ::QHostAddress *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHostAddress.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QHostAddress", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QHostAddress::QHostAddress()
    // 1: QHostAddress::QHostAddress(QHostAddress::SpecialAddress)
    // 2: QHostAddress::QHostAddress(QHostAddress)
    // 3: QHostAddress::QHostAddress(QIPv6Address)
    // 4: QHostAddress::QHostAddress(QString)
    // 5: QHostAddress::QHostAddress(quint32)
    if (numArgs == 0) {
        overloadId = 0; // QHostAddress()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 4; // QHostAddress(QString)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QIPV6ADDRESS_IDX]), (pyArgs[0])))) {
        overloadId = 3; // QHostAddress(QIPv6Address)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_SPECIALADDRESS_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // QHostAddress(QHostAddress::SpecialAddress)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), (pyArgs[0])))) {
        overloadId = 5; // QHostAddress(quint32)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QHostAddress(QHostAddress)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QHostAddress_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QHostAddress()
        {

            if (!PyErr_Occurred()) {
                // QHostAddress()
                cptr = new ::QHostAddress();
            }
            break;
        }
        case 1: // QHostAddress(QHostAddress::SpecialAddress address)
        {
            ::QHostAddress::SpecialAddress cppArg0{QHostAddress::Null};
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QHostAddress(QHostAddress::SpecialAddress)
                cptr = new ::QHostAddress(cppArg0);
            }
            break;
        }
        case 2: // QHostAddress(const QHostAddress & copy)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QHostAddress cppArg0_local;
            ::QHostAddress *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QHostAddress(QHostAddress)
                cptr = new ::QHostAddress(*cppArg0);
            }
            break;
        }
        case 3: // QHostAddress(const QIPv6Address & ip6Addr)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QIPv6Address cppArg0_local;
            ::QIPv6Address *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QIPV6ADDRESS_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QHostAddress(QIPv6Address)
                cptr = new ::QHostAddress(*cppArg0);
            }
            break;
        }
        case 4: // QHostAddress(const QString & address)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QHostAddress(QString)
                cptr = new ::QHostAddress(cppArg0);
            }
            break;
        }
        case 5: // QHostAddress(quint32 ip4Addr)
        {
            quint32 cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QHostAddress(quint32)
                cptr = new ::QHostAddress(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QHostAddress >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QHostAddress_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QHostAddress_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QHostAddressFunc_clear(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHostAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHostAddress.clear";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clear()
            cppSelf->clear();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QHostAddressFunc_isBroadcast(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHostAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHostAddress.isBroadcast";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isBroadcast()const
            bool cppResult = const_cast<const ::QHostAddress *>(cppSelf)->isBroadcast();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QHostAddressFunc_isEqual(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHostAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHostAddress.isEqual";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QHostAddressFunc_isEqual_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QHostAddressFunc_isEqual_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:isEqual", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QHostAddress::isEqual(QHostAddress,QFlags<QHostAddress::ConversionModeFlag>)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // isEqual(QHostAddress,QFlags<QHostAddress::ConversionModeFlag>)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QHOSTADDRESS_CONVERSIONMODEFLAG_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // isEqual(QHostAddress,QFlags<QHostAddress::ConversionModeFlag>)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QHostAddressFunc_isEqual_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_mode = Shiboken::String::createStaticString("mode");
            if (PyDict_Contains(kwds, key_mode)) {
                value = PyDict_GetItem(kwds, key_mode);
                if (value && pyArgs[1]) {
                    errInfo = key_mode;
                    Py_INCREF(errInfo);
                    goto Sbk_QHostAddressFunc_isEqual_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QHOSTADDRESS_CONVERSIONMODEFLAG_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QHostAddressFunc_isEqual_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_mode);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QHostAddressFunc_isEqual_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QHostAddress cppArg0_local;
        ::QHostAddress *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QFlags<QHostAddress::ConversionModeFlag> cppArg1 = QHostAddress::TolerantConversion;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // isEqual(QHostAddress,QFlags<QHostAddress::ConversionModeFlag>)const
            bool cppResult = const_cast<const ::QHostAddress *>(cppSelf)->isEqual(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QHostAddressFunc_isEqual_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QHostAddressFunc_isGlobal(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHostAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHostAddress.isGlobal";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isGlobal()const
            bool cppResult = const_cast<const ::QHostAddress *>(cppSelf)->isGlobal();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QHostAddressFunc_isInSubnet(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHostAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHostAddress.isInSubnet";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "isInSubnet", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QHostAddress::isInSubnet(QHostAddress,int)const
    // 1: QHostAddress::isInSubnet(QPair<QHostAddress,int>)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // isInSubnet(QHostAddress,int)const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QPAIR_QHOSTADDRESS_INT_IDX], (pyArgs[0])))) {
        overloadId = 1; // isInSubnet(QPair<QHostAddress,int>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QHostAddressFunc_isInSubnet_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // isInSubnet(const QHostAddress & subnet, int netmask) const
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QHostAddress cppArg0_local;
            ::QHostAddress *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // isInSubnet(QHostAddress,int)const
                bool cppResult = const_cast<const ::QHostAddress *>(cppSelf)->isInSubnet(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // isInSubnet(const QPair<QHostAddress,int > & subnet) const
        {
            ::QPair<QHostAddress,int > cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // isInSubnet(QPair<QHostAddress,int>)const
                bool cppResult = const_cast<const ::QHostAddress *>(cppSelf)->isInSubnet(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QHostAddressFunc_isInSubnet_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QHostAddressFunc_isLinkLocal(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHostAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHostAddress.isLinkLocal";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isLinkLocal()const
            bool cppResult = const_cast<const ::QHostAddress *>(cppSelf)->isLinkLocal();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QHostAddressFunc_isLoopback(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHostAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHostAddress.isLoopback";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isLoopback()const
            bool cppResult = const_cast<const ::QHostAddress *>(cppSelf)->isLoopback();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QHostAddressFunc_isMulticast(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHostAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHostAddress.isMulticast";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isMulticast()const
            bool cppResult = const_cast<const ::QHostAddress *>(cppSelf)->isMulticast();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QHostAddressFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHostAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHostAddress.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QHostAddress *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QHostAddressFunc_isSiteLocal(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHostAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHostAddress.isSiteLocal";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isSiteLocal()const
            bool cppResult = const_cast<const ::QHostAddress *>(cppSelf)->isSiteLocal();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QHostAddressFunc_isUniqueLocalUnicast(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHostAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHostAddress.isUniqueLocalUnicast";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isUniqueLocalUnicast()const
            bool cppResult = const_cast<const ::QHostAddress *>(cppSelf)->isUniqueLocalUnicast();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QHostAddressFunc_parseSubnet(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHostAddress.parseSubnet";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QHostAddress::parseSubnet(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // parseSubnet(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QHostAddressFunc_parseSubnet_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // parseSubnet(QString)
            QPair<QHostAddress,int > cppResult = ::QHostAddress::parseSubnet(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QPAIR_QHOSTADDRESS_INT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QHostAddressFunc_parseSubnet_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QHostAddressFunc_protocol(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHostAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHostAddress.protocol";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // protocol()const
            QAbstractSocket::NetworkLayerProtocol cppResult = const_cast<const ::QHostAddress *>(cppSelf)->protocol();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QABSTRACTSOCKET_NETWORKLAYERPROTOCOL_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QHostAddressFunc_scopeId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHostAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHostAddress.scopeId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // scopeId()const
            QString cppResult = const_cast<const ::QHostAddress *>(cppSelf)->scopeId();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QHostAddressFunc_setAddress(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHostAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHostAddress.setAddress";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QHostAddress::setAddress(QHostAddress::SpecialAddress)
    // 1: QHostAddress::setAddress(QIPv6Address)
    // 2: QHostAddress::setAddress(QString)
    // 3: QHostAddress::setAddress(quint32)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 2; // setAddress(QString)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QIPV6ADDRESS_IDX]), (pyArg)))) {
        overloadId = 1; // setAddress(QIPv6Address)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_SPECIALADDRESS_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setAddress(QHostAddress::SpecialAddress)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), (pyArg)))) {
        overloadId = 3; // setAddress(quint32)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QHostAddressFunc_setAddress_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setAddress(QHostAddress::SpecialAddress address)
        {
            ::QHostAddress::SpecialAddress cppArg0{QHostAddress::Null};
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // setAddress(QHostAddress::SpecialAddress)
                cppSelf->setAddress(cppArg0);
                pyResult = Py_None;
                Py_INCREF(Py_None);
            }
            break;
        }
        case 1: // setAddress(const QIPv6Address & ip6Addr)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QIPv6Address cppArg0_local;
            ::QIPv6Address *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QIPV6ADDRESS_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // setAddress(QIPv6Address)
                cppSelf->setAddress(*cppArg0);
                pyResult = Py_None;
                Py_INCREF(Py_None);
            }
            break;
        }
        case 2: // setAddress(const QString & address)
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // setAddress(QString)
                bool cppResult = cppSelf->setAddress(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 3: // setAddress(quint32 ip4Addr)
        {
            quint32 cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // setAddress(quint32)
                cppSelf->setAddress(cppArg0);
                pyResult = Py_None;
                Py_INCREF(Py_None);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QHostAddressFunc_setAddress_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QHostAddressFunc_setScopeId(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHostAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHostAddress.setScopeId";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QHostAddress::setScopeId(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setScopeId(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QHostAddressFunc_setScopeId_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setScopeId(QString)
            cppSelf->setScopeId(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QHostAddressFunc_setScopeId_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QHostAddressFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHostAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHostAddress.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QHostAddress::swap(QHostAddress&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QHostAddress&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QHostAddressFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QHostAddress cppArg0_local;
        ::QHostAddress *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QHostAddress&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QHostAddressFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QHostAddressFunc_toIPv4Address(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHostAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHostAddress.toIPv4Address";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "toIPv4Address", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QHostAddress::toIPv4Address()const
    // 1: QHostAddress::toIPv4Address(bool*)const
    if (numArgs == 0) {
        overloadId = 0; // toIPv4Address()const
    } else if (numArgs == 1
        && PyBool_Check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 1; // toIPv4Address(bool*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QHostAddressFunc_toIPv4Address_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // toIPv4Address() const
        {

            if (!PyErr_Occurred()) {
                // toIPv4Address()const
                quint32 cppResult = const_cast<const ::QHostAddress *>(cppSelf)->toIPv4Address();
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), &cppResult);
            }
            break;
        }
        case 1: // toIPv4Address(bool * ok) const
        {
            bool *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // toIPv4Address(bool*)const
                quint32 cppResult = const_cast<const ::QHostAddress *>(cppSelf)->toIPv4Address(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QHostAddressFunc_toIPv4Address_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QHostAddressFunc_toIPv6Address(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHostAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHostAddress.toIPv6Address";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toIPv6Address()const
            QIPv6Address cppResult = const_cast<const ::QHostAddress *>(cppSelf)->toIPv6Address();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QIPV6ADDRESS_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QHostAddressFunc_toString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHostAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHostAddress.toString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toString()const
            QString cppResult = const_cast<const ::QHostAddress *>(cppSelf)->toString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QHostAddress___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QHostAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QHostAddress_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QHostAddress_methods[] = {
    {"clear", reinterpret_cast<PyCFunction>(Sbk_QHostAddressFunc_clear), METH_NOARGS},
    {"isBroadcast", reinterpret_cast<PyCFunction>(Sbk_QHostAddressFunc_isBroadcast), METH_NOARGS},
    {"isEqual", reinterpret_cast<PyCFunction>(Sbk_QHostAddressFunc_isEqual), METH_VARARGS|METH_KEYWORDS},
    {"isGlobal", reinterpret_cast<PyCFunction>(Sbk_QHostAddressFunc_isGlobal), METH_NOARGS},
    {"isInSubnet", reinterpret_cast<PyCFunction>(Sbk_QHostAddressFunc_isInSubnet), METH_VARARGS},
    {"isLinkLocal", reinterpret_cast<PyCFunction>(Sbk_QHostAddressFunc_isLinkLocal), METH_NOARGS},
    {"isLoopback", reinterpret_cast<PyCFunction>(Sbk_QHostAddressFunc_isLoopback), METH_NOARGS},
    {"isMulticast", reinterpret_cast<PyCFunction>(Sbk_QHostAddressFunc_isMulticast), METH_NOARGS},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QHostAddressFunc_isNull), METH_NOARGS},
    {"isSiteLocal", reinterpret_cast<PyCFunction>(Sbk_QHostAddressFunc_isSiteLocal), METH_NOARGS},
    {"isUniqueLocalUnicast", reinterpret_cast<PyCFunction>(Sbk_QHostAddressFunc_isUniqueLocalUnicast), METH_NOARGS},
    {"parseSubnet", reinterpret_cast<PyCFunction>(Sbk_QHostAddressFunc_parseSubnet), METH_O|METH_STATIC},
    {"protocol", reinterpret_cast<PyCFunction>(Sbk_QHostAddressFunc_protocol), METH_NOARGS},
    {"scopeId", reinterpret_cast<PyCFunction>(Sbk_QHostAddressFunc_scopeId), METH_NOARGS},
    {"setAddress", reinterpret_cast<PyCFunction>(Sbk_QHostAddressFunc_setAddress), METH_O},
    {"setScopeId", reinterpret_cast<PyCFunction>(Sbk_QHostAddressFunc_setScopeId), METH_O},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QHostAddressFunc_swap), METH_O},
    {"toIPv4Address", reinterpret_cast<PyCFunction>(Sbk_QHostAddressFunc_toIPv4Address), METH_VARARGS},
    {"toIPv6Address", reinterpret_cast<PyCFunction>(Sbk_QHostAddressFunc_toIPv6Address), METH_NOARGS},
    {"toString", reinterpret_cast<PyCFunction>(Sbk_QHostAddressFunc_toString), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QHostAddress___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QHostAddress___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QHostAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

static PyObject *Sbk_QHostAddressFunc___lshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHostAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHostAddress.__lshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rlshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QHostAddress::operator<<(QDataStream&,QHostAddress)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator<<(QDataStream&,QHostAddress)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QHostAddressFunc___lshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDataStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator<<(QDataStream&,QHostAddress) [reverse operator]
                QDataStream & cppResult = (*cppArg0) << (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QHostAddressFunc___lshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QHostAddressFunc___rshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHostAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QHostAddress.__rshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rrshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QHostAddress::operator>>(QDataStream&,QHostAddress&)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator>>(QDataStream&,QHostAddress&)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QHostAddressFunc___rshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDataStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator>>(QDataStream&,QHostAddress&) [reverse operator]
                QDataStream & cppResult = (*cppArg0) >> (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QHostAddressFunc___rshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

// Rich comparison
static PyObject * Sbk_QHostAddress_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QHostAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_SPECIALADDRESS_IDX])->converter, (pyArg)))) {
                // operator!=(QHostAddress::SpecialAddress lhs)
                ::QHostAddress::SpecialAddress cppArg0{QHostAddress::Null};
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf !=(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), (pyArg)))) {
                // operator!=(const QHostAddress & address) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QHostAddress cppArg0_local;
                ::QHostAddress *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_SPECIALADDRESS_IDX])->converter, (pyArg)))) {
                // operator!=(QHostAddress::SpecialAddress address) const
                ::QHostAddress::SpecialAddress cppArg0{QHostAddress::Null};
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf !=(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_SPECIALADDRESS_IDX])->converter, (pyArg)))) {
                // operator==(QHostAddress::SpecialAddress address1)
                ::QHostAddress::SpecialAddress cppArg0{QHostAddress::Null};
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf ==(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), (pyArg)))) {
                // operator==(const QHostAddress & address) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QHostAddress cppArg0_local;
                ::QHostAddress *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_SPECIALADDRESS_IDX])->converter, (pyArg)))) {
                // operator==(QHostAddress::SpecialAddress address) const
                ::QHostAddress::SpecialAddress cppArg0{QHostAddress::Null};
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf ==(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QHostAddress_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QHostAddress_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static Py_hash_t Sbk_QHostAddress_HashFunc(PyObject *self) {
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHostAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Py_hash_t(qHash(*cppSelf));
}

static int Sbk_QHostAddress_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QHostAddress_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QHostAddress__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHostAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QHostAddress_Type = nullptr;
static SbkObjectType *Sbk_QHostAddress_TypeF(void)
{
    return _Sbk_QHostAddress_Type;
}

static PyType_Slot Sbk_QHostAddress_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QHostAddress__repr__)},
    {Py_tp_hash,        reinterpret_cast<void *>(&Sbk_QHostAddress_HashFunc)},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QHostAddress_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QHostAddress_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QHostAddress_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QHostAddress_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QHostAddress_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
    {Py_nb_rshift, (void *)Sbk_QHostAddressFunc___rshift__},
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QHostAddress___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QHostAddress___nb_bool},
#endif
    {Py_nb_lshift, (void *)Sbk_QHostAddressFunc___lshift__},
    {0, nullptr}
};
static PyType_Spec Sbk_QHostAddress_spec = {
    "2:PySide2.QtNetwork.QHostAddress",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QHostAddress_slots
};

} //extern "C"

PyObject *SbkPySide2_QtNetwork_QHostAddress_ConversionModeFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::QHostAddress::ConversionMode cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QHostAddress::ConversionMode>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QHostAddress::ConversionMode>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QHostAddress::ConversionMode>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QHostAddress::ConversionMode>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QHOSTADDRESS_CONVERSIONMODEFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtNetwork_QHostAddress_ConversionModeFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::QHostAddress::ConversionMode cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QHostAddress::ConversionMode>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QHostAddress::ConversionMode>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QHostAddress::ConversionMode>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QHostAddress::ConversionMode>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QHOSTADDRESS_CONVERSIONMODEFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtNetwork_QHostAddress_ConversionModeFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QHostAddress::ConversionMode cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QHostAddress::ConversionMode>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QHostAddress::ConversionMode>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QHostAddress::ConversionMode>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QHostAddress::ConversionMode>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QHOSTADDRESS_CONVERSIONMODEFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtNetwork_QHostAddress_ConversionModeFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QHostAddress::ConversionMode cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QHOSTADDRESS_CONVERSIONMODEFLAG_IDX])->converter, self, &cppSelf);
    ::QHostAddress::ConversionMode cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QHOSTADDRESS_CONVERSIONMODEFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtNetwork_QHostAddress_ConversionModeFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QHOSTADDRESS_CONVERSIONMODEFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtNetwork_QHostAddress_ConversionModeFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QHOSTADDRESS_CONVERSIONMODEFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtNetwork_QHostAddress_ConversionModeFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtNetwork_QHostAddress_ConversionModeFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtNetwork_QHostAddress_ConversionModeFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtNetwork_QHostAddress_ConversionModeFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtNetwork_QHostAddress_ConversionModeFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtNetwork_QHostAddress_ConversionModeFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtNetwork_QHostAddress_ConversionModeFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtNetwork_QHostAddress_ConversionModeFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtNetwork_QHostAddress_ConversionModeFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtNetwork_QHostAddress_ConversionModeFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtNetwork_QHostAddress_ConversionModeFlag_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QHostAddress_SpecialAddress_PythonToCpp_QHostAddress_SpecialAddress(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QHostAddress::SpecialAddress *>(cppOut) =
        static_cast<::QHostAddress::SpecialAddress>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QHostAddress_SpecialAddress_PythonToCpp_QHostAddress_SpecialAddress_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_SPECIALADDRESS_IDX]))
        return QHostAddress_SpecialAddress_PythonToCpp_QHostAddress_SpecialAddress;
    return {};
}
static PyObject *QHostAddress_SpecialAddress_CppToPython_QHostAddress_SpecialAddress(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QHostAddress::SpecialAddress *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_SPECIALADDRESS_IDX], castCppIn);

}

static void QHostAddress_ConversionModeFlag_PythonToCpp_QHostAddress_ConversionModeFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QHostAddress::ConversionModeFlag *>(cppOut) =
        static_cast<::QHostAddress::ConversionModeFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QHostAddress_ConversionModeFlag_PythonToCpp_QHostAddress_ConversionModeFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_CONVERSIONMODEFLAG_IDX]))
        return QHostAddress_ConversionModeFlag_PythonToCpp_QHostAddress_ConversionModeFlag;
    return {};
}
static PyObject *QHostAddress_ConversionModeFlag_CppToPython_QHostAddress_ConversionModeFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QHostAddress::ConversionModeFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_CONVERSIONMODEFLAG_IDX], castCppIn);

}

static void QFlags_QHostAddress_ConversionModeFlag__PythonToCpp_QFlags_QHostAddress_ConversionModeFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QHostAddress::ConversionModeFlag> *>(cppOut) =
        ::QFlags<QHostAddress::ConversionModeFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QHostAddress_ConversionModeFlag__PythonToCpp_QFlags_QHostAddress_ConversionModeFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QHOSTADDRESS_CONVERSIONMODEFLAG_IDX]))
        return QFlags_QHostAddress_ConversionModeFlag__PythonToCpp_QFlags_QHostAddress_ConversionModeFlag_;
    return {};
}
static PyObject *QFlags_QHostAddress_ConversionModeFlag__CppToPython_QFlags_QHostAddress_ConversionModeFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QHostAddress::ConversionModeFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QHOSTADDRESS_CONVERSIONMODEFLAG_IDX]));

}

static void QHostAddress_ConversionModeFlag_PythonToCpp_QFlags_QHostAddress_ConversionModeFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QHostAddress::ConversionModeFlag> *>(cppOut) =
        ::QFlags<QHostAddress::ConversionModeFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QHostAddress_ConversionModeFlag_PythonToCpp_QFlags_QHostAddress_ConversionModeFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_CONVERSIONMODEFLAG_IDX]))
        return QHostAddress_ConversionModeFlag_PythonToCpp_QFlags_QHostAddress_ConversionModeFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_QHostAddress_ConversionModeFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QHostAddress::ConversionModeFlag> *>(cppOut) =
        ::QFlags<QHostAddress::ConversionModeFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QHostAddress_ConversionModeFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_CONVERSIONMODEFLAG_IDX]))
        return number_PythonToCpp_QFlags_QHostAddress_ConversionModeFlag_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QHostAddress_PythonToCpp_QHostAddress_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QHostAddress_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QHostAddress_PythonToCpp_QHostAddress_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QHostAddress_TypeF())))
        return QHostAddress_PythonToCpp_QHostAddress_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QHostAddress_PTR_CppToPython_QHostAddress(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QHostAddress *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QHostAddress_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QHostAddress_COPY_CppToPython_QHostAddress(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QHostAddress_TypeF(), new ::QHostAddress(*reinterpret_cast<const ::QHostAddress *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QHostAddress_PythonToCpp_QHostAddress_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QHostAddress *>(cppOut) = *reinterpret_cast< ::QHostAddress *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QHostAddress_PythonToCpp_QHostAddress_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QHostAddress_TypeF())))
        return QHostAddress_PythonToCpp_QHostAddress_COPY;
    return {};
}

// Implicit conversions.
static void QHostAddress_SpecialAddress_PythonToCpp_QHostAddress(PyObject *pyIn, void *cppOut) {
    ::QHostAddress::SpecialAddress cppIn{QHostAddress::Null};
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_SPECIALADDRESS_IDX])->converter, pyIn, &cppIn);
    *reinterpret_cast<::QHostAddress *>(cppOut) = ::QHostAddress(cppIn);
}
static PythonToCppFunc is_QHostAddress_SpecialAddress_PythonToCpp_QHostAddress_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_SPECIALADDRESS_IDX], pyIn))
        return QHostAddress_SpecialAddress_PythonToCpp_QHostAddress;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QHostAddress_SignatureStrings[] = {
    "5:PySide2.QtNetwork.QHostAddress(self)",
    "4:PySide2.QtNetwork.QHostAddress(self,address:PySide2.QtNetwork.QHostAddress.SpecialAddress)",
    "3:PySide2.QtNetwork.QHostAddress(self,copy:PySide2.QtNetwork.QHostAddress)",
    "2:PySide2.QtNetwork.QHostAddress(self,ip6Addr:PySide2.QtNetwork.QIPv6Address)",
    "1:PySide2.QtNetwork.QHostAddress(self,address:QString)",
    "0:PySide2.QtNetwork.QHostAddress(self,ip4Addr:quint32)",
    "PySide2.QtNetwork.QHostAddress.clear(self)",
    "PySide2.QtNetwork.QHostAddress.isBroadcast(self)->bool",
    "PySide2.QtNetwork.QHostAddress.isEqual(self,address:PySide2.QtNetwork.QHostAddress,mode:PySide2.QtNetwork.QHostAddress.ConversionMode=QHostAddress.TolerantConversion)->bool",
    "PySide2.QtNetwork.QHostAddress.isGlobal(self)->bool",
    "1:PySide2.QtNetwork.QHostAddress.isInSubnet(self,subnet:PySide2.QtNetwork.QHostAddress,netmask:int)->bool",
    "0:PySide2.QtNetwork.QHostAddress.isInSubnet(self,subnet:QPair[PySide2.QtNetwork.QHostAddress, int])->bool",
    "PySide2.QtNetwork.QHostAddress.isLinkLocal(self)->bool",
    "PySide2.QtNetwork.QHostAddress.isLoopback(self)->bool",
    "PySide2.QtNetwork.QHostAddress.isMulticast(self)->bool",
    "PySide2.QtNetwork.QHostAddress.isNull(self)->bool",
    "PySide2.QtNetwork.QHostAddress.isSiteLocal(self)->bool",
    "PySide2.QtNetwork.QHostAddress.isUniqueLocalUnicast(self)->bool",
    "PySide2.QtNetwork.QHostAddress.parseSubnet(subnet:QString)->QPair[PySide2.QtNetwork.QHostAddress, int]",
    "PySide2.QtNetwork.QHostAddress.protocol(self)->PySide2.QtNetwork.QAbstractSocket.NetworkLayerProtocol",
    "PySide2.QtNetwork.QHostAddress.scopeId(self)->QString",
    "3:PySide2.QtNetwork.QHostAddress.setAddress(self,address:PySide2.QtNetwork.QHostAddress.SpecialAddress)",
    "2:PySide2.QtNetwork.QHostAddress.setAddress(self,ip6Addr:PySide2.QtNetwork.QIPv6Address)",
    "1:PySide2.QtNetwork.QHostAddress.setAddress(self,address:QString)->bool",
    "0:PySide2.QtNetwork.QHostAddress.setAddress(self,ip4Addr:quint32)",
    "PySide2.QtNetwork.QHostAddress.setScopeId(self,id:QString)",
    "PySide2.QtNetwork.QHostAddress.swap(self,other:PySide2.QtNetwork.QHostAddress)",
    "1:PySide2.QtNetwork.QHostAddress.toIPv4Address(self)->quint32",
    "0:PySide2.QtNetwork.QHostAddress.toIPv4Address(self,ok:bool*)->quint32",
    "PySide2.QtNetwork.QHostAddress.toIPv6Address(self)->PySide2.QtNetwork.QIPv6Address",
    "PySide2.QtNetwork.QHostAddress.toString(self)->QString",
    "PySide2.QtNetwork.QHostAddress.__copy__()",
    "PySide2.QtNetwork.QHostAddress.__lshift__(self,arg__1:PySide2.QtCore.QDataStream)->PySide2.QtCore.QDataStream",
    "PySide2.QtNetwork.QHostAddress.__rshift__(self,arg__1:PySide2.QtCore.QDataStream)->PySide2.QtCore.QDataStream",
    nullptr}; // Sentinel

void init_QHostAddress(PyObject *module)
{
    _Sbk_QHostAddress_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QHostAddress",
        "QHostAddress",
        &Sbk_QHostAddress_spec,
        &Shiboken::callCppDestructor< ::QHostAddress >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QHostAddress_Type);
    InitSignatureStrings(pyType, QHostAddress_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QHostAddress_Type), Sbk_QHostAddress_PropertyStrings);
    SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QHostAddress_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QHostAddress_TypeF(),
        QHostAddress_PythonToCpp_QHostAddress_PTR,
        is_QHostAddress_PythonToCpp_QHostAddress_PTR_Convertible,
        QHostAddress_PTR_CppToPython_QHostAddress,
        QHostAddress_COPY_CppToPython_QHostAddress);

    Shiboken::Conversions::registerConverterName(converter, "QHostAddress");
    Shiboken::Conversions::registerConverterName(converter, "QHostAddress*");
    Shiboken::Conversions::registerConverterName(converter, "QHostAddress&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QHostAddress).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QHostAddress_PythonToCpp_QHostAddress_COPY,
        is_QHostAddress_PythonToCpp_QHostAddress_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QHostAddress_SpecialAddress_PythonToCpp_QHostAddress,
        is_QHostAddress_SpecialAddress_PythonToCpp_QHostAddress_Convertible);

    // Initialization of enums.

    // Initialization of enum 'SpecialAddress'.
    SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_SPECIALADDRESS_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QHostAddress_TypeF(),
        "SpecialAddress",
        "2:PySide2.QtNetwork.QHostAddress.SpecialAddress",
        "QHostAddress::SpecialAddress");
    if (!SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_SPECIALADDRESS_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_SPECIALADDRESS_IDX],
        Sbk_QHostAddress_TypeF(), "Null", (long) QHostAddress::SpecialAddress::Null))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_SPECIALADDRESS_IDX],
        Sbk_QHostAddress_TypeF(), "Broadcast", (long) QHostAddress::SpecialAddress::Broadcast))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_SPECIALADDRESS_IDX],
        Sbk_QHostAddress_TypeF(), "LocalHost", (long) QHostAddress::SpecialAddress::LocalHost))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_SPECIALADDRESS_IDX],
        Sbk_QHostAddress_TypeF(), "LocalHostIPv6", (long) QHostAddress::SpecialAddress::LocalHostIPv6))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_SPECIALADDRESS_IDX],
        Sbk_QHostAddress_TypeF(), "Any", (long) QHostAddress::SpecialAddress::Any))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_SPECIALADDRESS_IDX],
        Sbk_QHostAddress_TypeF(), "AnyIPv6", (long) QHostAddress::SpecialAddress::AnyIPv6))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_SPECIALADDRESS_IDX],
        Sbk_QHostAddress_TypeF(), "AnyIPv4", (long) QHostAddress::SpecialAddress::AnyIPv4))
        return;
    // Register converter for enum 'QHostAddress::SpecialAddress'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_SPECIALADDRESS_IDX],
            QHostAddress_SpecialAddress_CppToPython_QHostAddress_SpecialAddress);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QHostAddress_SpecialAddress_PythonToCpp_QHostAddress_SpecialAddress,
            is_QHostAddress_SpecialAddress_PythonToCpp_QHostAddress_SpecialAddress_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_SPECIALADDRESS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QHostAddress::SpecialAddress");
        Shiboken::Conversions::registerConverterName(converter, "SpecialAddress");
    }
    // End of 'SpecialAddress' enum.

    // Initialization of enum 'ConversionModeFlag'.
    SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QHOSTADDRESS_CONVERSIONMODEFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtNetwork.QHostAddress.ConversionMode", SbkPySide2_QtNetwork_QHostAddress_ConversionModeFlag_number_slots);
    SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_CONVERSIONMODEFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QHostAddress_TypeF(),
        "ConversionModeFlag",
        "2:PySide2.QtNetwork.QHostAddress.ConversionModeFlag",
        "QHostAddress::ConversionModeFlag",
        SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QHOSTADDRESS_CONVERSIONMODEFLAG_IDX]);
    if (!SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_CONVERSIONMODEFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_CONVERSIONMODEFLAG_IDX],
        Sbk_QHostAddress_TypeF(), "ConvertV4MappedToIPv4", (long) QHostAddress::ConversionModeFlag::ConvertV4MappedToIPv4))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_CONVERSIONMODEFLAG_IDX],
        Sbk_QHostAddress_TypeF(), "ConvertV4CompatToIPv4", (long) QHostAddress::ConversionModeFlag::ConvertV4CompatToIPv4))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_CONVERSIONMODEFLAG_IDX],
        Sbk_QHostAddress_TypeF(), "ConvertUnspecifiedAddress", (long) QHostAddress::ConversionModeFlag::ConvertUnspecifiedAddress))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_CONVERSIONMODEFLAG_IDX],
        Sbk_QHostAddress_TypeF(), "ConvertLocalHost", (long) QHostAddress::ConversionModeFlag::ConvertLocalHost))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_CONVERSIONMODEFLAG_IDX],
        Sbk_QHostAddress_TypeF(), "TolerantConversion", (long) QHostAddress::ConversionModeFlag::TolerantConversion))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_CONVERSIONMODEFLAG_IDX],
        Sbk_QHostAddress_TypeF(), "StrictConversion", (long) QHostAddress::ConversionModeFlag::StrictConversion))
        return;
    // Register converter for enum 'QHostAddress::ConversionModeFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_CONVERSIONMODEFLAG_IDX],
            QHostAddress_ConversionModeFlag_CppToPython_QHostAddress_ConversionModeFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QHostAddress_ConversionModeFlag_PythonToCpp_QHostAddress_ConversionModeFlag,
            is_QHostAddress_ConversionModeFlag_PythonToCpp_QHostAddress_ConversionModeFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_CONVERSIONMODEFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QHostAddress::ConversionModeFlag");
        Shiboken::Conversions::registerConverterName(converter, "ConversionModeFlag");
    }
    // Register converter for flag 'QFlags<QHostAddress::ConversionModeFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QHOSTADDRESS_CONVERSIONMODEFLAG_IDX],
            QFlags_QHostAddress_ConversionModeFlag__CppToPython_QFlags_QHostAddress_ConversionModeFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QHostAddress_ConversionModeFlag_PythonToCpp_QFlags_QHostAddress_ConversionModeFlag_,
            is_QHostAddress_ConversionModeFlag_PythonToCpp_QFlags_QHostAddress_ConversionModeFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QHostAddress_ConversionModeFlag__PythonToCpp_QFlags_QHostAddress_ConversionModeFlag_,
            is_QFlags_QHostAddress_ConversionModeFlag__PythonToCpp_QFlags_QHostAddress_ConversionModeFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QHostAddress_ConversionModeFlag_,
            is_number_PythonToCpp_QFlags_QHostAddress_ConversionModeFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QFLAGS_QHOSTADDRESS_CONVERSIONMODEFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QHostAddress::ConversionMode");
        Shiboken::Conversions::registerConverterName(converter, "ConversionMode");
    }
    // End of 'ConversionModeFlag' enum/flags.

    qRegisterMetaType< ::QHostAddress >("QHostAddress");
    qRegisterMetaType< ::QHostAddress::SpecialAddress >("QHostAddress::SpecialAddress");
    qRegisterMetaType< ::QHostAddress::ConversionModeFlag >("QHostAddress::ConversionModeFlag");
    qRegisterMetaType< ::QHostAddress::ConversionMode >("QHostAddress::ConversionMode");
}
