/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtnetwork_python.h"

// main header
#include "qdtls_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QDtlsWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QDtlsWrapper::QDtlsWrapper(::QSslSocket::SslMode mode, ::QObject * parent) : QDtls(mode, parent)
{
    resetPyMethodCache();
    // ... middle
}

void QDtlsWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QDtlsWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QDtlsWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QDtlsWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QDtlsWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QDtls.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QDtlsWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QDtls.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QDtlsWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QDtlsWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QDtls::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QDtlsWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QDtls::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QDtlsWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QDtlsWrapper *>(this));
        return QDtls::qt_metacast(_clname);
}

QDtlsWrapper::~QDtlsWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QDtls_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QDtls >()))
        return -1;

    ::QDtlsWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDtls.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QDtls_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:QDtls", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QDtls::QDtls(QSslSocket::SslMode,QObject*)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QSSLSOCKET_SSLMODE_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // QDtls(QSslSocket::SslMode,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
            overloadId = 0; // QDtls(QSslSocket::SslMode,QObject*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDtls_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[1]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QDtls_Init_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1]))))
                        goto Sbk_QDtls_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        ::QSslSocket::SslMode cppArg0{QSslSocket::UnencryptedMode};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return -1;
        ::QObject *cppArg1 = nullptr;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // QDtls(QSslSocket::SslMode,QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QDtlsWrapper(cppArg0, cppArg1);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QDtlsWrapper(cppArg0, cppArg1);
            }

            Shiboken::Object::setParent(pyArgs[1], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QDtls >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QDtls_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QDtls_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QDtls_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QDtlsFunc_abortHandshake(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDtls *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDTLS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDtls.abortHandshake";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDtls::abortHandshake(QUdpSocket*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QUDPSOCKET_IDX]), (pyArg)))) {
        overloadId = 0; // abortHandshake(QUdpSocket*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDtlsFunc_abortHandshake_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUdpSocket *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // abortHandshake(QUdpSocket*)
            bool cppResult = cppSelf->abortHandshake(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDtlsFunc_abortHandshake_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDtlsFunc_decryptDatagram(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDtls *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDTLS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDtls.decryptDatagram";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "decryptDatagram", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QDtls::decryptDatagram(QUdpSocket*,QByteArray)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QUDPSOCKET_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[1])))) {
        overloadId = 0; // decryptDatagram(QUdpSocket*,QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDtlsFunc_decryptDatagram_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QUdpSocket *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QByteArray cppArg1_local;
        ::QByteArray *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // decryptDatagram(QUdpSocket*,QByteArray)
            QByteArray cppResult = cppSelf->decryptDatagram(cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDtlsFunc_decryptDatagram_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDtlsFunc_doHandshake(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDtls *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDTLS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDtls.doHandshake";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QDtlsFunc_doHandshake_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QDtlsFunc_doHandshake_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:doHandshake", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QDtls::doHandshake(QUdpSocket*,QByteArray)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QUDPSOCKET_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // doHandshake(QUdpSocket*,QByteArray)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[1])))) {
            overloadId = 0; // doHandshake(QUdpSocket*,QByteArray)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDtlsFunc_doHandshake_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_dgram = Shiboken::String::createStaticString("dgram");
            if (PyDict_Contains(kwds, key_dgram)) {
                value = PyDict_GetItem(kwds, key_dgram);
                if (value && pyArgs[1]) {
                    errInfo = key_dgram;
                    Py_INCREF(errInfo);
                    goto Sbk_QDtlsFunc_doHandshake_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[1]))))
                        goto Sbk_QDtlsFunc_doHandshake_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_dgram);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QDtlsFunc_doHandshake_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QUdpSocket *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QByteArray cppArg1_local = {};
        ::QByteArray *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);
        }

        if (!PyErr_Occurred()) {
            // doHandshake(QUdpSocket*,QByteArray)
            bool cppResult = cppSelf->doHandshake(cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDtlsFunc_doHandshake_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDtlsFunc_dtlsConfiguration(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDtls *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDTLS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDtls.dtlsConfiguration";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // dtlsConfiguration()const
            QSslConfiguration cppResult = const_cast<const ::QDtls *>(cppSelf)->dtlsConfiguration();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDtlsFunc_dtlsError(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDtls *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDTLS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDtls.dtlsError";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // dtlsError()const
            QDtlsError cppResult = const_cast<const ::QDtls *>(cppSelf)->dtlsError();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QDTLSERROR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDtlsFunc_dtlsErrorString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDtls *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDTLS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDtls.dtlsErrorString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // dtlsErrorString()const
            QString cppResult = const_cast<const ::QDtls *>(cppSelf)->dtlsErrorString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDtlsFunc_handleTimeout(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDtls *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDTLS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDtls.handleTimeout";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDtls::handleTimeout(QUdpSocket*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QUDPSOCKET_IDX]), (pyArg)))) {
        overloadId = 0; // handleTimeout(QUdpSocket*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDtlsFunc_handleTimeout_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUdpSocket *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // handleTimeout(QUdpSocket*)
            bool cppResult = cppSelf->handleTimeout(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDtlsFunc_handleTimeout_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDtlsFunc_handshakeState(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDtls *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDTLS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDtls.handshakeState";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // handshakeState()const
            QDtls::HandshakeState cppResult = const_cast<const ::QDtls *>(cppSelf)->handshakeState();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QDTLS_HANDSHAKESTATE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDtlsFunc_ignoreVerificationErrors(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDtls *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDTLS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDtls.ignoreVerificationErrors";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDtls::ignoreVerificationErrors(QVector<QSslError>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QVECTOR_QSSLERROR_IDX], (pyArg)))) {
        overloadId = 0; // ignoreVerificationErrors(QVector<QSslError>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDtlsFunc_ignoreVerificationErrors_TypeError;

    // Call function/method
    {
        ::QVector<QSslError > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // ignoreVerificationErrors(QVector<QSslError>)
            cppSelf->ignoreVerificationErrors(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDtlsFunc_ignoreVerificationErrors_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDtlsFunc_isConnectionEncrypted(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDtls *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDTLS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDtls.isConnectionEncrypted";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isConnectionEncrypted()const
            bool cppResult = const_cast<const ::QDtls *>(cppSelf)->isConnectionEncrypted();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDtlsFunc_mtuHint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDtls *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDTLS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDtls.mtuHint";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mtuHint()const
            quint16 cppResult = const_cast<const ::QDtls *>(cppSelf)->mtuHint();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint16>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDtlsFunc_peerAddress(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDtls *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDTLS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDtls.peerAddress";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // peerAddress()const
            QHostAddress cppResult = const_cast<const ::QDtls *>(cppSelf)->peerAddress();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDtlsFunc_peerPort(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDtls *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDTLS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDtls.peerPort";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // peerPort()const
            quint16 cppResult = const_cast<const ::QDtls *>(cppSelf)->peerPort();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint16>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDtlsFunc_peerVerificationErrors(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDtls *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDTLS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDtls.peerVerificationErrors";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // peerVerificationErrors()const
            QVector<QSslError > cppResult = const_cast<const ::QDtls *>(cppSelf)->peerVerificationErrors();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QVECTOR_QSSLERROR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDtlsFunc_peerVerificationName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDtls *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDTLS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDtls.peerVerificationName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // peerVerificationName()const
            QString cppResult = const_cast<const ::QDtls *>(cppSelf)->peerVerificationName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDtlsFunc_resumeHandshake(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDtls *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDTLS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDtls.resumeHandshake";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDtls::resumeHandshake(QUdpSocket*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QUDPSOCKET_IDX]), (pyArg)))) {
        overloadId = 0; // resumeHandshake(QUdpSocket*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDtlsFunc_resumeHandshake_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUdpSocket *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // resumeHandshake(QUdpSocket*)
            bool cppResult = cppSelf->resumeHandshake(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDtlsFunc_resumeHandshake_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDtlsFunc_sessionCipher(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDtls *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDTLS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDtls.sessionCipher";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sessionCipher()const
            QSslCipher cppResult = const_cast<const ::QDtls *>(cppSelf)->sessionCipher();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCIPHER_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDtlsFunc_sessionProtocol(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDtls *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDTLS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDtls.sessionProtocol";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sessionProtocol()const
            QSsl::SslProtocol cppResult = const_cast<const ::QDtls *>(cppSelf)->sessionProtocol();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QSSL_SSLPROTOCOL_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDtlsFunc_setDtlsConfiguration(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDtls *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDTLS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDtls.setDtlsConfiguration";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDtls::setDtlsConfiguration(QSslConfiguration)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX]), (pyArg)))) {
        overloadId = 0; // setDtlsConfiguration(QSslConfiguration)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDtlsFunc_setDtlsConfiguration_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSslConfiguration cppArg0_local;
        ::QSslConfiguration *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QSSLCONFIGURATION_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setDtlsConfiguration(QSslConfiguration)
            bool cppResult = cppSelf->setDtlsConfiguration(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDtlsFunc_setDtlsConfiguration_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDtlsFunc_setMtuHint(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDtls *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDTLS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDtls.setMtuHint";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDtls::setMtuHint(quint16)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint16>(), (pyArg)))) {
        overloadId = 0; // setMtuHint(quint16)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDtlsFunc_setMtuHint_TypeError;

    // Call function/method
    {
        quint16 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMtuHint(quint16)
            cppSelf->setMtuHint(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDtlsFunc_setMtuHint_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDtlsFunc_setPeer(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDtls *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDTLS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDtls.setPeer";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QDtlsFunc_setPeer_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QDtlsFunc_setPeer_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:setPeer", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QDtls::setPeer(QHostAddress,quint16,QString)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint16>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // setPeer(QHostAddress,quint16,QString)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
            overloadId = 0; // setPeer(QHostAddress,quint16,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDtlsFunc_setPeer_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_verificationName = Shiboken::String::createStaticString("verificationName");
            if (PyDict_Contains(kwds, key_verificationName)) {
                value = PyDict_GetItem(kwds, key_verificationName);
                if (value && pyArgs[2]) {
                    errInfo = key_verificationName;
                    Py_INCREF(errInfo);
                    goto Sbk_QDtlsFunc_setPeer_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2]))))
                        goto Sbk_QDtlsFunc_setPeer_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_verificationName);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QDtlsFunc_setPeer_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QHostAddress cppArg0_local;
        ::QHostAddress *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        quint16 cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2 = {};
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // setPeer(QHostAddress,quint16,QString)
            bool cppResult = cppSelf->setPeer(*cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDtlsFunc_setPeer_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDtlsFunc_setPeerVerificationName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDtls *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDTLS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDtls.setPeerVerificationName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDtls::setPeerVerificationName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setPeerVerificationName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDtlsFunc_setPeerVerificationName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPeerVerificationName(QString)
            bool cppResult = cppSelf->setPeerVerificationName(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDtlsFunc_setPeerVerificationName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDtlsFunc_shutdown(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDtls *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDTLS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDtls.shutdown";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDtls::shutdown(QUdpSocket*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QUDPSOCKET_IDX]), (pyArg)))) {
        overloadId = 0; // shutdown(QUdpSocket*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDtlsFunc_shutdown_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUdpSocket *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // shutdown(QUdpSocket*)
            bool cppResult = cppSelf->shutdown(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDtlsFunc_shutdown_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDtlsFunc_sslMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDtls *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDTLS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDtls.sslMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sslMode()const
            QSslSocket::SslMode cppResult = const_cast<const ::QDtls *>(cppSelf)->sslMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QSSLSOCKET_SSLMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDtlsFunc_writeDatagramEncrypted(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDtls *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDTLS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDtls.writeDatagramEncrypted";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "writeDatagramEncrypted", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QDtls::writeDatagramEncrypted(QUdpSocket*,QByteArray)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QUDPSOCKET_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[1])))) {
        overloadId = 0; // writeDatagramEncrypted(QUdpSocket*,QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDtlsFunc_writeDatagramEncrypted_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QUdpSocket *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QByteArray cppArg1_local;
        ::QByteArray *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // writeDatagramEncrypted(QUdpSocket*,QByteArray)
            qint64 cppResult = cppSelf->writeDatagramEncrypted(cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QDtlsFunc_writeDatagramEncrypted_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QDtls_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QDtls_methods[] = {
    {"abortHandshake", reinterpret_cast<PyCFunction>(Sbk_QDtlsFunc_abortHandshake), METH_O},
    {"decryptDatagram", reinterpret_cast<PyCFunction>(Sbk_QDtlsFunc_decryptDatagram), METH_VARARGS},
    {"doHandshake", reinterpret_cast<PyCFunction>(Sbk_QDtlsFunc_doHandshake), METH_VARARGS|METH_KEYWORDS},
    {"dtlsConfiguration", reinterpret_cast<PyCFunction>(Sbk_QDtlsFunc_dtlsConfiguration), METH_NOARGS},
    {"dtlsError", reinterpret_cast<PyCFunction>(Sbk_QDtlsFunc_dtlsError), METH_NOARGS},
    {"dtlsErrorString", reinterpret_cast<PyCFunction>(Sbk_QDtlsFunc_dtlsErrorString), METH_NOARGS},
    {"handleTimeout", reinterpret_cast<PyCFunction>(Sbk_QDtlsFunc_handleTimeout), METH_O},
    {"handshakeState", reinterpret_cast<PyCFunction>(Sbk_QDtlsFunc_handshakeState), METH_NOARGS},
    {"ignoreVerificationErrors", reinterpret_cast<PyCFunction>(Sbk_QDtlsFunc_ignoreVerificationErrors), METH_O},
    {"isConnectionEncrypted", reinterpret_cast<PyCFunction>(Sbk_QDtlsFunc_isConnectionEncrypted), METH_NOARGS},
    {"mtuHint", reinterpret_cast<PyCFunction>(Sbk_QDtlsFunc_mtuHint), METH_NOARGS},
    {"peerAddress", reinterpret_cast<PyCFunction>(Sbk_QDtlsFunc_peerAddress), METH_NOARGS},
    {"peerPort", reinterpret_cast<PyCFunction>(Sbk_QDtlsFunc_peerPort), METH_NOARGS},
    {"peerVerificationErrors", reinterpret_cast<PyCFunction>(Sbk_QDtlsFunc_peerVerificationErrors), METH_NOARGS},
    {"peerVerificationName", reinterpret_cast<PyCFunction>(Sbk_QDtlsFunc_peerVerificationName), METH_NOARGS},
    {"resumeHandshake", reinterpret_cast<PyCFunction>(Sbk_QDtlsFunc_resumeHandshake), METH_O},
    {"sessionCipher", reinterpret_cast<PyCFunction>(Sbk_QDtlsFunc_sessionCipher), METH_NOARGS},
    {"sessionProtocol", reinterpret_cast<PyCFunction>(Sbk_QDtlsFunc_sessionProtocol), METH_NOARGS},
    {"setDtlsConfiguration", reinterpret_cast<PyCFunction>(Sbk_QDtlsFunc_setDtlsConfiguration), METH_O},
    {"setMtuHint", reinterpret_cast<PyCFunction>(Sbk_QDtlsFunc_setMtuHint), METH_O},
    {"setPeer", reinterpret_cast<PyCFunction>(Sbk_QDtlsFunc_setPeer), METH_VARARGS|METH_KEYWORDS},
    {"setPeerVerificationName", reinterpret_cast<PyCFunction>(Sbk_QDtlsFunc_setPeerVerificationName), METH_O},
    {"shutdown", reinterpret_cast<PyCFunction>(Sbk_QDtlsFunc_shutdown), METH_O},
    {"sslMode", reinterpret_cast<PyCFunction>(Sbk_QDtlsFunc_sslMode), METH_NOARGS},
    {"writeDatagramEncrypted", reinterpret_cast<PyCFunction>(Sbk_QDtlsFunc_writeDatagramEncrypted), METH_VARARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QDtls_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QDtls *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDTLS_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QDtlsWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QDtls_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QDtls_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QDtls_Type = nullptr;
static SbkObjectType *Sbk_QDtls_TypeF(void)
{
    return _Sbk_QDtls_Type;
}

static PyType_Slot Sbk_QDtls_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QDtls_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QDtls_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QDtls_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QDtls_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QDtls_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QDtls_spec = {
    "2:PySide2.QtNetwork.QDtls",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QDtls_slots
};

} //extern "C"

static void *Sbk_QDtls_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QDtls *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QDtls_HandshakeState_PythonToCpp_QDtls_HandshakeState(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QDtls::HandshakeState *>(cppOut) =
        static_cast<::QDtls::HandshakeState>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QDtls_HandshakeState_PythonToCpp_QDtls_HandshakeState_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QDTLS_HANDSHAKESTATE_IDX]))
        return QDtls_HandshakeState_PythonToCpp_QDtls_HandshakeState;
    return {};
}
static PyObject *QDtls_HandshakeState_CppToPython_QDtls_HandshakeState(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QDtls::HandshakeState *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QDTLS_HANDSHAKESTATE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QDtls_PythonToCpp_QDtls_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QDtls_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QDtls_PythonToCpp_QDtls_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QDtls_TypeF())))
        return QDtls_PythonToCpp_QDtls_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QDtls_PTR_CppToPython_QDtls(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QDtls *>(const_cast<void *>(cppIn)), Sbk_QDtls_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QDtls_SignatureStrings[] = {
    "PySide2.QtNetwork.QDtls(self,mode:PySide2.QtNetwork.QSslSocket.SslMode,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtNetwork.QDtls.abortHandshake(self,socket:PySide2.QtNetwork.QUdpSocket)->bool",
    "PySide2.QtNetwork.QDtls.decryptDatagram(self,socket:PySide2.QtNetwork.QUdpSocket,dgram:PySide2.QtCore.QByteArray)->PySide2.QtCore.QByteArray",
    "PySide2.QtNetwork.QDtls.doHandshake(self,socket:PySide2.QtNetwork.QUdpSocket,dgram:PySide2.QtCore.QByteArray={})->bool",
    "PySide2.QtNetwork.QDtls.dtlsConfiguration(self)->PySide2.QtNetwork.QSslConfiguration",
    "PySide2.QtNetwork.QDtls.dtlsError(self)->PySide2.QtNetwork.QDtlsError",
    "PySide2.QtNetwork.QDtls.dtlsErrorString(self)->QString",
    "PySide2.QtNetwork.QDtls.handleTimeout(self,socket:PySide2.QtNetwork.QUdpSocket)->bool",
    "PySide2.QtNetwork.QDtls.handshakeState(self)->PySide2.QtNetwork.QDtls.HandshakeState",
    "PySide2.QtNetwork.QDtls.ignoreVerificationErrors(self,errorsToIgnore:QVector[PySide2.QtNetwork.QSslError])",
    "PySide2.QtNetwork.QDtls.isConnectionEncrypted(self)->bool",
    "PySide2.QtNetwork.QDtls.mtuHint(self)->quint16",
    "PySide2.QtNetwork.QDtls.peerAddress(self)->PySide2.QtNetwork.QHostAddress",
    "PySide2.QtNetwork.QDtls.peerPort(self)->quint16",
    "PySide2.QtNetwork.QDtls.peerVerificationErrors(self)->QVector[PySide2.QtNetwork.QSslError]",
    "PySide2.QtNetwork.QDtls.peerVerificationName(self)->QString",
    "PySide2.QtNetwork.QDtls.resumeHandshake(self,socket:PySide2.QtNetwork.QUdpSocket)->bool",
    "PySide2.QtNetwork.QDtls.sessionCipher(self)->PySide2.QtNetwork.QSslCipher",
    "PySide2.QtNetwork.QDtls.sessionProtocol(self)->PySide2.QtNetwork.QSsl.SslProtocol",
    "PySide2.QtNetwork.QDtls.setDtlsConfiguration(self,configuration:PySide2.QtNetwork.QSslConfiguration)->bool",
    "PySide2.QtNetwork.QDtls.setMtuHint(self,mtuHint:quint16)",
    "PySide2.QtNetwork.QDtls.setPeer(self,address:PySide2.QtNetwork.QHostAddress,port:quint16,verificationName:QString={})->bool",
    "PySide2.QtNetwork.QDtls.setPeerVerificationName(self,name:QString)->bool",
    "PySide2.QtNetwork.QDtls.shutdown(self,socket:PySide2.QtNetwork.QUdpSocket)->bool",
    "PySide2.QtNetwork.QDtls.sslMode(self)->PySide2.QtNetwork.QSslSocket.SslMode",
    "PySide2.QtNetwork.QDtls.writeDatagramEncrypted(self,socket:PySide2.QtNetwork.QUdpSocket,dgram:PySide2.QtCore.QByteArray)->qint64",
    nullptr}; // Sentinel

void init_QDtls(PyObject *module)
{
    _Sbk_QDtls_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QDtls",
        "QDtls*",
        &Sbk_QDtls_spec,
        &Shiboken::callCppDestructor< ::QDtls >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QDtls_Type);
    InitSignatureStrings(pyType, QDtls_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QDtls_Type), Sbk_QDtls_PropertyStrings);
    SbkPySide2_QtNetworkTypes[SBK_QDTLS_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QDtls_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QDtls_TypeF(),
        QDtls_PythonToCpp_QDtls_PTR,
        is_QDtls_PythonToCpp_QDtls_PTR_Convertible,
        QDtls_PTR_CppToPython_QDtls);

    Shiboken::Conversions::registerConverterName(converter, "QDtls");
    Shiboken::Conversions::registerConverterName(converter, "QDtls*");
    Shiboken::Conversions::registerConverterName(converter, "QDtls&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QDtls).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QDtlsWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QDtls_TypeF(), &Sbk_QDtls_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'HandshakeState'.
    SbkPySide2_QtNetworkTypes[SBK_QDTLS_HANDSHAKESTATE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QDtls_TypeF(),
        "HandshakeState",
        "2:PySide2.QtNetwork.QDtls.HandshakeState",
        "QDtls::HandshakeState");
    if (!SbkPySide2_QtNetworkTypes[SBK_QDTLS_HANDSHAKESTATE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QDTLS_HANDSHAKESTATE_IDX],
        Sbk_QDtls_TypeF(), "HandshakeNotStarted", (long) QDtls::HandshakeState::HandshakeNotStarted))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QDTLS_HANDSHAKESTATE_IDX],
        Sbk_QDtls_TypeF(), "HandshakeInProgress", (long) QDtls::HandshakeState::HandshakeInProgress))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QDTLS_HANDSHAKESTATE_IDX],
        Sbk_QDtls_TypeF(), "PeerVerificationFailed", (long) QDtls::HandshakeState::PeerVerificationFailed))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QDTLS_HANDSHAKESTATE_IDX],
        Sbk_QDtls_TypeF(), "HandshakeComplete", (long) QDtls::HandshakeState::HandshakeComplete))
        return;
    // Register converter for enum 'QDtls::HandshakeState'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QDTLS_HANDSHAKESTATE_IDX],
            QDtls_HandshakeState_CppToPython_QDtls_HandshakeState);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QDtls_HandshakeState_PythonToCpp_QDtls_HandshakeState,
            is_QDtls_HandshakeState_PythonToCpp_QDtls_HandshakeState_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QDTLS_HANDSHAKESTATE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QDtls::HandshakeState");
        Shiboken::Conversions::registerConverterName(converter, "HandshakeState");
    }
    // End of 'HandshakeState' enum.

    PySide::Signal::registerSignals(Sbk_QDtls_TypeF(), &::QDtls::staticMetaObject);
    qRegisterMetaType< ::QDtls::HandshakeState >("QDtls::HandshakeState");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QDtls_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QDtls_TypeF(), &::QDtls::staticMetaObject, sizeof(QDtlsWrapper));
}
