/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtnetwork_python.h"

// main header
#include "qdnslookup_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QDnsLookupWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QDnsLookupWrapper::QDnsLookupWrapper(::QDnsLookup::Type type, const ::QString & name, ::QObject * parent) : QDnsLookup(type, name, parent)
{
    resetPyMethodCache();
    // ... middle
}

QDnsLookupWrapper::QDnsLookupWrapper(::QDnsLookup::Type type, const ::QString & name, const ::QHostAddress & nameserver, ::QObject * parent) : QDnsLookup(type, name, nameserver, parent)
{
    resetPyMethodCache();
    // ... middle
}

QDnsLookupWrapper::QDnsLookupWrapper(::QObject * parent) : QDnsLookup(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QDnsLookupWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QDnsLookupWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QDnsLookupWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QDnsLookupWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QDnsLookupWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QDnsLookup.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QDnsLookupWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QDnsLookup.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QDnsLookupWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QDnsLookupWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QDnsLookup::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QDnsLookupWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QDnsLookup::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QDnsLookupWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QDnsLookupWrapper *>(this));
        return QDnsLookup::qt_metacast(_clname);
}

QDnsLookupWrapper::~QDnsLookupWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QDnsLookup_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QDnsLookup >()))
        return -1;

    ::QDnsLookupWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDnsLookup.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|OOOO:QDnsLookup", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return -1;


    // Overloaded function decisor
    // 0: QDnsLookup::QDnsLookup(QDnsLookup::Type,QString,QObject*)
    // 1: QDnsLookup::QDnsLookup(QDnsLookup::Type,QString,QHostAddress,QObject*)
    // 2: QDnsLookup::QDnsLookup(QObject*)
    if (numArgs == 0) {
        overloadId = 2; // QDnsLookup(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QDnsLookup(QObject*)
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_TYPE_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // QDnsLookup(QDnsLookup::Type,QString,QObject*)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 1; // QDnsLookup(QDnsLookup::Type,QString,QHostAddress,QObject*)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[3])))) {
                overloadId = 1; // QDnsLookup(QDnsLookup::Type,QString,QHostAddress,QObject*)
            }
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[2])))) {
            overloadId = 0; // QDnsLookup(QDnsLookup::Type,QString,QObject*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDnsLookup_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QDnsLookup(QDnsLookup::Type type, const QString & name, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[2]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QDnsLookup_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[2]))))
                            goto Sbk_QDnsLookup_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            ::QDnsLookup::Type cppArg0 = static_cast< ::QDnsLookup::Type>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QObject *cppArg2 = nullptr;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QDnsLookup(QDnsLookup::Type,QString,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QDnsLookupWrapper(cppArg0, cppArg1, cppArg2);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QDnsLookupWrapper(cppArg0, cppArg1, cppArg2);
                }

                Shiboken::Object::setParent(pyArgs[2], self);
            }
            break;
        }
        case 1: // QDnsLookup(QDnsLookup::Type type, const QString & name, const QHostAddress & nameserver, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[3]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QDnsLookup_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[3]))))
                            goto Sbk_QDnsLookup_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            ::QDnsLookup::Type cppArg0 = static_cast< ::QDnsLookup::Type>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QHostAddress cppArg2_local;
            ::QHostAddress *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!Shiboken::Object::isValid(pyArgs[3]))
                return -1;
            ::QObject *cppArg3 = nullptr;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // QDnsLookup(QDnsLookup::Type,QString,QHostAddress,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QDnsLookupWrapper(cppArg0, cppArg1, *cppArg2, cppArg3);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QDnsLookupWrapper(cppArg0, cppArg1, *cppArg2, cppArg3);
                }

                Shiboken::Object::setParent(pyArgs[3], self);
            }
            break;
        }
        case 2: // QDnsLookup(QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[0]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QDnsLookup_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                            goto Sbk_QDnsLookup_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0 = nullptr;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QDnsLookup(QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QDnsLookupWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QDnsLookupWrapper(cppArg0);
                }

                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QDnsLookup >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QDnsLookup_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QDnsLookup_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QDnsLookup_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QDnsLookupFunc_abort(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDnsLookup *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDnsLookup.abort";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // abort()
            cppSelf->abort();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QDnsLookupFunc_canonicalNameRecords(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDnsLookup *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDnsLookup.canonicalNameRecords";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // canonicalNameRecords()const
            QList<QDnsDomainNameRecord > cppResult = const_cast<const ::QDnsLookup *>(cppSelf)->canonicalNameRecords();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QDNSDOMAINNAMERECORD_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDnsLookupFunc_error(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDnsLookup *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDnsLookup.error";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // error()const
            QDnsLookup::Error cppResult = const_cast<const ::QDnsLookup *>(cppSelf)->error();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_ERROR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDnsLookupFunc_errorString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDnsLookup *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDnsLookup.errorString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // errorString()const
            QString cppResult = const_cast<const ::QDnsLookup *>(cppSelf)->errorString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDnsLookupFunc_hostAddressRecords(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDnsLookup *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDnsLookup.hostAddressRecords";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hostAddressRecords()const
            QList<QDnsHostAddressRecord > cppResult = const_cast<const ::QDnsLookup *>(cppSelf)->hostAddressRecords();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QDNSHOSTADDRESSRECORD_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDnsLookupFunc_isFinished(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDnsLookup *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDnsLookup.isFinished";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isFinished()const
            bool cppResult = const_cast<const ::QDnsLookup *>(cppSelf)->isFinished();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDnsLookupFunc_lookup(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDnsLookup *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDnsLookup.lookup";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lookup()
            cppSelf->lookup();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QDnsLookupFunc_mailExchangeRecords(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDnsLookup *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDnsLookup.mailExchangeRecords";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mailExchangeRecords()const
            QList<QDnsMailExchangeRecord > cppResult = const_cast<const ::QDnsLookup *>(cppSelf)->mailExchangeRecords();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QDNSMAILEXCHANGERECORD_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDnsLookupFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDnsLookup *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDnsLookup.name";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // name()const
            QString cppResult = const_cast<const ::QDnsLookup *>(cppSelf)->name();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDnsLookupFunc_nameServerRecords(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDnsLookup *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDnsLookup.nameServerRecords";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // nameServerRecords()const
            QList<QDnsDomainNameRecord > cppResult = const_cast<const ::QDnsLookup *>(cppSelf)->nameServerRecords();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QDNSDOMAINNAMERECORD_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDnsLookupFunc_nameserver(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDnsLookup *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDnsLookup.nameserver";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // nameserver()const
            QHostAddress cppResult = const_cast<const ::QDnsLookup *>(cppSelf)->nameserver();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDnsLookupFunc_pointerRecords(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDnsLookup *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDnsLookup.pointerRecords";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pointerRecords()const
            QList<QDnsDomainNameRecord > cppResult = const_cast<const ::QDnsLookup *>(cppSelf)->pointerRecords();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QDNSDOMAINNAMERECORD_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDnsLookupFunc_serviceRecords(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDnsLookup *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDnsLookup.serviceRecords";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // serviceRecords()const
            QList<QDnsServiceRecord > cppResult = const_cast<const ::QDnsLookup *>(cppSelf)->serviceRecords();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QDNSSERVICERECORD_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDnsLookupFunc_setName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDnsLookup *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDnsLookup.setName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDnsLookup::setName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDnsLookupFunc_setName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setName(QString)
            cppSelf->setName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDnsLookupFunc_setName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDnsLookupFunc_setNameserver(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDnsLookup *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDnsLookup.setNameserver";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDnsLookup::setNameserver(QHostAddress)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), (pyArg)))) {
        overloadId = 0; // setNameserver(QHostAddress)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDnsLookupFunc_setNameserver_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QHostAddress cppArg0_local;
        ::QHostAddress *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setNameserver(QHostAddress)
            cppSelf->setNameserver(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDnsLookupFunc_setNameserver_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDnsLookupFunc_setType(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDnsLookup *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDnsLookup.setType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDnsLookup::setType(QDnsLookup::Type)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_TYPE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setType(QDnsLookup::Type)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QDnsLookupFunc_setType_TypeError;

    // Call function/method
    {
        ::QDnsLookup::Type cppArg0 = static_cast< ::QDnsLookup::Type>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setType(QDnsLookup::Type)
            cppSelf->setType(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QDnsLookupFunc_setType_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QDnsLookupFunc_textRecords(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDnsLookup *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDnsLookup.textRecords";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // textRecords()const
            QList<QDnsTextRecord > cppResult = const_cast<const ::QDnsLookup *>(cppSelf)->textRecords();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtNetworkTypeConverters[SBK_QTNETWORK_QLIST_QDNSTEXTRECORD_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QDnsLookupFunc_type(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QDnsLookup *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtNetwork.QDnsLookup.type";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // type()const
            QDnsLookup::Type cppResult = const_cast<const ::QDnsLookup *>(cppSelf)->type();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_TYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QDnsLookup_PropertyStrings[] = {
    "error:",
    "errorString:",
    "name::",
    "nameserver::",
    "type::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QDnsLookup_methods[] = {
    {"abort", reinterpret_cast<PyCFunction>(Sbk_QDnsLookupFunc_abort), METH_NOARGS},
    {"canonicalNameRecords", reinterpret_cast<PyCFunction>(Sbk_QDnsLookupFunc_canonicalNameRecords), METH_NOARGS},
    {"error", reinterpret_cast<PyCFunction>(Sbk_QDnsLookupFunc_error), METH_NOARGS},
    {"errorString", reinterpret_cast<PyCFunction>(Sbk_QDnsLookupFunc_errorString), METH_NOARGS},
    {"hostAddressRecords", reinterpret_cast<PyCFunction>(Sbk_QDnsLookupFunc_hostAddressRecords), METH_NOARGS},
    {"isFinished", reinterpret_cast<PyCFunction>(Sbk_QDnsLookupFunc_isFinished), METH_NOARGS},
    {"lookup", reinterpret_cast<PyCFunction>(Sbk_QDnsLookupFunc_lookup), METH_NOARGS},
    {"mailExchangeRecords", reinterpret_cast<PyCFunction>(Sbk_QDnsLookupFunc_mailExchangeRecords), METH_NOARGS},
    {"name", reinterpret_cast<PyCFunction>(Sbk_QDnsLookupFunc_name), METH_NOARGS},
    {"nameServerRecords", reinterpret_cast<PyCFunction>(Sbk_QDnsLookupFunc_nameServerRecords), METH_NOARGS},
    {"nameserver", reinterpret_cast<PyCFunction>(Sbk_QDnsLookupFunc_nameserver), METH_NOARGS},
    {"pointerRecords", reinterpret_cast<PyCFunction>(Sbk_QDnsLookupFunc_pointerRecords), METH_NOARGS},
    {"serviceRecords", reinterpret_cast<PyCFunction>(Sbk_QDnsLookupFunc_serviceRecords), METH_NOARGS},
    {"setName", reinterpret_cast<PyCFunction>(Sbk_QDnsLookupFunc_setName), METH_O},
    {"setNameserver", reinterpret_cast<PyCFunction>(Sbk_QDnsLookupFunc_setNameserver), METH_O},
    {"setType", reinterpret_cast<PyCFunction>(Sbk_QDnsLookupFunc_setType), METH_O},
    {"textRecords", reinterpret_cast<PyCFunction>(Sbk_QDnsLookupFunc_textRecords), METH_NOARGS},
    {"type", reinterpret_cast<PyCFunction>(Sbk_QDnsLookupFunc_type), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QDnsLookup_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QDnsLookup *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QDnsLookupWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QDnsLookup_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QDnsLookup_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QDnsLookup_Type = nullptr;
static SbkObjectType *Sbk_QDnsLookup_TypeF(void)
{
    return _Sbk_QDnsLookup_Type;
}

static PyType_Slot Sbk_QDnsLookup_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QDnsLookup_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QDnsLookup_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QDnsLookup_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QDnsLookup_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QDnsLookup_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QDnsLookup_spec = {
    "2:PySide2.QtNetwork.QDnsLookup",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QDnsLookup_slots
};

} //extern "C"

static void *Sbk_QDnsLookup_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QDnsLookup *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QDnsLookup_Error_PythonToCpp_QDnsLookup_Error(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QDnsLookup::Error *>(cppOut) =
        static_cast<::QDnsLookup::Error>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QDnsLookup_Error_PythonToCpp_QDnsLookup_Error_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_ERROR_IDX]))
        return QDnsLookup_Error_PythonToCpp_QDnsLookup_Error;
    return {};
}
static PyObject *QDnsLookup_Error_CppToPython_QDnsLookup_Error(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QDnsLookup::Error *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_ERROR_IDX], castCppIn);

}

static void QDnsLookup_Type_PythonToCpp_QDnsLookup_Type(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QDnsLookup::Type *>(cppOut) =
        static_cast<::QDnsLookup::Type>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QDnsLookup_Type_PythonToCpp_QDnsLookup_Type_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_TYPE_IDX]))
        return QDnsLookup_Type_PythonToCpp_QDnsLookup_Type;
    return {};
}
static PyObject *QDnsLookup_Type_CppToPython_QDnsLookup_Type(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QDnsLookup::Type *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_TYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QDnsLookup_PythonToCpp_QDnsLookup_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QDnsLookup_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QDnsLookup_PythonToCpp_QDnsLookup_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QDnsLookup_TypeF())))
        return QDnsLookup_PythonToCpp_QDnsLookup_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QDnsLookup_PTR_CppToPython_QDnsLookup(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QDnsLookup *>(const_cast<void *>(cppIn)), Sbk_QDnsLookup_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QDnsLookup_SignatureStrings[] = {
    "2:PySide2.QtNetwork.QDnsLookup(self,type:PySide2.QtNetwork.QDnsLookup.Type,name:QString,parent:PySide2.QtCore.QObject=nullptr)",
    "1:PySide2.QtNetwork.QDnsLookup(self,type:PySide2.QtNetwork.QDnsLookup.Type,name:QString,nameserver:PySide2.QtNetwork.QHostAddress,parent:PySide2.QtCore.QObject=nullptr)",
    "0:PySide2.QtNetwork.QDnsLookup(self,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtNetwork.QDnsLookup.abort(self)",
    "PySide2.QtNetwork.QDnsLookup.canonicalNameRecords(self)->QList[PySide2.QtNetwork.QDnsDomainNameRecord]",
    "PySide2.QtNetwork.QDnsLookup.error(self)->PySide2.QtNetwork.QDnsLookup.Error",
    "PySide2.QtNetwork.QDnsLookup.errorString(self)->QString",
    "PySide2.QtNetwork.QDnsLookup.hostAddressRecords(self)->QList[PySide2.QtNetwork.QDnsHostAddressRecord]",
    "PySide2.QtNetwork.QDnsLookup.isFinished(self)->bool",
    "PySide2.QtNetwork.QDnsLookup.lookup(self)",
    "PySide2.QtNetwork.QDnsLookup.mailExchangeRecords(self)->QList[PySide2.QtNetwork.QDnsMailExchangeRecord]",
    "PySide2.QtNetwork.QDnsLookup.name(self)->QString",
    "PySide2.QtNetwork.QDnsLookup.nameServerRecords(self)->QList[PySide2.QtNetwork.QDnsDomainNameRecord]",
    "PySide2.QtNetwork.QDnsLookup.nameserver(self)->PySide2.QtNetwork.QHostAddress",
    "PySide2.QtNetwork.QDnsLookup.pointerRecords(self)->QList[PySide2.QtNetwork.QDnsDomainNameRecord]",
    "PySide2.QtNetwork.QDnsLookup.serviceRecords(self)->QList[PySide2.QtNetwork.QDnsServiceRecord]",
    "PySide2.QtNetwork.QDnsLookup.setName(self,name:QString)",
    "PySide2.QtNetwork.QDnsLookup.setNameserver(self,nameserver:PySide2.QtNetwork.QHostAddress)",
    "PySide2.QtNetwork.QDnsLookup.setType(self,arg__1:PySide2.QtNetwork.QDnsLookup.Type)",
    "PySide2.QtNetwork.QDnsLookup.textRecords(self)->QList[PySide2.QtNetwork.QDnsTextRecord]",
    "PySide2.QtNetwork.QDnsLookup.type(self)->PySide2.QtNetwork.QDnsLookup.Type",
    nullptr}; // Sentinel

void init_QDnsLookup(PyObject *module)
{
    _Sbk_QDnsLookup_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QDnsLookup",
        "QDnsLookup*",
        &Sbk_QDnsLookup_spec,
        &Shiboken::callCppDestructor< ::QDnsLookup >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QDnsLookup_Type);
    InitSignatureStrings(pyType, QDnsLookup_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QDnsLookup_Type), Sbk_QDnsLookup_PropertyStrings);
    SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QDnsLookup_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QDnsLookup_TypeF(),
        QDnsLookup_PythonToCpp_QDnsLookup_PTR,
        is_QDnsLookup_PythonToCpp_QDnsLookup_PTR_Convertible,
        QDnsLookup_PTR_CppToPython_QDnsLookup);

    Shiboken::Conversions::registerConverterName(converter, "QDnsLookup");
    Shiboken::Conversions::registerConverterName(converter, "QDnsLookup*");
    Shiboken::Conversions::registerConverterName(converter, "QDnsLookup&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QDnsLookup).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QDnsLookupWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QDnsLookup_TypeF(), &Sbk_QDnsLookup_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'Error'.
    SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_ERROR_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QDnsLookup_TypeF(),
        "Error",
        "2:PySide2.QtNetwork.QDnsLookup.Error",
        "QDnsLookup::Error");
    if (!SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_ERROR_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_ERROR_IDX],
        Sbk_QDnsLookup_TypeF(), "NoError", (long) QDnsLookup::Error::NoError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_ERROR_IDX],
        Sbk_QDnsLookup_TypeF(), "ResolverError", (long) QDnsLookup::Error::ResolverError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_ERROR_IDX],
        Sbk_QDnsLookup_TypeF(), "OperationCancelledError", (long) QDnsLookup::Error::OperationCancelledError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_ERROR_IDX],
        Sbk_QDnsLookup_TypeF(), "InvalidRequestError", (long) QDnsLookup::Error::InvalidRequestError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_ERROR_IDX],
        Sbk_QDnsLookup_TypeF(), "InvalidReplyError", (long) QDnsLookup::Error::InvalidReplyError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_ERROR_IDX],
        Sbk_QDnsLookup_TypeF(), "ServerFailureError", (long) QDnsLookup::Error::ServerFailureError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_ERROR_IDX],
        Sbk_QDnsLookup_TypeF(), "ServerRefusedError", (long) QDnsLookup::Error::ServerRefusedError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_ERROR_IDX],
        Sbk_QDnsLookup_TypeF(), "NotFoundError", (long) QDnsLookup::Error::NotFoundError))
        return;
    // Register converter for enum 'QDnsLookup::Error'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_ERROR_IDX],
            QDnsLookup_Error_CppToPython_QDnsLookup_Error);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QDnsLookup_Error_PythonToCpp_QDnsLookup_Error,
            is_QDnsLookup_Error_PythonToCpp_QDnsLookup_Error_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_ERROR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QDnsLookup::Error");
        Shiboken::Conversions::registerConverterName(converter, "Error");
    }
    // End of 'Error' enum.

    // Initialization of enum 'Type'.
    SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_TYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QDnsLookup_TypeF(),
        "Type",
        "2:PySide2.QtNetwork.QDnsLookup.Type",
        "QDnsLookup::Type");
    if (!SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_TYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_TYPE_IDX],
        Sbk_QDnsLookup_TypeF(), "A", (long) QDnsLookup::Type::A))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_TYPE_IDX],
        Sbk_QDnsLookup_TypeF(), "AAAA", (long) QDnsLookup::Type::AAAA))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_TYPE_IDX],
        Sbk_QDnsLookup_TypeF(), "ANY", (long) QDnsLookup::Type::ANY))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_TYPE_IDX],
        Sbk_QDnsLookup_TypeF(), "CNAME", (long) QDnsLookup::Type::CNAME))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_TYPE_IDX],
        Sbk_QDnsLookup_TypeF(), "MX", (long) QDnsLookup::Type::MX))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_TYPE_IDX],
        Sbk_QDnsLookup_TypeF(), "NS", (long) QDnsLookup::Type::NS))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_TYPE_IDX],
        Sbk_QDnsLookup_TypeF(), "PTR", (long) QDnsLookup::Type::PTR))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_TYPE_IDX],
        Sbk_QDnsLookup_TypeF(), "SRV", (long) QDnsLookup::Type::SRV))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_TYPE_IDX],
        Sbk_QDnsLookup_TypeF(), "TXT", (long) QDnsLookup::Type::TXT))
        return;
    // Register converter for enum 'QDnsLookup::Type'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_TYPE_IDX],
            QDnsLookup_Type_CppToPython_QDnsLookup_Type);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QDnsLookup_Type_PythonToCpp_QDnsLookup_Type,
            is_QDnsLookup_Type_PythonToCpp_QDnsLookup_Type_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtNetworkTypes[SBK_QDNSLOOKUP_TYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QDnsLookup::Type");
        Shiboken::Conversions::registerConverterName(converter, "Type");
    }
    // End of 'Type' enum.

    PySide::Signal::registerSignals(Sbk_QDnsLookup_TypeF(), &::QDnsLookup::staticMetaObject);
    qRegisterMetaType< ::QDnsLookup::Error >("QDnsLookup::Error");
    qRegisterMetaType< ::QDnsLookup::Type >("QDnsLookup::Type");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QDnsLookup_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QDnsLookup_TypeF(), &::QDnsLookup::staticMetaObject, sizeof(QDnsLookupWrapper));
}
