/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtmultimedia_python.h"

// main header
#include "qvideosurfaceformat_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <QtMultimedia/qvideosurfaceformat.h>
#include <qbytearray.h>
#include <qrect.h>
#include <qsize.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QVideoSurfaceFormat_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QVideoSurfaceFormat >()))
        return -1;

    ::QVideoSurfaceFormat *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoSurfaceFormat.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QVideoSurfaceFormat_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:QVideoSurfaceFormat", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return -1;


    // Overloaded function decisor
    // 0: QVideoSurfaceFormat::QVideoSurfaceFormat()
    // 1: QVideoSurfaceFormat::QVideoSurfaceFormat(QSize,QVideoFrame::PixelFormat,QAbstractVideoBuffer::HandleType)
    // 2: QVideoSurfaceFormat::QVideoSurfaceFormat(QVideoSurfaceFormat)
    if (numArgs == 0) {
        overloadId = 0; // QVideoSurfaceFormat()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QVideoSurfaceFormat(QVideoSurfaceFormat)
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX])->converter, (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 1; // QVideoSurfaceFormat(QSize,QVideoFrame::PixelFormat,QAbstractVideoBuffer::HandleType)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_HANDLETYPE_IDX])->converter, (pyArgs[2])))) {
            overloadId = 1; // QVideoSurfaceFormat(QSize,QVideoFrame::PixelFormat,QAbstractVideoBuffer::HandleType)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVideoSurfaceFormat_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QVideoSurfaceFormat()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QVideoSurfaceFormat_Init_TypeError;
            }

            if (!PyErr_Occurred()) {
                // QVideoSurfaceFormat()
                cptr = new ::QVideoSurfaceFormat();
            }
            break;
        }
        case 1: // QVideoSurfaceFormat(const QSize & size, QVideoFrame::PixelFormat pixelFormat, QAbstractVideoBuffer::HandleType handleType)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_handleType = Shiboken::String::createStaticString("handleType");
                if (PyDict_Contains(kwds, key_handleType)) {
                    value = PyDict_GetItem(kwds, key_handleType);
                    if (value && pyArgs[2]) {
                        errInfo = key_handleType;
                        Py_INCREF(errInfo);
                        goto Sbk_QVideoSurfaceFormat_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_HANDLETYPE_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QVideoSurfaceFormat_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_handleType);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QVideoSurfaceFormat_Init_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QSize cppArg0_local;
            ::QSize *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QVideoFrame::PixelFormat cppArg1{QVideoFrame::Format_Invalid};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QAbstractVideoBuffer::HandleType cppArg2 = QAbstractVideoBuffer::NoHandle;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QVideoSurfaceFormat(QSize,QVideoFrame::PixelFormat,QAbstractVideoBuffer::HandleType)
                cptr = new ::QVideoSurfaceFormat(*cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 2: // QVideoSurfaceFormat(const QVideoSurfaceFormat & format)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QVideoSurfaceFormat_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QVideoSurfaceFormat cppArg0_local;
            ::QVideoSurfaceFormat *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QVideoSurfaceFormat(QVideoSurfaceFormat)
                cptr = new ::QVideoSurfaceFormat(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QVideoSurfaceFormat >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QVideoSurfaceFormat_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QVideoSurfaceFormat_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QVideoSurfaceFormatFunc_frameHeight(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoSurfaceFormat.frameHeight";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // frameHeight()const
            int cppResult = const_cast<const ::QVideoSurfaceFormat *>(cppSelf)->frameHeight();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVideoSurfaceFormatFunc_frameRate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoSurfaceFormat.frameRate";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // frameRate()const
            qreal cppResult = const_cast<const ::QVideoSurfaceFormat *>(cppSelf)->frameRate();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVideoSurfaceFormatFunc_frameSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoSurfaceFormat.frameSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // frameSize()const
            QSize cppResult = const_cast<const ::QVideoSurfaceFormat *>(cppSelf)->frameSize();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVideoSurfaceFormatFunc_frameWidth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoSurfaceFormat.frameWidth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // frameWidth()const
            int cppResult = const_cast<const ::QVideoSurfaceFormat *>(cppSelf)->frameWidth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVideoSurfaceFormatFunc_handleType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoSurfaceFormat.handleType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // handleType()const
            QAbstractVideoBuffer::HandleType cppResult = const_cast<const ::QVideoSurfaceFormat *>(cppSelf)->handleType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_HANDLETYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVideoSurfaceFormatFunc_isMirrored(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoSurfaceFormat.isMirrored";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isMirrored()const
            bool cppResult = const_cast<const ::QVideoSurfaceFormat *>(cppSelf)->isMirrored();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVideoSurfaceFormatFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoSurfaceFormat.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QVideoSurfaceFormat *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVideoSurfaceFormatFunc_pixelAspectRatio(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoSurfaceFormat.pixelAspectRatio";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pixelAspectRatio()const
            QSize cppResult = const_cast<const ::QVideoSurfaceFormat *>(cppSelf)->pixelAspectRatio();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVideoSurfaceFormatFunc_pixelFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoSurfaceFormat.pixelFormat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pixelFormat()const
            QVideoFrame::PixelFormat cppResult = const_cast<const ::QVideoSurfaceFormat *>(cppSelf)->pixelFormat();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVideoSurfaceFormatFunc_property(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoSurfaceFormat.property";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QVideoSurfaceFormat::property(const char*)const
    if (Shiboken::String::check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 0; // property(const char*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVideoSurfaceFormatFunc_property_TypeError;

    // Call function/method
    {
        const char* cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // property(const char*)const
            QVariant cppResult = const_cast<const ::QVideoSurfaceFormat *>(cppSelf)->property(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QVideoSurfaceFormatFunc_property_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVideoSurfaceFormatFunc_propertyNames(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoSurfaceFormat.propertyNames";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // propertyNames()const
            QList<QByteArray > cppResult = const_cast<const ::QVideoSurfaceFormat *>(cppSelf)->propertyNames();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QBYTEARRAY_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVideoSurfaceFormatFunc_scanLineDirection(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoSurfaceFormat.scanLineDirection";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // scanLineDirection()const
            QVideoSurfaceFormat::Direction cppResult = const_cast<const ::QVideoSurfaceFormat *>(cppSelf)->scanLineDirection();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_DIRECTION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVideoSurfaceFormatFunc_setFrameRate(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoSurfaceFormat.setFrameRate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QVideoSurfaceFormat::setFrameRate(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setFrameRate(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVideoSurfaceFormatFunc_setFrameRate_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFrameRate(qreal)
            cppSelf->setFrameRate(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QVideoSurfaceFormatFunc_setFrameRate_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVideoSurfaceFormatFunc_setFrameSize(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoSurfaceFormat.setFrameSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setFrameSize", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QVideoSurfaceFormat::setFrameSize(QSize)
    // 1: QVideoSurfaceFormat::setFrameSize(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 1; // setFrameSize(int,int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[0])))) {
        overloadId = 0; // setFrameSize(QSize)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVideoSurfaceFormatFunc_setFrameSize_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setFrameSize(const QSize & size)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QSize cppArg0_local;
            ::QSize *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // setFrameSize(QSize)
                cppSelf->setFrameSize(*cppArg0);
            }
            break;
        }
        case 1: // setFrameSize(int width, int height)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setFrameSize(int,int)
                cppSelf->setFrameSize(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QVideoSurfaceFormatFunc_setFrameSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVideoSurfaceFormatFunc_setMirrored(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoSurfaceFormat.setMirrored";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QVideoSurfaceFormat::setMirrored(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setMirrored(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVideoSurfaceFormatFunc_setMirrored_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMirrored(bool)
            cppSelf->setMirrored(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QVideoSurfaceFormatFunc_setMirrored_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVideoSurfaceFormatFunc_setPixelAspectRatio(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoSurfaceFormat.setPixelAspectRatio";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setPixelAspectRatio", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QVideoSurfaceFormat::setPixelAspectRatio(QSize)
    // 1: QVideoSurfaceFormat::setPixelAspectRatio(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 1; // setPixelAspectRatio(int,int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[0])))) {
        overloadId = 0; // setPixelAspectRatio(QSize)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVideoSurfaceFormatFunc_setPixelAspectRatio_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setPixelAspectRatio(const QSize & ratio)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QSize cppArg0_local;
            ::QSize *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // setPixelAspectRatio(QSize)
                cppSelf->setPixelAspectRatio(*cppArg0);
            }
            break;
        }
        case 1: // setPixelAspectRatio(int width, int height)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setPixelAspectRatio(int,int)
                cppSelf->setPixelAspectRatio(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QVideoSurfaceFormatFunc_setPixelAspectRatio_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVideoSurfaceFormatFunc_setProperty(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoSurfaceFormat.setProperty";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setProperty", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QVideoSurfaceFormat::setProperty(const char*,QVariant)
    if (numArgs == 2
        && Shiboken::String::check(pyArgs[0]) && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[1])))) {
        overloadId = 0; // setProperty(const char*,QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVideoSurfaceFormatFunc_setProperty_TypeError;

    // Call function/method
    {
        const char* cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QVariant cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setProperty(const char*,QVariant)
            cppSelf->setProperty(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QVideoSurfaceFormatFunc_setProperty_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVideoSurfaceFormatFunc_setScanLineDirection(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoSurfaceFormat.setScanLineDirection";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QVideoSurfaceFormat::setScanLineDirection(QVideoSurfaceFormat::Direction)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_DIRECTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setScanLineDirection(QVideoSurfaceFormat::Direction)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVideoSurfaceFormatFunc_setScanLineDirection_TypeError;

    // Call function/method
    {
        ::QVideoSurfaceFormat::Direction cppArg0{QVideoSurfaceFormat::TopToBottom};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setScanLineDirection(QVideoSurfaceFormat::Direction)
            cppSelf->setScanLineDirection(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QVideoSurfaceFormatFunc_setScanLineDirection_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVideoSurfaceFormatFunc_setViewport(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoSurfaceFormat.setViewport";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QVideoSurfaceFormat::setViewport(QRect)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArg)))) {
        overloadId = 0; // setViewport(QRect)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVideoSurfaceFormatFunc_setViewport_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QRect cppArg0_local;
        ::QRect *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setViewport(QRect)
            cppSelf->setViewport(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QVideoSurfaceFormatFunc_setViewport_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVideoSurfaceFormatFunc_setYCbCrColorSpace(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoSurfaceFormat.setYCbCrColorSpace";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QVideoSurfaceFormat::setYCbCrColorSpace(QVideoSurfaceFormat::YCbCrColorSpace)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_YCBCRCOLORSPACE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setYCbCrColorSpace(QVideoSurfaceFormat::YCbCrColorSpace)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVideoSurfaceFormatFunc_setYCbCrColorSpace_TypeError;

    // Call function/method
    {
        ::QVideoSurfaceFormat::YCbCrColorSpace cppArg0{QVideoSurfaceFormat::YCbCr_Undefined};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setYCbCrColorSpace(QVideoSurfaceFormat::YCbCrColorSpace)
            cppSelf->setYCbCrColorSpace(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QVideoSurfaceFormatFunc_setYCbCrColorSpace_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVideoSurfaceFormatFunc_sizeHint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoSurfaceFormat.sizeHint";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sizeHint()const
            QSize cppResult = const_cast<const ::QVideoSurfaceFormat *>(cppSelf)->sizeHint();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVideoSurfaceFormatFunc_viewport(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoSurfaceFormat.viewport";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // viewport()const
            QRect cppResult = const_cast<const ::QVideoSurfaceFormat *>(cppSelf)->viewport();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVideoSurfaceFormatFunc_yCbCrColorSpace(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoSurfaceFormat.yCbCrColorSpace";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // yCbCrColorSpace()const
            QVideoSurfaceFormat::YCbCrColorSpace cppResult = const_cast<const ::QVideoSurfaceFormat *>(cppSelf)->yCbCrColorSpace();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_YCBCRCOLORSPACE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVideoSurfaceFormat___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QVideoSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QVideoSurfaceFormat_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QVideoSurfaceFormat_methods[] = {
    {"frameHeight", reinterpret_cast<PyCFunction>(Sbk_QVideoSurfaceFormatFunc_frameHeight), METH_NOARGS},
    {"frameRate", reinterpret_cast<PyCFunction>(Sbk_QVideoSurfaceFormatFunc_frameRate), METH_NOARGS},
    {"frameSize", reinterpret_cast<PyCFunction>(Sbk_QVideoSurfaceFormatFunc_frameSize), METH_NOARGS},
    {"frameWidth", reinterpret_cast<PyCFunction>(Sbk_QVideoSurfaceFormatFunc_frameWidth), METH_NOARGS},
    {"handleType", reinterpret_cast<PyCFunction>(Sbk_QVideoSurfaceFormatFunc_handleType), METH_NOARGS},
    {"isMirrored", reinterpret_cast<PyCFunction>(Sbk_QVideoSurfaceFormatFunc_isMirrored), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QVideoSurfaceFormatFunc_isValid), METH_NOARGS},
    {"pixelAspectRatio", reinterpret_cast<PyCFunction>(Sbk_QVideoSurfaceFormatFunc_pixelAspectRatio), METH_NOARGS},
    {"pixelFormat", reinterpret_cast<PyCFunction>(Sbk_QVideoSurfaceFormatFunc_pixelFormat), METH_NOARGS},
    {"property", reinterpret_cast<PyCFunction>(Sbk_QVideoSurfaceFormatFunc_property), METH_O},
    {"propertyNames", reinterpret_cast<PyCFunction>(Sbk_QVideoSurfaceFormatFunc_propertyNames), METH_NOARGS},
    {"scanLineDirection", reinterpret_cast<PyCFunction>(Sbk_QVideoSurfaceFormatFunc_scanLineDirection), METH_NOARGS},
    {"setFrameRate", reinterpret_cast<PyCFunction>(Sbk_QVideoSurfaceFormatFunc_setFrameRate), METH_O},
    {"setFrameSize", reinterpret_cast<PyCFunction>(Sbk_QVideoSurfaceFormatFunc_setFrameSize), METH_VARARGS},
    {"setMirrored", reinterpret_cast<PyCFunction>(Sbk_QVideoSurfaceFormatFunc_setMirrored), METH_O},
    {"setPixelAspectRatio", reinterpret_cast<PyCFunction>(Sbk_QVideoSurfaceFormatFunc_setPixelAspectRatio), METH_VARARGS},
    {"setProperty", reinterpret_cast<PyCFunction>(Sbk_QVideoSurfaceFormatFunc_setProperty), METH_VARARGS},
    {"setScanLineDirection", reinterpret_cast<PyCFunction>(Sbk_QVideoSurfaceFormatFunc_setScanLineDirection), METH_O},
    {"setViewport", reinterpret_cast<PyCFunction>(Sbk_QVideoSurfaceFormatFunc_setViewport), METH_O},
    {"setYCbCrColorSpace", reinterpret_cast<PyCFunction>(Sbk_QVideoSurfaceFormatFunc_setYCbCrColorSpace), METH_O},
    {"sizeHint", reinterpret_cast<PyCFunction>(Sbk_QVideoSurfaceFormatFunc_sizeHint), METH_NOARGS},
    {"viewport", reinterpret_cast<PyCFunction>(Sbk_QVideoSurfaceFormatFunc_viewport), METH_NOARGS},
    {"yCbCrColorSpace", reinterpret_cast<PyCFunction>(Sbk_QVideoSurfaceFormatFunc_yCbCrColorSpace), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QVideoSurfaceFormat___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QVideoSurfaceFormat_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QVideoSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_IDX]), (pyArg)))) {
                // operator!=(const QVideoSurfaceFormat & format) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QVideoSurfaceFormat cppArg0_local;
                ::QVideoSurfaceFormat *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_IDX]), (pyArg)))) {
                // operator==(const QVideoSurfaceFormat & format) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QVideoSurfaceFormat cppArg0_local;
                ::QVideoSurfaceFormat *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QVideoSurfaceFormat_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QVideoSurfaceFormat_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QVideoSurfaceFormat_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QVideoSurfaceFormat_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QVideoSurfaceFormat__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QVideoSurfaceFormat_Type = nullptr;
static SbkObjectType *Sbk_QVideoSurfaceFormat_TypeF(void)
{
    return _Sbk_QVideoSurfaceFormat_Type;
}

static PyType_Slot Sbk_QVideoSurfaceFormat_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QVideoSurfaceFormat__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QVideoSurfaceFormat_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QVideoSurfaceFormat_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QVideoSurfaceFormat_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QVideoSurfaceFormat_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QVideoSurfaceFormat_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QVideoSurfaceFormat_spec = {
    "2:PySide2.QtMultimedia.QVideoSurfaceFormat",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QVideoSurfaceFormat_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QVideoSurfaceFormat_Direction_PythonToCpp_QVideoSurfaceFormat_Direction(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QVideoSurfaceFormat::Direction *>(cppOut) =
        static_cast<::QVideoSurfaceFormat::Direction>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QVideoSurfaceFormat_Direction_PythonToCpp_QVideoSurfaceFormat_Direction_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_DIRECTION_IDX]))
        return QVideoSurfaceFormat_Direction_PythonToCpp_QVideoSurfaceFormat_Direction;
    return {};
}
static PyObject *QVideoSurfaceFormat_Direction_CppToPython_QVideoSurfaceFormat_Direction(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QVideoSurfaceFormat::Direction *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_DIRECTION_IDX], castCppIn);

}

static void QVideoSurfaceFormat_YCbCrColorSpace_PythonToCpp_QVideoSurfaceFormat_YCbCrColorSpace(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QVideoSurfaceFormat::YCbCrColorSpace *>(cppOut) =
        static_cast<::QVideoSurfaceFormat::YCbCrColorSpace>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QVideoSurfaceFormat_YCbCrColorSpace_PythonToCpp_QVideoSurfaceFormat_YCbCrColorSpace_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_YCBCRCOLORSPACE_IDX]))
        return QVideoSurfaceFormat_YCbCrColorSpace_PythonToCpp_QVideoSurfaceFormat_YCbCrColorSpace;
    return {};
}
static PyObject *QVideoSurfaceFormat_YCbCrColorSpace_CppToPython_QVideoSurfaceFormat_YCbCrColorSpace(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QVideoSurfaceFormat::YCbCrColorSpace *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_YCBCRCOLORSPACE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QVideoSurfaceFormat_PythonToCpp_QVideoSurfaceFormat_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QVideoSurfaceFormat_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QVideoSurfaceFormat_PythonToCpp_QVideoSurfaceFormat_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QVideoSurfaceFormat_TypeF())))
        return QVideoSurfaceFormat_PythonToCpp_QVideoSurfaceFormat_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QVideoSurfaceFormat_PTR_CppToPython_QVideoSurfaceFormat(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QVideoSurfaceFormat *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QVideoSurfaceFormat_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QVideoSurfaceFormat_COPY_CppToPython_QVideoSurfaceFormat(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QVideoSurfaceFormat_TypeF(), new ::QVideoSurfaceFormat(*reinterpret_cast<const ::QVideoSurfaceFormat *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QVideoSurfaceFormat_PythonToCpp_QVideoSurfaceFormat_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QVideoSurfaceFormat *>(cppOut) = *reinterpret_cast< ::QVideoSurfaceFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QVideoSurfaceFormat_PythonToCpp_QVideoSurfaceFormat_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QVideoSurfaceFormat_TypeF())))
        return QVideoSurfaceFormat_PythonToCpp_QVideoSurfaceFormat_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QVideoSurfaceFormat_SignatureStrings[] = {
    "2:PySide2.QtMultimedia.QVideoSurfaceFormat(self)",
    "1:PySide2.QtMultimedia.QVideoSurfaceFormat(self,size:PySide2.QtCore.QSize,pixelFormat:PySide2.QtMultimedia.QVideoFrame.PixelFormat,handleType:PySide2.QtMultimedia.QAbstractVideoBuffer.HandleType=QAbstractVideoBuffer.NoHandle)",
    "0:PySide2.QtMultimedia.QVideoSurfaceFormat(self,format:PySide2.QtMultimedia.QVideoSurfaceFormat)",
    "PySide2.QtMultimedia.QVideoSurfaceFormat.frameHeight(self)->int",
    "PySide2.QtMultimedia.QVideoSurfaceFormat.frameRate(self)->qreal",
    "PySide2.QtMultimedia.QVideoSurfaceFormat.frameSize(self)->PySide2.QtCore.QSize",
    "PySide2.QtMultimedia.QVideoSurfaceFormat.frameWidth(self)->int",
    "PySide2.QtMultimedia.QVideoSurfaceFormat.handleType(self)->PySide2.QtMultimedia.QAbstractVideoBuffer.HandleType",
    "PySide2.QtMultimedia.QVideoSurfaceFormat.isMirrored(self)->bool",
    "PySide2.QtMultimedia.QVideoSurfaceFormat.isValid(self)->bool",
    "PySide2.QtMultimedia.QVideoSurfaceFormat.pixelAspectRatio(self)->PySide2.QtCore.QSize",
    "PySide2.QtMultimedia.QVideoSurfaceFormat.pixelFormat(self)->PySide2.QtMultimedia.QVideoFrame.PixelFormat",
    "PySide2.QtMultimedia.QVideoSurfaceFormat.property(self,name:char*)->QVariant",
    "PySide2.QtMultimedia.QVideoSurfaceFormat.propertyNames(self)->QList[PySide2.QtCore.QByteArray]",
    "PySide2.QtMultimedia.QVideoSurfaceFormat.scanLineDirection(self)->PySide2.QtMultimedia.QVideoSurfaceFormat.Direction",
    "PySide2.QtMultimedia.QVideoSurfaceFormat.setFrameRate(self,rate:qreal)",
    "1:PySide2.QtMultimedia.QVideoSurfaceFormat.setFrameSize(self,size:PySide2.QtCore.QSize)",
    "0:PySide2.QtMultimedia.QVideoSurfaceFormat.setFrameSize(self,width:int,height:int)",
    "PySide2.QtMultimedia.QVideoSurfaceFormat.setMirrored(self,mirrored:bool)",
    "1:PySide2.QtMultimedia.QVideoSurfaceFormat.setPixelAspectRatio(self,ratio:PySide2.QtCore.QSize)",
    "0:PySide2.QtMultimedia.QVideoSurfaceFormat.setPixelAspectRatio(self,width:int,height:int)",
    "PySide2.QtMultimedia.QVideoSurfaceFormat.setProperty(self,name:char*,value:QVariant)",
    "PySide2.QtMultimedia.QVideoSurfaceFormat.setScanLineDirection(self,direction:PySide2.QtMultimedia.QVideoSurfaceFormat.Direction)",
    "PySide2.QtMultimedia.QVideoSurfaceFormat.setViewport(self,viewport:PySide2.QtCore.QRect)",
    "PySide2.QtMultimedia.QVideoSurfaceFormat.setYCbCrColorSpace(self,colorSpace:PySide2.QtMultimedia.QVideoSurfaceFormat.YCbCrColorSpace)",
    "PySide2.QtMultimedia.QVideoSurfaceFormat.sizeHint(self)->PySide2.QtCore.QSize",
    "PySide2.QtMultimedia.QVideoSurfaceFormat.viewport(self)->PySide2.QtCore.QRect",
    "PySide2.QtMultimedia.QVideoSurfaceFormat.yCbCrColorSpace(self)->PySide2.QtMultimedia.QVideoSurfaceFormat.YCbCrColorSpace",
    "PySide2.QtMultimedia.QVideoSurfaceFormat.__copy__()",
    nullptr}; // Sentinel

void init_QVideoSurfaceFormat(PyObject *module)
{
    _Sbk_QVideoSurfaceFormat_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QVideoSurfaceFormat",
        "QVideoSurfaceFormat",
        &Sbk_QVideoSurfaceFormat_spec,
        &Shiboken::callCppDestructor< ::QVideoSurfaceFormat >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QVideoSurfaceFormat_Type);
    InitSignatureStrings(pyType, QVideoSurfaceFormat_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QVideoSurfaceFormat_Type), Sbk_QVideoSurfaceFormat_PropertyStrings);
    SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QVideoSurfaceFormat_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QVideoSurfaceFormat_TypeF(),
        QVideoSurfaceFormat_PythonToCpp_QVideoSurfaceFormat_PTR,
        is_QVideoSurfaceFormat_PythonToCpp_QVideoSurfaceFormat_PTR_Convertible,
        QVideoSurfaceFormat_PTR_CppToPython_QVideoSurfaceFormat,
        QVideoSurfaceFormat_COPY_CppToPython_QVideoSurfaceFormat);

    Shiboken::Conversions::registerConverterName(converter, "QVideoSurfaceFormat");
    Shiboken::Conversions::registerConverterName(converter, "QVideoSurfaceFormat*");
    Shiboken::Conversions::registerConverterName(converter, "QVideoSurfaceFormat&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QVideoSurfaceFormat).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QVideoSurfaceFormat_PythonToCpp_QVideoSurfaceFormat_COPY,
        is_QVideoSurfaceFormat_PythonToCpp_QVideoSurfaceFormat_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'Direction'.
    SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_DIRECTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QVideoSurfaceFormat_TypeF(),
        "Direction",
        "2:PySide2.QtMultimedia.QVideoSurfaceFormat.Direction",
        "QVideoSurfaceFormat::Direction");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_DIRECTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_DIRECTION_IDX],
        Sbk_QVideoSurfaceFormat_TypeF(), "TopToBottom", (long) QVideoSurfaceFormat::Direction::TopToBottom))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_DIRECTION_IDX],
        Sbk_QVideoSurfaceFormat_TypeF(), "BottomToTop", (long) QVideoSurfaceFormat::Direction::BottomToTop))
        return;
    // Register converter for enum 'QVideoSurfaceFormat::Direction'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_DIRECTION_IDX],
            QVideoSurfaceFormat_Direction_CppToPython_QVideoSurfaceFormat_Direction);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QVideoSurfaceFormat_Direction_PythonToCpp_QVideoSurfaceFormat_Direction,
            is_QVideoSurfaceFormat_Direction_PythonToCpp_QVideoSurfaceFormat_Direction_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_DIRECTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QVideoSurfaceFormat::Direction");
        Shiboken::Conversions::registerConverterName(converter, "Direction");
    }
    // End of 'Direction' enum.

    // Initialization of enum 'YCbCrColorSpace'.
    SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_YCBCRCOLORSPACE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QVideoSurfaceFormat_TypeF(),
        "YCbCrColorSpace",
        "2:PySide2.QtMultimedia.QVideoSurfaceFormat.YCbCrColorSpace",
        "QVideoSurfaceFormat::YCbCrColorSpace");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_YCBCRCOLORSPACE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_YCBCRCOLORSPACE_IDX],
        Sbk_QVideoSurfaceFormat_TypeF(), "YCbCr_Undefined", (long) QVideoSurfaceFormat::YCbCrColorSpace::YCbCr_Undefined))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_YCBCRCOLORSPACE_IDX],
        Sbk_QVideoSurfaceFormat_TypeF(), "YCbCr_BT601", (long) QVideoSurfaceFormat::YCbCrColorSpace::YCbCr_BT601))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_YCBCRCOLORSPACE_IDX],
        Sbk_QVideoSurfaceFormat_TypeF(), "YCbCr_BT709", (long) QVideoSurfaceFormat::YCbCrColorSpace::YCbCr_BT709))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_YCBCRCOLORSPACE_IDX],
        Sbk_QVideoSurfaceFormat_TypeF(), "YCbCr_xvYCC601", (long) QVideoSurfaceFormat::YCbCrColorSpace::YCbCr_xvYCC601))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_YCBCRCOLORSPACE_IDX],
        Sbk_QVideoSurfaceFormat_TypeF(), "YCbCr_xvYCC709", (long) QVideoSurfaceFormat::YCbCrColorSpace::YCbCr_xvYCC709))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_YCBCRCOLORSPACE_IDX],
        Sbk_QVideoSurfaceFormat_TypeF(), "YCbCr_JPEG", (long) QVideoSurfaceFormat::YCbCrColorSpace::YCbCr_JPEG))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_YCBCRCOLORSPACE_IDX],
        Sbk_QVideoSurfaceFormat_TypeF(), "YCbCr_CustomMatrix", (long) QVideoSurfaceFormat::YCbCrColorSpace::YCbCr_CustomMatrix))
        return;
    // Register converter for enum 'QVideoSurfaceFormat::YCbCrColorSpace'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_YCBCRCOLORSPACE_IDX],
            QVideoSurfaceFormat_YCbCrColorSpace_CppToPython_QVideoSurfaceFormat_YCbCrColorSpace);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QVideoSurfaceFormat_YCbCrColorSpace_PythonToCpp_QVideoSurfaceFormat_YCbCrColorSpace,
            is_QVideoSurfaceFormat_YCbCrColorSpace_PythonToCpp_QVideoSurfaceFormat_YCbCrColorSpace_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOSURFACEFORMAT_YCBCRCOLORSPACE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QVideoSurfaceFormat::YCbCrColorSpace");
        Shiboken::Conversions::registerConverterName(converter, "YCbCrColorSpace");
    }
    // End of 'YCbCrColorSpace' enum.

    qRegisterMetaType< ::QVideoSurfaceFormat >("QVideoSurfaceFormat");
    qRegisterMetaType< ::QVideoSurfaceFormat::Direction >("QVideoSurfaceFormat::Direction");
    qRegisterMetaType< ::QVideoSurfaceFormat::YCbCrColorSpace >("QVideoSurfaceFormat::YCbCrColorSpace");
}
