/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtmultimedia_python.h"

// main header
#include "qvideoframe_wrapper.h"

// inner classes

// Extra includes
#include <QMap>
#include <QtGui/qimage.h>
#include <QtMultimedia/qabstractvideobuffer.h>
#include <QtMultimedia/qvideoframe.h>
#include <qsize.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QVideoFrame_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QVideoFrame >()))
        return -1;

    ::QVideoFrame *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoFrame.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2)
        goto Sbk_QVideoFrame_Init_TypeError;

    if (!PyArg_UnpackTuple(args, "QVideoFrame", 0, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return -1;


    // Overloaded function decisor
    // 0: QVideoFrame::QVideoFrame()
    // 1: QVideoFrame::QVideoFrame(QAbstractVideoBuffer*,QSize,QVideoFrame::PixelFormat)
    // 2: QVideoFrame::QVideoFrame(QImage)
    // 3: QVideoFrame::QVideoFrame(QVideoFrame)
    // 4: QVideoFrame::QVideoFrame(int,QSize,int,QVideoFrame::PixelFormat)
    if (numArgs == 0) {
        overloadId = 0; // QVideoFrame()
    } else if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX])->converter, (pyArgs[3])))) {
        overloadId = 4; // QVideoFrame(int,QSize,int,QVideoFrame::PixelFormat)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QVideoFrame(QImage)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX]), (pyArgs[0])))) {
        overloadId = 3; // QVideoFrame(QVideoFrame)
    } else if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX])->converter, (pyArgs[2])))) {
        overloadId = 1; // QVideoFrame(QAbstractVideoBuffer*,QSize,QVideoFrame::PixelFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVideoFrame_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QVideoFrame()
        {

            if (!PyErr_Occurred()) {
                // QVideoFrame()
                cptr = new ::QVideoFrame();
            }
            break;
        }
        case 1: // QVideoFrame(QAbstractVideoBuffer * buffer, const QSize & size, QVideoFrame::PixelFormat format)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QAbstractVideoBuffer *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QSize cppArg1_local;
            ::QSize *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            ::QVideoFrame::PixelFormat cppArg2{QVideoFrame::Format_Invalid};
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QVideoFrame(QAbstractVideoBuffer*,QSize,QVideoFrame::PixelFormat)
                cptr = new ::QVideoFrame(cppArg0, *cppArg1, cppArg2);
            }
            break;
        }
        case 2: // QVideoFrame(const QImage & image)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QImage cppArg0_local;
            ::QImage *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QVideoFrame(QImage)
                cptr = new ::QVideoFrame(*cppArg0);
            }
            break;
        }
        case 3: // QVideoFrame(const QVideoFrame & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QVideoFrame cppArg0_local;
            ::QVideoFrame *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QVideoFrame(QVideoFrame)
                cptr = new ::QVideoFrame(*cppArg0);
            }
            break;
        }
        case 4: // QVideoFrame(int bytes, const QSize & size, int bytesPerLine, QVideoFrame::PixelFormat format)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QSize cppArg1_local;
            ::QSize *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QVideoFrame::PixelFormat cppArg3{QVideoFrame::Format_Invalid};
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // QVideoFrame(int,QSize,int,QVideoFrame::PixelFormat)
                cptr = new ::QVideoFrame(cppArg0, *cppArg1, cppArg2, cppArg3);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QVideoFrame >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QVideoFrame_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QVideoFrame_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QVideoFrameFunc_availableMetaData(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoFrame *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoFrame.availableMetaData";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // availableMetaData()const
            QMap<QString,QVariant > cppResult = const_cast<const ::QVideoFrame *>(cppSelf)->availableMetaData();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QMAP_QSTRING_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVideoFrameFunc_bits(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoFrame *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoFrame.bits";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bits()
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtmultimedia.cpp (qvideoframe-bits)]
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            uchar * cppResult = cppSelf->bits();
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Buffer::newObject(cppResult, cppSelf->bytesPerLine() * cppSelf->height(), Shiboken::Buffer::ReadWrite);
            // END of custom code block [file: ../glue/qtmultimedia.cpp (qvideoframe-bits)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVideoFrameFunc_buffer(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoFrame *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoFrame.buffer";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // buffer()const
            QAbstractVideoBuffer * cppResult = const_cast<const ::QVideoFrame *>(cppSelf)->buffer();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVideoFrameFunc_bytesPerLine(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoFrame *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoFrame.bytesPerLine";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "bytesPerLine", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QVideoFrame::bytesPerLine()const
    // 1: QVideoFrame::bytesPerLine(int)const
    if (numArgs == 0) {
        overloadId = 0; // bytesPerLine()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 1; // bytesPerLine(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVideoFrameFunc_bytesPerLine_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // bytesPerLine() const
        {

            if (!PyErr_Occurred()) {
                // bytesPerLine()const
                int cppResult = const_cast<const ::QVideoFrame *>(cppSelf)->bytesPerLine();
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 1: // bytesPerLine(int plane) const
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // bytesPerLine(int)const
                int cppResult = const_cast<const ::QVideoFrame *>(cppSelf)->bytesPerLine(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QVideoFrameFunc_bytesPerLine_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVideoFrameFunc_endTime(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoFrame *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoFrame.endTime";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // endTime()const
            qint64 cppResult = const_cast<const ::QVideoFrame *>(cppSelf)->endTime();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVideoFrameFunc_fieldType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoFrame *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoFrame.fieldType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fieldType()const
            QVideoFrame::FieldType cppResult = const_cast<const ::QVideoFrame *>(cppSelf)->fieldType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_FIELDTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVideoFrameFunc_handle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoFrame *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoFrame.handle";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // handle()const
            QVariant cppResult = const_cast<const ::QVideoFrame *>(cppSelf)->handle();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVideoFrameFunc_handleType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoFrame *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoFrame.handleType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // handleType()const
            QAbstractVideoBuffer::HandleType cppResult = const_cast<const ::QVideoFrame *>(cppSelf)->handleType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_HANDLETYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVideoFrameFunc_height(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoFrame *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoFrame.height";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // height()const
            int cppResult = const_cast<const ::QVideoFrame *>(cppSelf)->height();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVideoFrameFunc_image(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoFrame *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoFrame.image";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // image()const
            QImage cppResult = const_cast<const ::QVideoFrame *>(cppSelf)->image();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVideoFrameFunc_imageFormatFromPixelFormat(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoFrame.imageFormatFromPixelFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QVideoFrame::imageFormatFromPixelFormat(QVideoFrame::PixelFormat)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // imageFormatFromPixelFormat(QVideoFrame::PixelFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVideoFrameFunc_imageFormatFromPixelFormat_TypeError;

    // Call function/method
    {
        ::QVideoFrame::PixelFormat cppArg0{QVideoFrame::Format_Invalid};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // imageFormatFromPixelFormat(QVideoFrame::PixelFormat)
            QImage::Format cppResult = ::QVideoFrame::imageFormatFromPixelFormat(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QVideoFrameFunc_imageFormatFromPixelFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVideoFrameFunc_isMapped(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoFrame *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoFrame.isMapped";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isMapped()const
            bool cppResult = const_cast<const ::QVideoFrame *>(cppSelf)->isMapped();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVideoFrameFunc_isReadable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoFrame *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoFrame.isReadable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isReadable()const
            bool cppResult = const_cast<const ::QVideoFrame *>(cppSelf)->isReadable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVideoFrameFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoFrame *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoFrame.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QVideoFrame *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVideoFrameFunc_isWritable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoFrame *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoFrame.isWritable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isWritable()const
            bool cppResult = const_cast<const ::QVideoFrame *>(cppSelf)->isWritable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVideoFrameFunc_map(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoFrame *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoFrame.map";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QVideoFrame::map(QAbstractVideoBuffer::MapMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_MAPMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // map(QAbstractVideoBuffer::MapMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVideoFrameFunc_map_TypeError;

    // Call function/method
    {
        ::QAbstractVideoBuffer::MapMode cppArg0{QAbstractVideoBuffer::NotMapped};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // map(QAbstractVideoBuffer::MapMode)
            bool cppResult = cppSelf->map(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QVideoFrameFunc_map_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVideoFrameFunc_mapMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoFrame *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoFrame.mapMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mapMode()const
            QAbstractVideoBuffer::MapMode cppResult = const_cast<const ::QVideoFrame *>(cppSelf)->mapMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOBUFFER_MAPMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVideoFrameFunc_mappedBytes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoFrame *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoFrame.mappedBytes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mappedBytes()const
            int cppResult = const_cast<const ::QVideoFrame *>(cppSelf)->mappedBytes();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVideoFrameFunc_metaData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoFrame *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoFrame.metaData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QVideoFrame::metaData(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // metaData(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVideoFrameFunc_metaData_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // metaData(QString)const
            QVariant cppResult = const_cast<const ::QVideoFrame *>(cppSelf)->metaData(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QVideoFrameFunc_metaData_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVideoFrameFunc_pixelFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoFrame *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoFrame.pixelFormat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pixelFormat()const
            QVideoFrame::PixelFormat cppResult = const_cast<const ::QVideoFrame *>(cppSelf)->pixelFormat();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVideoFrameFunc_pixelFormatFromImageFormat(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoFrame.pixelFormatFromImageFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QVideoFrame::pixelFormatFromImageFormat(QImage::Format)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QIMAGE_FORMAT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // pixelFormatFromImageFormat(QImage::Format)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVideoFrameFunc_pixelFormatFromImageFormat_TypeError;

    // Call function/method
    {
        ::QImage::Format cppArg0{QImage::Format_Invalid};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // pixelFormatFromImageFormat(QImage::Format)
            QVideoFrame::PixelFormat cppResult = ::QVideoFrame::pixelFormatFromImageFormat(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QVideoFrameFunc_pixelFormatFromImageFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVideoFrameFunc_planeCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoFrame *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoFrame.planeCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // planeCount()const
            int cppResult = const_cast<const ::QVideoFrame *>(cppSelf)->planeCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVideoFrameFunc_setEndTime(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoFrame *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoFrame.setEndTime";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QVideoFrame::setEndTime(qint64)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // setEndTime(qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVideoFrameFunc_setEndTime_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setEndTime(qint64)
            cppSelf->setEndTime(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QVideoFrameFunc_setEndTime_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVideoFrameFunc_setFieldType(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoFrame *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoFrame.setFieldType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QVideoFrame::setFieldType(QVideoFrame::FieldType)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_FIELDTYPE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setFieldType(QVideoFrame::FieldType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVideoFrameFunc_setFieldType_TypeError;

    // Call function/method
    {
        ::QVideoFrame::FieldType cppArg0{QVideoFrame::ProgressiveFrame};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFieldType(QVideoFrame::FieldType)
            cppSelf->setFieldType(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QVideoFrameFunc_setFieldType_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVideoFrameFunc_setMetaData(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoFrame *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoFrame.setMetaData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setMetaData", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QVideoFrame::setMetaData(QString,QVariant)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[1])))) {
        overloadId = 0; // setMetaData(QString,QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVideoFrameFunc_setMetaData_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QVariant cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setMetaData(QString,QVariant)
            cppSelf->setMetaData(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QVideoFrameFunc_setMetaData_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVideoFrameFunc_setStartTime(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoFrame *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoFrame.setStartTime";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QVideoFrame::setStartTime(qint64)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // setStartTime(qint64)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QVideoFrameFunc_setStartTime_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setStartTime(qint64)
            cppSelf->setStartTime(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QVideoFrameFunc_setStartTime_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QVideoFrameFunc_size(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoFrame *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoFrame.size";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // size()const
            QSize cppResult = const_cast<const ::QVideoFrame *>(cppSelf)->size();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVideoFrameFunc_startTime(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoFrame *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoFrame.startTime";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // startTime()const
            qint64 cppResult = const_cast<const ::QVideoFrame *>(cppSelf)->startTime();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVideoFrameFunc_unmap(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoFrame *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoFrame.unmap";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // unmap()
            cppSelf->unmap();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QVideoFrameFunc_width(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoFrame *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QVideoFrame.width";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // width()const
            int cppResult = const_cast<const ::QVideoFrame *>(cppSelf)->width();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QVideoFrame___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QVideoFrame *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QVideoFrame_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QVideoFrame_methods[] = {
    {"availableMetaData", reinterpret_cast<PyCFunction>(Sbk_QVideoFrameFunc_availableMetaData), METH_NOARGS},
    {"bits", reinterpret_cast<PyCFunction>(Sbk_QVideoFrameFunc_bits), METH_NOARGS},
    {"buffer", reinterpret_cast<PyCFunction>(Sbk_QVideoFrameFunc_buffer), METH_NOARGS},
    {"bytesPerLine", reinterpret_cast<PyCFunction>(Sbk_QVideoFrameFunc_bytesPerLine), METH_VARARGS},
    {"endTime", reinterpret_cast<PyCFunction>(Sbk_QVideoFrameFunc_endTime), METH_NOARGS},
    {"fieldType", reinterpret_cast<PyCFunction>(Sbk_QVideoFrameFunc_fieldType), METH_NOARGS},
    {"handle", reinterpret_cast<PyCFunction>(Sbk_QVideoFrameFunc_handle), METH_NOARGS},
    {"handleType", reinterpret_cast<PyCFunction>(Sbk_QVideoFrameFunc_handleType), METH_NOARGS},
    {"height", reinterpret_cast<PyCFunction>(Sbk_QVideoFrameFunc_height), METH_NOARGS},
    {"image", reinterpret_cast<PyCFunction>(Sbk_QVideoFrameFunc_image), METH_NOARGS},
    {"imageFormatFromPixelFormat", reinterpret_cast<PyCFunction>(Sbk_QVideoFrameFunc_imageFormatFromPixelFormat), METH_O|METH_STATIC},
    {"isMapped", reinterpret_cast<PyCFunction>(Sbk_QVideoFrameFunc_isMapped), METH_NOARGS},
    {"isReadable", reinterpret_cast<PyCFunction>(Sbk_QVideoFrameFunc_isReadable), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QVideoFrameFunc_isValid), METH_NOARGS},
    {"isWritable", reinterpret_cast<PyCFunction>(Sbk_QVideoFrameFunc_isWritable), METH_NOARGS},
    {"map", reinterpret_cast<PyCFunction>(Sbk_QVideoFrameFunc_map), METH_O},
    {"mapMode", reinterpret_cast<PyCFunction>(Sbk_QVideoFrameFunc_mapMode), METH_NOARGS},
    {"mappedBytes", reinterpret_cast<PyCFunction>(Sbk_QVideoFrameFunc_mappedBytes), METH_NOARGS},
    {"metaData", reinterpret_cast<PyCFunction>(Sbk_QVideoFrameFunc_metaData), METH_O},
    {"pixelFormat", reinterpret_cast<PyCFunction>(Sbk_QVideoFrameFunc_pixelFormat), METH_NOARGS},
    {"pixelFormatFromImageFormat", reinterpret_cast<PyCFunction>(Sbk_QVideoFrameFunc_pixelFormatFromImageFormat), METH_O|METH_STATIC},
    {"planeCount", reinterpret_cast<PyCFunction>(Sbk_QVideoFrameFunc_planeCount), METH_NOARGS},
    {"setEndTime", reinterpret_cast<PyCFunction>(Sbk_QVideoFrameFunc_setEndTime), METH_O},
    {"setFieldType", reinterpret_cast<PyCFunction>(Sbk_QVideoFrameFunc_setFieldType), METH_O},
    {"setMetaData", reinterpret_cast<PyCFunction>(Sbk_QVideoFrameFunc_setMetaData), METH_VARARGS},
    {"setStartTime", reinterpret_cast<PyCFunction>(Sbk_QVideoFrameFunc_setStartTime), METH_O},
    {"size", reinterpret_cast<PyCFunction>(Sbk_QVideoFrameFunc_size), METH_NOARGS},
    {"startTime", reinterpret_cast<PyCFunction>(Sbk_QVideoFrameFunc_startTime), METH_NOARGS},
    {"unmap", reinterpret_cast<PyCFunction>(Sbk_QVideoFrameFunc_unmap), METH_NOARGS},
    {"width", reinterpret_cast<PyCFunction>(Sbk_QVideoFrameFunc_width), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QVideoFrame___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QVideoFrame_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QVideoFrame *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX]), (pyArg)))) {
                // operator!=(const QVideoFrame & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QVideoFrame cppArg0_local;
                ::QVideoFrame *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX]), (pyArg)))) {
                // operator==(const QVideoFrame & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QVideoFrame cppArg0_local;
                ::QVideoFrame *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QVideoFrame_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QVideoFrame_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QVideoFrame_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QVideoFrame_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QVideoFrame__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QVideoFrame *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QVideoFrame_Type = nullptr;
static SbkObjectType *Sbk_QVideoFrame_TypeF(void)
{
    return _Sbk_QVideoFrame_Type;
}

static PyType_Slot Sbk_QVideoFrame_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QVideoFrame__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QVideoFrame_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QVideoFrame_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QVideoFrame_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QVideoFrame_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QVideoFrame_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QVideoFrame_spec = {
    "2:PySide2.QtMultimedia.QVideoFrame",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QVideoFrame_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QVideoFrame_FieldType_PythonToCpp_QVideoFrame_FieldType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QVideoFrame::FieldType *>(cppOut) =
        static_cast<::QVideoFrame::FieldType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QVideoFrame_FieldType_PythonToCpp_QVideoFrame_FieldType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_FIELDTYPE_IDX]))
        return QVideoFrame_FieldType_PythonToCpp_QVideoFrame_FieldType;
    return {};
}
static PyObject *QVideoFrame_FieldType_CppToPython_QVideoFrame_FieldType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QVideoFrame::FieldType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_FIELDTYPE_IDX], castCppIn);

}

static void QVideoFrame_PixelFormat_PythonToCpp_QVideoFrame_PixelFormat(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QVideoFrame::PixelFormat *>(cppOut) =
        static_cast<::QVideoFrame::PixelFormat>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QVideoFrame_PixelFormat_PythonToCpp_QVideoFrame_PixelFormat_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX]))
        return QVideoFrame_PixelFormat_PythonToCpp_QVideoFrame_PixelFormat;
    return {};
}
static PyObject *QVideoFrame_PixelFormat_CppToPython_QVideoFrame_PixelFormat(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QVideoFrame::PixelFormat *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QVideoFrame_PythonToCpp_QVideoFrame_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QVideoFrame_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QVideoFrame_PythonToCpp_QVideoFrame_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QVideoFrame_TypeF())))
        return QVideoFrame_PythonToCpp_QVideoFrame_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QVideoFrame_PTR_CppToPython_QVideoFrame(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QVideoFrame *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QVideoFrame_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QVideoFrame_COPY_CppToPython_QVideoFrame(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QVideoFrame_TypeF(), new ::QVideoFrame(*reinterpret_cast<const ::QVideoFrame *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QVideoFrame_PythonToCpp_QVideoFrame_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QVideoFrame *>(cppOut) = *reinterpret_cast< ::QVideoFrame *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QVideoFrame_PythonToCpp_QVideoFrame_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QVideoFrame_TypeF())))
        return QVideoFrame_PythonToCpp_QVideoFrame_COPY;
    return {};
}

// Implicit conversions.
static void PySide2_QtGui_constQImageREF_PythonToCpp_QVideoFrame(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QVideoFrame *>(cppOut) = ::QVideoFrame( *reinterpret_cast< ::QImage *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_PySide2_QtGui_constQImageREF_PythonToCpp_QVideoFrame_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX], pyIn))
        return PySide2_QtGui_constQImageREF_PythonToCpp_QVideoFrame;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QVideoFrame_SignatureStrings[] = {
    "4:PySide2.QtMultimedia.QVideoFrame(self)",
    "3:PySide2.QtMultimedia.QVideoFrame(self,buffer:PySide2.QtMultimedia.QAbstractVideoBuffer,size:PySide2.QtCore.QSize,format:PySide2.QtMultimedia.QVideoFrame.PixelFormat)",
    "2:PySide2.QtMultimedia.QVideoFrame(self,image:PySide2.QtGui.QImage)",
    "1:PySide2.QtMultimedia.QVideoFrame(self,other:PySide2.QtMultimedia.QVideoFrame)",
    "0:PySide2.QtMultimedia.QVideoFrame(self,bytes:int,size:PySide2.QtCore.QSize,bytesPerLine:int,format:PySide2.QtMultimedia.QVideoFrame.PixelFormat)",
    "PySide2.QtMultimedia.QVideoFrame.availableMetaData(self)->QMap[QString, QVariant]",
    "1:PySide2.QtMultimedia.QVideoFrame.bits(self)->uchar*",
    "0:PySide2.QtMultimedia.QVideoFrame.bits(self)->uchar*",
    "PySide2.QtMultimedia.QVideoFrame.buffer(self)->PySide2.QtMultimedia.QAbstractVideoBuffer",
    "1:PySide2.QtMultimedia.QVideoFrame.bytesPerLine(self)->int",
    "0:PySide2.QtMultimedia.QVideoFrame.bytesPerLine(self,plane:int)->int",
    "PySide2.QtMultimedia.QVideoFrame.endTime(self)->qint64",
    "PySide2.QtMultimedia.QVideoFrame.fieldType(self)->PySide2.QtMultimedia.QVideoFrame.FieldType",
    "PySide2.QtMultimedia.QVideoFrame.handle(self)->QVariant",
    "PySide2.QtMultimedia.QVideoFrame.handleType(self)->PySide2.QtMultimedia.QAbstractVideoBuffer.HandleType",
    "PySide2.QtMultimedia.QVideoFrame.height(self)->int",
    "PySide2.QtMultimedia.QVideoFrame.image(self)->PySide2.QtGui.QImage",
    "PySide2.QtMultimedia.QVideoFrame.imageFormatFromPixelFormat(format:PySide2.QtMultimedia.QVideoFrame.PixelFormat)->PySide2.QtGui.QImage.Format",
    "PySide2.QtMultimedia.QVideoFrame.isMapped(self)->bool",
    "PySide2.QtMultimedia.QVideoFrame.isReadable(self)->bool",
    "PySide2.QtMultimedia.QVideoFrame.isValid(self)->bool",
    "PySide2.QtMultimedia.QVideoFrame.isWritable(self)->bool",
    "PySide2.QtMultimedia.QVideoFrame.map(self,mode:PySide2.QtMultimedia.QAbstractVideoBuffer.MapMode)->bool",
    "PySide2.QtMultimedia.QVideoFrame.mapMode(self)->PySide2.QtMultimedia.QAbstractVideoBuffer.MapMode",
    "PySide2.QtMultimedia.QVideoFrame.mappedBytes(self)->int",
    "PySide2.QtMultimedia.QVideoFrame.metaData(self,key:QString)->QVariant",
    "PySide2.QtMultimedia.QVideoFrame.pixelFormat(self)->PySide2.QtMultimedia.QVideoFrame.PixelFormat",
    "PySide2.QtMultimedia.QVideoFrame.pixelFormatFromImageFormat(format:PySide2.QtGui.QImage.Format)->PySide2.QtMultimedia.QVideoFrame.PixelFormat",
    "PySide2.QtMultimedia.QVideoFrame.planeCount(self)->int",
    "PySide2.QtMultimedia.QVideoFrame.setEndTime(self,time:qint64)",
    "PySide2.QtMultimedia.QVideoFrame.setFieldType(self,arg__1:PySide2.QtMultimedia.QVideoFrame.FieldType)",
    "PySide2.QtMultimedia.QVideoFrame.setMetaData(self,key:QString,value:QVariant)",
    "PySide2.QtMultimedia.QVideoFrame.setStartTime(self,time:qint64)",
    "PySide2.QtMultimedia.QVideoFrame.size(self)->PySide2.QtCore.QSize",
    "PySide2.QtMultimedia.QVideoFrame.startTime(self)->qint64",
    "PySide2.QtMultimedia.QVideoFrame.unmap(self)",
    "PySide2.QtMultimedia.QVideoFrame.width(self)->int",
    "PySide2.QtMultimedia.QVideoFrame.__copy__()",
    nullptr}; // Sentinel

void init_QVideoFrame(PyObject *module)
{
    _Sbk_QVideoFrame_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QVideoFrame",
        "QVideoFrame",
        &Sbk_QVideoFrame_spec,
        &Shiboken::callCppDestructor< ::QVideoFrame >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QVideoFrame_Type);
    InitSignatureStrings(pyType, QVideoFrame_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QVideoFrame_Type), Sbk_QVideoFrame_PropertyStrings);
    SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QVideoFrame_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QVideoFrame_TypeF(),
        QVideoFrame_PythonToCpp_QVideoFrame_PTR,
        is_QVideoFrame_PythonToCpp_QVideoFrame_PTR_Convertible,
        QVideoFrame_PTR_CppToPython_QVideoFrame,
        QVideoFrame_COPY_CppToPython_QVideoFrame);

    Shiboken::Conversions::registerConverterName(converter, "QVideoFrame");
    Shiboken::Conversions::registerConverterName(converter, "QVideoFrame*");
    Shiboken::Conversions::registerConverterName(converter, "QVideoFrame&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QVideoFrame).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QVideoFrame_PythonToCpp_QVideoFrame_COPY,
        is_QVideoFrame_PythonToCpp_QVideoFrame_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtGui_constQImageREF_PythonToCpp_QVideoFrame,
        is_PySide2_QtGui_constQImageREF_PythonToCpp_QVideoFrame_Convertible);

    // Initialization of enums.

    // Initialization of enum 'FieldType'.
    SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_FIELDTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QVideoFrame_TypeF(),
        "FieldType",
        "2:PySide2.QtMultimedia.QVideoFrame.FieldType",
        "QVideoFrame::FieldType");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_FIELDTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_FIELDTYPE_IDX],
        Sbk_QVideoFrame_TypeF(), "ProgressiveFrame", (long) QVideoFrame::FieldType::ProgressiveFrame))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_FIELDTYPE_IDX],
        Sbk_QVideoFrame_TypeF(), "TopField", (long) QVideoFrame::FieldType::TopField))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_FIELDTYPE_IDX],
        Sbk_QVideoFrame_TypeF(), "BottomField", (long) QVideoFrame::FieldType::BottomField))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_FIELDTYPE_IDX],
        Sbk_QVideoFrame_TypeF(), "InterlacedFrame", (long) QVideoFrame::FieldType::InterlacedFrame))
        return;
    // Register converter for enum 'QVideoFrame::FieldType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_FIELDTYPE_IDX],
            QVideoFrame_FieldType_CppToPython_QVideoFrame_FieldType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QVideoFrame_FieldType_PythonToCpp_QVideoFrame_FieldType,
            is_QVideoFrame_FieldType_PythonToCpp_QVideoFrame_FieldType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_FIELDTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QVideoFrame::FieldType");
        Shiboken::Conversions::registerConverterName(converter, "FieldType");
    }
    // End of 'FieldType' enum.

    // Initialization of enum 'PixelFormat'.
    SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QVideoFrame_TypeF(),
        "PixelFormat",
        "2:PySide2.QtMultimedia.QVideoFrame.PixelFormat",
        "QVideoFrame::PixelFormat");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX],
        Sbk_QVideoFrame_TypeF(), "Format_Invalid", (long) QVideoFrame::PixelFormat::Format_Invalid))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX],
        Sbk_QVideoFrame_TypeF(), "Format_ARGB32", (long) QVideoFrame::PixelFormat::Format_ARGB32))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX],
        Sbk_QVideoFrame_TypeF(), "Format_ARGB32_Premultiplied", (long) QVideoFrame::PixelFormat::Format_ARGB32_Premultiplied))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX],
        Sbk_QVideoFrame_TypeF(), "Format_RGB32", (long) QVideoFrame::PixelFormat::Format_RGB32))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX],
        Sbk_QVideoFrame_TypeF(), "Format_RGB24", (long) QVideoFrame::PixelFormat::Format_RGB24))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX],
        Sbk_QVideoFrame_TypeF(), "Format_RGB565", (long) QVideoFrame::PixelFormat::Format_RGB565))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX],
        Sbk_QVideoFrame_TypeF(), "Format_RGB555", (long) QVideoFrame::PixelFormat::Format_RGB555))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX],
        Sbk_QVideoFrame_TypeF(), "Format_ARGB8565_Premultiplied", (long) QVideoFrame::PixelFormat::Format_ARGB8565_Premultiplied))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX],
        Sbk_QVideoFrame_TypeF(), "Format_BGRA32", (long) QVideoFrame::PixelFormat::Format_BGRA32))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX],
        Sbk_QVideoFrame_TypeF(), "Format_BGRA32_Premultiplied", (long) QVideoFrame::PixelFormat::Format_BGRA32_Premultiplied))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX],
        Sbk_QVideoFrame_TypeF(), "Format_BGR32", (long) QVideoFrame::PixelFormat::Format_BGR32))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX],
        Sbk_QVideoFrame_TypeF(), "Format_BGR24", (long) QVideoFrame::PixelFormat::Format_BGR24))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX],
        Sbk_QVideoFrame_TypeF(), "Format_BGR565", (long) QVideoFrame::PixelFormat::Format_BGR565))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX],
        Sbk_QVideoFrame_TypeF(), "Format_BGR555", (long) QVideoFrame::PixelFormat::Format_BGR555))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX],
        Sbk_QVideoFrame_TypeF(), "Format_BGRA5658_Premultiplied", (long) QVideoFrame::PixelFormat::Format_BGRA5658_Premultiplied))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX],
        Sbk_QVideoFrame_TypeF(), "Format_AYUV444", (long) QVideoFrame::PixelFormat::Format_AYUV444))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX],
        Sbk_QVideoFrame_TypeF(), "Format_AYUV444_Premultiplied", (long) QVideoFrame::PixelFormat::Format_AYUV444_Premultiplied))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX],
        Sbk_QVideoFrame_TypeF(), "Format_YUV444", (long) QVideoFrame::PixelFormat::Format_YUV444))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX],
        Sbk_QVideoFrame_TypeF(), "Format_YUV420P", (long) QVideoFrame::PixelFormat::Format_YUV420P))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX],
        Sbk_QVideoFrame_TypeF(), "Format_YV12", (long) QVideoFrame::PixelFormat::Format_YV12))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX],
        Sbk_QVideoFrame_TypeF(), "Format_UYVY", (long) QVideoFrame::PixelFormat::Format_UYVY))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX],
        Sbk_QVideoFrame_TypeF(), "Format_YUYV", (long) QVideoFrame::PixelFormat::Format_YUYV))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX],
        Sbk_QVideoFrame_TypeF(), "Format_NV12", (long) QVideoFrame::PixelFormat::Format_NV12))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX],
        Sbk_QVideoFrame_TypeF(), "Format_NV21", (long) QVideoFrame::PixelFormat::Format_NV21))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX],
        Sbk_QVideoFrame_TypeF(), "Format_IMC1", (long) QVideoFrame::PixelFormat::Format_IMC1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX],
        Sbk_QVideoFrame_TypeF(), "Format_IMC2", (long) QVideoFrame::PixelFormat::Format_IMC2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX],
        Sbk_QVideoFrame_TypeF(), "Format_IMC3", (long) QVideoFrame::PixelFormat::Format_IMC3))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX],
        Sbk_QVideoFrame_TypeF(), "Format_IMC4", (long) QVideoFrame::PixelFormat::Format_IMC4))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX],
        Sbk_QVideoFrame_TypeF(), "Format_Y8", (long) QVideoFrame::PixelFormat::Format_Y8))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX],
        Sbk_QVideoFrame_TypeF(), "Format_Y16", (long) QVideoFrame::PixelFormat::Format_Y16))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX],
        Sbk_QVideoFrame_TypeF(), "Format_Jpeg", (long) QVideoFrame::PixelFormat::Format_Jpeg))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX],
        Sbk_QVideoFrame_TypeF(), "Format_CameraRaw", (long) QVideoFrame::PixelFormat::Format_CameraRaw))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX],
        Sbk_QVideoFrame_TypeF(), "Format_AdobeDng", (long) QVideoFrame::PixelFormat::Format_AdobeDng))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX],
        Sbk_QVideoFrame_TypeF(), "Format_ABGR32", (long) QVideoFrame::PixelFormat::Format_ABGR32))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX],
        Sbk_QVideoFrame_TypeF(), "Format_YUV422P", (long) QVideoFrame::PixelFormat::Format_YUV422P))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX],
        Sbk_QVideoFrame_TypeF(), "NPixelFormats", (long) QVideoFrame::PixelFormat::NPixelFormats))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX],
        Sbk_QVideoFrame_TypeF(), "Format_User", (long) QVideoFrame::PixelFormat::Format_User))
        return;
    // Register converter for enum 'QVideoFrame::PixelFormat'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX],
            QVideoFrame_PixelFormat_CppToPython_QVideoFrame_PixelFormat);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QVideoFrame_PixelFormat_PythonToCpp_QVideoFrame_PixelFormat,
            is_QVideoFrame_PixelFormat_PythonToCpp_QVideoFrame_PixelFormat_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QVideoFrame::PixelFormat");
        Shiboken::Conversions::registerConverterName(converter, "PixelFormat");
    }
    // End of 'PixelFormat' enum.

    qRegisterMetaType< ::QVideoFrame >("QVideoFrame");
    qRegisterMetaType< ::QVideoFrame::FieldType >("QVideoFrame::FieldType");
    qRegisterMetaType< ::QVideoFrame::PixelFormat >("QVideoFrame::PixelFormat");
}
