/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include <sbkpython.h>
#include <shiboken.h>
#include <algorithm>
#include <signature.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
#include "pyside2_qtmultimedia_python.h"



// Extra includes

// Current module's type array.
PyTypeObject **SbkPySide2_QtMultimediaTypes = nullptr;
// Current module's PyObject pointer.
PyObject *SbkPySide2_QtMultimediaModuleObject = nullptr;
// Current module's converter array.
SbkConverter **SbkPySide2_QtMultimediaTypeConverters = nullptr;
void cleanTypesAttributes(void) {
    if (PY_VERSION_HEX >= 0x03000000 && PY_VERSION_HEX < 0x03060000)
        return; // PYSIDE-953: testbinding crashes in Python 3.5 when hasattr touches types!
    for (int i = 0, imax = SBK_QtMultimedia_IDX_COUNT; i < imax; i++) {
        PyObject *pyType = reinterpret_cast<PyObject *>(SbkPySide2_QtMultimediaTypes[i]);
        Shiboken::AutoDecRef attrName(Py_BuildValue("s", "staticMetaObject"));
        if (pyType && PyObject_HasAttr(pyType, attrName))
            PyObject_SetAttr(pyType, attrName, Py_None);
    }
}
// Global functions ------------------------------------------------------------

static PyMethodDef QtMultimedia_methods[] = {
    {0} // Sentinel
};

// Classes initialization functions ------------------------------------------------------------
void init_QVideoSurfaceFormat(PyObject *module);
void init_QVideoFrame(PyObject *module);
void init_QVideoFilterRunnable(PyObject *module);
void init_QVideoEncoderSettings(PyObject *module);
void init_QtMultimediaQMultimedia(PyObject *module);
void init_QMediaTimeRange(PyObject *module);
void init_QMediaTimeInterval(PyObject *module);
void init_QMediaServiceSupportedFormatsInterface(PyObject *module);
void init_QMediaServiceSupportedDevicesInterface(PyObject *module);
void init_QMediaServiceProviderHint(PyObject *module);
void init_QMediaServiceFeaturesInterface(PyObject *module);
void init_QMediaServiceDefaultDeviceInterface(PyObject *module);
void init_QMediaServiceCameraInfoInterface(PyObject *module);
void init_QMediaResource(PyObject *module);
void init_QMediaBindableInterface(PyObject *module);
void init_QImageEncoderSettings(PyObject *module);
void init_QCameraViewfinderSettings(PyObject *module);
void init_QCameraFocusZone(PyObject *module);
void init_QAudioFormat(PyObject *module);
void init_QAudioEncoderSettings(PyObject *module);
void init_QAudioDeviceInfo(PyObject *module);
void init_QAudioBuffer(PyObject *module);
void init_QtMultimediaQAudio(PyObject *module);
void init_QAbstractVideoBuffer(PyObject *module);
void init_QAbstractVideoSurface(PyObject *module);
void init_QAbstractVideoFilter(PyObject *module);
void init_QAbstractAudioOutput(PyObject *module);
void init_QAbstractAudioInput(PyObject *module);
void init_QAbstractAudioDeviceInfo(PyObject *module);
void init_QVideoProbe(PyObject *module);
void init_QSoundEffect(PyObject *module);
void init_QSound(PyObject *module);
void init_QRadioData(PyObject *module);
void init_QMediaService(PyObject *module);
void init_QMediaRecorder(PyObject *module);
void init_QAudioRecorder(PyObject *module);
void init_QMediaPlaylist(PyObject *module);
void init_QMediaObject(PyObject *module);
void init_QAudioDecoder(PyObject *module);
void init_QMediaPlayer(PyObject *module);
void init_QCamera(PyObject *module);
void init_QCamera_FrameRateRange(PyObject *enclosingClass);
void init_QRadioTuner(PyObject *module);
void init_QMediaControl(PyObject *module);
void init_QAudioRoleControl(PyObject *module);
void init_QAudioOutputSelectorControl(PyObject *module);
void init_QVideoEncoderSettingsControl(PyObject *module);
void init_QAudioInputSelectorControl(PyObject *module);
void init_QVideoDeviceSelectorControl(PyObject *module);
void init_QAudioEncoderSettingsControl(PyObject *module);
void init_QRadioTunerControl(PyObject *module);
void init_QRadioDataControl(PyObject *module);
void init_QAudioDecoderControl(PyObject *module);
void init_QMetaDataWriterControl(PyObject *module);
void init_QMetaDataReaderControl(PyObject *module);
void init_QMediaVideoProbeControl(PyObject *module);
void init_QMediaStreamsControl(PyObject *module);
void init_QMediaRecorderControl(PyObject *module);
void init_QMediaPlayerControl(PyObject *module);
void init_QMediaNetworkAccessControl(PyObject *module);
void init_QMediaGaplessPlaybackControl(PyObject *module);
void init_QMediaContainerControl(PyObject *module);
void init_QMediaAvailabilityControl(PyObject *module);
void init_QMediaAudioProbeControl(PyObject *module);
void init_QImageEncoderControl(PyObject *module);
void init_QCustomAudioRoleControl(PyObject *module);
void init_QCameraZoomControl(PyObject *module);
void init_QCameraViewfinderSettingsControl2(PyObject *module);
void init_QCameraViewfinderSettingsControl(PyObject *module);
void init_QCameraLocksControl(PyObject *module);
void init_QCameraInfoControl(PyObject *module);
void init_QCameraImageProcessingControl(PyObject *module);
void init_QCameraImageCaptureControl(PyObject *module);
void init_QCameraFocusControl(PyObject *module);
void init_QCameraFlashControl(PyObject *module);
void init_QCameraFeedbackControl(PyObject *module);
void init_QCameraExposureControl(PyObject *module);
void init_QCameraControl(PyObject *module);
void init_QCameraCaptureDestinationControl(PyObject *module);
void init_QVideoWindowControl(PyObject *module);
void init_QCameraCaptureBufferFormatControl(PyObject *module);
void init_QVideoRendererControl(PyObject *module);
void init_QCameraImageProcessing(PyObject *module);
void init_QCameraImageCapture(PyObject *module);
void init_QCameraFocus(PyObject *module);
void init_QCameraExposure(PyObject *module);
void init_QAudioProbe(PyObject *module);
void init_QAudioOutput(PyObject *module);
void init_QAudioInput(PyObject *module);
void init_QCameraInfo(PyObject *module);
void init_QMediaContent(PyObject *module);

// Required modules' type and converter arrays.
PyTypeObject **SbkPySide2_QtCoreTypes;
SbkConverter **SbkPySide2_QtCoreTypeConverters;
PyTypeObject **SbkPySide2_QtGuiTypes;
SbkConverter **SbkPySide2_QtGuiTypeConverters;
PyTypeObject **SbkPySide2_QtNetworkTypes;
SbkConverter **SbkPySide2_QtNetworkTypeConverters;

// Module initialization ------------------------------------------------------------
// Container Type converters.

// C++ to Python conversion for type 'const QList<QObject* > &'.
static PyObject *_constQList_QObjectPTR_REF_CppToPython__constQList_QObjectPTR_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QObject* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QObject* >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QObject* cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QObject* > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QObject* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX], pyIn))
        return _constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QByteArray >'.
static PyObject *_QList_QByteArray__CppToPython__QList_QByteArray_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QByteArray > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QByteArray >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QByteArray cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QByteArray__PythonToCpp__QList_QByteArray_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QByteArray > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QByteArray cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QByteArray__PythonToCpp__QList_QByteArray__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pyIn))
        return _QList_QByteArray__PythonToCpp__QList_QByteArray_;
    return {};
}

// C++ to Python conversion for type 'QList<QAudioFormat::Endian >'.
static PyObject *_QList_QAudioFormat_Endian__CppToPython__QList_QAudioFormat_Endian_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QAudioFormat::Endian > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QAudioFormat::Endian >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QAudioFormat::Endian cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_ENDIAN_IDX])->converter, &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QAudioFormat_Endian__PythonToCpp__QList_QAudioFormat_Endian_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QAudioFormat::Endian > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QAudioFormat::Endian cppItem{QAudioFormat::BigEndian};
        Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_ENDIAN_IDX])->converter, pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QAudioFormat_Endian__PythonToCpp__QList_QAudioFormat_Endian__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_ENDIAN_IDX])->converter, pyIn))
        return _QList_QAudioFormat_Endian__PythonToCpp__QList_QAudioFormat_Endian_;
    return {};
}

// C++ to Python conversion for type 'QList<int >'.
static PyObject *_QList_int__CppToPython__QList_int_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<int > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<int >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        int cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_int__PythonToCpp__QList_int_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<int > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        int cppItem;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_int__PythonToCpp__QList_int__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyIn))
        return _QList_int__PythonToCpp__QList_int_;
    return {};
}

// C++ to Python conversion for type 'QList<QAudioFormat::SampleType >'.
static PyObject *_QList_QAudioFormat_SampleType__CppToPython__QList_QAudioFormat_SampleType_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QAudioFormat::SampleType > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QAudioFormat::SampleType >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QAudioFormat::SampleType cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_SAMPLETYPE_IDX])->converter, &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QAudioFormat_SampleType__PythonToCpp__QList_QAudioFormat_SampleType_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QAudioFormat::SampleType > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QAudioFormat::SampleType cppItem{QAudioFormat::Unknown};
        Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_SAMPLETYPE_IDX])->converter, pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QAudioFormat_SampleType__PythonToCpp__QList_QAudioFormat_SampleType__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_SAMPLETYPE_IDX])->converter, pyIn))
        return _QList_QAudioFormat_SampleType__PythonToCpp__QList_QAudioFormat_SampleType_;
    return {};
}

// C++ to Python conversion for type 'QList<QVideoFrame::PixelFormat >'.
static PyObject *_QList_QVideoFrame_PixelFormat__CppToPython__QList_QVideoFrame_PixelFormat_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QVideoFrame::PixelFormat > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QVideoFrame::PixelFormat >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QVideoFrame::PixelFormat cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX])->converter, &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QVideoFrame_PixelFormat__PythonToCpp__QList_QVideoFrame_PixelFormat_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QVideoFrame::PixelFormat > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QVideoFrame::PixelFormat cppItem{QVideoFrame::Format_Invalid};
        Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX])->converter, pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QVideoFrame_PixelFormat__PythonToCpp__QList_QVideoFrame_PixelFormat__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOFRAME_PIXELFORMAT_IDX])->converter, pyIn))
        return _QList_QVideoFrame_PixelFormat__PythonToCpp__QList_QVideoFrame_PixelFormat_;
    return {};
}

// C++ to Python conversion for type 'QList<QAudioDeviceInfo >'.
static PyObject *_QList_QAudioDeviceInfo__CppToPython__QList_QAudioDeviceInfo_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QAudioDeviceInfo > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QAudioDeviceInfo >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QAudioDeviceInfo cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIODEVICEINFO_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QAudioDeviceInfo__PythonToCpp__QList_QAudioDeviceInfo_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QAudioDeviceInfo > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QAudioDeviceInfo cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIODEVICEINFO_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QAudioDeviceInfo__PythonToCpp__QList_QAudioDeviceInfo__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIODEVICEINFO_IDX]), pyIn))
        return _QList_QAudioDeviceInfo__PythonToCpp__QList_QAudioDeviceInfo_;
    return {};
}

// C++ to Python conversion for type 'QMap<QString,QVariant >'.
static PyObject *_QMap_QString_QVariant__CppToPython__QMap_QString_QVariant_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QMap<QString,QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppmap_to_pymap_conversion - START
    PyObject *pyOut = PyDict_New();
    for (::QMap<QString,QVariant >::const_iterator it = cppInRef.begin(), end = cppInRef.end(); it != end; ++it) {
        ::QString key = it.key();
        ::QVariant value = it.value();
        PyObject *pyKey = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &key);
        PyObject *pyValue = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &value);
        PyDict_SetItem(pyOut, pyKey, pyValue);
        Py_DECREF(pyKey);
        Py_DECREF(pyValue);
    }
    return pyOut;
    // TEMPLATE - cppmap_to_pymap_conversion - END

}
static void _QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QMap<QString,QVariant > *>(cppOut);
    // TEMPLATE - pydict_to_cppmap_conversion - START
    PyObject *key;
    PyObject *value;
    Py_ssize_t pos = 0;
    while (PyDict_Next(pyIn, &pos, &key, &value)) {
        ::QString cppKey;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], key, &(cppKey));
        ::QVariant cppValue;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], value, &(cppValue));
        cppOutRef.insert(cppKey, cppValue);
    }
    // TEMPLATE - pydict_to_cppmap_conversion - END

}
static PythonToCppFunc is__QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleDictTypes(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], false, SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], false, pyIn))
        return _QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant_;
    return {};
}

// C++ to Python conversion for type 'QList<QString >'.
static PyObject *_QList_QString__CppToPython__QList_QString_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QString > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QString >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QString cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QString__PythonToCpp__QList_QString_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QString > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QString cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QString__PythonToCpp__QList_QString__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], pyIn))
        return _QList_QString__PythonToCpp__QList_QString_;
    return {};
}

// C++ to Python conversion for type 'QList<QAudio::Role >'.
static PyObject *_QList_QAudio_Role__CppToPython__QList_QAudio_Role_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QAudio::Role > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QAudio::Role >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QAudio::Role cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_ROLE_IDX])->converter, &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QAudio_Role__PythonToCpp__QList_QAudio_Role_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QAudio::Role > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QAudio::Role cppItem{QAudio::UnknownRole};
        Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_ROLE_IDX])->converter, pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QAudio_Role__PythonToCpp__QList_QAudio_Role__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QAUDIO_ROLE_IDX])->converter, pyIn))
        return _QList_QAudio_Role__PythonToCpp__QList_QAudio_Role_;
    return {};
}

// C++ to Python conversion for type 'QList<QCamera::FrameRateRange >'.
static PyObject *_QList_QCamera_FrameRateRange__CppToPython__QList_QCamera_FrameRateRange_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QCamera::FrameRateRange > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QCamera::FrameRateRange >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QCamera::FrameRateRange cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_FRAMERATERANGE_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QCamera_FrameRateRange__PythonToCpp__QList_QCamera_FrameRateRange_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QCamera::FrameRateRange > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QCamera::FrameRateRange cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_FRAMERATERANGE_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QCamera_FrameRateRange__PythonToCpp__QList_QCamera_FrameRateRange__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_FRAMERATERANGE_IDX]), pyIn))
        return _QList_QCamera_FrameRateRange__PythonToCpp__QList_QCamera_FrameRateRange_;
    return {};
}

// C++ to Python conversion for type 'QList<QSize >'.
static PyObject *_QList_QSize__CppToPython__QList_QSize_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QSize > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QSize >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QSize cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QSize__PythonToCpp__QList_QSize_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QSize > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QSize cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QSize__PythonToCpp__QList_QSize__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pyIn))
        return _QList_QSize__PythonToCpp__QList_QSize_;
    return {};
}

// C++ to Python conversion for type 'QList<QCameraViewfinderSettings >'.
static PyObject *_QList_QCameraViewfinderSettings__CppToPython__QList_QCameraViewfinderSettings_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QCameraViewfinderSettings > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QCameraViewfinderSettings >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QCameraViewfinderSettings cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAVIEWFINDERSETTINGS_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QCameraViewfinderSettings__PythonToCpp__QList_QCameraViewfinderSettings_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QCameraViewfinderSettings > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QCameraViewfinderSettings cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAVIEWFINDERSETTINGS_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QCameraViewfinderSettings__PythonToCpp__QList_QCameraViewfinderSettings__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAVIEWFINDERSETTINGS_IDX]), pyIn))
        return _QList_QCameraViewfinderSettings__PythonToCpp__QList_QCameraViewfinderSettings_;
    return {};
}

// C++ to Python conversion for type 'QList<qreal >'.
static PyObject *_QList_qreal__CppToPython__QList_qreal_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<qreal > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<qreal >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        qreal cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_qreal__PythonToCpp__QList_qreal_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<qreal > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        qreal cppItem;
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_qreal__PythonToCpp__QList_qreal__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), pyIn))
        return _QList_qreal__PythonToCpp__QList_qreal_;
    return {};
}

// C++ to Python conversion for type 'QList<QVariant >'.
static PyObject *_QList_QVariant__CppToPython__QList_QVariant_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QVariant > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QVariant >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QVariant cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QVariant__PythonToCpp__QList_QVariant_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QVariant > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QVariant cppItem;
        Shiboken::Conversions::pythonToCppCopy(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QVariant__PythonToCpp__QList_QVariant__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyIn))
        return _QList_QVariant__PythonToCpp__QList_QVariant_;
    return {};
}

// C++ to Python conversion for type 'QList<QCameraFocusZone >'.
static PyObject *_QList_QCameraFocusZone__CppToPython__QList_QCameraFocusZone_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QCameraFocusZone > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QCameraFocusZone >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QCameraFocusZone cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUSZONE_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QCameraFocusZone__PythonToCpp__QList_QCameraFocusZone_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QCameraFocusZone > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QCameraFocusZone cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUSZONE_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QCameraFocusZone__PythonToCpp__QList_QCameraFocusZone__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUSZONE_IDX]), pyIn))
        return _QList_QCameraFocusZone__PythonToCpp__QList_QCameraFocusZone_;
    return {};
}

// C++ to Python conversion for type 'QList<QCameraInfo >'.
static PyObject *_QList_QCameraInfo__CppToPython__QList_QCameraInfo_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QCameraInfo > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QCameraInfo >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QCameraInfo cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAINFO_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QCameraInfo__PythonToCpp__QList_QCameraInfo_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QCameraInfo > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QCameraInfo cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAINFO_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QCameraInfo__PythonToCpp__QList_QCameraInfo__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAINFO_IDX]), pyIn))
        return _QList_QCameraInfo__PythonToCpp__QList_QCameraInfo_;
    return {};
}

// C++ to Python conversion for type 'const QList<QMediaResource > &'.
static PyObject *_constQList_QMediaResource_REF_CppToPython__constQList_QMediaResource_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QMediaResource > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QMediaResource >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QMediaResource cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARESOURCE_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QMediaResource_REF_PythonToCpp__constQList_QMediaResource_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QMediaResource > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QMediaResource cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARESOURCE_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QMediaResource_REF_PythonToCpp__constQList_QMediaResource_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARESOURCE_IDX]), pyIn))
        return _constQList_QMediaResource_REF_PythonToCpp__constQList_QMediaResource_REF;
    return {};
}

// C++ to Python conversion for type 'const QList<QNetworkConfiguration > &'.
static PyObject *_constQList_QNetworkConfiguration_REF_CppToPython__constQList_QNetworkConfiguration_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QNetworkConfiguration > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QNetworkConfiguration >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QNetworkConfiguration cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QNetworkConfiguration_REF_PythonToCpp__constQList_QNetworkConfiguration_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QNetworkConfiguration > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QNetworkConfiguration cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QNetworkConfiguration_REF_PythonToCpp__constQList_QNetworkConfiguration_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKCONFIGURATION_IDX]), pyIn))
        return _constQList_QNetworkConfiguration_REF_PythonToCpp__constQList_QNetworkConfiguration_REF;
    return {};
}

// C++ to Python conversion for type 'const QVector<QAbstractVideoSurface* > &'.
static PyObject *_constQVector_QAbstractVideoSurfacePTR_REF_CppToPython__constQVector_QAbstractVideoSurfacePTR_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QVector<QAbstractVideoSurface* > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cppvector_to_pylist_conversion - START
    ::QVector<QAbstractVideoSurface* >::size_type vectorSize = cppInRef.size();
    PyObject* pyOut = PyList_New((int) vectorSize);
    for (::QVector<QAbstractVideoSurface* >::size_type idx = 0; idx < vectorSize; ++idx) {
        ::QAbstractVideoSurface* cppItem(cppInRef[idx]);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOSURFACE_IDX]), cppItem));
    }
    return pyOut;
    // TEMPLATE - cppvector_to_pylist_conversion - END

}
static void _constQVector_QAbstractVideoSurfacePTR_REF_PythonToCpp__constQVector_QAbstractVideoSurfacePTR_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QVector<QAbstractVideoSurface* > *>(cppOut);
    // TEMPLATE - pyseq_to_cppvector_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    if (PySequence_Check(pyIn)) {
        int vectorSize = PySequence_Size(pyIn);
        cppOutRef.reserve(vectorSize);
    }
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QAbstractVideoSurface* cppItem{nullptr};
        Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOSURFACE_IDX]), pyItem, &(cppItem));
        cppOutRef.push_back(cppItem);
    }
    // TEMPLATE - pyseq_to_cppvector_conversion - END

}
static PythonToCppFunc is__constQVector_QAbstractVideoSurfacePTR_REF_PythonToCpp__constQVector_QAbstractVideoSurfacePTR_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::checkSequenceTypes(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOSURFACE_IDX], pyIn))
        return _constQVector_QAbstractVideoSurfacePTR_REF_PythonToCpp__constQVector_QAbstractVideoSurfacePTR_REF;
    return {};
}

// C++ to Python conversion for type 'const QList<QMediaContent > &'.
static PyObject *_constQList_QMediaContent_REF_CppToPython__constQList_QMediaContent_REF(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QMediaContent > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QMediaContent >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QMediaContent cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIACONTENT_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _constQList_QMediaContent_REF_PythonToCpp__constQList_QMediaContent_REF(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QMediaContent > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QMediaContent cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIACONTENT_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__constQList_QMediaContent_REF_PythonToCpp__constQList_QMediaContent_REF_Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIACONTENT_IDX]), pyIn))
        return _constQList_QMediaContent_REF_PythonToCpp__constQList_QMediaContent_REF;
    return {};
}

// C++ to Python conversion for type 'QList<QMediaTimeInterval >'.
static PyObject *_QList_QMediaTimeInterval__CppToPython__QList_QMediaTimeInterval_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QList<QMediaTimeInterval > *>(const_cast<void *>(cppIn));
    // TEMPLATE - cpplist_to_pylist_conversion - START
    PyObject* pyOut = PyList_New((int) cppInRef.size());
    ::QList<QMediaTimeInterval >::const_iterator it = cppInRef.begin();
    for (int idx = 0; it != cppInRef.end(); ++it, ++idx) {
        ::QMediaTimeInterval cppItem(*it);
        PyList_SET_ITEM(pyOut, idx, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMEINTERVAL_IDX]), &cppItem));
    }
    return pyOut;
    // TEMPLATE - cpplist_to_pylist_conversion - END

}
static void _QList_QMediaTimeInterval__PythonToCpp__QList_QMediaTimeInterval_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QList<QMediaTimeInterval > *>(cppOut);
    // TEMPLATE - pyseq_to_cpplist_conversion - START
    // PYSIDE-795: Turn all sequences into iterables.
    Shiboken::AutoDecRef it(PyObject_GetIter(pyIn));
    PyObject *(*iternext)(PyObject *) = *Py_TYPE(it)->tp_iternext;
    for (;;) {
        Shiboken::AutoDecRef pyItem(iternext(it));
        if (pyItem.isNull()) {
            if (PyErr_Occurred() && PyErr_ExceptionMatches(PyExc_StopIteration))
                PyErr_Clear();
            break;
        }
        ::QMediaTimeInterval cppItem;
        Shiboken::Conversions::pythonToCppCopy(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMEINTERVAL_IDX]), pyItem, &(cppItem));
        cppOutRef << cppItem;
    }
    // TEMPLATE - pyseq_to_cpplist_conversion - END

}
static PythonToCppFunc is__QList_QMediaTimeInterval__PythonToCpp__QList_QMediaTimeInterval__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertibleSequenceTypes(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMEINTERVAL_IDX]), pyIn))
        return _QList_QMediaTimeInterval__PythonToCpp__QList_QMediaTimeInterval_;
    return {};
}

// C++ to Python conversion for type 'QPair<int,int >'.
static PyObject *_QPair_int_int__CppToPython__QPair_int_int_(const void *cppIn) {
    auto &cppInRef = *reinterpret_cast<::QPair<int,int > *>(const_cast<void *>(cppIn));
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (return-qpair)]
    PyObject *pyOut = PyTuple_New(2);
    PyTuple_SET_ITEM(pyOut, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppInRef.first));
    PyTuple_SET_ITEM(pyOut, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppInRef.second));
    return pyOut;
    // END of custom code block [file: ../glue/qtcore.cpp (return-qpair)]
    // ========================================================================

}
static void _QPair_int_int__PythonToCpp__QPair_int_int_(PyObject *pyIn, void *cppOut) {
    auto &cppOutRef = *reinterpret_cast<::QPair<int,int > *>(cppOut);
    // ========================================================================
    // START of custom code block [file: ../glue/qtcore.cpp (conversion-qpair-pysequence)]
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), PySequence_Fast_GET_ITEM(pyIn, 0), &(cppOutRef.first));
    Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<int>(), PySequence_Fast_GET_ITEM(pyIn, 1), &(cppOutRef.second));
    // END of custom code block [file: ../glue/qtcore.cpp (conversion-qpair-pysequence)]
    // ========================================================================

}
static PythonToCppFunc is__QPair_int_int__PythonToCpp__QPair_int_int__Convertible(PyObject *pyIn) {
    if (Shiboken::Conversions::convertiblePairTypes(Shiboken::Conversions::PrimitiveTypeConverter<int>(), false, Shiboken::Conversions::PrimitiveTypeConverter<int>(), false, pyIn))
        return _QPair_int_int__PythonToCpp__QPair_int_int_;
    return {};
}


#ifdef IS_PY3K
static struct PyModuleDef moduledef = {
    /* m_base     */ PyModuleDef_HEAD_INIT,
    /* m_name     */ "QtMultimedia",
    /* m_doc      */ nullptr,
    /* m_size     */ -1,
    /* m_methods  */ QtMultimedia_methods,
    /* m_reload   */ nullptr,
    /* m_traverse */ nullptr,
    /* m_clear    */ nullptr,
    /* m_free     */ nullptr
};

#endif

// The signatures string for the global functions.
// Multiple signatures have their index "n:" in front.
static const char *QtMultimedia_SignatureStrings[] = {
    nullptr}; // Sentinel

SBK_MODULE_INIT_FUNCTION_BEGIN(QtMultimedia)
    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.QtCore"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_QtCoreTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_QtCoreTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.QtGui"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_QtGuiTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_QtGuiTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    {
        Shiboken::AutoDecRef requiredModule(Shiboken::Module::import("PySide2.QtNetwork"));
        if (requiredModule.isNull())
            return SBK_MODULE_INIT_ERROR;
        SbkPySide2_QtNetworkTypes = Shiboken::Module::getTypes(requiredModule);
        SbkPySide2_QtNetworkTypeConverters = Shiboken::Module::getTypeConverters(requiredModule);
    }

    // Create an array of wrapper types for the current module.
    static PyTypeObject *cppApi[SBK_QtMultimedia_IDX_COUNT];
    SbkPySide2_QtMultimediaTypes = cppApi;

    // Create an array of primitive type converters for the current module.
    static SbkConverter *sbkConverters[SBK_QtMultimedia_CONVERTERS_IDX_COUNT];
    SbkPySide2_QtMultimediaTypeConverters = sbkConverters;

#ifdef IS_PY3K
    PyObject *module = Shiboken::Module::create("QtMultimedia", &moduledef);
#else
    PyObject *module = Shiboken::Module::create("QtMultimedia", QtMultimedia_methods);
#endif

    // Make module available from global scope
    SbkPySide2_QtMultimediaModuleObject = module;

    // Initialize classes in the type system
    init_QVideoSurfaceFormat(module);
    init_QVideoFrame(module);
    init_QVideoFilterRunnable(module);
    init_QVideoEncoderSettings(module);
    init_QtMultimediaQMultimedia(module);
    init_QMediaTimeRange(module);
    init_QMediaTimeInterval(module);
    init_QMediaServiceSupportedFormatsInterface(module);
    init_QMediaServiceSupportedDevicesInterface(module);
    init_QMediaServiceProviderHint(module);
    init_QMediaServiceFeaturesInterface(module);
    init_QMediaServiceDefaultDeviceInterface(module);
    init_QMediaServiceCameraInfoInterface(module);
    init_QMediaResource(module);
    init_QMediaBindableInterface(module);
    init_QImageEncoderSettings(module);
    init_QCameraViewfinderSettings(module);
    init_QCameraFocusZone(module);
    init_QAudioFormat(module);
    init_QAudioEncoderSettings(module);
    init_QAudioDeviceInfo(module);
    init_QAudioBuffer(module);
    init_QtMultimediaQAudio(module);
    init_QAbstractVideoBuffer(module);
    init_QAbstractVideoSurface(module);
    init_QAbstractVideoFilter(module);
    init_QAbstractAudioOutput(module);
    init_QAbstractAudioInput(module);
    init_QAbstractAudioDeviceInfo(module);
    init_QVideoProbe(module);
    init_QSoundEffect(module);
    init_QSound(module);
    init_QRadioData(module);
    init_QMediaService(module);
    init_QMediaRecorder(module);
    init_QAudioRecorder(module);
    init_QMediaPlaylist(module);
    init_QMediaObject(module);
    init_QAudioDecoder(module);
    init_QMediaPlayer(module);
    init_QCamera(module);
    init_QCamera_FrameRateRange(reinterpret_cast<PyTypeObject *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_IDX])->tp_dict);
    init_QRadioTuner(module);
    init_QMediaControl(module);
    init_QAudioRoleControl(module);
    init_QAudioOutputSelectorControl(module);
    init_QVideoEncoderSettingsControl(module);
    init_QAudioInputSelectorControl(module);
    init_QVideoDeviceSelectorControl(module);
    init_QAudioEncoderSettingsControl(module);
    init_QRadioTunerControl(module);
    init_QRadioDataControl(module);
    init_QAudioDecoderControl(module);
    init_QMetaDataWriterControl(module);
    init_QMetaDataReaderControl(module);
    init_QMediaVideoProbeControl(module);
    init_QMediaStreamsControl(module);
    init_QMediaRecorderControl(module);
    init_QMediaPlayerControl(module);
    init_QMediaNetworkAccessControl(module);
    init_QMediaGaplessPlaybackControl(module);
    init_QMediaContainerControl(module);
    init_QMediaAvailabilityControl(module);
    init_QMediaAudioProbeControl(module);
    init_QImageEncoderControl(module);
    init_QCustomAudioRoleControl(module);
    init_QCameraZoomControl(module);
    init_QCameraViewfinderSettingsControl2(module);
    init_QCameraViewfinderSettingsControl(module);
    init_QCameraLocksControl(module);
    init_QCameraInfoControl(module);
    init_QCameraImageProcessingControl(module);
    init_QCameraImageCaptureControl(module);
    init_QCameraFocusControl(module);
    init_QCameraFlashControl(module);
    init_QCameraFeedbackControl(module);
    init_QCameraExposureControl(module);
    init_QCameraControl(module);
    init_QCameraCaptureDestinationControl(module);
    init_QVideoWindowControl(module);
    init_QCameraCaptureBufferFormatControl(module);
    init_QVideoRendererControl(module);
    init_QCameraImageProcessing(module);
    init_QCameraImageCapture(module);
    init_QCameraFocus(module);
    init_QCameraExposure(module);
    init_QAudioProbe(module);
    init_QAudioOutput(module);
    init_QAudioInput(module);
    init_QCameraInfo(module);
    init_QMediaContent(module);

    // Register converter for type 'const QList<QObject*>&'.
    SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QOBJECTPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QObjectPTR_REF_CppToPython__constQList_QObjectPTR_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QOBJECTPTR_IDX], "const QList<QObject*>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QOBJECTPTR_IDX], "QList<QObject*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QOBJECTPTR_IDX],
        _constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF,
        is__constQList_QObjectPTR_REF_PythonToCpp__constQList_QObjectPTR_REF_Convertible);

    // Register converter for type 'QList<QByteArray>'.
    SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QBYTEARRAY_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QByteArray__CppToPython__QList_QByteArray_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QBYTEARRAY_IDX], "QList<QByteArray>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QBYTEARRAY_IDX],
        _QList_QByteArray__PythonToCpp__QList_QByteArray_,
        is__QList_QByteArray__PythonToCpp__QList_QByteArray__Convertible);

    // Register converter for type 'QList<QAudioFormat::Endian>'.
    SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QAUDIOFORMAT_ENDIAN_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QAudioFormat_Endian__CppToPython__QList_QAudioFormat_Endian_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QAUDIOFORMAT_ENDIAN_IDX], "QList<QAudioFormat::Endian>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QAUDIOFORMAT_ENDIAN_IDX],
        _QList_QAudioFormat_Endian__PythonToCpp__QList_QAudioFormat_Endian_,
        is__QList_QAudioFormat_Endian__PythonToCpp__QList_QAudioFormat_Endian__Convertible);

    // Register converter for type 'QList<int>'.
    SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_INT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_int__CppToPython__QList_int_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_INT_IDX], "QList<int>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_INT_IDX],
        _QList_int__PythonToCpp__QList_int_,
        is__QList_int__PythonToCpp__QList_int__Convertible);

    // Register converter for type 'QList<QAudioFormat::SampleType>'.
    SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QAUDIOFORMAT_SAMPLETYPE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QAudioFormat_SampleType__CppToPython__QList_QAudioFormat_SampleType_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QAUDIOFORMAT_SAMPLETYPE_IDX], "QList<QAudioFormat::SampleType>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QAUDIOFORMAT_SAMPLETYPE_IDX],
        _QList_QAudioFormat_SampleType__PythonToCpp__QList_QAudioFormat_SampleType_,
        is__QList_QAudioFormat_SampleType__PythonToCpp__QList_QAudioFormat_SampleType__Convertible);

    // Register converter for type 'QList<QVideoFrame::PixelFormat>'.
    SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QVIDEOFRAME_PIXELFORMAT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QVideoFrame_PixelFormat__CppToPython__QList_QVideoFrame_PixelFormat_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QVIDEOFRAME_PIXELFORMAT_IDX], "QList<QVideoFrame::PixelFormat>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QVIDEOFRAME_PIXELFORMAT_IDX],
        _QList_QVideoFrame_PixelFormat__PythonToCpp__QList_QVideoFrame_PixelFormat_,
        is__QList_QVideoFrame_PixelFormat__PythonToCpp__QList_QVideoFrame_PixelFormat__Convertible);

    // Register converter for type 'QList<QAudioDeviceInfo>'.
    SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QAUDIODEVICEINFO_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QAudioDeviceInfo__CppToPython__QList_QAudioDeviceInfo_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QAUDIODEVICEINFO_IDX], "QList<QAudioDeviceInfo>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QAUDIODEVICEINFO_IDX],
        _QList_QAudioDeviceInfo__PythonToCpp__QList_QAudioDeviceInfo_,
        is__QList_QAudioDeviceInfo__PythonToCpp__QList_QAudioDeviceInfo__Convertible);

    // Register converter for type 'QMap<QString,QVariant>'.
    SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QMAP_QSTRING_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyDict_Type, _QMap_QString_QVariant__CppToPython__QMap_QString_QVariant_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QMAP_QSTRING_QVARIANT_IDX], "QMap<QString,QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QMAP_QSTRING_QVARIANT_IDX],
        _QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant_,
        is__QMap_QString_QVariant__PythonToCpp__QMap_QString_QVariant__Convertible);

    // Register converter for type 'QList<QString>'.
    SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QSTRING_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QString__CppToPython__QList_QString_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QSTRING_IDX], "QList<QString>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QSTRING_IDX],
        _QList_QString__PythonToCpp__QList_QString_,
        is__QList_QString__PythonToCpp__QList_QString__Convertible);

    // Register converter for type 'QList<QAudio::Role>'.
    SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QAUDIO_ROLE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QAudio_Role__CppToPython__QList_QAudio_Role_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QAUDIO_ROLE_IDX], "QList<QAudio::Role>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QAUDIO_ROLE_IDX],
        _QList_QAudio_Role__PythonToCpp__QList_QAudio_Role_,
        is__QList_QAudio_Role__PythonToCpp__QList_QAudio_Role__Convertible);

    // Register converter for type 'QList<QCamera::FrameRateRange>'.
    SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QCAMERA_FRAMERATERANGE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QCamera_FrameRateRange__CppToPython__QList_QCamera_FrameRateRange_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QCAMERA_FRAMERATERANGE_IDX], "QList<QCamera::FrameRateRange>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QCAMERA_FRAMERATERANGE_IDX],
        _QList_QCamera_FrameRateRange__PythonToCpp__QList_QCamera_FrameRateRange_,
        is__QList_QCamera_FrameRateRange__PythonToCpp__QList_QCamera_FrameRateRange__Convertible);

    // Register converter for type 'QList<QSize>'.
    SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QSIZE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QSize__CppToPython__QList_QSize_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QSIZE_IDX], "QList<QSize>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QSIZE_IDX],
        _QList_QSize__PythonToCpp__QList_QSize_,
        is__QList_QSize__PythonToCpp__QList_QSize__Convertible);

    // Register converter for type 'QList<QCameraViewfinderSettings>'.
    SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QCAMERAVIEWFINDERSETTINGS_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QCameraViewfinderSettings__CppToPython__QList_QCameraViewfinderSettings_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QCAMERAVIEWFINDERSETTINGS_IDX], "QList<QCameraViewfinderSettings>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QCAMERAVIEWFINDERSETTINGS_IDX],
        _QList_QCameraViewfinderSettings__PythonToCpp__QList_QCameraViewfinderSettings_,
        is__QList_QCameraViewfinderSettings__PythonToCpp__QList_QCameraViewfinderSettings__Convertible);

    // Register converter for type 'QList<qreal>'.
    SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QREAL_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_qreal__CppToPython__QList_qreal_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QREAL_IDX], "QList<qreal>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QREAL_IDX],
        _QList_qreal__PythonToCpp__QList_qreal_,
        is__QList_qreal__PythonToCpp__QList_qreal__Convertible);

    // Register converter for type 'QList<QVariant>'.
    SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QVARIANT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QVariant__CppToPython__QList_QVariant_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QVARIANT_IDX], "QList<QVariant>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QVARIANT_IDX],
        _QList_QVariant__PythonToCpp__QList_QVariant_,
        is__QList_QVariant__PythonToCpp__QList_QVariant__Convertible);

    // Register converter for type 'QList<QCameraFocusZone>'.
    SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QCAMERAFOCUSZONE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QCameraFocusZone__CppToPython__QList_QCameraFocusZone_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QCAMERAFOCUSZONE_IDX], "QList<QCameraFocusZone>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QCAMERAFOCUSZONE_IDX],
        _QList_QCameraFocusZone__PythonToCpp__QList_QCameraFocusZone_,
        is__QList_QCameraFocusZone__PythonToCpp__QList_QCameraFocusZone__Convertible);

    // Register converter for type 'QList<QCameraInfo>'.
    SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QCAMERAINFO_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QCameraInfo__CppToPython__QList_QCameraInfo_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QCAMERAINFO_IDX], "QList<QCameraInfo>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QCAMERAINFO_IDX],
        _QList_QCameraInfo__PythonToCpp__QList_QCameraInfo_,
        is__QList_QCameraInfo__PythonToCpp__QList_QCameraInfo__Convertible);

    // Register converter for type 'const QList<QMediaResource>&'.
    SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QMEDIARESOURCE_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QMediaResource_REF_CppToPython__constQList_QMediaResource_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QMEDIARESOURCE_IDX], "const QList<QMediaResource>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QMEDIARESOURCE_IDX], "QList<QMediaResource>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QMEDIARESOURCE_IDX],
        _constQList_QMediaResource_REF_PythonToCpp__constQList_QMediaResource_REF,
        is__constQList_QMediaResource_REF_PythonToCpp__constQList_QMediaResource_REF_Convertible);

    // Register converter for type 'const QList<QNetworkConfiguration>&'.
    SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QNETWORKCONFIGURATION_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QNetworkConfiguration_REF_CppToPython__constQList_QNetworkConfiguration_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QNETWORKCONFIGURATION_IDX], "const QList<QNetworkConfiguration>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QNETWORKCONFIGURATION_IDX], "QList<QNetworkConfiguration>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QNETWORKCONFIGURATION_IDX],
        _constQList_QNetworkConfiguration_REF_PythonToCpp__constQList_QNetworkConfiguration_REF,
        is__constQList_QNetworkConfiguration_REF_PythonToCpp__constQList_QNetworkConfiguration_REF_Convertible);

    // Register converter for type 'const QVector<QAbstractVideoSurface*>&'.
    SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QVECTOR_QABSTRACTVIDEOSURFACEPTR_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQVector_QAbstractVideoSurfacePTR_REF_CppToPython__constQVector_QAbstractVideoSurfacePTR_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QVECTOR_QABSTRACTVIDEOSURFACEPTR_IDX], "const QVector<QAbstractVideoSurface*>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QVECTOR_QABSTRACTVIDEOSURFACEPTR_IDX], "QVector<QAbstractVideoSurface*>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QVECTOR_QABSTRACTVIDEOSURFACEPTR_IDX],
        _constQVector_QAbstractVideoSurfacePTR_REF_PythonToCpp__constQVector_QAbstractVideoSurfacePTR_REF,
        is__constQVector_QAbstractVideoSurfacePTR_REF_PythonToCpp__constQVector_QAbstractVideoSurfacePTR_REF_Convertible);

    // Register converter for type 'const QList<QMediaContent>&'.
    SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QMEDIACONTENT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _constQList_QMediaContent_REF_CppToPython__constQList_QMediaContent_REF);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QMEDIACONTENT_IDX], "const QList<QMediaContent>&");
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QMEDIACONTENT_IDX], "QList<QMediaContent>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QMEDIACONTENT_IDX],
        _constQList_QMediaContent_REF_PythonToCpp__constQList_QMediaContent_REF,
        is__constQList_QMediaContent_REF_PythonToCpp__constQList_QMediaContent_REF_Convertible);

    // Register converter for type 'QList<QMediaTimeInterval>'.
    SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QMEDIATIMEINTERVAL_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QList_QMediaTimeInterval__CppToPython__QList_QMediaTimeInterval_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QMEDIATIMEINTERVAL_IDX], "QList<QMediaTimeInterval>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QMEDIATIMEINTERVAL_IDX],
        _QList_QMediaTimeInterval__PythonToCpp__QList_QMediaTimeInterval_,
        is__QList_QMediaTimeInterval__PythonToCpp__QList_QMediaTimeInterval__Convertible);

    // Register converter for type 'QPair<int,int>'.
    SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QPAIR_INT_INT_IDX] = Shiboken::Conversions::createConverter(&PyList_Type, _QPair_int_int__CppToPython__QPair_int_int_);
    Shiboken::Conversions::registerConverterName(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QPAIR_INT_INT_IDX], "QPair<int,int>");
    Shiboken::Conversions::addPythonToCppValueConversion(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QPAIR_INT_INT_IDX],
        _QPair_int_int__PythonToCpp__QPair_int_int_,
        is__QPair_int_int__PythonToCpp__QPair_int_int__Convertible);

    // Register primitive types converters.

    Shiboken::Module::registerTypes(module, SbkPySide2_QtMultimediaTypes);
    Shiboken::Module::registerTypeConverters(module, SbkPySide2_QtMultimediaTypeConverters);

    if (PyErr_Occurred()) {
        PyErr_Print();
        Py_FatalError("can't initialize module QtMultimedia");
    }
    PySide::registerCleanupFunction(cleanTypesAttributes);

    FinishSignatureInitialization(module, QtMultimedia_SignatureStrings);

SBK_MODULE_INIT_FUNCTION_END
