/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef SBK_QRADIOTUNERCONTROLWRAPPER_H
#define SBK_QRADIOTUNERCONTROLWRAPPER_H

#define protected public

#include <QtMultimedia/qradiotunercontrol.h>


// Extra includes
#include <qobject.h>
#include <QPair>
#include <qcoreevent.h>
#include <qmetaobject.h>
#include <qobjectdefs.h>
namespace PySide { class DynamicQMetaObject; }

class QRadioTunerControlWrapper : public QRadioTunerControl
{
public:
    QRadioTunerControlWrapper(::QObject * parent = nullptr);
    ::QRadioTuner::Band band() const override;
    void cancelSearch() override;
    void childEvent(::QChildEvent * event) override;
    void connectNotify(const ::QMetaMethod & signal) override;
    void customEvent(::QEvent * event) override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    ::QRadioTuner::Error error() const override;
    ::QString errorString() const override;
    bool event(::QEvent * event) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    int frequency() const override;
    ::QPair<int,int > frequencyRange(::QRadioTuner::Band b) const override;
    int frequencyStep(::QRadioTuner::Band b) const override;
    bool isAntennaConnected() const override;
    bool isBandSupported(::QRadioTuner::Band b) const override;
    bool isMuted() const override;
    bool isSearching() const override;
    bool isStereo() const override;
    const ::QMetaObject * metaObject() const override;
    void searchAllStations(::QRadioTuner::SearchMode searchMode = QRadioTuner::SearchFast) override;
    void searchBackward() override;
    void searchForward() override;
    void setBand(::QRadioTuner::Band b) override;
    void setFrequency(int frequency) override;
    void setMuted(bool muted) override;
    void setStereoMode(::QRadioTuner::StereoMode mode) override;
    void setVolume(int volume) override;
    int signalStrength() const override;
    void start() override;
    ::QRadioTuner::State state() const override;
    ::QRadioTuner::StereoMode stereoMode() const override;
    void stop() override;
    void timerEvent(::QTimerEvent * event) override;
    int volume() const override;
    ~QRadioTunerControlWrapper();
public:
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    // Inherited overloads, because the using keyword sux
    inline void error(::QRadioTuner::Error err) { QRadioTunerControl::error(QRadioTuner::Error(err)); }
    static void pysideInitQtMetaTypes();
    void resetPyMethodCache();
private:
    mutable bool m_PyMethodCache[34];
};

#endif // SBK_QRADIOTUNERCONTROLWRAPPER_H

