/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtmultimedia_python.h"

// main header
#include "qmediatimerange_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <QtMultimedia/qmediatimerange.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QMediaTimeRange_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QMediaTimeRange >()))
        return -1;

    ::QMediaTimeRange *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaTimeRange.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QMediaTimeRange", 0, 2, &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QMediaTimeRange::QMediaTimeRange()
    // 1: QMediaTimeRange::QMediaTimeRange(QMediaTimeInterval)
    // 2: QMediaTimeRange::QMediaTimeRange(QMediaTimeRange)
    // 3: QMediaTimeRange::QMediaTimeRange(qint64,qint64)
    if (numArgs == 0) {
        overloadId = 0; // QMediaTimeRange()
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[1])))) {
        overloadId = 3; // QMediaTimeRange(qint64,qint64)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMEINTERVAL_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QMediaTimeRange(QMediaTimeInterval)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QMediaTimeRange(QMediaTimeRange)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaTimeRange_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QMediaTimeRange()
        {

            if (!PyErr_Occurred()) {
                // QMediaTimeRange()
                cptr = new ::QMediaTimeRange();
            }
            break;
        }
        case 1: // QMediaTimeRange(const QMediaTimeInterval & arg__1)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QMediaTimeInterval cppArg0_local;
            ::QMediaTimeInterval *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMEINTERVAL_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QMediaTimeRange(QMediaTimeInterval)
                cptr = new ::QMediaTimeRange(*cppArg0);
            }
            break;
        }
        case 2: // QMediaTimeRange(const QMediaTimeRange & range)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QMediaTimeRange cppArg0_local;
            ::QMediaTimeRange *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QMediaTimeRange(QMediaTimeRange)
                cptr = new ::QMediaTimeRange(*cppArg0);
            }
            break;
        }
        case 3: // QMediaTimeRange(qint64 start, qint64 end)
        {
            qint64 cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            qint64 cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QMediaTimeRange(qint64,qint64)
                cptr = new ::QMediaTimeRange(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QMediaTimeRange >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QMediaTimeRange_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QMediaTimeRange_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QMediaTimeRangeFunc_addInterval(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaTimeRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaTimeRange.addInterval";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "addInterval", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QMediaTimeRange::addInterval(QMediaTimeInterval)
    // 1: QMediaTimeRange::addInterval(qint64,qint64)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[1])))) {
        overloadId = 1; // addInterval(qint64,qint64)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMEINTERVAL_IDX]), (pyArgs[0])))) {
        overloadId = 0; // addInterval(QMediaTimeInterval)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaTimeRangeFunc_addInterval_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // addInterval(const QMediaTimeInterval & interval)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QMediaTimeInterval cppArg0_local;
            ::QMediaTimeInterval *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMEINTERVAL_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // addInterval(QMediaTimeInterval)
                cppSelf->addInterval(*cppArg0);
            }
            break;
        }
        case 1: // addInterval(qint64 start, qint64 end)
        {
            qint64 cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            qint64 cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // addInterval(qint64,qint64)
                cppSelf->addInterval(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMediaTimeRangeFunc_addInterval_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMediaTimeRangeFunc_addTimeRange(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaTimeRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaTimeRange.addTimeRange";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMediaTimeRange::addTimeRange(QMediaTimeRange)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX]), (pyArg)))) {
        overloadId = 0; // addTimeRange(QMediaTimeRange)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaTimeRangeFunc_addTimeRange_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMediaTimeRange cppArg0_local;
        ::QMediaTimeRange *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // addTimeRange(QMediaTimeRange)
            cppSelf->addTimeRange(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMediaTimeRangeFunc_addTimeRange_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMediaTimeRangeFunc_clear(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaTimeRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaTimeRange.clear";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clear()
            cppSelf->clear();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QMediaTimeRangeFunc_contains(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaTimeRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaTimeRange.contains";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMediaTimeRange::contains(qint64)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // contains(qint64)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaTimeRangeFunc_contains_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // contains(qint64)const
            bool cppResult = const_cast<const ::QMediaTimeRange *>(cppSelf)->contains(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMediaTimeRangeFunc_contains_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMediaTimeRangeFunc_earliestTime(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaTimeRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaTimeRange.earliestTime";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // earliestTime()const
            qint64 cppResult = const_cast<const ::QMediaTimeRange *>(cppSelf)->earliestTime();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaTimeRangeFunc_intervals(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaTimeRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaTimeRange.intervals";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // intervals()const
            QList<QMediaTimeInterval > cppResult = const_cast<const ::QMediaTimeRange *>(cppSelf)->intervals();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QMEDIATIMEINTERVAL_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaTimeRangeFunc_isContinuous(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaTimeRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaTimeRange.isContinuous";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isContinuous()const
            bool cppResult = const_cast<const ::QMediaTimeRange *>(cppSelf)->isContinuous();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaTimeRangeFunc_isEmpty(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaTimeRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaTimeRange.isEmpty";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isEmpty()const
            bool cppResult = const_cast<const ::QMediaTimeRange *>(cppSelf)->isEmpty();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaTimeRangeFunc_latestTime(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaTimeRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaTimeRange.latestTime";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // latestTime()const
            qint64 cppResult = const_cast<const ::QMediaTimeRange *>(cppSelf)->latestTime();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaTimeRangeFunc_removeInterval(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaTimeRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaTimeRange.removeInterval";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "removeInterval", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QMediaTimeRange::removeInterval(QMediaTimeInterval)
    // 1: QMediaTimeRange::removeInterval(qint64,qint64)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[1])))) {
        overloadId = 1; // removeInterval(qint64,qint64)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMEINTERVAL_IDX]), (pyArgs[0])))) {
        overloadId = 0; // removeInterval(QMediaTimeInterval)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaTimeRangeFunc_removeInterval_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // removeInterval(const QMediaTimeInterval & interval)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QMediaTimeInterval cppArg0_local;
            ::QMediaTimeInterval *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMEINTERVAL_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // removeInterval(QMediaTimeInterval)
                cppSelf->removeInterval(*cppArg0);
            }
            break;
        }
        case 1: // removeInterval(qint64 start, qint64 end)
        {
            qint64 cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            qint64 cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // removeInterval(qint64,qint64)
                cppSelf->removeInterval(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMediaTimeRangeFunc_removeInterval_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMediaTimeRangeFunc_removeTimeRange(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaTimeRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaTimeRange.removeTimeRange";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMediaTimeRange::removeTimeRange(QMediaTimeRange)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX]), (pyArg)))) {
        overloadId = 0; // removeTimeRange(QMediaTimeRange)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaTimeRangeFunc_removeTimeRange_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMediaTimeRange cppArg0_local;
        ::QMediaTimeRange *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // removeTimeRange(QMediaTimeRange)
            cppSelf->removeTimeRange(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMediaTimeRangeFunc_removeTimeRange_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMediaTimeRange___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QMediaTimeRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QMediaTimeRange_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QMediaTimeRange_methods[] = {
    {"addInterval", reinterpret_cast<PyCFunction>(Sbk_QMediaTimeRangeFunc_addInterval), METH_VARARGS},
    {"addTimeRange", reinterpret_cast<PyCFunction>(Sbk_QMediaTimeRangeFunc_addTimeRange), METH_O},
    {"clear", reinterpret_cast<PyCFunction>(Sbk_QMediaTimeRangeFunc_clear), METH_NOARGS},
    {"contains", reinterpret_cast<PyCFunction>(Sbk_QMediaTimeRangeFunc_contains), METH_O},
    {"earliestTime", reinterpret_cast<PyCFunction>(Sbk_QMediaTimeRangeFunc_earliestTime), METH_NOARGS},
    {"intervals", reinterpret_cast<PyCFunction>(Sbk_QMediaTimeRangeFunc_intervals), METH_NOARGS},
    {"isContinuous", reinterpret_cast<PyCFunction>(Sbk_QMediaTimeRangeFunc_isContinuous), METH_NOARGS},
    {"isEmpty", reinterpret_cast<PyCFunction>(Sbk_QMediaTimeRangeFunc_isEmpty), METH_NOARGS},
    {"latestTime", reinterpret_cast<PyCFunction>(Sbk_QMediaTimeRangeFunc_latestTime), METH_NOARGS},
    {"removeInterval", reinterpret_cast<PyCFunction>(Sbk_QMediaTimeRangeFunc_removeInterval), METH_VARARGS},
    {"removeTimeRange", reinterpret_cast<PyCFunction>(Sbk_QMediaTimeRangeFunc_removeTimeRange), METH_O},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QMediaTimeRange___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QMediaTimeRangeFunc___add__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaTimeRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaTimeRange.__add__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMediaTimeRange::operator+(QMediaTimeRange,QMediaTimeRange)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX]), (pyArg)))) {
        overloadId = 0; // operator+(QMediaTimeRange,QMediaTimeRange)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaTimeRangeFunc___add___TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMediaTimeRange cppArg0_local;
        ::QMediaTimeRange *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // operator+(QMediaTimeRange,QMediaTimeRange)
            QMediaTimeRange cppResult = (*cppSelf) + (*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMediaTimeRangeFunc___add___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMediaTimeRangeFunc___iadd__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaTimeRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaTimeRange.__iadd__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMediaTimeRange::operator+=(QMediaTimeInterval)
    // 1: QMediaTimeRange::operator+=(QMediaTimeRange)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMEINTERVAL_IDX]), (pyArg)))) {
        overloadId = 0; // operator+=(QMediaTimeInterval)
    } else if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX]), (pyArg)))) {
        overloadId = 1; // operator+=(QMediaTimeRange)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaTimeRangeFunc___iadd___TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // operator+=(const QMediaTimeInterval & arg__1)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QMediaTimeInterval cppArg0_local;
            ::QMediaTimeInterval *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMEINTERVAL_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // operator+=(QMediaTimeInterval)
                (*cppSelf) += (*cppArg0);
            }
            break;
        }
        case 1: // operator+=(const QMediaTimeRange & arg__1)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QMediaTimeRange cppArg0_local;
            ::QMediaTimeRange *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // operator+=(QMediaTimeRange)
                (*cppSelf) += (*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_INCREF(self);
    return self;

    Sbk_QMediaTimeRangeFunc___iadd___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMediaTimeRangeFunc___sub__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaTimeRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaTimeRange.__sub__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMediaTimeRange::operator-(QMediaTimeRange,QMediaTimeRange)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX]), (pyArg)))) {
        overloadId = 0; // operator-(QMediaTimeRange,QMediaTimeRange)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaTimeRangeFunc___sub___TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMediaTimeRange cppArg0_local;
        ::QMediaTimeRange *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // operator-(QMediaTimeRange,QMediaTimeRange)
            QMediaTimeRange cppResult = (*cppSelf) - (*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMediaTimeRangeFunc___sub___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMediaTimeRangeFunc___isub__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaTimeRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaTimeRange.__isub__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMediaTimeRange::operator-=(QMediaTimeInterval)
    // 1: QMediaTimeRange::operator-=(QMediaTimeRange)
    if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMEINTERVAL_IDX]), (pyArg)))) {
        overloadId = 0; // operator-=(QMediaTimeInterval)
    } else if (!isReverse
        && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX]), (pyArg)))) {
        overloadId = 1; // operator-=(QMediaTimeRange)
    }

    if (isReverse && overloadId == -1) {
        PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
        return {};
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaTimeRangeFunc___isub___TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // operator-=(const QMediaTimeInterval & arg__1)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QMediaTimeInterval cppArg0_local;
            ::QMediaTimeInterval *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMEINTERVAL_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // operator-=(QMediaTimeInterval)
                (*cppSelf) -= (*cppArg0);
            }
            break;
        }
        case 1: // operator-=(const QMediaTimeRange & arg__1)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QMediaTimeRange cppArg0_local;
            ::QMediaTimeRange *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // operator-=(QMediaTimeRange)
                (*cppSelf) -= (*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_INCREF(self);
    return self;

    Sbk_QMediaTimeRangeFunc___isub___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

// Rich comparison
static PyObject * Sbk_QMediaTimeRange_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QMediaTimeRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX]), (pyArg)))) {
                // operator!=(const QMediaTimeRange & arg__2)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QMediaTimeRange cppArg0_local;
                ::QMediaTimeRange *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX]), (pyArg)))) {
                // operator==(const QMediaTimeRange & arg__2)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QMediaTimeRange cppArg0_local;
                ::QMediaTimeRange *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QMediaTimeRange_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QMediaTimeRange_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QMediaTimeRange_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QMediaTimeRange_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QMediaTimeRange__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaTimeRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QMediaTimeRange_Type = nullptr;
static SbkObjectType *Sbk_QMediaTimeRange_TypeF(void)
{
    return _Sbk_QMediaTimeRange_Type;
}

static PyType_Slot Sbk_QMediaTimeRange_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QMediaTimeRange__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QMediaTimeRange_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QMediaTimeRange_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QMediaTimeRange_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QMediaTimeRange_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QMediaTimeRange_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
    {Py_nb_inplace_add, (void *)Sbk_QMediaTimeRangeFunc___iadd__},
    {Py_nb_add, (void *)Sbk_QMediaTimeRangeFunc___add__},
    {Py_nb_inplace_subtract, (void *)Sbk_QMediaTimeRangeFunc___isub__},
    {Py_nb_subtract, (void *)Sbk_QMediaTimeRangeFunc___sub__},
    {0, nullptr}
};
static PyType_Spec Sbk_QMediaTimeRange_spec = {
    "2:PySide2.QtMultimedia.QMediaTimeRange",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QMediaTimeRange_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QMediaTimeRange_PythonToCpp_QMediaTimeRange_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QMediaTimeRange_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QMediaTimeRange_PythonToCpp_QMediaTimeRange_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QMediaTimeRange_TypeF())))
        return QMediaTimeRange_PythonToCpp_QMediaTimeRange_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QMediaTimeRange_PTR_CppToPython_QMediaTimeRange(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QMediaTimeRange *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QMediaTimeRange_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QMediaTimeRange_COPY_CppToPython_QMediaTimeRange(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QMediaTimeRange_TypeF(), new ::QMediaTimeRange(*reinterpret_cast<const ::QMediaTimeRange *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QMediaTimeRange_PythonToCpp_QMediaTimeRange_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QMediaTimeRange *>(cppOut) = *reinterpret_cast< ::QMediaTimeRange *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QMediaTimeRange_PythonToCpp_QMediaTimeRange_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QMediaTimeRange_TypeF())))
        return QMediaTimeRange_PythonToCpp_QMediaTimeRange_COPY;
    return {};
}

// Implicit conversions.
static void constQMediaTimeIntervalREF_PythonToCpp_QMediaTimeRange(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QMediaTimeRange *>(cppOut) = ::QMediaTimeRange( *reinterpret_cast< ::QMediaTimeInterval *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMEINTERVAL_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_constQMediaTimeIntervalREF_PythonToCpp_QMediaTimeRange_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMEINTERVAL_IDX], pyIn))
        return constQMediaTimeIntervalREF_PythonToCpp_QMediaTimeRange;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QMediaTimeRange_SignatureStrings[] = {
    "3:PySide2.QtMultimedia.QMediaTimeRange(self)",
    "2:PySide2.QtMultimedia.QMediaTimeRange(self,arg__1:PySide2.QtMultimedia.QMediaTimeInterval)",
    "1:PySide2.QtMultimedia.QMediaTimeRange(self,range:PySide2.QtMultimedia.QMediaTimeRange)",
    "0:PySide2.QtMultimedia.QMediaTimeRange(self,start:qint64,end:qint64)",
    "1:PySide2.QtMultimedia.QMediaTimeRange.addInterval(self,interval:PySide2.QtMultimedia.QMediaTimeInterval)",
    "0:PySide2.QtMultimedia.QMediaTimeRange.addInterval(self,start:qint64,end:qint64)",
    "PySide2.QtMultimedia.QMediaTimeRange.addTimeRange(self,arg__1:PySide2.QtMultimedia.QMediaTimeRange)",
    "PySide2.QtMultimedia.QMediaTimeRange.clear(self)",
    "PySide2.QtMultimedia.QMediaTimeRange.contains(self,time:qint64)->bool",
    "PySide2.QtMultimedia.QMediaTimeRange.earliestTime(self)->qint64",
    "PySide2.QtMultimedia.QMediaTimeRange.intervals(self)->QList[PySide2.QtMultimedia.QMediaTimeInterval]",
    "PySide2.QtMultimedia.QMediaTimeRange.isContinuous(self)->bool",
    "PySide2.QtMultimedia.QMediaTimeRange.isEmpty(self)->bool",
    "PySide2.QtMultimedia.QMediaTimeRange.latestTime(self)->qint64",
    "1:PySide2.QtMultimedia.QMediaTimeRange.removeInterval(self,interval:PySide2.QtMultimedia.QMediaTimeInterval)",
    "0:PySide2.QtMultimedia.QMediaTimeRange.removeInterval(self,start:qint64,end:qint64)",
    "PySide2.QtMultimedia.QMediaTimeRange.removeTimeRange(self,arg__1:PySide2.QtMultimedia.QMediaTimeRange)",
    "PySide2.QtMultimedia.QMediaTimeRange.__copy__()",
    "PySide2.QtMultimedia.QMediaTimeRange.__add__(self,arg__2:PySide2.QtMultimedia.QMediaTimeRange)->PySide2.QtMultimedia.QMediaTimeRange",
    "1:PySide2.QtMultimedia.QMediaTimeRange.__iadd__(self,arg__1:PySide2.QtMultimedia.QMediaTimeInterval)->PySide2.QtMultimedia.QMediaTimeRange",
    "0:PySide2.QtMultimedia.QMediaTimeRange.__iadd__(self,arg__1:PySide2.QtMultimedia.QMediaTimeRange)->PySide2.QtMultimedia.QMediaTimeRange",
    "PySide2.QtMultimedia.QMediaTimeRange.__sub__(self,arg__2:PySide2.QtMultimedia.QMediaTimeRange)->PySide2.QtMultimedia.QMediaTimeRange",
    "1:PySide2.QtMultimedia.QMediaTimeRange.__isub__(self,arg__1:PySide2.QtMultimedia.QMediaTimeInterval)->PySide2.QtMultimedia.QMediaTimeRange",
    "0:PySide2.QtMultimedia.QMediaTimeRange.__isub__(self,arg__1:PySide2.QtMultimedia.QMediaTimeRange)->PySide2.QtMultimedia.QMediaTimeRange",
    nullptr}; // Sentinel

void init_QMediaTimeRange(PyObject *module)
{
    _Sbk_QMediaTimeRange_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QMediaTimeRange",
        "QMediaTimeRange",
        &Sbk_QMediaTimeRange_spec,
        &Shiboken::callCppDestructor< ::QMediaTimeRange >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QMediaTimeRange_Type);
    InitSignatureStrings(pyType, QMediaTimeRange_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QMediaTimeRange_Type), Sbk_QMediaTimeRange_PropertyStrings);
    SbkPySide2_QtMultimediaTypes[SBK_QMEDIATIMERANGE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QMediaTimeRange_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QMediaTimeRange_TypeF(),
        QMediaTimeRange_PythonToCpp_QMediaTimeRange_PTR,
        is_QMediaTimeRange_PythonToCpp_QMediaTimeRange_PTR_Convertible,
        QMediaTimeRange_PTR_CppToPython_QMediaTimeRange,
        QMediaTimeRange_COPY_CppToPython_QMediaTimeRange);

    Shiboken::Conversions::registerConverterName(converter, "QMediaTimeRange");
    Shiboken::Conversions::registerConverterName(converter, "QMediaTimeRange*");
    Shiboken::Conversions::registerConverterName(converter, "QMediaTimeRange&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QMediaTimeRange).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QMediaTimeRange_PythonToCpp_QMediaTimeRange_COPY,
        is_QMediaTimeRange_PythonToCpp_QMediaTimeRange_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        constQMediaTimeIntervalREF_PythonToCpp_QMediaTimeRange,
        is_constQMediaTimeIntervalREF_PythonToCpp_QMediaTimeRange_Convertible);

    qRegisterMetaType< ::QMediaTimeRange >("QMediaTimeRange");
}
