/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <algorithm>
#include <set>
#include <iterator>

// module include
#include "pyside2_qtmultimedia_python.h"

// main header
#include "qmediarecorder_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QMediaRecorderWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QMediaRecorderWrapper::QMediaRecorderWrapper(::QMediaObject * mediaObject, ::QObject * parent) : QMediaRecorder(mediaObject, parent)
{
    resetPyMethodCache();
    // ... middle
}

void QMediaRecorderWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QMediaRecorderWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QMediaRecorderWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QMediaRecorderWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QMediaRecorderWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QMediaRecorder.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QMediaRecorderWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QMediaRecorder.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

::QMediaObject * QMediaRecorderWrapper::mediaObject() const
{
    if (m_PyMethodCache[6])
        return this->::QMediaRecorder::mediaObject();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mediaObject";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QMediaRecorder::mediaObject();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAOBJECT_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QMediaRecorder.mediaObject", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QMediaObject >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QMediaObject *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QMediaRecorderWrapper::setMediaObject(::QMediaObject * object)
{
    if (m_PyMethodCache[8])
        return this->::QMediaRecorder::setMediaObject(object);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setMediaObject";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QMediaRecorder::setMediaObject(object);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAOBJECT_IDX]), object)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QMediaRecorder.setMediaObject", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QMediaRecorderWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[9]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QMediaRecorderWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QMediaRecorder::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QMediaRecorderWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QMediaRecorder::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QMediaRecorderWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QMediaRecorderWrapper *>(this));
        return QMediaRecorder::qt_metacast(_clname);
}

QMediaRecorderWrapper::~QMediaRecorderWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QMediaRecorder_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_IDX]);
    if (type != myType)
        Shiboken::ObjectType::copyMultipleInheritance(type, myType);

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QMediaRecorder >()))
        return -1;

    ::QMediaRecorderWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaRecorder.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QMediaRecorder_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:QMediaRecorder", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QMediaRecorder::QMediaRecorder(QMediaObject*,QObject*)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAOBJECT_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // QMediaRecorder(QMediaObject*,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
            overloadId = 0; // QMediaRecorder(QMediaObject*,QObject*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaRecorder_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[1]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QMediaRecorder_Init_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1]))))
                        goto Sbk_QMediaRecorder_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QMediaObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return -1;
        ::QObject *cppArg1 = nullptr;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // QMediaRecorder(QMediaObject*,QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QMediaRecorderWrapper(cppArg0, cppArg1);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QMediaRecorderWrapper(cppArg0, cppArg1);
            }

            Shiboken::Object::setParent(pyArgs[1], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QMediaRecorder >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QMediaRecorder_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QMediaRecorder_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QMediaRecorder_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QMediaRecorderFunc_actualLocation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaRecorder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaRecorder.actualLocation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // actualLocation()const
            QUrl cppResult = const_cast<const ::QMediaRecorder *>(cppSelf)->actualLocation();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaRecorderFunc_audioCodecDescription(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaRecorder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaRecorder.audioCodecDescription";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMediaRecorder::audioCodecDescription(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // audioCodecDescription(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaRecorderFunc_audioCodecDescription_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // audioCodecDescription(QString)const
            QString cppResult = const_cast<const ::QMediaRecorder *>(cppSelf)->audioCodecDescription(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMediaRecorderFunc_audioCodecDescription_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMediaRecorderFunc_audioSettings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaRecorder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaRecorder.audioSettings";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // audioSettings()const
            QAudioEncoderSettings cppResult = const_cast<const ::QMediaRecorder *>(cppSelf)->audioSettings();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOENCODERSETTINGS_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaRecorderFunc_availability(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaRecorder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaRecorder.availability";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // availability()const
            QMultimedia::AvailabilityStatus cppResult = const_cast<const ::QMediaRecorder *>(cppSelf)->availability();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_AVAILABILITYSTATUS_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaRecorderFunc_availableMetaData(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaRecorder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaRecorder.availableMetaData";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // availableMetaData()const
            QStringList cppResult = const_cast<const ::QMediaRecorder *>(cppSelf)->availableMetaData();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaRecorderFunc_containerDescription(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaRecorder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaRecorder.containerDescription";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMediaRecorder::containerDescription(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // containerDescription(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaRecorderFunc_containerDescription_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // containerDescription(QString)const
            QString cppResult = const_cast<const ::QMediaRecorder *>(cppSelf)->containerDescription(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMediaRecorderFunc_containerDescription_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMediaRecorderFunc_containerFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaRecorder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaRecorder.containerFormat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // containerFormat()const
            QString cppResult = const_cast<const ::QMediaRecorder *>(cppSelf)->containerFormat();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaRecorderFunc_duration(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaRecorder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaRecorder.duration";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // duration()const
            qint64 cppResult = const_cast<const ::QMediaRecorder *>(cppSelf)->duration();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaRecorderFunc_error(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaRecorder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaRecorder.error";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // error()const
            QMediaRecorder::Error cppResult = const_cast<const ::QMediaRecorder *>(cppSelf)->error();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_ERROR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaRecorderFunc_errorString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaRecorder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaRecorder.errorString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // errorString()const
            QString cppResult = const_cast<const ::QMediaRecorder *>(cppSelf)->errorString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaRecorderFunc_isAvailable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaRecorder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaRecorder.isAvailable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isAvailable()const
            bool cppResult = const_cast<const ::QMediaRecorder *>(cppSelf)->isAvailable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaRecorderFunc_isMetaDataAvailable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaRecorder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaRecorder.isMetaDataAvailable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isMetaDataAvailable()const
            bool cppResult = const_cast<const ::QMediaRecorder *>(cppSelf)->isMetaDataAvailable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaRecorderFunc_isMetaDataWritable(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaRecorder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaRecorder.isMetaDataWritable";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isMetaDataWritable()const
            bool cppResult = const_cast<const ::QMediaRecorder *>(cppSelf)->isMetaDataWritable();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaRecorderFunc_isMuted(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaRecorder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaRecorder.isMuted";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isMuted()const
            bool cppResult = const_cast<const ::QMediaRecorder *>(cppSelf)->isMuted();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaRecorderFunc_mediaObject(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaRecorder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaRecorder.mediaObject";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mediaObject()const
            QMediaObject * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QMediaRecorder *>(cppSelf)->::QMediaRecorder::mediaObject()
                : const_cast<const ::QMediaRecorder *>(cppSelf)->mediaObject();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAOBJECT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaRecorderFunc_metaData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaRecorder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaRecorder.metaData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMediaRecorder::metaData(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // metaData(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaRecorderFunc_metaData_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // metaData(QString)const
            QVariant cppResult = const_cast<const ::QMediaRecorder *>(cppSelf)->metaData(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMediaRecorderFunc_metaData_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMediaRecorderFunc_outputLocation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaRecorder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaRecorder.outputLocation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // outputLocation()const
            QUrl cppResult = const_cast<const ::QMediaRecorder *>(cppSelf)->outputLocation();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaRecorderFunc_pause(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaRecorder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaRecorder.pause";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pause()
            cppSelf->pause();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QMediaRecorderFunc_record(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaRecorder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaRecorder.record";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // record()
            cppSelf->record();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QMediaRecorderFunc_setAudioSettings(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaRecorder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaRecorder.setAudioSettings";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMediaRecorder::setAudioSettings(QAudioEncoderSettings)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOENCODERSETTINGS_IDX]), (pyArg)))) {
        overloadId = 0; // setAudioSettings(QAudioEncoderSettings)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaRecorderFunc_setAudioSettings_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAudioEncoderSettings cppArg0_local;
        ::QAudioEncoderSettings *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOENCODERSETTINGS_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setAudioSettings(QAudioEncoderSettings)
            cppSelf->setAudioSettings(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMediaRecorderFunc_setAudioSettings_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMediaRecorderFunc_setContainerFormat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaRecorder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaRecorder.setContainerFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMediaRecorder::setContainerFormat(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setContainerFormat(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaRecorderFunc_setContainerFormat_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setContainerFormat(QString)
            cppSelf->setContainerFormat(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMediaRecorderFunc_setContainerFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMediaRecorderFunc_setEncodingSettings(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaRecorder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaRecorder.setEncodingSettings";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QMediaRecorderFunc_setEncodingSettings_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QMediaRecorderFunc_setEncodingSettings_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:setEncodingSettings", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QMediaRecorder::setEncodingSettings(QAudioEncoderSettings,QVideoEncoderSettings,QString)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOENCODERSETTINGS_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setEncodingSettings(QAudioEncoderSettings,QVideoEncoderSettings,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOENCODERSETTINGS_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // setEncodingSettings(QAudioEncoderSettings,QVideoEncoderSettings,QString)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
                overloadId = 0; // setEncodingSettings(QAudioEncoderSettings,QVideoEncoderSettings,QString)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaRecorderFunc_setEncodingSettings_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_videoSettings = Shiboken::String::createStaticString("videoSettings");
            if (PyDict_Contains(kwds, key_videoSettings)) {
                value = PyDict_GetItem(kwds, key_videoSettings);
                if (value && pyArgs[1]) {
                    errInfo = key_videoSettings;
                    Py_INCREF(errInfo);
                    goto Sbk_QMediaRecorderFunc_setEncodingSettings_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOENCODERSETTINGS_IDX]), (pyArgs[1]))))
                        goto Sbk_QMediaRecorderFunc_setEncodingSettings_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_videoSettings);
            }
            static PyObject *const key_containerMimeType = Shiboken::String::createStaticString("containerMimeType");
            if (PyDict_Contains(kwds, key_containerMimeType)) {
                value = PyDict_GetItem(kwds, key_containerMimeType);
                if (value && pyArgs[2]) {
                    errInfo = key_containerMimeType;
                    Py_INCREF(errInfo);
                    goto Sbk_QMediaRecorderFunc_setEncodingSettings_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2]))))
                        goto Sbk_QMediaRecorderFunc_setEncodingSettings_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_containerMimeType);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QMediaRecorderFunc_setEncodingSettings_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QAudioEncoderSettings cppArg0_local;
        ::QAudioEncoderSettings *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOENCODERSETTINGS_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QVideoEncoderSettings cppArg1_local = QVideoEncoderSettings();
        ::QVideoEncoderSettings *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOENCODERSETTINGS_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);
        }
        ::QString cppArg2 = QString();
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // setEncodingSettings(QAudioEncoderSettings,QVideoEncoderSettings,QString)
            cppSelf->setEncodingSettings(*cppArg0, *cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMediaRecorderFunc_setEncodingSettings_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMediaRecorderFunc_setMediaObject(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaRecorder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaRecorder.setMediaObject";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMediaBindableInterface::setMediaObject(QMediaObject*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAOBJECT_IDX]), (pyArg)))) {
        overloadId = 0; // setMediaObject(QMediaObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaRecorderFunc_setMediaObject_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMediaObject *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMediaObject(QMediaObject*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QMediaRecorder::setMediaObject(cppArg0)
                : cppSelf->setMediaObject(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMediaRecorderFunc_setMediaObject_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMediaRecorderFunc_setMetaData(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaRecorder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaRecorder.setMetaData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setMetaData", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QMediaRecorder::setMetaData(QString,QVariant)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[1])))) {
        overloadId = 0; // setMetaData(QString,QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaRecorderFunc_setMetaData_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QVariant cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setMetaData(QString,QVariant)
            cppSelf->setMetaData(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMediaRecorderFunc_setMetaData_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMediaRecorderFunc_setMuted(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaRecorder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaRecorder.setMuted";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMediaRecorder::setMuted(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setMuted(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaRecorderFunc_setMuted_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMuted(bool)
            cppSelf->setMuted(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMediaRecorderFunc_setMuted_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMediaRecorderFunc_setOutputLocation(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaRecorder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaRecorder.setOutputLocation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMediaRecorder::setOutputLocation(QUrl)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
        overloadId = 0; // setOutputLocation(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaRecorderFunc_setOutputLocation_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setOutputLocation(QUrl)
            bool cppResult = cppSelf->setOutputLocation(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMediaRecorderFunc_setOutputLocation_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMediaRecorderFunc_setVideoSettings(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaRecorder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaRecorder.setVideoSettings";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMediaRecorder::setVideoSettings(QVideoEncoderSettings)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOENCODERSETTINGS_IDX]), (pyArg)))) {
        overloadId = 0; // setVideoSettings(QVideoEncoderSettings)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaRecorderFunc_setVideoSettings_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QVideoEncoderSettings cppArg0_local;
        ::QVideoEncoderSettings *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOENCODERSETTINGS_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setVideoSettings(QVideoEncoderSettings)
            cppSelf->setVideoSettings(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMediaRecorderFunc_setVideoSettings_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMediaRecorderFunc_setVolume(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaRecorder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaRecorder.setVolume";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMediaRecorder::setVolume(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setVolume(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaRecorderFunc_setVolume_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setVolume(qreal)
            cppSelf->setVolume(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QMediaRecorderFunc_setVolume_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMediaRecorderFunc_state(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaRecorder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaRecorder.state";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // state()const
            QMediaRecorder::State cppResult = const_cast<const ::QMediaRecorder *>(cppSelf)->state();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_STATE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaRecorderFunc_status(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaRecorder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaRecorder.status";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // status()const
            QMediaRecorder::Status cppResult = const_cast<const ::QMediaRecorder *>(cppSelf)->status();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_STATUS_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaRecorderFunc_stop(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaRecorder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaRecorder.stop";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // stop()
            cppSelf->stop();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QMediaRecorderFunc_supportedAudioCodecs(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaRecorder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaRecorder.supportedAudioCodecs";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedAudioCodecs()const
            QStringList cppResult = const_cast<const ::QMediaRecorder *>(cppSelf)->supportedAudioCodecs();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaRecorderFunc_supportedContainers(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaRecorder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaRecorder.supportedContainers";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedContainers()const
            QStringList cppResult = const_cast<const ::QMediaRecorder *>(cppSelf)->supportedContainers();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaRecorderFunc_supportedVideoCodecs(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaRecorder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaRecorder.supportedVideoCodecs";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedVideoCodecs()const
            QStringList cppResult = const_cast<const ::QMediaRecorder *>(cppSelf)->supportedVideoCodecs();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaRecorderFunc_videoCodecDescription(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaRecorder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaRecorder.videoCodecDescription";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QMediaRecorder::videoCodecDescription(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // videoCodecDescription(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QMediaRecorderFunc_videoCodecDescription_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // videoCodecDescription(QString)const
            QString cppResult = const_cast<const ::QMediaRecorder *>(cppSelf)->videoCodecDescription(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QMediaRecorderFunc_videoCodecDescription_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QMediaRecorderFunc_videoSettings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaRecorder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaRecorder.videoSettings";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // videoSettings()const
            QVideoEncoderSettings cppResult = const_cast<const ::QMediaRecorder *>(cppSelf)->videoSettings();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QVIDEOENCODERSETTINGS_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QMediaRecorderFunc_volume(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QMediaRecorder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QMediaRecorder.volume";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // volume()const
            qreal cppResult = const_cast<const ::QMediaRecorder *>(cppSelf)->volume();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QMediaRecorder_PropertyStrings[] = {
    "actualLocation:",
    "duration:",
    "metaDataAvailable:isMetaDataAvailable",
    "metaDataWritable:isMetaDataWritable",
    "muted:isMuted:",
    "outputLocation::",
    "state:",
    "status:",
    "volume::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QMediaRecorder_methods[] = {
    {"actualLocation", reinterpret_cast<PyCFunction>(Sbk_QMediaRecorderFunc_actualLocation), METH_NOARGS},
    {"audioCodecDescription", reinterpret_cast<PyCFunction>(Sbk_QMediaRecorderFunc_audioCodecDescription), METH_O},
    {"audioSettings", reinterpret_cast<PyCFunction>(Sbk_QMediaRecorderFunc_audioSettings), METH_NOARGS},
    {"availability", reinterpret_cast<PyCFunction>(Sbk_QMediaRecorderFunc_availability), METH_NOARGS},
    {"availableMetaData", reinterpret_cast<PyCFunction>(Sbk_QMediaRecorderFunc_availableMetaData), METH_NOARGS},
    {"containerDescription", reinterpret_cast<PyCFunction>(Sbk_QMediaRecorderFunc_containerDescription), METH_O},
    {"containerFormat", reinterpret_cast<PyCFunction>(Sbk_QMediaRecorderFunc_containerFormat), METH_NOARGS},
    {"duration", reinterpret_cast<PyCFunction>(Sbk_QMediaRecorderFunc_duration), METH_NOARGS},
    {"error", reinterpret_cast<PyCFunction>(Sbk_QMediaRecorderFunc_error), METH_NOARGS},
    {"errorString", reinterpret_cast<PyCFunction>(Sbk_QMediaRecorderFunc_errorString), METH_NOARGS},
    {"isAvailable", reinterpret_cast<PyCFunction>(Sbk_QMediaRecorderFunc_isAvailable), METH_NOARGS},
    {"isMetaDataAvailable", reinterpret_cast<PyCFunction>(Sbk_QMediaRecorderFunc_isMetaDataAvailable), METH_NOARGS},
    {"isMetaDataWritable", reinterpret_cast<PyCFunction>(Sbk_QMediaRecorderFunc_isMetaDataWritable), METH_NOARGS},
    {"isMuted", reinterpret_cast<PyCFunction>(Sbk_QMediaRecorderFunc_isMuted), METH_NOARGS},
    {"mediaObject", reinterpret_cast<PyCFunction>(Sbk_QMediaRecorderFunc_mediaObject), METH_NOARGS},
    {"metaData", reinterpret_cast<PyCFunction>(Sbk_QMediaRecorderFunc_metaData), METH_O},
    {"outputLocation", reinterpret_cast<PyCFunction>(Sbk_QMediaRecorderFunc_outputLocation), METH_NOARGS},
    {"pause", reinterpret_cast<PyCFunction>(Sbk_QMediaRecorderFunc_pause), METH_NOARGS},
    {"record", reinterpret_cast<PyCFunction>(Sbk_QMediaRecorderFunc_record), METH_NOARGS},
    {"setAudioSettings", reinterpret_cast<PyCFunction>(Sbk_QMediaRecorderFunc_setAudioSettings), METH_O},
    {"setContainerFormat", reinterpret_cast<PyCFunction>(Sbk_QMediaRecorderFunc_setContainerFormat), METH_O},
    {"setEncodingSettings", reinterpret_cast<PyCFunction>(Sbk_QMediaRecorderFunc_setEncodingSettings), METH_VARARGS|METH_KEYWORDS},
    {"setMediaObject", reinterpret_cast<PyCFunction>(Sbk_QMediaRecorderFunc_setMediaObject), METH_O},
    {"setMetaData", reinterpret_cast<PyCFunction>(Sbk_QMediaRecorderFunc_setMetaData), METH_VARARGS},
    {"setMuted", reinterpret_cast<PyCFunction>(Sbk_QMediaRecorderFunc_setMuted), METH_O},
    {"setOutputLocation", reinterpret_cast<PyCFunction>(Sbk_QMediaRecorderFunc_setOutputLocation), METH_O},
    {"setVideoSettings", reinterpret_cast<PyCFunction>(Sbk_QMediaRecorderFunc_setVideoSettings), METH_O},
    {"setVolume", reinterpret_cast<PyCFunction>(Sbk_QMediaRecorderFunc_setVolume), METH_O},
    {"state", reinterpret_cast<PyCFunction>(Sbk_QMediaRecorderFunc_state), METH_NOARGS},
    {"status", reinterpret_cast<PyCFunction>(Sbk_QMediaRecorderFunc_status), METH_NOARGS},
    {"stop", reinterpret_cast<PyCFunction>(Sbk_QMediaRecorderFunc_stop), METH_NOARGS},
    {"supportedAudioCodecs", reinterpret_cast<PyCFunction>(Sbk_QMediaRecorderFunc_supportedAudioCodecs), METH_NOARGS},
    {"supportedContainers", reinterpret_cast<PyCFunction>(Sbk_QMediaRecorderFunc_supportedContainers), METH_NOARGS},
    {"supportedVideoCodecs", reinterpret_cast<PyCFunction>(Sbk_QMediaRecorderFunc_supportedVideoCodecs), METH_NOARGS},
    {"videoCodecDescription", reinterpret_cast<PyCFunction>(Sbk_QMediaRecorderFunc_videoCodecDescription), METH_O},
    {"videoSettings", reinterpret_cast<PyCFunction>(Sbk_QMediaRecorderFunc_videoSettings), METH_NOARGS},
    {"volume", reinterpret_cast<PyCFunction>(Sbk_QMediaRecorderFunc_volume), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QMediaRecorder_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QMediaRecorder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QMediaRecorderWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QMediaRecorder_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QMediaRecorder_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
static int mi_offsets[] = { -1, -1, -1, -1, -1 };
int *
Sbk_QMediaRecorder_mi_init(const void *cptr)
{
    if (mi_offsets[0] == -1) {
        std::set<int> offsets;
        const auto *class_ptr = reinterpret_cast<const QMediaRecorder *>(cptr);
        const auto base = reinterpret_cast<uintptr_t>(class_ptr);
        offsets.insert(int(reinterpret_cast<uintptr_t>(static_cast<const QObject *>(class_ptr)) - base));
        offsets.insert(int(reinterpret_cast<uintptr_t>(static_cast<const QObject *>(static_cast<const QMediaRecorder *>(static_cast<const void *>(class_ptr)))) - base));
        offsets.insert(int(reinterpret_cast<uintptr_t>(static_cast<const QMediaBindableInterface *>(class_ptr)) - base));
        offsets.insert(int(reinterpret_cast<uintptr_t>(static_cast<const QMediaBindableInterface *>(static_cast<const QMediaRecorder *>(static_cast<const void *>(class_ptr)))) - base));

        offsets.erase(0);

        std::copy(offsets.cbegin(), offsets.cend(), mi_offsets);
    }
    return mi_offsets;
}
static void * Sbk_QMediaRecorderSpecialCastFunction(void *obj, SbkObjectType *desiredType)
{
    auto me = reinterpret_cast< ::QMediaRecorder *>(obj);
    if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIABINDABLEINTERFACE_IDX]))
        return static_cast< ::QMediaBindableInterface *>(me);
    return me;
}


// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QMediaRecorder_Type = nullptr;
static SbkObjectType *Sbk_QMediaRecorder_TypeF(void)
{
    return _Sbk_QMediaRecorder_Type;
}

static PyType_Slot Sbk_QMediaRecorder_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QMediaRecorder_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QMediaRecorder_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QMediaRecorder_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QMediaRecorder_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QMediaRecorder_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QMediaRecorder_spec = {
    "2:PySide2.QtMultimedia.QMediaRecorder",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QMediaRecorder_slots
};

} //extern "C"

static void *Sbk_QMediaRecorder_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QMediaRecorder *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QMediaBindableInterface >()))
        return dynamic_cast< ::QMediaRecorder *>(reinterpret_cast< ::QMediaBindableInterface *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QMediaRecorder_State_PythonToCpp_QMediaRecorder_State(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QMediaRecorder::State *>(cppOut) =
        static_cast<::QMediaRecorder::State>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QMediaRecorder_State_PythonToCpp_QMediaRecorder_State_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_STATE_IDX]))
        return QMediaRecorder_State_PythonToCpp_QMediaRecorder_State;
    return {};
}
static PyObject *QMediaRecorder_State_CppToPython_QMediaRecorder_State(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QMediaRecorder::State *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_STATE_IDX], castCppIn);

}

static void QMediaRecorder_Status_PythonToCpp_QMediaRecorder_Status(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QMediaRecorder::Status *>(cppOut) =
        static_cast<::QMediaRecorder::Status>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QMediaRecorder_Status_PythonToCpp_QMediaRecorder_Status_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_STATUS_IDX]))
        return QMediaRecorder_Status_PythonToCpp_QMediaRecorder_Status;
    return {};
}
static PyObject *QMediaRecorder_Status_CppToPython_QMediaRecorder_Status(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QMediaRecorder::Status *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_STATUS_IDX], castCppIn);

}

static void QMediaRecorder_Error_PythonToCpp_QMediaRecorder_Error(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QMediaRecorder::Error *>(cppOut) =
        static_cast<::QMediaRecorder::Error>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QMediaRecorder_Error_PythonToCpp_QMediaRecorder_Error_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_ERROR_IDX]))
        return QMediaRecorder_Error_PythonToCpp_QMediaRecorder_Error;
    return {};
}
static PyObject *QMediaRecorder_Error_CppToPython_QMediaRecorder_Error(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QMediaRecorder::Error *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_ERROR_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QMediaRecorder_PythonToCpp_QMediaRecorder_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QMediaRecorder_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QMediaRecorder_PythonToCpp_QMediaRecorder_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QMediaRecorder_TypeF())))
        return QMediaRecorder_PythonToCpp_QMediaRecorder_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QMediaRecorder_PTR_CppToPython_QMediaRecorder(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QMediaRecorder *>(const_cast<void *>(cppIn)), Sbk_QMediaRecorder_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QMediaRecorder_SignatureStrings[] = {
    "PySide2.QtMultimedia.QMediaRecorder(self,mediaObject:PySide2.QtMultimedia.QMediaObject,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtMultimedia.QMediaRecorder.actualLocation(self)->PySide2.QtCore.QUrl",
    "PySide2.QtMultimedia.QMediaRecorder.audioCodecDescription(self,codecName:QString)->QString",
    "PySide2.QtMultimedia.QMediaRecorder.audioSettings(self)->PySide2.QtMultimedia.QAudioEncoderSettings",
    "PySide2.QtMultimedia.QMediaRecorder.availability(self)->PySide2.QtMultimedia.QMultimedia.AvailabilityStatus",
    "PySide2.QtMultimedia.QMediaRecorder.availableMetaData(self)->QStringList",
    "PySide2.QtMultimedia.QMediaRecorder.containerDescription(self,format:QString)->QString",
    "PySide2.QtMultimedia.QMediaRecorder.containerFormat(self)->QString",
    "PySide2.QtMultimedia.QMediaRecorder.duration(self)->qint64",
    "PySide2.QtMultimedia.QMediaRecorder.error(self)->PySide2.QtMultimedia.QMediaRecorder.Error",
    "PySide2.QtMultimedia.QMediaRecorder.errorString(self)->QString",
    "PySide2.QtMultimedia.QMediaRecorder.isAvailable(self)->bool",
    "PySide2.QtMultimedia.QMediaRecorder.isMetaDataAvailable(self)->bool",
    "PySide2.QtMultimedia.QMediaRecorder.isMetaDataWritable(self)->bool",
    "PySide2.QtMultimedia.QMediaRecorder.isMuted(self)->bool",
    "PySide2.QtMultimedia.QMediaRecorder.mediaObject(self)->PySide2.QtMultimedia.QMediaObject",
    "PySide2.QtMultimedia.QMediaRecorder.metaData(self,key:QString)->QVariant",
    "PySide2.QtMultimedia.QMediaRecorder.outputLocation(self)->PySide2.QtCore.QUrl",
    "PySide2.QtMultimedia.QMediaRecorder.pause(self)",
    "PySide2.QtMultimedia.QMediaRecorder.record(self)",
    "PySide2.QtMultimedia.QMediaRecorder.setAudioSettings(self,audioSettings:PySide2.QtMultimedia.QAudioEncoderSettings)",
    "PySide2.QtMultimedia.QMediaRecorder.setContainerFormat(self,container:QString)",
    "PySide2.QtMultimedia.QMediaRecorder.setEncodingSettings(self,audioSettings:PySide2.QtMultimedia.QAudioEncoderSettings,videoSettings:PySide2.QtMultimedia.QVideoEncoderSettings=QVideoEncoderSettings(),containerMimeType:QString=QString())",
    "PySide2.QtMultimedia.QMediaRecorder.setMediaObject(self,object:PySide2.QtMultimedia.QMediaObject)->bool",
    "PySide2.QtMultimedia.QMediaRecorder.setMetaData(self,key:QString,value:QVariant)",
    "PySide2.QtMultimedia.QMediaRecorder.setMuted(self,muted:bool)",
    "PySide2.QtMultimedia.QMediaRecorder.setOutputLocation(self,location:PySide2.QtCore.QUrl)->bool",
    "PySide2.QtMultimedia.QMediaRecorder.setVideoSettings(self,videoSettings:PySide2.QtMultimedia.QVideoEncoderSettings)",
    "PySide2.QtMultimedia.QMediaRecorder.setVolume(self,volume:qreal)",
    "PySide2.QtMultimedia.QMediaRecorder.state(self)->PySide2.QtMultimedia.QMediaRecorder.State",
    "PySide2.QtMultimedia.QMediaRecorder.status(self)->PySide2.QtMultimedia.QMediaRecorder.Status",
    "PySide2.QtMultimedia.QMediaRecorder.stop(self)",
    "PySide2.QtMultimedia.QMediaRecorder.supportedAudioCodecs(self)->QStringList",
    "PySide2.QtMultimedia.QMediaRecorder.supportedContainers(self)->QStringList",
    "PySide2.QtMultimedia.QMediaRecorder.supportedVideoCodecs(self)->QStringList",
    "PySide2.QtMultimedia.QMediaRecorder.videoCodecDescription(self,codecName:QString)->QString",
    "PySide2.QtMultimedia.QMediaRecorder.videoSettings(self)->PySide2.QtMultimedia.QVideoEncoderSettings",
    "PySide2.QtMultimedia.QMediaRecorder.volume(self)->qreal",
    nullptr}; // Sentinel

void init_QMediaRecorder(PyObject *module)
{
    PyObject *Sbk_QMediaRecorder_Type_bases = PyTuple_Pack(2,
        reinterpret_cast<PyObject *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        reinterpret_cast<PyObject *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIABINDABLEINTERFACE_IDX]));

    _Sbk_QMediaRecorder_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QMediaRecorder",
        "QMediaRecorder*",
        &Sbk_QMediaRecorder_spec,
        &Shiboken::callCppDestructor< ::QMediaRecorder >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        Sbk_QMediaRecorder_Type_bases,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QMediaRecorder_Type);
    InitSignatureStrings(pyType, QMediaRecorder_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QMediaRecorder_Type), Sbk_QMediaRecorder_PropertyStrings);
    SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QMediaRecorder_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QMediaRecorder_TypeF(),
        QMediaRecorder_PythonToCpp_QMediaRecorder_PTR,
        is_QMediaRecorder_PythonToCpp_QMediaRecorder_PTR_Convertible,
        QMediaRecorder_PTR_CppToPython_QMediaRecorder);

    Shiboken::Conversions::registerConverterName(converter, "QMediaRecorder");
    Shiboken::Conversions::registerConverterName(converter, "QMediaRecorder*");
    Shiboken::Conversions::registerConverterName(converter, "QMediaRecorder&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QMediaRecorder).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QMediaRecorderWrapper).name());


    MultipleInheritanceInitFunction func = Sbk_QMediaRecorder_mi_init;
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_QMediaRecorder_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_QMediaRecorder_TypeF(), &Sbk_QMediaRecorderSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QMediaRecorder_TypeF(), &Sbk_QMediaRecorder_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'State'.
    SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_STATE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QMediaRecorder_TypeF(),
        "State",
        "2:PySide2.QtMultimedia.QMediaRecorder.State",
        "QMediaRecorder::State");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_STATE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_STATE_IDX],
        Sbk_QMediaRecorder_TypeF(), "StoppedState", (long) QMediaRecorder::State::StoppedState))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_STATE_IDX],
        Sbk_QMediaRecorder_TypeF(), "RecordingState", (long) QMediaRecorder::State::RecordingState))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_STATE_IDX],
        Sbk_QMediaRecorder_TypeF(), "PausedState", (long) QMediaRecorder::State::PausedState))
        return;
    // Register converter for enum 'QMediaRecorder::State'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_STATE_IDX],
            QMediaRecorder_State_CppToPython_QMediaRecorder_State);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QMediaRecorder_State_PythonToCpp_QMediaRecorder_State,
            is_QMediaRecorder_State_PythonToCpp_QMediaRecorder_State_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_STATE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QMediaRecorder::State");
        Shiboken::Conversions::registerConverterName(converter, "State");
    }
    // End of 'State' enum.

    // Initialization of enum 'Status'.
    SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_STATUS_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QMediaRecorder_TypeF(),
        "Status",
        "2:PySide2.QtMultimedia.QMediaRecorder.Status",
        "QMediaRecorder::Status");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_STATUS_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_STATUS_IDX],
        Sbk_QMediaRecorder_TypeF(), "UnavailableStatus", (long) QMediaRecorder::Status::UnavailableStatus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_STATUS_IDX],
        Sbk_QMediaRecorder_TypeF(), "UnloadedStatus", (long) QMediaRecorder::Status::UnloadedStatus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_STATUS_IDX],
        Sbk_QMediaRecorder_TypeF(), "LoadingStatus", (long) QMediaRecorder::Status::LoadingStatus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_STATUS_IDX],
        Sbk_QMediaRecorder_TypeF(), "LoadedStatus", (long) QMediaRecorder::Status::LoadedStatus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_STATUS_IDX],
        Sbk_QMediaRecorder_TypeF(), "StartingStatus", (long) QMediaRecorder::Status::StartingStatus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_STATUS_IDX],
        Sbk_QMediaRecorder_TypeF(), "RecordingStatus", (long) QMediaRecorder::Status::RecordingStatus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_STATUS_IDX],
        Sbk_QMediaRecorder_TypeF(), "PausedStatus", (long) QMediaRecorder::Status::PausedStatus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_STATUS_IDX],
        Sbk_QMediaRecorder_TypeF(), "FinalizingStatus", (long) QMediaRecorder::Status::FinalizingStatus))
        return;
    // Register converter for enum 'QMediaRecorder::Status'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_STATUS_IDX],
            QMediaRecorder_Status_CppToPython_QMediaRecorder_Status);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QMediaRecorder_Status_PythonToCpp_QMediaRecorder_Status,
            is_QMediaRecorder_Status_PythonToCpp_QMediaRecorder_Status_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_STATUS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QMediaRecorder::Status");
        Shiboken::Conversions::registerConverterName(converter, "Status");
    }
    // End of 'Status' enum.

    // Initialization of enum 'Error'.
    SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_ERROR_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QMediaRecorder_TypeF(),
        "Error",
        "2:PySide2.QtMultimedia.QMediaRecorder.Error",
        "QMediaRecorder::Error");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_ERROR_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_ERROR_IDX],
        Sbk_QMediaRecorder_TypeF(), "NoError", (long) QMediaRecorder::Error::NoError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_ERROR_IDX],
        Sbk_QMediaRecorder_TypeF(), "ResourceError", (long) QMediaRecorder::Error::ResourceError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_ERROR_IDX],
        Sbk_QMediaRecorder_TypeF(), "FormatError", (long) QMediaRecorder::Error::FormatError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_ERROR_IDX],
        Sbk_QMediaRecorder_TypeF(), "OutOfSpaceError", (long) QMediaRecorder::Error::OutOfSpaceError))
        return;
    // Register converter for enum 'QMediaRecorder::Error'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_ERROR_IDX],
            QMediaRecorder_Error_CppToPython_QMediaRecorder_Error);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QMediaRecorder_Error_PythonToCpp_QMediaRecorder_Error,
            is_QMediaRecorder_Error_PythonToCpp_QMediaRecorder_Error_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QMEDIARECORDER_ERROR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QMediaRecorder::Error");
        Shiboken::Conversions::registerConverterName(converter, "Error");
    }
    // End of 'Error' enum.

    PySide::Signal::registerSignals(Sbk_QMediaRecorder_TypeF(), &::QMediaRecorder::staticMetaObject);
    qRegisterMetaType< ::QMediaRecorder::State >("QMediaRecorder::State");
    qRegisterMetaType< ::QMediaRecorder::Status >("QMediaRecorder::Status");
    qRegisterMetaType< ::QMediaRecorder::Error >("QMediaRecorder::Error");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QMediaRecorder_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QMediaRecorder_TypeF(), &::QMediaRecorder::staticMetaObject, sizeof(QMediaRecorderWrapper));
}
