/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtmultimedia_python.h"

// main header
#include "qcamera_wrapper.h"

// inner classes
#include "qcamera_frameraterange_wrapper.h"

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QCameraWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QCameraWrapper::QCameraWrapper(::QCamera::Position position, ::QObject * parent) : QCamera(position, parent)
{
    resetPyMethodCache();
    // ... middle
}

QCameraWrapper::QCameraWrapper(::QObject * parent) : QCamera(parent)
{
    resetPyMethodCache();
    // ... middle
}

QCameraWrapper::QCameraWrapper(const ::QByteArray & deviceName, ::QObject * parent) : QCamera(deviceName, parent)
{
    resetPyMethodCache();
    // ... middle
}

QCameraWrapper::QCameraWrapper(const ::QCameraInfo & cameraInfo, ::QObject * parent) : QCamera(cameraInfo, parent)
{
    resetPyMethodCache();
    // ... middle
}

::QMultimedia::AvailabilityStatus QCameraWrapper::availability() const
{
    if (m_PyMethodCache[0])
        return this->::QCamera::availability();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QMultimedia::Available;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "availability";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QCamera::availability();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QMultimedia::Available;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_AVAILABILITYSTATUS_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QCamera.availability", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QMultimedia::AvailabilityStatus >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QMultimedia::Available;
    }
    ::QMultimedia::AvailabilityStatus cppResult{QMultimedia::Available};
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QCameraWrapper::bind(::QObject * arg__1)
{
    if (m_PyMethodCache[1])
        return this->::QMediaObject::bind(arg__1);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "bind";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QMediaObject::bind(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QCamera.bind", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QCameraWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QCameraWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QCameraWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[4]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QCameraWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[5]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QCameraWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[6])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QCamera.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QCameraWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[7])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QCamera.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

bool QCameraWrapper::isAvailable() const
{
    if (m_PyMethodCache[8])
        return this->::QMediaObject::isAvailable();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "isAvailable";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QMediaObject::isAvailable();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QCamera.isAvailable", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QMediaService * QCameraWrapper::service() const
{
    if (m_PyMethodCache[10])
        return this->::QMediaObject::service();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "service";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        return this->::QMediaObject::service();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIASERVICE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QCamera.service", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QMediaService >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QMediaService *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QCameraWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[11]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QCameraWrapper::unbind(::QObject * arg__1)
{
    if (m_PyMethodCache[12]) {
        return this->::QMediaObject::unbind(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "unbind";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[12] = true;
        return this->::QMediaObject::unbind(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

const QMetaObject *QCameraWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QCamera::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QCameraWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QCamera::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QCameraWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QCameraWrapper *>(this));
        return QCamera::qt_metacast(_clname);
}

QCameraWrapper::~QCameraWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QCamera_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QCamera >()))
        return -1;

    ::QCameraWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCamera.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|OO:QCamera", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QCamera::QCamera(QCamera::Position,QObject*)
    // 1: QCamera::QCamera(QObject*)
    // 2: QCamera::QCamera(QByteArray,QObject*)
    // 3: QCamera::QCamera(QCameraInfo,QObject*)
    if (numArgs == 0) {
        overloadId = 1; // QCamera(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // QCamera(QByteArray,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
            overloadId = 2; // QCamera(QByteArray,QObject*)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAINFO_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 3; // QCamera(QCameraInfo,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
            overloadId = 3; // QCamera(QCameraInfo,QObject*)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QCamera(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_POSITION_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // QCamera(QCamera::Position,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
            overloadId = 0; // QCamera(QCamera::Position,QObject*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCamera_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QCamera(QCamera::Position position, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[1]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QCamera_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1]))))
                            goto Sbk_QCamera_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            ::QCamera::Position cppArg0{QCamera::UnspecifiedPosition};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QObject *cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QCamera(QCamera::Position,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QCameraWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QCameraWrapper(cppArg0, cppArg1);
                }

                Shiboken::Object::setParent(pyArgs[1], self);
            }
            break;
        }
        case 1: // QCamera(QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[0]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QCamera_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                            goto Sbk_QCamera_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0 = nullptr;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QCamera(QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QCameraWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QCameraWrapper(cppArg0);
                }

                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
        case 2: // QCamera(const QByteArray & deviceName, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[1]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QCamera_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1]))))
                            goto Sbk_QCamera_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QObject *cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QCamera(QByteArray,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QCameraWrapper(*cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QCameraWrapper(*cppArg0, cppArg1);
                }

                Shiboken::Object::setParent(pyArgs[1], self);
            }
            break;
        }
        case 3: // QCamera(const QCameraInfo & cameraInfo, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[1]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QCamera_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1]))))
                            goto Sbk_QCamera_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QCameraInfo cppArg0_local;
            ::QCameraInfo *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAINFO_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QObject *cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QCamera(QCameraInfo,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QCameraWrapper(*cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QCameraWrapper(*cppArg0, cppArg1);
                }

                Shiboken::Object::setParent(pyArgs[1], self);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QCamera >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QCamera_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QCamera_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QCamera_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QCameraFunc_availability(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCamera.availability";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // availability()const
            QMultimedia::AvailabilityStatus cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QCamera *>(cppSelf)->::QCamera::availability()
                : const_cast<const ::QCamera *>(cppSelf)->availability();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QMULTIMEDIA_AVAILABILITYSTATUS_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraFunc_availableDevices(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCamera.availableDevices";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // availableDevices()
            QList<QByteArray > cppResult = ::QCamera::availableDevices();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QBYTEARRAY_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraFunc_captureMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCamera.captureMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // captureMode()const
            QFlags<QCamera::CaptureMode> cppResult = const_cast<const ::QCamera *>(cppSelf)->captureMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERA_CAPTUREMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraFunc_deviceDescription(PyObject *self, PyObject *pyArg)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCamera.deviceDescription";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QCamera::deviceDescription(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // deviceDescription(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraFunc_deviceDescription_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // deviceDescription(QByteArray)
            QString cppResult = ::QCamera::deviceDescription(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCameraFunc_deviceDescription_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraFunc_error(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCamera.error";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // error()const
            QCamera::Error cppResult = const_cast<const ::QCamera *>(cppSelf)->error();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_ERROR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraFunc_errorString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCamera.errorString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // errorString()const
            QString cppResult = const_cast<const ::QCamera *>(cppSelf)->errorString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraFunc_exposure(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCamera.exposure";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // exposure()const
            QCameraExposure * cppResult = const_cast<const ::QCamera *>(cppSelf)->exposure();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAEXPOSURE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraFunc_focus(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCamera.focus";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // focus()const
            QCameraFocus * cppResult = const_cast<const ::QCamera *>(cppSelf)->focus();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAFOCUS_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraFunc_imageProcessing(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCamera.imageProcessing";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // imageProcessing()const
            QCameraImageProcessing * cppResult = const_cast<const ::QCamera *>(cppSelf)->imageProcessing();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAIMAGEPROCESSING_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraFunc_isCaptureModeSupported(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCamera.isCaptureModeSupported";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCamera::isCaptureModeSupported(QFlags<QCamera::CaptureMode>)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERA_CAPTUREMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // isCaptureModeSupported(QFlags<QCamera::CaptureMode>)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraFunc_isCaptureModeSupported_TypeError;

    // Call function/method
    {
        ::QFlags<QCamera::CaptureMode> cppArg0 = QFlags<QCamera::CaptureMode>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // isCaptureModeSupported(QFlags<QCamera::CaptureMode>)const
            bool cppResult = const_cast<const ::QCamera *>(cppSelf)->isCaptureModeSupported(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCameraFunc_isCaptureModeSupported_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraFunc_load(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCamera.load";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // load()
            cppSelf->load();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QCameraFunc_lockStatus(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCamera.lockStatus";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "lockStatus", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QCamera::lockStatus()const
    // 1: QCamera::lockStatus(QCamera::LockType)const
    if (numArgs == 0) {
        overloadId = 0; // lockStatus()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_LOCKTYPE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // lockStatus(QCamera::LockType)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraFunc_lockStatus_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // lockStatus() const
        {

            if (!PyErr_Occurred()) {
                // lockStatus()const
                QCamera::LockStatus cppResult = const_cast<const ::QCamera *>(cppSelf)->lockStatus();
                pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_LOCKSTATUS_IDX])->converter, &cppResult);
            }
            break;
        }
        case 1: // lockStatus(QCamera::LockType lock) const
        {
            ::QCamera::LockType cppArg0{QCamera::NoLock};
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // lockStatus(QCamera::LockType)const
                QCamera::LockStatus cppResult = const_cast<const ::QCamera *>(cppSelf)->lockStatus(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_LOCKSTATUS_IDX])->converter, &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCameraFunc_lockStatus_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraFunc_requestedLocks(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCamera.requestedLocks";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // requestedLocks()const
            QFlags<QCamera::LockType> cppResult = const_cast<const ::QCamera *>(cppSelf)->requestedLocks();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERA_LOCKTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraFunc_searchAndLock(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCamera.searchAndLock";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "searchAndLock", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QCamera::searchAndLock()
    // 1: QCamera::searchAndLock(QFlags<QCamera::LockType>)
    if (numArgs == 0) {
        overloadId = 0; // searchAndLock()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERA_LOCKTYPE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // searchAndLock(QFlags<QCamera::LockType>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraFunc_searchAndLock_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // searchAndLock()
        {

            if (!PyErr_Occurred()) {
                // searchAndLock()
                cppSelf->searchAndLock();
            }
            break;
        }
        case 1: // searchAndLock(QFlags<QCamera::LockType> locks)
        {
            ::QFlags<QCamera::LockType> cppArg0 = QFlags<QCamera::LockType>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // searchAndLock(QFlags<QCamera::LockType>)
                cppSelf->searchAndLock(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCameraFunc_searchAndLock_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraFunc_setCaptureMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCamera.setCaptureMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCamera::setCaptureMode(QFlags<QCamera::CaptureMode>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERA_CAPTUREMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setCaptureMode(QFlags<QCamera::CaptureMode>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraFunc_setCaptureMode_TypeError;

    // Call function/method
    {
        ::QFlags<QCamera::CaptureMode> cppArg0 = QFlags<QCamera::CaptureMode>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCaptureMode(QFlags<QCamera::CaptureMode>)
            cppSelf->setCaptureMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCameraFunc_setCaptureMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraFunc_setViewfinder(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCamera.setViewfinder";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCamera::setViewfinder(QAbstractVideoSurface*)
    // 1: QCamera::setViewfinder(QGraphicsVideoItem*)
    // 2: QCamera::setViewfinder(QVideoWidget*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArg)))) {
        overloadId = 1; // setViewfinder(QGraphicsVideoItem*)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QABSTRACTVIDEOSURFACE_IDX]), (pyArg)))) {
        overloadId = 0; // setViewfinder(QAbstractVideoSurface*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraFunc_setViewfinder_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setViewfinder(QAbstractVideoSurface * surface)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QAbstractVideoSurface *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // setViewfinder(QAbstractVideoSurface*)
                cppSelf->setViewfinder(cppArg0);
            }
            break;
        }
        case 1: // setViewfinder(QGraphicsVideoItem * viewfinder)
        {

            if (!PyErr_Occurred()) {
                // setViewfinder(QGraphicsVideoItem*)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtmultimedia.cpp (upcast)]
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                ::QObject* upcastedArg{nullptr};
                    Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), pyArg, &(upcastedArg));
                //XXX   /|\ omitting this space crashes shiboken!
                cppSelf->setViewfinder(reinterpret_cast< QGraphicsVideoItem * >(upcastedArg));
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                // END of custom code block [file: ../glue/qtmultimedia.cpp (upcast)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
        case 2: // setViewfinder(QVideoWidget * viewfinder)
        {

            if (!PyErr_Occurred()) {
                // setViewfinder(QVideoWidget*)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtmultimedia.cpp (upcast)]
                PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
                ::QObject* upcastedArg{nullptr};
                    Shiboken::Conversions::pythonToCppPointer(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), pyArg, &(upcastedArg));
                //XXX   /|\ omitting this space crashes shiboken!
                cppSelf->setViewfinder(reinterpret_cast< QVideoWidget * >(upcastedArg));
                PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
                // END of custom code block [file: ../glue/qtmultimedia.cpp (upcast)]
                // ========================================================================

                // End of code injection

            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCameraFunc_setViewfinder_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraFunc_setViewfinderSettings(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCamera.setViewfinderSettings";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QCamera::setViewfinderSettings(QCameraViewfinderSettings)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAVIEWFINDERSETTINGS_IDX]), (pyArg)))) {
        overloadId = 0; // setViewfinderSettings(QCameraViewfinderSettings)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraFunc_setViewfinderSettings_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QCameraViewfinderSettings cppArg0_local;
        ::QCameraViewfinderSettings *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAVIEWFINDERSETTINGS_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setViewfinderSettings(QCameraViewfinderSettings)
            cppSelf->setViewfinderSettings(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCameraFunc_setViewfinderSettings_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraFunc_start(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCamera.start";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // start()
            cppSelf->start();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QCameraFunc_state(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCamera.state";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // state()const
            QCamera::State cppResult = const_cast<const ::QCamera *>(cppSelf)->state();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_STATE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraFunc_status(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCamera.status";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // status()const
            QCamera::Status cppResult = const_cast<const ::QCamera *>(cppSelf)->status();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_STATUS_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraFunc_stop(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCamera.stop";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // stop()
            cppSelf->stop();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QCameraFunc_supportedLocks(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCamera.supportedLocks";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedLocks()const
            QFlags<QCamera::LockType> cppResult = const_cast<const ::QCamera *>(cppSelf)->supportedLocks();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERA_LOCKTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QCameraFunc_supportedViewfinderFrameRateRanges(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCamera.supportedViewfinderFrameRateRanges";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QCameraFunc_supportedViewfinderFrameRateRanges_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:supportedViewfinderFrameRateRanges", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QCamera::supportedViewfinderFrameRateRanges(QCameraViewfinderSettings)const
    if (numArgs == 0) {
        overloadId = 0; // supportedViewfinderFrameRateRanges(QCameraViewfinderSettings)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAVIEWFINDERSETTINGS_IDX]), (pyArgs[0])))) {
        overloadId = 0; // supportedViewfinderFrameRateRanges(QCameraViewfinderSettings)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraFunc_supportedViewfinderFrameRateRanges_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_settings = Shiboken::String::createStaticString("settings");
            if (PyDict_Contains(kwds, key_settings)) {
                value = PyDict_GetItem(kwds, key_settings);
                if (value && pyArgs[0]) {
                    errInfo = key_settings;
                    Py_INCREF(errInfo);
                    goto Sbk_QCameraFunc_supportedViewfinderFrameRateRanges_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAVIEWFINDERSETTINGS_IDX]), (pyArgs[0]))))
                        goto Sbk_QCameraFunc_supportedViewfinderFrameRateRanges_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_settings);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QCameraFunc_supportedViewfinderFrameRateRanges_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QCameraViewfinderSettings cppArg0_local = QCameraViewfinderSettings();
        ::QCameraViewfinderSettings *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAVIEWFINDERSETTINGS_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);
        }

        if (!PyErr_Occurred()) {
            // supportedViewfinderFrameRateRanges(QCameraViewfinderSettings)const
            QList<QCamera::FrameRateRange > cppResult = const_cast<const ::QCamera *>(cppSelf)->supportedViewfinderFrameRateRanges(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QCAMERA_FRAMERATERANGE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCameraFunc_supportedViewfinderFrameRateRanges_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraFunc_supportedViewfinderPixelFormats(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCamera.supportedViewfinderPixelFormats";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QCameraFunc_supportedViewfinderPixelFormats_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:supportedViewfinderPixelFormats", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QCamera::supportedViewfinderPixelFormats(QCameraViewfinderSettings)const
    if (numArgs == 0) {
        overloadId = 0; // supportedViewfinderPixelFormats(QCameraViewfinderSettings)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAVIEWFINDERSETTINGS_IDX]), (pyArgs[0])))) {
        overloadId = 0; // supportedViewfinderPixelFormats(QCameraViewfinderSettings)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraFunc_supportedViewfinderPixelFormats_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_settings = Shiboken::String::createStaticString("settings");
            if (PyDict_Contains(kwds, key_settings)) {
                value = PyDict_GetItem(kwds, key_settings);
                if (value && pyArgs[0]) {
                    errInfo = key_settings;
                    Py_INCREF(errInfo);
                    goto Sbk_QCameraFunc_supportedViewfinderPixelFormats_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAVIEWFINDERSETTINGS_IDX]), (pyArgs[0]))))
                        goto Sbk_QCameraFunc_supportedViewfinderPixelFormats_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_settings);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QCameraFunc_supportedViewfinderPixelFormats_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QCameraViewfinderSettings cppArg0_local = QCameraViewfinderSettings();
        ::QCameraViewfinderSettings *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAVIEWFINDERSETTINGS_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);
        }

        if (!PyErr_Occurred()) {
            // supportedViewfinderPixelFormats(QCameraViewfinderSettings)const
            QList<QVideoFrame::PixelFormat > cppResult = const_cast<const ::QCamera *>(cppSelf)->supportedViewfinderPixelFormats(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QVIDEOFRAME_PIXELFORMAT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCameraFunc_supportedViewfinderPixelFormats_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraFunc_supportedViewfinderResolutions(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCamera.supportedViewfinderResolutions";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QCameraFunc_supportedViewfinderResolutions_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:supportedViewfinderResolutions", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QCamera::supportedViewfinderResolutions(QCameraViewfinderSettings)const
    if (numArgs == 0) {
        overloadId = 0; // supportedViewfinderResolutions(QCameraViewfinderSettings)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAVIEWFINDERSETTINGS_IDX]), (pyArgs[0])))) {
        overloadId = 0; // supportedViewfinderResolutions(QCameraViewfinderSettings)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraFunc_supportedViewfinderResolutions_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_settings = Shiboken::String::createStaticString("settings");
            if (PyDict_Contains(kwds, key_settings)) {
                value = PyDict_GetItem(kwds, key_settings);
                if (value && pyArgs[0]) {
                    errInfo = key_settings;
                    Py_INCREF(errInfo);
                    goto Sbk_QCameraFunc_supportedViewfinderResolutions_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAVIEWFINDERSETTINGS_IDX]), (pyArgs[0]))))
                        goto Sbk_QCameraFunc_supportedViewfinderResolutions_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_settings);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QCameraFunc_supportedViewfinderResolutions_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QCameraViewfinderSettings cppArg0_local = QCameraViewfinderSettings();
        ::QCameraViewfinderSettings *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAVIEWFINDERSETTINGS_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);
        }

        if (!PyErr_Occurred()) {
            // supportedViewfinderResolutions(QCameraViewfinderSettings)const
            QList<QSize > cppResult = const_cast<const ::QCamera *>(cppSelf)->supportedViewfinderResolutions(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QSIZE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCameraFunc_supportedViewfinderResolutions_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraFunc_supportedViewfinderSettings(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCamera.supportedViewfinderSettings";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QCameraFunc_supportedViewfinderSettings_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:supportedViewfinderSettings", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QCamera::supportedViewfinderSettings(QCameraViewfinderSettings)const
    if (numArgs == 0) {
        overloadId = 0; // supportedViewfinderSettings(QCameraViewfinderSettings)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAVIEWFINDERSETTINGS_IDX]), (pyArgs[0])))) {
        overloadId = 0; // supportedViewfinderSettings(QCameraViewfinderSettings)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraFunc_supportedViewfinderSettings_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_settings = Shiboken::String::createStaticString("settings");
            if (PyDict_Contains(kwds, key_settings)) {
                value = PyDict_GetItem(kwds, key_settings);
                if (value && pyArgs[0]) {
                    errInfo = key_settings;
                    Py_INCREF(errInfo);
                    goto Sbk_QCameraFunc_supportedViewfinderSettings_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAVIEWFINDERSETTINGS_IDX]), (pyArgs[0]))))
                        goto Sbk_QCameraFunc_supportedViewfinderSettings_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_settings);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QCameraFunc_supportedViewfinderSettings_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QCameraViewfinderSettings cppArg0_local = QCameraViewfinderSettings();
        ::QCameraViewfinderSettings *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAVIEWFINDERSETTINGS_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);
        }

        if (!PyErr_Occurred()) {
            // supportedViewfinderSettings(QCameraViewfinderSettings)const
            QList<QCameraViewfinderSettings > cppResult = const_cast<const ::QCamera *>(cppSelf)->supportedViewfinderSettings(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtMultimediaTypeConverters[SBK_QTMULTIMEDIA_QLIST_QCAMERAVIEWFINDERSETTINGS_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QCameraFunc_supportedViewfinderSettings_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraFunc_unload(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCamera.unload";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // unload()
            cppSelf->unload();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QCameraFunc_unlock(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCamera.unlock";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "unlock", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QCamera::unlock()
    // 1: QCamera::unlock(QFlags<QCamera::LockType>)
    if (numArgs == 0) {
        overloadId = 0; // unlock()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERA_LOCKTYPE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // unlock(QFlags<QCamera::LockType>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QCameraFunc_unlock_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // unlock()
        {

            if (!PyErr_Occurred()) {
                // unlock()
                cppSelf->unlock();
            }
            break;
        }
        case 1: // unlock(QFlags<QCamera::LockType> locks)
        {
            ::QFlags<QCamera::LockType> cppArg0 = QFlags<QCamera::LockType>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // unlock(QFlags<QCamera::LockType>)
                cppSelf->unlock(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QCameraFunc_unlock_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QCameraFunc_viewfinderSettings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QCamera.viewfinderSettings";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // viewfinderSettings()const
            QCameraViewfinderSettings cppResult = const_cast<const ::QCamera *>(cppSelf)->viewfinderSettings();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QCAMERAVIEWFINDERSETTINGS_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QCamera_PropertyStrings[] = {
    "captureMode::",
    "lockStatus:",
    "state:",
    "status:",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QCamera_methods[] = {
    {"availability", reinterpret_cast<PyCFunction>(Sbk_QCameraFunc_availability), METH_NOARGS},
    {"availableDevices", reinterpret_cast<PyCFunction>(Sbk_QCameraFunc_availableDevices), METH_NOARGS|METH_STATIC},
    {"captureMode", reinterpret_cast<PyCFunction>(Sbk_QCameraFunc_captureMode), METH_NOARGS},
    {"deviceDescription", reinterpret_cast<PyCFunction>(Sbk_QCameraFunc_deviceDescription), METH_O|METH_STATIC},
    {"error", reinterpret_cast<PyCFunction>(Sbk_QCameraFunc_error), METH_NOARGS},
    {"errorString", reinterpret_cast<PyCFunction>(Sbk_QCameraFunc_errorString), METH_NOARGS},
    {"exposure", reinterpret_cast<PyCFunction>(Sbk_QCameraFunc_exposure), METH_NOARGS},
    {"focus", reinterpret_cast<PyCFunction>(Sbk_QCameraFunc_focus), METH_NOARGS},
    {"imageProcessing", reinterpret_cast<PyCFunction>(Sbk_QCameraFunc_imageProcessing), METH_NOARGS},
    {"isCaptureModeSupported", reinterpret_cast<PyCFunction>(Sbk_QCameraFunc_isCaptureModeSupported), METH_O},
    {"load", reinterpret_cast<PyCFunction>(Sbk_QCameraFunc_load), METH_NOARGS},
    {"lockStatus", reinterpret_cast<PyCFunction>(Sbk_QCameraFunc_lockStatus), METH_VARARGS},
    {"requestedLocks", reinterpret_cast<PyCFunction>(Sbk_QCameraFunc_requestedLocks), METH_NOARGS},
    {"searchAndLock", reinterpret_cast<PyCFunction>(Sbk_QCameraFunc_searchAndLock), METH_VARARGS},
    {"setCaptureMode", reinterpret_cast<PyCFunction>(Sbk_QCameraFunc_setCaptureMode), METH_O},
    {"setViewfinder", reinterpret_cast<PyCFunction>(Sbk_QCameraFunc_setViewfinder), METH_O},
    {"setViewfinderSettings", reinterpret_cast<PyCFunction>(Sbk_QCameraFunc_setViewfinderSettings), METH_O},
    {"start", reinterpret_cast<PyCFunction>(Sbk_QCameraFunc_start), METH_NOARGS},
    {"state", reinterpret_cast<PyCFunction>(Sbk_QCameraFunc_state), METH_NOARGS},
    {"status", reinterpret_cast<PyCFunction>(Sbk_QCameraFunc_status), METH_NOARGS},
    {"stop", reinterpret_cast<PyCFunction>(Sbk_QCameraFunc_stop), METH_NOARGS},
    {"supportedLocks", reinterpret_cast<PyCFunction>(Sbk_QCameraFunc_supportedLocks), METH_NOARGS},
    {"supportedViewfinderFrameRateRanges", reinterpret_cast<PyCFunction>(Sbk_QCameraFunc_supportedViewfinderFrameRateRanges), METH_VARARGS|METH_KEYWORDS},
    {"supportedViewfinderPixelFormats", reinterpret_cast<PyCFunction>(Sbk_QCameraFunc_supportedViewfinderPixelFormats), METH_VARARGS|METH_KEYWORDS},
    {"supportedViewfinderResolutions", reinterpret_cast<PyCFunction>(Sbk_QCameraFunc_supportedViewfinderResolutions), METH_VARARGS|METH_KEYWORDS},
    {"supportedViewfinderSettings", reinterpret_cast<PyCFunction>(Sbk_QCameraFunc_supportedViewfinderSettings), METH_VARARGS|METH_KEYWORDS},
    {"unload", reinterpret_cast<PyCFunction>(Sbk_QCameraFunc_unload), METH_NOARGS},
    {"unlock", reinterpret_cast<PyCFunction>(Sbk_QCameraFunc_unlock), METH_VARARGS},
    {"viewfinderSettings", reinterpret_cast<PyCFunction>(Sbk_QCameraFunc_viewfinderSettings), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QCamera_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QCamera *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QCameraWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QCamera_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QCamera_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QCamera_Type = nullptr;
static SbkObjectType *Sbk_QCamera_TypeF(void)
{
    return _Sbk_QCamera_Type;
}

static PyType_Slot Sbk_QCamera_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QCamera_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QCamera_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QCamera_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QCamera_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QCamera_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QCamera_spec = {
    "2:PySide2.QtMultimedia.QCamera",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QCamera_slots
};

} //extern "C"

static void *Sbk_QCamera_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QCamera *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}

PyObject *SbkPySide2_QtMultimedia_QCamera_CaptureMode___and__(PyObject *self, PyObject *pyArg)
{
    ::QCamera::CaptureModes cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QCamera::CaptureModes>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QCamera::CaptureModes>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QCamera::CaptureModes>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QCamera::CaptureModes>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERA_CAPTUREMODE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtMultimedia_QCamera_CaptureMode___or__(PyObject *self, PyObject *pyArg)
{
    ::QCamera::CaptureModes cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QCamera::CaptureModes>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QCamera::CaptureModes>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QCamera::CaptureModes>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QCamera::CaptureModes>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERA_CAPTUREMODE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtMultimedia_QCamera_CaptureMode___xor__(PyObject *self, PyObject *pyArg)
{
    ::QCamera::CaptureModes cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QCamera::CaptureModes>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QCamera::CaptureModes>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QCamera::CaptureModes>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QCamera::CaptureModes>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERA_CAPTUREMODE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtMultimedia_QCamera_CaptureMode___invert__(PyObject *self, PyObject *pyArg)
{
    ::QCamera::CaptureModes cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERA_CAPTUREMODE_IDX])->converter, self, &cppSelf);
    ::QCamera::CaptureModes cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERA_CAPTUREMODE_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtMultimedia_QCamera_CaptureMode_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERA_CAPTUREMODE_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtMultimedia_QCamera_CaptureMode__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERA_CAPTUREMODE_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtMultimedia_QCamera_CaptureMode_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCamera_CaptureMode__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCamera_CaptureMode__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCamera_CaptureMode_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCamera_CaptureMode___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCamera_CaptureMode___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCamera_CaptureMode___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCamera_CaptureMode___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCamera_CaptureMode_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCamera_CaptureMode_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCamera_CaptureMode_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtMultimedia_QCamera_LockType___and__(PyObject *self, PyObject *pyArg)
{
    ::QCamera::LockTypes cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QCamera::LockTypes>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QCamera::LockTypes>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QCamera::LockTypes>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QCamera::LockTypes>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERA_LOCKTYPE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtMultimedia_QCamera_LockType___or__(PyObject *self, PyObject *pyArg)
{
    ::QCamera::LockTypes cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QCamera::LockTypes>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QCamera::LockTypes>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QCamera::LockTypes>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QCamera::LockTypes>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERA_LOCKTYPE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtMultimedia_QCamera_LockType___xor__(PyObject *self, PyObject *pyArg)
{
    ::QCamera::LockTypes cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QCamera::LockTypes>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QCamera::LockTypes>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QCamera::LockTypes>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QCamera::LockTypes>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERA_LOCKTYPE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtMultimedia_QCamera_LockType___invert__(PyObject *self, PyObject *pyArg)
{
    ::QCamera::LockTypes cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERA_LOCKTYPE_IDX])->converter, self, &cppSelf);
    ::QCamera::LockTypes cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERA_LOCKTYPE_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtMultimedia_QCamera_LockType_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERA_LOCKTYPE_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtMultimedia_QCamera_LockType__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERA_LOCKTYPE_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtMultimedia_QCamera_LockType_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCamera_LockType__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCamera_LockType__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCamera_LockType_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCamera_LockType___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCamera_LockType___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCamera_LockType___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCamera_LockType___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCamera_LockType_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCamera_LockType_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtMultimedia_QCamera_LockType_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QCamera_Status_PythonToCpp_QCamera_Status(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCamera::Status *>(cppOut) =
        static_cast<::QCamera::Status>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QCamera_Status_PythonToCpp_QCamera_Status_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_STATUS_IDX]))
        return QCamera_Status_PythonToCpp_QCamera_Status;
    return {};
}
static PyObject *QCamera_Status_CppToPython_QCamera_Status(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QCamera::Status *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_STATUS_IDX], castCppIn);

}

static void QCamera_State_PythonToCpp_QCamera_State(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCamera::State *>(cppOut) =
        static_cast<::QCamera::State>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QCamera_State_PythonToCpp_QCamera_State_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_STATE_IDX]))
        return QCamera_State_PythonToCpp_QCamera_State;
    return {};
}
static PyObject *QCamera_State_CppToPython_QCamera_State(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QCamera::State *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_STATE_IDX], castCppIn);

}

static void QCamera_CaptureMode_PythonToCpp_QCamera_CaptureMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCamera::CaptureMode *>(cppOut) =
        static_cast<::QCamera::CaptureMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QCamera_CaptureMode_PythonToCpp_QCamera_CaptureMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_CAPTUREMODE_IDX]))
        return QCamera_CaptureMode_PythonToCpp_QCamera_CaptureMode;
    return {};
}
static PyObject *QCamera_CaptureMode_CppToPython_QCamera_CaptureMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QCamera::CaptureMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_CAPTUREMODE_IDX], castCppIn);

}

static void QFlags_QCamera_CaptureMode__PythonToCpp_QFlags_QCamera_CaptureMode_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QCamera::CaptureMode> *>(cppOut) =
        ::QFlags<QCamera::CaptureMode>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QCamera_CaptureMode__PythonToCpp_QFlags_QCamera_CaptureMode__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERA_CAPTUREMODE_IDX]))
        return QFlags_QCamera_CaptureMode__PythonToCpp_QFlags_QCamera_CaptureMode_;
    return {};
}
static PyObject *QFlags_QCamera_CaptureMode__CppToPython_QFlags_QCamera_CaptureMode_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QCamera::CaptureMode> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERA_CAPTUREMODE_IDX]));

}

static void QCamera_CaptureMode_PythonToCpp_QFlags_QCamera_CaptureMode_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QCamera::CaptureMode> *>(cppOut) =
        ::QFlags<QCamera::CaptureMode>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QCamera_CaptureMode_PythonToCpp_QFlags_QCamera_CaptureMode__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_CAPTUREMODE_IDX]))
        return QCamera_CaptureMode_PythonToCpp_QFlags_QCamera_CaptureMode_;
    return {};
}
static void number_PythonToCpp_QFlags_QCamera_CaptureMode_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QCamera::CaptureMode> *>(cppOut) =
        ::QFlags<QCamera::CaptureMode>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QCamera_CaptureMode__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_CAPTUREMODE_IDX]))
        return number_PythonToCpp_QFlags_QCamera_CaptureMode_;
    return {};
}
static void QCamera_Error_PythonToCpp_QCamera_Error(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCamera::Error *>(cppOut) =
        static_cast<::QCamera::Error>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QCamera_Error_PythonToCpp_QCamera_Error_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_ERROR_IDX]))
        return QCamera_Error_PythonToCpp_QCamera_Error;
    return {};
}
static PyObject *QCamera_Error_CppToPython_QCamera_Error(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QCamera::Error *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_ERROR_IDX], castCppIn);

}

static void QCamera_LockStatus_PythonToCpp_QCamera_LockStatus(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCamera::LockStatus *>(cppOut) =
        static_cast<::QCamera::LockStatus>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QCamera_LockStatus_PythonToCpp_QCamera_LockStatus_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_LOCKSTATUS_IDX]))
        return QCamera_LockStatus_PythonToCpp_QCamera_LockStatus;
    return {};
}
static PyObject *QCamera_LockStatus_CppToPython_QCamera_LockStatus(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QCamera::LockStatus *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_LOCKSTATUS_IDX], castCppIn);

}

static void QCamera_LockChangeReason_PythonToCpp_QCamera_LockChangeReason(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCamera::LockChangeReason *>(cppOut) =
        static_cast<::QCamera::LockChangeReason>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QCamera_LockChangeReason_PythonToCpp_QCamera_LockChangeReason_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_LOCKCHANGEREASON_IDX]))
        return QCamera_LockChangeReason_PythonToCpp_QCamera_LockChangeReason;
    return {};
}
static PyObject *QCamera_LockChangeReason_CppToPython_QCamera_LockChangeReason(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QCamera::LockChangeReason *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_LOCKCHANGEREASON_IDX], castCppIn);

}

static void QCamera_LockType_PythonToCpp_QCamera_LockType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCamera::LockType *>(cppOut) =
        static_cast<::QCamera::LockType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QCamera_LockType_PythonToCpp_QCamera_LockType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_LOCKTYPE_IDX]))
        return QCamera_LockType_PythonToCpp_QCamera_LockType;
    return {};
}
static PyObject *QCamera_LockType_CppToPython_QCamera_LockType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QCamera::LockType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_LOCKTYPE_IDX], castCppIn);

}

static void QFlags_QCamera_LockType__PythonToCpp_QFlags_QCamera_LockType_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QCamera::LockType> *>(cppOut) =
        ::QFlags<QCamera::LockType>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QCamera_LockType__PythonToCpp_QFlags_QCamera_LockType__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERA_LOCKTYPE_IDX]))
        return QFlags_QCamera_LockType__PythonToCpp_QFlags_QCamera_LockType_;
    return {};
}
static PyObject *QFlags_QCamera_LockType__CppToPython_QFlags_QCamera_LockType_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QCamera::LockType> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERA_LOCKTYPE_IDX]));

}

static void QCamera_LockType_PythonToCpp_QFlags_QCamera_LockType_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QCamera::LockType> *>(cppOut) =
        ::QFlags<QCamera::LockType>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QCamera_LockType_PythonToCpp_QFlags_QCamera_LockType__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_LOCKTYPE_IDX]))
        return QCamera_LockType_PythonToCpp_QFlags_QCamera_LockType_;
    return {};
}
static void number_PythonToCpp_QFlags_QCamera_LockType_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QCamera::LockType> *>(cppOut) =
        ::QFlags<QCamera::LockType>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QCamera_LockType__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_LOCKTYPE_IDX]))
        return number_PythonToCpp_QFlags_QCamera_LockType_;
    return {};
}
static void QCamera_Position_PythonToCpp_QCamera_Position(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QCamera::Position *>(cppOut) =
        static_cast<::QCamera::Position>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QCamera_Position_PythonToCpp_QCamera_Position_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_POSITION_IDX]))
        return QCamera_Position_PythonToCpp_QCamera_Position;
    return {};
}
static PyObject *QCamera_Position_CppToPython_QCamera_Position(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QCamera::Position *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_POSITION_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QCamera_PythonToCpp_QCamera_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QCamera_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QCamera_PythonToCpp_QCamera_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QCamera_TypeF())))
        return QCamera_PythonToCpp_QCamera_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QCamera_PTR_CppToPython_QCamera(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QCamera *>(const_cast<void *>(cppIn)), Sbk_QCamera_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QCamera_SignatureStrings[] = {
    "3:PySide2.QtMultimedia.QCamera(self,position:PySide2.QtMultimedia.QCamera.Position,parent:PySide2.QtCore.QObject=nullptr)",
    "2:PySide2.QtMultimedia.QCamera(self,parent:PySide2.QtCore.QObject=nullptr)",
    "1:PySide2.QtMultimedia.QCamera(self,deviceName:PySide2.QtCore.QByteArray,parent:PySide2.QtCore.QObject=nullptr)",
    "0:PySide2.QtMultimedia.QCamera(self,cameraInfo:PySide2.QtMultimedia.QCameraInfo,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtMultimedia.QCamera.availability(self)->PySide2.QtMultimedia.QMultimedia.AvailabilityStatus",
    "PySide2.QtMultimedia.QCamera.availableDevices()->QList[PySide2.QtCore.QByteArray]",
    "PySide2.QtMultimedia.QCamera.captureMode(self)->PySide2.QtMultimedia.QCamera.CaptureModes",
    "PySide2.QtMultimedia.QCamera.deviceDescription(device:PySide2.QtCore.QByteArray)->QString",
    "PySide2.QtMultimedia.QCamera.error(self)->PySide2.QtMultimedia.QCamera.Error",
    "PySide2.QtMultimedia.QCamera.errorString(self)->QString",
    "PySide2.QtMultimedia.QCamera.exposure(self)->PySide2.QtMultimedia.QCameraExposure",
    "PySide2.QtMultimedia.QCamera.focus(self)->PySide2.QtMultimedia.QCameraFocus",
    "PySide2.QtMultimedia.QCamera.imageProcessing(self)->PySide2.QtMultimedia.QCameraImageProcessing",
    "PySide2.QtMultimedia.QCamera.isCaptureModeSupported(self,mode:PySide2.QtMultimedia.QCamera.CaptureModes)->bool",
    "PySide2.QtMultimedia.QCamera.load(self)",
    "1:PySide2.QtMultimedia.QCamera.lockStatus(self)->PySide2.QtMultimedia.QCamera.LockStatus",
    "0:PySide2.QtMultimedia.QCamera.lockStatus(self,lock:PySide2.QtMultimedia.QCamera.LockType)->PySide2.QtMultimedia.QCamera.LockStatus",
    "PySide2.QtMultimedia.QCamera.requestedLocks(self)->PySide2.QtMultimedia.QCamera.LockTypes",
    "1:PySide2.QtMultimedia.QCamera.searchAndLock(self)",
    "0:PySide2.QtMultimedia.QCamera.searchAndLock(self,locks:PySide2.QtMultimedia.QCamera.LockTypes)",
    "PySide2.QtMultimedia.QCamera.setCaptureMode(self,mode:PySide2.QtMultimedia.QCamera.CaptureModes)",
    "2:PySide2.QtMultimedia.QCamera.setViewfinder(self,surface:PySide2.QtMultimedia.QAbstractVideoSurface)",
    "1:PySide2.QtMultimedia.QCamera.setViewfinder(self,viewfinder:QGraphicsVideoItem)",
    "0:PySide2.QtMultimedia.QCamera.setViewfinder(self,viewfinder:QVideoWidget)",
    "PySide2.QtMultimedia.QCamera.setViewfinderSettings(self,settings:PySide2.QtMultimedia.QCameraViewfinderSettings)",
    "PySide2.QtMultimedia.QCamera.start(self)",
    "PySide2.QtMultimedia.QCamera.state(self)->PySide2.QtMultimedia.QCamera.State",
    "PySide2.QtMultimedia.QCamera.status(self)->PySide2.QtMultimedia.QCamera.Status",
    "PySide2.QtMultimedia.QCamera.stop(self)",
    "PySide2.QtMultimedia.QCamera.supportedLocks(self)->PySide2.QtMultimedia.QCamera.LockTypes",
    "PySide2.QtMultimedia.QCamera.supportedViewfinderFrameRateRanges(self,settings:PySide2.QtMultimedia.QCameraViewfinderSettings=QCameraViewfinderSettings())->QList[PySide2.QtMultimedia.QCamera.FrameRateRange]",
    "PySide2.QtMultimedia.QCamera.supportedViewfinderPixelFormats(self,settings:PySide2.QtMultimedia.QCameraViewfinderSettings=QCameraViewfinderSettings())->QList[PySide2.QtMultimedia.QVideoFrame.PixelFormat]",
    "PySide2.QtMultimedia.QCamera.supportedViewfinderResolutions(self,settings:PySide2.QtMultimedia.QCameraViewfinderSettings=QCameraViewfinderSettings())->QList[PySide2.QtCore.QSize]",
    "PySide2.QtMultimedia.QCamera.supportedViewfinderSettings(self,settings:PySide2.QtMultimedia.QCameraViewfinderSettings=QCameraViewfinderSettings())->QList[PySide2.QtMultimedia.QCameraViewfinderSettings]",
    "PySide2.QtMultimedia.QCamera.unload(self)",
    "1:PySide2.QtMultimedia.QCamera.unlock(self)",
    "0:PySide2.QtMultimedia.QCamera.unlock(self,locks:PySide2.QtMultimedia.QCamera.LockTypes)",
    "PySide2.QtMultimedia.QCamera.viewfinderSettings(self)->PySide2.QtMultimedia.QCameraViewfinderSettings",
    nullptr}; // Sentinel

void init_QCamera(PyObject *module)
{
    _Sbk_QCamera_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QCamera",
        "QCamera*",
        &Sbk_QCamera_spec,
        &Shiboken::callCppDestructor< ::QCamera >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QMEDIAOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QCamera_Type);
    InitSignatureStrings(pyType, QCamera_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QCamera_Type), Sbk_QCamera_PropertyStrings);
    SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QCamera_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QCamera_TypeF(),
        QCamera_PythonToCpp_QCamera_PTR,
        is_QCamera_PythonToCpp_QCamera_PTR_Convertible,
        QCamera_PTR_CppToPython_QCamera);

    Shiboken::Conversions::registerConverterName(converter, "QCamera");
    Shiboken::Conversions::registerConverterName(converter, "QCamera*");
    Shiboken::Conversions::registerConverterName(converter, "QCamera&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QCamera).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QCameraWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QCamera_TypeF(), &Sbk_QCamera_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'Status'.
    SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_STATUS_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QCamera_TypeF(),
        "Status",
        "2:PySide2.QtMultimedia.QCamera.Status",
        "QCamera::Status");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_STATUS_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_STATUS_IDX],
        Sbk_QCamera_TypeF(), "UnavailableStatus", (long) QCamera::Status::UnavailableStatus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_STATUS_IDX],
        Sbk_QCamera_TypeF(), "UnloadedStatus", (long) QCamera::Status::UnloadedStatus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_STATUS_IDX],
        Sbk_QCamera_TypeF(), "LoadingStatus", (long) QCamera::Status::LoadingStatus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_STATUS_IDX],
        Sbk_QCamera_TypeF(), "UnloadingStatus", (long) QCamera::Status::UnloadingStatus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_STATUS_IDX],
        Sbk_QCamera_TypeF(), "LoadedStatus", (long) QCamera::Status::LoadedStatus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_STATUS_IDX],
        Sbk_QCamera_TypeF(), "StandbyStatus", (long) QCamera::Status::StandbyStatus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_STATUS_IDX],
        Sbk_QCamera_TypeF(), "StartingStatus", (long) QCamera::Status::StartingStatus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_STATUS_IDX],
        Sbk_QCamera_TypeF(), "StoppingStatus", (long) QCamera::Status::StoppingStatus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_STATUS_IDX],
        Sbk_QCamera_TypeF(), "ActiveStatus", (long) QCamera::Status::ActiveStatus))
        return;
    // Register converter for enum 'QCamera::Status'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_STATUS_IDX],
            QCamera_Status_CppToPython_QCamera_Status);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCamera_Status_PythonToCpp_QCamera_Status,
            is_QCamera_Status_PythonToCpp_QCamera_Status_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_STATUS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCamera::Status");
        Shiboken::Conversions::registerConverterName(converter, "Status");
    }
    // End of 'Status' enum.

    // Initialization of enum 'State'.
    SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_STATE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QCamera_TypeF(),
        "State",
        "2:PySide2.QtMultimedia.QCamera.State",
        "QCamera::State");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_STATE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_STATE_IDX],
        Sbk_QCamera_TypeF(), "UnloadedState", (long) QCamera::State::UnloadedState))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_STATE_IDX],
        Sbk_QCamera_TypeF(), "LoadedState", (long) QCamera::State::LoadedState))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_STATE_IDX],
        Sbk_QCamera_TypeF(), "ActiveState", (long) QCamera::State::ActiveState))
        return;
    // Register converter for enum 'QCamera::State'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_STATE_IDX],
            QCamera_State_CppToPython_QCamera_State);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCamera_State_PythonToCpp_QCamera_State,
            is_QCamera_State_PythonToCpp_QCamera_State_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_STATE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCamera::State");
        Shiboken::Conversions::registerConverterName(converter, "State");
    }
    // End of 'State' enum.

    // Initialization of enum 'CaptureMode'.
    SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERA_CAPTUREMODE_IDX] = PySide::QFlags::create("2:PySide2.QtMultimedia.QCamera.CaptureModes", SbkPySide2_QtMultimedia_QCamera_CaptureMode_number_slots);
    SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_CAPTUREMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QCamera_TypeF(),
        "CaptureMode",
        "2:PySide2.QtMultimedia.QCamera.CaptureMode",
        "QCamera::CaptureMode",
        SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERA_CAPTUREMODE_IDX]);
    if (!SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_CAPTUREMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_CAPTUREMODE_IDX],
        Sbk_QCamera_TypeF(), "CaptureViewfinder", (long) QCamera::CaptureMode::CaptureViewfinder))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_CAPTUREMODE_IDX],
        Sbk_QCamera_TypeF(), "CaptureStillImage", (long) QCamera::CaptureMode::CaptureStillImage))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_CAPTUREMODE_IDX],
        Sbk_QCamera_TypeF(), "CaptureVideo", (long) QCamera::CaptureMode::CaptureVideo))
        return;
    // Register converter for enum 'QCamera::CaptureMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_CAPTUREMODE_IDX],
            QCamera_CaptureMode_CppToPython_QCamera_CaptureMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCamera_CaptureMode_PythonToCpp_QCamera_CaptureMode,
            is_QCamera_CaptureMode_PythonToCpp_QCamera_CaptureMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_CAPTUREMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCamera::CaptureMode");
        Shiboken::Conversions::registerConverterName(converter, "CaptureMode");
    }
    // Register converter for flag 'QFlags<QCamera::CaptureMode>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERA_CAPTUREMODE_IDX],
            QFlags_QCamera_CaptureMode__CppToPython_QFlags_QCamera_CaptureMode_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCamera_CaptureMode_PythonToCpp_QFlags_QCamera_CaptureMode_,
            is_QCamera_CaptureMode_PythonToCpp_QFlags_QCamera_CaptureMode__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QCamera_CaptureMode__PythonToCpp_QFlags_QCamera_CaptureMode_,
            is_QFlags_QCamera_CaptureMode__PythonToCpp_QFlags_QCamera_CaptureMode__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QCamera_CaptureMode_,
            is_number_PythonToCpp_QFlags_QCamera_CaptureMode__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERA_CAPTUREMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCamera::CaptureModes");
        Shiboken::Conversions::registerConverterName(converter, "CaptureModes");
    }
    // End of 'CaptureMode' enum/flags.

    // Initialization of enum 'Error'.
    SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_ERROR_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QCamera_TypeF(),
        "Error",
        "2:PySide2.QtMultimedia.QCamera.Error",
        "QCamera::Error");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_ERROR_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_ERROR_IDX],
        Sbk_QCamera_TypeF(), "NoError", (long) QCamera::Error::NoError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_ERROR_IDX],
        Sbk_QCamera_TypeF(), "CameraError", (long) QCamera::Error::CameraError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_ERROR_IDX],
        Sbk_QCamera_TypeF(), "InvalidRequestError", (long) QCamera::Error::InvalidRequestError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_ERROR_IDX],
        Sbk_QCamera_TypeF(), "ServiceMissingError", (long) QCamera::Error::ServiceMissingError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_ERROR_IDX],
        Sbk_QCamera_TypeF(), "NotSupportedFeatureError", (long) QCamera::Error::NotSupportedFeatureError))
        return;
    // Register converter for enum 'QCamera::Error'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_ERROR_IDX],
            QCamera_Error_CppToPython_QCamera_Error);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCamera_Error_PythonToCpp_QCamera_Error,
            is_QCamera_Error_PythonToCpp_QCamera_Error_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_ERROR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCamera::Error");
        Shiboken::Conversions::registerConverterName(converter, "Error");
    }
    // End of 'Error' enum.

    // Initialization of enum 'LockStatus'.
    SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_LOCKSTATUS_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QCamera_TypeF(),
        "LockStatus",
        "2:PySide2.QtMultimedia.QCamera.LockStatus",
        "QCamera::LockStatus");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_LOCKSTATUS_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_LOCKSTATUS_IDX],
        Sbk_QCamera_TypeF(), "Unlocked", (long) QCamera::LockStatus::Unlocked))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_LOCKSTATUS_IDX],
        Sbk_QCamera_TypeF(), "Searching", (long) QCamera::LockStatus::Searching))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_LOCKSTATUS_IDX],
        Sbk_QCamera_TypeF(), "Locked", (long) QCamera::LockStatus::Locked))
        return;
    // Register converter for enum 'QCamera::LockStatus'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_LOCKSTATUS_IDX],
            QCamera_LockStatus_CppToPython_QCamera_LockStatus);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCamera_LockStatus_PythonToCpp_QCamera_LockStatus,
            is_QCamera_LockStatus_PythonToCpp_QCamera_LockStatus_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_LOCKSTATUS_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCamera::LockStatus");
        Shiboken::Conversions::registerConverterName(converter, "LockStatus");
    }
    // End of 'LockStatus' enum.

    // Initialization of enum 'LockChangeReason'.
    SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_LOCKCHANGEREASON_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QCamera_TypeF(),
        "LockChangeReason",
        "2:PySide2.QtMultimedia.QCamera.LockChangeReason",
        "QCamera::LockChangeReason");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_LOCKCHANGEREASON_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_LOCKCHANGEREASON_IDX],
        Sbk_QCamera_TypeF(), "UserRequest", (long) QCamera::LockChangeReason::UserRequest))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_LOCKCHANGEREASON_IDX],
        Sbk_QCamera_TypeF(), "LockAcquired", (long) QCamera::LockChangeReason::LockAcquired))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_LOCKCHANGEREASON_IDX],
        Sbk_QCamera_TypeF(), "LockFailed", (long) QCamera::LockChangeReason::LockFailed))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_LOCKCHANGEREASON_IDX],
        Sbk_QCamera_TypeF(), "LockLost", (long) QCamera::LockChangeReason::LockLost))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_LOCKCHANGEREASON_IDX],
        Sbk_QCamera_TypeF(), "LockTemporaryLost", (long) QCamera::LockChangeReason::LockTemporaryLost))
        return;
    // Register converter for enum 'QCamera::LockChangeReason'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_LOCKCHANGEREASON_IDX],
            QCamera_LockChangeReason_CppToPython_QCamera_LockChangeReason);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCamera_LockChangeReason_PythonToCpp_QCamera_LockChangeReason,
            is_QCamera_LockChangeReason_PythonToCpp_QCamera_LockChangeReason_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_LOCKCHANGEREASON_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCamera::LockChangeReason");
        Shiboken::Conversions::registerConverterName(converter, "LockChangeReason");
    }
    // End of 'LockChangeReason' enum.

    // Initialization of enum 'LockType'.
    SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERA_LOCKTYPE_IDX] = PySide::QFlags::create("2:PySide2.QtMultimedia.QCamera.LockTypes", SbkPySide2_QtMultimedia_QCamera_LockType_number_slots);
    SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_LOCKTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QCamera_TypeF(),
        "LockType",
        "2:PySide2.QtMultimedia.QCamera.LockType",
        "QCamera::LockType",
        SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERA_LOCKTYPE_IDX]);
    if (!SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_LOCKTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_LOCKTYPE_IDX],
        Sbk_QCamera_TypeF(), "NoLock", (long) QCamera::LockType::NoLock))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_LOCKTYPE_IDX],
        Sbk_QCamera_TypeF(), "LockExposure", (long) QCamera::LockType::LockExposure))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_LOCKTYPE_IDX],
        Sbk_QCamera_TypeF(), "LockWhiteBalance", (long) QCamera::LockType::LockWhiteBalance))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_LOCKTYPE_IDX],
        Sbk_QCamera_TypeF(), "LockFocus", (long) QCamera::LockType::LockFocus))
        return;
    // Register converter for enum 'QCamera::LockType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_LOCKTYPE_IDX],
            QCamera_LockType_CppToPython_QCamera_LockType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCamera_LockType_PythonToCpp_QCamera_LockType,
            is_QCamera_LockType_PythonToCpp_QCamera_LockType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_LOCKTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCamera::LockType");
        Shiboken::Conversions::registerConverterName(converter, "LockType");
    }
    // Register converter for flag 'QFlags<QCamera::LockType>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERA_LOCKTYPE_IDX],
            QFlags_QCamera_LockType__CppToPython_QFlags_QCamera_LockType_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCamera_LockType_PythonToCpp_QFlags_QCamera_LockType_,
            is_QCamera_LockType_PythonToCpp_QFlags_QCamera_LockType__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QCamera_LockType__PythonToCpp_QFlags_QCamera_LockType_,
            is_QFlags_QCamera_LockType__PythonToCpp_QFlags_QCamera_LockType__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QCamera_LockType_,
            is_number_PythonToCpp_QFlags_QCamera_LockType__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QFLAGS_QCAMERA_LOCKTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCamera::LockTypes");
        Shiboken::Conversions::registerConverterName(converter, "LockTypes");
    }
    // End of 'LockType' enum/flags.

    // Initialization of enum 'Position'.
    SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_POSITION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QCamera_TypeF(),
        "Position",
        "2:PySide2.QtMultimedia.QCamera.Position",
        "QCamera::Position");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_POSITION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_POSITION_IDX],
        Sbk_QCamera_TypeF(), "UnspecifiedPosition", (long) QCamera::Position::UnspecifiedPosition))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_POSITION_IDX],
        Sbk_QCamera_TypeF(), "BackFace", (long) QCamera::Position::BackFace))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_POSITION_IDX],
        Sbk_QCamera_TypeF(), "FrontFace", (long) QCamera::Position::FrontFace))
        return;
    // Register converter for enum 'QCamera::Position'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_POSITION_IDX],
            QCamera_Position_CppToPython_QCamera_Position);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QCamera_Position_PythonToCpp_QCamera_Position,
            is_QCamera_Position_PythonToCpp_QCamera_Position_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QCAMERA_POSITION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QCamera::Position");
        Shiboken::Conversions::registerConverterName(converter, "Position");
    }
    // End of 'Position' enum.

    PySide::Signal::registerSignals(Sbk_QCamera_TypeF(), &::QCamera::staticMetaObject);
    qRegisterMetaType< ::QCamera::Status >("QCamera::Status");
    qRegisterMetaType< ::QCamera::State >("QCamera::State");
    qRegisterMetaType< ::QCamera::CaptureMode >("QCamera::CaptureMode");
    qRegisterMetaType< ::QCamera::CaptureModes >("QCamera::CaptureModes");
    qRegisterMetaType< ::QCamera::Error >("QCamera::Error");
    qRegisterMetaType< ::QCamera::LockStatus >("QCamera::LockStatus");
    qRegisterMetaType< ::QCamera::LockChangeReason >("QCamera::LockChangeReason");
    qRegisterMetaType< ::QCamera::LockType >("QCamera::LockType");
    qRegisterMetaType< ::QCamera::LockTypes >("QCamera::LockTypes");
    qRegisterMetaType< ::QCamera::Position >("QCamera::Position");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QCamera_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QCamera_TypeF(), &::QCamera::staticMetaObject, sizeof(QCameraWrapper));
}
