/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtmultimedia_python.h"

// main header
#include "qaudioformat_wrapper.h"

// inner classes

// Extra includes
#include <QtMultimedia/qaudioformat.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QAudioFormat_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QAudioFormat >()))
        return -1;

    ::QAudioFormat *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioFormat.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QAudioFormat", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QAudioFormat::QAudioFormat()
    // 1: QAudioFormat::QAudioFormat(QAudioFormat)
    if (numArgs == 0) {
        overloadId = 0; // QAudioFormat()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QAudioFormat(QAudioFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAudioFormat_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QAudioFormat()
        {

            if (!PyErr_Occurred()) {
                // QAudioFormat()
                cptr = new ::QAudioFormat();
            }
            break;
        }
        case 1: // QAudioFormat(const QAudioFormat & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QAudioFormat cppArg0_local;
            ::QAudioFormat *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QAudioFormat(QAudioFormat)
                cptr = new ::QAudioFormat(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QAudioFormat >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QAudioFormat_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QAudioFormat_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QAudioFormatFunc_byteOrder(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioFormat.byteOrder";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // byteOrder()const
            QAudioFormat::Endian cppResult = const_cast<const ::QAudioFormat *>(cppSelf)->byteOrder();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_ENDIAN_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAudioFormatFunc_bytesForDuration(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioFormat.bytesForDuration";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAudioFormat::bytesForDuration(qint64)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // bytesForDuration(qint64)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAudioFormatFunc_bytesForDuration_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // bytesForDuration(qint64)const
            qint32 cppResult = const_cast<const ::QAudioFormat *>(cppSelf)->bytesForDuration(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint32>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAudioFormatFunc_bytesForDuration_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAudioFormatFunc_bytesForFrames(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioFormat.bytesForFrames";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAudioFormat::bytesForFrames(qint32)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint32>(), (pyArg)))) {
        overloadId = 0; // bytesForFrames(qint32)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAudioFormatFunc_bytesForFrames_TypeError;

    // Call function/method
    {
        qint32 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // bytesForFrames(qint32)const
            qint32 cppResult = const_cast<const ::QAudioFormat *>(cppSelf)->bytesForFrames(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint32>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAudioFormatFunc_bytesForFrames_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAudioFormatFunc_bytesPerFrame(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioFormat.bytesPerFrame";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bytesPerFrame()const
            int cppResult = const_cast<const ::QAudioFormat *>(cppSelf)->bytesPerFrame();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAudioFormatFunc_channelCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioFormat.channelCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // channelCount()const
            int cppResult = const_cast<const ::QAudioFormat *>(cppSelf)->channelCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAudioFormatFunc_codec(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioFormat.codec";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // codec()const
            QString cppResult = const_cast<const ::QAudioFormat *>(cppSelf)->codec();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAudioFormatFunc_durationForBytes(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioFormat.durationForBytes";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAudioFormat::durationForBytes(qint32)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint32>(), (pyArg)))) {
        overloadId = 0; // durationForBytes(qint32)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAudioFormatFunc_durationForBytes_TypeError;

    // Call function/method
    {
        qint32 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // durationForBytes(qint32)const
            qint64 cppResult = const_cast<const ::QAudioFormat *>(cppSelf)->durationForBytes(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAudioFormatFunc_durationForBytes_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAudioFormatFunc_durationForFrames(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioFormat.durationForFrames";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAudioFormat::durationForFrames(qint32)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint32>(), (pyArg)))) {
        overloadId = 0; // durationForFrames(qint32)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAudioFormatFunc_durationForFrames_TypeError;

    // Call function/method
    {
        qint32 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // durationForFrames(qint32)const
            qint64 cppResult = const_cast<const ::QAudioFormat *>(cppSelf)->durationForFrames(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAudioFormatFunc_durationForFrames_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAudioFormatFunc_framesForBytes(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioFormat.framesForBytes";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAudioFormat::framesForBytes(qint32)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint32>(), (pyArg)))) {
        overloadId = 0; // framesForBytes(qint32)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAudioFormatFunc_framesForBytes_TypeError;

    // Call function/method
    {
        qint32 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // framesForBytes(qint32)const
            qint32 cppResult = const_cast<const ::QAudioFormat *>(cppSelf)->framesForBytes(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint32>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAudioFormatFunc_framesForBytes_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAudioFormatFunc_framesForDuration(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioFormat.framesForDuration";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAudioFormat::framesForDuration(qint64)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArg)))) {
        overloadId = 0; // framesForDuration(qint64)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAudioFormatFunc_framesForDuration_TypeError;

    // Call function/method
    {
        qint64 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // framesForDuration(qint64)const
            qint32 cppResult = const_cast<const ::QAudioFormat *>(cppSelf)->framesForDuration(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint32>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QAudioFormatFunc_framesForDuration_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAudioFormatFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioFormat.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QAudioFormat *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAudioFormatFunc_sampleRate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioFormat.sampleRate";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sampleRate()const
            int cppResult = const_cast<const ::QAudioFormat *>(cppSelf)->sampleRate();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAudioFormatFunc_sampleSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioFormat.sampleSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sampleSize()const
            int cppResult = const_cast<const ::QAudioFormat *>(cppSelf)->sampleSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAudioFormatFunc_sampleType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioFormat.sampleType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sampleType()const
            QAudioFormat::SampleType cppResult = const_cast<const ::QAudioFormat *>(cppSelf)->sampleType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_SAMPLETYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAudioFormatFunc_setByteOrder(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioFormat.setByteOrder";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAudioFormat::setByteOrder(QAudioFormat::Endian)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_ENDIAN_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setByteOrder(QAudioFormat::Endian)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAudioFormatFunc_setByteOrder_TypeError;

    // Call function/method
    {
        ::QAudioFormat::Endian cppArg0{QAudioFormat::BigEndian};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setByteOrder(QAudioFormat::Endian)
            cppSelf->setByteOrder(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAudioFormatFunc_setByteOrder_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAudioFormatFunc_setChannelCount(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioFormat.setChannelCount";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAudioFormat::setChannelCount(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setChannelCount(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAudioFormatFunc_setChannelCount_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setChannelCount(int)
            cppSelf->setChannelCount(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAudioFormatFunc_setChannelCount_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAudioFormatFunc_setCodec(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioFormat.setCodec";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAudioFormat::setCodec(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setCodec(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAudioFormatFunc_setCodec_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCodec(QString)
            cppSelf->setCodec(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAudioFormatFunc_setCodec_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAudioFormatFunc_setSampleRate(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioFormat.setSampleRate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAudioFormat::setSampleRate(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setSampleRate(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAudioFormatFunc_setSampleRate_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSampleRate(int)
            cppSelf->setSampleRate(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAudioFormatFunc_setSampleRate_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAudioFormatFunc_setSampleSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioFormat.setSampleSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAudioFormat::setSampleSize(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setSampleSize(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAudioFormatFunc_setSampleSize_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSampleSize(int)
            cppSelf->setSampleSize(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAudioFormatFunc_setSampleSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAudioFormatFunc_setSampleType(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioFormat.setSampleType";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAudioFormat::setSampleType(QAudioFormat::SampleType)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_SAMPLETYPE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setSampleType(QAudioFormat::SampleType)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAudioFormatFunc_setSampleType_TypeError;

    // Call function/method
    {
        ::QAudioFormat::SampleType cppArg0{QAudioFormat::Unknown};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSampleType(QAudioFormat::SampleType)
            cppSelf->setSampleType(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QAudioFormatFunc_setSampleType_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QAudioFormat___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QAudioFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QAudioFormat_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QAudioFormat_methods[] = {
    {"byteOrder", reinterpret_cast<PyCFunction>(Sbk_QAudioFormatFunc_byteOrder), METH_NOARGS},
    {"bytesForDuration", reinterpret_cast<PyCFunction>(Sbk_QAudioFormatFunc_bytesForDuration), METH_O},
    {"bytesForFrames", reinterpret_cast<PyCFunction>(Sbk_QAudioFormatFunc_bytesForFrames), METH_O},
    {"bytesPerFrame", reinterpret_cast<PyCFunction>(Sbk_QAudioFormatFunc_bytesPerFrame), METH_NOARGS},
    {"channelCount", reinterpret_cast<PyCFunction>(Sbk_QAudioFormatFunc_channelCount), METH_NOARGS},
    {"codec", reinterpret_cast<PyCFunction>(Sbk_QAudioFormatFunc_codec), METH_NOARGS},
    {"durationForBytes", reinterpret_cast<PyCFunction>(Sbk_QAudioFormatFunc_durationForBytes), METH_O},
    {"durationForFrames", reinterpret_cast<PyCFunction>(Sbk_QAudioFormatFunc_durationForFrames), METH_O},
    {"framesForBytes", reinterpret_cast<PyCFunction>(Sbk_QAudioFormatFunc_framesForBytes), METH_O},
    {"framesForDuration", reinterpret_cast<PyCFunction>(Sbk_QAudioFormatFunc_framesForDuration), METH_O},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QAudioFormatFunc_isValid), METH_NOARGS},
    {"sampleRate", reinterpret_cast<PyCFunction>(Sbk_QAudioFormatFunc_sampleRate), METH_NOARGS},
    {"sampleSize", reinterpret_cast<PyCFunction>(Sbk_QAudioFormatFunc_sampleSize), METH_NOARGS},
    {"sampleType", reinterpret_cast<PyCFunction>(Sbk_QAudioFormatFunc_sampleType), METH_NOARGS},
    {"setByteOrder", reinterpret_cast<PyCFunction>(Sbk_QAudioFormatFunc_setByteOrder), METH_O},
    {"setChannelCount", reinterpret_cast<PyCFunction>(Sbk_QAudioFormatFunc_setChannelCount), METH_O},
    {"setCodec", reinterpret_cast<PyCFunction>(Sbk_QAudioFormatFunc_setCodec), METH_O},
    {"setSampleRate", reinterpret_cast<PyCFunction>(Sbk_QAudioFormatFunc_setSampleRate), METH_O},
    {"setSampleSize", reinterpret_cast<PyCFunction>(Sbk_QAudioFormatFunc_setSampleSize), METH_O},
    {"setSampleType", reinterpret_cast<PyCFunction>(Sbk_QAudioFormatFunc_setSampleType), METH_O},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QAudioFormat___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QAudioFormat_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QAudioFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX]), (pyArg)))) {
                // operator!=(const QAudioFormat & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QAudioFormat cppArg0_local;
                ::QAudioFormat *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX]), (pyArg)))) {
                // operator==(const QAudioFormat & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QAudioFormat cppArg0_local;
                ::QAudioFormat *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QAudioFormat_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QAudioFormat_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QAudioFormat_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QAudioFormat_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QAudioFormat__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QAudioFormat_Type = nullptr;
static SbkObjectType *Sbk_QAudioFormat_TypeF(void)
{
    return _Sbk_QAudioFormat_Type;
}

static PyType_Slot Sbk_QAudioFormat_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QAudioFormat__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QAudioFormat_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QAudioFormat_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QAudioFormat_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QAudioFormat_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QAudioFormat_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QAudioFormat_spec = {
    "2:PySide2.QtMultimedia.QAudioFormat",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QAudioFormat_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QAudioFormat_SampleType_PythonToCpp_QAudioFormat_SampleType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAudioFormat::SampleType *>(cppOut) =
        static_cast<::QAudioFormat::SampleType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAudioFormat_SampleType_PythonToCpp_QAudioFormat_SampleType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_SAMPLETYPE_IDX]))
        return QAudioFormat_SampleType_PythonToCpp_QAudioFormat_SampleType;
    return {};
}
static PyObject *QAudioFormat_SampleType_CppToPython_QAudioFormat_SampleType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAudioFormat::SampleType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_SAMPLETYPE_IDX], castCppIn);

}

static void QAudioFormat_Endian_PythonToCpp_QAudioFormat_Endian(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAudioFormat::Endian *>(cppOut) =
        static_cast<::QAudioFormat::Endian>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QAudioFormat_Endian_PythonToCpp_QAudioFormat_Endian_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_ENDIAN_IDX]))
        return QAudioFormat_Endian_PythonToCpp_QAudioFormat_Endian;
    return {};
}
static PyObject *QAudioFormat_Endian_CppToPython_QAudioFormat_Endian(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QAudioFormat::Endian *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_ENDIAN_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QAudioFormat_PythonToCpp_QAudioFormat_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QAudioFormat_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QAudioFormat_PythonToCpp_QAudioFormat_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QAudioFormat_TypeF())))
        return QAudioFormat_PythonToCpp_QAudioFormat_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QAudioFormat_PTR_CppToPython_QAudioFormat(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QAudioFormat *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QAudioFormat_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QAudioFormat_COPY_CppToPython_QAudioFormat(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QAudioFormat_TypeF(), new ::QAudioFormat(*reinterpret_cast<const ::QAudioFormat *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QAudioFormat_PythonToCpp_QAudioFormat_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAudioFormat *>(cppOut) = *reinterpret_cast< ::QAudioFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QAudioFormat_PythonToCpp_QAudioFormat_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QAudioFormat_TypeF())))
        return QAudioFormat_PythonToCpp_QAudioFormat_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QAudioFormat_SignatureStrings[] = {
    "1:PySide2.QtMultimedia.QAudioFormat(self)",
    "0:PySide2.QtMultimedia.QAudioFormat(self,other:PySide2.QtMultimedia.QAudioFormat)",
    "PySide2.QtMultimedia.QAudioFormat.byteOrder(self)->PySide2.QtMultimedia.QAudioFormat.Endian",
    "PySide2.QtMultimedia.QAudioFormat.bytesForDuration(self,duration:qint64)->qint32",
    "PySide2.QtMultimedia.QAudioFormat.bytesForFrames(self,frameCount:qint32)->qint32",
    "PySide2.QtMultimedia.QAudioFormat.bytesPerFrame(self)->int",
    "PySide2.QtMultimedia.QAudioFormat.channelCount(self)->int",
    "PySide2.QtMultimedia.QAudioFormat.codec(self)->QString",
    "PySide2.QtMultimedia.QAudioFormat.durationForBytes(self,byteCount:qint32)->qint64",
    "PySide2.QtMultimedia.QAudioFormat.durationForFrames(self,frameCount:qint32)->qint64",
    "PySide2.QtMultimedia.QAudioFormat.framesForBytes(self,byteCount:qint32)->qint32",
    "PySide2.QtMultimedia.QAudioFormat.framesForDuration(self,duration:qint64)->qint32",
    "PySide2.QtMultimedia.QAudioFormat.isValid(self)->bool",
    "PySide2.QtMultimedia.QAudioFormat.sampleRate(self)->int",
    "PySide2.QtMultimedia.QAudioFormat.sampleSize(self)->int",
    "PySide2.QtMultimedia.QAudioFormat.sampleType(self)->PySide2.QtMultimedia.QAudioFormat.SampleType",
    "PySide2.QtMultimedia.QAudioFormat.setByteOrder(self,byteOrder:PySide2.QtMultimedia.QAudioFormat.Endian)",
    "PySide2.QtMultimedia.QAudioFormat.setChannelCount(self,channelCount:int)",
    "PySide2.QtMultimedia.QAudioFormat.setCodec(self,codec:QString)",
    "PySide2.QtMultimedia.QAudioFormat.setSampleRate(self,sampleRate:int)",
    "PySide2.QtMultimedia.QAudioFormat.setSampleSize(self,sampleSize:int)",
    "PySide2.QtMultimedia.QAudioFormat.setSampleType(self,sampleType:PySide2.QtMultimedia.QAudioFormat.SampleType)",
    "PySide2.QtMultimedia.QAudioFormat.__copy__()",
    nullptr}; // Sentinel

void init_QAudioFormat(PyObject *module)
{
    _Sbk_QAudioFormat_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QAudioFormat",
        "QAudioFormat",
        &Sbk_QAudioFormat_spec,
        &Shiboken::callCppDestructor< ::QAudioFormat >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QAudioFormat_Type);
    InitSignatureStrings(pyType, QAudioFormat_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QAudioFormat_Type), Sbk_QAudioFormat_PropertyStrings);
    SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QAudioFormat_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QAudioFormat_TypeF(),
        QAudioFormat_PythonToCpp_QAudioFormat_PTR,
        is_QAudioFormat_PythonToCpp_QAudioFormat_PTR_Convertible,
        QAudioFormat_PTR_CppToPython_QAudioFormat,
        QAudioFormat_COPY_CppToPython_QAudioFormat);

    Shiboken::Conversions::registerConverterName(converter, "QAudioFormat");
    Shiboken::Conversions::registerConverterName(converter, "QAudioFormat*");
    Shiboken::Conversions::registerConverterName(converter, "QAudioFormat&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAudioFormat).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QAudioFormat_PythonToCpp_QAudioFormat_COPY,
        is_QAudioFormat_PythonToCpp_QAudioFormat_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'SampleType'.
    SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_SAMPLETYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAudioFormat_TypeF(),
        "SampleType",
        "2:PySide2.QtMultimedia.QAudioFormat.SampleType",
        "QAudioFormat::SampleType");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_SAMPLETYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_SAMPLETYPE_IDX],
        Sbk_QAudioFormat_TypeF(), "Unknown", (long) QAudioFormat::SampleType::Unknown))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_SAMPLETYPE_IDX],
        Sbk_QAudioFormat_TypeF(), "SignedInt", (long) QAudioFormat::SampleType::SignedInt))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_SAMPLETYPE_IDX],
        Sbk_QAudioFormat_TypeF(), "UnSignedInt", (long) QAudioFormat::SampleType::UnSignedInt))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_SAMPLETYPE_IDX],
        Sbk_QAudioFormat_TypeF(), "Float", (long) QAudioFormat::SampleType::Float))
        return;
    // Register converter for enum 'QAudioFormat::SampleType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_SAMPLETYPE_IDX],
            QAudioFormat_SampleType_CppToPython_QAudioFormat_SampleType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAudioFormat_SampleType_PythonToCpp_QAudioFormat_SampleType,
            is_QAudioFormat_SampleType_PythonToCpp_QAudioFormat_SampleType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_SAMPLETYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAudioFormat::SampleType");
        Shiboken::Conversions::registerConverterName(converter, "SampleType");
    }
    // End of 'SampleType' enum.

    // Initialization of enum 'Endian'.
    SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_ENDIAN_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QAudioFormat_TypeF(),
        "Endian",
        "2:PySide2.QtMultimedia.QAudioFormat.Endian",
        "QAudioFormat::Endian");
    if (!SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_ENDIAN_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_ENDIAN_IDX],
        Sbk_QAudioFormat_TypeF(), "BigEndian", (long) QAudioFormat::Endian::BigEndian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_ENDIAN_IDX],
        Sbk_QAudioFormat_TypeF(), "LittleEndian", (long) QAudioFormat::Endian::LittleEndian))
        return;
    // Register converter for enum 'QAudioFormat::Endian'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_ENDIAN_IDX],
            QAudioFormat_Endian_CppToPython_QAudioFormat_Endian);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QAudioFormat_Endian_PythonToCpp_QAudioFormat_Endian,
            is_QAudioFormat_Endian_PythonToCpp_QAudioFormat_Endian_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_ENDIAN_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QAudioFormat::Endian");
        Shiboken::Conversions::registerConverterName(converter, "Endian");
    }
    // End of 'Endian' enum.

    qRegisterMetaType< ::QAudioFormat >("QAudioFormat");
    qRegisterMetaType< ::QAudioFormat::SampleType >("QAudioFormat::SampleType");
    qRegisterMetaType< ::QAudioFormat::Endian >("QAudioFormat::Endian");
}
