/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtmultimedia_python.h"

// main header
#include "qaudiobuffer_wrapper.h"

// inner classes

// Extra includes
#include <QtMultimedia/qaudiobuffer.h>
#include <QtMultimedia/qaudioformat.h>
#include <qbytearray.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QAudioBuffer_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QAudioBuffer >()))
        return -1;

    ::QAudioBuffer *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioBuffer.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QAudioBuffer_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:QAudioBuffer", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return -1;


    // Overloaded function decisor
    // 0: QAudioBuffer::QAudioBuffer()
    // 1: QAudioBuffer::QAudioBuffer(QAudioBuffer)
    // 2: QAudioBuffer::QAudioBuffer(QByteArray,QAudioFormat,qint64)
    // 3: QAudioBuffer::QAudioBuffer(int,QAudioFormat,qint64)
    if (numArgs == 0) {
        overloadId = 0; // QAudioBuffer()
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 3; // QAudioBuffer(int,QAudioFormat,qint64)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[2])))) {
            overloadId = 3; // QAudioBuffer(int,QAudioFormat,qint64)
        }
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 2; // QAudioBuffer(QByteArray,QAudioFormat,qint64)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[2])))) {
            overloadId = 2; // QAudioBuffer(QByteArray,QAudioFormat,qint64)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOBUFFER_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QAudioBuffer(QAudioBuffer)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QAudioBuffer_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QAudioBuffer()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QAudioBuffer_Init_TypeError;
            }

            if (!PyErr_Occurred()) {
                // QAudioBuffer()
                cptr = new ::QAudioBuffer();
            }
            break;
        }
        case 1: // QAudioBuffer(const QAudioBuffer & other)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QAudioBuffer_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QAudioBuffer cppArg0_local;
            ::QAudioBuffer *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOBUFFER_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QAudioBuffer(QAudioBuffer)
                cptr = new ::QAudioBuffer(*cppArg0);
            }
            break;
        }
        case 2: // QAudioBuffer(const QByteArray & data, const QAudioFormat & format, qint64 startTime)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_startTime = Shiboken::String::createStaticString("startTime");
                if (PyDict_Contains(kwds, key_startTime)) {
                    value = PyDict_GetItem(kwds, key_startTime);
                    if (value && pyArgs[2]) {
                        errInfo = key_startTime;
                        Py_INCREF(errInfo);
                        goto Sbk_QAudioBuffer_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[2]))))
                            goto Sbk_QAudioBuffer_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_startTime);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QAudioBuffer_Init_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QAudioFormat cppArg1_local;
            ::QAudioFormat *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            qint64 cppArg2 = -1;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QAudioBuffer(QByteArray,QAudioFormat,qint64)
                cptr = new ::QAudioBuffer(*cppArg0, *cppArg1, cppArg2);
            }
            break;
        }
        case 3: // QAudioBuffer(int numFrames, const QAudioFormat & format, qint64 startTime)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_startTime = Shiboken::String::createStaticString("startTime");
                if (PyDict_Contains(kwds, key_startTime)) {
                    value = PyDict_GetItem(kwds, key_startTime);
                    if (value && pyArgs[2]) {
                        errInfo = key_startTime;
                        Py_INCREF(errInfo);
                        goto Sbk_QAudioBuffer_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[2]))))
                            goto Sbk_QAudioBuffer_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_startTime);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QAudioBuffer_Init_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QAudioFormat cppArg1_local;
            ::QAudioFormat *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            qint64 cppArg2 = -1;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QAudioBuffer(int,QAudioFormat,qint64)
                cptr = new ::QAudioBuffer(cppArg0, *cppArg1, cppArg2);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QAudioBuffer >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QAudioBuffer_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QAudioBuffer_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QAudioBufferFunc_byteCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioBuffer.byteCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // byteCount()const
            int cppResult = const_cast<const ::QAudioBuffer *>(cppSelf)->byteCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAudioBufferFunc_constData(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioBuffer.constData";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // constData()const
            const void * cppResult = const_cast<const ::QAudioBuffer *>(cppSelf)->constData();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAudioBufferFunc_data(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioBuffer.data";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // data()
            void * cppResult = cppSelf->data();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAudioBufferFunc_duration(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioBuffer.duration";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // duration()const
            qint64 cppResult = const_cast<const ::QAudioBuffer *>(cppSelf)->duration();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAudioBufferFunc_format(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioBuffer.format";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // format()const
            QAudioFormat cppResult = const_cast<const ::QAudioBuffer *>(cppSelf)->format();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOFORMAT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAudioBufferFunc_frameCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioBuffer.frameCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // frameCount()const
            int cppResult = const_cast<const ::QAudioBuffer *>(cppSelf)->frameCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAudioBufferFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioBuffer.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QAudioBuffer *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAudioBufferFunc_sampleCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioBuffer.sampleCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sampleCount()const
            int cppResult = const_cast<const ::QAudioBuffer *>(cppSelf)->sampleCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAudioBufferFunc_startTime(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QAudioBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtMultimedia.QAudioBuffer.startTime";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // startTime()const
            qint64 cppResult = const_cast<const ::QAudioBuffer *>(cppSelf)->startTime();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QAudioBuffer___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QAudioBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOBUFFER_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOBUFFER_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QAudioBuffer_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QAudioBuffer_methods[] = {
    {"byteCount", reinterpret_cast<PyCFunction>(Sbk_QAudioBufferFunc_byteCount), METH_NOARGS},
    {"constData", reinterpret_cast<PyCFunction>(Sbk_QAudioBufferFunc_constData), METH_NOARGS},
    {"data", reinterpret_cast<PyCFunction>(Sbk_QAudioBufferFunc_data), METH_NOARGS},
    {"duration", reinterpret_cast<PyCFunction>(Sbk_QAudioBufferFunc_duration), METH_NOARGS},
    {"format", reinterpret_cast<PyCFunction>(Sbk_QAudioBufferFunc_format), METH_NOARGS},
    {"frameCount", reinterpret_cast<PyCFunction>(Sbk_QAudioBufferFunc_frameCount), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QAudioBufferFunc_isValid), METH_NOARGS},
    {"sampleCount", reinterpret_cast<PyCFunction>(Sbk_QAudioBufferFunc_sampleCount), METH_NOARGS},
    {"startTime", reinterpret_cast<PyCFunction>(Sbk_QAudioBufferFunc_startTime), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QAudioBuffer___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QAudioBuffer_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QAudioBuffer_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QAudioBuffer_Type = nullptr;
static SbkObjectType *Sbk_QAudioBuffer_TypeF(void)
{
    return _Sbk_QAudioBuffer_Type;
}

static PyType_Slot Sbk_QAudioBuffer_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QAudioBuffer_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QAudioBuffer_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QAudioBuffer_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QAudioBuffer_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QAudioBuffer_spec = {
    "2:PySide2.QtMultimedia.QAudioBuffer",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QAudioBuffer_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QAudioBuffer_PythonToCpp_QAudioBuffer_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QAudioBuffer_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QAudioBuffer_PythonToCpp_QAudioBuffer_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QAudioBuffer_TypeF())))
        return QAudioBuffer_PythonToCpp_QAudioBuffer_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QAudioBuffer_PTR_CppToPython_QAudioBuffer(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QAudioBuffer *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QAudioBuffer_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QAudioBuffer_COPY_CppToPython_QAudioBuffer(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QAudioBuffer_TypeF(), new ::QAudioBuffer(*reinterpret_cast<const ::QAudioBuffer *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QAudioBuffer_PythonToCpp_QAudioBuffer_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QAudioBuffer *>(cppOut) = *reinterpret_cast< ::QAudioBuffer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtMultimediaTypes[SBK_QAUDIOBUFFER_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QAudioBuffer_PythonToCpp_QAudioBuffer_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QAudioBuffer_TypeF())))
        return QAudioBuffer_PythonToCpp_QAudioBuffer_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QAudioBuffer_SignatureStrings[] = {
    "3:PySide2.QtMultimedia.QAudioBuffer(self)",
    "2:PySide2.QtMultimedia.QAudioBuffer(self,other:PySide2.QtMultimedia.QAudioBuffer)",
    "1:PySide2.QtMultimedia.QAudioBuffer(self,data:PySide2.QtCore.QByteArray,format:PySide2.QtMultimedia.QAudioFormat,startTime:qint64=-1)",
    "0:PySide2.QtMultimedia.QAudioBuffer(self,numFrames:int,format:PySide2.QtMultimedia.QAudioFormat,startTime:qint64=-1)",
    "PySide2.QtMultimedia.QAudioBuffer.byteCount(self)->int",
    "PySide2.QtMultimedia.QAudioBuffer.constData(self)->void",
    "1:PySide2.QtMultimedia.QAudioBuffer.data(self)->void",
    "0:PySide2.QtMultimedia.QAudioBuffer.data(self)->void",
    "PySide2.QtMultimedia.QAudioBuffer.duration(self)->qint64",
    "PySide2.QtMultimedia.QAudioBuffer.format(self)->PySide2.QtMultimedia.QAudioFormat",
    "PySide2.QtMultimedia.QAudioBuffer.frameCount(self)->int",
    "PySide2.QtMultimedia.QAudioBuffer.isValid(self)->bool",
    "PySide2.QtMultimedia.QAudioBuffer.sampleCount(self)->int",
    "PySide2.QtMultimedia.QAudioBuffer.startTime(self)->qint64",
    "PySide2.QtMultimedia.QAudioBuffer.__copy__()",
    nullptr}; // Sentinel

void init_QAudioBuffer(PyObject *module)
{
    _Sbk_QAudioBuffer_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QAudioBuffer",
        "QAudioBuffer",
        &Sbk_QAudioBuffer_spec,
        &Shiboken::callCppDestructor< ::QAudioBuffer >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QAudioBuffer_Type);
    InitSignatureStrings(pyType, QAudioBuffer_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QAudioBuffer_Type), Sbk_QAudioBuffer_PropertyStrings);
    SbkPySide2_QtMultimediaTypes[SBK_QAUDIOBUFFER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QAudioBuffer_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QAudioBuffer_TypeF(),
        QAudioBuffer_PythonToCpp_QAudioBuffer_PTR,
        is_QAudioBuffer_PythonToCpp_QAudioBuffer_PTR_Convertible,
        QAudioBuffer_PTR_CppToPython_QAudioBuffer,
        QAudioBuffer_COPY_CppToPython_QAudioBuffer);

    Shiboken::Conversions::registerConverterName(converter, "QAudioBuffer");
    Shiboken::Conversions::registerConverterName(converter, "QAudioBuffer*");
    Shiboken::Conversions::registerConverterName(converter, "QAudioBuffer&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QAudioBuffer).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QAudioBuffer_PythonToCpp_QAudioBuffer_COPY,
        is_QAudioBuffer_PythonToCpp_QAudioBuffer_COPY_Convertible);

    qRegisterMetaType< ::QAudioBuffer >("QAudioBuffer");
}
