/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtlocation_python.h"

// main header
#include "qplacesupplier_wrapper.h"

// inner classes

// Extra includes
#include <QtLocation/qplaceicon.h>
#include <QtLocation/qplacesupplier.h>
#include <qurl.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QPlaceSupplier_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QPlaceSupplier >()))
        return -1;

    ::QPlaceSupplier *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceSupplier.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QPlaceSupplier", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QPlaceSupplier::QPlaceSupplier()
    // 1: QPlaceSupplier::QPlaceSupplier(QPlaceSupplier)
    if (numArgs == 0) {
        overloadId = 0; // QPlaceSupplier()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACESUPPLIER_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QPlaceSupplier(QPlaceSupplier)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPlaceSupplier_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QPlaceSupplier()
        {

            if (!PyErr_Occurred()) {
                // QPlaceSupplier()
                cptr = new ::QPlaceSupplier();
            }
            break;
        }
        case 1: // QPlaceSupplier(const QPlaceSupplier & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QPlaceSupplier cppArg0_local;
            ::QPlaceSupplier *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACESUPPLIER_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QPlaceSupplier(QPlaceSupplier)
                cptr = new ::QPlaceSupplier(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QPlaceSupplier >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QPlaceSupplier_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QPlaceSupplier_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QPlaceSupplierFunc_icon(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceSupplier *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACESUPPLIER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceSupplier.icon";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // icon()const
            QPlaceIcon cppResult = const_cast<const ::QPlaceSupplier *>(cppSelf)->icon();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACEICON_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPlaceSupplierFunc_isEmpty(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceSupplier *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACESUPPLIER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceSupplier.isEmpty";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isEmpty()const
            bool cppResult = const_cast<const ::QPlaceSupplier *>(cppSelf)->isEmpty();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPlaceSupplierFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceSupplier *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACESUPPLIER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceSupplier.name";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // name()const
            QString cppResult = const_cast<const ::QPlaceSupplier *>(cppSelf)->name();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPlaceSupplierFunc_setIcon(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceSupplier *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACESUPPLIER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceSupplier.setIcon";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPlaceSupplier::setIcon(QPlaceIcon)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACEICON_IDX]), (pyArg)))) {
        overloadId = 0; // setIcon(QPlaceIcon)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPlaceSupplierFunc_setIcon_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPlaceIcon cppArg0_local;
        ::QPlaceIcon *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACEICON_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setIcon(QPlaceIcon)
            cppSelf->setIcon(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPlaceSupplierFunc_setIcon_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPlaceSupplierFunc_setName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceSupplier *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACESUPPLIER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceSupplier.setName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPlaceSupplier::setName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPlaceSupplierFunc_setName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setName(QString)
            cppSelf->setName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPlaceSupplierFunc_setName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPlaceSupplierFunc_setSupplierId(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceSupplier *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACESUPPLIER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceSupplier.setSupplierId";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPlaceSupplier::setSupplierId(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setSupplierId(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPlaceSupplierFunc_setSupplierId_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSupplierId(QString)
            cppSelf->setSupplierId(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPlaceSupplierFunc_setSupplierId_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPlaceSupplierFunc_setUrl(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceSupplier *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACESUPPLIER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceSupplier.setUrl";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPlaceSupplier::setUrl(QUrl)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
        overloadId = 0; // setUrl(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPlaceSupplierFunc_setUrl_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setUrl(QUrl)
            cppSelf->setUrl(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPlaceSupplierFunc_setUrl_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPlaceSupplierFunc_supplierId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceSupplier *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACESUPPLIER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceSupplier.supplierId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supplierId()const
            QString cppResult = const_cast<const ::QPlaceSupplier *>(cppSelf)->supplierId();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPlaceSupplierFunc_url(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceSupplier *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACESUPPLIER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceSupplier.url";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // url()const
            QUrl cppResult = const_cast<const ::QPlaceSupplier *>(cppSelf)->url();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPlaceSupplier___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QPlaceSupplier *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACESUPPLIER_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACESUPPLIER_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QPlaceSupplier_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QPlaceSupplier_methods[] = {
    {"icon", reinterpret_cast<PyCFunction>(Sbk_QPlaceSupplierFunc_icon), METH_NOARGS},
    {"isEmpty", reinterpret_cast<PyCFunction>(Sbk_QPlaceSupplierFunc_isEmpty), METH_NOARGS},
    {"name", reinterpret_cast<PyCFunction>(Sbk_QPlaceSupplierFunc_name), METH_NOARGS},
    {"setIcon", reinterpret_cast<PyCFunction>(Sbk_QPlaceSupplierFunc_setIcon), METH_O},
    {"setName", reinterpret_cast<PyCFunction>(Sbk_QPlaceSupplierFunc_setName), METH_O},
    {"setSupplierId", reinterpret_cast<PyCFunction>(Sbk_QPlaceSupplierFunc_setSupplierId), METH_O},
    {"setUrl", reinterpret_cast<PyCFunction>(Sbk_QPlaceSupplierFunc_setUrl), METH_O},
    {"supplierId", reinterpret_cast<PyCFunction>(Sbk_QPlaceSupplierFunc_supplierId), METH_NOARGS},
    {"url", reinterpret_cast<PyCFunction>(Sbk_QPlaceSupplierFunc_url), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QPlaceSupplier___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QPlaceSupplier_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QPlaceSupplier *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACESUPPLIER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACESUPPLIER_IDX]), (pyArg)))) {
                // operator!=(const QPlaceSupplier & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QPlaceSupplier cppArg0_local;
                ::QPlaceSupplier *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACESUPPLIER_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACESUPPLIER_IDX]), (pyArg)))) {
                // operator==(const QPlaceSupplier & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QPlaceSupplier cppArg0_local;
                ::QPlaceSupplier *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACESUPPLIER_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QPlaceSupplier_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QPlaceSupplier_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QPlaceSupplier_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QPlaceSupplier_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QPlaceSupplier_Type = nullptr;
static SbkObjectType *Sbk_QPlaceSupplier_TypeF(void)
{
    return _Sbk_QPlaceSupplier_Type;
}

static PyType_Slot Sbk_QPlaceSupplier_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QPlaceSupplier_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QPlaceSupplier_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QPlaceSupplier_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QPlaceSupplier_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QPlaceSupplier_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QPlaceSupplier_spec = {
    "2:PySide2.QtLocation.QPlaceSupplier",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QPlaceSupplier_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QPlaceSupplier_PythonToCpp_QPlaceSupplier_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QPlaceSupplier_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QPlaceSupplier_PythonToCpp_QPlaceSupplier_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QPlaceSupplier_TypeF())))
        return QPlaceSupplier_PythonToCpp_QPlaceSupplier_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QPlaceSupplier_PTR_CppToPython_QPlaceSupplier(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QPlaceSupplier *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QPlaceSupplier_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QPlaceSupplier_COPY_CppToPython_QPlaceSupplier(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QPlaceSupplier_TypeF(), new ::QPlaceSupplier(*reinterpret_cast<const ::QPlaceSupplier *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QPlaceSupplier_PythonToCpp_QPlaceSupplier_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPlaceSupplier *>(cppOut) = *reinterpret_cast< ::QPlaceSupplier *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACESUPPLIER_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QPlaceSupplier_PythonToCpp_QPlaceSupplier_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QPlaceSupplier_TypeF())))
        return QPlaceSupplier_PythonToCpp_QPlaceSupplier_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QPlaceSupplier_SignatureStrings[] = {
    "1:PySide2.QtLocation.QPlaceSupplier(self)",
    "0:PySide2.QtLocation.QPlaceSupplier(self,other:PySide2.QtLocation.QPlaceSupplier)",
    "PySide2.QtLocation.QPlaceSupplier.icon(self)->PySide2.QtLocation.QPlaceIcon",
    "PySide2.QtLocation.QPlaceSupplier.isEmpty(self)->bool",
    "PySide2.QtLocation.QPlaceSupplier.name(self)->QString",
    "PySide2.QtLocation.QPlaceSupplier.setIcon(self,icon:PySide2.QtLocation.QPlaceIcon)",
    "PySide2.QtLocation.QPlaceSupplier.setName(self,data:QString)",
    "PySide2.QtLocation.QPlaceSupplier.setSupplierId(self,identifier:QString)",
    "PySide2.QtLocation.QPlaceSupplier.setUrl(self,data:PySide2.QtCore.QUrl)",
    "PySide2.QtLocation.QPlaceSupplier.supplierId(self)->QString",
    "PySide2.QtLocation.QPlaceSupplier.url(self)->PySide2.QtCore.QUrl",
    "PySide2.QtLocation.QPlaceSupplier.__copy__()",
    nullptr}; // Sentinel

void init_QPlaceSupplier(PyObject *module)
{
    _Sbk_QPlaceSupplier_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QPlaceSupplier",
        "QPlaceSupplier",
        &Sbk_QPlaceSupplier_spec,
        &Shiboken::callCppDestructor< ::QPlaceSupplier >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QPlaceSupplier_Type);
    InitSignatureStrings(pyType, QPlaceSupplier_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QPlaceSupplier_Type), Sbk_QPlaceSupplier_PropertyStrings);
    SbkPySide2_QtLocationTypes[SBK_QPLACESUPPLIER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QPlaceSupplier_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QPlaceSupplier_TypeF(),
        QPlaceSupplier_PythonToCpp_QPlaceSupplier_PTR,
        is_QPlaceSupplier_PythonToCpp_QPlaceSupplier_PTR_Convertible,
        QPlaceSupplier_PTR_CppToPython_QPlaceSupplier,
        QPlaceSupplier_COPY_CppToPython_QPlaceSupplier);

    Shiboken::Conversions::registerConverterName(converter, "QPlaceSupplier");
    Shiboken::Conversions::registerConverterName(converter, "QPlaceSupplier*");
    Shiboken::Conversions::registerConverterName(converter, "QPlaceSupplier&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QPlaceSupplier).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QPlaceSupplier_PythonToCpp_QPlaceSupplier_COPY,
        is_QPlaceSupplier_PythonToCpp_QPlaceSupplier_COPY_Convertible);

    qRegisterMetaType< ::QPlaceSupplier >("QPlaceSupplier");
}
