/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtlocation_python.h"

// main header
#include "qplacesearchresult_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QPlaceSearchResultWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QPlaceSearchResultWrapper::QPlaceSearchResultWrapper() : QPlaceSearchResult()
{
    resetPyMethodCache();
    // ... middle
}

QPlaceSearchResultWrapper::~QPlaceSearchResultWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QPlaceSearchResult_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QPlaceSearchResult >()))
        return -1;

    ::QPlaceSearchResultWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceSearchResult.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QPlaceSearchResult", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QPlaceSearchResult::QPlaceSearchResult()
    // 1: QPlaceSearchResult::QPlaceSearchResult(QPlaceSearchResult)
    if (numArgs == 0) {
        overloadId = 0; // QPlaceSearchResult()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHRESULT_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QPlaceSearchResult(QPlaceSearchResult)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPlaceSearchResult_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QPlaceSearchResult()
        {

            if (!PyErr_Occurred()) {
                // QPlaceSearchResult()
                cptr = new ::QPlaceSearchResultWrapper();
            }
            break;
        }
        case 1: // QPlaceSearchResult(const QPlaceSearchResult & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QPlaceSearchResult *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QPlaceSearchResult(QPlaceSearchResult)
                cptr = new ::QPlaceSearchResultWrapper(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QPlaceSearchResult >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QPlaceSearchResult_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QPlaceSearchResult_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QPlaceSearchResultFunc_icon(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceSearchResult *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHRESULT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceSearchResult.icon";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // icon()const
            QPlaceIcon cppResult = const_cast<const ::QPlaceSearchResult *>(cppSelf)->icon();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACEICON_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPlaceSearchResultFunc_setIcon(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceSearchResult *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHRESULT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceSearchResult.setIcon";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPlaceSearchResult::setIcon(QPlaceIcon)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACEICON_IDX]), (pyArg)))) {
        overloadId = 0; // setIcon(QPlaceIcon)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPlaceSearchResultFunc_setIcon_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPlaceIcon cppArg0_local;
        ::QPlaceIcon *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACEICON_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setIcon(QPlaceIcon)
            cppSelf->setIcon(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPlaceSearchResultFunc_setIcon_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPlaceSearchResultFunc_setTitle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceSearchResult *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHRESULT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceSearchResult.setTitle";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPlaceSearchResult::setTitle(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setTitle(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPlaceSearchResultFunc_setTitle_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTitle(QString)
            cppSelf->setTitle(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPlaceSearchResultFunc_setTitle_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPlaceSearchResultFunc_title(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceSearchResult *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHRESULT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceSearchResult.title";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // title()const
            QString cppResult = const_cast<const ::QPlaceSearchResult *>(cppSelf)->title();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPlaceSearchResultFunc_type(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceSearchResult *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHRESULT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceSearchResult.type";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // type()const
            QPlaceSearchResult::SearchResultType cppResult = const_cast<const ::QPlaceSearchResult *>(cppSelf)->type();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHRESULT_SEARCHRESULTTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QPlaceSearchResult_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QPlaceSearchResult_methods[] = {
    {"icon", reinterpret_cast<PyCFunction>(Sbk_QPlaceSearchResultFunc_icon), METH_NOARGS},
    {"setIcon", reinterpret_cast<PyCFunction>(Sbk_QPlaceSearchResultFunc_setIcon), METH_O},
    {"setTitle", reinterpret_cast<PyCFunction>(Sbk_QPlaceSearchResultFunc_setTitle), METH_O},
    {"title", reinterpret_cast<PyCFunction>(Sbk_QPlaceSearchResultFunc_title), METH_NOARGS},
    {"type", reinterpret_cast<PyCFunction>(Sbk_QPlaceSearchResultFunc_type), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QPlaceSearchResult_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QPlaceSearchResult *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHRESULT_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QPlaceSearchResultWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

// Rich comparison
static PyObject * Sbk_QPlaceSearchResult_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QPlaceSearchResult *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHRESULT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHRESULT_IDX]), (pyArg)))) {
                // operator!=(const QPlaceSearchResult & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QPlaceSearchResult *cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHRESULT_IDX]), (pyArg)))) {
                // operator==(const QPlaceSearchResult & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QPlaceSearchResult *cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QPlaceSearchResult_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QPlaceSearchResult_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QPlaceSearchResult_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QPlaceSearchResult_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QPlaceSearchResult_Type = nullptr;
static SbkObjectType *Sbk_QPlaceSearchResult_TypeF(void)
{
    return _Sbk_QPlaceSearchResult_Type;
}

static PyType_Slot Sbk_QPlaceSearchResult_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QPlaceSearchResult_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QPlaceSearchResult_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QPlaceSearchResult_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QPlaceSearchResult_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QPlaceSearchResult_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QPlaceSearchResult_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QPlaceSearchResult_spec = {
    "2:PySide2.QtLocation.QPlaceSearchResult",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QPlaceSearchResult_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QPlaceSearchResult_SearchResultType_PythonToCpp_QPlaceSearchResult_SearchResultType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPlaceSearchResult::SearchResultType *>(cppOut) =
        static_cast<::QPlaceSearchResult::SearchResultType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QPlaceSearchResult_SearchResultType_PythonToCpp_QPlaceSearchResult_SearchResultType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHRESULT_SEARCHRESULTTYPE_IDX]))
        return QPlaceSearchResult_SearchResultType_PythonToCpp_QPlaceSearchResult_SearchResultType;
    return {};
}
static PyObject *QPlaceSearchResult_SearchResultType_CppToPython_QPlaceSearchResult_SearchResultType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QPlaceSearchResult::SearchResultType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHRESULT_SEARCHRESULTTYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QPlaceSearchResult_PythonToCpp_QPlaceSearchResult_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QPlaceSearchResult_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QPlaceSearchResult_PythonToCpp_QPlaceSearchResult_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QPlaceSearchResult_TypeF())))
        return QPlaceSearchResult_PythonToCpp_QPlaceSearchResult_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QPlaceSearchResult_PTR_CppToPython_QPlaceSearchResult(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QPlaceSearchResult *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QPlaceSearchResult_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QPlaceSearchResult_SignatureStrings[] = {
    "1:PySide2.QtLocation.QPlaceSearchResult(self)",
    "0:PySide2.QtLocation.QPlaceSearchResult(self,other:PySide2.QtLocation.QPlaceSearchResult)",
    "PySide2.QtLocation.QPlaceSearchResult.icon(self)->PySide2.QtLocation.QPlaceIcon",
    "PySide2.QtLocation.QPlaceSearchResult.setIcon(self,icon:PySide2.QtLocation.QPlaceIcon)",
    "PySide2.QtLocation.QPlaceSearchResult.setTitle(self,title:QString)",
    "PySide2.QtLocation.QPlaceSearchResult.title(self)->QString",
    "PySide2.QtLocation.QPlaceSearchResult.type(self)->PySide2.QtLocation.QPlaceSearchResult.SearchResultType",
    nullptr}; // Sentinel

void init_QPlaceSearchResult(PyObject *module)
{
    _Sbk_QPlaceSearchResult_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QPlaceSearchResult",
        "QPlaceSearchResult*",
        &Sbk_QPlaceSearchResult_spec,
        &Shiboken::callCppDestructor< ::QPlaceSearchResult >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QPlaceSearchResult_Type);
    InitSignatureStrings(pyType, QPlaceSearchResult_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QPlaceSearchResult_Type), Sbk_QPlaceSearchResult_PropertyStrings);
    SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHRESULT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QPlaceSearchResult_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QPlaceSearchResult_TypeF(),
        QPlaceSearchResult_PythonToCpp_QPlaceSearchResult_PTR,
        is_QPlaceSearchResult_PythonToCpp_QPlaceSearchResult_PTR_Convertible,
        QPlaceSearchResult_PTR_CppToPython_QPlaceSearchResult);

    Shiboken::Conversions::registerConverterName(converter, "QPlaceSearchResult");
    Shiboken::Conversions::registerConverterName(converter, "QPlaceSearchResult*");
    Shiboken::Conversions::registerConverterName(converter, "QPlaceSearchResult&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QPlaceSearchResult).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QPlaceSearchResultWrapper).name());


    // Initialization of enums.

    // Initialization of enum 'SearchResultType'.
    SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHRESULT_SEARCHRESULTTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QPlaceSearchResult_TypeF(),
        "SearchResultType",
        "2:PySide2.QtLocation.QPlaceSearchResult.SearchResultType",
        "QPlaceSearchResult::SearchResultType");
    if (!SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHRESULT_SEARCHRESULTTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHRESULT_SEARCHRESULTTYPE_IDX],
        Sbk_QPlaceSearchResult_TypeF(), "UnknownSearchResult", (long) QPlaceSearchResult::SearchResultType::UnknownSearchResult))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHRESULT_SEARCHRESULTTYPE_IDX],
        Sbk_QPlaceSearchResult_TypeF(), "PlaceResult", (long) QPlaceSearchResult::SearchResultType::PlaceResult))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHRESULT_SEARCHRESULTTYPE_IDX],
        Sbk_QPlaceSearchResult_TypeF(), "ProposedSearchResult", (long) QPlaceSearchResult::SearchResultType::ProposedSearchResult))
        return;
    // Register converter for enum 'QPlaceSearchResult::SearchResultType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHRESULT_SEARCHRESULTTYPE_IDX],
            QPlaceSearchResult_SearchResultType_CppToPython_QPlaceSearchResult_SearchResultType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QPlaceSearchResult_SearchResultType_PythonToCpp_QPlaceSearchResult_SearchResultType,
            is_QPlaceSearchResult_SearchResultType_PythonToCpp_QPlaceSearchResult_SearchResultType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHRESULT_SEARCHRESULTTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QPlaceSearchResult::SearchResultType");
        Shiboken::Conversions::registerConverterName(converter, "SearchResultType");
    }
    // End of 'SearchResultType' enum.

    qRegisterMetaType< ::QPlaceSearchResult::SearchResultType >("QPlaceSearchResult::SearchResultType");
}
