/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtlocation_python.h"

// main header
#include "qplacesearchrequest_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <QtLocation/qplacecategory.h>
#include <QtLocation/qplacesearchrequest.h>
#include <QtPositioning/qgeoshape.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QPlaceSearchRequest_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QPlaceSearchRequest >()))
        return -1;

    ::QPlaceSearchRequest *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceSearchRequest.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QPlaceSearchRequest", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QPlaceSearchRequest::QPlaceSearchRequest()
    // 1: QPlaceSearchRequest::QPlaceSearchRequest(QPlaceSearchRequest)
    if (numArgs == 0) {
        overloadId = 0; // QPlaceSearchRequest()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHREQUEST_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QPlaceSearchRequest(QPlaceSearchRequest)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPlaceSearchRequest_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QPlaceSearchRequest()
        {

            if (!PyErr_Occurred()) {
                // QPlaceSearchRequest()
                cptr = new ::QPlaceSearchRequest();
            }
            break;
        }
        case 1: // QPlaceSearchRequest(const QPlaceSearchRequest & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QPlaceSearchRequest *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QPlaceSearchRequest(QPlaceSearchRequest)
                cptr = new ::QPlaceSearchRequest(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QPlaceSearchRequest >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QPlaceSearchRequest_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QPlaceSearchRequest_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QPlaceSearchRequestFunc_categories(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceSearchRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceSearchRequest.categories";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // categories()const
            QList<QPlaceCategory > cppResult = const_cast<const ::QPlaceSearchRequest *>(cppSelf)->categories();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QPLACECATEGORY_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPlaceSearchRequestFunc_clear(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceSearchRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceSearchRequest.clear";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clear()
            cppSelf->clear();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QPlaceSearchRequestFunc_limit(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceSearchRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceSearchRequest.limit";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // limit()const
            int cppResult = const_cast<const ::QPlaceSearchRequest *>(cppSelf)->limit();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPlaceSearchRequestFunc_recommendationId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceSearchRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceSearchRequest.recommendationId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // recommendationId()const
            QString cppResult = const_cast<const ::QPlaceSearchRequest *>(cppSelf)->recommendationId();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPlaceSearchRequestFunc_relevanceHint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceSearchRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceSearchRequest.relevanceHint";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // relevanceHint()const
            QPlaceSearchRequest::RelevanceHint cppResult = const_cast<const ::QPlaceSearchRequest *>(cppSelf)->relevanceHint();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHREQUEST_RELEVANCEHINT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPlaceSearchRequestFunc_searchArea(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceSearchRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceSearchRequest.searchArea";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // searchArea()const
            QGeoShape cppResult = const_cast<const ::QPlaceSearchRequest *>(cppSelf)->searchArea();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOSHAPE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPlaceSearchRequestFunc_searchContext(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceSearchRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceSearchRequest.searchContext";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // searchContext()const
            QVariant cppResult = const_cast<const ::QPlaceSearchRequest *>(cppSelf)->searchContext();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPlaceSearchRequestFunc_searchTerm(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceSearchRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceSearchRequest.searchTerm";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // searchTerm()const
            QString cppResult = const_cast<const ::QPlaceSearchRequest *>(cppSelf)->searchTerm();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPlaceSearchRequestFunc_setCategories(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceSearchRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceSearchRequest.setCategories";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPlaceSearchRequest::setCategories(QList<QPlaceCategory>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QPLACECATEGORY_IDX], (pyArg)))) {
        overloadId = 0; // setCategories(QList<QPlaceCategory>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPlaceSearchRequestFunc_setCategories_TypeError;

    // Call function/method
    {
        ::QList<QPlaceCategory > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCategories(QList<QPlaceCategory>)
            cppSelf->setCategories(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPlaceSearchRequestFunc_setCategories_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPlaceSearchRequestFunc_setCategory(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceSearchRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceSearchRequest.setCategory";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPlaceSearchRequest::setCategory(QPlaceCategory)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACECATEGORY_IDX]), (pyArg)))) {
        overloadId = 0; // setCategory(QPlaceCategory)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPlaceSearchRequestFunc_setCategory_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPlaceCategory cppArg0_local;
        ::QPlaceCategory *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACECATEGORY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setCategory(QPlaceCategory)
            cppSelf->setCategory(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPlaceSearchRequestFunc_setCategory_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPlaceSearchRequestFunc_setLimit(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceSearchRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceSearchRequest.setLimit";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPlaceSearchRequest::setLimit(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setLimit(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPlaceSearchRequestFunc_setLimit_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLimit(int)
            cppSelf->setLimit(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPlaceSearchRequestFunc_setLimit_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPlaceSearchRequestFunc_setRecommendationId(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceSearchRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceSearchRequest.setRecommendationId";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPlaceSearchRequest::setRecommendationId(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setRecommendationId(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPlaceSearchRequestFunc_setRecommendationId_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRecommendationId(QString)
            cppSelf->setRecommendationId(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPlaceSearchRequestFunc_setRecommendationId_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPlaceSearchRequestFunc_setRelevanceHint(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceSearchRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceSearchRequest.setRelevanceHint";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPlaceSearchRequest::setRelevanceHint(QPlaceSearchRequest::RelevanceHint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHREQUEST_RELEVANCEHINT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setRelevanceHint(QPlaceSearchRequest::RelevanceHint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPlaceSearchRequestFunc_setRelevanceHint_TypeError;

    // Call function/method
    {
        ::QPlaceSearchRequest::RelevanceHint cppArg0{QPlaceSearchRequest::UnspecifiedHint};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRelevanceHint(QPlaceSearchRequest::RelevanceHint)
            cppSelf->setRelevanceHint(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPlaceSearchRequestFunc_setRelevanceHint_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPlaceSearchRequestFunc_setSearchArea(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceSearchRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceSearchRequest.setSearchArea";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPlaceSearchRequest::setSearchArea(QGeoShape)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOSHAPE_IDX]), (pyArg)))) {
        overloadId = 0; // setSearchArea(QGeoShape)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPlaceSearchRequestFunc_setSearchArea_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGeoShape cppArg0_local;
        ::QGeoShape *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOSHAPE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setSearchArea(QGeoShape)
            cppSelf->setSearchArea(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPlaceSearchRequestFunc_setSearchArea_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPlaceSearchRequestFunc_setSearchContext(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceSearchRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceSearchRequest.setSearchContext";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPlaceSearchRequest::setSearchContext(QVariant)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArg)))) {
        overloadId = 0; // setSearchContext(QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPlaceSearchRequestFunc_setSearchContext_TypeError;

    // Call function/method
    {
        ::QVariant cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSearchContext(QVariant)
            cppSelf->setSearchContext(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPlaceSearchRequestFunc_setSearchContext_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPlaceSearchRequestFunc_setSearchTerm(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPlaceSearchRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QPlaceSearchRequest.setSearchTerm";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPlaceSearchRequest::setSearchTerm(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setSearchTerm(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPlaceSearchRequestFunc_setSearchTerm_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSearchTerm(QString)
            cppSelf->setSearchTerm(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPlaceSearchRequestFunc_setSearchTerm_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QPlaceSearchRequest_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QPlaceSearchRequest_methods[] = {
    {"categories", reinterpret_cast<PyCFunction>(Sbk_QPlaceSearchRequestFunc_categories), METH_NOARGS},
    {"clear", reinterpret_cast<PyCFunction>(Sbk_QPlaceSearchRequestFunc_clear), METH_NOARGS},
    {"limit", reinterpret_cast<PyCFunction>(Sbk_QPlaceSearchRequestFunc_limit), METH_NOARGS},
    {"recommendationId", reinterpret_cast<PyCFunction>(Sbk_QPlaceSearchRequestFunc_recommendationId), METH_NOARGS},
    {"relevanceHint", reinterpret_cast<PyCFunction>(Sbk_QPlaceSearchRequestFunc_relevanceHint), METH_NOARGS},
    {"searchArea", reinterpret_cast<PyCFunction>(Sbk_QPlaceSearchRequestFunc_searchArea), METH_NOARGS},
    {"searchContext", reinterpret_cast<PyCFunction>(Sbk_QPlaceSearchRequestFunc_searchContext), METH_NOARGS},
    {"searchTerm", reinterpret_cast<PyCFunction>(Sbk_QPlaceSearchRequestFunc_searchTerm), METH_NOARGS},
    {"setCategories", reinterpret_cast<PyCFunction>(Sbk_QPlaceSearchRequestFunc_setCategories), METH_O},
    {"setCategory", reinterpret_cast<PyCFunction>(Sbk_QPlaceSearchRequestFunc_setCategory), METH_O},
    {"setLimit", reinterpret_cast<PyCFunction>(Sbk_QPlaceSearchRequestFunc_setLimit), METH_O},
    {"setRecommendationId", reinterpret_cast<PyCFunction>(Sbk_QPlaceSearchRequestFunc_setRecommendationId), METH_O},
    {"setRelevanceHint", reinterpret_cast<PyCFunction>(Sbk_QPlaceSearchRequestFunc_setRelevanceHint), METH_O},
    {"setSearchArea", reinterpret_cast<PyCFunction>(Sbk_QPlaceSearchRequestFunc_setSearchArea), METH_O},
    {"setSearchContext", reinterpret_cast<PyCFunction>(Sbk_QPlaceSearchRequestFunc_setSearchContext), METH_O},
    {"setSearchTerm", reinterpret_cast<PyCFunction>(Sbk_QPlaceSearchRequestFunc_setSearchTerm), METH_O},

    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QPlaceSearchRequest_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QPlaceSearchRequest *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHREQUEST_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHREQUEST_IDX]), (pyArg)))) {
                // operator!=(const QPlaceSearchRequest & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QPlaceSearchRequest *cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHREQUEST_IDX]), (pyArg)))) {
                // operator==(const QPlaceSearchRequest & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QPlaceSearchRequest *cppArg0;
                pythonToCpp(pyArg, &cppArg0);
                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QPlaceSearchRequest_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QPlaceSearchRequest_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QPlaceSearchRequest_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QPlaceSearchRequest_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QPlaceSearchRequest_Type = nullptr;
static SbkObjectType *Sbk_QPlaceSearchRequest_TypeF(void)
{
    return _Sbk_QPlaceSearchRequest_Type;
}

static PyType_Slot Sbk_QPlaceSearchRequest_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QPlaceSearchRequest_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QPlaceSearchRequest_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QPlaceSearchRequest_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QPlaceSearchRequest_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QPlaceSearchRequest_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QPlaceSearchRequest_spec = {
    "2:PySide2.QtLocation.QPlaceSearchRequest",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QPlaceSearchRequest_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QPlaceSearchRequest_RelevanceHint_PythonToCpp_QPlaceSearchRequest_RelevanceHint(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPlaceSearchRequest::RelevanceHint *>(cppOut) =
        static_cast<::QPlaceSearchRequest::RelevanceHint>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QPlaceSearchRequest_RelevanceHint_PythonToCpp_QPlaceSearchRequest_RelevanceHint_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHREQUEST_RELEVANCEHINT_IDX]))
        return QPlaceSearchRequest_RelevanceHint_PythonToCpp_QPlaceSearchRequest_RelevanceHint;
    return {};
}
static PyObject *QPlaceSearchRequest_RelevanceHint_CppToPython_QPlaceSearchRequest_RelevanceHint(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QPlaceSearchRequest::RelevanceHint *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHREQUEST_RELEVANCEHINT_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QPlaceSearchRequest_PythonToCpp_QPlaceSearchRequest_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QPlaceSearchRequest_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QPlaceSearchRequest_PythonToCpp_QPlaceSearchRequest_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QPlaceSearchRequest_TypeF())))
        return QPlaceSearchRequest_PythonToCpp_QPlaceSearchRequest_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QPlaceSearchRequest_PTR_CppToPython_QPlaceSearchRequest(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QPlaceSearchRequest *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QPlaceSearchRequest_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QPlaceSearchRequest_SignatureStrings[] = {
    "1:PySide2.QtLocation.QPlaceSearchRequest(self)",
    "0:PySide2.QtLocation.QPlaceSearchRequest(self,other:PySide2.QtLocation.QPlaceSearchRequest)",
    "PySide2.QtLocation.QPlaceSearchRequest.categories(self)->QList[PySide2.QtLocation.QPlaceCategory]",
    "PySide2.QtLocation.QPlaceSearchRequest.clear(self)",
    "PySide2.QtLocation.QPlaceSearchRequest.limit(self)->int",
    "PySide2.QtLocation.QPlaceSearchRequest.recommendationId(self)->QString",
    "PySide2.QtLocation.QPlaceSearchRequest.relevanceHint(self)->PySide2.QtLocation.QPlaceSearchRequest.RelevanceHint",
    "PySide2.QtLocation.QPlaceSearchRequest.searchArea(self)->PySide2.QtPositioning.QGeoShape",
    "PySide2.QtLocation.QPlaceSearchRequest.searchContext(self)->QVariant",
    "PySide2.QtLocation.QPlaceSearchRequest.searchTerm(self)->QString",
    "PySide2.QtLocation.QPlaceSearchRequest.setCategories(self,categories:QList[PySide2.QtLocation.QPlaceCategory])",
    "PySide2.QtLocation.QPlaceSearchRequest.setCategory(self,category:PySide2.QtLocation.QPlaceCategory)",
    "PySide2.QtLocation.QPlaceSearchRequest.setLimit(self,limit:int)",
    "PySide2.QtLocation.QPlaceSearchRequest.setRecommendationId(self,recommendationId:QString)",
    "PySide2.QtLocation.QPlaceSearchRequest.setRelevanceHint(self,hint:PySide2.QtLocation.QPlaceSearchRequest.RelevanceHint)",
    "PySide2.QtLocation.QPlaceSearchRequest.setSearchArea(self,area:PySide2.QtPositioning.QGeoShape)",
    "PySide2.QtLocation.QPlaceSearchRequest.setSearchContext(self,context:QVariant)",
    "PySide2.QtLocation.QPlaceSearchRequest.setSearchTerm(self,term:QString)",
    nullptr}; // Sentinel

void init_QPlaceSearchRequest(PyObject *module)
{
    _Sbk_QPlaceSearchRequest_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QPlaceSearchRequest",
        "QPlaceSearchRequest*",
        &Sbk_QPlaceSearchRequest_spec,
        &Shiboken::callCppDestructor< ::QPlaceSearchRequest >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QPlaceSearchRequest_Type);
    InitSignatureStrings(pyType, QPlaceSearchRequest_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QPlaceSearchRequest_Type), Sbk_QPlaceSearchRequest_PropertyStrings);
    SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHREQUEST_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QPlaceSearchRequest_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QPlaceSearchRequest_TypeF(),
        QPlaceSearchRequest_PythonToCpp_QPlaceSearchRequest_PTR,
        is_QPlaceSearchRequest_PythonToCpp_QPlaceSearchRequest_PTR_Convertible,
        QPlaceSearchRequest_PTR_CppToPython_QPlaceSearchRequest);

    Shiboken::Conversions::registerConverterName(converter, "QPlaceSearchRequest");
    Shiboken::Conversions::registerConverterName(converter, "QPlaceSearchRequest*");
    Shiboken::Conversions::registerConverterName(converter, "QPlaceSearchRequest&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QPlaceSearchRequest).name());


    // Initialization of enums.

    // Initialization of enum 'RelevanceHint'.
    SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHREQUEST_RELEVANCEHINT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QPlaceSearchRequest_TypeF(),
        "RelevanceHint",
        "2:PySide2.QtLocation.QPlaceSearchRequest.RelevanceHint",
        "QPlaceSearchRequest::RelevanceHint");
    if (!SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHREQUEST_RELEVANCEHINT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHREQUEST_RELEVANCEHINT_IDX],
        Sbk_QPlaceSearchRequest_TypeF(), "UnspecifiedHint", (long) QPlaceSearchRequest::RelevanceHint::UnspecifiedHint))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHREQUEST_RELEVANCEHINT_IDX],
        Sbk_QPlaceSearchRequest_TypeF(), "DistanceHint", (long) QPlaceSearchRequest::RelevanceHint::DistanceHint))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHREQUEST_RELEVANCEHINT_IDX],
        Sbk_QPlaceSearchRequest_TypeF(), "LexicalPlaceNameHint", (long) QPlaceSearchRequest::RelevanceHint::LexicalPlaceNameHint))
        return;
    // Register converter for enum 'QPlaceSearchRequest::RelevanceHint'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHREQUEST_RELEVANCEHINT_IDX],
            QPlaceSearchRequest_RelevanceHint_CppToPython_QPlaceSearchRequest_RelevanceHint);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QPlaceSearchRequest_RelevanceHint_PythonToCpp_QPlaceSearchRequest_RelevanceHint,
            is_QPlaceSearchRequest_RelevanceHint_PythonToCpp_QPlaceSearchRequest_RelevanceHint_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtLocationTypes[SBK_QPLACESEARCHREQUEST_RELEVANCEHINT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QPlaceSearchRequest::RelevanceHint");
        Shiboken::Conversions::registerConverterName(converter, "RelevanceHint");
    }
    // End of 'RelevanceHint' enum.

    qRegisterMetaType< ::QPlaceSearchRequest::RelevanceHint >("QPlaceSearchRequest::RelevanceHint");
}
