/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtlocation_python.h"

// main header
#include "qgeoroutingmanagerengine_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QGeoRoutingManagerEngineWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QGeoRoutingManagerEngineWrapper::QGeoRoutingManagerEngineWrapper(const ::QMap<QString,QVariant > & parameters, ::QObject * parent) : QGeoRoutingManagerEngine(parameters, parent)
{
    resetPyMethodCache();
    // ... middle
}

::QGeoRouteReply * QGeoRoutingManagerEngineWrapper::calculateRoute(const ::QGeoRouteRequest & request)
{
    if (m_PyMethodCache[0]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoRoutingManagerEngine.calculateRoute()' not implemented.");
        return nullptr;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "calculateRoute";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoRoutingManagerEngine.calculateRoute()' not implemented.");
        return nullptr;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_IDX]), &request)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREPLY_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGeoRoutingManagerEngine.calculateRoute", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QGeoRouteReply >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QGeoRouteReply *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QGeoRoutingManagerEngineWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGeoRoutingManagerEngineWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QGeoRoutingManagerEngineWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGeoRoutingManagerEngineWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[4]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QGeoRoutingManagerEngineWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGeoRoutingManagerEngine.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QGeoRoutingManagerEngineWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[6])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGeoRoutingManagerEngine.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QGeoRoutingManagerEngineWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[8]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

::QGeoRouteReply * QGeoRoutingManagerEngineWrapper::updateRoute(const ::QGeoRoute & route, const ::QGeoCoordinate & position)
{
    if (m_PyMethodCache[9])
        return this->::QGeoRoutingManagerEngine::updateRoute(route, position);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "updateRoute";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QGeoRoutingManagerEngine::updateRoute(route, position);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QGEOROUTE_IDX]), &route),
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), &position)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREPLY_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGeoRoutingManagerEngine.updateRoute", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QGeoRouteReply >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QGeoRouteReply *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

const QMetaObject *QGeoRoutingManagerEngineWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QGeoRoutingManagerEngine::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QGeoRoutingManagerEngineWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QGeoRoutingManagerEngine::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QGeoRoutingManagerEngineWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QGeoRoutingManagerEngineWrapper *>(this));
        return QGeoRoutingManagerEngine::qt_metacast(_clname);
}

QGeoRoutingManagerEngineWrapper::~QGeoRoutingManagerEngineWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QGeoRoutingManagerEngine_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QGEOROUTINGMANAGERENGINE_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QGeoRoutingManagerEngine' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QGeoRoutingManagerEngine >()))
        return -1;

    ::QGeoRoutingManagerEngineWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRoutingManagerEngine.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QGeoRoutingManagerEngine_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:QGeoRoutingManagerEngine", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QGeoRoutingManagerEngine::QGeoRoutingManagerEngine(QMap<QString,QVariant>,QObject*)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QMAP_QSTRING_QVARIANT_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // QGeoRoutingManagerEngine(QMap<QString,QVariant>,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
            overloadId = 0; // QGeoRoutingManagerEngine(QMap<QString,QVariant>,QObject*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoRoutingManagerEngine_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[1]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QGeoRoutingManagerEngine_Init_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1]))))
                        goto Sbk_QGeoRoutingManagerEngine_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        ::QMap<QString,QVariant > cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return -1;
        ::QObject *cppArg1 = nullptr;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // QGeoRoutingManagerEngine(QMap<QString,QVariant>,QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QGeoRoutingManagerEngineWrapper(cppArg0, cppArg1);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QGeoRoutingManagerEngineWrapper(cppArg0, cppArg1);
            }

            Shiboken::Object::setParent(pyArgs[1], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QGeoRoutingManagerEngine >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QGeoRoutingManagerEngine_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QGeoRoutingManagerEngine_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QGeoRoutingManagerEngine_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QGeoRoutingManagerEngineFunc_calculateRoute(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRoutingManagerEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTINGMANAGERENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRoutingManagerEngine.calculateRoute";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoRoutingManagerEngine::calculateRoute(QGeoRouteRequest)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_IDX]), (pyArg)))) {
        overloadId = 0; // calculateRoute(QGeoRouteRequest)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoRoutingManagerEngineFunc_calculateRoute_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGeoRouteRequest *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // calculateRoute(QGeoRouteRequest)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGeoRoutingManagerEngine.calculateRoute()' not implemented.");
                return {};
            }
            QGeoRouteReply * cppResult = cppSelf->calculateRoute(*cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREPLY_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoRoutingManagerEngineFunc_calculateRoute_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoRoutingManagerEngineFunc_locale(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRoutingManagerEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTINGMANAGERENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRoutingManagerEngine.locale";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // locale()const
            QLocale cppResult = const_cast<const ::QGeoRoutingManagerEngine *>(cppSelf)->locale();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoRoutingManagerEngineFunc_managerName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRoutingManagerEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTINGMANAGERENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRoutingManagerEngine.managerName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // managerName()const
            QString cppResult = const_cast<const ::QGeoRoutingManagerEngine *>(cppSelf)->managerName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoRoutingManagerEngineFunc_managerVersion(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRoutingManagerEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTINGMANAGERENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRoutingManagerEngine.managerVersion";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // managerVersion()const
            int cppResult = const_cast<const ::QGeoRoutingManagerEngine *>(cppSelf)->managerVersion();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoRoutingManagerEngineFunc_measurementSystem(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRoutingManagerEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTINGMANAGERENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRoutingManagerEngine.measurementSystem";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // measurementSystem()const
            QLocale::MeasurementSystem cppResult = const_cast<const ::QGeoRoutingManagerEngine *>(cppSelf)->measurementSystem();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_MEASUREMENTSYSTEM_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoRoutingManagerEngineFunc_setLocale(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRoutingManagerEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTINGMANAGERENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRoutingManagerEngine.setLocale";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoRoutingManagerEngine::setLocale(QLocale)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), (pyArg)))) {
        overloadId = 0; // setLocale(QLocale)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoRoutingManagerEngineFunc_setLocale_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QLocale cppArg0_local;
        ::QLocale *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setLocale(QLocale)
            cppSelf->setLocale(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoRoutingManagerEngineFunc_setLocale_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoRoutingManagerEngineFunc_setMeasurementSystem(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRoutingManagerEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTINGMANAGERENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRoutingManagerEngine.setMeasurementSystem";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoRoutingManagerEngine::setMeasurementSystem(QLocale::MeasurementSystem)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QLOCALE_MEASUREMENTSYSTEM_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setMeasurementSystem(QLocale::MeasurementSystem)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoRoutingManagerEngineFunc_setMeasurementSystem_TypeError;

    // Call function/method
    {
        ::QLocale::MeasurementSystem cppArg0{QLocale::MetricSystem};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMeasurementSystem(QLocale::MeasurementSystem)
            cppSelf->setMeasurementSystem(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoRoutingManagerEngineFunc_setMeasurementSystem_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoRoutingManagerEngineFunc_setSupportedFeatureTypes(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRoutingManagerEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTINGMANAGERENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRoutingManagerEngine.setSupportedFeatureTypes";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoRoutingManagerEngine::setSupportedFeatureTypes(QFlags<QGeoRouteRequest::FeatureType>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_FEATURETYPE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setSupportedFeatureTypes(QFlags<QGeoRouteRequest::FeatureType>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoRoutingManagerEngineFunc_setSupportedFeatureTypes_TypeError;

    // Call function/method
    {
        ::QFlags<QGeoRouteRequest::FeatureType> cppArg0 = QFlags<QGeoRouteRequest::FeatureType>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSupportedFeatureTypes(QFlags<QGeoRouteRequest::FeatureType>)
            cppSelf->setSupportedFeatureTypes(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoRoutingManagerEngineFunc_setSupportedFeatureTypes_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoRoutingManagerEngineFunc_setSupportedFeatureWeights(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRoutingManagerEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTINGMANAGERENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRoutingManagerEngine.setSupportedFeatureWeights";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoRoutingManagerEngine::setSupportedFeatureWeights(QFlags<QGeoRouteRequest::FeatureWeight>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_FEATUREWEIGHT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setSupportedFeatureWeights(QFlags<QGeoRouteRequest::FeatureWeight>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoRoutingManagerEngineFunc_setSupportedFeatureWeights_TypeError;

    // Call function/method
    {
        ::QFlags<QGeoRouteRequest::FeatureWeight> cppArg0 = QFlags<QGeoRouteRequest::FeatureWeight>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSupportedFeatureWeights(QFlags<QGeoRouteRequest::FeatureWeight>)
            cppSelf->setSupportedFeatureWeights(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoRoutingManagerEngineFunc_setSupportedFeatureWeights_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoRoutingManagerEngineFunc_setSupportedManeuverDetails(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRoutingManagerEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTINGMANAGERENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRoutingManagerEngine.setSupportedManeuverDetails";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoRoutingManagerEngine::setSupportedManeuverDetails(QFlags<QGeoRouteRequest::ManeuverDetail>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_MANEUVERDETAIL_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setSupportedManeuverDetails(QFlags<QGeoRouteRequest::ManeuverDetail>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoRoutingManagerEngineFunc_setSupportedManeuverDetails_TypeError;

    // Call function/method
    {
        ::QFlags<QGeoRouteRequest::ManeuverDetail> cppArg0 = QFlags<QGeoRouteRequest::ManeuverDetail>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSupportedManeuverDetails(QFlags<QGeoRouteRequest::ManeuverDetail>)
            cppSelf->setSupportedManeuverDetails(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoRoutingManagerEngineFunc_setSupportedManeuverDetails_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoRoutingManagerEngineFunc_setSupportedRouteOptimizations(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRoutingManagerEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTINGMANAGERENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRoutingManagerEngine.setSupportedRouteOptimizations";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoRoutingManagerEngine::setSupportedRouteOptimizations(QFlags<QGeoRouteRequest::RouteOptimization>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_ROUTEOPTIMIZATION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setSupportedRouteOptimizations(QFlags<QGeoRouteRequest::RouteOptimization>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoRoutingManagerEngineFunc_setSupportedRouteOptimizations_TypeError;

    // Call function/method
    {
        ::QFlags<QGeoRouteRequest::RouteOptimization> cppArg0 = QFlags<QGeoRouteRequest::RouteOptimization>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSupportedRouteOptimizations(QFlags<QGeoRouteRequest::RouteOptimization>)
            cppSelf->setSupportedRouteOptimizations(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoRoutingManagerEngineFunc_setSupportedRouteOptimizations_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoRoutingManagerEngineFunc_setSupportedSegmentDetails(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRoutingManagerEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTINGMANAGERENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRoutingManagerEngine.setSupportedSegmentDetails";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoRoutingManagerEngine::setSupportedSegmentDetails(QFlags<QGeoRouteRequest::SegmentDetail>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_SEGMENTDETAIL_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setSupportedSegmentDetails(QFlags<QGeoRouteRequest::SegmentDetail>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoRoutingManagerEngineFunc_setSupportedSegmentDetails_TypeError;

    // Call function/method
    {
        ::QFlags<QGeoRouteRequest::SegmentDetail> cppArg0 = QFlags<QGeoRouteRequest::SegmentDetail>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSupportedSegmentDetails(QFlags<QGeoRouteRequest::SegmentDetail>)
            cppSelf->setSupportedSegmentDetails(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoRoutingManagerEngineFunc_setSupportedSegmentDetails_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoRoutingManagerEngineFunc_setSupportedTravelModes(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRoutingManagerEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTINGMANAGERENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRoutingManagerEngine.setSupportedTravelModes";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoRoutingManagerEngine::setSupportedTravelModes(QFlags<QGeoRouteRequest::TravelMode>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_TRAVELMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setSupportedTravelModes(QFlags<QGeoRouteRequest::TravelMode>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoRoutingManagerEngineFunc_setSupportedTravelModes_TypeError;

    // Call function/method
    {
        ::QFlags<QGeoRouteRequest::TravelMode> cppArg0 = QFlags<QGeoRouteRequest::TravelMode>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSupportedTravelModes(QFlags<QGeoRouteRequest::TravelMode>)
            cppSelf->setSupportedTravelModes(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoRoutingManagerEngineFunc_setSupportedTravelModes_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoRoutingManagerEngineFunc_supportedFeatureTypes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRoutingManagerEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTINGMANAGERENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRoutingManagerEngine.supportedFeatureTypes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedFeatureTypes()const
            QFlags<QGeoRouteRequest::FeatureType> cppResult = const_cast<const ::QGeoRoutingManagerEngine *>(cppSelf)->supportedFeatureTypes();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_FEATURETYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoRoutingManagerEngineFunc_supportedFeatureWeights(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRoutingManagerEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTINGMANAGERENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRoutingManagerEngine.supportedFeatureWeights";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedFeatureWeights()const
            QFlags<QGeoRouteRequest::FeatureWeight> cppResult = const_cast<const ::QGeoRoutingManagerEngine *>(cppSelf)->supportedFeatureWeights();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_FEATUREWEIGHT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoRoutingManagerEngineFunc_supportedManeuverDetails(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRoutingManagerEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTINGMANAGERENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRoutingManagerEngine.supportedManeuverDetails";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedManeuverDetails()const
            QFlags<QGeoRouteRequest::ManeuverDetail> cppResult = const_cast<const ::QGeoRoutingManagerEngine *>(cppSelf)->supportedManeuverDetails();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_MANEUVERDETAIL_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoRoutingManagerEngineFunc_supportedRouteOptimizations(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRoutingManagerEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTINGMANAGERENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRoutingManagerEngine.supportedRouteOptimizations";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedRouteOptimizations()const
            QFlags<QGeoRouteRequest::RouteOptimization> cppResult = const_cast<const ::QGeoRoutingManagerEngine *>(cppSelf)->supportedRouteOptimizations();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_ROUTEOPTIMIZATION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoRoutingManagerEngineFunc_supportedSegmentDetails(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRoutingManagerEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTINGMANAGERENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRoutingManagerEngine.supportedSegmentDetails";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedSegmentDetails()const
            QFlags<QGeoRouteRequest::SegmentDetail> cppResult = const_cast<const ::QGeoRoutingManagerEngine *>(cppSelf)->supportedSegmentDetails();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_SEGMENTDETAIL_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoRoutingManagerEngineFunc_supportedTravelModes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRoutingManagerEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTINGMANAGERENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRoutingManagerEngine.supportedTravelModes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedTravelModes()const
            QFlags<QGeoRouteRequest::TravelMode> cppResult = const_cast<const ::QGeoRoutingManagerEngine *>(cppSelf)->supportedTravelModes();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QFLAGS_QGEOROUTEREQUEST_TRAVELMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoRoutingManagerEngineFunc_updateRoute(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRoutingManagerEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTINGMANAGERENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRoutingManagerEngine.updateRoute";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "updateRoute", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGeoRoutingManagerEngine::updateRoute(QGeoRoute,QGeoCoordinate)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QGEOROUTE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), (pyArgs[1])))) {
        overloadId = 0; // updateRoute(QGeoRoute,QGeoCoordinate)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoRoutingManagerEngineFunc_updateRoute_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QGeoRoute cppArg0_local;
        ::QGeoRoute *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QGEOROUTE_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QGeoCoordinate cppArg1_local;
        ::QGeoCoordinate *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtPositioningTypes[SBK_QGEOCOORDINATE_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // updateRoute(QGeoRoute,QGeoCoordinate)
            QGeoRouteReply * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QGeoRoutingManagerEngine::updateRoute(*cppArg0, *cppArg1)
                : cppSelf->updateRoute(*cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREPLY_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGeoRoutingManagerEngineFunc_updateRoute_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QGeoRoutingManagerEngine_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QGeoRoutingManagerEngine_methods[] = {
    {"calculateRoute", reinterpret_cast<PyCFunction>(Sbk_QGeoRoutingManagerEngineFunc_calculateRoute), METH_O},
    {"locale", reinterpret_cast<PyCFunction>(Sbk_QGeoRoutingManagerEngineFunc_locale), METH_NOARGS},
    {"managerName", reinterpret_cast<PyCFunction>(Sbk_QGeoRoutingManagerEngineFunc_managerName), METH_NOARGS},
    {"managerVersion", reinterpret_cast<PyCFunction>(Sbk_QGeoRoutingManagerEngineFunc_managerVersion), METH_NOARGS},
    {"measurementSystem", reinterpret_cast<PyCFunction>(Sbk_QGeoRoutingManagerEngineFunc_measurementSystem), METH_NOARGS},
    {"setLocale", reinterpret_cast<PyCFunction>(Sbk_QGeoRoutingManagerEngineFunc_setLocale), METH_O},
    {"setMeasurementSystem", reinterpret_cast<PyCFunction>(Sbk_QGeoRoutingManagerEngineFunc_setMeasurementSystem), METH_O},
    {"setSupportedFeatureTypes", reinterpret_cast<PyCFunction>(Sbk_QGeoRoutingManagerEngineFunc_setSupportedFeatureTypes), METH_O},
    {"setSupportedFeatureWeights", reinterpret_cast<PyCFunction>(Sbk_QGeoRoutingManagerEngineFunc_setSupportedFeatureWeights), METH_O},
    {"setSupportedManeuverDetails", reinterpret_cast<PyCFunction>(Sbk_QGeoRoutingManagerEngineFunc_setSupportedManeuverDetails), METH_O},
    {"setSupportedRouteOptimizations", reinterpret_cast<PyCFunction>(Sbk_QGeoRoutingManagerEngineFunc_setSupportedRouteOptimizations), METH_O},
    {"setSupportedSegmentDetails", reinterpret_cast<PyCFunction>(Sbk_QGeoRoutingManagerEngineFunc_setSupportedSegmentDetails), METH_O},
    {"setSupportedTravelModes", reinterpret_cast<PyCFunction>(Sbk_QGeoRoutingManagerEngineFunc_setSupportedTravelModes), METH_O},
    {"supportedFeatureTypes", reinterpret_cast<PyCFunction>(Sbk_QGeoRoutingManagerEngineFunc_supportedFeatureTypes), METH_NOARGS},
    {"supportedFeatureWeights", reinterpret_cast<PyCFunction>(Sbk_QGeoRoutingManagerEngineFunc_supportedFeatureWeights), METH_NOARGS},
    {"supportedManeuverDetails", reinterpret_cast<PyCFunction>(Sbk_QGeoRoutingManagerEngineFunc_supportedManeuverDetails), METH_NOARGS},
    {"supportedRouteOptimizations", reinterpret_cast<PyCFunction>(Sbk_QGeoRoutingManagerEngineFunc_supportedRouteOptimizations), METH_NOARGS},
    {"supportedSegmentDetails", reinterpret_cast<PyCFunction>(Sbk_QGeoRoutingManagerEngineFunc_supportedSegmentDetails), METH_NOARGS},
    {"supportedTravelModes", reinterpret_cast<PyCFunction>(Sbk_QGeoRoutingManagerEngineFunc_supportedTravelModes), METH_NOARGS},
    {"updateRoute", reinterpret_cast<PyCFunction>(Sbk_QGeoRoutingManagerEngineFunc_updateRoute), METH_VARARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QGeoRoutingManagerEngine_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QGeoRoutingManagerEngine *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTINGMANAGERENGINE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QGeoRoutingManagerEngineWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QGeoRoutingManagerEngine_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QGeoRoutingManagerEngine_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QGeoRoutingManagerEngine_Type = nullptr;
static SbkObjectType *Sbk_QGeoRoutingManagerEngine_TypeF(void)
{
    return _Sbk_QGeoRoutingManagerEngine_Type;
}

static PyType_Slot Sbk_QGeoRoutingManagerEngine_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QGeoRoutingManagerEngine_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QGeoRoutingManagerEngine_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QGeoRoutingManagerEngine_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QGeoRoutingManagerEngine_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QGeoRoutingManagerEngine_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QGeoRoutingManagerEngine_spec = {
    "2:PySide2.QtLocation.QGeoRoutingManagerEngine",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QGeoRoutingManagerEngine_slots
};

} //extern "C"

static void *Sbk_QGeoRoutingManagerEngine_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QGeoRoutingManagerEngine *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QGeoRoutingManagerEngine_PythonToCpp_QGeoRoutingManagerEngine_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QGeoRoutingManagerEngine_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QGeoRoutingManagerEngine_PythonToCpp_QGeoRoutingManagerEngine_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGeoRoutingManagerEngine_TypeF())))
        return QGeoRoutingManagerEngine_PythonToCpp_QGeoRoutingManagerEngine_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QGeoRoutingManagerEngine_PTR_CppToPython_QGeoRoutingManagerEngine(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QGeoRoutingManagerEngine *>(const_cast<void *>(cppIn)), Sbk_QGeoRoutingManagerEngine_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QGeoRoutingManagerEngine_SignatureStrings[] = {
    "PySide2.QtLocation.QGeoRoutingManagerEngine(self,parameters:QMap[QString, QVariant],parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtLocation.QGeoRoutingManagerEngine.calculateRoute(self,request:PySide2.QtLocation.QGeoRouteRequest)->PySide2.QtLocation.QGeoRouteReply",
    "PySide2.QtLocation.QGeoRoutingManagerEngine.locale(self)->PySide2.QtCore.QLocale",
    "PySide2.QtLocation.QGeoRoutingManagerEngine.managerName(self)->QString",
    "PySide2.QtLocation.QGeoRoutingManagerEngine.managerVersion(self)->int",
    "PySide2.QtLocation.QGeoRoutingManagerEngine.measurementSystem(self)->PySide2.QtCore.QLocale.MeasurementSystem",
    "PySide2.QtLocation.QGeoRoutingManagerEngine.setLocale(self,locale:PySide2.QtCore.QLocale)",
    "PySide2.QtLocation.QGeoRoutingManagerEngine.setMeasurementSystem(self,system:PySide2.QtCore.QLocale.MeasurementSystem)",
    "PySide2.QtLocation.QGeoRoutingManagerEngine.setSupportedFeatureTypes(self,featureTypes:PySide2.QtLocation.QGeoRouteRequest.FeatureTypes)",
    "PySide2.QtLocation.QGeoRoutingManagerEngine.setSupportedFeatureWeights(self,featureWeights:PySide2.QtLocation.QGeoRouteRequest.FeatureWeights)",
    "PySide2.QtLocation.QGeoRoutingManagerEngine.setSupportedManeuverDetails(self,maneuverDetails:PySide2.QtLocation.QGeoRouteRequest.ManeuverDetails)",
    "PySide2.QtLocation.QGeoRoutingManagerEngine.setSupportedRouteOptimizations(self,optimizations:PySide2.QtLocation.QGeoRouteRequest.RouteOptimizations)",
    "PySide2.QtLocation.QGeoRoutingManagerEngine.setSupportedSegmentDetails(self,segmentDetails:PySide2.QtLocation.QGeoRouteRequest.SegmentDetails)",
    "PySide2.QtLocation.QGeoRoutingManagerEngine.setSupportedTravelModes(self,travelModes:PySide2.QtLocation.QGeoRouteRequest.TravelModes)",
    "PySide2.QtLocation.QGeoRoutingManagerEngine.supportedFeatureTypes(self)->PySide2.QtLocation.QGeoRouteRequest.FeatureTypes",
    "PySide2.QtLocation.QGeoRoutingManagerEngine.supportedFeatureWeights(self)->PySide2.QtLocation.QGeoRouteRequest.FeatureWeights",
    "PySide2.QtLocation.QGeoRoutingManagerEngine.supportedManeuverDetails(self)->PySide2.QtLocation.QGeoRouteRequest.ManeuverDetails",
    "PySide2.QtLocation.QGeoRoutingManagerEngine.supportedRouteOptimizations(self)->PySide2.QtLocation.QGeoRouteRequest.RouteOptimizations",
    "PySide2.QtLocation.QGeoRoutingManagerEngine.supportedSegmentDetails(self)->PySide2.QtLocation.QGeoRouteRequest.SegmentDetails",
    "PySide2.QtLocation.QGeoRoutingManagerEngine.supportedTravelModes(self)->PySide2.QtLocation.QGeoRouteRequest.TravelModes",
    "PySide2.QtLocation.QGeoRoutingManagerEngine.updateRoute(self,route:PySide2.QtLocation.QGeoRoute,position:PySide2.QtPositioning.QGeoCoordinate)->PySide2.QtLocation.QGeoRouteReply",
    nullptr}; // Sentinel

void init_QGeoRoutingManagerEngine(PyObject *module)
{
    _Sbk_QGeoRoutingManagerEngine_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QGeoRoutingManagerEngine",
        "QGeoRoutingManagerEngine*",
        &Sbk_QGeoRoutingManagerEngine_spec,
        &Shiboken::callCppDestructor< ::QGeoRoutingManagerEngine >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QGeoRoutingManagerEngine_Type);
    InitSignatureStrings(pyType, QGeoRoutingManagerEngine_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QGeoRoutingManagerEngine_Type), Sbk_QGeoRoutingManagerEngine_PropertyStrings);
    SbkPySide2_QtLocationTypes[SBK_QGEOROUTINGMANAGERENGINE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QGeoRoutingManagerEngine_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QGeoRoutingManagerEngine_TypeF(),
        QGeoRoutingManagerEngine_PythonToCpp_QGeoRoutingManagerEngine_PTR,
        is_QGeoRoutingManagerEngine_PythonToCpp_QGeoRoutingManagerEngine_PTR_Convertible,
        QGeoRoutingManagerEngine_PTR_CppToPython_QGeoRoutingManagerEngine);

    Shiboken::Conversions::registerConverterName(converter, "QGeoRoutingManagerEngine");
    Shiboken::Conversions::registerConverterName(converter, "QGeoRoutingManagerEngine*");
    Shiboken::Conversions::registerConverterName(converter, "QGeoRoutingManagerEngine&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGeoRoutingManagerEngine).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGeoRoutingManagerEngineWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QGeoRoutingManagerEngine_TypeF(), &Sbk_QGeoRoutingManagerEngine_typeDiscovery);

    PySide::Signal::registerSignals(Sbk_QGeoRoutingManagerEngine_TypeF(), &::QGeoRoutingManagerEngine::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QGeoRoutingManagerEngine_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QGeoRoutingManagerEngine_TypeF(), &::QGeoRoutingManagerEngine::staticMetaObject, sizeof(QGeoRoutingManagerEngineWrapper));
}
