/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtlocation_python.h"

// main header
#include "qgeoroutereply_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QGeoRouteReplyWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QGeoRouteReplyWrapper::QGeoRouteReplyWrapper(::QGeoRouteReply::Error error, const ::QString & errorString, ::QObject * parent) : QGeoRouteReply(error, errorString, parent)
{
    resetPyMethodCache();
    // ... middle
}

QGeoRouteReplyWrapper::QGeoRouteReplyWrapper(const ::QGeoRouteRequest & request, ::QObject * parent) : QGeoRouteReply(request, parent)
{
    resetPyMethodCache();
    // ... middle
}

void QGeoRouteReplyWrapper::abort()
{
    if (m_PyMethodCache[0]) {
        return this->::QGeoRouteReply::abort();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "abort";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QGeoRouteReply::abort();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QGeoRouteReplyWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGeoRouteReplyWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QGeoRouteReplyWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGeoRouteReplyWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[4]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QGeoRouteReplyWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGeoRouteReply.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QGeoRouteReplyWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[6])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGeoRouteReply.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QGeoRouteReplyWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[8]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QGeoRouteReplyWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QGeoRouteReply::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QGeoRouteReplyWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QGeoRouteReply::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QGeoRouteReplyWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QGeoRouteReplyWrapper *>(this));
        return QGeoRouteReply::qt_metacast(_clname);
}

QGeoRouteReplyWrapper::~QGeoRouteReplyWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QGeoRouteReply_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QGeoRouteReply >()))
        return -1;

    ::QGeoRouteReplyWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRouteReply.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QGeoRouteReply_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:QGeoRouteReply", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return -1;


    // Overloaded function decisor
    // 0: QGeoRouteReply::QGeoRouteReply(QGeoRouteReply::Error,QString,QObject*)
    // 1: QGeoRouteReply::QGeoRouteReply(QGeoRouteRequest,QObject*)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // QGeoRouteReply(QGeoRouteRequest,QObject*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1])))) {
            overloadId = 1; // QGeoRouteReply(QGeoRouteRequest,QObject*)
        }
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREPLY_ERROR_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // QGeoRouteReply(QGeoRouteReply::Error,QString,QObject*)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[2])))) {
            overloadId = 0; // QGeoRouteReply(QGeoRouteReply::Error,QString,QObject*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoRouteReply_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QGeoRouteReply(QGeoRouteReply::Error error, const QString & errorString, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[2]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QGeoRouteReply_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[2]))))
                            goto Sbk_QGeoRouteReply_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            ::QGeoRouteReply::Error cppArg0{QGeoRouteReply::NoError};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QObject *cppArg2 = nullptr;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QGeoRouteReply(QGeoRouteReply::Error,QString,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QGeoRouteReplyWrapper(cppArg0, cppArg1, cppArg2);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QGeoRouteReplyWrapper(cppArg0, cppArg1, cppArg2);
                }

                Shiboken::Object::setParent(pyArgs[2], self);
            }
            break;
        }
        case 1: // QGeoRouteReply(const QGeoRouteRequest & request, QObject * parent)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[1]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QGeoRouteReply_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[1]))))
                            goto Sbk_QGeoRouteReply_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QGeoRouteRequest *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QObject *cppArg1 = nullptr;
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QGeoRouteReply(QGeoRouteRequest,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QGeoRouteReplyWrapper(*cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QGeoRouteReplyWrapper(*cppArg0, cppArg1);
                }

                Shiboken::Object::setParent(pyArgs[1], self);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QGeoRouteReply >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QGeoRouteReply_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QGeoRouteReply_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QGeoRouteReply_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QGeoRouteReplyFunc_abort(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRouteReply *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREPLY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRouteReply.abort";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // abort()
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QGeoRouteReply::abort()
                : cppSelf->abort();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QGeoRouteReplyFunc_addRoutes(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRouteReply *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREPLY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRouteReply.addRoutes";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoRouteReply::addRoutes(QList<QGeoRoute>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QGEOROUTE_IDX], (pyArg)))) {
        overloadId = 0; // addRoutes(QList<QGeoRoute>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoRouteReplyFunc_addRoutes_TypeError;

    // Call function/method
    {
        ::QList<QGeoRoute > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // addRoutes(QList<QGeoRoute>)
            cppSelf->addRoutes(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoRouteReplyFunc_addRoutes_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoRouteReplyFunc_error(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRouteReply *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREPLY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRouteReply.error";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // error()const
            QGeoRouteReply::Error cppResult = const_cast<const ::QGeoRouteReply *>(cppSelf)->error();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREPLY_ERROR_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoRouteReplyFunc_errorString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRouteReply *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREPLY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRouteReply.errorString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // errorString()const
            QString cppResult = const_cast<const ::QGeoRouteReply *>(cppSelf)->errorString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoRouteReplyFunc_isFinished(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRouteReply *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREPLY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRouteReply.isFinished";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isFinished()const
            bool cppResult = const_cast<const ::QGeoRouteReply *>(cppSelf)->isFinished();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoRouteReplyFunc_request(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRouteReply *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREPLY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRouteReply.request";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // request()const
            QGeoRouteRequest* cppResult = new QGeoRouteRequest(const_cast<const ::QGeoRouteReply *>(cppSelf)->request());
            pyResult = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREQUEST_IDX]), cppResult, true, true);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoRouteReplyFunc_routes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRouteReply *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREPLY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRouteReply.routes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // routes()const
            QList<QGeoRoute > cppResult = const_cast<const ::QGeoRouteReply *>(cppSelf)->routes();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QGEOROUTE_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGeoRouteReplyFunc_setError(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRouteReply *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREPLY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRouteReply.setError";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setError", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGeoRouteReply::setError(QGeoRouteReply::Error,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREPLY_ERROR_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // setError(QGeoRouteReply::Error,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoRouteReplyFunc_setError_TypeError;

    // Call function/method
    {
        ::QGeoRouteReply::Error cppArg0{QGeoRouteReply::NoError};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setError(QGeoRouteReply::Error,QString)
            cppSelf->setError(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoRouteReplyFunc_setError_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoRouteReplyFunc_setFinished(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRouteReply *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREPLY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRouteReply.setFinished";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoRouteReply::setFinished(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setFinished(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoRouteReplyFunc_setFinished_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFinished(bool)
            cppSelf->setFinished(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoRouteReplyFunc_setFinished_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGeoRouteReplyFunc_setRoutes(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGeoRouteReply *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREPLY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtLocation.QGeoRouteReply.setRoutes";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGeoRouteReply::setRoutes(QList<QGeoRoute>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtLocationTypeConverters[SBK_QTLOCATION_QLIST_QGEOROUTE_IDX], (pyArg)))) {
        overloadId = 0; // setRoutes(QList<QGeoRoute>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGeoRouteReplyFunc_setRoutes_TypeError;

    // Call function/method
    {
        ::QList<QGeoRoute > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRoutes(QList<QGeoRoute>)
            cppSelf->setRoutes(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGeoRouteReplyFunc_setRoutes_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QGeoRouteReply_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QGeoRouteReply_methods[] = {
    {"abort", reinterpret_cast<PyCFunction>(Sbk_QGeoRouteReplyFunc_abort), METH_NOARGS},
    {"addRoutes", reinterpret_cast<PyCFunction>(Sbk_QGeoRouteReplyFunc_addRoutes), METH_O},
    {"error", reinterpret_cast<PyCFunction>(Sbk_QGeoRouteReplyFunc_error), METH_NOARGS},
    {"errorString", reinterpret_cast<PyCFunction>(Sbk_QGeoRouteReplyFunc_errorString), METH_NOARGS},
    {"isFinished", reinterpret_cast<PyCFunction>(Sbk_QGeoRouteReplyFunc_isFinished), METH_NOARGS},
    {"request", reinterpret_cast<PyCFunction>(Sbk_QGeoRouteReplyFunc_request), METH_NOARGS},
    {"routes", reinterpret_cast<PyCFunction>(Sbk_QGeoRouteReplyFunc_routes), METH_NOARGS},
    {"setError", reinterpret_cast<PyCFunction>(Sbk_QGeoRouteReplyFunc_setError), METH_VARARGS},
    {"setFinished", reinterpret_cast<PyCFunction>(Sbk_QGeoRouteReplyFunc_setFinished), METH_O},
    {"setRoutes", reinterpret_cast<PyCFunction>(Sbk_QGeoRouteReplyFunc_setRoutes), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QGeoRouteReply_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QGeoRouteReply *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREPLY_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QGeoRouteReplyWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QGeoRouteReply_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QGeoRouteReply_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QGeoRouteReply_Type = nullptr;
static SbkObjectType *Sbk_QGeoRouteReply_TypeF(void)
{
    return _Sbk_QGeoRouteReply_Type;
}

static PyType_Slot Sbk_QGeoRouteReply_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QGeoRouteReply_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QGeoRouteReply_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QGeoRouteReply_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QGeoRouteReply_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QGeoRouteReply_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QGeoRouteReply_spec = {
    "2:PySide2.QtLocation.QGeoRouteReply",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QGeoRouteReply_slots
};

} //extern "C"

static void *Sbk_QGeoRouteReply_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QGeoRouteReply *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QGeoRouteReply_Error_PythonToCpp_QGeoRouteReply_Error(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QGeoRouteReply::Error *>(cppOut) =
        static_cast<::QGeoRouteReply::Error>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QGeoRouteReply_Error_PythonToCpp_QGeoRouteReply_Error_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREPLY_ERROR_IDX]))
        return QGeoRouteReply_Error_PythonToCpp_QGeoRouteReply_Error;
    return {};
}
static PyObject *QGeoRouteReply_Error_CppToPython_QGeoRouteReply_Error(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QGeoRouteReply::Error *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREPLY_ERROR_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QGeoRouteReply_PythonToCpp_QGeoRouteReply_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QGeoRouteReply_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QGeoRouteReply_PythonToCpp_QGeoRouteReply_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGeoRouteReply_TypeF())))
        return QGeoRouteReply_PythonToCpp_QGeoRouteReply_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QGeoRouteReply_PTR_CppToPython_QGeoRouteReply(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QGeoRouteReply *>(const_cast<void *>(cppIn)), Sbk_QGeoRouteReply_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QGeoRouteReply_SignatureStrings[] = {
    "1:PySide2.QtLocation.QGeoRouteReply(self,error:PySide2.QtLocation.QGeoRouteReply.Error,errorString:QString,parent:PySide2.QtCore.QObject=nullptr)",
    "0:PySide2.QtLocation.QGeoRouteReply(self,request:PySide2.QtLocation.QGeoRouteRequest,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtLocation.QGeoRouteReply.abort(self)",
    "PySide2.QtLocation.QGeoRouteReply.addRoutes(self,routes:QList[PySide2.QtLocation.QGeoRoute])",
    "PySide2.QtLocation.QGeoRouteReply.error(self)->PySide2.QtLocation.QGeoRouteReply.Error",
    "PySide2.QtLocation.QGeoRouteReply.errorString(self)->QString",
    "PySide2.QtLocation.QGeoRouteReply.isFinished(self)->bool",
    "PySide2.QtLocation.QGeoRouteReply.request(self)->PySide2.QtLocation.QGeoRouteRequest",
    "PySide2.QtLocation.QGeoRouteReply.routes(self)->QList[PySide2.QtLocation.QGeoRoute]",
    "PySide2.QtLocation.QGeoRouteReply.setError(self,error:PySide2.QtLocation.QGeoRouteReply.Error,errorString:QString)",
    "PySide2.QtLocation.QGeoRouteReply.setFinished(self,finished:bool)",
    "PySide2.QtLocation.QGeoRouteReply.setRoutes(self,routes:QList[PySide2.QtLocation.QGeoRoute])",
    nullptr}; // Sentinel

void init_QGeoRouteReply(PyObject *module)
{
    _Sbk_QGeoRouteReply_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QGeoRouteReply",
        "QGeoRouteReply*",
        &Sbk_QGeoRouteReply_spec,
        &Shiboken::callCppDestructor< ::QGeoRouteReply >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QGeoRouteReply_Type);
    InitSignatureStrings(pyType, QGeoRouteReply_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QGeoRouteReply_Type), Sbk_QGeoRouteReply_PropertyStrings);
    SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREPLY_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QGeoRouteReply_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QGeoRouteReply_TypeF(),
        QGeoRouteReply_PythonToCpp_QGeoRouteReply_PTR,
        is_QGeoRouteReply_PythonToCpp_QGeoRouteReply_PTR_Convertible,
        QGeoRouteReply_PTR_CppToPython_QGeoRouteReply);

    Shiboken::Conversions::registerConverterName(converter, "QGeoRouteReply");
    Shiboken::Conversions::registerConverterName(converter, "QGeoRouteReply*");
    Shiboken::Conversions::registerConverterName(converter, "QGeoRouteReply&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGeoRouteReply).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGeoRouteReplyWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QGeoRouteReply_TypeF(), &Sbk_QGeoRouteReply_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'Error'.
    SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREPLY_ERROR_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QGeoRouteReply_TypeF(),
        "Error",
        "2:PySide2.QtLocation.QGeoRouteReply.Error",
        "QGeoRouteReply::Error");
    if (!SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREPLY_ERROR_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREPLY_ERROR_IDX],
        Sbk_QGeoRouteReply_TypeF(), "NoError", (long) QGeoRouteReply::Error::NoError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREPLY_ERROR_IDX],
        Sbk_QGeoRouteReply_TypeF(), "EngineNotSetError", (long) QGeoRouteReply::Error::EngineNotSetError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREPLY_ERROR_IDX],
        Sbk_QGeoRouteReply_TypeF(), "CommunicationError", (long) QGeoRouteReply::Error::CommunicationError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREPLY_ERROR_IDX],
        Sbk_QGeoRouteReply_TypeF(), "ParseError", (long) QGeoRouteReply::Error::ParseError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREPLY_ERROR_IDX],
        Sbk_QGeoRouteReply_TypeF(), "UnsupportedOptionError", (long) QGeoRouteReply::Error::UnsupportedOptionError))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREPLY_ERROR_IDX],
        Sbk_QGeoRouteReply_TypeF(), "UnknownError", (long) QGeoRouteReply::Error::UnknownError))
        return;
    // Register converter for enum 'QGeoRouteReply::Error'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREPLY_ERROR_IDX],
            QGeoRouteReply_Error_CppToPython_QGeoRouteReply_Error);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QGeoRouteReply_Error_PythonToCpp_QGeoRouteReply_Error,
            is_QGeoRouteReply_Error_PythonToCpp_QGeoRouteReply_Error_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtLocationTypes[SBK_QGEOROUTEREPLY_ERROR_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QGeoRouteReply::Error");
        Shiboken::Conversions::registerConverterName(converter, "Error");
    }
    // End of 'Error' enum.

    PySide::Signal::registerSignals(Sbk_QGeoRouteReply_TypeF(), &::QGeoRouteReply::staticMetaObject);
    qRegisterMetaType< ::QGeoRouteReply::Error >("QGeoRouteReply::Error");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QGeoRouteReply_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QGeoRouteReply_TypeF(), &::QGeoRouteReply::staticMetaObject, sizeof(QGeoRouteReplyWrapper));
}
