/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qthelp_python.h"

// main header
#include "qhelpindexmodel_wrapper.h"

// inner classes

// Extra includes
#include <QMap>
#include <QtHelp/qhelpenginecore.h>
#include <pysideqflags.h>
#include <qabstractitemmodel.h>
#include <qbytearray.h>
#include <qcoreevent.h>
#include <qmetaobject.h>
#include <qmimedata.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qsize.h>
#include <qurl.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static PyObject *Sbk_QHelpIndexModelFunc_createIndex(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHelpIndexModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtHelpTypes[SBK_QHELPINDEXMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtHelp.QHelpIndexModel.createIndex";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QHelpIndexModelFunc_createIndex_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QHelpIndexModelFunc_createIndex_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:createIndex", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QHelpIndexModel::createIndex(QString)
    // 1: QAbstractItemModel::createIndex(int,int,quintptr)const
    // 2: QAbstractItemModel::createIndex(int,int,PyObject*)const
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 1; // createIndex(int,int,quintptr)const
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QUINTPTR_IDX], (pyArgs[2])))) {
            overloadId = 1; // createIndex(int,int,quintptr)const
        } else if (numArgs == 3
            && PyObject_Check(pyArgs[2])) {
            overloadId = 2; // createIndex(int,int,PyObject*)const
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 0; // createIndex(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QHelpIndexModelFunc_createIndex_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // createIndex(const QString & customFilterName)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QHelpIndexModelFunc_createIndex_TypeError;
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // createIndex(QString)
                cppSelf->createIndex(cppArg0);
                pyResult = Py_None;
                Py_INCREF(Py_None);
            }
            break;
        }
        case 1: // createIndex(int row, int column, quintptr id) const
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_id = Shiboken::String::createStaticString("id");
                if (PyDict_Contains(kwds, key_id)) {
                    value = PyDict_GetItem(kwds, key_id);
                    if (value && pyArgs[2]) {
                        errInfo = key_id;
                        Py_INCREF(errInfo);
                        goto Sbk_QHelpIndexModelFunc_createIndex_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QUINTPTR_IDX], (pyArgs[2]))))
                            goto Sbk_QHelpIndexModelFunc_createIndex_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_id);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QHelpIndexModelFunc_createIndex_TypeError;
                }
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::quintptr cppArg2 = 0;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // createIndex(int,int,quintptr)const
                QModelIndex cppResult = const_cast<const ::QAbstractListModel *>(reinterpret_cast<QAbstractListModel *>(cppSelf))->createIndex(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &cppResult);
            }
            break;
        }
        case 2: // createIndex(int row, int column, PyObject * ptr) const
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QHelpIndexModelFunc_createIndex_TypeError;
            }
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            SBK_UNUSED(cppArg0)
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            SBK_UNUSED(cppArg1)

            if (!PyErr_Occurred()) {
                // createIndex(int,int,PyObject*)const
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QHelpIndexModelFunc_createIndex_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QHelpIndexModelFunc_filter(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHelpIndexModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtHelpTypes[SBK_QHELPINDEXMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtHelp.QHelpIndexModel.filter";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QHelpIndexModelFunc_filter_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QHelpIndexModelFunc_filter_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:filter", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QHelpIndexModel::filter(QString,QString)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // filter(QString,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 0; // filter(QString,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QHelpIndexModelFunc_filter_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_wildcard = Shiboken::String::createStaticString("wildcard");
            if (PyDict_Contains(kwds, key_wildcard)) {
                value = PyDict_GetItem(kwds, key_wildcard);
                if (value && pyArgs[1]) {
                    errInfo = key_wildcard;
                    Py_INCREF(errInfo);
                    goto Sbk_QHelpIndexModelFunc_filter_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                        goto Sbk_QHelpIndexModelFunc_filter_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_wildcard);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QHelpIndexModelFunc_filter_TypeError;
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1 = QString();
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // filter(QString,QString)
            QModelIndex cppResult = cppSelf->filter(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QHelpIndexModelFunc_filter_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QHelpIndexModelFunc_helpEngine(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHelpIndexModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtHelpTypes[SBK_QHELPINDEXMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtHelp.QHelpIndexModel.helpEngine";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // helpEngine()const
            QHelpEngineCore * cppResult = const_cast<const ::QHelpIndexModel *>(cppSelf)->helpEngine();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtHelpTypes[SBK_QHELPENGINECORE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QHelpIndexModelFunc_isCreatingIndex(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHelpIndexModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtHelpTypes[SBK_QHELPINDEXMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtHelp.QHelpIndexModel.isCreatingIndex";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isCreatingIndex()const
            bool cppResult = const_cast<const ::QHelpIndexModel *>(cppSelf)->isCreatingIndex();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QHelpIndexModelFunc_linksForKeyword(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QHelpIndexModel *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtHelpTypes[SBK_QHELPINDEXMODEL_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtHelp.QHelpIndexModel.linksForKeyword";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QHelpIndexModel::linksForKeyword(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // linksForKeyword(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QHelpIndexModelFunc_linksForKeyword_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // linksForKeyword(QString)const
            QMap<QString,QUrl > cppResult = const_cast<const ::QHelpIndexModel *>(cppSelf)->linksForKeyword(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtHelpTypeConverters[SBK_QTHELP_QMAP_QSTRING_QURL_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QHelpIndexModelFunc_linksForKeyword_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QHelpIndexModel_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QHelpIndexModel_methods[] = {
    {"createIndex", reinterpret_cast<PyCFunction>(Sbk_QHelpIndexModelFunc_createIndex), METH_VARARGS|METH_KEYWORDS},
    {"filter", reinterpret_cast<PyCFunction>(Sbk_QHelpIndexModelFunc_filter), METH_VARARGS|METH_KEYWORDS},
    {"helpEngine", reinterpret_cast<PyCFunction>(Sbk_QHelpIndexModelFunc_helpEngine), METH_NOARGS},
    {"isCreatingIndex", reinterpret_cast<PyCFunction>(Sbk_QHelpIndexModelFunc_isCreatingIndex), METH_NOARGS},
    {"linksForKeyword", reinterpret_cast<PyCFunction>(Sbk_QHelpIndexModelFunc_linksForKeyword), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QHelpIndexModel_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QHelpIndexModel_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QHelpIndexModel_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QHelpIndexModel_Type = nullptr;
static SbkObjectType *Sbk_QHelpIndexModel_TypeF(void)
{
    return _Sbk_QHelpIndexModel_Type;
}

static PyType_Slot Sbk_QHelpIndexModel_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(SbkDeallocWrapperWithPrivateDtor)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QHelpIndexModel_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QHelpIndexModel_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QHelpIndexModel_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QHelpIndexModel_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QHelpIndexModel_spec = {
    "2:PySide2.QtHelp.QHelpIndexModel",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QHelpIndexModel_slots
};

} //extern "C"

static void *Sbk_QHelpIndexModel_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QHelpIndexModel *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QHelpIndexModel_PythonToCpp_QHelpIndexModel_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QHelpIndexModel_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QHelpIndexModel_PythonToCpp_QHelpIndexModel_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QHelpIndexModel_TypeF())))
        return QHelpIndexModel_PythonToCpp_QHelpIndexModel_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QHelpIndexModel_PTR_CppToPython_QHelpIndexModel(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QHelpIndexModel *>(const_cast<void *>(cppIn)), Sbk_QHelpIndexModel_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QHelpIndexModel_SignatureStrings[] = {
    "2:PySide2.QtHelp.QHelpIndexModel.createIndex(self,customFilterName:QString)",
    "1:PySide2.QtHelp.QHelpIndexModel.createIndex(self,row:int,column:int,id:quintptr=0)->PySide2.QtCore.QModelIndex",
    "0:PySide2.QtHelp.QHelpIndexModel.createIndex(self,row:int,column:int,ptr:PyObject)->PySide2.QtCore.QModelIndex",
    "PySide2.QtHelp.QHelpIndexModel.filter(self,filter:QString,wildcard:QString=QString())->PySide2.QtCore.QModelIndex",
    "PySide2.QtHelp.QHelpIndexModel.helpEngine(self)->PySide2.QtHelp.QHelpEngineCore",
    "PySide2.QtHelp.QHelpIndexModel.isCreatingIndex(self)->bool",
    "PySide2.QtHelp.QHelpIndexModel.linksForKeyword(self,keyword:QString)->QMap[QString, PySide2.QtCore.QUrl]",
    nullptr}; // Sentinel

void init_QHelpIndexModel(PyObject *module)
{
    _Sbk_QHelpIndexModel_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QHelpIndexModel",
        "QHelpIndexModel*",
        &Sbk_QHelpIndexModel_spec,
        0,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSTRINGLISTMODEL_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QHelpIndexModel_Type);
    InitSignatureStrings(pyType, QHelpIndexModel_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QHelpIndexModel_Type), Sbk_QHelpIndexModel_PropertyStrings);
    SbkPySide2_QtHelpTypes[SBK_QHELPINDEXMODEL_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QHelpIndexModel_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QHelpIndexModel_TypeF(),
        QHelpIndexModel_PythonToCpp_QHelpIndexModel_PTR,
        is_QHelpIndexModel_PythonToCpp_QHelpIndexModel_PTR_Convertible,
        QHelpIndexModel_PTR_CppToPython_QHelpIndexModel);

    Shiboken::Conversions::registerConverterName(converter, "QHelpIndexModel");
    Shiboken::Conversions::registerConverterName(converter, "QHelpIndexModel*");
    Shiboken::Conversions::registerConverterName(converter, "QHelpIndexModel&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QHelpIndexModel).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QHelpIndexModel_TypeF(), &Sbk_QHelpIndexModel_typeDiscovery);

    PySide::Signal::registerSignals(Sbk_QHelpIndexModel_TypeF(), &::QHelpIndexModel::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QHelpIndexModel_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QHelpIndexModel_TypeF(), &::QHelpIndexModel::staticMetaObject, sizeof(::QHelpIndexModel));
}
