/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qtextobjectinterface_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QTextObjectInterfaceWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QTextObjectInterfaceWrapper::QTextObjectInterfaceWrapper() : QTextObjectInterface()
{
    resetPyMethodCache();
    // ... middle
}

void QTextObjectInterfaceWrapper::drawObject(::QPainter * painter, const ::QRectF & rect, ::QTextDocument * doc, int posInDocument, const ::QTextFormat & format)
{
    if (m_PyMethodCache[0]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QTextObjectInterface.drawObject()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "drawObject";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QTextObjectInterface.drawObject()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNNiN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), painter),
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &rect),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX]), doc),
    posInDocument,
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX]), &format)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

::QSizeF QTextObjectInterfaceWrapper::intrinsicSize(::QTextDocument * doc, int posInDocument, const ::QTextFormat & format)
{
    if (m_PyMethodCache[1]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QTextObjectInterface.intrinsicSize()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "intrinsicSize";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QTextObjectInterface.intrinsicSize()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NiN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX]), doc),
    posInDocument,
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX]), &format)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QTextObjectInterface.intrinsicSize", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSizeF >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QSizeF cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

QTextObjectInterfaceWrapper::~QTextObjectInterfaceWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QTextObjectInterface_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTOBJECTINTERFACE_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QTextObjectInterface' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QTextObjectInterface >()))
        return -1;

    ::QTextObjectInterfaceWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextObjectInterface.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QTextObjectInterface()
            cptr = new ::QTextObjectInterfaceWrapper();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QTextObjectInterface >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QTextObjectInterfaceFunc_drawObject(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextObjectInterface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTOBJECTINTERFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextObjectInterface.drawObject";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "drawObject", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QTextObjectInterface::drawObject(QPainter*,QRectF,QTextDocument*,int,QTextFormat)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX]), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX]), (pyArgs[4])))) {
        overloadId = 0; // drawObject(QPainter*,QRectF,QTextDocument*,int,QTextFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextObjectInterfaceFunc_drawObject_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QPainter *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QRectF cppArg1_local;
        ::QRectF *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QTextDocument *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        if (!Shiboken::Object::isValid(pyArgs[4]))
            return {};
        ::QTextFormat cppArg4_local;
        ::QTextFormat *cppArg4 = &cppArg4_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX]), pythonToCpp[4]))
            pythonToCpp[4](pyArgs[4], &cppArg4_local);
        else
            pythonToCpp[4](pyArgs[4], &cppArg4);


        if (!PyErr_Occurred()) {
            // drawObject(QPainter*,QRectF,QTextDocument*,int,QTextFormat)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QTextObjectInterface.drawObject()' not implemented.");
                return {};
            }
            cppSelf->drawObject(cppArg0, *cppArg1, cppArg2, cppArg3, *cppArg4);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QTextObjectInterfaceFunc_drawObject_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QTextObjectInterfaceFunc_intrinsicSize(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextObjectInterface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTOBJECTINTERFACE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextObjectInterface.intrinsicSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "intrinsicSize", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QTextObjectInterface::intrinsicSize(QTextDocument*,int,QTextFormat)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTDOCUMENT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX]), (pyArgs[2])))) {
        overloadId = 0; // intrinsicSize(QTextDocument*,int,QTextFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextObjectInterfaceFunc_intrinsicSize_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QTextDocument *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QTextFormat cppArg2_local;
        ::QTextFormat *cppArg2 = &cppArg2_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTFORMAT_IDX]), pythonToCpp[2]))
            pythonToCpp[2](pyArgs[2], &cppArg2_local);
        else
            pythonToCpp[2](pyArgs[2], &cppArg2);


        if (!PyErr_Occurred()) {
            // intrinsicSize(QTextDocument*,int,QTextFormat)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QTextObjectInterface.intrinsicSize()' not implemented.");
                return {};
            }
            QSizeF cppResult = cppSelf->intrinsicSize(cppArg0, cppArg1, *cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QTextObjectInterfaceFunc_intrinsicSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QTextObjectInterface_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QTextObjectInterface_methods[] = {
    {"drawObject", reinterpret_cast<PyCFunction>(Sbk_QTextObjectInterfaceFunc_drawObject), METH_VARARGS},
    {"intrinsicSize", reinterpret_cast<PyCFunction>(Sbk_QTextObjectInterfaceFunc_intrinsicSize), METH_VARARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QTextObjectInterface_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QTextObjectInterface *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTOBJECTINTERFACE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QTextObjectInterfaceWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QTextObjectInterface_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QTextObjectInterface_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QTextObjectInterface_Type = nullptr;
static SbkObjectType *Sbk_QTextObjectInterface_TypeF(void)
{
    return _Sbk_QTextObjectInterface_Type;
}

static PyType_Slot Sbk_QTextObjectInterface_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QTextObjectInterface_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QTextObjectInterface_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QTextObjectInterface_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QTextObjectInterface_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QTextObjectInterface_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QTextObjectInterface_spec = {
    "2:PySide2.QtGui.QTextObjectInterface",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QTextObjectInterface_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QTextObjectInterface_PythonToCpp_QTextObjectInterface_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QTextObjectInterface_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QTextObjectInterface_PythonToCpp_QTextObjectInterface_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTextObjectInterface_TypeF())))
        return QTextObjectInterface_PythonToCpp_QTextObjectInterface_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QTextObjectInterface_PTR_CppToPython_QTextObjectInterface(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QTextObjectInterface *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QTextObjectInterface_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QTextObjectInterface_SignatureStrings[] = {
    "PySide2.QtGui.QTextObjectInterface(self)",
    "PySide2.QtGui.QTextObjectInterface.drawObject(self,painter:PySide2.QtGui.QPainter,rect:PySide2.QtCore.QRectF,doc:PySide2.QtGui.QTextDocument,posInDocument:int,format:PySide2.QtGui.QTextFormat)",
    "PySide2.QtGui.QTextObjectInterface.intrinsicSize(self,doc:PySide2.QtGui.QTextDocument,posInDocument:int,format:PySide2.QtGui.QTextFormat)->PySide2.QtCore.QSizeF",
    nullptr}; // Sentinel

void init_QTextObjectInterface(PyObject *module)
{
    _Sbk_QTextObjectInterface_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QTextObjectInterface",
        "QTextObjectInterface*",
        &Sbk_QTextObjectInterface_spec,
        &Shiboken::callCppDestructor< ::QTextObjectInterface >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QTextObjectInterface_Type);
    InitSignatureStrings(pyType, QTextObjectInterface_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QTextObjectInterface_Type), Sbk_QTextObjectInterface_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QTEXTOBJECTINTERFACE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QTextObjectInterface_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QTextObjectInterface_TypeF(),
        QTextObjectInterface_PythonToCpp_QTextObjectInterface_PTR,
        is_QTextObjectInterface_PythonToCpp_QTextObjectInterface_PTR_Convertible,
        QTextObjectInterface_PTR_CppToPython_QTextObjectInterface);

    Shiboken::Conversions::registerConverterName(converter, "QTextObjectInterface");
    Shiboken::Conversions::registerConverterName(converter, "QTextObjectInterface*");
    Shiboken::Conversions::registerConverterName(converter, "QTextObjectInterface&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTextObjectInterface).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTextObjectInterfaceWrapper).name());


}
