/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qtextitem_wrapper.h"

// inner classes

// Extra includes
#include <QtGui/qfont.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QTextItem_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QTextItem >()))
        return -1;

    ::QTextItem *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextItem.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QTextItem()
            cptr = new ::QTextItem();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QTextItem >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QTextItemFunc_ascent(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextItem.ascent";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // ascent()const
            qreal cppResult = const_cast<const ::QTextItem *>(cppSelf)->ascent();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextItemFunc_descent(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextItem.descent";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // descent()const
            qreal cppResult = const_cast<const ::QTextItem *>(cppSelf)->descent();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextItemFunc_font(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextItem.font";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // font()const
            QFont cppResult = const_cast<const ::QTextItem *>(cppSelf)->font();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextItemFunc_renderFlags(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextItem.renderFlags";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // renderFlags()const
            QFlags<QTextItem::RenderFlag> cppResult = const_cast<const ::QTextItem *>(cppSelf)->renderFlags();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTITEM_RENDERFLAG_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextItemFunc_text(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextItem.text";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // text()const
            QString cppResult = const_cast<const ::QTextItem *>(cppSelf)->text();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTextItemFunc_width(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTextItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTEXTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTextItem.width";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // width()const
            qreal cppResult = const_cast<const ::QTextItem *>(cppSelf)->width();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QTextItem_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QTextItem_methods[] = {
    {"ascent", reinterpret_cast<PyCFunction>(Sbk_QTextItemFunc_ascent), METH_NOARGS},
    {"descent", reinterpret_cast<PyCFunction>(Sbk_QTextItemFunc_descent), METH_NOARGS},
    {"font", reinterpret_cast<PyCFunction>(Sbk_QTextItemFunc_font), METH_NOARGS},
    {"renderFlags", reinterpret_cast<PyCFunction>(Sbk_QTextItemFunc_renderFlags), METH_NOARGS},
    {"text", reinterpret_cast<PyCFunction>(Sbk_QTextItemFunc_text), METH_NOARGS},
    {"width", reinterpret_cast<PyCFunction>(Sbk_QTextItemFunc_width), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QTextItem_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QTextItem_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QTextItem_Type = nullptr;
static SbkObjectType *Sbk_QTextItem_TypeF(void)
{
    return _Sbk_QTextItem_Type;
}

static PyType_Slot Sbk_QTextItem_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QTextItem_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QTextItem_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QTextItem_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QTextItem_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QTextItem_spec = {
    "2:PySide2.QtGui.QTextItem",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QTextItem_slots
};

} //extern "C"

PyObject *SbkPySide2_QtGui_QTextItem_RenderFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::QTextItem::RenderFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QTextItem::RenderFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QTextItem::RenderFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QTextItem::RenderFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QTextItem::RenderFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTITEM_RENDERFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QTextItem_RenderFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::QTextItem::RenderFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QTextItem::RenderFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QTextItem::RenderFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QTextItem::RenderFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QTextItem::RenderFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTITEM_RENDERFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QTextItem_RenderFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QTextItem::RenderFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QTextItem::RenderFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QTextItem::RenderFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QTextItem::RenderFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QTextItem::RenderFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTITEM_RENDERFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QTextItem_RenderFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QTextItem::RenderFlags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTITEM_RENDERFLAG_IDX])->converter, self, &cppSelf);
    ::QTextItem::RenderFlags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTITEM_RENDERFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtGui_QTextItem_RenderFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTITEM_RENDERFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtGui_QTextItem_RenderFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTITEM_RENDERFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtGui_QTextItem_RenderFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtGui_QTextItem_RenderFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtGui_QTextItem_RenderFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtGui_QTextItem_RenderFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtGui_QTextItem_RenderFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtGui_QTextItem_RenderFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtGui_QTextItem_RenderFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtGui_QTextItem_RenderFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtGui_QTextItem_RenderFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtGui_QTextItem_RenderFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtGui_QTextItem_RenderFlag_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QTextItem_RenderFlag_PythonToCpp_QTextItem_RenderFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextItem::RenderFlag *>(cppOut) =
        static_cast<::QTextItem::RenderFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTextItem_RenderFlag_PythonToCpp_QTextItem_RenderFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTEXTITEM_RENDERFLAG_IDX]))
        return QTextItem_RenderFlag_PythonToCpp_QTextItem_RenderFlag;
    return {};
}
static PyObject *QTextItem_RenderFlag_CppToPython_QTextItem_RenderFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTextItem::RenderFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QTEXTITEM_RENDERFLAG_IDX], castCppIn);

}

static void QFlags_QTextItem_RenderFlag__PythonToCpp_QFlags_QTextItem_RenderFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QTextItem::RenderFlag> *>(cppOut) =
        ::QFlags<QTextItem::RenderFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QTextItem_RenderFlag__PythonToCpp_QFlags_QTextItem_RenderFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTITEM_RENDERFLAG_IDX]))
        return QFlags_QTextItem_RenderFlag__PythonToCpp_QFlags_QTextItem_RenderFlag_;
    return {};
}
static PyObject *QFlags_QTextItem_RenderFlag__CppToPython_QFlags_QTextItem_RenderFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QTextItem::RenderFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTITEM_RENDERFLAG_IDX]));

}

static void QTextItem_RenderFlag_PythonToCpp_QFlags_QTextItem_RenderFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QTextItem::RenderFlag> *>(cppOut) =
        ::QFlags<QTextItem::RenderFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QTextItem_RenderFlag_PythonToCpp_QFlags_QTextItem_RenderFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTEXTITEM_RENDERFLAG_IDX]))
        return QTextItem_RenderFlag_PythonToCpp_QFlags_QTextItem_RenderFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_QTextItem_RenderFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QTextItem::RenderFlag> *>(cppOut) =
        ::QFlags<QTextItem::RenderFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QTextItem_RenderFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTEXTITEM_RENDERFLAG_IDX]))
        return number_PythonToCpp_QFlags_QTextItem_RenderFlag_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QTextItem_PythonToCpp_QTextItem_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QTextItem_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QTextItem_PythonToCpp_QTextItem_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTextItem_TypeF())))
        return QTextItem_PythonToCpp_QTextItem_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QTextItem_PTR_CppToPython_QTextItem(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QTextItem *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QTextItem_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QTextItem_SignatureStrings[] = {
    "PySide2.QtGui.QTextItem(self)",
    "PySide2.QtGui.QTextItem.ascent(self)->qreal",
    "PySide2.QtGui.QTextItem.descent(self)->qreal",
    "PySide2.QtGui.QTextItem.font(self)->PySide2.QtGui.QFont",
    "PySide2.QtGui.QTextItem.renderFlags(self)->PySide2.QtGui.QTextItem.RenderFlags",
    "PySide2.QtGui.QTextItem.text(self)->QString",
    "PySide2.QtGui.QTextItem.width(self)->qreal",
    nullptr}; // Sentinel

void init_QTextItem(PyObject *module)
{
    _Sbk_QTextItem_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QTextItem",
        "QTextItem*",
        &Sbk_QTextItem_spec,
        &Shiboken::callCppDestructor< ::QTextItem >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QTextItem_Type);
    InitSignatureStrings(pyType, QTextItem_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QTextItem_Type), Sbk_QTextItem_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QTEXTITEM_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QTextItem_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QTextItem_TypeF(),
        QTextItem_PythonToCpp_QTextItem_PTR,
        is_QTextItem_PythonToCpp_QTextItem_PTR_Convertible,
        QTextItem_PTR_CppToPython_QTextItem);

    Shiboken::Conversions::registerConverterName(converter, "QTextItem");
    Shiboken::Conversions::registerConverterName(converter, "QTextItem*");
    Shiboken::Conversions::registerConverterName(converter, "QTextItem&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTextItem).name());


    // Initialization of enums.

    // Initialization of enum 'RenderFlag'.
    SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTITEM_RENDERFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtGui.QTextItem.RenderFlags", SbkPySide2_QtGui_QTextItem_RenderFlag_number_slots);
    SbkPySide2_QtGuiTypes[SBK_QTEXTITEM_RENDERFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTextItem_TypeF(),
        "RenderFlag",
        "2:PySide2.QtGui.QTextItem.RenderFlag",
        "QTextItem::RenderFlag",
        SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTITEM_RENDERFLAG_IDX]);
    if (!SbkPySide2_QtGuiTypes[SBK_QTEXTITEM_RENDERFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTITEM_RENDERFLAG_IDX],
        Sbk_QTextItem_TypeF(), "RightToLeft", (long) QTextItem::RenderFlag::RightToLeft))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTITEM_RENDERFLAG_IDX],
        Sbk_QTextItem_TypeF(), "Overline", (long) QTextItem::RenderFlag::Overline))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTITEM_RENDERFLAG_IDX],
        Sbk_QTextItem_TypeF(), "Underline", (long) QTextItem::RenderFlag::Underline))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTITEM_RENDERFLAG_IDX],
        Sbk_QTextItem_TypeF(), "StrikeOut", (long) QTextItem::RenderFlag::StrikeOut))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTEXTITEM_RENDERFLAG_IDX],
        Sbk_QTextItem_TypeF(), "Dummy", (long) QTextItem::RenderFlag::Dummy))
        return;
    // Register converter for enum 'QTextItem::RenderFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTITEM_RENDERFLAG_IDX],
            QTextItem_RenderFlag_CppToPython_QTextItem_RenderFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTextItem_RenderFlag_PythonToCpp_QTextItem_RenderFlag,
            is_QTextItem_RenderFlag_PythonToCpp_QTextItem_RenderFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QTEXTITEM_RENDERFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTextItem::RenderFlag");
        Shiboken::Conversions::registerConverterName(converter, "RenderFlag");
    }
    // Register converter for flag 'QFlags<QTextItem::RenderFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTITEM_RENDERFLAG_IDX],
            QFlags_QTextItem_RenderFlag__CppToPython_QFlags_QTextItem_RenderFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTextItem_RenderFlag_PythonToCpp_QFlags_QTextItem_RenderFlag_,
            is_QTextItem_RenderFlag_PythonToCpp_QFlags_QTextItem_RenderFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QTextItem_RenderFlag__PythonToCpp_QFlags_QTextItem_RenderFlag_,
            is_QFlags_QTextItem_RenderFlag__PythonToCpp_QFlags_QTextItem_RenderFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QTextItem_RenderFlag_,
            is_number_PythonToCpp_QFlags_QTextItem_RenderFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QTEXTITEM_RENDERFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTextItem::RenderFlags");
        Shiboken::Conversions::registerConverterName(converter, "RenderFlags");
    }
    // End of 'RenderFlag' enum/flags.

    qRegisterMetaType< ::QTextItem::RenderFlag >("QTextItem::RenderFlag");
    qRegisterMetaType< ::QTextItem::RenderFlags >("QTextItem::RenderFlags");
}
