/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qtabletevent_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QTabletEventWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QTabletEventWrapper::QTabletEventWrapper(::QEvent::Type t, const ::QPointF & pos, const ::QPointF & globalPos, int device, int pointerType, qreal pressure, int xTilt, int yTilt, qreal tangentialPressure, qreal rotation, int z, ::QFlags<Qt::KeyboardModifier> keyState, qint64 uniqueID) : QTabletEvent(t, pos, globalPos, device, pointerType, pressure, xTilt, yTilt, tangentialPressure, rotation, z, keyState, uniqueID)
{
    resetPyMethodCache();
    // ... middle
}

QTabletEventWrapper::QTabletEventWrapper(::QEvent::Type t, const ::QPointF & pos, const ::QPointF & globalPos, int device, int pointerType, qreal pressure, int xTilt, int yTilt, qreal tangentialPressure, qreal rotation, int z, ::QFlags<Qt::KeyboardModifier> keyState, qint64 uniqueID, ::Qt::MouseButton button, ::QFlags<Qt::MouseButton> buttons) : QTabletEvent(t, pos, globalPos, device, pointerType, pressure, xTilt, yTilt, tangentialPressure, rotation, z, keyState, uniqueID, button, buttons)
{
    resetPyMethodCache();
    // ... middle
}

QTabletEventWrapper::~QTabletEventWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QTabletEvent_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QTabletEvent >()))
        return -1;

    ::QTabletEventWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTabletEvent.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 14)
        goto Sbk_QTabletEvent_Init_TypeError;

    if (!PyArg_UnpackTuple(args, "QTabletEvent", 13, 15, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8]), &(pyArgs[9]), &(pyArgs[10]), &(pyArgs[11]), &(pyArgs[12]), &(pyArgs[13]), &(pyArgs[14])))
        return -1;


    // Overloaded function decisor
    // 0: QTabletEvent::QTabletEvent(QEvent::Type,QPointF,QPointF,int,int,qreal,int,int,qreal,qreal,int,QFlags<Qt::KeyboardModifier>,qint64)
    // 1: QTabletEvent::QTabletEvent(QEvent::Type,QPointF,QPointF,int,int,qreal,int,int,qreal,qreal,int,QFlags<Qt::KeyboardModifier>,qint64,Qt::MouseButton,QFlags<Qt::MouseButton>)
    if (numArgs >= 13
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QEVENT_TYPE_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[7])))
        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[8])))
        && (pythonToCpp[9] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[9])))
        && (pythonToCpp[10] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[10])))
        && (pythonToCpp[11] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_KEYBOARDMODIFIER_IDX])->converter, (pyArgs[11])))
        && (pythonToCpp[12] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), (pyArgs[12])))) {
        if (numArgs == 13) {
            overloadId = 0; // QTabletEvent(QEvent::Type,QPointF,QPointF,int,int,qreal,int,int,qreal,qreal,int,QFlags<Qt::KeyboardModifier>,qint64)
        } else if (numArgs == 15
            && (pythonToCpp[13] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX])->converter, (pyArgs[13])))
            && (pythonToCpp[14] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MOUSEBUTTON_IDX])->converter, (pyArgs[14])))) {
            overloadId = 1; // QTabletEvent(QEvent::Type,QPointF,QPointF,int,int,qreal,int,int,qreal,qreal,int,QFlags<Qt::KeyboardModifier>,qint64,Qt::MouseButton,QFlags<Qt::MouseButton>)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTabletEvent_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QTabletEvent(QEvent::Type t, const QPointF & pos, const QPointF & globalPos, int device, int pointerType, qreal pressure, int xTilt, int yTilt, qreal tangentialPressure, qreal rotation, int z, QFlags<Qt::KeyboardModifier> keyState, qint64 uniqueID)
        {
            ::QEvent::Type cppArg0{QEvent::None};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QPointF cppArg1_local;
            ::QPointF *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QPointF cppArg2_local;
            ::QPointF *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);

            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            qreal cppArg5;
            pythonToCpp[5](pyArgs[5], &cppArg5);
            int cppArg6;
            pythonToCpp[6](pyArgs[6], &cppArg6);
            int cppArg7;
            pythonToCpp[7](pyArgs[7], &cppArg7);
            qreal cppArg8;
            pythonToCpp[8](pyArgs[8], &cppArg8);
            qreal cppArg9;
            pythonToCpp[9](pyArgs[9], &cppArg9);
            int cppArg10;
            pythonToCpp[10](pyArgs[10], &cppArg10);
            ::QFlags<Qt::KeyboardModifier> cppArg11 = QFlags<Qt::KeyboardModifier>(0);
            pythonToCpp[11](pyArgs[11], &cppArg11);
            qint64 cppArg12;
            pythonToCpp[12](pyArgs[12], &cppArg12);

            if (!PyErr_Occurred()) {
                // QTabletEvent(QEvent::Type,QPointF,QPointF,int,int,qreal,int,int,qreal,qreal,int,QFlags<Qt::KeyboardModifier>,qint64)
                cptr = new ::QTabletEventWrapper(cppArg0, *cppArg1, *cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9, cppArg10, cppArg11, cppArg12);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QTabletEvent.QTabletEvent(QEvent::Type t, const QPointF & pos, const QPointF & globalPos, int device, int pointerType, qreal pressure, int xTilt, int yTilt, qreal tangentialPressure, qreal rotation, int z, QFlags<Qt::KeyboardModifier> keyState, qint64 uniqueID) is deprecated", 1);
            break;
        }
        case 1: // QTabletEvent(QEvent::Type t, const QPointF & pos, const QPointF & globalPos, int device, int pointerType, qreal pressure, int xTilt, int yTilt, qreal tangentialPressure, qreal rotation, int z, QFlags<Qt::KeyboardModifier> keyState, qint64 uniqueID, Qt::MouseButton button, QFlags<Qt::MouseButton> buttons)
        {
            ::QEvent::Type cppArg0{QEvent::None};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QPointF cppArg1_local;
            ::QPointF *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QPointF cppArg2_local;
            ::QPointF *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);

            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            int cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            qreal cppArg5;
            pythonToCpp[5](pyArgs[5], &cppArg5);
            int cppArg6;
            pythonToCpp[6](pyArgs[6], &cppArg6);
            int cppArg7;
            pythonToCpp[7](pyArgs[7], &cppArg7);
            qreal cppArg8;
            pythonToCpp[8](pyArgs[8], &cppArg8);
            qreal cppArg9;
            pythonToCpp[9](pyArgs[9], &cppArg9);
            int cppArg10;
            pythonToCpp[10](pyArgs[10], &cppArg10);
            ::QFlags<Qt::KeyboardModifier> cppArg11 = QFlags<Qt::KeyboardModifier>(0);
            pythonToCpp[11](pyArgs[11], &cppArg11);
            qint64 cppArg12;
            pythonToCpp[12](pyArgs[12], &cppArg12);
            ::Qt::MouseButton cppArg13{Qt::NoButton};
            pythonToCpp[13](pyArgs[13], &cppArg13);
            ::QFlags<Qt::MouseButton> cppArg14 = QFlags<Qt::MouseButton>(0);
            pythonToCpp[14](pyArgs[14], &cppArg14);

            if (!PyErr_Occurred()) {
                // QTabletEvent(QEvent::Type,QPointF,QPointF,int,int,qreal,int,int,qreal,qreal,int,QFlags<Qt::KeyboardModifier>,qint64,Qt::MouseButton,QFlags<Qt::MouseButton>)
                cptr = new ::QTabletEventWrapper(cppArg0, *cppArg1, *cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9, cppArg10, cppArg11, cppArg12, cppArg13, cppArg14);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QTabletEvent >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QTabletEvent_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QTabletEvent_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QTabletEventFunc_button(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTabletEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTabletEvent.button";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // button()const
            Qt::MouseButton cppResult = const_cast<const ::QTabletEvent *>(cppSelf)->button();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_MOUSEBUTTON_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTabletEventFunc_buttons(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTabletEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTabletEvent.buttons";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // buttons()const
            QFlags<Qt::MouseButton> cppResult = const_cast<const ::QTabletEvent *>(cppSelf)->buttons();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_MOUSEBUTTON_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTabletEventFunc_device(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTabletEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTabletEvent.device";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // device()const
            QTabletEvent::TabletDevice cppResult = const_cast<const ::QTabletEvent *>(cppSelf)->device();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_TABLETDEVICE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTabletEventFunc_deviceType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTabletEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTabletEvent.deviceType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // deviceType()const
            QTabletEvent::TabletDevice cppResult = const_cast<const ::QTabletEvent *>(cppSelf)->deviceType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_TABLETDEVICE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTabletEventFunc_globalPos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTabletEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTabletEvent.globalPos";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // globalPos()const
            QPoint cppResult = const_cast<const ::QTabletEvent *>(cppSelf)->globalPos();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTabletEventFunc_globalPosF(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTabletEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTabletEvent.globalPosF";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // globalPosF()const
            const QPointF & cppResult = const_cast<const ::QTabletEvent *>(cppSelf)->globalPosF();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTabletEventFunc_globalX(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTabletEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTabletEvent.globalX";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // globalX()const
            int cppResult = const_cast<const ::QTabletEvent *>(cppSelf)->globalX();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTabletEventFunc_globalY(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTabletEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTabletEvent.globalY";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // globalY()const
            int cppResult = const_cast<const ::QTabletEvent *>(cppSelf)->globalY();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTabletEventFunc_hiResGlobalX(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTabletEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTabletEvent.hiResGlobalX";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hiResGlobalX()const
            qreal cppResult = const_cast<const ::QTabletEvent *>(cppSelf)->hiResGlobalX();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTabletEventFunc_hiResGlobalY(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTabletEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTabletEvent.hiResGlobalY";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hiResGlobalY()const
            qreal cppResult = const_cast<const ::QTabletEvent *>(cppSelf)->hiResGlobalY();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTabletEventFunc_pointerType(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTabletEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTabletEvent.pointerType";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pointerType()const
            QTabletEvent::PointerType cppResult = const_cast<const ::QTabletEvent *>(cppSelf)->pointerType();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_POINTERTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTabletEventFunc_pos(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTabletEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTabletEvent.pos";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pos()const
            QPoint cppResult = const_cast<const ::QTabletEvent *>(cppSelf)->pos();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTabletEventFunc_posF(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTabletEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTabletEvent.posF";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // posF()const
            const QPointF & cppResult = const_cast<const ::QTabletEvent *>(cppSelf)->posF();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTabletEventFunc_pressure(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTabletEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTabletEvent.pressure";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pressure()const
            qreal cppResult = const_cast<const ::QTabletEvent *>(cppSelf)->pressure();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTabletEventFunc_rotation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTabletEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTabletEvent.rotation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rotation()const
            qreal cppResult = const_cast<const ::QTabletEvent *>(cppSelf)->rotation();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTabletEventFunc_tangentialPressure(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTabletEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTabletEvent.tangentialPressure";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // tangentialPressure()const
            qreal cppResult = const_cast<const ::QTabletEvent *>(cppSelf)->tangentialPressure();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTabletEventFunc_uniqueId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTabletEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTabletEvent.uniqueId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // uniqueId()const
            qint64 cppResult = const_cast<const ::QTabletEvent *>(cppSelf)->uniqueId();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTabletEventFunc_x(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTabletEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTabletEvent.x";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // x()const
            int cppResult = const_cast<const ::QTabletEvent *>(cppSelf)->x();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTabletEventFunc_xTilt(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTabletEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTabletEvent.xTilt";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // xTilt()const
            int cppResult = const_cast<const ::QTabletEvent *>(cppSelf)->xTilt();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTabletEventFunc_y(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTabletEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTabletEvent.y";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // y()const
            int cppResult = const_cast<const ::QTabletEvent *>(cppSelf)->y();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTabletEventFunc_yTilt(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTabletEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTabletEvent.yTilt";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // yTilt()const
            int cppResult = const_cast<const ::QTabletEvent *>(cppSelf)->yTilt();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QTabletEventFunc_z(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QTabletEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QTabletEvent.z";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // z()const
            int cppResult = const_cast<const ::QTabletEvent *>(cppSelf)->z();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QTabletEvent_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QTabletEvent_methods[] = {
    {"button", reinterpret_cast<PyCFunction>(Sbk_QTabletEventFunc_button), METH_NOARGS},
    {"buttons", reinterpret_cast<PyCFunction>(Sbk_QTabletEventFunc_buttons), METH_NOARGS},
    {"device", reinterpret_cast<PyCFunction>(Sbk_QTabletEventFunc_device), METH_NOARGS},
    {"deviceType", reinterpret_cast<PyCFunction>(Sbk_QTabletEventFunc_deviceType), METH_NOARGS},
    {"globalPos", reinterpret_cast<PyCFunction>(Sbk_QTabletEventFunc_globalPos), METH_NOARGS},
    {"globalPosF", reinterpret_cast<PyCFunction>(Sbk_QTabletEventFunc_globalPosF), METH_NOARGS},
    {"globalX", reinterpret_cast<PyCFunction>(Sbk_QTabletEventFunc_globalX), METH_NOARGS},
    {"globalY", reinterpret_cast<PyCFunction>(Sbk_QTabletEventFunc_globalY), METH_NOARGS},
    {"hiResGlobalX", reinterpret_cast<PyCFunction>(Sbk_QTabletEventFunc_hiResGlobalX), METH_NOARGS},
    {"hiResGlobalY", reinterpret_cast<PyCFunction>(Sbk_QTabletEventFunc_hiResGlobalY), METH_NOARGS},
    {"pointerType", reinterpret_cast<PyCFunction>(Sbk_QTabletEventFunc_pointerType), METH_NOARGS},
    {"pos", reinterpret_cast<PyCFunction>(Sbk_QTabletEventFunc_pos), METH_NOARGS},
    {"posF", reinterpret_cast<PyCFunction>(Sbk_QTabletEventFunc_posF), METH_NOARGS},
    {"pressure", reinterpret_cast<PyCFunction>(Sbk_QTabletEventFunc_pressure), METH_NOARGS},
    {"rotation", reinterpret_cast<PyCFunction>(Sbk_QTabletEventFunc_rotation), METH_NOARGS},
    {"tangentialPressure", reinterpret_cast<PyCFunction>(Sbk_QTabletEventFunc_tangentialPressure), METH_NOARGS},
    {"uniqueId", reinterpret_cast<PyCFunction>(Sbk_QTabletEventFunc_uniqueId), METH_NOARGS},
    {"x", reinterpret_cast<PyCFunction>(Sbk_QTabletEventFunc_x), METH_NOARGS},
    {"xTilt", reinterpret_cast<PyCFunction>(Sbk_QTabletEventFunc_xTilt), METH_NOARGS},
    {"y", reinterpret_cast<PyCFunction>(Sbk_QTabletEventFunc_y), METH_NOARGS},
    {"yTilt", reinterpret_cast<PyCFunction>(Sbk_QTabletEventFunc_yTilt), METH_NOARGS},
    {"z", reinterpret_cast<PyCFunction>(Sbk_QTabletEventFunc_z), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QTabletEvent_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QTabletEvent *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QTabletEventWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QTabletEvent_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QTabletEvent_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QTabletEvent_Type = nullptr;
static SbkObjectType *Sbk_QTabletEvent_TypeF(void)
{
    return _Sbk_QTabletEvent_Type;
}

static PyType_Slot Sbk_QTabletEvent_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QTabletEvent_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QTabletEvent_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QTabletEvent_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QTabletEvent_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QTabletEvent_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QTabletEvent_spec = {
    "2:PySide2.QtGui.QTabletEvent",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QTabletEvent_slots
};

} //extern "C"

static void *Sbk_QTabletEvent_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
     if ( reinterpret_cast< ::QTabletEvent *>(cptr)->type() == QEvent::TabletMove ||  reinterpret_cast< ::QTabletEvent *>(cptr)->type() == QEvent::TabletPress ||  reinterpret_cast< ::QTabletEvent *>(cptr)->type() == QEvent::TabletRelease)
        return cptr;
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QTabletEvent_TabletDevice_PythonToCpp_QTabletEvent_TabletDevice(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTabletEvent::TabletDevice *>(cppOut) =
        static_cast<::QTabletEvent::TabletDevice>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTabletEvent_TabletDevice_PythonToCpp_QTabletEvent_TabletDevice_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_TABLETDEVICE_IDX]))
        return QTabletEvent_TabletDevice_PythonToCpp_QTabletEvent_TabletDevice;
    return {};
}
static PyObject *QTabletEvent_TabletDevice_CppToPython_QTabletEvent_TabletDevice(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTabletEvent::TabletDevice *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_TABLETDEVICE_IDX], castCppIn);

}

static void QTabletEvent_PointerType_PythonToCpp_QTabletEvent_PointerType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTabletEvent::PointerType *>(cppOut) =
        static_cast<::QTabletEvent::PointerType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QTabletEvent_PointerType_PythonToCpp_QTabletEvent_PointerType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_POINTERTYPE_IDX]))
        return QTabletEvent_PointerType_PythonToCpp_QTabletEvent_PointerType;
    return {};
}
static PyObject *QTabletEvent_PointerType_CppToPython_QTabletEvent_PointerType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QTabletEvent::PointerType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_POINTERTYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QTabletEvent_PythonToCpp_QTabletEvent_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QTabletEvent_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QTabletEvent_PythonToCpp_QTabletEvent_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTabletEvent_TypeF())))
        return QTabletEvent_PythonToCpp_QTabletEvent_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QTabletEvent_PTR_CppToPython_QTabletEvent(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QTabletEvent *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QTabletEvent_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QTabletEvent_SignatureStrings[] = {
    "1:PySide2.QtGui.QTabletEvent(self,t:PySide2.QtCore.QEvent.Type,pos:PySide2.QtCore.QPointF,globalPos:PySide2.QtCore.QPointF,device:int,pointerType:int,pressure:qreal,xTilt:int,yTilt:int,tangentialPressure:qreal,rotation:qreal,z:int,keyState:PySide2.QtCore.Qt.KeyboardModifiers,uniqueID:qint64)",
    "0:PySide2.QtGui.QTabletEvent(self,t:PySide2.QtCore.QEvent.Type,pos:PySide2.QtCore.QPointF,globalPos:PySide2.QtCore.QPointF,device:int,pointerType:int,pressure:qreal,xTilt:int,yTilt:int,tangentialPressure:qreal,rotation:qreal,z:int,keyState:PySide2.QtCore.Qt.KeyboardModifiers,uniqueID:qint64,button:PySide2.QtCore.Qt.MouseButton,buttons:PySide2.QtCore.Qt.MouseButtons)",
    "PySide2.QtGui.QTabletEvent.button(self)->PySide2.QtCore.Qt.MouseButton",
    "PySide2.QtGui.QTabletEvent.buttons(self)->PySide2.QtCore.Qt.MouseButtons",
    "PySide2.QtGui.QTabletEvent.device(self)->PySide2.QtGui.QTabletEvent.TabletDevice",
    "PySide2.QtGui.QTabletEvent.deviceType(self)->PySide2.QtGui.QTabletEvent.TabletDevice",
    "PySide2.QtGui.QTabletEvent.globalPos(self)->PySide2.QtCore.QPoint",
    "PySide2.QtGui.QTabletEvent.globalPosF(self)->PySide2.QtCore.QPointF",
    "PySide2.QtGui.QTabletEvent.globalX(self)->int",
    "PySide2.QtGui.QTabletEvent.globalY(self)->int",
    "PySide2.QtGui.QTabletEvent.hiResGlobalX(self)->qreal",
    "PySide2.QtGui.QTabletEvent.hiResGlobalY(self)->qreal",
    "PySide2.QtGui.QTabletEvent.pointerType(self)->PySide2.QtGui.QTabletEvent.PointerType",
    "PySide2.QtGui.QTabletEvent.pos(self)->PySide2.QtCore.QPoint",
    "PySide2.QtGui.QTabletEvent.posF(self)->PySide2.QtCore.QPointF",
    "PySide2.QtGui.QTabletEvent.pressure(self)->qreal",
    "PySide2.QtGui.QTabletEvent.rotation(self)->qreal",
    "PySide2.QtGui.QTabletEvent.tangentialPressure(self)->qreal",
    "PySide2.QtGui.QTabletEvent.uniqueId(self)->qint64",
    "PySide2.QtGui.QTabletEvent.x(self)->int",
    "PySide2.QtGui.QTabletEvent.xTilt(self)->int",
    "PySide2.QtGui.QTabletEvent.y(self)->int",
    "PySide2.QtGui.QTabletEvent.yTilt(self)->int",
    "PySide2.QtGui.QTabletEvent.z(self)->int",
    nullptr}; // Sentinel

void init_QTabletEvent(PyObject *module)
{
    _Sbk_QTabletEvent_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QTabletEvent",
        "QTabletEvent*",
        &Sbk_QTabletEvent_spec,
        &Shiboken::callCppDestructor< ::QTabletEvent >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QINPUTEVENT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QTabletEvent_Type);
    InitSignatureStrings(pyType, QTabletEvent_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QTabletEvent_Type), Sbk_QTabletEvent_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QTabletEvent_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QTabletEvent_TypeF(),
        QTabletEvent_PythonToCpp_QTabletEvent_PTR,
        is_QTabletEvent_PythonToCpp_QTabletEvent_PTR_Convertible,
        QTabletEvent_PTR_CppToPython_QTabletEvent);

    Shiboken::Conversions::registerConverterName(converter, "QTabletEvent");
    Shiboken::Conversions::registerConverterName(converter, "QTabletEvent*");
    Shiboken::Conversions::registerConverterName(converter, "QTabletEvent&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTabletEvent).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTabletEventWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QTabletEvent_TypeF(), &Sbk_QTabletEvent_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'TabletDevice'.
    SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_TABLETDEVICE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTabletEvent_TypeF(),
        "TabletDevice",
        "2:PySide2.QtGui.QTabletEvent.TabletDevice",
        "QTabletEvent::TabletDevice");
    if (!SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_TABLETDEVICE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_TABLETDEVICE_IDX],
        Sbk_QTabletEvent_TypeF(), "NoDevice", (long) QTabletEvent::TabletDevice::NoDevice))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_TABLETDEVICE_IDX],
        Sbk_QTabletEvent_TypeF(), "Puck", (long) QTabletEvent::TabletDevice::Puck))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_TABLETDEVICE_IDX],
        Sbk_QTabletEvent_TypeF(), "Stylus", (long) QTabletEvent::TabletDevice::Stylus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_TABLETDEVICE_IDX],
        Sbk_QTabletEvent_TypeF(), "Airbrush", (long) QTabletEvent::TabletDevice::Airbrush))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_TABLETDEVICE_IDX],
        Sbk_QTabletEvent_TypeF(), "FourDMouse", (long) QTabletEvent::TabletDevice::FourDMouse))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_TABLETDEVICE_IDX],
        Sbk_QTabletEvent_TypeF(), "XFreeEraser", (long) QTabletEvent::TabletDevice::XFreeEraser))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_TABLETDEVICE_IDX],
        Sbk_QTabletEvent_TypeF(), "RotationStylus", (long) QTabletEvent::TabletDevice::RotationStylus))
        return;
    // Register converter for enum 'QTabletEvent::TabletDevice'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_TABLETDEVICE_IDX],
            QTabletEvent_TabletDevice_CppToPython_QTabletEvent_TabletDevice);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTabletEvent_TabletDevice_PythonToCpp_QTabletEvent_TabletDevice,
            is_QTabletEvent_TabletDevice_PythonToCpp_QTabletEvent_TabletDevice_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_TABLETDEVICE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTabletEvent::TabletDevice");
        Shiboken::Conversions::registerConverterName(converter, "TabletDevice");
    }
    // End of 'TabletDevice' enum.

    // Initialization of enum 'PointerType'.
    SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_POINTERTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QTabletEvent_TypeF(),
        "PointerType",
        "2:PySide2.QtGui.QTabletEvent.PointerType",
        "QTabletEvent::PointerType");
    if (!SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_POINTERTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_POINTERTYPE_IDX],
        Sbk_QTabletEvent_TypeF(), "UnknownPointer", (long) QTabletEvent::PointerType::UnknownPointer))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_POINTERTYPE_IDX],
        Sbk_QTabletEvent_TypeF(), "Pen", (long) QTabletEvent::PointerType::Pen))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_POINTERTYPE_IDX],
        Sbk_QTabletEvent_TypeF(), "Cursor", (long) QTabletEvent::PointerType::Cursor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_POINTERTYPE_IDX],
        Sbk_QTabletEvent_TypeF(), "Eraser", (long) QTabletEvent::PointerType::Eraser))
        return;
    // Register converter for enum 'QTabletEvent::PointerType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_POINTERTYPE_IDX],
            QTabletEvent_PointerType_CppToPython_QTabletEvent_PointerType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QTabletEvent_PointerType_PythonToCpp_QTabletEvent_PointerType,
            is_QTabletEvent_PointerType_PythonToCpp_QTabletEvent_PointerType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_POINTERTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QTabletEvent::PointerType");
        Shiboken::Conversions::registerConverterName(converter, "PointerType");
    }
    // End of 'PointerType' enum.

    qRegisterMetaType< ::QTabletEvent::TabletDevice >("QTabletEvent::TabletDevice");
    qRegisterMetaType< ::QTabletEvent::PointerType >("QTabletEvent::PointerType");
}
