/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qstatictext_wrapper.h"

// inner classes

// Extra includes
#include <QtGui/qfont.h>
#include <QtGui/qstatictext.h>
#include <QtGui/qtextoption.h>
#include <QtGui/qtransform.h>
#include <qsize.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QStaticText_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QStaticText >()))
        return -1;

    ::QStaticText *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStaticText.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QStaticText", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QStaticText::QStaticText()
    // 1: QStaticText::QStaticText(QStaticText)
    // 2: QStaticText::QStaticText(QString)
    if (numArgs == 0) {
        overloadId = 0; // QStaticText()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        overloadId = 2; // QStaticText(QString)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSTATICTEXT_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QStaticText(QStaticText)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStaticText_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QStaticText()
        {

            if (!PyErr_Occurred()) {
                // QStaticText()
                cptr = new ::QStaticText();
            }
            break;
        }
        case 1: // QStaticText(const QStaticText & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QStaticText cppArg0_local;
            ::QStaticText *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSTATICTEXT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QStaticText(QStaticText)
                cptr = new ::QStaticText(*cppArg0);
            }
            break;
        }
        case 2: // QStaticText(const QString & text)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QStaticText(QString)
                cptr = new ::QStaticText(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QStaticText >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QStaticText_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QStaticText_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QStaticTextFunc_performanceHint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStaticText *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTATICTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStaticText.performanceHint";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // performanceHint()const
            QStaticText::PerformanceHint cppResult = const_cast<const ::QStaticText *>(cppSelf)->performanceHint();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QSTATICTEXT_PERFORMANCEHINT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStaticTextFunc_prepare(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStaticText *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTATICTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStaticText.prepare";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QStaticTextFunc_prepare_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:prepare", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QStaticText::prepare(QTransform,QFont)
    if (numArgs == 0) {
        overloadId = 0; // prepare(QTransform,QFont)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // prepare(QTransform,QFont)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), (pyArgs[1])))) {
            overloadId = 0; // prepare(QTransform,QFont)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStaticTextFunc_prepare_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_matrix = Shiboken::String::createStaticString("matrix");
            if (PyDict_Contains(kwds, key_matrix)) {
                value = PyDict_GetItem(kwds, key_matrix);
                if (value && pyArgs[0]) {
                    errInfo = key_matrix;
                    Py_INCREF(errInfo);
                    goto Sbk_QStaticTextFunc_prepare_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), (pyArgs[0]))))
                        goto Sbk_QStaticTextFunc_prepare_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_matrix);
            }
            static PyObject *const key_font = Shiboken::String::createStaticString("font");
            if (PyDict_Contains(kwds, key_font)) {
                value = PyDict_GetItem(kwds, key_font);
                if (value && pyArgs[1]) {
                    errInfo = key_font;
                    Py_INCREF(errInfo);
                    goto Sbk_QStaticTextFunc_prepare_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), (pyArgs[1]))))
                        goto Sbk_QStaticTextFunc_prepare_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_font);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QStaticTextFunc_prepare_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QTransform cppArg0_local = QTransform();
        ::QTransform *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);
        }
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QFont cppArg1_local = QFont();
        ::QFont *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);
        }

        if (!PyErr_Occurred()) {
            // prepare(QTransform,QFont)
            cppSelf->prepare(*cppArg0, *cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStaticTextFunc_prepare_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStaticTextFunc_setPerformanceHint(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStaticText *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTATICTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStaticText.setPerformanceHint";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QStaticText::setPerformanceHint(QStaticText::PerformanceHint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QSTATICTEXT_PERFORMANCEHINT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setPerformanceHint(QStaticText::PerformanceHint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStaticTextFunc_setPerformanceHint_TypeError;

    // Call function/method
    {
        ::QStaticText::PerformanceHint cppArg0{QStaticText::ModerateCaching};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPerformanceHint(QStaticText::PerformanceHint)
            cppSelf->setPerformanceHint(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStaticTextFunc_setPerformanceHint_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStaticTextFunc_setText(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStaticText *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTATICTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStaticText.setText";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QStaticText::setText(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setText(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStaticTextFunc_setText_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setText(QString)
            cppSelf->setText(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStaticTextFunc_setText_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStaticTextFunc_setTextFormat(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStaticText *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTATICTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStaticText.setTextFormat";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QStaticText::setTextFormat(Qt::TextFormat)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TEXTFORMAT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setTextFormat(Qt::TextFormat)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStaticTextFunc_setTextFormat_TypeError;

    // Call function/method
    {
        ::Qt::TextFormat cppArg0{Qt::PlainText};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTextFormat(Qt::TextFormat)
            cppSelf->setTextFormat(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStaticTextFunc_setTextFormat_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStaticTextFunc_setTextOption(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStaticText *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTATICTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStaticText.setTextOption";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QStaticText::setTextOption(QTextOption)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_IDX]), (pyArg)))) {
        overloadId = 0; // setTextOption(QTextOption)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStaticTextFunc_setTextOption_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTextOption cppArg0_local;
        ::QTextOption *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setTextOption(QTextOption)
            cppSelf->setTextOption(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStaticTextFunc_setTextOption_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStaticTextFunc_setTextWidth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStaticText *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTATICTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStaticText.setTextWidth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QStaticText::setTextWidth(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setTextWidth(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStaticTextFunc_setTextWidth_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTextWidth(qreal)
            cppSelf->setTextWidth(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStaticTextFunc_setTextWidth_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStaticTextFunc_size(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStaticText *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTATICTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStaticText.size";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // size()const
            QSizeF cppResult = const_cast<const ::QStaticText *>(cppSelf)->size();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStaticTextFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStaticText *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTATICTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStaticText.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QStaticText::swap(QStaticText&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSTATICTEXT_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QStaticText&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStaticTextFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QStaticText cppArg0_local;
        ::QStaticText *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSTATICTEXT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QStaticText&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStaticTextFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStaticTextFunc_text(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStaticText *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTATICTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStaticText.text";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // text()const
            QString cppResult = const_cast<const ::QStaticText *>(cppSelf)->text();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStaticTextFunc_textFormat(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStaticText *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTATICTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStaticText.textFormat";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // textFormat()const
            Qt::TextFormat cppResult = const_cast<const ::QStaticText *>(cppSelf)->textFormat();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TEXTFORMAT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStaticTextFunc_textOption(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStaticText *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTATICTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStaticText.textOption";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // textOption()const
            QTextOption cppResult = const_cast<const ::QStaticText *>(cppSelf)->textOption();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTOPTION_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStaticTextFunc_textWidth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStaticText *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTATICTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QStaticText.textWidth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // textWidth()const
            qreal cppResult = const_cast<const ::QStaticText *>(cppSelf)->textWidth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStaticText___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QStaticText *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTATICTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSTATICTEXT_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QStaticText_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QStaticText_methods[] = {
    {"performanceHint", reinterpret_cast<PyCFunction>(Sbk_QStaticTextFunc_performanceHint), METH_NOARGS},
    {"prepare", reinterpret_cast<PyCFunction>(Sbk_QStaticTextFunc_prepare), METH_VARARGS|METH_KEYWORDS},
    {"setPerformanceHint", reinterpret_cast<PyCFunction>(Sbk_QStaticTextFunc_setPerformanceHint), METH_O},
    {"setText", reinterpret_cast<PyCFunction>(Sbk_QStaticTextFunc_setText), METH_O},
    {"setTextFormat", reinterpret_cast<PyCFunction>(Sbk_QStaticTextFunc_setTextFormat), METH_O},
    {"setTextOption", reinterpret_cast<PyCFunction>(Sbk_QStaticTextFunc_setTextOption), METH_O},
    {"setTextWidth", reinterpret_cast<PyCFunction>(Sbk_QStaticTextFunc_setTextWidth), METH_O},
    {"size", reinterpret_cast<PyCFunction>(Sbk_QStaticTextFunc_size), METH_NOARGS},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QStaticTextFunc_swap), METH_O},
    {"text", reinterpret_cast<PyCFunction>(Sbk_QStaticTextFunc_text), METH_NOARGS},
    {"textFormat", reinterpret_cast<PyCFunction>(Sbk_QStaticTextFunc_textFormat), METH_NOARGS},
    {"textOption", reinterpret_cast<PyCFunction>(Sbk_QStaticTextFunc_textOption), METH_NOARGS},
    {"textWidth", reinterpret_cast<PyCFunction>(Sbk_QStaticTextFunc_textWidth), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QStaticText___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QStaticText_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QStaticText *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTATICTEXT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSTATICTEXT_IDX]), (pyArg)))) {
                // operator!=(const QStaticText & arg__1) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QStaticText cppArg0_local;
                ::QStaticText *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSTATICTEXT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSTATICTEXT_IDX]), (pyArg)))) {
                // operator==(const QStaticText & arg__1) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QStaticText cppArg0_local;
                ::QStaticText *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSTATICTEXT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QStaticText_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QStaticText_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QStaticText_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QStaticText_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QStaticText_Type = nullptr;
static SbkObjectType *Sbk_QStaticText_TypeF(void)
{
    return _Sbk_QStaticText_Type;
}

static PyType_Slot Sbk_QStaticText_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QStaticText_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QStaticText_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QStaticText_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QStaticText_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QStaticText_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QStaticText_spec = {
    "2:PySide2.QtGui.QStaticText",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QStaticText_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QStaticText_PerformanceHint_PythonToCpp_QStaticText_PerformanceHint(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStaticText::PerformanceHint *>(cppOut) =
        static_cast<::QStaticText::PerformanceHint>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStaticText_PerformanceHint_PythonToCpp_QStaticText_PerformanceHint_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QSTATICTEXT_PERFORMANCEHINT_IDX]))
        return QStaticText_PerformanceHint_PythonToCpp_QStaticText_PerformanceHint;
    return {};
}
static PyObject *QStaticText_PerformanceHint_CppToPython_QStaticText_PerformanceHint(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStaticText::PerformanceHint *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QSTATICTEXT_PERFORMANCEHINT_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QStaticText_PythonToCpp_QStaticText_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QStaticText_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QStaticText_PythonToCpp_QStaticText_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QStaticText_TypeF())))
        return QStaticText_PythonToCpp_QStaticText_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QStaticText_PTR_CppToPython_QStaticText(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QStaticText *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QStaticText_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QStaticText_COPY_CppToPython_QStaticText(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QStaticText_TypeF(), new ::QStaticText(*reinterpret_cast<const ::QStaticText *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QStaticText_PythonToCpp_QStaticText_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStaticText *>(cppOut) = *reinterpret_cast< ::QStaticText *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QSTATICTEXT_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QStaticText_PythonToCpp_QStaticText_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QStaticText_TypeF())))
        return QStaticText_PythonToCpp_QStaticText_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QStaticText_SignatureStrings[] = {
    "2:PySide2.QtGui.QStaticText(self)",
    "1:PySide2.QtGui.QStaticText(self,other:PySide2.QtGui.QStaticText)",
    "0:PySide2.QtGui.QStaticText(self,text:QString)",
    "PySide2.QtGui.QStaticText.performanceHint(self)->PySide2.QtGui.QStaticText.PerformanceHint",
    "PySide2.QtGui.QStaticText.prepare(self,matrix:PySide2.QtGui.QTransform=QTransform(),font:PySide2.QtGui.QFont=QFont())",
    "PySide2.QtGui.QStaticText.setPerformanceHint(self,performanceHint:PySide2.QtGui.QStaticText.PerformanceHint)",
    "PySide2.QtGui.QStaticText.setText(self,text:QString)",
    "PySide2.QtGui.QStaticText.setTextFormat(self,textFormat:PySide2.QtCore.Qt.TextFormat)",
    "PySide2.QtGui.QStaticText.setTextOption(self,textOption:PySide2.QtGui.QTextOption)",
    "PySide2.QtGui.QStaticText.setTextWidth(self,textWidth:qreal)",
    "PySide2.QtGui.QStaticText.size(self)->PySide2.QtCore.QSizeF",
    "PySide2.QtGui.QStaticText.swap(self,other:PySide2.QtGui.QStaticText)",
    "PySide2.QtGui.QStaticText.text(self)->QString",
    "PySide2.QtGui.QStaticText.textFormat(self)->PySide2.QtCore.Qt.TextFormat",
    "PySide2.QtGui.QStaticText.textOption(self)->PySide2.QtGui.QTextOption",
    "PySide2.QtGui.QStaticText.textWidth(self)->qreal",
    "PySide2.QtGui.QStaticText.__copy__()",
    nullptr}; // Sentinel

void init_QStaticText(PyObject *module)
{
    _Sbk_QStaticText_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QStaticText",
        "QStaticText",
        &Sbk_QStaticText_spec,
        &Shiboken::callCppDestructor< ::QStaticText >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QStaticText_Type);
    InitSignatureStrings(pyType, QStaticText_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QStaticText_Type), Sbk_QStaticText_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QSTATICTEXT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QStaticText_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QStaticText_TypeF(),
        QStaticText_PythonToCpp_QStaticText_PTR,
        is_QStaticText_PythonToCpp_QStaticText_PTR_Convertible,
        QStaticText_PTR_CppToPython_QStaticText,
        QStaticText_COPY_CppToPython_QStaticText);

    Shiboken::Conversions::registerConverterName(converter, "QStaticText");
    Shiboken::Conversions::registerConverterName(converter, "QStaticText*");
    Shiboken::Conversions::registerConverterName(converter, "QStaticText&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QStaticText).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QStaticText_PythonToCpp_QStaticText_COPY,
        is_QStaticText_PythonToCpp_QStaticText_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'PerformanceHint'.
    SbkPySide2_QtGuiTypes[SBK_QSTATICTEXT_PERFORMANCEHINT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStaticText_TypeF(),
        "PerformanceHint",
        "2:PySide2.QtGui.QStaticText.PerformanceHint",
        "QStaticText::PerformanceHint");
    if (!SbkPySide2_QtGuiTypes[SBK_QSTATICTEXT_PERFORMANCEHINT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QSTATICTEXT_PERFORMANCEHINT_IDX],
        Sbk_QStaticText_TypeF(), "ModerateCaching", (long) QStaticText::PerformanceHint::ModerateCaching))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QSTATICTEXT_PERFORMANCEHINT_IDX],
        Sbk_QStaticText_TypeF(), "AggressiveCaching", (long) QStaticText::PerformanceHint::AggressiveCaching))
        return;
    // Register converter for enum 'QStaticText::PerformanceHint'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QSTATICTEXT_PERFORMANCEHINT_IDX],
            QStaticText_PerformanceHint_CppToPython_QStaticText_PerformanceHint);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStaticText_PerformanceHint_PythonToCpp_QStaticText_PerformanceHint,
            is_QStaticText_PerformanceHint_PythonToCpp_QStaticText_PerformanceHint_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QSTATICTEXT_PERFORMANCEHINT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStaticText::PerformanceHint");
        Shiboken::Conversions::registerConverterName(converter, "PerformanceHint");
    }
    // End of 'PerformanceHint' enum.

    qRegisterMetaType< ::QStaticText >("QStaticText");
    qRegisterMetaType< ::QStaticText::PerformanceHint >("QStaticText::PerformanceHint");
}
