/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qrawfont_wrapper.h"

// inner classes

// Extra includes
#include <QList>
#include <QVector>
#include <QtGui/qfont.h>
#include <QtGui/qimage.h>
#include <QtGui/qpainterpath.h>
#include <QtGui/qrawfont.h>
#include <QtGui/qtransform.h>
#include <qbytearray.h>
#include <qpoint.h>
#include <qrect.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QRawFont_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QRawFont >()))
        return -1;

    ::QRawFont *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QRawFont.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QRawFont_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:QRawFont", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return -1;


    // Overloaded function decisor
    // 0: QRawFont::QRawFont()
    // 1: QRawFont::QRawFont(QByteArray,qreal,QFont::HintingPreference)
    // 2: QRawFont::QRawFont(QRawFont)
    // 3: QRawFont::QRawFont(QString,qreal,QFont::HintingPreference)
    if (numArgs == 0) {
        overloadId = 0; // QRawFont()
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 3; // QRawFont(QString,qreal,QFont::HintingPreference)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONT_HINTINGPREFERENCE_IDX])->converter, (pyArgs[2])))) {
            overloadId = 3; // QRawFont(QString,qreal,QFont::HintingPreference)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QRawFont(QRawFont)
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 1; // QRawFont(QByteArray,qreal,QFont::HintingPreference)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONT_HINTINGPREFERENCE_IDX])->converter, (pyArgs[2])))) {
            overloadId = 1; // QRawFont(QByteArray,qreal,QFont::HintingPreference)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRawFont_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QRawFont()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QRawFont_Init_TypeError;
            }

            if (!PyErr_Occurred()) {
                // QRawFont()
                cptr = new ::QRawFont();
            }
            break;
        }
        case 1: // QRawFont(const QByteArray & fontData, qreal pixelSize, QFont::HintingPreference hintingPreference)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_hintingPreference = Shiboken::String::createStaticString("hintingPreference");
                if (PyDict_Contains(kwds, key_hintingPreference)) {
                    value = PyDict_GetItem(kwds, key_hintingPreference);
                    if (value && pyArgs[2]) {
                        errInfo = key_hintingPreference;
                        Py_INCREF(errInfo);
                        goto Sbk_QRawFont_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONT_HINTINGPREFERENCE_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QRawFont_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_hintingPreference);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QRawFont_Init_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QByteArray cppArg0_local;
            ::QByteArray *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFont::HintingPreference cppArg2 = QFont::PreferDefaultHinting;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QRawFont(QByteArray,qreal,QFont::HintingPreference)
                cptr = new ::QRawFont(*cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 2: // QRawFont(const QRawFont & other)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QRawFont_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QRawFont cppArg0_local;
            ::QRawFont *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QRawFont(QRawFont)
                cptr = new ::QRawFont(*cppArg0);
            }
            break;
        }
        case 3: // QRawFont(const QString & fileName, qreal pixelSize, QFont::HintingPreference hintingPreference)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_hintingPreference = Shiboken::String::createStaticString("hintingPreference");
                if (PyDict_Contains(kwds, key_hintingPreference)) {
                    value = PyDict_GetItem(kwds, key_hintingPreference);
                    if (value && pyArgs[2]) {
                        errInfo = key_hintingPreference;
                        Py_INCREF(errInfo);
                        goto Sbk_QRawFont_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONT_HINTINGPREFERENCE_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QRawFont_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_hintingPreference);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QRawFont_Init_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QFont::HintingPreference cppArg2 = QFont::PreferDefaultHinting;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // QRawFont(QString,qreal,QFont::HintingPreference)
                cptr = new ::QRawFont(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QRawFont >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QRawFont_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QRawFont_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QRawFontFunc_advancesForGlyphIndexes(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRawFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QRawFont.advancesForGlyphIndexes";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "advancesForGlyphIndexes", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QRawFont::advancesForGlyphIndexes(QVector<quint32>)const
    // 1: QRawFont::advancesForGlyphIndexes(QVector<quint32>,QFlags<QRawFont::LayoutFlag>)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QUINT32_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // advancesForGlyphIndexes(QVector<quint32>)const
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QRAWFONT_LAYOUTFLAG_IDX])->converter, (pyArgs[1])))) {
            overloadId = 1; // advancesForGlyphIndexes(QVector<quint32>,QFlags<QRawFont::LayoutFlag>)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRawFontFunc_advancesForGlyphIndexes_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // advancesForGlyphIndexes(const QVector<quint32 > & glyphIndexes) const
        {
            ::QVector<quint32 > cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // advancesForGlyphIndexes(QVector<quint32>)const
                QVector<QPointF > cppResult = const_cast<const ::QRawFont *>(cppSelf)->advancesForGlyphIndexes(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QPOINTF_IDX], &cppResult);
            }
            break;
        }
        case 1: // advancesForGlyphIndexes(const QVector<quint32 > & glyphIndexes, QFlags<QRawFont::LayoutFlag> layoutFlags) const
        {
            ::QVector<quint32 > cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QFlags<QRawFont::LayoutFlag> cppArg1 = QFlags<QRawFont::LayoutFlag>(0);
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // advancesForGlyphIndexes(QVector<quint32>,QFlags<QRawFont::LayoutFlag>)const
                QVector<QPointF > cppResult = const_cast<const ::QRawFont *>(cppSelf)->advancesForGlyphIndexes(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QPOINTF_IDX], &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QRawFontFunc_advancesForGlyphIndexes_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRawFontFunc_alphaMapForGlyph(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRawFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QRawFont.alphaMapForGlyph";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QRawFontFunc_alphaMapForGlyph_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QRawFontFunc_alphaMapForGlyph_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:alphaMapForGlyph", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QRawFont::alphaMapForGlyph(quint32,QRawFont::AntialiasingType,QTransform)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // alphaMapForGlyph(quint32,QRawFont::AntialiasingType,QTransform)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_ANTIALIASINGTYPE_IDX])->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // alphaMapForGlyph(quint32,QRawFont::AntialiasingType,QTransform)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), (pyArgs[2])))) {
                overloadId = 0; // alphaMapForGlyph(quint32,QRawFont::AntialiasingType,QTransform)const
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRawFontFunc_alphaMapForGlyph_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_antialiasingType = Shiboken::String::createStaticString("antialiasingType");
            if (PyDict_Contains(kwds, key_antialiasingType)) {
                value = PyDict_GetItem(kwds, key_antialiasingType);
                if (value && pyArgs[1]) {
                    errInfo = key_antialiasingType;
                    Py_INCREF(errInfo);
                    goto Sbk_QRawFontFunc_alphaMapForGlyph_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_ANTIALIASINGTYPE_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QRawFontFunc_alphaMapForGlyph_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_antialiasingType);
            }
            static PyObject *const key_transform = Shiboken::String::createStaticString("transform");
            if (PyDict_Contains(kwds, key_transform)) {
                value = PyDict_GetItem(kwds, key_transform);
                if (value && pyArgs[2]) {
                    errInfo = key_transform;
                    Py_INCREF(errInfo);
                    goto Sbk_QRawFontFunc_alphaMapForGlyph_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), (pyArgs[2]))))
                        goto Sbk_QRawFontFunc_alphaMapForGlyph_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_transform);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QRawFontFunc_alphaMapForGlyph_TypeError;
            }
        }
        quint32 cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QRawFont::AntialiasingType cppArg1 = QRawFont::AntialiasingType::SubPixelAntialiasing;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QTransform cppArg2_local = QTransform();
        ::QTransform *cppArg2 = &cppArg2_local;
        if (pythonToCpp[2]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), pythonToCpp[2]))
            pythonToCpp[2](pyArgs[2], &cppArg2_local);
        else
            pythonToCpp[2](pyArgs[2], &cppArg2);
        }

        if (!PyErr_Occurred()) {
            // alphaMapForGlyph(quint32,QRawFont::AntialiasingType,QTransform)const
            QImage cppResult = const_cast<const ::QRawFont *>(cppSelf)->alphaMapForGlyph(cppArg0, cppArg1, *cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QIMAGE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QRawFontFunc_alphaMapForGlyph_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRawFontFunc_ascent(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRawFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QRawFont.ascent";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // ascent()const
            qreal cppResult = const_cast<const ::QRawFont *>(cppSelf)->ascent();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRawFontFunc_averageCharWidth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRawFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QRawFont.averageCharWidth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // averageCharWidth()const
            qreal cppResult = const_cast<const ::QRawFont *>(cppSelf)->averageCharWidth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRawFontFunc_boundingRect(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRawFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QRawFont.boundingRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QRawFont::boundingRect(quint32)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), (pyArg)))) {
        overloadId = 0; // boundingRect(quint32)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRawFontFunc_boundingRect_TypeError;

    // Call function/method
    {
        quint32 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // boundingRect(quint32)const
            QRectF cppResult = const_cast<const ::QRawFont *>(cppSelf)->boundingRect(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QRawFontFunc_boundingRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRawFontFunc_capHeight(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRawFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QRawFont.capHeight";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // capHeight()const
            qreal cppResult = const_cast<const ::QRawFont *>(cppSelf)->capHeight();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRawFontFunc_descent(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRawFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QRawFont.descent";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // descent()const
            qreal cppResult = const_cast<const ::QRawFont *>(cppSelf)->descent();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRawFontFunc_familyName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRawFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QRawFont.familyName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // familyName()const
            QString cppResult = const_cast<const ::QRawFont *>(cppSelf)->familyName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRawFontFunc_fontTable(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRawFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QRawFont.fontTable";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QRawFont::fontTable(const char*)const
    if (Shiboken::String::check(pyArg) && (pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 0; // fontTable(const char*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRawFontFunc_fontTable_TypeError;

    // Call function/method
    {
        const char* cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // fontTable(const char*)const
            QByteArray cppResult = const_cast<const ::QRawFont *>(cppSelf)->fontTable(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QRawFontFunc_fontTable_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRawFontFunc_fromFont(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QRawFont.fromFont";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QRawFontFunc_fromFont_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QRawFontFunc_fromFont_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:fromFont", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QRawFont::fromFont(QFont,QFontDatabase::WritingSystem)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // fromFont(QFont,QFontDatabase::WritingSystem)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // fromFont(QFont,QFontDatabase::WritingSystem)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRawFontFunc_fromFont_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_writingSystem = Shiboken::String::createStaticString("writingSystem");
            if (PyDict_Contains(kwds, key_writingSystem)) {
                value = PyDict_GetItem(kwds, key_writingSystem);
                if (value && pyArgs[1]) {
                    errInfo = key_writingSystem;
                    Py_INCREF(errInfo);
                    goto Sbk_QRawFontFunc_fromFont_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONTDATABASE_WRITINGSYSTEM_IDX])->converter, (pyArgs[1]))))
                        goto Sbk_QRawFontFunc_fromFont_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_writingSystem);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QRawFontFunc_fromFont_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QFont cppArg0_local;
        ::QFont *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QFontDatabase::WritingSystem cppArg1 = QFontDatabase::Any;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // fromFont(QFont,QFontDatabase::WritingSystem)
            QRawFont cppResult = ::QRawFont::fromFont(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QRawFontFunc_fromFont_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRawFontFunc_glyphIndexesForString(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRawFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QRawFont.glyphIndexesForString";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QRawFont::glyphIndexesForString(QString)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // glyphIndexesForString(QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRawFontFunc_glyphIndexesForString_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // glyphIndexesForString(QString)const
            QVector<quint32 > cppResult = const_cast<const ::QRawFont *>(cppSelf)->glyphIndexesForString(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QUINT32_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QRawFontFunc_glyphIndexesForString_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRawFontFunc_hintingPreference(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRawFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QRawFont.hintingPreference";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hintingPreference()const
            QFont::HintingPreference cppResult = const_cast<const ::QRawFont *>(cppSelf)->hintingPreference();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONT_HINTINGPREFERENCE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRawFontFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRawFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QRawFont.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QRawFont *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRawFontFunc_leading(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRawFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QRawFont.leading";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // leading()const
            qreal cppResult = const_cast<const ::QRawFont *>(cppSelf)->leading();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRawFontFunc_lineThickness(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRawFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QRawFont.lineThickness";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lineThickness()const
            qreal cppResult = const_cast<const ::QRawFont *>(cppSelf)->lineThickness();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRawFontFunc_loadFromData(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRawFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QRawFont.loadFromData";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "loadFromData", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QRawFont::loadFromData(QByteArray,qreal,QFont::HintingPreference)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONT_HINTINGPREFERENCE_IDX])->converter, (pyArgs[2])))) {
        overloadId = 0; // loadFromData(QByteArray,qreal,QFont::HintingPreference)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRawFontFunc_loadFromData_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        qreal cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QFont::HintingPreference cppArg2{QFont::PreferDefaultHinting};
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // loadFromData(QByteArray,qreal,QFont::HintingPreference)
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            cppSelf->loadFromData(*cppArg0, cppArg1, cppArg2);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QRawFontFunc_loadFromData_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRawFontFunc_loadFromFile(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRawFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QRawFont.loadFromFile";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "loadFromFile", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QRawFont::loadFromFile(QString,qreal,QFont::HintingPreference)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONT_HINTINGPREFERENCE_IDX])->converter, (pyArgs[2])))) {
        overloadId = 0; // loadFromFile(QString,qreal,QFont::HintingPreference)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRawFontFunc_loadFromFile_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        qreal cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QFont::HintingPreference cppArg2{QFont::PreferDefaultHinting};
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // loadFromFile(QString,qreal,QFont::HintingPreference)
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            cppSelf->loadFromFile(cppArg0, cppArg1, cppArg2);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QRawFontFunc_loadFromFile_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRawFontFunc_maxCharWidth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRawFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QRawFont.maxCharWidth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maxCharWidth()const
            qreal cppResult = const_cast<const ::QRawFont *>(cppSelf)->maxCharWidth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRawFontFunc_pathForGlyph(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRawFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QRawFont.pathForGlyph";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QRawFont::pathForGlyph(quint32)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), (pyArg)))) {
        overloadId = 0; // pathForGlyph(quint32)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRawFontFunc_pathForGlyph_TypeError;

    // Call function/method
    {
        quint32 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // pathForGlyph(quint32)const
            QPainterPath cppResult = const_cast<const ::QRawFont *>(cppSelf)->pathForGlyph(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QRawFontFunc_pathForGlyph_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRawFontFunc_pixelSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRawFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QRawFont.pixelSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pixelSize()const
            qreal cppResult = const_cast<const ::QRawFont *>(cppSelf)->pixelSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRawFontFunc_setPixelSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRawFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QRawFont.setPixelSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QRawFont::setPixelSize(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setPixelSize(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRawFontFunc_setPixelSize_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPixelSize(qreal)
            cppSelf->setPixelSize(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QRawFontFunc_setPixelSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRawFontFunc_style(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRawFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QRawFont.style";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // style()const
            QFont::Style cppResult = const_cast<const ::QRawFont *>(cppSelf)->style();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFONT_STYLE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRawFontFunc_styleName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRawFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QRawFont.styleName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // styleName()const
            QString cppResult = const_cast<const ::QRawFont *>(cppSelf)->styleName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRawFontFunc_supportedWritingSystems(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRawFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QRawFont.supportedWritingSystems";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedWritingSystems()const
            QList<QFontDatabase::WritingSystem > cppResult = const_cast<const ::QRawFont *>(cppSelf)->supportedWritingSystems();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QLIST_QFONTDATABASE_WRITINGSYSTEM_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRawFontFunc_supportsCharacter(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRawFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QRawFont.supportsCharacter";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QRawFont::supportsCharacter(QChar)const
    // 1: QRawFont::supportsCharacter(uint)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArg)))) {
        overloadId = 1; // supportsCharacter(uint)const
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QCHAR_IDX], (pyArg)))) {
        overloadId = 0; // supportsCharacter(QChar)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRawFontFunc_supportsCharacter_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // supportsCharacter(QChar character) const
        {
            ::QChar cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // supportsCharacter(QChar)const
                bool cppResult = const_cast<const ::QRawFont *>(cppSelf)->supportsCharacter(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // supportsCharacter(uint ucs4) const
        {
            uint cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // supportsCharacter(uint)const
                bool cppResult = const_cast<const ::QRawFont *>(cppSelf)->supportsCharacter(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QRawFontFunc_supportsCharacter_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRawFontFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRawFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QRawFont.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QRawFont::swap(QRawFont&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QRawFont&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QRawFontFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QRawFont cppArg0_local;
        ::QRawFont *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QRawFont&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QRawFontFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QRawFontFunc_underlinePosition(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRawFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QRawFont.underlinePosition";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // underlinePosition()const
            qreal cppResult = const_cast<const ::QRawFont *>(cppSelf)->underlinePosition();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRawFontFunc_unitsPerEm(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRawFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QRawFont.unitsPerEm";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // unitsPerEm()const
            qreal cppResult = const_cast<const ::QRawFont *>(cppSelf)->unitsPerEm();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRawFontFunc_weight(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRawFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QRawFont.weight";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // weight()const
            int cppResult = const_cast<const ::QRawFont *>(cppSelf)->weight();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRawFontFunc_xHeight(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QRawFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QRawFont.xHeight";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // xHeight()const
            qreal cppResult = const_cast<const ::QRawFont *>(cppSelf)->xHeight();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QRawFont___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QRawFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QRawFont_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QRawFont_methods[] = {
    {"advancesForGlyphIndexes", reinterpret_cast<PyCFunction>(Sbk_QRawFontFunc_advancesForGlyphIndexes), METH_VARARGS},
    {"alphaMapForGlyph", reinterpret_cast<PyCFunction>(Sbk_QRawFontFunc_alphaMapForGlyph), METH_VARARGS|METH_KEYWORDS},
    {"ascent", reinterpret_cast<PyCFunction>(Sbk_QRawFontFunc_ascent), METH_NOARGS},
    {"averageCharWidth", reinterpret_cast<PyCFunction>(Sbk_QRawFontFunc_averageCharWidth), METH_NOARGS},
    {"boundingRect", reinterpret_cast<PyCFunction>(Sbk_QRawFontFunc_boundingRect), METH_O},
    {"capHeight", reinterpret_cast<PyCFunction>(Sbk_QRawFontFunc_capHeight), METH_NOARGS},
    {"descent", reinterpret_cast<PyCFunction>(Sbk_QRawFontFunc_descent), METH_NOARGS},
    {"familyName", reinterpret_cast<PyCFunction>(Sbk_QRawFontFunc_familyName), METH_NOARGS},
    {"fontTable", reinterpret_cast<PyCFunction>(Sbk_QRawFontFunc_fontTable), METH_O},
    {"fromFont", reinterpret_cast<PyCFunction>(Sbk_QRawFontFunc_fromFont), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"glyphIndexesForString", reinterpret_cast<PyCFunction>(Sbk_QRawFontFunc_glyphIndexesForString), METH_O},
    {"hintingPreference", reinterpret_cast<PyCFunction>(Sbk_QRawFontFunc_hintingPreference), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QRawFontFunc_isValid), METH_NOARGS},
    {"leading", reinterpret_cast<PyCFunction>(Sbk_QRawFontFunc_leading), METH_NOARGS},
    {"lineThickness", reinterpret_cast<PyCFunction>(Sbk_QRawFontFunc_lineThickness), METH_NOARGS},
    {"loadFromData", reinterpret_cast<PyCFunction>(Sbk_QRawFontFunc_loadFromData), METH_VARARGS},
    {"loadFromFile", reinterpret_cast<PyCFunction>(Sbk_QRawFontFunc_loadFromFile), METH_VARARGS},
    {"maxCharWidth", reinterpret_cast<PyCFunction>(Sbk_QRawFontFunc_maxCharWidth), METH_NOARGS},
    {"pathForGlyph", reinterpret_cast<PyCFunction>(Sbk_QRawFontFunc_pathForGlyph), METH_O},
    {"pixelSize", reinterpret_cast<PyCFunction>(Sbk_QRawFontFunc_pixelSize), METH_NOARGS},
    {"setPixelSize", reinterpret_cast<PyCFunction>(Sbk_QRawFontFunc_setPixelSize), METH_O},
    {"style", reinterpret_cast<PyCFunction>(Sbk_QRawFontFunc_style), METH_NOARGS},
    {"styleName", reinterpret_cast<PyCFunction>(Sbk_QRawFontFunc_styleName), METH_NOARGS},
    {"supportedWritingSystems", reinterpret_cast<PyCFunction>(Sbk_QRawFontFunc_supportedWritingSystems), METH_NOARGS},
    {"supportsCharacter", reinterpret_cast<PyCFunction>(Sbk_QRawFontFunc_supportsCharacter), METH_O},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QRawFontFunc_swap), METH_O},
    {"underlinePosition", reinterpret_cast<PyCFunction>(Sbk_QRawFontFunc_underlinePosition), METH_NOARGS},
    {"unitsPerEm", reinterpret_cast<PyCFunction>(Sbk_QRawFontFunc_unitsPerEm), METH_NOARGS},
    {"weight", reinterpret_cast<PyCFunction>(Sbk_QRawFontFunc_weight), METH_NOARGS},
    {"xHeight", reinterpret_cast<PyCFunction>(Sbk_QRawFontFunc_xHeight), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QRawFont___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QRawFont_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QRawFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX]), (pyArg)))) {
                // operator!=(const QRawFont & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QRawFont cppArg0_local;
                ::QRawFont *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX]), (pyArg)))) {
                // operator==(const QRawFont & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QRawFont cppArg0_local;
                ::QRawFont *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QRawFont_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QRawFont_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QRawFont_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QRawFont_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QRawFont_Type = nullptr;
static SbkObjectType *Sbk_QRawFont_TypeF(void)
{
    return _Sbk_QRawFont_Type;
}

static PyType_Slot Sbk_QRawFont_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QRawFont_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QRawFont_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QRawFont_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QRawFont_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QRawFont_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QRawFont_spec = {
    "2:PySide2.QtGui.QRawFont",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QRawFont_slots
};

} //extern "C"

PyObject *SbkPySide2_QtGui_QRawFont_LayoutFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::QRawFont::LayoutFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QRawFont::LayoutFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QRawFont::LayoutFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QRawFont::LayoutFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QRawFont::LayoutFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QRAWFONT_LAYOUTFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QRawFont_LayoutFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::QRawFont::LayoutFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QRawFont::LayoutFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QRawFont::LayoutFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QRawFont::LayoutFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QRawFont::LayoutFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QRAWFONT_LAYOUTFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QRawFont_LayoutFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QRawFont::LayoutFlags cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QRawFont::LayoutFlags>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QRawFont::LayoutFlags>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QRawFont::LayoutFlags>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QRawFont::LayoutFlags>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QRAWFONT_LAYOUTFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtGui_QRawFont_LayoutFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QRawFont::LayoutFlags cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QRAWFONT_LAYOUTFLAG_IDX])->converter, self, &cppSelf);
    ::QRawFont::LayoutFlags cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QRAWFONT_LAYOUTFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtGui_QRawFont_LayoutFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QRAWFONT_LAYOUTFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtGui_QRawFont_LayoutFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QRAWFONT_LAYOUTFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtGui_QRawFont_LayoutFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtGui_QRawFont_LayoutFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtGui_QRawFont_LayoutFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtGui_QRawFont_LayoutFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtGui_QRawFont_LayoutFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtGui_QRawFont_LayoutFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtGui_QRawFont_LayoutFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtGui_QRawFont_LayoutFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtGui_QRawFont_LayoutFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtGui_QRawFont_LayoutFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtGui_QRawFont_LayoutFlag_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QRawFont_AntialiasingType_PythonToCpp_QRawFont_AntialiasingType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QRawFont::AntialiasingType *>(cppOut) =
        static_cast<::QRawFont::AntialiasingType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QRawFont_AntialiasingType_PythonToCpp_QRawFont_AntialiasingType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QRAWFONT_ANTIALIASINGTYPE_IDX]))
        return QRawFont_AntialiasingType_PythonToCpp_QRawFont_AntialiasingType;
    return {};
}
static PyObject *QRawFont_AntialiasingType_CppToPython_QRawFont_AntialiasingType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QRawFont::AntialiasingType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_ANTIALIASINGTYPE_IDX], castCppIn);

}

static void QRawFont_LayoutFlag_PythonToCpp_QRawFont_LayoutFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QRawFont::LayoutFlag *>(cppOut) =
        static_cast<::QRawFont::LayoutFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QRawFont_LayoutFlag_PythonToCpp_QRawFont_LayoutFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QRAWFONT_LAYOUTFLAG_IDX]))
        return QRawFont_LayoutFlag_PythonToCpp_QRawFont_LayoutFlag;
    return {};
}
static PyObject *QRawFont_LayoutFlag_CppToPython_QRawFont_LayoutFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QRawFont::LayoutFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_LAYOUTFLAG_IDX], castCppIn);

}

static void QFlags_QRawFont_LayoutFlag__PythonToCpp_QFlags_QRawFont_LayoutFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QRawFont::LayoutFlag> *>(cppOut) =
        ::QFlags<QRawFont::LayoutFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QRawFont_LayoutFlag__PythonToCpp_QFlags_QRawFont_LayoutFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QFLAGS_QRAWFONT_LAYOUTFLAG_IDX]))
        return QFlags_QRawFont_LayoutFlag__PythonToCpp_QFlags_QRawFont_LayoutFlag_;
    return {};
}
static PyObject *QFlags_QRawFont_LayoutFlag__CppToPython_QFlags_QRawFont_LayoutFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QRawFont::LayoutFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtGuiTypes[SBK_QFLAGS_QRAWFONT_LAYOUTFLAG_IDX]));

}

static void QRawFont_LayoutFlag_PythonToCpp_QFlags_QRawFont_LayoutFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QRawFont::LayoutFlag> *>(cppOut) =
        ::QFlags<QRawFont::LayoutFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QRawFont_LayoutFlag_PythonToCpp_QFlags_QRawFont_LayoutFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QRAWFONT_LAYOUTFLAG_IDX]))
        return QRawFont_LayoutFlag_PythonToCpp_QFlags_QRawFont_LayoutFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_QRawFont_LayoutFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QRawFont::LayoutFlag> *>(cppOut) =
        ::QFlags<QRawFont::LayoutFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QRawFont_LayoutFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QRAWFONT_LAYOUTFLAG_IDX]))
        return number_PythonToCpp_QFlags_QRawFont_LayoutFlag_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QRawFont_PythonToCpp_QRawFont_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QRawFont_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QRawFont_PythonToCpp_QRawFont_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QRawFont_TypeF())))
        return QRawFont_PythonToCpp_QRawFont_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QRawFont_PTR_CppToPython_QRawFont(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QRawFont *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QRawFont_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QRawFont_COPY_CppToPython_QRawFont(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QRawFont_TypeF(), new ::QRawFont(*reinterpret_cast<const ::QRawFont *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QRawFont_PythonToCpp_QRawFont_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QRawFont *>(cppOut) = *reinterpret_cast< ::QRawFont *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QRawFont_PythonToCpp_QRawFont_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QRawFont_TypeF())))
        return QRawFont_PythonToCpp_QRawFont_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QRawFont_SignatureStrings[] = {
    "3:PySide2.QtGui.QRawFont(self)",
    "2:PySide2.QtGui.QRawFont(self,fontData:PySide2.QtCore.QByteArray,pixelSize:qreal,hintingPreference:PySide2.QtGui.QFont.HintingPreference=QFont.PreferDefaultHinting)",
    "1:PySide2.QtGui.QRawFont(self,other:PySide2.QtGui.QRawFont)",
    "0:PySide2.QtGui.QRawFont(self,fileName:QString,pixelSize:qreal,hintingPreference:PySide2.QtGui.QFont.HintingPreference=QFont.PreferDefaultHinting)",
    "1:PySide2.QtGui.QRawFont.advancesForGlyphIndexes(self,glyphIndexes:QVector[quint32])->QVector[PySide2.QtCore.QPointF]",
    "0:PySide2.QtGui.QRawFont.advancesForGlyphIndexes(self,glyphIndexes:QVector[quint32],layoutFlags:PySide2.QtGui.QRawFont.LayoutFlags)->QVector[PySide2.QtCore.QPointF]",
    "PySide2.QtGui.QRawFont.alphaMapForGlyph(self,glyphIndex:quint32,antialiasingType:PySide2.QtGui.QRawFont.AntialiasingType=SubPixelAntialiasing,transform:PySide2.QtGui.QTransform=QTransform())->PySide2.QtGui.QImage",
    "PySide2.QtGui.QRawFont.ascent(self)->qreal",
    "PySide2.QtGui.QRawFont.averageCharWidth(self)->qreal",
    "PySide2.QtGui.QRawFont.boundingRect(self,glyphIndex:quint32)->PySide2.QtCore.QRectF",
    "PySide2.QtGui.QRawFont.capHeight(self)->qreal",
    "PySide2.QtGui.QRawFont.descent(self)->qreal",
    "PySide2.QtGui.QRawFont.familyName(self)->QString",
    "PySide2.QtGui.QRawFont.fontTable(self,tagName:char*)->PySide2.QtCore.QByteArray",
    "PySide2.QtGui.QRawFont.fromFont(font:PySide2.QtGui.QFont,writingSystem:PySide2.QtGui.QFontDatabase.WritingSystem=QFontDatabase.Any)->PySide2.QtGui.QRawFont",
    "PySide2.QtGui.QRawFont.glyphIndexesForString(self,text:QString)->QVector[quint32]",
    "PySide2.QtGui.QRawFont.hintingPreference(self)->PySide2.QtGui.QFont.HintingPreference",
    "PySide2.QtGui.QRawFont.isValid(self)->bool",
    "PySide2.QtGui.QRawFont.leading(self)->qreal",
    "PySide2.QtGui.QRawFont.lineThickness(self)->qreal",
    "PySide2.QtGui.QRawFont.loadFromData(self,fontData:PySide2.QtCore.QByteArray,pixelSize:qreal,hintingPreference:PySide2.QtGui.QFont.HintingPreference)",
    "PySide2.QtGui.QRawFont.loadFromFile(self,fileName:QString,pixelSize:qreal,hintingPreference:PySide2.QtGui.QFont.HintingPreference)",
    "PySide2.QtGui.QRawFont.maxCharWidth(self)->qreal",
    "PySide2.QtGui.QRawFont.pathForGlyph(self,glyphIndex:quint32)->PySide2.QtGui.QPainterPath",
    "PySide2.QtGui.QRawFont.pixelSize(self)->qreal",
    "PySide2.QtGui.QRawFont.setPixelSize(self,pixelSize:qreal)",
    "PySide2.QtGui.QRawFont.style(self)->PySide2.QtGui.QFont.Style",
    "PySide2.QtGui.QRawFont.styleName(self)->QString",
    "PySide2.QtGui.QRawFont.supportedWritingSystems(self)->QList[PySide2.QtGui.QFontDatabase.WritingSystem]",
    "1:PySide2.QtGui.QRawFont.supportsCharacter(self,character:QChar)->bool",
    "0:PySide2.QtGui.QRawFont.supportsCharacter(self,ucs4:uint)->bool",
    "PySide2.QtGui.QRawFont.swap(self,other:PySide2.QtGui.QRawFont)",
    "PySide2.QtGui.QRawFont.underlinePosition(self)->qreal",
    "PySide2.QtGui.QRawFont.unitsPerEm(self)->qreal",
    "PySide2.QtGui.QRawFont.weight(self)->int",
    "PySide2.QtGui.QRawFont.xHeight(self)->qreal",
    "PySide2.QtGui.QRawFont.__copy__()",
    nullptr}; // Sentinel

void init_QRawFont(PyObject *module)
{
    _Sbk_QRawFont_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QRawFont",
        "QRawFont",
        &Sbk_QRawFont_spec,
        &Shiboken::callCppDestructor< ::QRawFont >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QRawFont_Type);
    InitSignatureStrings(pyType, QRawFont_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QRawFont_Type), Sbk_QRawFont_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QRAWFONT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QRawFont_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QRawFont_TypeF(),
        QRawFont_PythonToCpp_QRawFont_PTR,
        is_QRawFont_PythonToCpp_QRawFont_PTR_Convertible,
        QRawFont_PTR_CppToPython_QRawFont,
        QRawFont_COPY_CppToPython_QRawFont);

    Shiboken::Conversions::registerConverterName(converter, "QRawFont");
    Shiboken::Conversions::registerConverterName(converter, "QRawFont*");
    Shiboken::Conversions::registerConverterName(converter, "QRawFont&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QRawFont).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QRawFont_PythonToCpp_QRawFont_COPY,
        is_QRawFont_PythonToCpp_QRawFont_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'AntialiasingType'.
    SbkPySide2_QtGuiTypes[SBK_QRAWFONT_ANTIALIASINGTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QRawFont_TypeF(),
        "AntialiasingType",
        "2:PySide2.QtGui.QRawFont.AntialiasingType",
        "QRawFont::AntialiasingType");
    if (!SbkPySide2_QtGuiTypes[SBK_QRAWFONT_ANTIALIASINGTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_ANTIALIASINGTYPE_IDX],
        Sbk_QRawFont_TypeF(), "PixelAntialiasing", (long) QRawFont::AntialiasingType::PixelAntialiasing))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_ANTIALIASINGTYPE_IDX],
        Sbk_QRawFont_TypeF(), "SubPixelAntialiasing", (long) QRawFont::AntialiasingType::SubPixelAntialiasing))
        return;
    // Register converter for enum 'QRawFont::AntialiasingType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_ANTIALIASINGTYPE_IDX],
            QRawFont_AntialiasingType_CppToPython_QRawFont_AntialiasingType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QRawFont_AntialiasingType_PythonToCpp_QRawFont_AntialiasingType,
            is_QRawFont_AntialiasingType_PythonToCpp_QRawFont_AntialiasingType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_ANTIALIASINGTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QRawFont::AntialiasingType");
        Shiboken::Conversions::registerConverterName(converter, "AntialiasingType");
    }
    // End of 'AntialiasingType' enum.

    // Initialization of enum 'LayoutFlag'.
    SbkPySide2_QtGuiTypes[SBK_QFLAGS_QRAWFONT_LAYOUTFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtGui.QRawFont.LayoutFlags", SbkPySide2_QtGui_QRawFont_LayoutFlag_number_slots);
    SbkPySide2_QtGuiTypes[SBK_QRAWFONT_LAYOUTFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QRawFont_TypeF(),
        "LayoutFlag",
        "2:PySide2.QtGui.QRawFont.LayoutFlag",
        "QRawFont::LayoutFlag",
        SbkPySide2_QtGuiTypes[SBK_QFLAGS_QRAWFONT_LAYOUTFLAG_IDX]);
    if (!SbkPySide2_QtGuiTypes[SBK_QRAWFONT_LAYOUTFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_LAYOUTFLAG_IDX],
        Sbk_QRawFont_TypeF(), "SeparateAdvances", (long) QRawFont::LayoutFlag::SeparateAdvances))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_LAYOUTFLAG_IDX],
        Sbk_QRawFont_TypeF(), "KernedAdvances", (long) QRawFont::LayoutFlag::KernedAdvances))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_LAYOUTFLAG_IDX],
        Sbk_QRawFont_TypeF(), "UseDesignMetrics", (long) QRawFont::LayoutFlag::UseDesignMetrics))
        return;
    // Register converter for enum 'QRawFont::LayoutFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_LAYOUTFLAG_IDX],
            QRawFont_LayoutFlag_CppToPython_QRawFont_LayoutFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QRawFont_LayoutFlag_PythonToCpp_QRawFont_LayoutFlag,
            is_QRawFont_LayoutFlag_PythonToCpp_QRawFont_LayoutFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QRAWFONT_LAYOUTFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QRawFont::LayoutFlag");
        Shiboken::Conversions::registerConverterName(converter, "LayoutFlag");
    }
    // Register converter for flag 'QFlags<QRawFont::LayoutFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QRAWFONT_LAYOUTFLAG_IDX],
            QFlags_QRawFont_LayoutFlag__CppToPython_QFlags_QRawFont_LayoutFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QRawFont_LayoutFlag_PythonToCpp_QFlags_QRawFont_LayoutFlag_,
            is_QRawFont_LayoutFlag_PythonToCpp_QFlags_QRawFont_LayoutFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QRawFont_LayoutFlag__PythonToCpp_QFlags_QRawFont_LayoutFlag_,
            is_QFlags_QRawFont_LayoutFlag__PythonToCpp_QFlags_QRawFont_LayoutFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QRawFont_LayoutFlag_,
            is_number_PythonToCpp_QFlags_QRawFont_LayoutFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QRAWFONT_LAYOUTFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QRawFont::LayoutFlags");
        Shiboken::Conversions::registerConverterName(converter, "LayoutFlags");
    }
    // End of 'LayoutFlag' enum/flags.

    qRegisterMetaType< ::QRawFont >("QRawFont");
    qRegisterMetaType< ::QRawFont::AntialiasingType >("QRawFont::AntialiasingType");
    qRegisterMetaType< ::QRawFont::LayoutFlag >("QRawFont::LayoutFlag");
    qRegisterMetaType< ::QRawFont::LayoutFlags >("QRawFont::LayoutFlags");
}
