/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qpixelformat_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QPixelFormat_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QPixelFormat >()))
        return -1;

    ::QPixelFormat *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixelFormat.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 13) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPixelFormat_Init_TypeError;
    } else if (numArgs == 2 || numArgs == 3 || numArgs == 4 || numArgs == 5 || numArgs == 6 || numArgs == 7 || numArgs == 8 || numArgs == 9 || numArgs == 10)
        goto Sbk_QPixelFormat_Init_TypeError;

    if (!PyArg_ParseTuple(args, "|OOOOOOOOOOOOO:QPixelFormat", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8]), &(pyArgs[9]), &(pyArgs[10]), &(pyArgs[11]), &(pyArgs[12])))
        return -1;


    // Overloaded function decisor
    // 0: QPixelFormat::QPixelFormat()
    // 1: QPixelFormat::QPixelFormat(QPixelFormat::ColorModel,uchar,uchar,uchar,uchar,uchar,uchar,QPixelFormat::AlphaUsage,QPixelFormat::AlphaPosition,QPixelFormat::AlphaPremultiplied,QPixelFormat::TypeInterpretation,QPixelFormat::ByteOrder,uchar)
    // 2: QPixelFormat::QPixelFormat(QPixelFormat)
    if (numArgs == 0) {
        overloadId = 0; // QPixelFormat()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QPixelFormat(QPixelFormat)
    } else if (numArgs >= 11
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_COLORMODEL_IDX])->converter, (pyArgs[0])))
        && SbkChar_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uchar>(), (pyArgs[1])))
        && SbkChar_Check(pyArgs[2]) && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uchar>(), (pyArgs[2])))
        && SbkChar_Check(pyArgs[3]) && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uchar>(), (pyArgs[3])))
        && SbkChar_Check(pyArgs[4]) && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uchar>(), (pyArgs[4])))
        && SbkChar_Check(pyArgs[5]) && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uchar>(), (pyArgs[5])))
        && SbkChar_Check(pyArgs[6]) && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uchar>(), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_ALPHAUSAGE_IDX])->converter, (pyArgs[7])))
        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_ALPHAPOSITION_IDX])->converter, (pyArgs[8])))
        && (pythonToCpp[9] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_ALPHAPREMULTIPLIED_IDX])->converter, (pyArgs[9])))
        && (pythonToCpp[10] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_TYPEINTERPRETATION_IDX])->converter, (pyArgs[10])))) {
        if (numArgs == 11) {
            overloadId = 1; // QPixelFormat(QPixelFormat::ColorModel,uchar,uchar,uchar,uchar,uchar,uchar,QPixelFormat::AlphaUsage,QPixelFormat::AlphaPosition,QPixelFormat::AlphaPremultiplied,QPixelFormat::TypeInterpretation,QPixelFormat::ByteOrder,uchar)
        } else if (numArgs >= 12
            && (pythonToCpp[11] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_BYTEORDER_IDX])->converter, (pyArgs[11])))) {
            if (numArgs == 12) {
                overloadId = 1; // QPixelFormat(QPixelFormat::ColorModel,uchar,uchar,uchar,uchar,uchar,uchar,QPixelFormat::AlphaUsage,QPixelFormat::AlphaPosition,QPixelFormat::AlphaPremultiplied,QPixelFormat::TypeInterpretation,QPixelFormat::ByteOrder,uchar)
            } else if (numArgs >= 13
                && SbkChar_Check(pyArgs[12]) && (pythonToCpp[12] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uchar>(), (pyArgs[12])))) {
                overloadId = 1; // QPixelFormat(QPixelFormat::ColorModel,uchar,uchar,uchar,uchar,uchar,uchar,QPixelFormat::AlphaUsage,QPixelFormat::AlphaPosition,QPixelFormat::AlphaPremultiplied,QPixelFormat::TypeInterpretation,QPixelFormat::ByteOrder,uchar)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPixelFormat_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QPixelFormat()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QPixelFormat_Init_TypeError;
            }

            if (!PyErr_Occurred()) {
                // QPixelFormat()
                cptr = new ::QPixelFormat();
            }
            break;
        }
        case 1: // QPixelFormat(QPixelFormat::ColorModel colorModel, uchar firstSize, uchar secondSize, uchar thirdSize, uchar fourthSize, uchar fifthSize, uchar alphaSize, QPixelFormat::AlphaUsage alphaUsage, QPixelFormat::AlphaPosition alphaPosition, QPixelFormat::AlphaPremultiplied premultiplied, QPixelFormat::TypeInterpretation typeInterpretation, QPixelFormat::ByteOrder byteOrder, uchar subEnum)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_byteOrder = Shiboken::String::createStaticString("byteOrder");
                if (PyDict_Contains(kwds, key_byteOrder)) {
                    value = PyDict_GetItem(kwds, key_byteOrder);
                    if (value && pyArgs[11]) {
                        errInfo = key_byteOrder;
                        Py_INCREF(errInfo);
                        goto Sbk_QPixelFormat_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[11] = value;
                        if (!(pythonToCpp[11] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_BYTEORDER_IDX])->converter, (pyArgs[11]))))
                            goto Sbk_QPixelFormat_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_byteOrder);
                }
                static PyObject *const key_subEnum = Shiboken::String::createStaticString("subEnum");
                if (PyDict_Contains(kwds, key_subEnum)) {
                    value = PyDict_GetItem(kwds, key_subEnum);
                    if (value && pyArgs[12]) {
                        errInfo = key_subEnum;
                        Py_INCREF(errInfo);
                        goto Sbk_QPixelFormat_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[12] = value;
                        if (!SbkChar_Check(pyArgs[12]) && (pythonToCpp[12] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uchar>(), (pyArgs[12]))))
                            goto Sbk_QPixelFormat_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_subEnum);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPixelFormat_Init_TypeError;
                }
            }
            ::QPixelFormat::ColorModel cppArg0{QPixelFormat::RGB};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            uchar cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            uchar cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            uchar cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            uchar cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);
            uchar cppArg5;
            pythonToCpp[5](pyArgs[5], &cppArg5);
            uchar cppArg6;
            pythonToCpp[6](pyArgs[6], &cppArg6);
            ::QPixelFormat::AlphaUsage cppArg7{QPixelFormat::UsesAlpha};
            pythonToCpp[7](pyArgs[7], &cppArg7);
            ::QPixelFormat::AlphaPosition cppArg8{QPixelFormat::AtBeginning};
            pythonToCpp[8](pyArgs[8], &cppArg8);
            ::QPixelFormat::AlphaPremultiplied cppArg9{QPixelFormat::NotPremultiplied};
            pythonToCpp[9](pyArgs[9], &cppArg9);
            ::QPixelFormat::TypeInterpretation cppArg10{QPixelFormat::UnsignedInteger};
            pythonToCpp[10](pyArgs[10], &cppArg10);
            ::QPixelFormat::ByteOrder cppArg11 = QPixelFormat::ByteOrder::CurrentSystemEndian;
            if (pythonToCpp[11]) pythonToCpp[11](pyArgs[11], &cppArg11);
            uchar cppArg12 = 0;
            if (pythonToCpp[12]) pythonToCpp[12](pyArgs[12], &cppArg12);

            if (!PyErr_Occurred()) {
                // QPixelFormat(QPixelFormat::ColorModel,uchar,uchar,uchar,uchar,uchar,uchar,QPixelFormat::AlphaUsage,QPixelFormat::AlphaPosition,QPixelFormat::AlphaPremultiplied,QPixelFormat::TypeInterpretation,QPixelFormat::ByteOrder,uchar)
                cptr = new ::QPixelFormat(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8, cppArg9, cppArg10, cppArg11, cppArg12);
            }
            break;
        }
        case 2: // QPixelFormat(const QPixelFormat & QPixelFormat)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QPixelFormat_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QPixelFormat cppArg0_local;
            ::QPixelFormat *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QPixelFormat(QPixelFormat)
                cptr = new ::QPixelFormat(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QPixelFormat >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QPixelFormat_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QPixelFormat_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QPixelFormatFunc_alphaPosition(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixelFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixelFormat.alphaPosition";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // alphaPosition()const
            QPixelFormat::AlphaPosition cppResult = const_cast<const ::QPixelFormat *>(cppSelf)->alphaPosition();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_ALPHAPOSITION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPixelFormatFunc_alphaSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixelFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixelFormat.alphaSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // alphaSize()const
            uchar cppResult = const_cast<const ::QPixelFormat *>(cppSelf)->alphaSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uchar>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPixelFormatFunc_alphaUsage(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixelFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixelFormat.alphaUsage";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // alphaUsage()const
            QPixelFormat::AlphaUsage cppResult = const_cast<const ::QPixelFormat *>(cppSelf)->alphaUsage();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_ALPHAUSAGE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPixelFormatFunc_bitsPerPixel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixelFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixelFormat.bitsPerPixel";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // bitsPerPixel()const
            uchar cppResult = const_cast<const ::QPixelFormat *>(cppSelf)->bitsPerPixel();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uchar>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPixelFormatFunc_blackSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixelFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixelFormat.blackSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // blackSize()const
            uchar cppResult = const_cast<const ::QPixelFormat *>(cppSelf)->blackSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uchar>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPixelFormatFunc_blueSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixelFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixelFormat.blueSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // blueSize()const
            uchar cppResult = const_cast<const ::QPixelFormat *>(cppSelf)->blueSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uchar>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPixelFormatFunc_brightnessSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixelFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixelFormat.brightnessSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // brightnessSize()const
            uchar cppResult = const_cast<const ::QPixelFormat *>(cppSelf)->brightnessSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uchar>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPixelFormatFunc_byteOrder(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixelFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixelFormat.byteOrder";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // byteOrder()const
            QPixelFormat::ByteOrder cppResult = const_cast<const ::QPixelFormat *>(cppSelf)->byteOrder();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_BYTEORDER_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPixelFormatFunc_channelCount(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixelFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixelFormat.channelCount";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // channelCount()const
            uchar cppResult = const_cast<const ::QPixelFormat *>(cppSelf)->channelCount();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uchar>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPixelFormatFunc_colorModel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixelFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixelFormat.colorModel";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // colorModel()const
            QPixelFormat::ColorModel cppResult = const_cast<const ::QPixelFormat *>(cppSelf)->colorModel();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_COLORMODEL_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPixelFormatFunc_cyanSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixelFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixelFormat.cyanSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // cyanSize()const
            uchar cppResult = const_cast<const ::QPixelFormat *>(cppSelf)->cyanSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uchar>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPixelFormatFunc_greenSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixelFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixelFormat.greenSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // greenSize()const
            uchar cppResult = const_cast<const ::QPixelFormat *>(cppSelf)->greenSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uchar>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPixelFormatFunc_hueSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixelFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixelFormat.hueSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hueSize()const
            uchar cppResult = const_cast<const ::QPixelFormat *>(cppSelf)->hueSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uchar>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPixelFormatFunc_lightnessSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixelFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixelFormat.lightnessSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // lightnessSize()const
            uchar cppResult = const_cast<const ::QPixelFormat *>(cppSelf)->lightnessSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uchar>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPixelFormatFunc_magentaSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixelFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixelFormat.magentaSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // magentaSize()const
            uchar cppResult = const_cast<const ::QPixelFormat *>(cppSelf)->magentaSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uchar>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPixelFormatFunc_premultiplied(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixelFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixelFormat.premultiplied";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // premultiplied()const
            QPixelFormat::AlphaPremultiplied cppResult = const_cast<const ::QPixelFormat *>(cppSelf)->premultiplied();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_ALPHAPREMULTIPLIED_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPixelFormatFunc_redSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixelFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixelFormat.redSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // redSize()const
            uchar cppResult = const_cast<const ::QPixelFormat *>(cppSelf)->redSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uchar>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPixelFormatFunc_saturationSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixelFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixelFormat.saturationSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // saturationSize()const
            uchar cppResult = const_cast<const ::QPixelFormat *>(cppSelf)->saturationSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uchar>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPixelFormatFunc_subEnum(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixelFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixelFormat.subEnum";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // subEnum()const
            uchar cppResult = const_cast<const ::QPixelFormat *>(cppSelf)->subEnum();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uchar>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPixelFormatFunc_typeInterpretation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixelFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixelFormat.typeInterpretation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // typeInterpretation()const
            QPixelFormat::TypeInterpretation cppResult = const_cast<const ::QPixelFormat *>(cppSelf)->typeInterpretation();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_TYPEINTERPRETATION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPixelFormatFunc_yellowSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixelFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixelFormat.yellowSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // yellowSize()const
            uchar cppResult = const_cast<const ::QPixelFormat *>(cppSelf)->yellowSize();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uchar>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPixelFormatFunc_yuvLayout(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPixelFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPixelFormat.yuvLayout";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // yuvLayout()const
            QPixelFormat::YUVLayout cppResult = const_cast<const ::QPixelFormat *>(cppSelf)->yuvLayout();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_YUVLAYOUT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPixelFormat___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QPixelFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QPixelFormat_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QPixelFormat_methods[] = {
    {"alphaPosition", reinterpret_cast<PyCFunction>(Sbk_QPixelFormatFunc_alphaPosition), METH_NOARGS},
    {"alphaSize", reinterpret_cast<PyCFunction>(Sbk_QPixelFormatFunc_alphaSize), METH_NOARGS},
    {"alphaUsage", reinterpret_cast<PyCFunction>(Sbk_QPixelFormatFunc_alphaUsage), METH_NOARGS},
    {"bitsPerPixel", reinterpret_cast<PyCFunction>(Sbk_QPixelFormatFunc_bitsPerPixel), METH_NOARGS},
    {"blackSize", reinterpret_cast<PyCFunction>(Sbk_QPixelFormatFunc_blackSize), METH_NOARGS},
    {"blueSize", reinterpret_cast<PyCFunction>(Sbk_QPixelFormatFunc_blueSize), METH_NOARGS},
    {"brightnessSize", reinterpret_cast<PyCFunction>(Sbk_QPixelFormatFunc_brightnessSize), METH_NOARGS},
    {"byteOrder", reinterpret_cast<PyCFunction>(Sbk_QPixelFormatFunc_byteOrder), METH_NOARGS},
    {"channelCount", reinterpret_cast<PyCFunction>(Sbk_QPixelFormatFunc_channelCount), METH_NOARGS},
    {"colorModel", reinterpret_cast<PyCFunction>(Sbk_QPixelFormatFunc_colorModel), METH_NOARGS},
    {"cyanSize", reinterpret_cast<PyCFunction>(Sbk_QPixelFormatFunc_cyanSize), METH_NOARGS},
    {"greenSize", reinterpret_cast<PyCFunction>(Sbk_QPixelFormatFunc_greenSize), METH_NOARGS},
    {"hueSize", reinterpret_cast<PyCFunction>(Sbk_QPixelFormatFunc_hueSize), METH_NOARGS},
    {"lightnessSize", reinterpret_cast<PyCFunction>(Sbk_QPixelFormatFunc_lightnessSize), METH_NOARGS},
    {"magentaSize", reinterpret_cast<PyCFunction>(Sbk_QPixelFormatFunc_magentaSize), METH_NOARGS},
    {"premultiplied", reinterpret_cast<PyCFunction>(Sbk_QPixelFormatFunc_premultiplied), METH_NOARGS},
    {"redSize", reinterpret_cast<PyCFunction>(Sbk_QPixelFormatFunc_redSize), METH_NOARGS},
    {"saturationSize", reinterpret_cast<PyCFunction>(Sbk_QPixelFormatFunc_saturationSize), METH_NOARGS},
    {"subEnum", reinterpret_cast<PyCFunction>(Sbk_QPixelFormatFunc_subEnum), METH_NOARGS},
    {"typeInterpretation", reinterpret_cast<PyCFunction>(Sbk_QPixelFormatFunc_typeInterpretation), METH_NOARGS},
    {"yellowSize", reinterpret_cast<PyCFunction>(Sbk_QPixelFormatFunc_yellowSize), METH_NOARGS},
    {"yuvLayout", reinterpret_cast<PyCFunction>(Sbk_QPixelFormatFunc_yuvLayout), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QPixelFormat___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QPixelFormat_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QPixelFormat_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QPixelFormat_Type = nullptr;
static SbkObjectType *Sbk_QPixelFormat_TypeF(void)
{
    return _Sbk_QPixelFormat_Type;
}

static PyType_Slot Sbk_QPixelFormat_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QPixelFormat_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QPixelFormat_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QPixelFormat_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QPixelFormat_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QPixelFormat_spec = {
    "2:PySide2.QtGui.QPixelFormat",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QPixelFormat_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QPixelFormat_ColorModel_PythonToCpp_QPixelFormat_ColorModel(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPixelFormat::ColorModel *>(cppOut) =
        static_cast<::QPixelFormat::ColorModel>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QPixelFormat_ColorModel_PythonToCpp_QPixelFormat_ColorModel_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_COLORMODEL_IDX]))
        return QPixelFormat_ColorModel_PythonToCpp_QPixelFormat_ColorModel;
    return {};
}
static PyObject *QPixelFormat_ColorModel_CppToPython_QPixelFormat_ColorModel(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QPixelFormat::ColorModel *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_COLORMODEL_IDX], castCppIn);

}

static void QPixelFormat_AlphaUsage_PythonToCpp_QPixelFormat_AlphaUsage(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPixelFormat::AlphaUsage *>(cppOut) =
        static_cast<::QPixelFormat::AlphaUsage>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QPixelFormat_AlphaUsage_PythonToCpp_QPixelFormat_AlphaUsage_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_ALPHAUSAGE_IDX]))
        return QPixelFormat_AlphaUsage_PythonToCpp_QPixelFormat_AlphaUsage;
    return {};
}
static PyObject *QPixelFormat_AlphaUsage_CppToPython_QPixelFormat_AlphaUsage(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QPixelFormat::AlphaUsage *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_ALPHAUSAGE_IDX], castCppIn);

}

static void QPixelFormat_AlphaPosition_PythonToCpp_QPixelFormat_AlphaPosition(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPixelFormat::AlphaPosition *>(cppOut) =
        static_cast<::QPixelFormat::AlphaPosition>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QPixelFormat_AlphaPosition_PythonToCpp_QPixelFormat_AlphaPosition_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_ALPHAPOSITION_IDX]))
        return QPixelFormat_AlphaPosition_PythonToCpp_QPixelFormat_AlphaPosition;
    return {};
}
static PyObject *QPixelFormat_AlphaPosition_CppToPython_QPixelFormat_AlphaPosition(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QPixelFormat::AlphaPosition *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_ALPHAPOSITION_IDX], castCppIn);

}

static void QPixelFormat_AlphaPremultiplied_PythonToCpp_QPixelFormat_AlphaPremultiplied(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPixelFormat::AlphaPremultiplied *>(cppOut) =
        static_cast<::QPixelFormat::AlphaPremultiplied>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QPixelFormat_AlphaPremultiplied_PythonToCpp_QPixelFormat_AlphaPremultiplied_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_ALPHAPREMULTIPLIED_IDX]))
        return QPixelFormat_AlphaPremultiplied_PythonToCpp_QPixelFormat_AlphaPremultiplied;
    return {};
}
static PyObject *QPixelFormat_AlphaPremultiplied_CppToPython_QPixelFormat_AlphaPremultiplied(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QPixelFormat::AlphaPremultiplied *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_ALPHAPREMULTIPLIED_IDX], castCppIn);

}

static void QPixelFormat_TypeInterpretation_PythonToCpp_QPixelFormat_TypeInterpretation(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPixelFormat::TypeInterpretation *>(cppOut) =
        static_cast<::QPixelFormat::TypeInterpretation>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QPixelFormat_TypeInterpretation_PythonToCpp_QPixelFormat_TypeInterpretation_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_TYPEINTERPRETATION_IDX]))
        return QPixelFormat_TypeInterpretation_PythonToCpp_QPixelFormat_TypeInterpretation;
    return {};
}
static PyObject *QPixelFormat_TypeInterpretation_CppToPython_QPixelFormat_TypeInterpretation(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QPixelFormat::TypeInterpretation *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_TYPEINTERPRETATION_IDX], castCppIn);

}

static void QPixelFormat_YUVLayout_PythonToCpp_QPixelFormat_YUVLayout(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPixelFormat::YUVLayout *>(cppOut) =
        static_cast<::QPixelFormat::YUVLayout>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QPixelFormat_YUVLayout_PythonToCpp_QPixelFormat_YUVLayout_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_YUVLAYOUT_IDX]))
        return QPixelFormat_YUVLayout_PythonToCpp_QPixelFormat_YUVLayout;
    return {};
}
static PyObject *QPixelFormat_YUVLayout_CppToPython_QPixelFormat_YUVLayout(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QPixelFormat::YUVLayout *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_YUVLAYOUT_IDX], castCppIn);

}

static void QPixelFormat_ByteOrder_PythonToCpp_QPixelFormat_ByteOrder(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPixelFormat::ByteOrder *>(cppOut) =
        static_cast<::QPixelFormat::ByteOrder>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QPixelFormat_ByteOrder_PythonToCpp_QPixelFormat_ByteOrder_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_BYTEORDER_IDX]))
        return QPixelFormat_ByteOrder_PythonToCpp_QPixelFormat_ByteOrder;
    return {};
}
static PyObject *QPixelFormat_ByteOrder_CppToPython_QPixelFormat_ByteOrder(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QPixelFormat::ByteOrder *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_BYTEORDER_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QPixelFormat_PythonToCpp_QPixelFormat_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QPixelFormat_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QPixelFormat_PythonToCpp_QPixelFormat_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QPixelFormat_TypeF())))
        return QPixelFormat_PythonToCpp_QPixelFormat_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QPixelFormat_PTR_CppToPython_QPixelFormat(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QPixelFormat *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QPixelFormat_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QPixelFormat_COPY_CppToPython_QPixelFormat(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QPixelFormat_TypeF(), new ::QPixelFormat(*reinterpret_cast<const ::QPixelFormat *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QPixelFormat_PythonToCpp_QPixelFormat_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPixelFormat *>(cppOut) = *reinterpret_cast< ::QPixelFormat *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QPixelFormat_PythonToCpp_QPixelFormat_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QPixelFormat_TypeF())))
        return QPixelFormat_PythonToCpp_QPixelFormat_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QPixelFormat_SignatureStrings[] = {
    "2:PySide2.QtGui.QPixelFormat(self)",
    "1:PySide2.QtGui.QPixelFormat(self,colorModel:PySide2.QtGui.QPixelFormat.ColorModel,firstSize:uchar,secondSize:uchar,thirdSize:uchar,fourthSize:uchar,fifthSize:uchar,alphaSize:uchar,alphaUsage:PySide2.QtGui.QPixelFormat.AlphaUsage,alphaPosition:PySide2.QtGui.QPixelFormat.AlphaPosition,premultiplied:PySide2.QtGui.QPixelFormat.AlphaPremultiplied,typeInterpretation:PySide2.QtGui.QPixelFormat.TypeInterpretation,byteOrder:PySide2.QtGui.QPixelFormat.ByteOrder=CurrentSystemEndian,subEnum:uchar=0)",
    "0:PySide2.QtGui.QPixelFormat(self,QPixelFormat:PySide2.QtGui.QPixelFormat)",
    "PySide2.QtGui.QPixelFormat.alphaPosition(self)->PySide2.QtGui.QPixelFormat.AlphaPosition",
    "PySide2.QtGui.QPixelFormat.alphaSize(self)->uchar",
    "PySide2.QtGui.QPixelFormat.alphaUsage(self)->PySide2.QtGui.QPixelFormat.AlphaUsage",
    "PySide2.QtGui.QPixelFormat.bitsPerPixel(self)->uchar",
    "PySide2.QtGui.QPixelFormat.blackSize(self)->uchar",
    "PySide2.QtGui.QPixelFormat.blueSize(self)->uchar",
    "PySide2.QtGui.QPixelFormat.brightnessSize(self)->uchar",
    "PySide2.QtGui.QPixelFormat.byteOrder(self)->PySide2.QtGui.QPixelFormat.ByteOrder",
    "PySide2.QtGui.QPixelFormat.channelCount(self)->uchar",
    "PySide2.QtGui.QPixelFormat.colorModel(self)->PySide2.QtGui.QPixelFormat.ColorModel",
    "PySide2.QtGui.QPixelFormat.cyanSize(self)->uchar",
    "PySide2.QtGui.QPixelFormat.greenSize(self)->uchar",
    "PySide2.QtGui.QPixelFormat.hueSize(self)->uchar",
    "PySide2.QtGui.QPixelFormat.lightnessSize(self)->uchar",
    "PySide2.QtGui.QPixelFormat.magentaSize(self)->uchar",
    "PySide2.QtGui.QPixelFormat.premultiplied(self)->PySide2.QtGui.QPixelFormat.AlphaPremultiplied",
    "PySide2.QtGui.QPixelFormat.redSize(self)->uchar",
    "PySide2.QtGui.QPixelFormat.saturationSize(self)->uchar",
    "PySide2.QtGui.QPixelFormat.subEnum(self)->uchar",
    "PySide2.QtGui.QPixelFormat.typeInterpretation(self)->PySide2.QtGui.QPixelFormat.TypeInterpretation",
    "PySide2.QtGui.QPixelFormat.yellowSize(self)->uchar",
    "PySide2.QtGui.QPixelFormat.yuvLayout(self)->PySide2.QtGui.QPixelFormat.YUVLayout",
    "PySide2.QtGui.QPixelFormat.__copy__()",
    nullptr}; // Sentinel

void init_QPixelFormat(PyObject *module)
{
    _Sbk_QPixelFormat_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QPixelFormat",
        "QPixelFormat",
        &Sbk_QPixelFormat_spec,
        &Shiboken::callCppDestructor< ::QPixelFormat >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QPixelFormat_Type);
    InitSignatureStrings(pyType, QPixelFormat_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QPixelFormat_Type), Sbk_QPixelFormat_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QPixelFormat_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QPixelFormat_TypeF(),
        QPixelFormat_PythonToCpp_QPixelFormat_PTR,
        is_QPixelFormat_PythonToCpp_QPixelFormat_PTR_Convertible,
        QPixelFormat_PTR_CppToPython_QPixelFormat,
        QPixelFormat_COPY_CppToPython_QPixelFormat);

    Shiboken::Conversions::registerConverterName(converter, "QPixelFormat");
    Shiboken::Conversions::registerConverterName(converter, "QPixelFormat*");
    Shiboken::Conversions::registerConverterName(converter, "QPixelFormat&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QPixelFormat).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QPixelFormat_PythonToCpp_QPixelFormat_COPY,
        is_QPixelFormat_PythonToCpp_QPixelFormat_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'ColorModel'.
    SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_COLORMODEL_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QPixelFormat_TypeF(),
        "ColorModel",
        "2:PySide2.QtGui.QPixelFormat.ColorModel",
        "QPixelFormat::ColorModel");
    if (!SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_COLORMODEL_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_COLORMODEL_IDX],
        Sbk_QPixelFormat_TypeF(), "RGB", (long) QPixelFormat::ColorModel::RGB))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_COLORMODEL_IDX],
        Sbk_QPixelFormat_TypeF(), "BGR", (long) QPixelFormat::ColorModel::BGR))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_COLORMODEL_IDX],
        Sbk_QPixelFormat_TypeF(), "Indexed", (long) QPixelFormat::ColorModel::Indexed))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_COLORMODEL_IDX],
        Sbk_QPixelFormat_TypeF(), "Grayscale", (long) QPixelFormat::ColorModel::Grayscale))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_COLORMODEL_IDX],
        Sbk_QPixelFormat_TypeF(), "CMYK", (long) QPixelFormat::ColorModel::CMYK))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_COLORMODEL_IDX],
        Sbk_QPixelFormat_TypeF(), "HSL", (long) QPixelFormat::ColorModel::HSL))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_COLORMODEL_IDX],
        Sbk_QPixelFormat_TypeF(), "HSV", (long) QPixelFormat::ColorModel::HSV))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_COLORMODEL_IDX],
        Sbk_QPixelFormat_TypeF(), "YUV", (long) QPixelFormat::ColorModel::YUV))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_COLORMODEL_IDX],
        Sbk_QPixelFormat_TypeF(), "Alpha", (long) QPixelFormat::ColorModel::Alpha))
        return;
    // Register converter for enum 'QPixelFormat::ColorModel'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_COLORMODEL_IDX],
            QPixelFormat_ColorModel_CppToPython_QPixelFormat_ColorModel);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QPixelFormat_ColorModel_PythonToCpp_QPixelFormat_ColorModel,
            is_QPixelFormat_ColorModel_PythonToCpp_QPixelFormat_ColorModel_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_COLORMODEL_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QPixelFormat::ColorModel");
        Shiboken::Conversions::registerConverterName(converter, "ColorModel");
    }
    // End of 'ColorModel' enum.

    // Initialization of enum 'AlphaUsage'.
    SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_ALPHAUSAGE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QPixelFormat_TypeF(),
        "AlphaUsage",
        "2:PySide2.QtGui.QPixelFormat.AlphaUsage",
        "QPixelFormat::AlphaUsage");
    if (!SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_ALPHAUSAGE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_ALPHAUSAGE_IDX],
        Sbk_QPixelFormat_TypeF(), "UsesAlpha", (long) QPixelFormat::AlphaUsage::UsesAlpha))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_ALPHAUSAGE_IDX],
        Sbk_QPixelFormat_TypeF(), "IgnoresAlpha", (long) QPixelFormat::AlphaUsage::IgnoresAlpha))
        return;
    // Register converter for enum 'QPixelFormat::AlphaUsage'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_ALPHAUSAGE_IDX],
            QPixelFormat_AlphaUsage_CppToPython_QPixelFormat_AlphaUsage);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QPixelFormat_AlphaUsage_PythonToCpp_QPixelFormat_AlphaUsage,
            is_QPixelFormat_AlphaUsage_PythonToCpp_QPixelFormat_AlphaUsage_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_ALPHAUSAGE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QPixelFormat::AlphaUsage");
        Shiboken::Conversions::registerConverterName(converter, "AlphaUsage");
    }
    // End of 'AlphaUsage' enum.

    // Initialization of enum 'AlphaPosition'.
    SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_ALPHAPOSITION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QPixelFormat_TypeF(),
        "AlphaPosition",
        "2:PySide2.QtGui.QPixelFormat.AlphaPosition",
        "QPixelFormat::AlphaPosition");
    if (!SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_ALPHAPOSITION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_ALPHAPOSITION_IDX],
        Sbk_QPixelFormat_TypeF(), "AtBeginning", (long) QPixelFormat::AlphaPosition::AtBeginning))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_ALPHAPOSITION_IDX],
        Sbk_QPixelFormat_TypeF(), "AtEnd", (long) QPixelFormat::AlphaPosition::AtEnd))
        return;
    // Register converter for enum 'QPixelFormat::AlphaPosition'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_ALPHAPOSITION_IDX],
            QPixelFormat_AlphaPosition_CppToPython_QPixelFormat_AlphaPosition);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QPixelFormat_AlphaPosition_PythonToCpp_QPixelFormat_AlphaPosition,
            is_QPixelFormat_AlphaPosition_PythonToCpp_QPixelFormat_AlphaPosition_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_ALPHAPOSITION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QPixelFormat::AlphaPosition");
        Shiboken::Conversions::registerConverterName(converter, "AlphaPosition");
    }
    // End of 'AlphaPosition' enum.

    // Initialization of enum 'AlphaPremultiplied'.
    SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_ALPHAPREMULTIPLIED_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QPixelFormat_TypeF(),
        "AlphaPremultiplied",
        "2:PySide2.QtGui.QPixelFormat.AlphaPremultiplied",
        "QPixelFormat::AlphaPremultiplied");
    if (!SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_ALPHAPREMULTIPLIED_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_ALPHAPREMULTIPLIED_IDX],
        Sbk_QPixelFormat_TypeF(), "NotPremultiplied", (long) QPixelFormat::AlphaPremultiplied::NotPremultiplied))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_ALPHAPREMULTIPLIED_IDX],
        Sbk_QPixelFormat_TypeF(), "Premultiplied", (long) QPixelFormat::AlphaPremultiplied::Premultiplied))
        return;
    // Register converter for enum 'QPixelFormat::AlphaPremultiplied'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_ALPHAPREMULTIPLIED_IDX],
            QPixelFormat_AlphaPremultiplied_CppToPython_QPixelFormat_AlphaPremultiplied);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QPixelFormat_AlphaPremultiplied_PythonToCpp_QPixelFormat_AlphaPremultiplied,
            is_QPixelFormat_AlphaPremultiplied_PythonToCpp_QPixelFormat_AlphaPremultiplied_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_ALPHAPREMULTIPLIED_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QPixelFormat::AlphaPremultiplied");
        Shiboken::Conversions::registerConverterName(converter, "AlphaPremultiplied");
    }
    // End of 'AlphaPremultiplied' enum.

    // Initialization of enum 'TypeInterpretation'.
    SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_TYPEINTERPRETATION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QPixelFormat_TypeF(),
        "TypeInterpretation",
        "2:PySide2.QtGui.QPixelFormat.TypeInterpretation",
        "QPixelFormat::TypeInterpretation");
    if (!SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_TYPEINTERPRETATION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_TYPEINTERPRETATION_IDX],
        Sbk_QPixelFormat_TypeF(), "UnsignedInteger", (long) QPixelFormat::TypeInterpretation::UnsignedInteger))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_TYPEINTERPRETATION_IDX],
        Sbk_QPixelFormat_TypeF(), "UnsignedShort", (long) QPixelFormat::TypeInterpretation::UnsignedShort))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_TYPEINTERPRETATION_IDX],
        Sbk_QPixelFormat_TypeF(), "UnsignedByte", (long) QPixelFormat::TypeInterpretation::UnsignedByte))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_TYPEINTERPRETATION_IDX],
        Sbk_QPixelFormat_TypeF(), "FloatingPoint", (long) QPixelFormat::TypeInterpretation::FloatingPoint))
        return;
    // Register converter for enum 'QPixelFormat::TypeInterpretation'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_TYPEINTERPRETATION_IDX],
            QPixelFormat_TypeInterpretation_CppToPython_QPixelFormat_TypeInterpretation);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QPixelFormat_TypeInterpretation_PythonToCpp_QPixelFormat_TypeInterpretation,
            is_QPixelFormat_TypeInterpretation_PythonToCpp_QPixelFormat_TypeInterpretation_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_TYPEINTERPRETATION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QPixelFormat::TypeInterpretation");
        Shiboken::Conversions::registerConverterName(converter, "TypeInterpretation");
    }
    // End of 'TypeInterpretation' enum.

    // Initialization of enum 'YUVLayout'.
    SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_YUVLAYOUT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QPixelFormat_TypeF(),
        "YUVLayout",
        "2:PySide2.QtGui.QPixelFormat.YUVLayout",
        "QPixelFormat::YUVLayout");
    if (!SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_YUVLAYOUT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_YUVLAYOUT_IDX],
        Sbk_QPixelFormat_TypeF(), "YUV444", (long) QPixelFormat::YUVLayout::YUV444))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_YUVLAYOUT_IDX],
        Sbk_QPixelFormat_TypeF(), "YUV422", (long) QPixelFormat::YUVLayout::YUV422))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_YUVLAYOUT_IDX],
        Sbk_QPixelFormat_TypeF(), "YUV411", (long) QPixelFormat::YUVLayout::YUV411))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_YUVLAYOUT_IDX],
        Sbk_QPixelFormat_TypeF(), "YUV420P", (long) QPixelFormat::YUVLayout::YUV420P))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_YUVLAYOUT_IDX],
        Sbk_QPixelFormat_TypeF(), "YUV420SP", (long) QPixelFormat::YUVLayout::YUV420SP))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_YUVLAYOUT_IDX],
        Sbk_QPixelFormat_TypeF(), "YV12", (long) QPixelFormat::YUVLayout::YV12))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_YUVLAYOUT_IDX],
        Sbk_QPixelFormat_TypeF(), "UYVY", (long) QPixelFormat::YUVLayout::UYVY))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_YUVLAYOUT_IDX],
        Sbk_QPixelFormat_TypeF(), "YUYV", (long) QPixelFormat::YUVLayout::YUYV))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_YUVLAYOUT_IDX],
        Sbk_QPixelFormat_TypeF(), "NV12", (long) QPixelFormat::YUVLayout::NV12))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_YUVLAYOUT_IDX],
        Sbk_QPixelFormat_TypeF(), "NV21", (long) QPixelFormat::YUVLayout::NV21))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_YUVLAYOUT_IDX],
        Sbk_QPixelFormat_TypeF(), "IMC1", (long) QPixelFormat::YUVLayout::IMC1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_YUVLAYOUT_IDX],
        Sbk_QPixelFormat_TypeF(), "IMC2", (long) QPixelFormat::YUVLayout::IMC2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_YUVLAYOUT_IDX],
        Sbk_QPixelFormat_TypeF(), "IMC3", (long) QPixelFormat::YUVLayout::IMC3))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_YUVLAYOUT_IDX],
        Sbk_QPixelFormat_TypeF(), "IMC4", (long) QPixelFormat::YUVLayout::IMC4))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_YUVLAYOUT_IDX],
        Sbk_QPixelFormat_TypeF(), "Y8", (long) QPixelFormat::YUVLayout::Y8))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_YUVLAYOUT_IDX],
        Sbk_QPixelFormat_TypeF(), "Y16", (long) QPixelFormat::YUVLayout::Y16))
        return;
    // Register converter for enum 'QPixelFormat::YUVLayout'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_YUVLAYOUT_IDX],
            QPixelFormat_YUVLayout_CppToPython_QPixelFormat_YUVLayout);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QPixelFormat_YUVLayout_PythonToCpp_QPixelFormat_YUVLayout,
            is_QPixelFormat_YUVLayout_PythonToCpp_QPixelFormat_YUVLayout_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_YUVLAYOUT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QPixelFormat::YUVLayout");
        Shiboken::Conversions::registerConverterName(converter, "YUVLayout");
    }
    // End of 'YUVLayout' enum.

    // Initialization of enum 'ByteOrder'.
    SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_BYTEORDER_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QPixelFormat_TypeF(),
        "ByteOrder",
        "2:PySide2.QtGui.QPixelFormat.ByteOrder",
        "QPixelFormat::ByteOrder");
    if (!SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_BYTEORDER_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_BYTEORDER_IDX],
        Sbk_QPixelFormat_TypeF(), "LittleEndian", (long) QPixelFormat::ByteOrder::LittleEndian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_BYTEORDER_IDX],
        Sbk_QPixelFormat_TypeF(), "BigEndian", (long) QPixelFormat::ByteOrder::BigEndian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_BYTEORDER_IDX],
        Sbk_QPixelFormat_TypeF(), "CurrentSystemEndian", (long) QPixelFormat::ByteOrder::CurrentSystemEndian))
        return;
    // Register converter for enum 'QPixelFormat::ByteOrder'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_BYTEORDER_IDX],
            QPixelFormat_ByteOrder_CppToPython_QPixelFormat_ByteOrder);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QPixelFormat_ByteOrder_PythonToCpp_QPixelFormat_ByteOrder,
            is_QPixelFormat_ByteOrder_PythonToCpp_QPixelFormat_ByteOrder_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QPIXELFORMAT_BYTEORDER_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QPixelFormat::ByteOrder");
        Shiboken::Conversions::registerConverterName(converter, "ByteOrder");
    }
    // End of 'ByteOrder' enum.

    qRegisterMetaType< ::QPixelFormat >("QPixelFormat");
    qRegisterMetaType< ::QPixelFormat::ColorModel >("QPixelFormat::ColorModel");
    qRegisterMetaType< ::QPixelFormat::AlphaUsage >("QPixelFormat::AlphaUsage");
    qRegisterMetaType< ::QPixelFormat::AlphaPosition >("QPixelFormat::AlphaPosition");
    qRegisterMetaType< ::QPixelFormat::AlphaPremultiplied >("QPixelFormat::AlphaPremultiplied");
    qRegisterMetaType< ::QPixelFormat::TypeInterpretation >("QPixelFormat::TypeInterpretation");
    qRegisterMetaType< ::QPixelFormat::YUVLayout >("QPixelFormat::YUVLayout");
    qRegisterMetaType< ::QPixelFormat::ByteOrder >("QPixelFormat::ByteOrder");
}
