/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qpen_wrapper.h"

// inner classes

// Extra includes
#include <QBrush>
#include <QVector>
#include <QtGui/qbrush.h>
#include <QtGui/qcolor.h>
#include <QtGui/qpen.h>
#include <qdatastream.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QPen_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QPen >()))
        return -1;

    ::QPen *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPen.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 5) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPen_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOO:QPen", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return -1;


    // Overloaded function decisor
    // 0: QPen::QPen()
    // 1: QPen::QPen(Qt::PenStyle)
    // 2: QPen::QPen(QBrush,qreal,Qt::PenStyle,Qt::PenCapStyle,Qt::PenJoinStyle)
    // 3: QPen::QPen(QColor)
    // 4: QPen::QPen(QPen)
    if (numArgs == 0) {
        overloadId = 0; // QPen()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_PENSTYLE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // QPen(Qt::PenStyle)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArgs[0])))) {
        overloadId = 3; // QPen(QColor)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), (pyArgs[0])))) {
        overloadId = 4; // QPen(QPen)
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 2; // QPen(QBrush,qreal,Qt::PenStyle,Qt::PenCapStyle,Qt::PenJoinStyle)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_PENSTYLE_IDX])->converter, (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 2; // QPen(QBrush,qreal,Qt::PenStyle,Qt::PenCapStyle,Qt::PenJoinStyle)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_PENCAPSTYLE_IDX])->converter, (pyArgs[3])))) {
                if (numArgs == 4) {
                    overloadId = 2; // QPen(QBrush,qreal,Qt::PenStyle,Qt::PenCapStyle,Qt::PenJoinStyle)
                } else if (numArgs >= 5
                    && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_PENJOINSTYLE_IDX])->converter, (pyArgs[4])))) {
                    overloadId = 2; // QPen(QBrush,qreal,Qt::PenStyle,Qt::PenCapStyle,Qt::PenJoinStyle)
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPen_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QPen()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QPen_Init_TypeError;
            }

            if (!PyErr_Occurred()) {
                // QPen()
                cptr = new ::QPen();
            }
            break;
        }
        case 1: // QPen(Qt::PenStyle arg__1)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QPen_Init_TypeError;
            }
            ::Qt::PenStyle cppArg0{Qt::NoPen};
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QPen(Qt::PenStyle)
                cptr = new ::QPen(cppArg0);
            }
            break;
        }
        case 2: // QPen(const QBrush & brush, qreal width, Qt::PenStyle s, Qt::PenCapStyle c, Qt::PenJoinStyle j)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_s = Shiboken::String::createStaticString("s");
                if (PyDict_Contains(kwds, key_s)) {
                    value = PyDict_GetItem(kwds, key_s);
                    if (value && pyArgs[2]) {
                        errInfo = key_s;
                        Py_INCREF(errInfo);
                        goto Sbk_QPen_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_PENSTYLE_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QPen_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_s);
                }
                static PyObject *const key_c = Shiboken::String::createStaticString("c");
                if (PyDict_Contains(kwds, key_c)) {
                    value = PyDict_GetItem(kwds, key_c);
                    if (value && pyArgs[3]) {
                        errInfo = key_c;
                        Py_INCREF(errInfo);
                        goto Sbk_QPen_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_PENCAPSTYLE_IDX])->converter, (pyArgs[3]))))
                            goto Sbk_QPen_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_c);
                }
                static PyObject *const key_j = Shiboken::String::createStaticString("j");
                if (PyDict_Contains(kwds, key_j)) {
                    value = PyDict_GetItem(kwds, key_j);
                    if (value && pyArgs[4]) {
                        errInfo = key_j;
                        Py_INCREF(errInfo);
                        goto Sbk_QPen_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_PENJOINSTYLE_IDX])->converter, (pyArgs[4]))))
                            goto Sbk_QPen_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_j);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPen_Init_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QBrush cppArg0_local;
            ::QBrush *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::Qt::PenStyle cppArg2 = Qt::SolidLine;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            ::Qt::PenCapStyle cppArg3 = Qt::SquareCap;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
            ::Qt::PenJoinStyle cppArg4 = Qt::BevelJoin;
            if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!PyErr_Occurred()) {
                // QPen(QBrush,qreal,Qt::PenStyle,Qt::PenCapStyle,Qt::PenJoinStyle)
                cptr = new ::QPen(*cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            }
            break;
        }
        case 3: // QPen(const QColor & color)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QPen_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QColor cppArg0_local;
            ::QColor *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QPen(QColor)
                cptr = new ::QPen(*cppArg0);
            }
            break;
        }
        case 4: // QPen(const QPen & pen)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QPen_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QPen cppArg0_local;
            ::QPen *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QPen(QPen)
                cptr = new ::QPen(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QPen >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QPen_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QPen_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QPenFunc_brush(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPen.brush";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // brush()const
            QBrush cppResult = const_cast<const ::QPen *>(cppSelf)->brush();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPenFunc_capStyle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPen.capStyle";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // capStyle()const
            Qt::PenCapStyle cppResult = const_cast<const ::QPen *>(cppSelf)->capStyle();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_PENCAPSTYLE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPenFunc_color(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPen.color";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // color()const
            QColor cppResult = const_cast<const ::QPen *>(cppSelf)->color();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPenFunc_dashOffset(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPen.dashOffset";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // dashOffset()const
            qreal cppResult = const_cast<const ::QPen *>(cppSelf)->dashOffset();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPenFunc_dashPattern(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPen.dashPattern";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // dashPattern()const
            QVector<qreal > cppResult = const_cast<const ::QPen *>(cppSelf)->dashPattern();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QREAL_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPenFunc_isCosmetic(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPen.isCosmetic";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isCosmetic()const
            bool cppResult = const_cast<const ::QPen *>(cppSelf)->isCosmetic();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPenFunc_isSolid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPen.isSolid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isSolid()const
            bool cppResult = const_cast<const ::QPen *>(cppSelf)->isSolid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPenFunc_joinStyle(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPen.joinStyle";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // joinStyle()const
            Qt::PenJoinStyle cppResult = const_cast<const ::QPen *>(cppSelf)->joinStyle();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_PENJOINSTYLE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPenFunc_miterLimit(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPen.miterLimit";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // miterLimit()const
            qreal cppResult = const_cast<const ::QPen *>(cppSelf)->miterLimit();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPenFunc_setBrush(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPen.setBrush";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPen::setBrush(QBrush)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArg)))) {
        overloadId = 0; // setBrush(QBrush)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPenFunc_setBrush_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QBrush cppArg0_local;
        ::QBrush *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setBrush(QBrush)
            cppSelf->setBrush(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPenFunc_setBrush_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPenFunc_setCapStyle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPen.setCapStyle";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPen::setCapStyle(Qt::PenCapStyle)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_PENCAPSTYLE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setCapStyle(Qt::PenCapStyle)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPenFunc_setCapStyle_TypeError;

    // Call function/method
    {
        ::Qt::PenCapStyle cppArg0{Qt::FlatCap};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCapStyle(Qt::PenCapStyle)
            cppSelf->setCapStyle(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPenFunc_setCapStyle_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPenFunc_setColor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPen.setColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPen::setColor(QColor)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArg)))) {
        overloadId = 0; // setColor(QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPenFunc_setColor_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QColor cppArg0_local;
        ::QColor *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setColor(QColor)
            cppSelf->setColor(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPenFunc_setColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPenFunc_setCosmetic(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPen.setCosmetic";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPen::setCosmetic(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setCosmetic(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPenFunc_setCosmetic_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCosmetic(bool)
            cppSelf->setCosmetic(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPenFunc_setCosmetic_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPenFunc_setDashOffset(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPen.setDashOffset";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPen::setDashOffset(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setDashOffset(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPenFunc_setDashOffset_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDashOffset(qreal)
            cppSelf->setDashOffset(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPenFunc_setDashOffset_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPenFunc_setDashPattern(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPen.setDashPattern";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPen::setDashPattern(QVector<qreal>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QVECTOR_QREAL_IDX], (pyArg)))) {
        overloadId = 0; // setDashPattern(QVector<qreal>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPenFunc_setDashPattern_TypeError;

    // Call function/method
    {
        ::QVector<qreal > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDashPattern(QVector<qreal>)
            cppSelf->setDashPattern(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPenFunc_setDashPattern_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPenFunc_setJoinStyle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPen.setJoinStyle";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPen::setJoinStyle(Qt::PenJoinStyle)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_PENJOINSTYLE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setJoinStyle(Qt::PenJoinStyle)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPenFunc_setJoinStyle_TypeError;

    // Call function/method
    {
        ::Qt::PenJoinStyle cppArg0{Qt::MiterJoin};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setJoinStyle(Qt::PenJoinStyle)
            cppSelf->setJoinStyle(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPenFunc_setJoinStyle_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPenFunc_setMiterLimit(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPen.setMiterLimit";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPen::setMiterLimit(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setMiterLimit(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPenFunc_setMiterLimit_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMiterLimit(qreal)
            cppSelf->setMiterLimit(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPenFunc_setMiterLimit_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPenFunc_setStyle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPen.setStyle";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPen::setStyle(Qt::PenStyle)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_PENSTYLE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setStyle(Qt::PenStyle)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPenFunc_setStyle_TypeError;

    // Call function/method
    {
        ::Qt::PenStyle cppArg0{Qt::NoPen};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setStyle(Qt::PenStyle)
            cppSelf->setStyle(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPenFunc_setStyle_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPenFunc_setWidth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPen.setWidth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPen::setWidth(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setWidth(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPenFunc_setWidth_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setWidth(int)
            cppSelf->setWidth(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPenFunc_setWidth_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPenFunc_setWidthF(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPen.setWidthF";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPen::setWidthF(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setWidthF(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPenFunc_setWidthF_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setWidthF(qreal)
            cppSelf->setWidthF(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPenFunc_setWidthF_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPenFunc_style(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPen.style";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // style()const
            Qt::PenStyle cppResult = const_cast<const ::QPen *>(cppSelf)->style();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_PENSTYLE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPenFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPen.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPen::swap(QPen&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QPen&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPenFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPen cppArg0_local;
        ::QPen *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QPen&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPenFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPenFunc_width(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPen.width";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // width()const
            int cppResult = const_cast<const ::QPen *>(cppSelf)->width();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPenFunc_widthF(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPen.widthF";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // widthF()const
            qreal cppResult = const_cast<const ::QPen *>(cppSelf)->widthF();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPen___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QPen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QPen_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QPen_methods[] = {
    {"brush", reinterpret_cast<PyCFunction>(Sbk_QPenFunc_brush), METH_NOARGS},
    {"capStyle", reinterpret_cast<PyCFunction>(Sbk_QPenFunc_capStyle), METH_NOARGS},
    {"color", reinterpret_cast<PyCFunction>(Sbk_QPenFunc_color), METH_NOARGS},
    {"dashOffset", reinterpret_cast<PyCFunction>(Sbk_QPenFunc_dashOffset), METH_NOARGS},
    {"dashPattern", reinterpret_cast<PyCFunction>(Sbk_QPenFunc_dashPattern), METH_NOARGS},
    {"isCosmetic", reinterpret_cast<PyCFunction>(Sbk_QPenFunc_isCosmetic), METH_NOARGS},
    {"isSolid", reinterpret_cast<PyCFunction>(Sbk_QPenFunc_isSolid), METH_NOARGS},
    {"joinStyle", reinterpret_cast<PyCFunction>(Sbk_QPenFunc_joinStyle), METH_NOARGS},
    {"miterLimit", reinterpret_cast<PyCFunction>(Sbk_QPenFunc_miterLimit), METH_NOARGS},
    {"setBrush", reinterpret_cast<PyCFunction>(Sbk_QPenFunc_setBrush), METH_O},
    {"setCapStyle", reinterpret_cast<PyCFunction>(Sbk_QPenFunc_setCapStyle), METH_O},
    {"setColor", reinterpret_cast<PyCFunction>(Sbk_QPenFunc_setColor), METH_O},
    {"setCosmetic", reinterpret_cast<PyCFunction>(Sbk_QPenFunc_setCosmetic), METH_O},
    {"setDashOffset", reinterpret_cast<PyCFunction>(Sbk_QPenFunc_setDashOffset), METH_O},
    {"setDashPattern", reinterpret_cast<PyCFunction>(Sbk_QPenFunc_setDashPattern), METH_O},
    {"setJoinStyle", reinterpret_cast<PyCFunction>(Sbk_QPenFunc_setJoinStyle), METH_O},
    {"setMiterLimit", reinterpret_cast<PyCFunction>(Sbk_QPenFunc_setMiterLimit), METH_O},
    {"setStyle", reinterpret_cast<PyCFunction>(Sbk_QPenFunc_setStyle), METH_O},
    {"setWidth", reinterpret_cast<PyCFunction>(Sbk_QPenFunc_setWidth), METH_O},
    {"setWidthF", reinterpret_cast<PyCFunction>(Sbk_QPenFunc_setWidthF), METH_O},
    {"style", reinterpret_cast<PyCFunction>(Sbk_QPenFunc_style), METH_NOARGS},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QPenFunc_swap), METH_O},
    {"width", reinterpret_cast<PyCFunction>(Sbk_QPenFunc_width), METH_NOARGS},
    {"widthF", reinterpret_cast<PyCFunction>(Sbk_QPenFunc_widthF), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QPen___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QPenFunc___lshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPen.__lshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rlshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QPen::operator<<(QDataStream&,QPen)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator<<(QDataStream&,QPen)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QPenFunc___lshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDataStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator<<(QDataStream&,QPen) [reverse operator]
                QDataStream & cppResult = (*cppArg0) << (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPenFunc___lshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPenFunc___rshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPen.__rshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rrshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QPen::operator>>(QDataStream&,QPen&)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator>>(QDataStream&,QPen&)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QPenFunc___rshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDataStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator>>(QDataStream&,QPen&) [reverse operator]
                QDataStream & cppResult = (*cppArg0) >> (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPenFunc___rshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

// Rich comparison
static PyObject * Sbk_QPen_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QPen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), (pyArg)))) {
                // operator!=(const QPen & p) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QPen cppArg0_local;
                ::QPen *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), (pyArg)))) {
                // operator==(const QPen & p) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QPen cppArg0_local;
                ::QPen *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QPen_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QPen_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QPen_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QPen_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QPen__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QPen_Type = nullptr;
static SbkObjectType *Sbk_QPen_TypeF(void)
{
    return _Sbk_QPen_Type;
}

static PyType_Slot Sbk_QPen_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QPen__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QPen_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QPen_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QPen_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QPen_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QPen_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
    {Py_nb_rshift, (void *)Sbk_QPenFunc___rshift__},
    {Py_nb_lshift, (void *)Sbk_QPenFunc___lshift__},
    {0, nullptr}
};
static PyType_Spec Sbk_QPen_spec = {
    "2:PySide2.QtGui.QPen",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QPen_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QPen_PythonToCpp_QPen_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QPen_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QPen_PythonToCpp_QPen_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QPen_TypeF())))
        return QPen_PythonToCpp_QPen_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QPen_PTR_CppToPython_QPen(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QPen *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QPen_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QPen_COPY_CppToPython_QPen(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QPen_TypeF(), new ::QPen(*reinterpret_cast<const ::QPen *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QPen_PythonToCpp_QPen_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPen *>(cppOut) = *reinterpret_cast< ::QPen *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QPen_PythonToCpp_QPen_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QPen_TypeF())))
        return QPen_PythonToCpp_QPen_COPY;
    return {};
}

// Implicit conversions.
static void PySide2_QtCore_Qt_PenStyle_PythonToCpp_QPen(PyObject *pyIn, void *cppOut) {
    ::Qt::PenStyle cppIn{Qt::NoPen};
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_PENSTYLE_IDX])->converter, pyIn, &cppIn);
    *reinterpret_cast<::QPen *>(cppOut) = ::QPen(cppIn);
}
static PythonToCppFunc is_PySide2_QtCore_Qt_PenStyle_PythonToCpp_QPen_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QT_PENSTYLE_IDX], pyIn))
        return PySide2_QtCore_Qt_PenStyle_PythonToCpp_QPen;
    return {};
}

static void constQColorREF_PythonToCpp_QPen(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPen *>(cppOut) = ::QPen( *reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_constQColorREF_PythonToCpp_QPen_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], pyIn))
        return constQColorREF_PythonToCpp_QPen;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QPen_SignatureStrings[] = {
    "4:PySide2.QtGui.QPen(self)",
    "3:PySide2.QtGui.QPen(self,arg__1:PySide2.QtCore.Qt.PenStyle)",
    "2:PySide2.QtGui.QPen(self,brush:PySide2.QtGui.QBrush,width:qreal,s:PySide2.QtCore.Qt.PenStyle=Qt.SolidLine,c:PySide2.QtCore.Qt.PenCapStyle=Qt.SquareCap,j:PySide2.QtCore.Qt.PenJoinStyle=Qt.BevelJoin)",
    "1:PySide2.QtGui.QPen(self,color:PySide2.QtGui.QColor)",
    "0:PySide2.QtGui.QPen(self,pen:PySide2.QtGui.QPen)",
    "PySide2.QtGui.QPen.brush(self)->PySide2.QtGui.QBrush",
    "PySide2.QtGui.QPen.capStyle(self)->PySide2.QtCore.Qt.PenCapStyle",
    "PySide2.QtGui.QPen.color(self)->PySide2.QtGui.QColor",
    "PySide2.QtGui.QPen.dashOffset(self)->qreal",
    "PySide2.QtGui.QPen.dashPattern(self)->QVector[qreal]",
    "PySide2.QtGui.QPen.isCosmetic(self)->bool",
    "PySide2.QtGui.QPen.isSolid(self)->bool",
    "PySide2.QtGui.QPen.joinStyle(self)->PySide2.QtCore.Qt.PenJoinStyle",
    "PySide2.QtGui.QPen.miterLimit(self)->qreal",
    "PySide2.QtGui.QPen.setBrush(self,brush:PySide2.QtGui.QBrush)",
    "PySide2.QtGui.QPen.setCapStyle(self,pcs:PySide2.QtCore.Qt.PenCapStyle)",
    "PySide2.QtGui.QPen.setColor(self,color:PySide2.QtGui.QColor)",
    "PySide2.QtGui.QPen.setCosmetic(self,cosmetic:bool)",
    "PySide2.QtGui.QPen.setDashOffset(self,doffset:qreal)",
    "PySide2.QtGui.QPen.setDashPattern(self,pattern:QVector[qreal])",
    "PySide2.QtGui.QPen.setJoinStyle(self,pcs:PySide2.QtCore.Qt.PenJoinStyle)",
    "PySide2.QtGui.QPen.setMiterLimit(self,limit:qreal)",
    "PySide2.QtGui.QPen.setStyle(self,arg__1:PySide2.QtCore.Qt.PenStyle)",
    "PySide2.QtGui.QPen.setWidth(self,width:int)",
    "PySide2.QtGui.QPen.setWidthF(self,width:qreal)",
    "PySide2.QtGui.QPen.style(self)->PySide2.QtCore.Qt.PenStyle",
    "PySide2.QtGui.QPen.swap(self,other:PySide2.QtGui.QPen)",
    "PySide2.QtGui.QPen.width(self)->int",
    "PySide2.QtGui.QPen.widthF(self)->qreal",
    "PySide2.QtGui.QPen.__copy__()",
    "PySide2.QtGui.QPen.__lshift__(self,arg__1:PySide2.QtCore.QDataStream)->PySide2.QtCore.QDataStream",
    "PySide2.QtGui.QPen.__rshift__(self,arg__1:PySide2.QtCore.QDataStream)->PySide2.QtCore.QDataStream",
    nullptr}; // Sentinel

void init_QPen(PyObject *module)
{
    _Sbk_QPen_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QPen",
        "QPen",
        &Sbk_QPen_spec,
        &Shiboken::callCppDestructor< ::QPen >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QPen_Type);
    InitSignatureStrings(pyType, QPen_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QPen_Type), Sbk_QPen_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QPen_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QPen_TypeF(),
        QPen_PythonToCpp_QPen_PTR,
        is_QPen_PythonToCpp_QPen_PTR_Convertible,
        QPen_PTR_CppToPython_QPen,
        QPen_COPY_CppToPython_QPen);

    Shiboken::Conversions::registerConverterName(converter, "QPen");
    Shiboken::Conversions::registerConverterName(converter, "QPen*");
    Shiboken::Conversions::registerConverterName(converter, "QPen&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QPen).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QPen_PythonToCpp_QPen_COPY,
        is_QPen_PythonToCpp_QPen_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtCore_Qt_PenStyle_PythonToCpp_QPen,
        is_PySide2_QtCore_Qt_PenStyle_PythonToCpp_QPen_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        constQColorREF_PythonToCpp_QPen,
        is_constQColorREF_PythonToCpp_QPen_Convertible);

    qRegisterMetaType< ::QPen >("QPen");
}
