/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qpalette_wrapper.h"

// inner classes

// Extra includes
#include <QtGui/qbrush.h>
#include <QtGui/qcolor.h>
#include <QtGui/qpalette.h>
#include <qdatastream.h>
#include <qobject.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QPalette_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QPalette >()))
        return -1;

    ::QPalette *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPalette.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 3 || numArgs == 4 || numArgs == 5 || numArgs == 6 || numArgs == 8)
        goto Sbk_QPalette_Init_TypeError;

    if (!PyArg_UnpackTuple(args, "QPalette", 0, 9, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8])))
        return -1;


    // Overloaded function decisor
    // 0: QPalette::QPalette()
    // 1: QPalette::QPalette(Qt::GlobalColor)
    // 2: QPalette::QPalette(QBrush,QBrush,QBrush,QBrush,QBrush,QBrush,QBrush,QBrush,QBrush)
    // 3: QPalette::QPalette(QColor)
    // 4: QPalette::QPalette(QColor,QColor)
    // 5: QPalette::QPalette(QColor,QColor,QColor,QColor,QColor,QColor,QColor)
    // 6: QPalette::QPalette(QPalette)
    if (numArgs == 0) {
        overloadId = 0; // QPalette()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // QPalette(Qt::GlobalColor)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 3; // QPalette(QColor)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 4; // QPalette(QColor,QColor)
            } else if (numArgs == 7
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArgs[2])))
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArgs[3])))
                && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArgs[4])))
                && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArgs[5])))
                && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArgs[6])))) {
                overloadId = 5; // QPalette(QColor,QColor,QColor,QColor,QColor,QColor,QColor)
            }
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX]), (pyArgs[0])))) {
        overloadId = 6; // QPalette(QPalette)
    } else if (numArgs == 9
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArgs[7])))
        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArgs[8])))) {
        overloadId = 2; // QPalette(QBrush,QBrush,QBrush,QBrush,QBrush,QBrush,QBrush,QBrush,QBrush)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPalette_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QPalette()
        {

            if (!PyErr_Occurred()) {
                // QPalette()
                cptr = new ::QPalette();
            }
            break;
        }
        case 1: // QPalette(Qt::GlobalColor button)
        {
            ::Qt::GlobalColor cppArg0{Qt::color0};
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QPalette(Qt::GlobalColor)
                cptr = new ::QPalette(cppArg0);
            }
            break;
        }
        case 2: // QPalette(const QBrush & windowText, const QBrush & button, const QBrush & light, const QBrush & dark, const QBrush & mid, const QBrush & text, const QBrush & bright_text, const QBrush & base, const QBrush & window)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QBrush cppArg0_local;
            ::QBrush *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QBrush cppArg1_local;
            ::QBrush *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QBrush cppArg2_local;
            ::QBrush *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!Shiboken::Object::isValid(pyArgs[3]))
                return -1;
            ::QBrush cppArg3_local;
            ::QBrush *cppArg3 = &cppArg3_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp[3]))
                pythonToCpp[3](pyArgs[3], &cppArg3_local);
            else
                pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!Shiboken::Object::isValid(pyArgs[4]))
                return -1;
            ::QBrush cppArg4_local;
            ::QBrush *cppArg4 = &cppArg4_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp[4]))
                pythonToCpp[4](pyArgs[4], &cppArg4_local);
            else
                pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!Shiboken::Object::isValid(pyArgs[5]))
                return -1;
            ::QBrush cppArg5_local;
            ::QBrush *cppArg5 = &cppArg5_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp[5]))
                pythonToCpp[5](pyArgs[5], &cppArg5_local);
            else
                pythonToCpp[5](pyArgs[5], &cppArg5);

            if (!Shiboken::Object::isValid(pyArgs[6]))
                return -1;
            ::QBrush cppArg6_local;
            ::QBrush *cppArg6 = &cppArg6_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp[6]))
                pythonToCpp[6](pyArgs[6], &cppArg6_local);
            else
                pythonToCpp[6](pyArgs[6], &cppArg6);

            if (!Shiboken::Object::isValid(pyArgs[7]))
                return -1;
            ::QBrush cppArg7_local;
            ::QBrush *cppArg7 = &cppArg7_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp[7]))
                pythonToCpp[7](pyArgs[7], &cppArg7_local);
            else
                pythonToCpp[7](pyArgs[7], &cppArg7);

            if (!Shiboken::Object::isValid(pyArgs[8]))
                return -1;
            ::QBrush cppArg8_local;
            ::QBrush *cppArg8 = &cppArg8_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp[8]))
                pythonToCpp[8](pyArgs[8], &cppArg8_local);
            else
                pythonToCpp[8](pyArgs[8], &cppArg8);


            if (!PyErr_Occurred()) {
                // QPalette(QBrush,QBrush,QBrush,QBrush,QBrush,QBrush,QBrush,QBrush,QBrush)
                cptr = new ::QPalette(*cppArg0, *cppArg1, *cppArg2, *cppArg3, *cppArg4, *cppArg5, *cppArg6, *cppArg7, *cppArg8);
            }
            break;
        }
        case 3: // QPalette(const QColor & button)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QColor cppArg0_local;
            ::QColor *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QPalette(QColor)
                cptr = new ::QPalette(*cppArg0);
            }
            break;
        }
        case 4: // QPalette(const QColor & button, const QColor & window)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QColor cppArg0_local;
            ::QColor *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QColor cppArg1_local;
            ::QColor *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // QPalette(QColor,QColor)
                cptr = new ::QPalette(*cppArg0, *cppArg1);
            }
            break;
        }
        case 5: // QPalette(const QColor & windowText, const QColor & window, const QColor & light, const QColor & dark, const QColor & mid, const QColor & text, const QColor & base)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QColor cppArg0_local;
            ::QColor *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QColor cppArg1_local;
            ::QColor *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QColor cppArg2_local;
            ::QColor *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!Shiboken::Object::isValid(pyArgs[3]))
                return -1;
            ::QColor cppArg3_local;
            ::QColor *cppArg3 = &cppArg3_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp[3]))
                pythonToCpp[3](pyArgs[3], &cppArg3_local);
            else
                pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!Shiboken::Object::isValid(pyArgs[4]))
                return -1;
            ::QColor cppArg4_local;
            ::QColor *cppArg4 = &cppArg4_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp[4]))
                pythonToCpp[4](pyArgs[4], &cppArg4_local);
            else
                pythonToCpp[4](pyArgs[4], &cppArg4);

            if (!Shiboken::Object::isValid(pyArgs[5]))
                return -1;
            ::QColor cppArg5_local;
            ::QColor *cppArg5 = &cppArg5_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp[5]))
                pythonToCpp[5](pyArgs[5], &cppArg5_local);
            else
                pythonToCpp[5](pyArgs[5], &cppArg5);

            if (!Shiboken::Object::isValid(pyArgs[6]))
                return -1;
            ::QColor cppArg6_local;
            ::QColor *cppArg6 = &cppArg6_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp[6]))
                pythonToCpp[6](pyArgs[6], &cppArg6_local);
            else
                pythonToCpp[6](pyArgs[6], &cppArg6);


            if (!PyErr_Occurred()) {
                // QPalette(QColor,QColor,QColor,QColor,QColor,QColor,QColor)
                cptr = new ::QPalette(*cppArg0, *cppArg1, *cppArg2, *cppArg3, *cppArg4, *cppArg5, *cppArg6);
            }
            break;
        }
        case 6: // QPalette(const QPalette & palette)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QPalette cppArg0_local;
            ::QPalette *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QPalette(QPalette)
                cptr = new ::QPalette(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QPalette >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QPalette_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QPalette_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QPaletteFunc_alternateBase(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPalette *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPalette.alternateBase";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // alternateBase()const
            const QBrush & cppResult = const_cast<const ::QPalette *>(cppSelf)->alternateBase();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaletteFunc_background(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPalette *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPalette.background";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // background()const
            const QBrush & cppResult = const_cast<const ::QPalette *>(cppSelf)->background();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaletteFunc_base(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPalette *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPalette.base";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // base()const
            const QBrush & cppResult = const_cast<const ::QPalette *>(cppSelf)->base();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaletteFunc_brightText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPalette *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPalette.brightText";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // brightText()const
            const QBrush & cppResult = const_cast<const ::QPalette *>(cppSelf)->brightText();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaletteFunc_brush(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPalette *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPalette.brush";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "brush", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QPalette::brush(QPalette::ColorGroup,QPalette::ColorRole)const
    // 1: QPalette::brush(QPalette::ColorRole)const
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // brush(QPalette::ColorRole)const
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORGROUP_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX])->converter, (pyArgs[1])))) {
        overloadId = 0; // brush(QPalette::ColorGroup,QPalette::ColorRole)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPaletteFunc_brush_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // brush(QPalette::ColorGroup cg, QPalette::ColorRole cr) const
        {
            ::QPalette::ColorGroup cppArg0{QPalette::Normal};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QPalette::ColorRole cppArg1{QPalette::Foreground};
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // brush(QPalette::ColorGroup,QPalette::ColorRole)const
                const QBrush & cppResult = const_cast<const ::QPalette *>(cppSelf)->brush(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
            }
            break;
        }
        case 1: // brush(QPalette::ColorRole cr) const
        {
            ::QPalette::ColorRole cppArg0{QPalette::Foreground};
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // brush(QPalette::ColorRole)const
                const QBrush & cppResult = const_cast<const ::QPalette *>(cppSelf)->brush(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPaletteFunc_brush_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPaletteFunc_button(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPalette *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPalette.button";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // button()const
            const QBrush & cppResult = const_cast<const ::QPalette *>(cppSelf)->button();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaletteFunc_buttonText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPalette *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPalette.buttonText";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // buttonText()const
            const QBrush & cppResult = const_cast<const ::QPalette *>(cppSelf)->buttonText();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaletteFunc_cacheKey(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPalette *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPalette.cacheKey";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // cacheKey()const
            qint64 cppResult = const_cast<const ::QPalette *>(cppSelf)->cacheKey();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qint64>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaletteFunc_color(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPalette *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPalette.color";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "color", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QPalette::color(QPalette::ColorGroup,QPalette::ColorRole)const
    // 1: QPalette::color(QPalette::ColorRole)const
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // color(QPalette::ColorRole)const
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORGROUP_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX])->converter, (pyArgs[1])))) {
        overloadId = 0; // color(QPalette::ColorGroup,QPalette::ColorRole)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPaletteFunc_color_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // color(QPalette::ColorGroup cg, QPalette::ColorRole cr) const
        {
            ::QPalette::ColorGroup cppArg0{QPalette::Normal};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QPalette::ColorRole cppArg1{QPalette::Foreground};
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // color(QPalette::ColorGroup,QPalette::ColorRole)const
                const QColor & cppResult = const_cast<const ::QPalette *>(cppSelf)->color(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
            }
            break;
        }
        case 1: // color(QPalette::ColorRole cr) const
        {
            ::QPalette::ColorRole cppArg0{QPalette::Foreground};
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // color(QPalette::ColorRole)const
                const QColor & cppResult = const_cast<const ::QPalette *>(cppSelf)->color(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPaletteFunc_color_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPaletteFunc_currentColorGroup(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPalette *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPalette.currentColorGroup";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // currentColorGroup()const
            QPalette::ColorGroup cppResult = const_cast<const ::QPalette *>(cppSelf)->currentColorGroup();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORGROUP_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaletteFunc_dark(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPalette *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPalette.dark";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // dark()const
            const QBrush & cppResult = const_cast<const ::QPalette *>(cppSelf)->dark();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaletteFunc_foreground(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPalette *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPalette.foreground";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // foreground()const
            const QBrush & cppResult = const_cast<const ::QPalette *>(cppSelf)->foreground();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaletteFunc_highlight(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPalette *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPalette.highlight";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // highlight()const
            const QBrush & cppResult = const_cast<const ::QPalette *>(cppSelf)->highlight();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaletteFunc_highlightedText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPalette *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPalette.highlightedText";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // highlightedText()const
            const QBrush & cppResult = const_cast<const ::QPalette *>(cppSelf)->highlightedText();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaletteFunc_isBrushSet(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPalette *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPalette.isBrushSet";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "isBrushSet", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QPalette::isBrushSet(QPalette::ColorGroup,QPalette::ColorRole)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORGROUP_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX])->converter, (pyArgs[1])))) {
        overloadId = 0; // isBrushSet(QPalette::ColorGroup,QPalette::ColorRole)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPaletteFunc_isBrushSet_TypeError;

    // Call function/method
    {
        ::QPalette::ColorGroup cppArg0{QPalette::Normal};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QPalette::ColorRole cppArg1{QPalette::Foreground};
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // isBrushSet(QPalette::ColorGroup,QPalette::ColorRole)const
            bool cppResult = const_cast<const ::QPalette *>(cppSelf)->isBrushSet(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPaletteFunc_isBrushSet_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPaletteFunc_isCopyOf(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPalette *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPalette.isCopyOf";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPalette::isCopyOf(QPalette)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX]), (pyArg)))) {
        overloadId = 0; // isCopyOf(QPalette)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPaletteFunc_isCopyOf_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPalette cppArg0_local;
        ::QPalette *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // isCopyOf(QPalette)const
            bool cppResult = const_cast<const ::QPalette *>(cppSelf)->isCopyOf(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPaletteFunc_isCopyOf_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPaletteFunc_isEqual(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPalette *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPalette.isEqual";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "isEqual", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QPalette::isEqual(QPalette::ColorGroup,QPalette::ColorGroup)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORGROUP_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORGROUP_IDX])->converter, (pyArgs[1])))) {
        overloadId = 0; // isEqual(QPalette::ColorGroup,QPalette::ColorGroup)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPaletteFunc_isEqual_TypeError;

    // Call function/method
    {
        ::QPalette::ColorGroup cppArg0{QPalette::Normal};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QPalette::ColorGroup cppArg1{QPalette::Normal};
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // isEqual(QPalette::ColorGroup,QPalette::ColorGroup)const
            bool cppResult = const_cast<const ::QPalette *>(cppSelf)->isEqual(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPaletteFunc_isEqual_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPaletteFunc_light(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPalette *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPalette.light";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // light()const
            const QBrush & cppResult = const_cast<const ::QPalette *>(cppSelf)->light();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaletteFunc_link(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPalette *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPalette.link";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // link()const
            const QBrush & cppResult = const_cast<const ::QPalette *>(cppSelf)->link();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaletteFunc_linkVisited(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPalette *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPalette.linkVisited";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // linkVisited()const
            const QBrush & cppResult = const_cast<const ::QPalette *>(cppSelf)->linkVisited();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaletteFunc_mid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPalette *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPalette.mid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mid()const
            const QBrush & cppResult = const_cast<const ::QPalette *>(cppSelf)->mid();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaletteFunc_midlight(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPalette *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPalette.midlight";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // midlight()const
            const QBrush & cppResult = const_cast<const ::QPalette *>(cppSelf)->midlight();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaletteFunc_placeholderText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPalette *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPalette.placeholderText";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // placeholderText()const
            const QBrush & cppResult = const_cast<const ::QPalette *>(cppSelf)->placeholderText();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaletteFunc_resolve(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPalette *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPalette.resolve";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "resolve", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QPalette::resolve()const
    // 1: QPalette::resolve(QPalette)const
    // 2: QPalette::resolve(uint)
    if (numArgs == 0) {
        overloadId = 0; // resolve()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), (pyArgs[0])))) {
        overloadId = 2; // resolve(uint)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX]), (pyArgs[0])))) {
        overloadId = 1; // resolve(QPalette)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPaletteFunc_resolve_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // resolve() const
        {

            if (!PyErr_Occurred()) {
                // resolve()const
                uint cppResult = const_cast<const ::QPalette *>(cppSelf)->resolve();
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<uint>(), &cppResult);
            }
            break;
        }
        case 1: // resolve(const QPalette & arg__1) const
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QPalette cppArg0_local;
            ::QPalette *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // resolve(QPalette)const
                QPalette cppResult = const_cast<const ::QPalette *>(cppSelf)->resolve(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX]), &cppResult);
            }
            break;
        }
        case 2: // resolve(uint mask)
        {
            uint cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // resolve(uint)
                cppSelf->resolve(cppArg0);
                pyResult = Py_None;
                Py_INCREF(Py_None);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPaletteFunc_resolve_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPaletteFunc_setBrush(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPalette *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPalette.setBrush";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setBrush", 2, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QPalette::setBrush(QPalette::ColorGroup,QPalette::ColorRole,QBrush)
    // 1: QPalette::setBrush(QPalette::ColorRole,QBrush)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArgs[1])))) {
        overloadId = 1; // setBrush(QPalette::ColorRole,QBrush)
    } else if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORGROUP_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX])->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArgs[2])))) {
        overloadId = 0; // setBrush(QPalette::ColorGroup,QPalette::ColorRole,QBrush)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPaletteFunc_setBrush_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setBrush(QPalette::ColorGroup cg, QPalette::ColorRole cr, const QBrush & brush)
        {
            ::QPalette::ColorGroup cppArg0{QPalette::Normal};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QPalette::ColorRole cppArg1{QPalette::Foreground};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QBrush cppArg2_local;
            ::QBrush *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);


            if (!PyErr_Occurred()) {
                // setBrush(QPalette::ColorGroup,QPalette::ColorRole,QBrush)
                cppSelf->setBrush(cppArg0, cppArg1, *cppArg2);
            }
            break;
        }
        case 1: // setBrush(QPalette::ColorRole cr, const QBrush & brush)
        {
            ::QPalette::ColorRole cppArg0{QPalette::Foreground};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QBrush cppArg1_local;
            ::QBrush *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setBrush(QPalette::ColorRole,QBrush)
                cppSelf->setBrush(cppArg0, *cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPaletteFunc_setBrush_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPaletteFunc_setColor(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPalette *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPalette.setColor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setColor", 2, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QPalette::setColor(QPalette::ColorGroup,QPalette::ColorRole,QColor)
    // 1: QPalette::setColor(QPalette::ColorRole,QColor)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArgs[1])))) {
        overloadId = 1; // setColor(QPalette::ColorRole,QColor)
    } else if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORGROUP_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX])->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), (pyArgs[2])))) {
        overloadId = 0; // setColor(QPalette::ColorGroup,QPalette::ColorRole,QColor)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPaletteFunc_setColor_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setColor(QPalette::ColorGroup cg, QPalette::ColorRole cr, const QColor & color)
        {
            ::QPalette::ColorGroup cppArg0{QPalette::Normal};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QPalette::ColorRole cppArg1{QPalette::Foreground};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QColor cppArg2_local;
            ::QColor *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);


            if (!PyErr_Occurred()) {
                // setColor(QPalette::ColorGroup,QPalette::ColorRole,QColor)
                cppSelf->setColor(cppArg0, cppArg1, *cppArg2);
            }
            break;
        }
        case 1: // setColor(QPalette::ColorRole cr, const QColor & color)
        {
            ::QPalette::ColorRole cppArg0{QPalette::Foreground};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QColor cppArg1_local;
            ::QColor *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // setColor(QPalette::ColorRole,QColor)
                cppSelf->setColor(cppArg0, *cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPaletteFunc_setColor_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPaletteFunc_setColorGroup(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPalette *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPalette.setColorGroup";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setColorGroup", 10, 10, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8]), &(pyArgs[9])))
        return {};


    // Overloaded function decisor
    // 0: QPalette::setColorGroup(QPalette::ColorGroup,QBrush,QBrush,QBrush,QBrush,QBrush,QBrush,QBrush,QBrush,QBrush)
    if (numArgs == 10
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORGROUP_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArgs[5])))
        && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArgs[6])))
        && (pythonToCpp[7] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArgs[7])))
        && (pythonToCpp[8] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArgs[8])))
        && (pythonToCpp[9] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyArgs[9])))) {
        overloadId = 0; // setColorGroup(QPalette::ColorGroup,QBrush,QBrush,QBrush,QBrush,QBrush,QBrush,QBrush,QBrush,QBrush)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPaletteFunc_setColorGroup_TypeError;

    // Call function/method
    {
        ::QPalette::ColorGroup cppArg0{QPalette::Normal};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QBrush cppArg1_local;
        ::QBrush *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QBrush cppArg2_local;
        ::QBrush *cppArg2 = &cppArg2_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp[2]))
            pythonToCpp[2](pyArgs[2], &cppArg2_local);
        else
            pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!Shiboken::Object::isValid(pyArgs[3]))
            return {};
        ::QBrush cppArg3_local;
        ::QBrush *cppArg3 = &cppArg3_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp[3]))
            pythonToCpp[3](pyArgs[3], &cppArg3_local);
        else
            pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!Shiboken::Object::isValid(pyArgs[4]))
            return {};
        ::QBrush cppArg4_local;
        ::QBrush *cppArg4 = &cppArg4_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp[4]))
            pythonToCpp[4](pyArgs[4], &cppArg4_local);
        else
            pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!Shiboken::Object::isValid(pyArgs[5]))
            return {};
        ::QBrush cppArg5_local;
        ::QBrush *cppArg5 = &cppArg5_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp[5]))
            pythonToCpp[5](pyArgs[5], &cppArg5_local);
        else
            pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!Shiboken::Object::isValid(pyArgs[6]))
            return {};
        ::QBrush cppArg6_local;
        ::QBrush *cppArg6 = &cppArg6_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp[6]))
            pythonToCpp[6](pyArgs[6], &cppArg6_local);
        else
            pythonToCpp[6](pyArgs[6], &cppArg6);

        if (!Shiboken::Object::isValid(pyArgs[7]))
            return {};
        ::QBrush cppArg7_local;
        ::QBrush *cppArg7 = &cppArg7_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp[7]))
            pythonToCpp[7](pyArgs[7], &cppArg7_local);
        else
            pythonToCpp[7](pyArgs[7], &cppArg7);

        if (!Shiboken::Object::isValid(pyArgs[8]))
            return {};
        ::QBrush cppArg8_local;
        ::QBrush *cppArg8 = &cppArg8_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp[8]))
            pythonToCpp[8](pyArgs[8], &cppArg8_local);
        else
            pythonToCpp[8](pyArgs[8], &cppArg8);

        if (!Shiboken::Object::isValid(pyArgs[9]))
            return {};
        ::QBrush cppArg9_local;
        ::QBrush *cppArg9 = &cppArg9_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), pythonToCpp[9]))
            pythonToCpp[9](pyArgs[9], &cppArg9_local);
        else
            pythonToCpp[9](pyArgs[9], &cppArg9);


        if (!PyErr_Occurred()) {
            // setColorGroup(QPalette::ColorGroup,QBrush,QBrush,QBrush,QBrush,QBrush,QBrush,QBrush,QBrush,QBrush)
            cppSelf->setColorGroup(cppArg0, *cppArg1, *cppArg2, *cppArg3, *cppArg4, *cppArg5, *cppArg6, *cppArg7, *cppArg8, *cppArg9);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPaletteFunc_setColorGroup_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPaletteFunc_setCurrentColorGroup(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPalette *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPalette.setCurrentColorGroup";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPalette::setCurrentColorGroup(QPalette::ColorGroup)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORGROUP_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setCurrentColorGroup(QPalette::ColorGroup)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPaletteFunc_setCurrentColorGroup_TypeError;

    // Call function/method
    {
        ::QPalette::ColorGroup cppArg0{QPalette::Normal};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setCurrentColorGroup(QPalette::ColorGroup)
            cppSelf->setCurrentColorGroup(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPaletteFunc_setCurrentColorGroup_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPaletteFunc_shadow(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPalette *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPalette.shadow";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // shadow()const
            const QBrush & cppResult = const_cast<const ::QPalette *>(cppSelf)->shadow();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaletteFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPalette *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPalette.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPalette::swap(QPalette&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QPalette&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPaletteFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPalette cppArg0_local;
        ::QPalette *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QPalette&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPaletteFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPaletteFunc_text(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPalette *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPalette.text";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // text()const
            const QBrush & cppResult = const_cast<const ::QPalette *>(cppSelf)->text();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaletteFunc_toolTipBase(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPalette *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPalette.toolTipBase";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toolTipBase()const
            const QBrush & cppResult = const_cast<const ::QPalette *>(cppSelf)->toolTipBase();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaletteFunc_toolTipText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPalette *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPalette.toolTipText";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // toolTipText()const
            const QBrush & cppResult = const_cast<const ::QPalette *>(cppSelf)->toolTipText();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaletteFunc_window(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPalette *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPalette.window";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // window()const
            const QBrush & cppResult = const_cast<const ::QPalette *>(cppSelf)->window();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaletteFunc_windowText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPalette *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPalette.windowText";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // windowText()const
            const QBrush & cppResult = const_cast<const ::QPalette *>(cppSelf)->windowText();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPalette___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QPalette *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QPalette_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QPalette_methods[] = {
    {"alternateBase", reinterpret_cast<PyCFunction>(Sbk_QPaletteFunc_alternateBase), METH_NOARGS},
    {"background", reinterpret_cast<PyCFunction>(Sbk_QPaletteFunc_background), METH_NOARGS},
    {"base", reinterpret_cast<PyCFunction>(Sbk_QPaletteFunc_base), METH_NOARGS},
    {"brightText", reinterpret_cast<PyCFunction>(Sbk_QPaletteFunc_brightText), METH_NOARGS},
    {"brush", reinterpret_cast<PyCFunction>(Sbk_QPaletteFunc_brush), METH_VARARGS},
    {"button", reinterpret_cast<PyCFunction>(Sbk_QPaletteFunc_button), METH_NOARGS},
    {"buttonText", reinterpret_cast<PyCFunction>(Sbk_QPaletteFunc_buttonText), METH_NOARGS},
    {"cacheKey", reinterpret_cast<PyCFunction>(Sbk_QPaletteFunc_cacheKey), METH_NOARGS},
    {"color", reinterpret_cast<PyCFunction>(Sbk_QPaletteFunc_color), METH_VARARGS},
    {"currentColorGroup", reinterpret_cast<PyCFunction>(Sbk_QPaletteFunc_currentColorGroup), METH_NOARGS},
    {"dark", reinterpret_cast<PyCFunction>(Sbk_QPaletteFunc_dark), METH_NOARGS},
    {"foreground", reinterpret_cast<PyCFunction>(Sbk_QPaletteFunc_foreground), METH_NOARGS},
    {"highlight", reinterpret_cast<PyCFunction>(Sbk_QPaletteFunc_highlight), METH_NOARGS},
    {"highlightedText", reinterpret_cast<PyCFunction>(Sbk_QPaletteFunc_highlightedText), METH_NOARGS},
    {"isBrushSet", reinterpret_cast<PyCFunction>(Sbk_QPaletteFunc_isBrushSet), METH_VARARGS},
    {"isCopyOf", reinterpret_cast<PyCFunction>(Sbk_QPaletteFunc_isCopyOf), METH_O},
    {"isEqual", reinterpret_cast<PyCFunction>(Sbk_QPaletteFunc_isEqual), METH_VARARGS},
    {"light", reinterpret_cast<PyCFunction>(Sbk_QPaletteFunc_light), METH_NOARGS},
    {"link", reinterpret_cast<PyCFunction>(Sbk_QPaletteFunc_link), METH_NOARGS},
    {"linkVisited", reinterpret_cast<PyCFunction>(Sbk_QPaletteFunc_linkVisited), METH_NOARGS},
    {"mid", reinterpret_cast<PyCFunction>(Sbk_QPaletteFunc_mid), METH_NOARGS},
    {"midlight", reinterpret_cast<PyCFunction>(Sbk_QPaletteFunc_midlight), METH_NOARGS},
    {"placeholderText", reinterpret_cast<PyCFunction>(Sbk_QPaletteFunc_placeholderText), METH_NOARGS},
    {"resolve", reinterpret_cast<PyCFunction>(Sbk_QPaletteFunc_resolve), METH_VARARGS},
    {"setBrush", reinterpret_cast<PyCFunction>(Sbk_QPaletteFunc_setBrush), METH_VARARGS},
    {"setColor", reinterpret_cast<PyCFunction>(Sbk_QPaletteFunc_setColor), METH_VARARGS},
    {"setColorGroup", reinterpret_cast<PyCFunction>(Sbk_QPaletteFunc_setColorGroup), METH_VARARGS},
    {"setCurrentColorGroup", reinterpret_cast<PyCFunction>(Sbk_QPaletteFunc_setCurrentColorGroup), METH_O},
    {"shadow", reinterpret_cast<PyCFunction>(Sbk_QPaletteFunc_shadow), METH_NOARGS},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QPaletteFunc_swap), METH_O},
    {"text", reinterpret_cast<PyCFunction>(Sbk_QPaletteFunc_text), METH_NOARGS},
    {"toolTipBase", reinterpret_cast<PyCFunction>(Sbk_QPaletteFunc_toolTipBase), METH_NOARGS},
    {"toolTipText", reinterpret_cast<PyCFunction>(Sbk_QPaletteFunc_toolTipText), METH_NOARGS},
    {"window", reinterpret_cast<PyCFunction>(Sbk_QPaletteFunc_window), METH_NOARGS},
    {"windowText", reinterpret_cast<PyCFunction>(Sbk_QPaletteFunc_windowText), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QPalette___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QPaletteFunc___lshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPalette *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPalette.__lshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rlshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QPalette::operator<<(QDataStream&,QPalette)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator<<(QDataStream&,QPalette)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QPaletteFunc___lshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDataStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator<<(QDataStream&,QPalette) [reverse operator]
                QDataStream & cppResult = (*cppArg0) << (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPaletteFunc___lshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPaletteFunc___rshift__(PyObject *self, PyObject *pyArg)
{
    bool isReverse = SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], pyArg)
                    && !SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], self);
    if (isReverse)
        std::swap(self, pyArg);
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPalette *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPalette.__rshift__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    Shiboken::AutoDecRef attrName(Py_BuildValue("s", "__rrshift__"));
    if (!isReverse
        && Shiboken::Object::checkType(pyArg)
        && !PyObject_TypeCheck(pyArg, self->ob_type)
        && PyObject_HasAttr(pyArg, attrName)) {
        PyObject *revOpMethod = PyObject_GetAttr(pyArg, attrName);
        if (revOpMethod && PyCallable_Check(revOpMethod)) {
            pyResult = PyObject_CallFunction(revOpMethod, const_cast<char *>("O"), self);
            if (PyErr_Occurred() && (PyErr_ExceptionMatches(PyExc_NotImplementedError) || PyErr_ExceptionMatches(PyExc_AttributeError))) {
                PyErr_Clear();
                Py_XDECREF(pyResult);
                pyResult = nullptr;
            }
        }
        Py_XDECREF(revOpMethod);

    }

    // Do not enter here if other object has implemented a reverse operator.
    if (!pyResult) {
        // Overloaded function decisor
        // 0: QPalette::operator>>(QDataStream&,QPalette&)
        if (isReverse
            && (pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), (pyArg)))) {
            overloadId = 0; // operator>>(QDataStream&,QPalette&)
        }

        if (isReverse && overloadId == -1) {
            PyErr_SetString(PyExc_NotImplementedError, "reverse operator not implemented.");
            return {};
        }

        // Function signature not found.
        if (overloadId == -1) goto Sbk_QPaletteFunc___rshift___TypeError;

        // Call function/method
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDataStream *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // operator>>(QDataStream&,QPalette&) [reverse operator]
                QDataStream & cppResult = (*cppArg0) >> (*cppSelf);
                pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDATASTREAM_IDX]), &cppResult);
            }
        }

    } // End of "if (!pyResult)"

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPaletteFunc___rshift___TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

// Rich comparison
static PyObject * Sbk_QPalette_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QPalette *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX]), (pyArg)))) {
                // operator!=(const QPalette & p) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QPalette cppArg0_local;
                ::QPalette *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX]), (pyArg)))) {
                // operator==(const QPalette & p) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QPalette cppArg0_local;
                ::QPalette *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QPalette_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QPalette_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QPalette_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QPalette_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QPalette__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPalette *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QPalette_Type = nullptr;
static SbkObjectType *Sbk_QPalette_TypeF(void)
{
    return _Sbk_QPalette_Type;
}

static PyType_Slot Sbk_QPalette_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QPalette__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QPalette_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QPalette_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QPalette_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QPalette_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QPalette_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
    {Py_nb_rshift, (void *)Sbk_QPaletteFunc___rshift__},
    {Py_nb_lshift, (void *)Sbk_QPaletteFunc___lshift__},
    {0, nullptr}
};
static PyType_Spec Sbk_QPalette_spec = {
    "2:PySide2.QtGui.QPalette",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QPalette_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QPalette_ColorGroup_PythonToCpp_QPalette_ColorGroup(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPalette::ColorGroup *>(cppOut) =
        static_cast<::QPalette::ColorGroup>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QPalette_ColorGroup_PythonToCpp_QPalette_ColorGroup_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORGROUP_IDX]))
        return QPalette_ColorGroup_PythonToCpp_QPalette_ColorGroup;
    return {};
}
static PyObject *QPalette_ColorGroup_CppToPython_QPalette_ColorGroup(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QPalette::ColorGroup *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORGROUP_IDX], castCppIn);

}

static void QPalette_ColorRole_PythonToCpp_QPalette_ColorRole(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPalette::ColorRole *>(cppOut) =
        static_cast<::QPalette::ColorRole>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QPalette_ColorRole_PythonToCpp_QPalette_ColorRole_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX]))
        return QPalette_ColorRole_PythonToCpp_QPalette_ColorRole;
    return {};
}
static PyObject *QPalette_ColorRole_CppToPython_QPalette_ColorRole(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QPalette::ColorRole *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QPalette_PythonToCpp_QPalette_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QPalette_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QPalette_PythonToCpp_QPalette_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QPalette_TypeF())))
        return QPalette_PythonToCpp_QPalette_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QPalette_PTR_CppToPython_QPalette(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QPalette *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QPalette_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QPalette_COPY_CppToPython_QPalette(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QPalette_TypeF(), new ::QPalette(*reinterpret_cast<const ::QPalette *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QPalette_PythonToCpp_QPalette_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPalette *>(cppOut) = *reinterpret_cast< ::QPalette *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QPalette_PythonToCpp_QPalette_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QPalette_TypeF())))
        return QPalette_PythonToCpp_QPalette_COPY;
    return {};
}

// Implicit conversions.
static void PySide2_QtCore_Qt_GlobalColor_PythonToCpp_QPalette(PyObject *pyIn, void *cppOut) {
    ::Qt::GlobalColor cppIn{Qt::color0};
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX])->converter, pyIn, &cppIn);
    *reinterpret_cast<::QPalette *>(cppOut) = ::QPalette(cppIn);
}
static PythonToCppFunc is_PySide2_QtCore_Qt_GlobalColor_PythonToCpp_QPalette_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QT_GLOBALCOLOR_IDX], pyIn))
        return PySide2_QtCore_Qt_GlobalColor_PythonToCpp_QPalette;
    return {};
}

static void constQColorREF_PythonToCpp_QPalette(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPalette *>(cppOut) = ::QPalette( *reinterpret_cast< ::QColor *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_constQColorREF_PythonToCpp_QPalette_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtGuiTypes[SBK_QCOLOR_IDX], pyIn))
        return constQColorREF_PythonToCpp_QPalette;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QPalette_SignatureStrings[] = {
    "6:PySide2.QtGui.QPalette(self)",
    "5:PySide2.QtGui.QPalette(self,button:PySide2.QtCore.Qt.GlobalColor)",
    "4:PySide2.QtGui.QPalette(self,windowText:PySide2.QtGui.QBrush,button:PySide2.QtGui.QBrush,light:PySide2.QtGui.QBrush,dark:PySide2.QtGui.QBrush,mid:PySide2.QtGui.QBrush,text:PySide2.QtGui.QBrush,bright_text:PySide2.QtGui.QBrush,base:PySide2.QtGui.QBrush,window:PySide2.QtGui.QBrush)",
    "3:PySide2.QtGui.QPalette(self,button:PySide2.QtGui.QColor)",
    "2:PySide2.QtGui.QPalette(self,button:PySide2.QtGui.QColor,window:PySide2.QtGui.QColor)",
    "1:PySide2.QtGui.QPalette(self,windowText:PySide2.QtGui.QColor,window:PySide2.QtGui.QColor,light:PySide2.QtGui.QColor,dark:PySide2.QtGui.QColor,mid:PySide2.QtGui.QColor,text:PySide2.QtGui.QColor,base:PySide2.QtGui.QColor)",
    "0:PySide2.QtGui.QPalette(self,palette:PySide2.QtGui.QPalette)",
    "PySide2.QtGui.QPalette.alternateBase(self)->PySide2.QtGui.QBrush",
    "PySide2.QtGui.QPalette.background(self)->PySide2.QtGui.QBrush",
    "PySide2.QtGui.QPalette.base(self)->PySide2.QtGui.QBrush",
    "PySide2.QtGui.QPalette.brightText(self)->PySide2.QtGui.QBrush",
    "1:PySide2.QtGui.QPalette.brush(self,cg:PySide2.QtGui.QPalette.ColorGroup,cr:PySide2.QtGui.QPalette.ColorRole)->PySide2.QtGui.QBrush",
    "0:PySide2.QtGui.QPalette.brush(self,cr:PySide2.QtGui.QPalette.ColorRole)->PySide2.QtGui.QBrush",
    "PySide2.QtGui.QPalette.button(self)->PySide2.QtGui.QBrush",
    "PySide2.QtGui.QPalette.buttonText(self)->PySide2.QtGui.QBrush",
    "PySide2.QtGui.QPalette.cacheKey(self)->qint64",
    "1:PySide2.QtGui.QPalette.color(self,cg:PySide2.QtGui.QPalette.ColorGroup,cr:PySide2.QtGui.QPalette.ColorRole)->PySide2.QtGui.QColor",
    "0:PySide2.QtGui.QPalette.color(self,cr:PySide2.QtGui.QPalette.ColorRole)->PySide2.QtGui.QColor",
    "PySide2.QtGui.QPalette.currentColorGroup(self)->PySide2.QtGui.QPalette.ColorGroup",
    "PySide2.QtGui.QPalette.dark(self)->PySide2.QtGui.QBrush",
    "PySide2.QtGui.QPalette.foreground(self)->PySide2.QtGui.QBrush",
    "PySide2.QtGui.QPalette.highlight(self)->PySide2.QtGui.QBrush",
    "PySide2.QtGui.QPalette.highlightedText(self)->PySide2.QtGui.QBrush",
    "PySide2.QtGui.QPalette.isBrushSet(self,cg:PySide2.QtGui.QPalette.ColorGroup,cr:PySide2.QtGui.QPalette.ColorRole)->bool",
    "PySide2.QtGui.QPalette.isCopyOf(self,p:PySide2.QtGui.QPalette)->bool",
    "PySide2.QtGui.QPalette.isEqual(self,cr1:PySide2.QtGui.QPalette.ColorGroup,cr2:PySide2.QtGui.QPalette.ColorGroup)->bool",
    "PySide2.QtGui.QPalette.light(self)->PySide2.QtGui.QBrush",
    "PySide2.QtGui.QPalette.link(self)->PySide2.QtGui.QBrush",
    "PySide2.QtGui.QPalette.linkVisited(self)->PySide2.QtGui.QBrush",
    "PySide2.QtGui.QPalette.mid(self)->PySide2.QtGui.QBrush",
    "PySide2.QtGui.QPalette.midlight(self)->PySide2.QtGui.QBrush",
    "PySide2.QtGui.QPalette.placeholderText(self)->PySide2.QtGui.QBrush",
    "2:PySide2.QtGui.QPalette.resolve(self)->uint",
    "1:PySide2.QtGui.QPalette.resolve(self,arg__1:PySide2.QtGui.QPalette)->PySide2.QtGui.QPalette",
    "0:PySide2.QtGui.QPalette.resolve(self,mask:uint)",
    "1:PySide2.QtGui.QPalette.setBrush(self,cg:PySide2.QtGui.QPalette.ColorGroup,cr:PySide2.QtGui.QPalette.ColorRole,brush:PySide2.QtGui.QBrush)",
    "0:PySide2.QtGui.QPalette.setBrush(self,cr:PySide2.QtGui.QPalette.ColorRole,brush:PySide2.QtGui.QBrush)",
    "1:PySide2.QtGui.QPalette.setColor(self,cg:PySide2.QtGui.QPalette.ColorGroup,cr:PySide2.QtGui.QPalette.ColorRole,color:PySide2.QtGui.QColor)",
    "0:PySide2.QtGui.QPalette.setColor(self,cr:PySide2.QtGui.QPalette.ColorRole,color:PySide2.QtGui.QColor)",
    "PySide2.QtGui.QPalette.setColorGroup(self,cr:PySide2.QtGui.QPalette.ColorGroup,windowText:PySide2.QtGui.QBrush,button:PySide2.QtGui.QBrush,light:PySide2.QtGui.QBrush,dark:PySide2.QtGui.QBrush,mid:PySide2.QtGui.QBrush,text:PySide2.QtGui.QBrush,bright_text:PySide2.QtGui.QBrush,base:PySide2.QtGui.QBrush,window:PySide2.QtGui.QBrush)",
    "PySide2.QtGui.QPalette.setCurrentColorGroup(self,cg:PySide2.QtGui.QPalette.ColorGroup)",
    "PySide2.QtGui.QPalette.shadow(self)->PySide2.QtGui.QBrush",
    "PySide2.QtGui.QPalette.swap(self,other:PySide2.QtGui.QPalette)",
    "PySide2.QtGui.QPalette.text(self)->PySide2.QtGui.QBrush",
    "PySide2.QtGui.QPalette.toolTipBase(self)->PySide2.QtGui.QBrush",
    "PySide2.QtGui.QPalette.toolTipText(self)->PySide2.QtGui.QBrush",
    "PySide2.QtGui.QPalette.window(self)->PySide2.QtGui.QBrush",
    "PySide2.QtGui.QPalette.windowText(self)->PySide2.QtGui.QBrush",
    "PySide2.QtGui.QPalette.__copy__()",
    "PySide2.QtGui.QPalette.__lshift__(self,ds:PySide2.QtCore.QDataStream)->PySide2.QtCore.QDataStream",
    "PySide2.QtGui.QPalette.__rshift__(self,ds:PySide2.QtCore.QDataStream)->PySide2.QtCore.QDataStream",
    nullptr}; // Sentinel

void init_QPalette(PyObject *module)
{
    _Sbk_QPalette_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QPalette",
        "QPalette",
        &Sbk_QPalette_spec,
        &Shiboken::callCppDestructor< ::QPalette >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QPalette_Type);
    InitSignatureStrings(pyType, QPalette_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QPalette_Type), Sbk_QPalette_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QPalette_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QPalette_TypeF(),
        QPalette_PythonToCpp_QPalette_PTR,
        is_QPalette_PythonToCpp_QPalette_PTR_Convertible,
        QPalette_PTR_CppToPython_QPalette,
        QPalette_COPY_CppToPython_QPalette);

    Shiboken::Conversions::registerConverterName(converter, "QPalette");
    Shiboken::Conversions::registerConverterName(converter, "QPalette*");
    Shiboken::Conversions::registerConverterName(converter, "QPalette&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QPalette).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QPalette_PythonToCpp_QPalette_COPY,
        is_QPalette_PythonToCpp_QPalette_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtCore_Qt_GlobalColor_PythonToCpp_QPalette,
        is_PySide2_QtCore_Qt_GlobalColor_PythonToCpp_QPalette_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        constQColorREF_PythonToCpp_QPalette,
        is_constQColorREF_PythonToCpp_QPalette_Convertible);

    // Initialization of enums.

    // Initialization of enum 'ColorGroup'.
    SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORGROUP_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QPalette_TypeF(),
        "ColorGroup",
        "2:PySide2.QtGui.QPalette.ColorGroup",
        "QPalette::ColorGroup");
    if (!SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORGROUP_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORGROUP_IDX],
        Sbk_QPalette_TypeF(), "Active", (long) QPalette::ColorGroup::Active))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORGROUP_IDX],
        Sbk_QPalette_TypeF(), "Disabled", (long) QPalette::ColorGroup::Disabled))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORGROUP_IDX],
        Sbk_QPalette_TypeF(), "Inactive", (long) QPalette::ColorGroup::Inactive))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORGROUP_IDX],
        Sbk_QPalette_TypeF(), "NColorGroups", (long) QPalette::ColorGroup::NColorGroups))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORGROUP_IDX],
        Sbk_QPalette_TypeF(), "Current", (long) QPalette::ColorGroup::Current))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORGROUP_IDX],
        Sbk_QPalette_TypeF(), "All", (long) QPalette::ColorGroup::All))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORGROUP_IDX],
        Sbk_QPalette_TypeF(), "Normal", (long) QPalette::ColorGroup::Normal))
        return;
    // Register converter for enum 'QPalette::ColorGroup'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORGROUP_IDX],
            QPalette_ColorGroup_CppToPython_QPalette_ColorGroup);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QPalette_ColorGroup_PythonToCpp_QPalette_ColorGroup,
            is_QPalette_ColorGroup_PythonToCpp_QPalette_ColorGroup_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORGROUP_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QPalette::ColorGroup");
        Shiboken::Conversions::registerConverterName(converter, "ColorGroup");
    }
    // End of 'ColorGroup' enum.

    // Initialization of enum 'ColorRole'.
    SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QPalette_TypeF(),
        "ColorRole",
        "2:PySide2.QtGui.QPalette.ColorRole",
        "QPalette::ColorRole");
    if (!SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX],
        Sbk_QPalette_TypeF(), "WindowText", (long) QPalette::ColorRole::WindowText))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX],
        Sbk_QPalette_TypeF(), "Button", (long) QPalette::ColorRole::Button))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX],
        Sbk_QPalette_TypeF(), "Light", (long) QPalette::ColorRole::Light))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX],
        Sbk_QPalette_TypeF(), "Midlight", (long) QPalette::ColorRole::Midlight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX],
        Sbk_QPalette_TypeF(), "Dark", (long) QPalette::ColorRole::Dark))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX],
        Sbk_QPalette_TypeF(), "Mid", (long) QPalette::ColorRole::Mid))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX],
        Sbk_QPalette_TypeF(), "Text", (long) QPalette::ColorRole::Text))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX],
        Sbk_QPalette_TypeF(), "BrightText", (long) QPalette::ColorRole::BrightText))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX],
        Sbk_QPalette_TypeF(), "ButtonText", (long) QPalette::ColorRole::ButtonText))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX],
        Sbk_QPalette_TypeF(), "Base", (long) QPalette::ColorRole::Base))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX],
        Sbk_QPalette_TypeF(), "Window", (long) QPalette::ColorRole::Window))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX],
        Sbk_QPalette_TypeF(), "Shadow", (long) QPalette::ColorRole::Shadow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX],
        Sbk_QPalette_TypeF(), "Highlight", (long) QPalette::ColorRole::Highlight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX],
        Sbk_QPalette_TypeF(), "HighlightedText", (long) QPalette::ColorRole::HighlightedText))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX],
        Sbk_QPalette_TypeF(), "Link", (long) QPalette::ColorRole::Link))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX],
        Sbk_QPalette_TypeF(), "LinkVisited", (long) QPalette::ColorRole::LinkVisited))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX],
        Sbk_QPalette_TypeF(), "AlternateBase", (long) QPalette::ColorRole::AlternateBase))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX],
        Sbk_QPalette_TypeF(), "NoRole", (long) QPalette::ColorRole::NoRole))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX],
        Sbk_QPalette_TypeF(), "ToolTipBase", (long) QPalette::ColorRole::ToolTipBase))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX],
        Sbk_QPalette_TypeF(), "ToolTipText", (long) QPalette::ColorRole::ToolTipText))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX],
        Sbk_QPalette_TypeF(), "PlaceholderText", (long) QPalette::ColorRole::PlaceholderText))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX],
        Sbk_QPalette_TypeF(), "NColorRoles", (long) QPalette::ColorRole::NColorRoles))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX],
        Sbk_QPalette_TypeF(), "Foreground", (long) QPalette::ColorRole::Foreground))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX],
        Sbk_QPalette_TypeF(), "Background", (long) QPalette::ColorRole::Background))
        return;
    // Register converter for enum 'QPalette::ColorRole'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX],
            QPalette_ColorRole_CppToPython_QPalette_ColorRole);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QPalette_ColorRole_PythonToCpp_QPalette_ColorRole,
            is_QPalette_ColorRole_PythonToCpp_QPalette_ColorRole_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QPalette::ColorRole");
        Shiboken::Conversions::registerConverterName(converter, "ColorRole");
    }
    // End of 'ColorRole' enum.

    qRegisterMetaType< ::QPalette >("QPalette");
    qRegisterMetaType< ::QPalette::ColorGroup >("QPalette::ColorGroup");
    qRegisterMetaType< ::QPalette::ColorRole >("QPalette::ColorRole");
}
