/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qpainter_pixmapfragment_wrapper.h"

// inner classes

// Extra includes
#include <QPainter>
#include <qpoint.h>
#include <qrect.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QPainter_PixmapFragment_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QPainter::PixmapFragment >()))
        return -1;

    ::QPainter::PixmapFragment *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.PixmapFragment.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "PixmapFragment", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: PixmapFragment::PixmapFragment()
    // 1: PixmapFragment::PixmapFragment(QPainter::PixmapFragment)
    if (numArgs == 0) {
        overloadId = 0; // PixmapFragment()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_PIXMAPFRAGMENT_IDX]), (pyArgs[0])))) {
        overloadId = 1; // PixmapFragment(QPainter::PixmapFragment)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainter_PixmapFragment_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // PixmapFragment()
        {

            if (!PyErr_Occurred()) {
                // PixmapFragment()
                cptr = new ::QPainter::PixmapFragment();
            }
            break;
        }
        case 1: // PixmapFragment(const QPainter::PixmapFragment & PixmapFragment)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QPainter::PixmapFragment cppArg0_local;
            ::QPainter::PixmapFragment *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_PIXMAPFRAGMENT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // PixmapFragment(QPainter::PixmapFragment)
                cptr = new ::QPainter::PixmapFragment(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QPainter::PixmapFragment >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QPainter_PixmapFragment_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QPainter_PixmapFragment_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QPainter_PixmapFragmentFunc_create(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPainter.PixmapFragment.create";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 6) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPainter_PixmapFragmentFunc_create_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QPainter_PixmapFragmentFunc_create_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOOO:create", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: static PixmapFragment::create(QPointF,QRectF,qreal,qreal,qreal,qreal)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // create(QPointF,QRectF,qreal,qreal,qreal,qreal)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))) {
            if (numArgs == 3) {
                overloadId = 0; // create(QPointF,QRectF,qreal,qreal,qreal,qreal)
            } else if (numArgs >= 4
                && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[3])))) {
                if (numArgs == 4) {
                    overloadId = 0; // create(QPointF,QRectF,qreal,qreal,qreal,qreal)
                } else if (numArgs >= 5
                    && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[4])))) {
                    if (numArgs == 5) {
                        overloadId = 0; // create(QPointF,QRectF,qreal,qreal,qreal,qreal)
                    } else if (numArgs >= 6
                        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[5])))) {
                        overloadId = 0; // create(QPointF,QRectF,qreal,qreal,qreal,qreal)
                    }
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPainter_PixmapFragmentFunc_create_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_scaleX = Shiboken::String::createStaticString("scaleX");
            if (PyDict_Contains(kwds, key_scaleX)) {
                value = PyDict_GetItem(kwds, key_scaleX);
                if (value && pyArgs[2]) {
                    errInfo = key_scaleX;
                    Py_INCREF(errInfo);
                    goto Sbk_QPainter_PixmapFragmentFunc_create_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2]))))
                        goto Sbk_QPainter_PixmapFragmentFunc_create_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_scaleX);
            }
            static PyObject *const key_scaleY = Shiboken::String::createStaticString("scaleY");
            if (PyDict_Contains(kwds, key_scaleY)) {
                value = PyDict_GetItem(kwds, key_scaleY);
                if (value && pyArgs[3]) {
                    errInfo = key_scaleY;
                    Py_INCREF(errInfo);
                    goto Sbk_QPainter_PixmapFragmentFunc_create_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[3]))))
                        goto Sbk_QPainter_PixmapFragmentFunc_create_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_scaleY);
            }
            static PyObject *const key_rotation = Shiboken::String::createStaticString("rotation");
            if (PyDict_Contains(kwds, key_rotation)) {
                value = PyDict_GetItem(kwds, key_rotation);
                if (value && pyArgs[4]) {
                    errInfo = key_rotation;
                    Py_INCREF(errInfo);
                    goto Sbk_QPainter_PixmapFragmentFunc_create_TypeError;
                }
                if (value) {
                    pyArgs[4] = value;
                    if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[4]))))
                        goto Sbk_QPainter_PixmapFragmentFunc_create_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_rotation);
            }
            static PyObject *const key_opacity = Shiboken::String::createStaticString("opacity");
            if (PyDict_Contains(kwds, key_opacity)) {
                value = PyDict_GetItem(kwds, key_opacity);
                if (value && pyArgs[5]) {
                    errInfo = key_opacity;
                    Py_INCREF(errInfo);
                    goto Sbk_QPainter_PixmapFragmentFunc_create_TypeError;
                }
                if (value) {
                    pyArgs[5] = value;
                    if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[5]))))
                        goto Sbk_QPainter_PixmapFragmentFunc_create_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_opacity);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QPainter_PixmapFragmentFunc_create_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QPointF cppArg0_local;
        ::QPointF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QRectF cppArg1_local;
        ::QRectF *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        qreal cppArg2 = 1;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
        qreal cppArg3 = 1;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
        qreal cppArg4 = 0;
        if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);
        qreal cppArg5 = 1;
        if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // create(QPointF,QRectF,qreal,qreal,qreal,qreal)
            QPainter::PixmapFragment cppResult = ::QPainter::PixmapFragment::create(*cppArg0, *cppArg1, cppArg2, cppArg3, cppArg4, cppArg5);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_PIXMAPFRAGMENT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPainter_PixmapFragmentFunc_create_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPainter_PixmapFragment___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QPainter::PixmapFragment *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_PIXMAPFRAGMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_PIXMAPFRAGMENT_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QPainter_PixmapFragment_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QPainter_PixmapFragment_methods[] = {
    {"create", reinterpret_cast<PyCFunction>(Sbk_QPainter_PixmapFragmentFunc_create), METH_VARARGS|METH_KEYWORDS|METH_STATIC},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QPainter_PixmapFragment___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QPainter_PixmapFragment_get_x(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QPainter::PixmapFragment *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_PIXMAPFRAGMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppSelf->x);
    return pyOut;
}
static int Sbk_QPainter_PixmapFragment_set_x(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QPainter::PixmapFragment *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_PIXMAPFRAGMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'x' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'x', 'qreal' or convertible type expected");
        return -1;
    }

    qreal& cppOut_ptr = cppSelf->x;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QPainter_PixmapFragment_get_y(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QPainter::PixmapFragment *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_PIXMAPFRAGMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppSelf->y);
    return pyOut;
}
static int Sbk_QPainter_PixmapFragment_set_y(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QPainter::PixmapFragment *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_PIXMAPFRAGMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'y' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'y', 'qreal' or convertible type expected");
        return -1;
    }

    qreal& cppOut_ptr = cppSelf->y;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QPainter_PixmapFragment_get_sourceLeft(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QPainter::PixmapFragment *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_PIXMAPFRAGMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppSelf->sourceLeft);
    return pyOut;
}
static int Sbk_QPainter_PixmapFragment_set_sourceLeft(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QPainter::PixmapFragment *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_PIXMAPFRAGMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'sourceLeft' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'sourceLeft', 'qreal' or convertible type expected");
        return -1;
    }

    qreal& cppOut_ptr = cppSelf->sourceLeft;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QPainter_PixmapFragment_get_sourceTop(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QPainter::PixmapFragment *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_PIXMAPFRAGMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppSelf->sourceTop);
    return pyOut;
}
static int Sbk_QPainter_PixmapFragment_set_sourceTop(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QPainter::PixmapFragment *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_PIXMAPFRAGMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'sourceTop' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'sourceTop', 'qreal' or convertible type expected");
        return -1;
    }

    qreal& cppOut_ptr = cppSelf->sourceTop;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QPainter_PixmapFragment_get_width(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QPainter::PixmapFragment *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_PIXMAPFRAGMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppSelf->width);
    return pyOut;
}
static int Sbk_QPainter_PixmapFragment_set_width(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QPainter::PixmapFragment *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_PIXMAPFRAGMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'width' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'width', 'qreal' or convertible type expected");
        return -1;
    }

    qreal& cppOut_ptr = cppSelf->width;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QPainter_PixmapFragment_get_height(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QPainter::PixmapFragment *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_PIXMAPFRAGMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppSelf->height);
    return pyOut;
}
static int Sbk_QPainter_PixmapFragment_set_height(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QPainter::PixmapFragment *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_PIXMAPFRAGMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'height' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'height', 'qreal' or convertible type expected");
        return -1;
    }

    qreal& cppOut_ptr = cppSelf->height;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QPainter_PixmapFragment_get_scaleX(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QPainter::PixmapFragment *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_PIXMAPFRAGMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppSelf->scaleX);
    return pyOut;
}
static int Sbk_QPainter_PixmapFragment_set_scaleX(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QPainter::PixmapFragment *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_PIXMAPFRAGMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'scaleX' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'scaleX', 'qreal' or convertible type expected");
        return -1;
    }

    qreal& cppOut_ptr = cppSelf->scaleX;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QPainter_PixmapFragment_get_scaleY(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QPainter::PixmapFragment *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_PIXMAPFRAGMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppSelf->scaleY);
    return pyOut;
}
static int Sbk_QPainter_PixmapFragment_set_scaleY(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QPainter::PixmapFragment *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_PIXMAPFRAGMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'scaleY' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'scaleY', 'qreal' or convertible type expected");
        return -1;
    }

    qreal& cppOut_ptr = cppSelf->scaleY;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QPainter_PixmapFragment_get_rotation(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QPainter::PixmapFragment *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_PIXMAPFRAGMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppSelf->rotation);
    return pyOut;
}
static int Sbk_QPainter_PixmapFragment_set_rotation(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QPainter::PixmapFragment *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_PIXMAPFRAGMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'rotation' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'rotation', 'qreal' or convertible type expected");
        return -1;
    }

    qreal& cppOut_ptr = cppSelf->rotation;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QPainter_PixmapFragment_get_opacity(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QPainter::PixmapFragment *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_PIXMAPFRAGMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppSelf->opacity);
    return pyOut;
}
static int Sbk_QPainter_PixmapFragment_set_opacity(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QPainter::PixmapFragment *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_PIXMAPFRAGMENT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'opacity' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'opacity', 'qreal' or convertible type expected");
        return -1;
    }

    qreal& cppOut_ptr = cppSelf->opacity;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

// Getters and Setters for PixmapFragment
static PyGetSetDef Sbk_QPainter_PixmapFragment_getsetlist[] = {
    {const_cast<char *>("x"), Sbk_QPainter_PixmapFragment_get_x, Sbk_QPainter_PixmapFragment_set_x},
    {const_cast<char *>("y"), Sbk_QPainter_PixmapFragment_get_y, Sbk_QPainter_PixmapFragment_set_y},
    {const_cast<char *>("sourceLeft"), Sbk_QPainter_PixmapFragment_get_sourceLeft, Sbk_QPainter_PixmapFragment_set_sourceLeft},
    {const_cast<char *>("sourceTop"), Sbk_QPainter_PixmapFragment_get_sourceTop, Sbk_QPainter_PixmapFragment_set_sourceTop},
    {const_cast<char *>("width"), Sbk_QPainter_PixmapFragment_get_width, Sbk_QPainter_PixmapFragment_set_width},
    {const_cast<char *>("height"), Sbk_QPainter_PixmapFragment_get_height, Sbk_QPainter_PixmapFragment_set_height},
    {const_cast<char *>("scaleX"), Sbk_QPainter_PixmapFragment_get_scaleX, Sbk_QPainter_PixmapFragment_set_scaleX},
    {const_cast<char *>("scaleY"), Sbk_QPainter_PixmapFragment_get_scaleY, Sbk_QPainter_PixmapFragment_set_scaleY},
    {const_cast<char *>("rotation"), Sbk_QPainter_PixmapFragment_get_rotation, Sbk_QPainter_PixmapFragment_set_rotation},
    {const_cast<char *>("opacity"), Sbk_QPainter_PixmapFragment_get_opacity, Sbk_QPainter_PixmapFragment_set_opacity},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QPainter_PixmapFragment_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QPainter_PixmapFragment_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QPainter_PixmapFragment_Type = nullptr;
static SbkObjectType *Sbk_QPainter_PixmapFragment_TypeF(void)
{
    return _Sbk_QPainter_PixmapFragment_Type;
}

static PyType_Slot Sbk_QPainter_PixmapFragment_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QPainter_PixmapFragment_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QPainter_PixmapFragment_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QPainter_PixmapFragment_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QPainter_PixmapFragment_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QPainter_PixmapFragment_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QPainter_PixmapFragment_spec = {
    "2:PySide2.QtGui.QPainter.PixmapFragment",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QPainter_PixmapFragment_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void PixmapFragment_PythonToCpp_PixmapFragment_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QPainter_PixmapFragment_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_PixmapFragment_PythonToCpp_PixmapFragment_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QPainter_PixmapFragment_TypeF())))
        return PixmapFragment_PythonToCpp_PixmapFragment_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *PixmapFragment_PTR_CppToPython_PixmapFragment(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QPainter::PixmapFragment *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QPainter_PixmapFragment_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *PixmapFragment_COPY_CppToPython_PixmapFragment(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QPainter_PixmapFragment_TypeF(), new ::QPainter::PixmapFragment(*reinterpret_cast<const ::QPainter::PixmapFragment *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void PixmapFragment_PythonToCpp_PixmapFragment_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPainter::PixmapFragment *>(cppOut) = *reinterpret_cast< ::QPainter::PixmapFragment *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTER_PIXMAPFRAGMENT_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_PixmapFragment_PythonToCpp_PixmapFragment_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QPainter_PixmapFragment_TypeF())))
        return PixmapFragment_PythonToCpp_PixmapFragment_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QPainter_PixmapFragment_SignatureStrings[] = {
    "1:PySide2.QtGui.QPainter.PixmapFragment(self)",
    "0:PySide2.QtGui.QPainter.PixmapFragment(self,PixmapFragment:PySide2.QtGui.QPainter.PixmapFragment)",
    "PySide2.QtGui.QPainter.PixmapFragment.create(pos:PySide2.QtCore.QPointF,sourceRect:PySide2.QtCore.QRectF,scaleX:qreal=1,scaleY:qreal=1,rotation:qreal=0,opacity:qreal=1)->PySide2.QtGui.QPainter.PixmapFragment",
    "PySide2.QtGui.QPainter.PixmapFragment.__copy__()",
    nullptr}; // Sentinel

void init_QPainter_PixmapFragment(PyObject *enclosingClass)
{
    _Sbk_QPainter_PixmapFragment_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "PixmapFragment",
        "QPainter::PixmapFragment",
        &Sbk_QPainter_PixmapFragment_spec,
        &Shiboken::callCppDestructor< ::QPainter::PixmapFragment >,
        0,
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QPainter_PixmapFragment_Type);
    InitSignatureStrings(pyType, QPainter_PixmapFragment_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QPainter_PixmapFragment_Type), Sbk_QPainter_PixmapFragment_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QPAINTER_PIXMAPFRAGMENT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QPainter_PixmapFragment_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QPainter_PixmapFragment_TypeF(),
        PixmapFragment_PythonToCpp_PixmapFragment_PTR,
        is_PixmapFragment_PythonToCpp_PixmapFragment_PTR_Convertible,
        PixmapFragment_PTR_CppToPython_PixmapFragment,
        PixmapFragment_COPY_CppToPython_PixmapFragment);

    Shiboken::Conversions::registerConverterName(converter, "QPainter::PixmapFragment");
    Shiboken::Conversions::registerConverterName(converter, "QPainter::PixmapFragment*");
    Shiboken::Conversions::registerConverterName(converter, "QPainter::PixmapFragment&");
    Shiboken::Conversions::registerConverterName(converter, "PixmapFragment");
    Shiboken::Conversions::registerConverterName(converter, "PixmapFragment*");
    Shiboken::Conversions::registerConverterName(converter, "PixmapFragment&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QPainter::PixmapFragment).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PixmapFragment_PythonToCpp_PixmapFragment_COPY,
        is_PixmapFragment_PythonToCpp_PixmapFragment_COPY_Convertible);

    qRegisterMetaType< ::QPainter::PixmapFragment >("PixmapFragment");
    qRegisterMetaType< ::QPainter::PixmapFragment >("QPainter::PixmapFragment");
}
