/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qpaintenginestate_wrapper.h"

// inner classes

// Extra includes
#include <QPainterPath>
#include <QtGui/qbrush.h>
#include <QtGui/qfont.h>
#include <QtGui/qmatrix.h>
#include <QtGui/qpainter.h>
#include <QtGui/qpainterpath.h>
#include <QtGui/qpen.h>
#include <QtGui/qregion.h>
#include <QtGui/qtransform.h>
#include <qpoint.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QPaintEngineState_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QPaintEngineState >()))
        return -1;

    ::QPaintEngineState *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngineState.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QPaintEngineState()
            cptr = new ::QPaintEngineState();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QPaintEngineState >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QPaintEngineStateFunc_backgroundBrush(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngineState *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINESTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngineState.backgroundBrush";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // backgroundBrush()const
            QBrush cppResult = const_cast<const ::QPaintEngineState *>(cppSelf)->backgroundBrush();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaintEngineStateFunc_backgroundMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngineState *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINESTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngineState.backgroundMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // backgroundMode()const
            Qt::BGMode cppResult = const_cast<const ::QPaintEngineState *>(cppSelf)->backgroundMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_BGMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaintEngineStateFunc_brush(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngineState *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINESTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngineState.brush";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // brush()const
            QBrush cppResult = const_cast<const ::QPaintEngineState *>(cppSelf)->brush();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaintEngineStateFunc_brushNeedsResolving(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngineState *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINESTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngineState.brushNeedsResolving";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // brushNeedsResolving()const
            bool cppResult = const_cast<const ::QPaintEngineState *>(cppSelf)->brushNeedsResolving();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaintEngineStateFunc_brushOrigin(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngineState *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINESTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngineState.brushOrigin";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // brushOrigin()const
            QPointF cppResult = const_cast<const ::QPaintEngineState *>(cppSelf)->brushOrigin();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaintEngineStateFunc_clipOperation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngineState *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINESTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngineState.clipOperation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clipOperation()const
            Qt::ClipOperation cppResult = const_cast<const ::QPaintEngineState *>(cppSelf)->clipOperation();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_CLIPOPERATION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaintEngineStateFunc_clipPath(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngineState *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINESTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngineState.clipPath";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clipPath()const
            QPainterPath cppResult = const_cast<const ::QPaintEngineState *>(cppSelf)->clipPath();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTERPATH_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaintEngineStateFunc_clipRegion(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngineState *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINESTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngineState.clipRegion";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clipRegion()const
            QRegion cppResult = const_cast<const ::QPaintEngineState *>(cppSelf)->clipRegion();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QREGION_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaintEngineStateFunc_compositionMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngineState *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINESTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngineState.compositionMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // compositionMode()const
            QPainter::CompositionMode cppResult = const_cast<const ::QPaintEngineState *>(cppSelf)->compositionMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAINTER_COMPOSITIONMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaintEngineStateFunc_font(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngineState *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINESTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngineState.font";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // font()const
            QFont cppResult = const_cast<const ::QPaintEngineState *>(cppSelf)->font();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaintEngineStateFunc_isClipEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngineState *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINESTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngineState.isClipEnabled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isClipEnabled()const
            bool cppResult = const_cast<const ::QPaintEngineState *>(cppSelf)->isClipEnabled();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaintEngineStateFunc_matrix(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngineState *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINESTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngineState.matrix";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // matrix()const
            QMatrix cppResult = const_cast<const ::QPaintEngineState *>(cppSelf)->matrix();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaintEngineStateFunc_opacity(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngineState *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINESTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngineState.opacity";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // opacity()const
            qreal cppResult = const_cast<const ::QPaintEngineState *>(cppSelf)->opacity();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaintEngineStateFunc_painter(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngineState *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINESTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngineState.painter";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // painter()const
            QPainter * cppResult = const_cast<const ::QPaintEngineState *>(cppSelf)->painter();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaintEngineStateFunc_pen(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngineState *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINESTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngineState.pen";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pen()const
            QPen cppResult = const_cast<const ::QPaintEngineState *>(cppSelf)->pen();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPEN_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaintEngineStateFunc_penNeedsResolving(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngineState *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINESTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngineState.penNeedsResolving";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // penNeedsResolving()const
            bool cppResult = const_cast<const ::QPaintEngineState *>(cppSelf)->penNeedsResolving();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaintEngineStateFunc_renderHints(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngineState *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINESTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngineState.renderHints";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // renderHints()const
            QFlags<QPainter::RenderHint> cppResult = const_cast<const ::QPaintEngineState *>(cppSelf)->renderHints();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTER_RENDERHINT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaintEngineStateFunc_state(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngineState *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINESTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngineState.state";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // state()const
            QFlags<QPaintEngine::DirtyFlag> cppResult = const_cast<const ::QPaintEngineState *>(cppSelf)->state();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTENGINE_DIRTYFLAG_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPaintEngineStateFunc_transform(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPaintEngineState *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINESTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPaintEngineState.transform";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // transform()const
            QTransform cppResult = const_cast<const ::QPaintEngineState *>(cppSelf)->transform();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QPaintEngineState_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QPaintEngineState_methods[] = {
    {"backgroundBrush", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineStateFunc_backgroundBrush), METH_NOARGS},
    {"backgroundMode", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineStateFunc_backgroundMode), METH_NOARGS},
    {"brush", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineStateFunc_brush), METH_NOARGS},
    {"brushNeedsResolving", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineStateFunc_brushNeedsResolving), METH_NOARGS},
    {"brushOrigin", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineStateFunc_brushOrigin), METH_NOARGS},
    {"clipOperation", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineStateFunc_clipOperation), METH_NOARGS},
    {"clipPath", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineStateFunc_clipPath), METH_NOARGS},
    {"clipRegion", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineStateFunc_clipRegion), METH_NOARGS},
    {"compositionMode", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineStateFunc_compositionMode), METH_NOARGS},
    {"font", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineStateFunc_font), METH_NOARGS},
    {"isClipEnabled", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineStateFunc_isClipEnabled), METH_NOARGS},
    {"matrix", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineStateFunc_matrix), METH_NOARGS},
    {"opacity", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineStateFunc_opacity), METH_NOARGS},
    {"painter", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineStateFunc_painter), METH_NOARGS},
    {"pen", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineStateFunc_pen), METH_NOARGS},
    {"penNeedsResolving", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineStateFunc_penNeedsResolving), METH_NOARGS},
    {"renderHints", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineStateFunc_renderHints), METH_NOARGS},
    {"state", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineStateFunc_state), METH_NOARGS},
    {"transform", reinterpret_cast<PyCFunction>(Sbk_QPaintEngineStateFunc_transform), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QPaintEngineState_get_dirtyFlags(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QPaintEngineState *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINESTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTENGINE_DIRTYFLAG_IDX])->converter, &cppSelf->dirtyFlags);
    return pyOut;
}
static int Sbk_QPaintEngineState_set_dirtyFlags(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QPaintEngineState *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINESTATE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'dirtyFlags' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QFLAGS_QPAINTENGINE_DIRTYFLAG_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'dirtyFlags', 'DirtyFlags' or convertible type expected");
        return -1;
    }

    ::QFlags<QPaintEngine::DirtyFlag> cppOut_local = cppSelf->dirtyFlags;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->dirtyFlags = cppOut_local;

    return 0;
}

// Getters and Setters for QPaintEngineState
static PyGetSetDef Sbk_QPaintEngineState_getsetlist[] = {
    {const_cast<char *>("dirtyFlags"), Sbk_QPaintEngineState_get_dirtyFlags, Sbk_QPaintEngineState_set_dirtyFlags},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QPaintEngineState_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QPaintEngineState_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QPaintEngineState_Type = nullptr;
static SbkObjectType *Sbk_QPaintEngineState_TypeF(void)
{
    return _Sbk_QPaintEngineState_Type;
}

static PyType_Slot Sbk_QPaintEngineState_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QPaintEngineState_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QPaintEngineState_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QPaintEngineState_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QPaintEngineState_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QPaintEngineState_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QPaintEngineState_spec = {
    "2:PySide2.QtGui.QPaintEngineState",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QPaintEngineState_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QPaintEngineState_PythonToCpp_QPaintEngineState_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QPaintEngineState_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QPaintEngineState_PythonToCpp_QPaintEngineState_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QPaintEngineState_TypeF())))
        return QPaintEngineState_PythonToCpp_QPaintEngineState_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QPaintEngineState_PTR_CppToPython_QPaintEngineState(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QPaintEngineState *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QPaintEngineState_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QPaintEngineState_SignatureStrings[] = {
    "PySide2.QtGui.QPaintEngineState(self)",
    "PySide2.QtGui.QPaintEngineState.backgroundBrush(self)->PySide2.QtGui.QBrush",
    "PySide2.QtGui.QPaintEngineState.backgroundMode(self)->PySide2.QtCore.Qt.BGMode",
    "PySide2.QtGui.QPaintEngineState.brush(self)->PySide2.QtGui.QBrush",
    "PySide2.QtGui.QPaintEngineState.brushNeedsResolving(self)->bool",
    "PySide2.QtGui.QPaintEngineState.brushOrigin(self)->PySide2.QtCore.QPointF",
    "PySide2.QtGui.QPaintEngineState.clipOperation(self)->PySide2.QtCore.Qt.ClipOperation",
    "PySide2.QtGui.QPaintEngineState.clipPath(self)->PySide2.QtGui.QPainterPath",
    "PySide2.QtGui.QPaintEngineState.clipRegion(self)->PySide2.QtGui.QRegion",
    "PySide2.QtGui.QPaintEngineState.compositionMode(self)->PySide2.QtGui.QPainter.CompositionMode",
    "PySide2.QtGui.QPaintEngineState.font(self)->PySide2.QtGui.QFont",
    "PySide2.QtGui.QPaintEngineState.isClipEnabled(self)->bool",
    "PySide2.QtGui.QPaintEngineState.matrix(self)->PySide2.QtGui.QMatrix",
    "PySide2.QtGui.QPaintEngineState.opacity(self)->qreal",
    "PySide2.QtGui.QPaintEngineState.painter(self)->PySide2.QtGui.QPainter",
    "PySide2.QtGui.QPaintEngineState.pen(self)->PySide2.QtGui.QPen",
    "PySide2.QtGui.QPaintEngineState.penNeedsResolving(self)->bool",
    "PySide2.QtGui.QPaintEngineState.renderHints(self)->PySide2.QtGui.QPainter.RenderHints",
    "PySide2.QtGui.QPaintEngineState.state(self)->PySide2.QtGui.QPaintEngine.DirtyFlags",
    "PySide2.QtGui.QPaintEngineState.transform(self)->PySide2.QtGui.QTransform",
    nullptr}; // Sentinel

void init_QPaintEngineState(PyObject *module)
{
    _Sbk_QPaintEngineState_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QPaintEngineState",
        "QPaintEngineState*",
        &Sbk_QPaintEngineState_spec,
        &Shiboken::callCppDestructor< ::QPaintEngineState >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QPaintEngineState_Type);
    InitSignatureStrings(pyType, QPaintEngineState_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QPaintEngineState_Type), Sbk_QPaintEngineState_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QPAINTENGINESTATE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QPaintEngineState_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QPaintEngineState_TypeF(),
        QPaintEngineState_PythonToCpp_QPaintEngineState_PTR,
        is_QPaintEngineState_PythonToCpp_QPaintEngineState_PTR_Convertible,
        QPaintEngineState_PTR_CppToPython_QPaintEngineState);

    Shiboken::Conversions::registerConverterName(converter, "QPaintEngineState");
    Shiboken::Conversions::registerConverterName(converter, "QPaintEngineState*");
    Shiboken::Conversions::registerConverterName(converter, "QPaintEngineState&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QPaintEngineState).name());


}
