/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qpagelayout_wrapper.h"

// inner classes

// Extra includes
#include <QtGui/qpagelayout.h>
#include <QtGui/qpagesize.h>
#include <qmargins.h>
#include <qrect.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QPageLayout_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QPageLayout >()))
        return -1;

    ::QPageLayout *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageLayout.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 5) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPageLayout_Init_TypeError;
    } else if (numArgs == 2)
        goto Sbk_QPageLayout_Init_TypeError;

    if (!PyArg_ParseTuple(args, "|OOOOO:QPageLayout", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return -1;


    // Overloaded function decisor
    // 0: QPageLayout::QPageLayout()
    // 1: QPageLayout::QPageLayout(QPageLayout)
    // 2: QPageLayout::QPageLayout(QPageSize,QPageLayout::Orientation,QMarginsF,QPageLayout::Unit,QMarginsF)
    if (numArgs == 0) {
        overloadId = 0; // QPageLayout()
    } else if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_ORIENTATION_IDX])->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 2; // QPageLayout(QPageSize,QPageLayout::Orientation,QMarginsF,QPageLayout::Unit,QMarginsF)
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_UNIT_IDX])->converter, (pyArgs[3])))) {
            if (numArgs == 4) {
                overloadId = 2; // QPageLayout(QPageSize,QPageLayout::Orientation,QMarginsF,QPageLayout::Unit,QMarginsF)
            } else if (numArgs >= 5
                && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), (pyArgs[4])))) {
                overloadId = 2; // QPageLayout(QPageSize,QPageLayout::Orientation,QMarginsF,QPageLayout::Unit,QMarginsF)
            }
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QPageLayout(QPageLayout)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPageLayout_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QPageLayout()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QPageLayout_Init_TypeError;
            }

            if (!PyErr_Occurred()) {
                // QPageLayout()
                cptr = new ::QPageLayout();
            }
            break;
        }
        case 1: // QPageLayout(const QPageLayout & other)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QPageLayout_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QPageLayout cppArg0_local;
            ::QPageLayout *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QPageLayout(QPageLayout)
                cptr = new ::QPageLayout(*cppArg0);
            }
            break;
        }
        case 2: // QPageLayout(const QPageSize & pageSize, QPageLayout::Orientation orientation, const QMarginsF & margins, QPageLayout::Unit units, const QMarginsF & minMargins)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_units = Shiboken::String::createStaticString("units");
                if (PyDict_Contains(kwds, key_units)) {
                    value = PyDict_GetItem(kwds, key_units);
                    if (value && pyArgs[3]) {
                        errInfo = key_units;
                        Py_INCREF(errInfo);
                        goto Sbk_QPageLayout_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_UNIT_IDX])->converter, (pyArgs[3]))))
                            goto Sbk_QPageLayout_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_units);
                }
                static PyObject *const key_minMargins = Shiboken::String::createStaticString("minMargins");
                if (PyDict_Contains(kwds, key_minMargins)) {
                    value = PyDict_GetItem(kwds, key_minMargins);
                    if (value && pyArgs[4]) {
                        errInfo = key_minMargins;
                        Py_INCREF(errInfo);
                        goto Sbk_QPageLayout_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[4] = value;
                        if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), (pyArgs[4]))))
                            goto Sbk_QPageLayout_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_minMargins);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QPageLayout_Init_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QPageSize cppArg0_local;
            ::QPageSize *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QPageLayout::Orientation cppArg1{QPageLayout::Portrait};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QMarginsF cppArg2_local;
            ::QMarginsF *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);

            ::QPageLayout::Unit cppArg3 = QPageLayout::Unit::Point;
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
            if (!Shiboken::Object::isValid(pyArgs[4]))
                return -1;
            ::QMarginsF cppArg4_local = QMarginsF(0, 0, 0, 0);
            ::QMarginsF *cppArg4 = &cppArg4_local;
            if (pythonToCpp[4]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), pythonToCpp[4]))
                pythonToCpp[4](pyArgs[4], &cppArg4_local);
            else
                pythonToCpp[4](pyArgs[4], &cppArg4);
            }

            if (!PyErr_Occurred()) {
                // QPageLayout(QPageSize,QPageLayout::Orientation,QMarginsF,QPageLayout::Unit,QMarginsF)
                cptr = new ::QPageLayout(*cppArg0, cppArg1, *cppArg2, cppArg3, *cppArg4);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QPageLayout >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QPageLayout_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QPageLayout_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QPageLayoutFunc_fullRect(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPageLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageLayout.fullRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "fullRect", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QPageLayout::fullRect()const
    // 1: QPageLayout::fullRect(QPageLayout::Unit)const
    if (numArgs == 0) {
        overloadId = 0; // fullRect()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_UNIT_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // fullRect(QPageLayout::Unit)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPageLayoutFunc_fullRect_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // fullRect() const
        {

            if (!PyErr_Occurred()) {
                // fullRect()const
                QRectF cppResult = const_cast<const ::QPageLayout *>(cppSelf)->fullRect();
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
            }
            break;
        }
        case 1: // fullRect(QPageLayout::Unit units) const
        {
            ::QPageLayout::Unit cppArg0{QPageLayout::Millimeter};
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // fullRect(QPageLayout::Unit)const
                QRectF cppResult = const_cast<const ::QPageLayout *>(cppSelf)->fullRect(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPageLayoutFunc_fullRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPageLayoutFunc_fullRectPixels(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPageLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageLayout.fullRectPixels";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPageLayout::fullRectPixels(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // fullRectPixels(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPageLayoutFunc_fullRectPixels_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // fullRectPixels(int)const
            QRect cppResult = const_cast<const ::QPageLayout *>(cppSelf)->fullRectPixels(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPageLayoutFunc_fullRectPixels_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPageLayoutFunc_fullRectPoints(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPageLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageLayout.fullRectPoints";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fullRectPoints()const
            QRect cppResult = const_cast<const ::QPageLayout *>(cppSelf)->fullRectPoints();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPageLayoutFunc_isEquivalentTo(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPageLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageLayout.isEquivalentTo";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPageLayout::isEquivalentTo(QPageLayout)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX]), (pyArg)))) {
        overloadId = 0; // isEquivalentTo(QPageLayout)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPageLayoutFunc_isEquivalentTo_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPageLayout cppArg0_local;
        ::QPageLayout *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // isEquivalentTo(QPageLayout)const
            bool cppResult = const_cast<const ::QPageLayout *>(cppSelf)->isEquivalentTo(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPageLayoutFunc_isEquivalentTo_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPageLayoutFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPageLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageLayout.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QPageLayout *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPageLayoutFunc_margins(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPageLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageLayout.margins";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "margins", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QPageLayout::margins()const
    // 1: QPageLayout::margins(QPageLayout::Unit)const
    if (numArgs == 0) {
        overloadId = 0; // margins()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_UNIT_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // margins(QPageLayout::Unit)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPageLayoutFunc_margins_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // margins() const
        {

            if (!PyErr_Occurred()) {
                // margins()const
                QMarginsF cppResult = const_cast<const ::QPageLayout *>(cppSelf)->margins();
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), &cppResult);
            }
            break;
        }
        case 1: // margins(QPageLayout::Unit units) const
        {
            ::QPageLayout::Unit cppArg0{QPageLayout::Millimeter};
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // margins(QPageLayout::Unit)const
                QMarginsF cppResult = const_cast<const ::QPageLayout *>(cppSelf)->margins(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPageLayoutFunc_margins_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPageLayoutFunc_marginsPixels(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPageLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageLayout.marginsPixels";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPageLayout::marginsPixels(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // marginsPixels(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPageLayoutFunc_marginsPixels_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // marginsPixels(int)const
            QMargins cppResult = const_cast<const ::QPageLayout *>(cppSelf)->marginsPixels(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINS_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPageLayoutFunc_marginsPixels_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPageLayoutFunc_marginsPoints(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPageLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageLayout.marginsPoints";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // marginsPoints()const
            QMargins cppResult = const_cast<const ::QPageLayout *>(cppSelf)->marginsPoints();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINS_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPageLayoutFunc_maximumMargins(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPageLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageLayout.maximumMargins";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maximumMargins()const
            QMarginsF cppResult = const_cast<const ::QPageLayout *>(cppSelf)->maximumMargins();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPageLayoutFunc_minimumMargins(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPageLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageLayout.minimumMargins";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // minimumMargins()const
            QMarginsF cppResult = const_cast<const ::QPageLayout *>(cppSelf)->minimumMargins();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPageLayoutFunc_mode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPageLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageLayout.mode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mode()const
            QPageLayout::Mode cppResult = const_cast<const ::QPageLayout *>(cppSelf)->mode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_MODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPageLayoutFunc_orientation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPageLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageLayout.orientation";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // orientation()const
            QPageLayout::Orientation cppResult = const_cast<const ::QPageLayout *>(cppSelf)->orientation();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_ORIENTATION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPageLayoutFunc_pageSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPageLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageLayout.pageSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pageSize()const
            QPageSize cppResult = const_cast<const ::QPageLayout *>(cppSelf)->pageSize();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPageLayoutFunc_paintRect(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPageLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageLayout.paintRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "paintRect", 0, 1, &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QPageLayout::paintRect()const
    // 1: QPageLayout::paintRect(QPageLayout::Unit)const
    if (numArgs == 0) {
        overloadId = 0; // paintRect()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_UNIT_IDX])->converter, (pyArgs[0])))) {
        overloadId = 1; // paintRect(QPageLayout::Unit)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPageLayoutFunc_paintRect_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // paintRect() const
        {

            if (!PyErr_Occurred()) {
                // paintRect()const
                QRectF cppResult = const_cast<const ::QPageLayout *>(cppSelf)->paintRect();
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
            }
            break;
        }
        case 1: // paintRect(QPageLayout::Unit units) const
        {
            ::QPageLayout::Unit cppArg0{QPageLayout::Millimeter};
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // paintRect(QPageLayout::Unit)const
                QRectF cppResult = const_cast<const ::QPageLayout *>(cppSelf)->paintRect(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPageLayoutFunc_paintRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPageLayoutFunc_paintRectPixels(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPageLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageLayout.paintRectPixels";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPageLayout::paintRectPixels(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // paintRectPixels(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPageLayoutFunc_paintRectPixels_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // paintRectPixels(int)const
            QRect cppResult = const_cast<const ::QPageLayout *>(cppSelf)->paintRectPixels(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPageLayoutFunc_paintRectPixels_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPageLayoutFunc_paintRectPoints(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPageLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageLayout.paintRectPoints";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // paintRectPoints()const
            QRect cppResult = const_cast<const ::QPageLayout *>(cppSelf)->paintRectPoints();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPageLayoutFunc_setBottomMargin(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPageLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageLayout.setBottomMargin";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPageLayout::setBottomMargin(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setBottomMargin(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPageLayoutFunc_setBottomMargin_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setBottomMargin(qreal)
            bool cppResult = cppSelf->setBottomMargin(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPageLayoutFunc_setBottomMargin_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPageLayoutFunc_setLeftMargin(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPageLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageLayout.setLeftMargin";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPageLayout::setLeftMargin(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setLeftMargin(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPageLayoutFunc_setLeftMargin_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setLeftMargin(qreal)
            bool cppResult = cppSelf->setLeftMargin(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPageLayoutFunc_setLeftMargin_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPageLayoutFunc_setMargins(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPageLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageLayout.setMargins";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPageLayout::setMargins(QMarginsF)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), (pyArg)))) {
        overloadId = 0; // setMargins(QMarginsF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPageLayoutFunc_setMargins_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMarginsF cppArg0_local;
        ::QMarginsF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setMargins(QMarginsF)
            bool cppResult = cppSelf->setMargins(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPageLayoutFunc_setMargins_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPageLayoutFunc_setMinimumMargins(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPageLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageLayout.setMinimumMargins";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPageLayout::setMinimumMargins(QMarginsF)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), (pyArg)))) {
        overloadId = 0; // setMinimumMargins(QMarginsF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPageLayoutFunc_setMinimumMargins_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QMarginsF cppArg0_local;
        ::QMarginsF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setMinimumMargins(QMarginsF)
            cppSelf->setMinimumMargins(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPageLayoutFunc_setMinimumMargins_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPageLayoutFunc_setMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPageLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageLayout.setMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPageLayout::setMode(QPageLayout::Mode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_MODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setMode(QPageLayout::Mode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPageLayoutFunc_setMode_TypeError;

    // Call function/method
    {
        ::QPageLayout::Mode cppArg0{QPageLayout::StandardMode};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMode(QPageLayout::Mode)
            cppSelf->setMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPageLayoutFunc_setMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPageLayoutFunc_setOrientation(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPageLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageLayout.setOrientation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPageLayout::setOrientation(QPageLayout::Orientation)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_ORIENTATION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setOrientation(QPageLayout::Orientation)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPageLayoutFunc_setOrientation_TypeError;

    // Call function/method
    {
        ::QPageLayout::Orientation cppArg0{QPageLayout::Portrait};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setOrientation(QPageLayout::Orientation)
            cppSelf->setOrientation(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPageLayoutFunc_setOrientation_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPageLayoutFunc_setPageSize(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPageLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageLayout.setPageSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QPageLayoutFunc_setPageSize_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QPageLayoutFunc_setPageSize_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setPageSize", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QPageLayout::setPageSize(QPageSize,QMarginsF)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setPageSize(QPageSize,QMarginsF)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), (pyArgs[1])))) {
            overloadId = 0; // setPageSize(QPageSize,QMarginsF)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPageLayoutFunc_setPageSize_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_minMargins = Shiboken::String::createStaticString("minMargins");
            if (PyDict_Contains(kwds, key_minMargins)) {
                value = PyDict_GetItem(kwds, key_minMargins);
                if (value && pyArgs[1]) {
                    errInfo = key_minMargins;
                    Py_INCREF(errInfo);
                    goto Sbk_QPageLayoutFunc_setPageSize_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), (pyArgs[1]))))
                        goto Sbk_QPageLayoutFunc_setPageSize_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_minMargins);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QPageLayoutFunc_setPageSize_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QPageSize cppArg0_local;
        ::QPageSize *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QMarginsF cppArg1_local = QMarginsF(0, 0, 0, 0);
        ::QMarginsF *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);
        }

        if (!PyErr_Occurred()) {
            // setPageSize(QPageSize,QMarginsF)
            cppSelf->setPageSize(*cppArg0, *cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPageLayoutFunc_setPageSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPageLayoutFunc_setRightMargin(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPageLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageLayout.setRightMargin";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPageLayout::setRightMargin(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setRightMargin(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPageLayoutFunc_setRightMargin_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRightMargin(qreal)
            bool cppResult = cppSelf->setRightMargin(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPageLayoutFunc_setRightMargin_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPageLayoutFunc_setTopMargin(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPageLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageLayout.setTopMargin";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPageLayout::setTopMargin(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setTopMargin(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPageLayoutFunc_setTopMargin_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTopMargin(qreal)
            bool cppResult = cppSelf->setTopMargin(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPageLayoutFunc_setTopMargin_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPageLayoutFunc_setUnits(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPageLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageLayout.setUnits";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPageLayout::setUnits(QPageLayout::Unit)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_UNIT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setUnits(QPageLayout::Unit)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPageLayoutFunc_setUnits_TypeError;

    // Call function/method
    {
        ::QPageLayout::Unit cppArg0{QPageLayout::Millimeter};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setUnits(QPageLayout::Unit)
            cppSelf->setUnits(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPageLayoutFunc_setUnits_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPageLayoutFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPageLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageLayout.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPageLayout::swap(QPageLayout&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QPageLayout&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPageLayoutFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPageLayout cppArg0_local;
        ::QPageLayout *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QPageLayout&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPageLayoutFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPageLayoutFunc_units(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPageLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPageLayout.units";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // units()const
            QPageLayout::Unit cppResult = const_cast<const ::QPageLayout *>(cppSelf)->units();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_UNIT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPageLayout___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QPageLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QPageLayout_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QPageLayout_methods[] = {
    {"fullRect", reinterpret_cast<PyCFunction>(Sbk_QPageLayoutFunc_fullRect), METH_VARARGS},
    {"fullRectPixels", reinterpret_cast<PyCFunction>(Sbk_QPageLayoutFunc_fullRectPixels), METH_O},
    {"fullRectPoints", reinterpret_cast<PyCFunction>(Sbk_QPageLayoutFunc_fullRectPoints), METH_NOARGS},
    {"isEquivalentTo", reinterpret_cast<PyCFunction>(Sbk_QPageLayoutFunc_isEquivalentTo), METH_O},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QPageLayoutFunc_isValid), METH_NOARGS},
    {"margins", reinterpret_cast<PyCFunction>(Sbk_QPageLayoutFunc_margins), METH_VARARGS},
    {"marginsPixels", reinterpret_cast<PyCFunction>(Sbk_QPageLayoutFunc_marginsPixels), METH_O},
    {"marginsPoints", reinterpret_cast<PyCFunction>(Sbk_QPageLayoutFunc_marginsPoints), METH_NOARGS},
    {"maximumMargins", reinterpret_cast<PyCFunction>(Sbk_QPageLayoutFunc_maximumMargins), METH_NOARGS},
    {"minimumMargins", reinterpret_cast<PyCFunction>(Sbk_QPageLayoutFunc_minimumMargins), METH_NOARGS},
    {"mode", reinterpret_cast<PyCFunction>(Sbk_QPageLayoutFunc_mode), METH_NOARGS},
    {"orientation", reinterpret_cast<PyCFunction>(Sbk_QPageLayoutFunc_orientation), METH_NOARGS},
    {"pageSize", reinterpret_cast<PyCFunction>(Sbk_QPageLayoutFunc_pageSize), METH_NOARGS},
    {"paintRect", reinterpret_cast<PyCFunction>(Sbk_QPageLayoutFunc_paintRect), METH_VARARGS},
    {"paintRectPixels", reinterpret_cast<PyCFunction>(Sbk_QPageLayoutFunc_paintRectPixels), METH_O},
    {"paintRectPoints", reinterpret_cast<PyCFunction>(Sbk_QPageLayoutFunc_paintRectPoints), METH_NOARGS},
    {"setBottomMargin", reinterpret_cast<PyCFunction>(Sbk_QPageLayoutFunc_setBottomMargin), METH_O},
    {"setLeftMargin", reinterpret_cast<PyCFunction>(Sbk_QPageLayoutFunc_setLeftMargin), METH_O},
    {"setMargins", reinterpret_cast<PyCFunction>(Sbk_QPageLayoutFunc_setMargins), METH_O},
    {"setMinimumMargins", reinterpret_cast<PyCFunction>(Sbk_QPageLayoutFunc_setMinimumMargins), METH_O},
    {"setMode", reinterpret_cast<PyCFunction>(Sbk_QPageLayoutFunc_setMode), METH_O},
    {"setOrientation", reinterpret_cast<PyCFunction>(Sbk_QPageLayoutFunc_setOrientation), METH_O},
    {"setPageSize", reinterpret_cast<PyCFunction>(Sbk_QPageLayoutFunc_setPageSize), METH_VARARGS|METH_KEYWORDS},
    {"setRightMargin", reinterpret_cast<PyCFunction>(Sbk_QPageLayoutFunc_setRightMargin), METH_O},
    {"setTopMargin", reinterpret_cast<PyCFunction>(Sbk_QPageLayoutFunc_setTopMargin), METH_O},
    {"setUnits", reinterpret_cast<PyCFunction>(Sbk_QPageLayoutFunc_setUnits), METH_O},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QPageLayoutFunc_swap), METH_O},
    {"units", reinterpret_cast<PyCFunction>(Sbk_QPageLayoutFunc_units), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QPageLayout___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QPageLayout_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QPageLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX]), (pyArg)))) {
                // operator!=(const QPageLayout & rhs)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QPageLayout cppArg0_local;
                ::QPageLayout *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX]), (pyArg)))) {
                // operator==(const QPageLayout & rhs)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QPageLayout cppArg0_local;
                ::QPageLayout *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QPageLayout_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QPageLayout_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QPageLayout_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QPageLayout_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QPageLayout__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPageLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QPageLayout_Type = nullptr;
static SbkObjectType *Sbk_QPageLayout_TypeF(void)
{
    return _Sbk_QPageLayout_Type;
}

static PyType_Slot Sbk_QPageLayout_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QPageLayout__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QPageLayout_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QPageLayout_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QPageLayout_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QPageLayout_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QPageLayout_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QPageLayout_spec = {
    "2:PySide2.QtGui.QPageLayout",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QPageLayout_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QPageLayout_Unit_PythonToCpp_QPageLayout_Unit(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPageLayout::Unit *>(cppOut) =
        static_cast<::QPageLayout::Unit>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QPageLayout_Unit_PythonToCpp_QPageLayout_Unit_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_UNIT_IDX]))
        return QPageLayout_Unit_PythonToCpp_QPageLayout_Unit;
    return {};
}
static PyObject *QPageLayout_Unit_CppToPython_QPageLayout_Unit(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QPageLayout::Unit *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_UNIT_IDX], castCppIn);

}

static void QPageLayout_Orientation_PythonToCpp_QPageLayout_Orientation(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPageLayout::Orientation *>(cppOut) =
        static_cast<::QPageLayout::Orientation>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QPageLayout_Orientation_PythonToCpp_QPageLayout_Orientation_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_ORIENTATION_IDX]))
        return QPageLayout_Orientation_PythonToCpp_QPageLayout_Orientation;
    return {};
}
static PyObject *QPageLayout_Orientation_CppToPython_QPageLayout_Orientation(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QPageLayout::Orientation *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_ORIENTATION_IDX], castCppIn);

}

static void QPageLayout_Mode_PythonToCpp_QPageLayout_Mode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPageLayout::Mode *>(cppOut) =
        static_cast<::QPageLayout::Mode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QPageLayout_Mode_PythonToCpp_QPageLayout_Mode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_MODE_IDX]))
        return QPageLayout_Mode_PythonToCpp_QPageLayout_Mode;
    return {};
}
static PyObject *QPageLayout_Mode_CppToPython_QPageLayout_Mode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QPageLayout::Mode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_MODE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QPageLayout_PythonToCpp_QPageLayout_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QPageLayout_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QPageLayout_PythonToCpp_QPageLayout_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QPageLayout_TypeF())))
        return QPageLayout_PythonToCpp_QPageLayout_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QPageLayout_PTR_CppToPython_QPageLayout(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QPageLayout *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QPageLayout_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QPageLayout_COPY_CppToPython_QPageLayout(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QPageLayout_TypeF(), new ::QPageLayout(*reinterpret_cast<const ::QPageLayout *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QPageLayout_PythonToCpp_QPageLayout_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPageLayout *>(cppOut) = *reinterpret_cast< ::QPageLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QPageLayout_PythonToCpp_QPageLayout_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QPageLayout_TypeF())))
        return QPageLayout_PythonToCpp_QPageLayout_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QPageLayout_SignatureStrings[] = {
    "2:PySide2.QtGui.QPageLayout(self)",
    "1:PySide2.QtGui.QPageLayout(self,other:PySide2.QtGui.QPageLayout)",
    "0:PySide2.QtGui.QPageLayout(self,pageSize:PySide2.QtGui.QPageSize,orientation:PySide2.QtGui.QPageLayout.Orientation,margins:PySide2.QtCore.QMarginsF,units:PySide2.QtGui.QPageLayout.Unit=Point,minMargins:PySide2.QtCore.QMarginsF=QMarginsF(0, 0, 0, 0))",
    "1:PySide2.QtGui.QPageLayout.fullRect(self)->PySide2.QtCore.QRectF",
    "0:PySide2.QtGui.QPageLayout.fullRect(self,units:PySide2.QtGui.QPageLayout.Unit)->PySide2.QtCore.QRectF",
    "PySide2.QtGui.QPageLayout.fullRectPixels(self,resolution:int)->PySide2.QtCore.QRect",
    "PySide2.QtGui.QPageLayout.fullRectPoints(self)->PySide2.QtCore.QRect",
    "PySide2.QtGui.QPageLayout.isEquivalentTo(self,other:PySide2.QtGui.QPageLayout)->bool",
    "PySide2.QtGui.QPageLayout.isValid(self)->bool",
    "1:PySide2.QtGui.QPageLayout.margins(self)->PySide2.QtCore.QMarginsF",
    "0:PySide2.QtGui.QPageLayout.margins(self,units:PySide2.QtGui.QPageLayout.Unit)->PySide2.QtCore.QMarginsF",
    "PySide2.QtGui.QPageLayout.marginsPixels(self,resolution:int)->PySide2.QtCore.QMargins",
    "PySide2.QtGui.QPageLayout.marginsPoints(self)->PySide2.QtCore.QMargins",
    "PySide2.QtGui.QPageLayout.maximumMargins(self)->PySide2.QtCore.QMarginsF",
    "PySide2.QtGui.QPageLayout.minimumMargins(self)->PySide2.QtCore.QMarginsF",
    "PySide2.QtGui.QPageLayout.mode(self)->PySide2.QtGui.QPageLayout.Mode",
    "PySide2.QtGui.QPageLayout.orientation(self)->PySide2.QtGui.QPageLayout.Orientation",
    "PySide2.QtGui.QPageLayout.pageSize(self)->PySide2.QtGui.QPageSize",
    "1:PySide2.QtGui.QPageLayout.paintRect(self)->PySide2.QtCore.QRectF",
    "0:PySide2.QtGui.QPageLayout.paintRect(self,units:PySide2.QtGui.QPageLayout.Unit)->PySide2.QtCore.QRectF",
    "PySide2.QtGui.QPageLayout.paintRectPixels(self,resolution:int)->PySide2.QtCore.QRect",
    "PySide2.QtGui.QPageLayout.paintRectPoints(self)->PySide2.QtCore.QRect",
    "PySide2.QtGui.QPageLayout.setBottomMargin(self,bottomMargin:qreal)->bool",
    "PySide2.QtGui.QPageLayout.setLeftMargin(self,leftMargin:qreal)->bool",
    "PySide2.QtGui.QPageLayout.setMargins(self,margins:PySide2.QtCore.QMarginsF)->bool",
    "PySide2.QtGui.QPageLayout.setMinimumMargins(self,minMargins:PySide2.QtCore.QMarginsF)",
    "PySide2.QtGui.QPageLayout.setMode(self,mode:PySide2.QtGui.QPageLayout.Mode)",
    "PySide2.QtGui.QPageLayout.setOrientation(self,orientation:PySide2.QtGui.QPageLayout.Orientation)",
    "PySide2.QtGui.QPageLayout.setPageSize(self,pageSize:PySide2.QtGui.QPageSize,minMargins:PySide2.QtCore.QMarginsF=QMarginsF(0, 0, 0, 0))",
    "PySide2.QtGui.QPageLayout.setRightMargin(self,rightMargin:qreal)->bool",
    "PySide2.QtGui.QPageLayout.setTopMargin(self,topMargin:qreal)->bool",
    "PySide2.QtGui.QPageLayout.setUnits(self,units:PySide2.QtGui.QPageLayout.Unit)",
    "PySide2.QtGui.QPageLayout.swap(self,other:PySide2.QtGui.QPageLayout)",
    "PySide2.QtGui.QPageLayout.units(self)->PySide2.QtGui.QPageLayout.Unit",
    "PySide2.QtGui.QPageLayout.__copy__()",
    nullptr}; // Sentinel

void init_QPageLayout(PyObject *module)
{
    _Sbk_QPageLayout_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QPageLayout",
        "QPageLayout",
        &Sbk_QPageLayout_spec,
        &Shiboken::callCppDestructor< ::QPageLayout >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QPageLayout_Type);
    InitSignatureStrings(pyType, QPageLayout_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QPageLayout_Type), Sbk_QPageLayout_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QPageLayout_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QPageLayout_TypeF(),
        QPageLayout_PythonToCpp_QPageLayout_PTR,
        is_QPageLayout_PythonToCpp_QPageLayout_PTR_Convertible,
        QPageLayout_PTR_CppToPython_QPageLayout,
        QPageLayout_COPY_CppToPython_QPageLayout);

    Shiboken::Conversions::registerConverterName(converter, "QPageLayout");
    Shiboken::Conversions::registerConverterName(converter, "QPageLayout*");
    Shiboken::Conversions::registerConverterName(converter, "QPageLayout&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QPageLayout).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QPageLayout_PythonToCpp_QPageLayout_COPY,
        is_QPageLayout_PythonToCpp_QPageLayout_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'Unit'.
    SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_UNIT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QPageLayout_TypeF(),
        "Unit",
        "2:PySide2.QtGui.QPageLayout.Unit",
        "QPageLayout::Unit");
    if (!SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_UNIT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_UNIT_IDX],
        Sbk_QPageLayout_TypeF(), "Millimeter", (long) QPageLayout::Unit::Millimeter))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_UNIT_IDX],
        Sbk_QPageLayout_TypeF(), "Point", (long) QPageLayout::Unit::Point))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_UNIT_IDX],
        Sbk_QPageLayout_TypeF(), "Inch", (long) QPageLayout::Unit::Inch))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_UNIT_IDX],
        Sbk_QPageLayout_TypeF(), "Pica", (long) QPageLayout::Unit::Pica))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_UNIT_IDX],
        Sbk_QPageLayout_TypeF(), "Didot", (long) QPageLayout::Unit::Didot))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_UNIT_IDX],
        Sbk_QPageLayout_TypeF(), "Cicero", (long) QPageLayout::Unit::Cicero))
        return;
    // Register converter for enum 'QPageLayout::Unit'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_UNIT_IDX],
            QPageLayout_Unit_CppToPython_QPageLayout_Unit);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QPageLayout_Unit_PythonToCpp_QPageLayout_Unit,
            is_QPageLayout_Unit_PythonToCpp_QPageLayout_Unit_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_UNIT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QPageLayout::Unit");
        Shiboken::Conversions::registerConverterName(converter, "Unit");
    }
    // End of 'Unit' enum.

    // Initialization of enum 'Orientation'.
    SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_ORIENTATION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QPageLayout_TypeF(),
        "Orientation",
        "2:PySide2.QtGui.QPageLayout.Orientation",
        "QPageLayout::Orientation");
    if (!SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_ORIENTATION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_ORIENTATION_IDX],
        Sbk_QPageLayout_TypeF(), "Portrait", (long) QPageLayout::Orientation::Portrait))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_ORIENTATION_IDX],
        Sbk_QPageLayout_TypeF(), "Landscape", (long) QPageLayout::Orientation::Landscape))
        return;
    // Register converter for enum 'QPageLayout::Orientation'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_ORIENTATION_IDX],
            QPageLayout_Orientation_CppToPython_QPageLayout_Orientation);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QPageLayout_Orientation_PythonToCpp_QPageLayout_Orientation,
            is_QPageLayout_Orientation_PythonToCpp_QPageLayout_Orientation_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_ORIENTATION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QPageLayout::Orientation");
        Shiboken::Conversions::registerConverterName(converter, "Orientation");
    }
    // End of 'Orientation' enum.

    // Initialization of enum 'Mode'.
    SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_MODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QPageLayout_TypeF(),
        "Mode",
        "2:PySide2.QtGui.QPageLayout.Mode",
        "QPageLayout::Mode");
    if (!SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_MODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_MODE_IDX],
        Sbk_QPageLayout_TypeF(), "StandardMode", (long) QPageLayout::Mode::StandardMode))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_MODE_IDX],
        Sbk_QPageLayout_TypeF(), "FullPageMode", (long) QPageLayout::Mode::FullPageMode))
        return;
    // Register converter for enum 'QPageLayout::Mode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_MODE_IDX],
            QPageLayout_Mode_CppToPython_QPageLayout_Mode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QPageLayout_Mode_PythonToCpp_QPageLayout_Mode,
            is_QPageLayout_Mode_PythonToCpp_QPageLayout_Mode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_MODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QPageLayout::Mode");
        Shiboken::Conversions::registerConverterName(converter, "Mode");
    }
    // End of 'Mode' enum.

    qRegisterMetaType< ::QPageLayout >("QPageLayout");
    qRegisterMetaType< ::QPageLayout::Unit >("QPageLayout::Unit");
    qRegisterMetaType< ::QPageLayout::Orientation >("QPageLayout::Orientation");
    qRegisterMetaType< ::QPageLayout::Mode >("QPageLayout::Mode");
}
