/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qpagedpaintdevice_wrapper.h"

// inner classes
#include "qpagedpaintdevice_margins_wrapper.h"

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QPagedPaintDeviceWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QPagedPaintDeviceWrapper::QPagedPaintDeviceWrapper() : QPagedPaintDevice()
{
    resetPyMethodCache();
    // ... middle
}

int QPagedPaintDeviceWrapper::devType() const
{
    if (m_PyMethodCache[0])
        return this->::QPaintDevice::devType();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "devType";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QPaintDevice::devType();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPagedPaintDevice.devType", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QPagedPaintDeviceWrapper::initPainter(::QPainter * painter) const
{
    if (m_PyMethodCache[1]) {
        return this->::QPaintDevice::initPainter(painter);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "initPainter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QPaintDevice::initPainter(painter);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), painter)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

int QPagedPaintDeviceWrapper::metric(::QPaintDevice::PaintDeviceMetric metric) const
{
    if (m_PyMethodCache[2])
        return this->::QPaintDevice::metric(metric);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "metric";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QPaintDevice::metric(metric);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_PAINTDEVICEMETRIC_IDX])->converter, &metric)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPagedPaintDevice.metric", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QPagedPaintDeviceWrapper::newPage()
{
    if (m_PyMethodCache[3]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPagedPaintDevice.newPage()' not implemented.");
        return false;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "newPage";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPagedPaintDevice.newPage()' not implemented.");
        return false;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPagedPaintDevice.newPage", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QPaintEngine * QPagedPaintDeviceWrapper::paintEngine() const
{
    if (m_PyMethodCache[4]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPagedPaintDevice.paintEngine()' not implemented.");
        return nullptr;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "paintEngine";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPagedPaintDevice.paintEngine()' not implemented.");
        return nullptr;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPagedPaintDevice.paintEngine", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QPaintEngine >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QPaintEngine *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QPaintDevice * QPagedPaintDeviceWrapper::redirected(::QPoint * offset) const
{
    if (m_PyMethodCache[5])
        return this->::QPaintDevice::redirected(offset);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "redirected";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QPaintDevice::redirected(offset);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), offset)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPagedPaintDevice.redirected", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QPaintDevice >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QPaintDevice *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QPagedPaintDeviceWrapper::setMargins(const ::QPagedPaintDevice::Margins & margins)
{
    if (m_PyMethodCache[6]) {
        return this->::QPagedPaintDevice::setMargins(margins);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setMargins";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QPagedPaintDevice::setMargins(margins);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_MARGINS_IDX]), &margins)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QPagedPaintDeviceWrapper::setPageSize(::QPagedPaintDevice::PageSize size)
{
    if (m_PyMethodCache[7]) {
        return this->::QPagedPaintDevice::setPageSize(size);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setPageSize";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QPagedPaintDevice::setPageSize(size);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX])->converter, &size)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QPagedPaintDeviceWrapper::setPageSizeMM(const ::QSizeF & size)
{
    if (m_PyMethodCache[8]) {
        return this->::QPagedPaintDevice::setPageSizeMM(size);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setPageSizeMM";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QPagedPaintDevice::setPageSizeMM(size);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), &size)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QPainter * QPagedPaintDeviceWrapper::sharedPainter() const
{
    if (m_PyMethodCache[9])
        return this->::QPaintDevice::sharedPainter();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "sharedPainter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QPaintDevice::sharedPainter();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QPagedPaintDevice.sharedPainter", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QPainter >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QPainter *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

QPagedPaintDeviceWrapper::~QPagedPaintDeviceWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QPagedPaintDevice_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QPagedPaintDevice' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QPagedPaintDevice >()))
        return -1;

    ::QPagedPaintDeviceWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPagedPaintDevice.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QPagedPaintDevice()
            cptr = new ::QPagedPaintDeviceWrapper();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QPagedPaintDevice >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QPagedPaintDeviceFunc_devicePageLayout(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPagedPaintDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPagedPaintDevice.devicePageLayout";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // devicePageLayout()
            QPageLayout & cppResult = cppSelf->devicePageLayout();
            pyResult = Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPagedPaintDeviceFunc_margins(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPagedPaintDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPagedPaintDevice.margins";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // margins()const
            QPagedPaintDevice::Margins cppResult = const_cast<const ::QPagedPaintDevice *>(cppSelf)->margins();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_MARGINS_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPagedPaintDeviceFunc_newPage(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPagedPaintDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPagedPaintDevice.newPage";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // newPage()
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QPagedPaintDevice.newPage()' not implemented.");
                return {};
            }
            bool cppResult = cppSelf->newPage();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPagedPaintDeviceFunc_pageLayout(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPagedPaintDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPagedPaintDevice.pageLayout";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pageLayout()const
            QPageLayout cppResult = const_cast<const ::QPagedPaintDevice *>(cppSelf)->pageLayout();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPagedPaintDeviceFunc_pageSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPagedPaintDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPagedPaintDevice.pageSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pageSize()const
            QPagedPaintDevice::PageSize cppResult = const_cast<const ::QPagedPaintDevice *>(cppSelf)->pageSize();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPagedPaintDeviceFunc_pageSizeMM(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPagedPaintDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPagedPaintDevice.pageSizeMM";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pageSizeMM()const
            QSizeF cppResult = const_cast<const ::QPagedPaintDevice *>(cppSelf)->pageSizeMM();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QPagedPaintDeviceFunc_setMargins(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPagedPaintDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPagedPaintDevice.setMargins";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPagedPaintDevice::setMargins(QPagedPaintDevice::Margins)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_MARGINS_IDX]), (pyArg)))) {
        overloadId = 0; // setMargins(QPagedPaintDevice::Margins)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPagedPaintDeviceFunc_setMargins_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPagedPaintDevice::Margins cppArg0_local;
        ::QPagedPaintDevice::Margins *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_MARGINS_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setMargins(QPagedPaintDevice::Margins)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QPagedPaintDevice::setMargins(*cppArg0)
                : cppSelf->setMargins(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPagedPaintDeviceFunc_setMargins_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPagedPaintDeviceFunc_setPageLayout(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPagedPaintDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPagedPaintDevice.setPageLayout";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPagedPaintDevice::setPageLayout(QPageLayout)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX]), (pyArg)))) {
        overloadId = 0; // setPageLayout(QPageLayout)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPagedPaintDeviceFunc_setPageLayout_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QPageLayout cppArg0_local;
        ::QPageLayout *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setPageLayout(QPageLayout)
            bool cppResult = cppSelf->setPageLayout(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPagedPaintDeviceFunc_setPageLayout_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPagedPaintDeviceFunc_setPageMargins(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPagedPaintDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPagedPaintDevice.setPageMargins";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setPageMargins", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QPagedPaintDevice::setPageMargins(QMarginsF)
    // 1: QPagedPaintDevice::setPageMargins(QMarginsF,QPageLayout::Unit)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setPageMargins(QMarginsF)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_UNIT_IDX])->converter, (pyArgs[1])))) {
            overloadId = 1; // setPageMargins(QMarginsF,QPageLayout::Unit)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPagedPaintDeviceFunc_setPageMargins_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setPageMargins(const QMarginsF & margins)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QMarginsF cppArg0_local;
            ::QMarginsF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // setPageMargins(QMarginsF)
                bool cppResult = cppSelf->setPageMargins(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // setPageMargins(const QMarginsF & margins, QPageLayout::Unit units)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QMarginsF cppArg0_local;
            ::QMarginsF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINSF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QPageLayout::Unit cppArg1{QPageLayout::Millimeter};
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setPageMargins(QMarginsF,QPageLayout::Unit)
                bool cppResult = cppSelf->setPageMargins(*cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPagedPaintDeviceFunc_setPageMargins_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPagedPaintDeviceFunc_setPageOrientation(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPagedPaintDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPagedPaintDevice.setPageOrientation";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPagedPaintDevice::setPageOrientation(QPageLayout::Orientation)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGELAYOUT_ORIENTATION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setPageOrientation(QPageLayout::Orientation)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPagedPaintDeviceFunc_setPageOrientation_TypeError;

    // Call function/method
    {
        ::QPageLayout::Orientation cppArg0{QPageLayout::Portrait};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPageOrientation(QPageLayout::Orientation)
            bool cppResult = cppSelf->setPageOrientation(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPagedPaintDeviceFunc_setPageOrientation_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPagedPaintDeviceFunc_setPageSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPagedPaintDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPagedPaintDevice.setPageSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPagedPaintDevice::setPageSize(QPagedPaintDevice::PageSize)
    // 1: QPagedPaintDevice::setPageSize(QPageSize)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX]), (pyArg)))) {
        overloadId = 1; // setPageSize(QPageSize)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setPageSize(QPagedPaintDevice::PageSize)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPagedPaintDeviceFunc_setPageSize_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setPageSize(QPagedPaintDevice::PageSize size)
        {
            ::QPagedPaintDevice::PageSize cppArg0{QPagedPaintDevice::A4};
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // setPageSize(QPagedPaintDevice::PageSize)
                Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                    ? cppSelf->::QPagedPaintDevice::setPageSize(cppArg0)
                    : cppSelf->setPageSize(cppArg0);
                pyResult = Py_None;
                Py_INCREF(Py_None);
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QPagedPaintDevice.setPageSize(QPagedPaintDevice::PageSize size) is deprecated", 1);
            break;
        }
        case 1: // setPageSize(const QPageSize & pageSize)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QPageSize cppArg0_local;
            ::QPageSize *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAGESIZE_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // setPageSize(QPageSize)
                bool cppResult = cppSelf->setPageSize(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QPagedPaintDeviceFunc_setPageSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QPagedPaintDeviceFunc_setPageSizeMM(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QPagedPaintDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QPagedPaintDevice.setPageSizeMM";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QPagedPaintDevice::setPageSizeMM(QSizeF)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), (pyArg)))) {
        overloadId = 0; // setPageSizeMM(QSizeF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QPagedPaintDeviceFunc_setPageSizeMM_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QSizeF cppArg0_local;
        ::QSizeF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setPageSizeMM(QSizeF)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QPagedPaintDevice::setPageSizeMM(*cppArg0)
                : cppSelf->setPageSizeMM(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QPagedPaintDeviceFunc_setPageSizeMM_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QPagedPaintDevice_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QPagedPaintDevice_methods[] = {
    {"devicePageLayout", reinterpret_cast<PyCFunction>(Sbk_QPagedPaintDeviceFunc_devicePageLayout), METH_NOARGS},
    {"margins", reinterpret_cast<PyCFunction>(Sbk_QPagedPaintDeviceFunc_margins), METH_NOARGS},
    {"newPage", reinterpret_cast<PyCFunction>(Sbk_QPagedPaintDeviceFunc_newPage), METH_NOARGS},
    {"pageLayout", reinterpret_cast<PyCFunction>(Sbk_QPagedPaintDeviceFunc_pageLayout), METH_NOARGS},
    {"pageSize", reinterpret_cast<PyCFunction>(Sbk_QPagedPaintDeviceFunc_pageSize), METH_NOARGS},
    {"pageSizeMM", reinterpret_cast<PyCFunction>(Sbk_QPagedPaintDeviceFunc_pageSizeMM), METH_NOARGS},
    {"setMargins", reinterpret_cast<PyCFunction>(Sbk_QPagedPaintDeviceFunc_setMargins), METH_O},
    {"setPageLayout", reinterpret_cast<PyCFunction>(Sbk_QPagedPaintDeviceFunc_setPageLayout), METH_O},
    {"setPageMargins", reinterpret_cast<PyCFunction>(Sbk_QPagedPaintDeviceFunc_setPageMargins), METH_VARARGS},
    {"setPageOrientation", reinterpret_cast<PyCFunction>(Sbk_QPagedPaintDeviceFunc_setPageOrientation), METH_O},
    {"setPageSize", reinterpret_cast<PyCFunction>(Sbk_QPagedPaintDeviceFunc_setPageSize), METH_O},
    {"setPageSizeMM", reinterpret_cast<PyCFunction>(Sbk_QPagedPaintDeviceFunc_setPageSizeMM), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QPagedPaintDevice_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QPagedPaintDevice *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QPagedPaintDeviceWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QPagedPaintDevice_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QPagedPaintDevice_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QPagedPaintDevice_Type = nullptr;
static SbkObjectType *Sbk_QPagedPaintDevice_TypeF(void)
{
    return _Sbk_QPagedPaintDevice_Type;
}

static PyType_Slot Sbk_QPagedPaintDevice_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QPagedPaintDevice_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QPagedPaintDevice_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QPagedPaintDevice_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QPagedPaintDevice_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QPagedPaintDevice_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QPagedPaintDevice_spec = {
    "2:PySide2.QtGui.QPagedPaintDevice",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QPagedPaintDevice_slots
};

} //extern "C"

static void *Sbk_QPagedPaintDevice_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QPaintDevice >()))
        return dynamic_cast< ::QPagedPaintDevice *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QPagedPaintDevice_PageSize_PythonToCpp_QPagedPaintDevice_PageSize(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPagedPaintDevice::PageSize *>(cppOut) =
        static_cast<::QPagedPaintDevice::PageSize>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QPagedPaintDevice_PageSize_PythonToCpp_QPagedPaintDevice_PageSize_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX]))
        return QPagedPaintDevice_PageSize_PythonToCpp_QPagedPaintDevice_PageSize;
    return {};
}
static PyObject *QPagedPaintDevice_PageSize_CppToPython_QPagedPaintDevice_PageSize(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QPagedPaintDevice::PageSize *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX], castCppIn);

}

static void QPagedPaintDevice_PdfVersion_PythonToCpp_QPagedPaintDevice_PdfVersion(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QPagedPaintDevice::PdfVersion *>(cppOut) =
        static_cast<::QPagedPaintDevice::PdfVersion>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QPagedPaintDevice_PdfVersion_PythonToCpp_QPagedPaintDevice_PdfVersion_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PDFVERSION_IDX]))
        return QPagedPaintDevice_PdfVersion_PythonToCpp_QPagedPaintDevice_PdfVersion;
    return {};
}
static PyObject *QPagedPaintDevice_PdfVersion_CppToPython_QPagedPaintDevice_PdfVersion(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QPagedPaintDevice::PdfVersion *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PDFVERSION_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QPagedPaintDevice_PythonToCpp_QPagedPaintDevice_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QPagedPaintDevice_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QPagedPaintDevice_PythonToCpp_QPagedPaintDevice_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QPagedPaintDevice_TypeF())))
        return QPagedPaintDevice_PythonToCpp_QPagedPaintDevice_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QPagedPaintDevice_PTR_CppToPython_QPagedPaintDevice(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QPagedPaintDevice *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QPagedPaintDevice_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QPagedPaintDevice_SignatureStrings[] = {
    "PySide2.QtGui.QPagedPaintDevice(self)",
    "1:PySide2.QtGui.QPagedPaintDevice.devicePageLayout(self)->PySide2.QtGui.QPageLayout",
    "0:PySide2.QtGui.QPagedPaintDevice.devicePageLayout(self)->PySide2.QtGui.QPageLayout",
    "PySide2.QtGui.QPagedPaintDevice.margins(self)->PySide2.QtGui.QPagedPaintDevice.Margins",
    "PySide2.QtGui.QPagedPaintDevice.newPage(self)->bool",
    "PySide2.QtGui.QPagedPaintDevice.pageLayout(self)->PySide2.QtGui.QPageLayout",
    "PySide2.QtGui.QPagedPaintDevice.pageSize(self)->PySide2.QtGui.QPagedPaintDevice.PageSize",
    "PySide2.QtGui.QPagedPaintDevice.pageSizeMM(self)->PySide2.QtCore.QSizeF",
    "PySide2.QtGui.QPagedPaintDevice.setMargins(self,margins:PySide2.QtGui.QPagedPaintDevice.Margins)",
    "PySide2.QtGui.QPagedPaintDevice.setPageLayout(self,pageLayout:PySide2.QtGui.QPageLayout)->bool",
    "1:PySide2.QtGui.QPagedPaintDevice.setPageMargins(self,margins:PySide2.QtCore.QMarginsF)->bool",
    "0:PySide2.QtGui.QPagedPaintDevice.setPageMargins(self,margins:PySide2.QtCore.QMarginsF,units:PySide2.QtGui.QPageLayout.Unit)->bool",
    "PySide2.QtGui.QPagedPaintDevice.setPageOrientation(self,orientation:PySide2.QtGui.QPageLayout.Orientation)->bool",
    "1:PySide2.QtGui.QPagedPaintDevice.setPageSize(self,size:PySide2.QtGui.QPagedPaintDevice.PageSize)",
    "0:PySide2.QtGui.QPagedPaintDevice.setPageSize(self,pageSize:PySide2.QtGui.QPageSize)->bool",
    "PySide2.QtGui.QPagedPaintDevice.setPageSizeMM(self,size:PySide2.QtCore.QSizeF)",
    nullptr}; // Sentinel

void init_QPagedPaintDevice(PyObject *module)
{
    _Sbk_QPagedPaintDevice_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QPagedPaintDevice",
        "QPagedPaintDevice*",
        &Sbk_QPagedPaintDevice_spec,
        &Shiboken::callCppDestructor< ::QPagedPaintDevice >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QPagedPaintDevice_Type);
    InitSignatureStrings(pyType, QPagedPaintDevice_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QPagedPaintDevice_Type), Sbk_QPagedPaintDevice_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QPagedPaintDevice_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QPagedPaintDevice_TypeF(),
        QPagedPaintDevice_PythonToCpp_QPagedPaintDevice_PTR,
        is_QPagedPaintDevice_PythonToCpp_QPagedPaintDevice_PTR_Convertible,
        QPagedPaintDevice_PTR_CppToPython_QPagedPaintDevice);

    Shiboken::Conversions::registerConverterName(converter, "QPagedPaintDevice");
    Shiboken::Conversions::registerConverterName(converter, "QPagedPaintDevice*");
    Shiboken::Conversions::registerConverterName(converter, "QPagedPaintDevice&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QPagedPaintDevice).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QPagedPaintDeviceWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QPagedPaintDevice_TypeF(), &Sbk_QPagedPaintDevice_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'PageSize'.
    SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QPagedPaintDevice_TypeF(),
        "PageSize",
        "2:PySide2.QtGui.QPagedPaintDevice.PageSize",
        "QPagedPaintDevice::PageSize");
    if (!SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "A4", (long) QPagedPaintDevice::PageSize::A4))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "B5", (long) QPagedPaintDevice::PageSize::B5))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "Letter", (long) QPagedPaintDevice::PageSize::Letter))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "Legal", (long) QPagedPaintDevice::PageSize::Legal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "Executive", (long) QPagedPaintDevice::PageSize::Executive))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "A0", (long) QPagedPaintDevice::PageSize::A0))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "A1", (long) QPagedPaintDevice::PageSize::A1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "A2", (long) QPagedPaintDevice::PageSize::A2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "A3", (long) QPagedPaintDevice::PageSize::A3))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "A5", (long) QPagedPaintDevice::PageSize::A5))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "A6", (long) QPagedPaintDevice::PageSize::A6))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "A7", (long) QPagedPaintDevice::PageSize::A7))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "A8", (long) QPagedPaintDevice::PageSize::A8))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "A9", (long) QPagedPaintDevice::PageSize::A9))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "B0", (long) QPagedPaintDevice::PageSize::B0))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "B1", (long) QPagedPaintDevice::PageSize::B1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "B10", (long) QPagedPaintDevice::PageSize::B10))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "B2", (long) QPagedPaintDevice::PageSize::B2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "B3", (long) QPagedPaintDevice::PageSize::B3))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "B4", (long) QPagedPaintDevice::PageSize::B4))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "B6", (long) QPagedPaintDevice::PageSize::B6))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "B7", (long) QPagedPaintDevice::PageSize::B7))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "B8", (long) QPagedPaintDevice::PageSize::B8))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "B9", (long) QPagedPaintDevice::PageSize::B9))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "C5E", (long) QPagedPaintDevice::PageSize::C5E))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "Comm10E", (long) QPagedPaintDevice::PageSize::Comm10E))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "DLE", (long) QPagedPaintDevice::PageSize::DLE))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "Folio", (long) QPagedPaintDevice::PageSize::Folio))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "Ledger", (long) QPagedPaintDevice::PageSize::Ledger))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "Tabloid", (long) QPagedPaintDevice::PageSize::Tabloid))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "Custom", (long) QPagedPaintDevice::PageSize::Custom))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "A10", (long) QPagedPaintDevice::PageSize::A10))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "A3Extra", (long) QPagedPaintDevice::PageSize::A3Extra))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "A4Extra", (long) QPagedPaintDevice::PageSize::A4Extra))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "A4Plus", (long) QPagedPaintDevice::PageSize::A4Plus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "A4Small", (long) QPagedPaintDevice::PageSize::A4Small))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "A5Extra", (long) QPagedPaintDevice::PageSize::A5Extra))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "B5Extra", (long) QPagedPaintDevice::PageSize::B5Extra))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "JisB0", (long) QPagedPaintDevice::PageSize::JisB0))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "JisB1", (long) QPagedPaintDevice::PageSize::JisB1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "JisB2", (long) QPagedPaintDevice::PageSize::JisB2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "JisB3", (long) QPagedPaintDevice::PageSize::JisB3))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "JisB4", (long) QPagedPaintDevice::PageSize::JisB4))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "JisB5", (long) QPagedPaintDevice::PageSize::JisB5))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "JisB6", (long) QPagedPaintDevice::PageSize::JisB6))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "JisB7", (long) QPagedPaintDevice::PageSize::JisB7))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "JisB8", (long) QPagedPaintDevice::PageSize::JisB8))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "JisB9", (long) QPagedPaintDevice::PageSize::JisB9))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "JisB10", (long) QPagedPaintDevice::PageSize::JisB10))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "AnsiC", (long) QPagedPaintDevice::PageSize::AnsiC))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "AnsiD", (long) QPagedPaintDevice::PageSize::AnsiD))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "AnsiE", (long) QPagedPaintDevice::PageSize::AnsiE))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "LegalExtra", (long) QPagedPaintDevice::PageSize::LegalExtra))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "LetterExtra", (long) QPagedPaintDevice::PageSize::LetterExtra))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "LetterPlus", (long) QPagedPaintDevice::PageSize::LetterPlus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "LetterSmall", (long) QPagedPaintDevice::PageSize::LetterSmall))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "TabloidExtra", (long) QPagedPaintDevice::PageSize::TabloidExtra))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "ArchA", (long) QPagedPaintDevice::PageSize::ArchA))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "ArchB", (long) QPagedPaintDevice::PageSize::ArchB))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "ArchC", (long) QPagedPaintDevice::PageSize::ArchC))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "ArchD", (long) QPagedPaintDevice::PageSize::ArchD))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "ArchE", (long) QPagedPaintDevice::PageSize::ArchE))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "Imperial7x9", (long) QPagedPaintDevice::PageSize::Imperial7x9))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "Imperial8x10", (long) QPagedPaintDevice::PageSize::Imperial8x10))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "Imperial9x11", (long) QPagedPaintDevice::PageSize::Imperial9x11))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "Imperial9x12", (long) QPagedPaintDevice::PageSize::Imperial9x12))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "Imperial10x11", (long) QPagedPaintDevice::PageSize::Imperial10x11))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "Imperial10x13", (long) QPagedPaintDevice::PageSize::Imperial10x13))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "Imperial10x14", (long) QPagedPaintDevice::PageSize::Imperial10x14))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "Imperial12x11", (long) QPagedPaintDevice::PageSize::Imperial12x11))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "Imperial15x11", (long) QPagedPaintDevice::PageSize::Imperial15x11))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "ExecutiveStandard", (long) QPagedPaintDevice::PageSize::ExecutiveStandard))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "Note", (long) QPagedPaintDevice::PageSize::Note))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "Quarto", (long) QPagedPaintDevice::PageSize::Quarto))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "Statement", (long) QPagedPaintDevice::PageSize::Statement))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "SuperA", (long) QPagedPaintDevice::PageSize::SuperA))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "SuperB", (long) QPagedPaintDevice::PageSize::SuperB))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "Postcard", (long) QPagedPaintDevice::PageSize::Postcard))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "DoublePostcard", (long) QPagedPaintDevice::PageSize::DoublePostcard))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "Prc16K", (long) QPagedPaintDevice::PageSize::Prc16K))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "Prc32K", (long) QPagedPaintDevice::PageSize::Prc32K))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "Prc32KBig", (long) QPagedPaintDevice::PageSize::Prc32KBig))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "FanFoldUS", (long) QPagedPaintDevice::PageSize::FanFoldUS))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "FanFoldGerman", (long) QPagedPaintDevice::PageSize::FanFoldGerman))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "FanFoldGermanLegal", (long) QPagedPaintDevice::PageSize::FanFoldGermanLegal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "EnvelopeB4", (long) QPagedPaintDevice::PageSize::EnvelopeB4))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "EnvelopeB5", (long) QPagedPaintDevice::PageSize::EnvelopeB5))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "EnvelopeB6", (long) QPagedPaintDevice::PageSize::EnvelopeB6))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "EnvelopeC0", (long) QPagedPaintDevice::PageSize::EnvelopeC0))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "EnvelopeC1", (long) QPagedPaintDevice::PageSize::EnvelopeC1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "EnvelopeC2", (long) QPagedPaintDevice::PageSize::EnvelopeC2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "EnvelopeC3", (long) QPagedPaintDevice::PageSize::EnvelopeC3))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "EnvelopeC4", (long) QPagedPaintDevice::PageSize::EnvelopeC4))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "EnvelopeC6", (long) QPagedPaintDevice::PageSize::EnvelopeC6))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "EnvelopeC65", (long) QPagedPaintDevice::PageSize::EnvelopeC65))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "EnvelopeC7", (long) QPagedPaintDevice::PageSize::EnvelopeC7))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "Envelope9", (long) QPagedPaintDevice::PageSize::Envelope9))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "Envelope11", (long) QPagedPaintDevice::PageSize::Envelope11))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "Envelope12", (long) QPagedPaintDevice::PageSize::Envelope12))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "Envelope14", (long) QPagedPaintDevice::PageSize::Envelope14))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "EnvelopeMonarch", (long) QPagedPaintDevice::PageSize::EnvelopeMonarch))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "EnvelopePersonal", (long) QPagedPaintDevice::PageSize::EnvelopePersonal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "EnvelopeChou3", (long) QPagedPaintDevice::PageSize::EnvelopeChou3))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "EnvelopeChou4", (long) QPagedPaintDevice::PageSize::EnvelopeChou4))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "EnvelopeInvite", (long) QPagedPaintDevice::PageSize::EnvelopeInvite))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "EnvelopeItalian", (long) QPagedPaintDevice::PageSize::EnvelopeItalian))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "EnvelopeKaku2", (long) QPagedPaintDevice::PageSize::EnvelopeKaku2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "EnvelopeKaku3", (long) QPagedPaintDevice::PageSize::EnvelopeKaku3))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "EnvelopePrc1", (long) QPagedPaintDevice::PageSize::EnvelopePrc1))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "EnvelopePrc2", (long) QPagedPaintDevice::PageSize::EnvelopePrc2))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "EnvelopePrc3", (long) QPagedPaintDevice::PageSize::EnvelopePrc3))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "EnvelopePrc4", (long) QPagedPaintDevice::PageSize::EnvelopePrc4))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "EnvelopePrc5", (long) QPagedPaintDevice::PageSize::EnvelopePrc5))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "EnvelopePrc6", (long) QPagedPaintDevice::PageSize::EnvelopePrc6))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "EnvelopePrc7", (long) QPagedPaintDevice::PageSize::EnvelopePrc7))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "EnvelopePrc8", (long) QPagedPaintDevice::PageSize::EnvelopePrc8))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "EnvelopePrc9", (long) QPagedPaintDevice::PageSize::EnvelopePrc9))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "EnvelopePrc10", (long) QPagedPaintDevice::PageSize::EnvelopePrc10))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "EnvelopeYou4", (long) QPagedPaintDevice::PageSize::EnvelopeYou4))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "LastPageSize", (long) QPagedPaintDevice::PageSize::LastPageSize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "NPageSize", (long) QPagedPaintDevice::PageSize::NPageSize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "NPaperSize", (long) QPagedPaintDevice::PageSize::NPaperSize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "AnsiA", (long) QPagedPaintDevice::PageSize::AnsiA))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "AnsiB", (long) QPagedPaintDevice::PageSize::AnsiB))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "EnvelopeC5", (long) QPagedPaintDevice::PageSize::EnvelopeC5))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "EnvelopeDL", (long) QPagedPaintDevice::PageSize::EnvelopeDL))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "Envelope10", (long) QPagedPaintDevice::PageSize::Envelope10))
        return;
    // Register converter for enum 'QPagedPaintDevice::PageSize'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX],
            QPagedPaintDevice_PageSize_CppToPython_QPagedPaintDevice_PageSize);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QPagedPaintDevice_PageSize_PythonToCpp_QPagedPaintDevice_PageSize,
            is_QPagedPaintDevice_PageSize_PythonToCpp_QPagedPaintDevice_PageSize_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PAGESIZE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QPagedPaintDevice::PageSize");
        Shiboken::Conversions::registerConverterName(converter, "PageSize");
    }
    // End of 'PageSize' enum.

    // Initialization of enum 'PdfVersion'.
    SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PDFVERSION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QPagedPaintDevice_TypeF(),
        "PdfVersion",
        "2:PySide2.QtGui.QPagedPaintDevice.PdfVersion",
        "QPagedPaintDevice::PdfVersion");
    if (!SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PDFVERSION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PDFVERSION_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "PdfVersion_1_4", (long) QPagedPaintDevice::PdfVersion::PdfVersion_1_4))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PDFVERSION_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "PdfVersion_A1b", (long) QPagedPaintDevice::PdfVersion::PdfVersion_A1b))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PDFVERSION_IDX],
        Sbk_QPagedPaintDevice_TypeF(), "PdfVersion_1_6", (long) QPagedPaintDevice::PdfVersion::PdfVersion_1_6))
        return;
    // Register converter for enum 'QPagedPaintDevice::PdfVersion'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PDFVERSION_IDX],
            QPagedPaintDevice_PdfVersion_CppToPython_QPagedPaintDevice_PdfVersion);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QPagedPaintDevice_PdfVersion_PythonToCpp_QPagedPaintDevice_PdfVersion,
            is_QPagedPaintDevice_PdfVersion_PythonToCpp_QPagedPaintDevice_PdfVersion_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QPAGEDPAINTDEVICE_PDFVERSION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QPagedPaintDevice::PdfVersion");
        Shiboken::Conversions::registerConverterName(converter, "PdfVersion");
    }
    // End of 'PdfVersion' enum.

    qRegisterMetaType< ::QPagedPaintDevice::PageSize >("QPagedPaintDevice::PageSize");
    qRegisterMetaType< ::QPagedPaintDevice::PdfVersion >("QPagedPaintDevice::PdfVersion");
}
