/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qopenglvertexarrayobject_binder_wrapper.h"

// inner classes

// Extra includes
#include <QtGui/qopenglvertexarrayobject.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QOpenGLVertexArrayObject_Binder_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QOpenGLVertexArrayObject::Binder >()))
        return -1;

    ::QOpenGLVertexArrayObject::Binder *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLVertexArrayObject.Binder.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "Binder", 1, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: Binder::Binder(QOpenGLVertexArrayObject*)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLVERTEXARRAYOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // Binder(QOpenGLVertexArrayObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLVertexArrayObject_Binder_Init_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QOpenGLVertexArrayObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // Binder(QOpenGLVertexArrayObject*)
            cptr = new ::QOpenGLVertexArrayObject::Binder(cppArg0);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QOpenGLVertexArrayObject::Binder >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QOpenGLVertexArrayObject_Binder_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QOpenGLVertexArrayObject_Binder_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QOpenGLVertexArrayObject_BinderFunc_rebind(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLVertexArrayObject::Binder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLVERTEXARRAYOBJECT_BINDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLVertexArrayObject.Binder.rebind";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rebind()
            cppSelf->rebind();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QOpenGLVertexArrayObject_BinderFunc_release(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLVertexArrayObject::Binder *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLVERTEXARRAYOBJECT_BINDER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLVertexArrayObject.Binder.release";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // release()
            cppSelf->release();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}


static const char *Sbk_QOpenGLVertexArrayObject_Binder_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QOpenGLVertexArrayObject_Binder_methods[] = {
    {"rebind", reinterpret_cast<PyCFunction>(Sbk_QOpenGLVertexArrayObject_BinderFunc_rebind), METH_NOARGS},
    {"release", reinterpret_cast<PyCFunction>(Sbk_QOpenGLVertexArrayObject_BinderFunc_release), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QOpenGLVertexArrayObject_Binder_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QOpenGLVertexArrayObject_Binder_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QOpenGLVertexArrayObject_Binder_Type = nullptr;
static SbkObjectType *Sbk_QOpenGLVertexArrayObject_Binder_TypeF(void)
{
    return _Sbk_QOpenGLVertexArrayObject_Binder_Type;
}

static PyType_Slot Sbk_QOpenGLVertexArrayObject_Binder_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QOpenGLVertexArrayObject_Binder_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QOpenGLVertexArrayObject_Binder_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QOpenGLVertexArrayObject_Binder_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QOpenGLVertexArrayObject_Binder_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QOpenGLVertexArrayObject_Binder_spec = {
    "2:PySide2.QtGui.QOpenGLVertexArrayObject.Binder",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QOpenGLVertexArrayObject_Binder_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void Binder_PythonToCpp_Binder_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QOpenGLVertexArrayObject_Binder_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_Binder_PythonToCpp_Binder_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QOpenGLVertexArrayObject_Binder_TypeF())))
        return Binder_PythonToCpp_Binder_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *Binder_PTR_CppToPython_Binder(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QOpenGLVertexArrayObject::Binder *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QOpenGLVertexArrayObject_Binder_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QOpenGLVertexArrayObject_Binder_SignatureStrings[] = {
    "PySide2.QtGui.QOpenGLVertexArrayObject.Binder(self,v:PySide2.QtGui.QOpenGLVertexArrayObject)",
    "PySide2.QtGui.QOpenGLVertexArrayObject.Binder.rebind(self)",
    "PySide2.QtGui.QOpenGLVertexArrayObject.Binder.release(self)",
    nullptr}; // Sentinel

void init_QOpenGLVertexArrayObject_Binder(PyObject *enclosingClass)
{
    _Sbk_QOpenGLVertexArrayObject_Binder_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "Binder",
        "QOpenGLVertexArrayObject::Binder*",
        &Sbk_QOpenGLVertexArrayObject_Binder_spec,
        &Shiboken::callCppDestructor< ::QOpenGLVertexArrayObject::Binder >,
        0,
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QOpenGLVertexArrayObject_Binder_Type);
    InitSignatureStrings(pyType, QOpenGLVertexArrayObject_Binder_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QOpenGLVertexArrayObject_Binder_Type), Sbk_QOpenGLVertexArrayObject_Binder_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QOPENGLVERTEXARRAYOBJECT_BINDER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QOpenGLVertexArrayObject_Binder_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QOpenGLVertexArrayObject_Binder_TypeF(),
        Binder_PythonToCpp_Binder_PTR,
        is_Binder_PythonToCpp_Binder_PTR_Convertible,
        Binder_PTR_CppToPython_Binder);

    Shiboken::Conversions::registerConverterName(converter, "QOpenGLVertexArrayObject::Binder");
    Shiboken::Conversions::registerConverterName(converter, "QOpenGLVertexArrayObject::Binder*");
    Shiboken::Conversions::registerConverterName(converter, "QOpenGLVertexArrayObject::Binder&");
    Shiboken::Conversions::registerConverterName(converter, "Binder");
    Shiboken::Conversions::registerConverterName(converter, "Binder*");
    Shiboken::Conversions::registerConverterName(converter, "Binder&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QOpenGLVertexArrayObject::Binder).name());


}
