/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qopenglversionprofile_wrapper.h"

// inner classes

// Extra includes
#include <QPair>
#include <QtGui/qopenglcontext.h>
#include <QtGui/qsurfaceformat.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QOpenGLVersionProfile_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QOpenGLVersionProfile >()))
        return -1;

    ::QOpenGLVersionProfile *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLVersionProfile.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QOpenGLVersionProfile", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QOpenGLVersionProfile::QOpenGLVersionProfile()
    // 1: QOpenGLVersionProfile::QOpenGLVersionProfile(QOpenGLVersionProfile)
    // 2: QOpenGLVersionProfile::QOpenGLVersionProfile(QSurfaceFormat)
    if (numArgs == 0) {
        overloadId = 0; // QOpenGLVersionProfile()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QOpenGLVersionProfile(QSurfaceFormat)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLVERSIONPROFILE_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QOpenGLVersionProfile(QOpenGLVersionProfile)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLVersionProfile_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QOpenGLVersionProfile()
        {

            if (!PyErr_Occurred()) {
                // QOpenGLVersionProfile()
                cptr = new ::QOpenGLVersionProfile();
            }
            break;
        }
        case 1: // QOpenGLVersionProfile(const QOpenGLVersionProfile & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QOpenGLVersionProfile cppArg0_local;
            ::QOpenGLVersionProfile *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLVERSIONPROFILE_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QOpenGLVersionProfile(QOpenGLVersionProfile)
                cptr = new ::QOpenGLVersionProfile(*cppArg0);
            }
            break;
        }
        case 2: // QOpenGLVersionProfile(const QSurfaceFormat & format)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QSurfaceFormat cppArg0_local;
            ::QSurfaceFormat *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QOpenGLVersionProfile(QSurfaceFormat)
                cptr = new ::QOpenGLVersionProfile(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QOpenGLVersionProfile >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QOpenGLVersionProfile_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QOpenGLVersionProfile_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QOpenGLVersionProfileFunc_hasProfiles(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLVersionProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLVERSIONPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLVersionProfile.hasProfiles";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasProfiles()const
            bool cppResult = const_cast<const ::QOpenGLVersionProfile *>(cppSelf)->hasProfiles();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLVersionProfileFunc_isLegacyVersion(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLVersionProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLVERSIONPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLVersionProfile.isLegacyVersion";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isLegacyVersion()const
            bool cppResult = const_cast<const ::QOpenGLVersionProfile *>(cppSelf)->isLegacyVersion();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLVersionProfileFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLVersionProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLVERSIONPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLVersionProfile.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QOpenGLVersionProfile *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLVersionProfileFunc_profile(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLVersionProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLVERSIONPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLVersionProfile.profile";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // profile()const
            QSurfaceFormat::OpenGLContextProfile cppResult = const_cast<const ::QOpenGLVersionProfile *>(cppSelf)->profile();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_OPENGLCONTEXTPROFILE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLVersionProfileFunc_setProfile(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLVersionProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLVERSIONPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLVersionProfile.setProfile";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLVersionProfile::setProfile(QSurfaceFormat::OpenGLContextProfile)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QSURFACEFORMAT_OPENGLCONTEXTPROFILE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setProfile(QSurfaceFormat::OpenGLContextProfile)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLVersionProfileFunc_setProfile_TypeError;

    // Call function/method
    {
        ::QSurfaceFormat::OpenGLContextProfile cppArg0{QSurfaceFormat::NoProfile};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setProfile(QSurfaceFormat::OpenGLContextProfile)
            cppSelf->setProfile(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLVersionProfileFunc_setProfile_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLVersionProfileFunc_setVersion(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLVersionProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLVERSIONPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLVersionProfile.setVersion";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setVersion", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLVersionProfile::setVersion(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // setVersion(int,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLVersionProfileFunc_setVersion_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setVersion(int,int)
            cppSelf->setVersion(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLVersionProfileFunc_setVersion_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLVersionProfileFunc_version(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLVersionProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLVERSIONPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLVersionProfile.version";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // version()const
            QPair<int,int > cppResult = const_cast<const ::QOpenGLVersionProfile *>(cppSelf)->version();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtGuiTypeConverters[SBK_QTGUI_QPAIR_INT_INT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLVersionProfile___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QOpenGLVersionProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLVERSIONPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLVERSIONPROFILE_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QOpenGLVersionProfile_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QOpenGLVersionProfile_methods[] = {
    {"hasProfiles", reinterpret_cast<PyCFunction>(Sbk_QOpenGLVersionProfileFunc_hasProfiles), METH_NOARGS},
    {"isLegacyVersion", reinterpret_cast<PyCFunction>(Sbk_QOpenGLVersionProfileFunc_isLegacyVersion), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QOpenGLVersionProfileFunc_isValid), METH_NOARGS},
    {"profile", reinterpret_cast<PyCFunction>(Sbk_QOpenGLVersionProfileFunc_profile), METH_NOARGS},
    {"setProfile", reinterpret_cast<PyCFunction>(Sbk_QOpenGLVersionProfileFunc_setProfile), METH_O},
    {"setVersion", reinterpret_cast<PyCFunction>(Sbk_QOpenGLVersionProfileFunc_setVersion), METH_VARARGS},
    {"version", reinterpret_cast<PyCFunction>(Sbk_QOpenGLVersionProfileFunc_version), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QOpenGLVersionProfile___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

// Rich comparison
static PyObject * Sbk_QOpenGLVersionProfile_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QOpenGLVersionProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLVERSIONPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLVERSIONPROFILE_IDX]), (pyArg)))) {
                // operator!=(const QOpenGLVersionProfile & rhs)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QOpenGLVersionProfile cppArg0_local;
                ::QOpenGLVersionProfile *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLVERSIONPROFILE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLVERSIONPROFILE_IDX]), (pyArg)))) {
                // operator==(const QOpenGLVersionProfile & rhs)
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QOpenGLVersionProfile cppArg0_local;
                ::QOpenGLVersionProfile *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QOPENGLVERSIONPROFILE_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QOpenGLVersionProfile_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QOpenGLVersionProfile_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QOpenGLVersionProfile_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QOpenGLVersionProfile_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QOpenGLVersionProfile__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLVersionProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLVERSIONPROFILE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QOpenGLVersionProfile_Type = nullptr;
static SbkObjectType *Sbk_QOpenGLVersionProfile_TypeF(void)
{
    return _Sbk_QOpenGLVersionProfile_Type;
}

static PyType_Slot Sbk_QOpenGLVersionProfile_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QOpenGLVersionProfile__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QOpenGLVersionProfile_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QOpenGLVersionProfile_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QOpenGLVersionProfile_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QOpenGLVersionProfile_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QOpenGLVersionProfile_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QOpenGLVersionProfile_spec = {
    "2:PySide2.QtGui.QOpenGLVersionProfile",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QOpenGLVersionProfile_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QOpenGLVersionProfile_PythonToCpp_QOpenGLVersionProfile_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QOpenGLVersionProfile_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QOpenGLVersionProfile_PythonToCpp_QOpenGLVersionProfile_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QOpenGLVersionProfile_TypeF())))
        return QOpenGLVersionProfile_PythonToCpp_QOpenGLVersionProfile_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QOpenGLVersionProfile_PTR_CppToPython_QOpenGLVersionProfile(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QOpenGLVersionProfile *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QOpenGLVersionProfile_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QOpenGLVersionProfile_COPY_CppToPython_QOpenGLVersionProfile(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QOpenGLVersionProfile_TypeF(), new ::QOpenGLVersionProfile(*reinterpret_cast<const ::QOpenGLVersionProfile *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QOpenGLVersionProfile_PythonToCpp_QOpenGLVersionProfile_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QOpenGLVersionProfile *>(cppOut) = *reinterpret_cast< ::QOpenGLVersionProfile *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLVERSIONPROFILE_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QOpenGLVersionProfile_PythonToCpp_QOpenGLVersionProfile_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QOpenGLVersionProfile_TypeF())))
        return QOpenGLVersionProfile_PythonToCpp_QOpenGLVersionProfile_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QOpenGLVersionProfile_SignatureStrings[] = {
    "2:PySide2.QtGui.QOpenGLVersionProfile(self)",
    "1:PySide2.QtGui.QOpenGLVersionProfile(self,other:PySide2.QtGui.QOpenGLVersionProfile)",
    "0:PySide2.QtGui.QOpenGLVersionProfile(self,format:PySide2.QtGui.QSurfaceFormat)",
    "PySide2.QtGui.QOpenGLVersionProfile.hasProfiles(self)->bool",
    "PySide2.QtGui.QOpenGLVersionProfile.isLegacyVersion(self)->bool",
    "PySide2.QtGui.QOpenGLVersionProfile.isValid(self)->bool",
    "PySide2.QtGui.QOpenGLVersionProfile.profile(self)->PySide2.QtGui.QSurfaceFormat.OpenGLContextProfile",
    "PySide2.QtGui.QOpenGLVersionProfile.setProfile(self,profile:PySide2.QtGui.QSurfaceFormat.OpenGLContextProfile)",
    "PySide2.QtGui.QOpenGLVersionProfile.setVersion(self,majorVersion:int,minorVersion:int)",
    "PySide2.QtGui.QOpenGLVersionProfile.version(self)->QPair[int, int]",
    "PySide2.QtGui.QOpenGLVersionProfile.__copy__()",
    nullptr}; // Sentinel

void init_QOpenGLVersionProfile(PyObject *module)
{
    _Sbk_QOpenGLVersionProfile_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QOpenGLVersionProfile",
        "QOpenGLVersionProfile",
        &Sbk_QOpenGLVersionProfile_spec,
        &Shiboken::callCppDestructor< ::QOpenGLVersionProfile >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QOpenGLVersionProfile_Type);
    InitSignatureStrings(pyType, QOpenGLVersionProfile_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QOpenGLVersionProfile_Type), Sbk_QOpenGLVersionProfile_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QOPENGLVERSIONPROFILE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QOpenGLVersionProfile_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QOpenGLVersionProfile_TypeF(),
        QOpenGLVersionProfile_PythonToCpp_QOpenGLVersionProfile_PTR,
        is_QOpenGLVersionProfile_PythonToCpp_QOpenGLVersionProfile_PTR_Convertible,
        QOpenGLVersionProfile_PTR_CppToPython_QOpenGLVersionProfile,
        QOpenGLVersionProfile_COPY_CppToPython_QOpenGLVersionProfile);

    Shiboken::Conversions::registerConverterName(converter, "QOpenGLVersionProfile");
    Shiboken::Conversions::registerConverterName(converter, "QOpenGLVersionProfile*");
    Shiboken::Conversions::registerConverterName(converter, "QOpenGLVersionProfile&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QOpenGLVersionProfile).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QOpenGLVersionProfile_PythonToCpp_QOpenGLVersionProfile_COPY,
        is_QOpenGLVersionProfile_PythonToCpp_QOpenGLVersionProfile_COPY_Convertible);

    qRegisterMetaType< ::QOpenGLVersionProfile >("QOpenGLVersionProfile");
}
