/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtgui_python.h"

// main header
#include "qopengltextureblitter_wrapper.h"

// inner classes

// Extra includes
#include <QtGui/qgenericmatrix.h>
#include <QtGui/qmatrix4x4.h>
#include <qrect.h>
#include <qsize.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QOpenGLTextureBlitter_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QOpenGLTextureBlitter >()))
        return -1;

    ::QOpenGLTextureBlitter *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTextureBlitter.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QOpenGLTextureBlitter()
            cptr = new ::QOpenGLTextureBlitter();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QOpenGLTextureBlitter >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QOpenGLTextureBlitterFunc_bind(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTextureBlitter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTUREBLITTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTextureBlitter.bind";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QOpenGLTextureBlitterFunc_bind_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:bind", &(pyArgs[0])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLTextureBlitter::bind(uint)
    if (numArgs == 0) {
        overloadId = 0; // bind(uint)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))) {
        overloadId = 0; // bind(uint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTextureBlitterFunc_bind_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_target = Shiboken::String::createStaticString("target");
            if (PyDict_Contains(kwds, key_target)) {
                value = PyDict_GetItem(kwds, key_target);
                if (value && pyArgs[0]) {
                    errInfo = key_target;
                    Py_INCREF(errInfo);
                    goto Sbk_QOpenGLTextureBlitterFunc_bind_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0]))))
                        goto Sbk_QOpenGLTextureBlitterFunc_bind_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_target);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QOpenGLTextureBlitterFunc_bind_TypeError;
            }
        }
        unsigned int cppArg0 = GL_TEXTURE_2D;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // bind(uint)
            cppSelf->bind(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLTextureBlitterFunc_bind_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLTextureBlitterFunc_blit(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTextureBlitter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTUREBLITTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTextureBlitter.blit";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "blit", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QOpenGLTextureBlitter::blit(uint,QMatrix4x4,QOpenGLTextureBlitter::Origin)
    // 1: QOpenGLTextureBlitter::blit(uint,QMatrix4x4,QMatrix3x3)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<unsigned int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), (pyArgs[1])))) {
        if (numArgs == 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX3X3_IDX]), (pyArgs[2])))) {
            overloadId = 1; // blit(uint,QMatrix4x4,QMatrix3x3)
        } else if (numArgs == 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTUREBLITTER_ORIGIN_IDX])->converter, (pyArgs[2])))) {
            overloadId = 0; // blit(uint,QMatrix4x4,QOpenGLTextureBlitter::Origin)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTextureBlitterFunc_blit_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // blit(unsigned int texture, const QMatrix4x4 & targetTransform, QOpenGLTextureBlitter::Origin sourceOrigin)
        {
            unsigned int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QMatrix4x4 cppArg1_local;
            ::QMatrix4x4 *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            ::QOpenGLTextureBlitter::Origin cppArg2{QOpenGLTextureBlitter::OriginBottomLeft};
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // blit(uint,QMatrix4x4,QOpenGLTextureBlitter::Origin)
                cppSelf->blit(cppArg0, *cppArg1, cppArg2);
            }
            break;
        }
        case 1: // blit(unsigned int texture, const QMatrix4x4 & targetTransform, const QMatrix3x3 & sourceTransform)
        {
            unsigned int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QMatrix4x4 cppArg1_local;
            ::QMatrix4x4 *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!Shiboken::Object::isValid(pyArgs[2]))
                return {};
            ::QMatrix3x3 cppArg2_local;
            ::QMatrix3x3 *cppArg2 = &cppArg2_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX3X3_IDX]), pythonToCpp[2]))
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);


            if (!PyErr_Occurred()) {
                // blit(uint,QMatrix4x4,QMatrix3x3)
                cppSelf->blit(cppArg0, *cppArg1, *cppArg2);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLTextureBlitterFunc_blit_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLTextureBlitterFunc_create(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTextureBlitter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTUREBLITTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTextureBlitter.create";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // create()
            bool cppResult = cppSelf->create();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLTextureBlitterFunc_destroy(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTextureBlitter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTUREBLITTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTextureBlitter.destroy";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // destroy()
            cppSelf->destroy();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QOpenGLTextureBlitterFunc_isCreated(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTextureBlitter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTUREBLITTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTextureBlitter.isCreated";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isCreated()const
            bool cppResult = const_cast<const ::QOpenGLTextureBlitter *>(cppSelf)->isCreated();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLTextureBlitterFunc_release(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTextureBlitter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTUREBLITTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTextureBlitter.release";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // release()
            cppSelf->release();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QOpenGLTextureBlitterFunc_setOpacity(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTextureBlitter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTUREBLITTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTextureBlitter.setOpacity";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLTextureBlitter::setOpacity(float)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<float>(), (pyArg)))) {
        overloadId = 0; // setOpacity(float)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTextureBlitterFunc_setOpacity_TypeError;

    // Call function/method
    {
        float cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setOpacity(float)
            cppSelf->setOpacity(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLTextureBlitterFunc_setOpacity_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLTextureBlitterFunc_setRedBlueSwizzle(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTextureBlitter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTUREBLITTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTextureBlitter.setRedBlueSwizzle";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QOpenGLTextureBlitter::setRedBlueSwizzle(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setRedBlueSwizzle(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTextureBlitterFunc_setRedBlueSwizzle_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRedBlueSwizzle(bool)
            cppSelf->setRedBlueSwizzle(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QOpenGLTextureBlitterFunc_setRedBlueSwizzle_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLTextureBlitterFunc_sourceTransform(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTextureBlitter.sourceTransform";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "sourceTransform", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: static QOpenGLTextureBlitter::sourceTransform(QRectF,QSize,QOpenGLTextureBlitter::Origin)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTUREBLITTER_ORIGIN_IDX])->converter, (pyArgs[2])))) {
        overloadId = 0; // sourceTransform(QRectF,QSize,QOpenGLTextureBlitter::Origin)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTextureBlitterFunc_sourceTransform_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QRectF cppArg0_local;
        ::QRectF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QSize cppArg1_local;
        ::QSize *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        ::QOpenGLTextureBlitter::Origin cppArg2{QOpenGLTextureBlitter::OriginBottomLeft};
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // sourceTransform(QRectF,QSize,QOpenGLTextureBlitter::Origin)
            QMatrix3x3 cppResult = ::QOpenGLTextureBlitter::sourceTransform(*cppArg0, *cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX3X3_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLTextureBlitterFunc_sourceTransform_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QOpenGLTextureBlitterFunc_supportsExternalOESTarget(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QOpenGLTextureBlitter *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTUREBLITTER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTextureBlitter.supportsExternalOESTarget";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportsExternalOESTarget()const
            bool cppResult = const_cast<const ::QOpenGLTextureBlitter *>(cppSelf)->supportsExternalOESTarget();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QOpenGLTextureBlitterFunc_targetTransform(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtGui.QOpenGLTextureBlitter.targetTransform";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "targetTransform", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QOpenGLTextureBlitter::targetTransform(QRectF,QRect)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[1])))) {
        overloadId = 0; // targetTransform(QRectF,QRect)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QOpenGLTextureBlitterFunc_targetTransform_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QRectF cppArg0_local;
        ::QRectF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QRect cppArg1_local;
        ::QRect *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // targetTransform(QRectF,QRect)
            QMatrix4x4 cppResult = ::QOpenGLTextureBlitter::targetTransform(*cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX4X4_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QOpenGLTextureBlitterFunc_targetTransform_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QOpenGLTextureBlitter_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QOpenGLTextureBlitter_methods[] = {
    {"bind", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureBlitterFunc_bind), METH_VARARGS|METH_KEYWORDS},
    {"blit", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureBlitterFunc_blit), METH_VARARGS},
    {"create", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureBlitterFunc_create), METH_NOARGS},
    {"destroy", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureBlitterFunc_destroy), METH_NOARGS},
    {"isCreated", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureBlitterFunc_isCreated), METH_NOARGS},
    {"release", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureBlitterFunc_release), METH_NOARGS},
    {"setOpacity", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureBlitterFunc_setOpacity), METH_O},
    {"setRedBlueSwizzle", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureBlitterFunc_setRedBlueSwizzle), METH_O},
    {"sourceTransform", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureBlitterFunc_sourceTransform), METH_VARARGS|METH_STATIC},
    {"supportsExternalOESTarget", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureBlitterFunc_supportsExternalOESTarget), METH_NOARGS},
    {"targetTransform", reinterpret_cast<PyCFunction>(Sbk_QOpenGLTextureBlitterFunc_targetTransform), METH_VARARGS|METH_STATIC},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QOpenGLTextureBlitter_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QOpenGLTextureBlitter_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QOpenGLTextureBlitter_Type = nullptr;
static SbkObjectType *Sbk_QOpenGLTextureBlitter_TypeF(void)
{
    return _Sbk_QOpenGLTextureBlitter_Type;
}

static PyType_Slot Sbk_QOpenGLTextureBlitter_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QOpenGLTextureBlitter_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QOpenGLTextureBlitter_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QOpenGLTextureBlitter_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QOpenGLTextureBlitter_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QOpenGLTextureBlitter_spec = {
    "2:PySide2.QtGui.QOpenGLTextureBlitter",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QOpenGLTextureBlitter_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QOpenGLTextureBlitter_Origin_PythonToCpp_QOpenGLTextureBlitter_Origin(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QOpenGLTextureBlitter::Origin *>(cppOut) =
        static_cast<::QOpenGLTextureBlitter::Origin>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QOpenGLTextureBlitter_Origin_PythonToCpp_QOpenGLTextureBlitter_Origin_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTUREBLITTER_ORIGIN_IDX]))
        return QOpenGLTextureBlitter_Origin_PythonToCpp_QOpenGLTextureBlitter_Origin;
    return {};
}
static PyObject *QOpenGLTextureBlitter_Origin_CppToPython_QOpenGLTextureBlitter_Origin(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QOpenGLTextureBlitter::Origin *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTUREBLITTER_ORIGIN_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QOpenGLTextureBlitter_PythonToCpp_QOpenGLTextureBlitter_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QOpenGLTextureBlitter_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QOpenGLTextureBlitter_PythonToCpp_QOpenGLTextureBlitter_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QOpenGLTextureBlitter_TypeF())))
        return QOpenGLTextureBlitter_PythonToCpp_QOpenGLTextureBlitter_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QOpenGLTextureBlitter_PTR_CppToPython_QOpenGLTextureBlitter(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QOpenGLTextureBlitter *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QOpenGLTextureBlitter_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QOpenGLTextureBlitter_SignatureStrings[] = {
    "PySide2.QtGui.QOpenGLTextureBlitter(self)",
    "PySide2.QtGui.QOpenGLTextureBlitter.bind(self,target:unsigned int=GL_TEXTURE_2D)",
    "1:PySide2.QtGui.QOpenGLTextureBlitter.blit(self,texture:unsigned int,targetTransform:PySide2.QtGui.QMatrix4x4,sourceOrigin:PySide2.QtGui.QOpenGLTextureBlitter.Origin)",
    "0:PySide2.QtGui.QOpenGLTextureBlitter.blit(self,texture:unsigned int,targetTransform:PySide2.QtGui.QMatrix4x4,sourceTransform:PySide2.QtGui.QMatrix3x3)",
    "PySide2.QtGui.QOpenGLTextureBlitter.create(self)->bool",
    "PySide2.QtGui.QOpenGLTextureBlitter.destroy(self)",
    "PySide2.QtGui.QOpenGLTextureBlitter.isCreated(self)->bool",
    "PySide2.QtGui.QOpenGLTextureBlitter.release(self)",
    "PySide2.QtGui.QOpenGLTextureBlitter.setOpacity(self,opacity:float)",
    "PySide2.QtGui.QOpenGLTextureBlitter.setRedBlueSwizzle(self,swizzle:bool)",
    "PySide2.QtGui.QOpenGLTextureBlitter.sourceTransform(subTexture:PySide2.QtCore.QRectF,textureSize:PySide2.QtCore.QSize,origin:PySide2.QtGui.QOpenGLTextureBlitter.Origin)->PySide2.QtGui.QMatrix3x3",
    "PySide2.QtGui.QOpenGLTextureBlitter.supportsExternalOESTarget(self)->bool",
    "PySide2.QtGui.QOpenGLTextureBlitter.targetTransform(target:PySide2.QtCore.QRectF,viewport:PySide2.QtCore.QRect)->PySide2.QtGui.QMatrix4x4",
    nullptr}; // Sentinel

void init_QOpenGLTextureBlitter(PyObject *module)
{
    _Sbk_QOpenGLTextureBlitter_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QOpenGLTextureBlitter",
        "QOpenGLTextureBlitter*",
        &Sbk_QOpenGLTextureBlitter_spec,
        &Shiboken::callCppDestructor< ::QOpenGLTextureBlitter >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QOpenGLTextureBlitter_Type);
    InitSignatureStrings(pyType, QOpenGLTextureBlitter_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QOpenGLTextureBlitter_Type), Sbk_QOpenGLTextureBlitter_PropertyStrings);
    SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTUREBLITTER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QOpenGLTextureBlitter_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QOpenGLTextureBlitter_TypeF(),
        QOpenGLTextureBlitter_PythonToCpp_QOpenGLTextureBlitter_PTR,
        is_QOpenGLTextureBlitter_PythonToCpp_QOpenGLTextureBlitter_PTR_Convertible,
        QOpenGLTextureBlitter_PTR_CppToPython_QOpenGLTextureBlitter);

    Shiboken::Conversions::registerConverterName(converter, "QOpenGLTextureBlitter");
    Shiboken::Conversions::registerConverterName(converter, "QOpenGLTextureBlitter*");
    Shiboken::Conversions::registerConverterName(converter, "QOpenGLTextureBlitter&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QOpenGLTextureBlitter).name());


    // Initialization of enums.

    // Initialization of enum 'Origin'.
    SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTUREBLITTER_ORIGIN_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QOpenGLTextureBlitter_TypeF(),
        "Origin",
        "2:PySide2.QtGui.QOpenGLTextureBlitter.Origin",
        "QOpenGLTextureBlitter::Origin");
    if (!SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTUREBLITTER_ORIGIN_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTUREBLITTER_ORIGIN_IDX],
        Sbk_QOpenGLTextureBlitter_TypeF(), "OriginBottomLeft", (long) QOpenGLTextureBlitter::Origin::OriginBottomLeft))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTUREBLITTER_ORIGIN_IDX],
        Sbk_QOpenGLTextureBlitter_TypeF(), "OriginTopLeft", (long) QOpenGLTextureBlitter::Origin::OriginTopLeft))
        return;
    // Register converter for enum 'QOpenGLTextureBlitter::Origin'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTUREBLITTER_ORIGIN_IDX],
            QOpenGLTextureBlitter_Origin_CppToPython_QOpenGLTextureBlitter_Origin);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QOpenGLTextureBlitter_Origin_PythonToCpp_QOpenGLTextureBlitter_Origin,
            is_QOpenGLTextureBlitter_Origin_PythonToCpp_QOpenGLTextureBlitter_Origin_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtGuiTypes[SBK_QOPENGLTEXTUREBLITTER_ORIGIN_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QOpenGLTextureBlitter::Origin");
        Shiboken::Conversions::registerConverterName(converter, "Origin");
    }
    // End of 'Origin' enum.

    qRegisterMetaType< ::QOpenGLTextureBlitter::Origin >("QOpenGLTextureBlitter::Origin");
}
